/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 13)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm013 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 12
				(send gEgo:
					posn(296 167)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (water:init()
         setCycle(Fwd)
         cycleSpeed(10))
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
      (var dyingScript)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(12))
            )
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(10))
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gEgo:hide())
                   (drowningCurt:init() setCycle(End) cycleSpeed(5))
                   = dyingScript ScriptID(DYING_SCRIPT)
                   (send dyingScript:
                     caller(3)
                     register("It's deeper than it looks!")
                   )
                   (send gGame:setScript(dyingScript))
            )
            
    )
    (method (handleEvent pEvent)

        (super:handleEvent(pEvent))
        (if(Said('get/ball'))
           Print("Of course. But how?")
        )
        (if(Said('look>'))
               (if(Said('<in/hole'))
                  (if(send gEgo:inRect(24 94 73 144))
                     Print("The hole is empty")
                  )(else
                     Print("Get closer.")
                   )
               )
        )
        (if(Said('look/hole'))
           (if(send gEgo:inRect(24 94 73 144))
                     Print("The hole is empty")
                  )(else
                     Print("Get closer.")
                   )
        )
        (if(Said('look/water'))
           Print("There's something in the water!")
        )
        (if(Said('look/waterfall'))
           Print("very nice.")
        )
        (if(Said('look/around'))
           Print("Hole 18: A small bridge, with a water hazard. Par 2. I recommend a putter.")
        )
        (if(Said('use/putter,club'))
                Print("How?")
            )
            (if(Said('golf'))
                Print("No time.")
            )
        (if(Said('put,use/club,putter/water'))
         (if(not(send gEgo:has(INV_BALL)))
           (if(send gEgo:inRect(98 136 208 189))
              (if(send gEgo:has(INV_TAPECLUB))
                 Print("You put the club in the water. . .")
                 Print(". . . and draw out. . .")
                 Print(". . . an ORANGE GOLF BALL!")
                 (send gGame:changeScore(10))
                 (send gEgo:get(INV_BALL))
              )(else
                 Print("You just manage to move the item around a little.")
               )
           )(else
               Print("You're not close enough.")
            )
         )(else
            Print("You have the ball already!")
          )
        )
    )
)
/******************************************************************************/
(instance water of Prop
 (properties
     y 26
     x 126
     view 506
 )
)
(instance drowningCurt of Act
 (properties
     y 161
     x 145
     view 516
 )
)

