/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 14)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm014 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
            (send gGame:setSpeed(5))
		(super:init())
		(self:setScript(RoomScript))
          (switch(gPreviousRoomNumber)
			(case 12
				(send gEgo:
					posn(296 167)
					loop(3)
				)
			)
		)



		SetUpEgo()
		(send gEgo:init()
         hide()
        )
        (curt:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState newState)
    (var dyingScript)
        = state newState
        (switch (state)
                (case 0
                 (curt:setMotion(MoveTo 25 120 RoomScript))
                )
                (case 1
                 (curt:setMotion(MoveTo 45 180 RoomScript))
                )

                (case 2
                 ShakeScreen (8)
                 = cycles 1
                )
                (case 3

                 (curt:hide())
                 (blood:init()
                  setCycle(End)
                  cycleSpeed(10)
                 )
                 =cycles 30
                )
                (case 4
                 (= dyingScript ScriptID(DYING_SCRIPT)
                  (send dyingScript:
                   caller(3)
                   register("Even worse than a seven-ten split!")
                  )
                  (send gGame:setScript(dyingScript))
                 )
                )
        )
    )
)
/******************************************************************************/
(instance curt of Act
 (properties
     y 135
     x 0
     view 200
 )
)
(instance blood of Act
 (properties
     y 180
     x 45
     view 201
 )
)
