/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 15)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm015 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

        (switch(gPreviousRoomNumber)
			(case 2
				(send gEgo:
					posn(295 125)
					loop(1)
				)
            )
            (case 16
				(send gEgo:
					posn(159 25)
					loop(2)
				)
            )
            (case 21
				(send gEgo:
					posn(23 125)
					loop(0)
				)
            )
        )
		SetUpEgo()
		(send gEgo:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)

            (if(== (send gEgo:onControl()) ctlGREY)
                   (send gRoom:newRoom(2))
            )
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(16))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(21))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around'))
               Print("The road continues, while a driveway leads to a nice house surrounded by a white fence.")
            )
            (if(Said('look/driveway,building'))
               Print("A driveway leads north, to home.")
            )
            (if(Said('look/road'))
               Print("It goes east and west, with a driveway heading north.")
            )
            (if(Said('look/fence'))
               Print("It's sturdy enough, but not important to your mission.")
            )
            (if(Said('look/grass'))
               Print("I think it's greener on the other side of the fence.")
            )
    )
)
/******************************************************************************/
