/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 16)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm016 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

       (switch(gPreviousRoomNumber)
		 	(case 15
				(send gEgo:
					posn(146 163)
					loop(3)
				)
            )
            (case 20
				(send gEgo:
					posn(30 70)
					loop(2)
				)
            )
            (case 17
				(send gEgo:
					posn(230 100)
					loop(2)
				)
            )
       )

		SetUpEgo()
		(send gEgo:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)

            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(15))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(20))
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gRoom:newRoom(17))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/porch'))
               (if(send gEgo:inRect(175 96 283 100))
                    Print("A small hand shovel rests on the porch")
               )(else
                    Print("You can't see the porch well from here.")
                )
            )
            (if(Said('look/around'))
               Print("Home sweet home. The driveway leads up to a porch, where the door is always open for you.")
            )
            (if(Said('look/home,building'))
               Print("be it ever so humble.")
            )
            (if(Said('look/driveway,road'))
               Print("It leads back to the main road.")
            )
            (if(Said('look/shovel'))
               Print("It's around here somewhere.")
            )
            (if(Said('look/door'))
               Print("It's open for you.")
            )
            (if(Said('look/window'))
               Print("You can't see inside from here.")
            )
            (if(Said('look/steps,stairs'))
               Print("Some stairs lead to the porch, while some stone steps lead off to the right (Where you can't go, incidentally).")
            )
            (if(Said('take/shovel'))
             (if(send gEgo:has(INV_SHOVEL))
                      Print("You already have it!")
                )(else
                   (if(send gEgo:inRect(175 96 195 100))
                    Print("You've got a hand shovel!")
                    (send gGame:changeScore(3))
                    (send gEgo:get(INV_SHOVEL))

                    )(else
                      Print("You're not close enough!")
                      )
                  )
         )
    )
)
/******************************************************************************/
