/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 17)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm017 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 16
				(send gEgo:
					posn(276 177)
					loop(3)
				)
			)
            (case 18
				(send gEgo:
					posn(42 100)
					loop(0)
				)
			)
            (case 175
				(send gEgo:
					posn(44 112)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gRoom:newRoom(16))
            )
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(18))
            )
    )
    (method (handleEvent pEvent)
    (super:handleEvent(pEvent))
            (if(Said('look,open/cupboard'))
               (if(send gEgo:inRect(31 85 52 129))
                  (send gGame:changeScore(2))
                  (send gRoom:newRoom(175))
               )(else
                 Print("This isn't the cupboard you're interested in.")
                )
            )
            (if(Said('look/around'))
               Print("You are in your kitchen. Cupboards are all around you. There is also an oven, a fridge, etc. A hall leads off to the left, while the exit is in the lower right corner of the room.")
            )
            (if(Said('look/home,building'))
               Print("be it ever so humble.")
            )
            (if(Said('look/window'))
               Print("The neighbor kid is running around in the back yard.")
            )
            (if(Said('look/oven,stove'))
               Print("There's nothing of interest in the stove.")
            )
            (if(Said('look,open/fridge,sink'))
               Print("It's just scenery.")
            )
            (if(Said('look/exit'))
               Print("It lead's to the front yard.")
            )
            (if(Said('look/hall'))
               Print("It leads to the laundry room.")
            )
    )
)
/******************************************************************************/
