/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 20)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "wander")
(use "obj")
/******************************************************************************/
(instance public rm020 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)

	(method (init)

       (= kidtrapped Random(1 3))
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            (case 16
				(send gEgo:
					posn(61 168)
					loop(3)
				)
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (if(< holedug 4)
           (kid:init()
                 posn(13 32)
                 setCycle(Walk)
                 setMotion(Wander)
           )
        )
        //(Print(kidtrapped))
        (if (== holedug 1)
            (hole:init())
        )
        (if (== holedug 2)
            (if (== kidtrapped 3)
                (kid:hide())
                (kidinhole:init())
                (= holedug 3)
            )
        )
        (if (== holedug 3)
            (kid:hide())
            (kidinhole:init())
            (Print("HELP! HELP"))
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
    (var dyingScript)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(16))
            )
            (if(send gEgo:inRect(69 50 115 80))
               (if(== holedug 2)
                  (send gEgo:hide())
                  (curtinhole:init())

                  = dyingScript ScriptID(DYING_SCRIPT)
                  (send dyingScript:
                   caller(510)
                   register("Caught in your own web!")
                  )
                  (send gGame:setScript(dyingScript))
               )
            )
    )

    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if(Said('look/around'))
            Print("You are in the backyard, where the neighbor kid likes to hang out. There's a big pile of leaves as well.")
        )
        (if(Said('look/house'))
           Print("be it ever so humble.")
        )
        (if(Said('look/leaves'))
           Print("There's nothing unusual in the pile of leaves.")
        )
        (if(Said('look/neighbor,kid'))
           Print("He's a spaz.")
        )
        (if(Said('look/court'))
           Print("If you had a basketball and some time, you could hang out here.")
        )
        (if(Said('dig'))
           (if(send gEgo:inRect(76 61 131 91))
                 (if(send gEgo:has(INV_SHOVEL))
                          (if( == holedug 0)
                                    Print ("ok.")
                                    (send gGame:changeScore(2))
                                    (hole:init())
                                    = holedug 1
                                )(else
                                    Print ("One hole is enough!")
                                 )
                    )(else
                          Print ("you don't have time to dig with your hands.")
                      )
             )(else
                 Print("not here!")
              )
           )
           (if(Said('cover/hole'))
              (if (<> holedug 1)
                  Print("What hole")
              )(else
                 (if(send gEgo:inRect(76 61 131 91))
                    Print ("very clever! You cover the hole with leaves and dirt,then scuttle to safety")
                    (hole:hide())
                    (= holedug 2)
                    (send gGame:changeScore(4))
                    (send gEgo:posn(213 129))
                 )(else
                      Print("get closer to the hole.")
                  )
               )
           )
           (if(Said('free,release,help/kid,boy'))
               (if (== holedug 3)
                   (Print("The kid replies \"Thanks! Have my scooter!\", then runs back to whence he came."))
                   (send gEgo:get(INV_SCOOTER))
                   (send gGame:changeScore(5))
                   (kidinhole:hide())
                   (= holedug 4)
                   (kid:init())
               )(else
                 Print("Huh?")
                )
            )
          (if(Said('talk/kid,neighbor'))
             ("\"BLAH BLAH GOT A NEW SCOOTER I AM TALKING LOUD.\"")
          )
          (if(Said('ask [<for,about]/scooter'))
            Print("It goes really fast." #title "the kid says")
          )
          (if(Said('ask [<for,about]/anyword'))
            Print("I don't know, but once I got sting by a bee." #title "the kid says")
          )
          (if(Said('get/leaves'))
             Print("nah.")
          )
     )
)
/******************************************************************************/
(instance kid of Act
 (properties
     y 60
     x 60
     view 9
 )
)
(instance hole of Prop
 (properties
     y 75
     x 100
     view 507
 )
)
(instance kidinhole of Prop
 (properties
     y 75
     x 100
     view 508
 )
)
(instance curtinhole of Prop
 (properties
     y 75
     x 100
     view 510
 )
)
