/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 21)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm021 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            (case 15
				(send gEgo:
					posn(295 125)
					loop(1)
				)
            )
            (case 28
                (= desertcount 0)
				(send gEgo:
					posn(30 125)
					loop(0)
				)
            )
            (case 22
				(send gEgo:
					posn(92 20)
					loop(2)
				)
            )
            (case 26
				(send gEgo:
					posn(207 175)
					loop(3)
				)
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (= ridingscooter FALSE)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(15))
            )
            (if(== (send gEgo:onControl()) ctlGREY)
                   (++desertcount)
                   (send gRoom:newRoom(28))
            )
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(22))
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gRoom:newRoom(26))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('read,look/sign'))
               (if(send gEgo:inRect(0 45 37 94))
                  Print("WARNING! NO WATER FOR MILES! DO NOT CROSS WITHOUT PROPER PROVISIONS!")
                )(else
                  Print("You are not close enough.")
               )
            )
            (if(Said('look/around'))
               Print("The road continues, going in all directions. A sign is posted.")
            )

            (if(Said('look/road'))
               Print("It gives you lots of options.")
            )
    )
    
)
/******************************************************************************/
