/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 22)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm022 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 21
				(send gEgo:
					posn(20 173)
					loop(3)
				)
			)
            (case 24
				(send gEgo:
					posn(15 25)
					loop(2)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (roy:init ())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(21))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(24))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around'))
               Print("You are passing by the home of Roy, your current employer. By a stroke of bad luck, Roy is in the front yard")
            )
            (if(Said('look/house,building'))
               Print("It's Roy's house. It looks like this game's artist forgot to give him windows.")
            )
            (if(Said('look/road'))
               Print("It goes north and south.")
            )
            (if(Said('look/mailbox'))
               Print("There's nothing in the mailbox.")
            )
            (if(Said('look/garage'))
               Print("There's nothing in the garage.")
            )
            (if(Said('look/door'))
               Print("Roy didn't invite you in.")
            )
            (if(Said('look/roy'))
               Print("The years have been kind to Roy.")
            )
            (if(Said('talk'))
               Print("Well hey Chief! If you see Boey, tell him we need to talk.")
            )
            (if(Said('ask [<for,about]/check'))
               (if((send gEgo:has(INV_TIMECARD)) or (== usedtimecard TRUE))
                   Print("Do more work, and I'll give you another check." #title "Roy says")
               )(else
                  Print("You need to fill out a timecard. I gave them to Boey" #title "Roy says")
                )
            )
            (if(Said('ask [<for,about]/timecard,time,card'))
                Print("I gave all the ones I had to Boey." #title "Roy says")

            )
            (if(Said('ask[<for,about]/boey'))
               Print("I think he's in the shed.")
            )
            (if(Said('ask[<for,about]/shed'))
               Print("It look ok.")
            )
            (if(Said('ask[<for,about]/boey'))
               Print("I think he's in the shed.")
            )
            (if(Said('ask[<for,about]/anyword'))
               Print("You'll need to ask someone else about that.")
            )
            (if(Said('give/timecard,time,card'))
                (if(send gEgo:has(INV_TIMECARD))
                   (if(== usedtimecard FALSE)
                      Print ("Hey! Nice work this week! Here's your check." #title "Roy says")
                      (send gGame:changeScore(4))
                      (send gEgo:get(INV_CHECK))
                      (send gEgo:put(INV_TIMECARD))
                      (= usedtimecard TRUE)
                   )(else
                       Print ("You are out of timecards.")
                    )
                )(else
                   Print ("you don't have one.")
                 )
            )
            (if(Said('knock'))
               Print("Roy's out front.")
            )
    )
)
/******************************************************************************/
(instance roy of Act
 (properties
     y 115
     x 86
     view 10
 )
)
