/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 25)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm025 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 24
				(send gEgo:
					posn(132 175)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (cashier:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(24))
            )
    )
    (method (handleEvent pEvent)
         (super:handleEvent(pEvent))
         (if(Said('look/around'))
               Print("You are in holiday oil. Huh. It seems inventory has shrunk. Either the stocker, or the programmer is really lazy.")
            )
            (if(Said('look/soda'))
               Print("It offers a variety of products to destroy the stomach lining.")
            )
            (if(Said('look/cashier,man'))
               Print("Typical convenience store worker.")
            )
            (if(Said('look/cups'))
               Print("They're stacked on the counter.")
            )
            (if(Said('look/counter'))
               Print("There are cups and not much else.")
            )
            (if(Said('look/door'))
               Print("It leads back to the road!")
            )
            (if(Said('get,buy/drink,cup'))
             (if(send gEgo:inRect(147 85 227 100))
                (if(send gEgo:has(INV_DOLLAR))
                    (if(send gEgo:has(INV_PENNY))
                        Print("\"All right. Here's your cup. Have a good day.\"" #title "the cashier responds")
                        Print("\"Thanks. You too.\"" #title "You reply")
                        Print("\"Thanks.\"" #title "the cashier replies")
                        (send gGame:changeScore(3))
                        (= usedcheck TRUE)
                        (send gEgo:put(INV_DOLLAR))
                        (send gEgo:put(INV_PENNY))
                        (send gEgo:get(INV_CUP))
                    )(else
                       Print("\"You're six cents short.\"" #title "the cashier replies")
                     )
                )(else
                    Print("You need some money, cap'n." #title "the cashier responds")
                 )
             )(else
                 (if(send gEgo:inRect(30 90 71 129))
                      (if(send gEgo:has(INV_CUP))
                          Print("You fill your cup with Coke.")
                          (send gGame:changeScore(2))
                          (= cupfull TRUE)
                      )(else
                          Print("You need a cup first. See the cashier.")
                       )
                 )(else
                  Print("You're not close enough!")
                  )
              )
            )
            (if(Said('get,buy/mug'))
               Print("You'll never afford it.")
            )
            (if(Said('go [<behind]/counter'))
               Print("nah.")
            )
            (if(Said('ask [<for,about]/holiday'))
               Print("It pays the bills." #title "the worker says")
            )
            (if(Said('ask [<for,about]/job,application'))
               Print("We're not hiring right now." #title "the worker says")
            )
            (if(Said('ask [<for,about]/sunglasses'))
               Print("No." #title "the clerk says")
            )
            (if(Said('ask [<for,about]/mug'))
               Print("It's pretty nice." #title "the clerk says")
            )
            (if(Said('ask [<for,about]/drink,cup'))
               Print("It's a dollar six." #title "the worker says")
            )
    )
)
/******************************************************************************/
(instance cashier of Act
 (properties
     y 51
     x 186
     view 11
 )
)
