/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 27)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "wander")
/******************************************************************************/
(instance public rm027 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 265
				(send gEgo:
					posn(299 166)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init()
         view(22))
        (light1:init()
               setCycle(Fwd)
               cycleSpeed(3))
        (light2:init()
               setCycle(Fwd)
               cycleSpeed(3))
        (kid1:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (kid2:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (kid3:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (kid4:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (kid5:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (kid6:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl1:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl2:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl3:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl4:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl5:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (girl6:init()
              setCycle(Walk)
              setMotion(Wander)
        )
        (if(not(send gEgo:has (INV_LADDER)))
           (if(not(== usedladder TRUE))
               (ladder:init()
                cycleSpeed(1))))
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(265))
            )
            (if(== (send gEgo:onControl()) 2)
                   (send gEgo:posn(203 40)
                              loop(1))
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gEgo:posn(257 72)
                              loop(2))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around,gym'))
               Print("You are inside the church dance, which is almost at capacity.")
            )
            (if(Said('look/lights'))
               Print("They are blaring away.")
            )
            (if(Said('look/boy,girl,kids'))
               Print("Punk kids.")
            )
            (if(Said('dance'))
               Print("no time!")
            )

            (if(Said('look/exit'))
               Print("It exits.")
            )

            (if(Said('look/door'))
               Print("It leads to the stage.")
            )
            (if(Said('look/stage'))
               Print("There's not much up there.")
            )

            (if(Said('look/ladder'))
               Print("It's hanging behind the stage.")
            )
            (if(Said('look [<under]/stage'))
               Print("There is some storage that is unimportant.")
            )
            (if(Said('use/ladder'))
               Print("Not now.")
            )

            (if(Said('take/ladder'))

              (if(send gEgo:has(INV_LADDER))
                       Print("You already have it!")
              )(else
                    (if(send gEgo:inRect(67 36 199 43))
                      Print("You've got a ladder!")
                      (send gGame:changeScore(4))
                      (send gEgo:get(INV_LADDER))
                      (ladder:hide())
                    )(else
                      Print("You're not close enough!")
                      )
                )

            )
            (if(Said('open/door'))
               Print("If it's not already open, it's none of your business.")
            )
            (if(Said('talk'))
               Print("GREAT DANCE, HUH?")
            )
            (if(Said('ask [<for,about]/dance'))
                Print("Maybe later!")
            )
            (if(Said('ask [<for,about]/stage,ladder'))
               Print("I don't know what the ladder's for.")
            )
            (if(Said('ask [<for,about]/anyword'))
               Print("dance now, talk later")
            )
    )
)
/******************************************************************************/
(instance light1 of Prop
 (properties
     y 44
     x 82
     view 500
 )
)
(instance light2 of Prop
 (properties
     y 44
     x 203
     view 500
 )
)
(instance kid1 of Act
 (properties
     y 292
     x 135
     view 15
 )
)
(instance kid2 of Act
 (properties
     y 262
     x 105
     view 15
 )
)
(instance kid3 of Act
 (properties
     y 105
     x 232
     view 15
 )
)
(instance kid4 of Act
 (properties
     y 90
     x 167
     view 15
 )
)
(instance kid5 of Act
 (properties
     y 90
     x 129
     view 15
 )
)
(instance kid6 of Act
 (properties
     y 133
     x 89
     view 15
 )
)
(instance girl1 of Act
 (properties
     y 105
     x 215
     view 16
 )
)
(instance girl2 of Act
 (properties
     y 262
     x 25
     view 16
 )
)
(instance girl3 of Act
 (properties
     y 135
     x 250
     view 16
 )
)
(instance girl4 of Act
 (properties
     y 115
     x 230
     view 16
 )
)
(instance girl5 of Act
 (properties
     y 230
     x 115
     view 16
 )
)
(instance girl6 of Act
 (properties
     y 115
     x 183
     view 16
 )
)
(instance ladder of Prop
 (properties
     x 136
     y 5
     view 414
 )
)
