/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 29)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm029 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
        (= xx1 Random(1 319))
        (= xx2 Random(1 319))
        (= xx3 Random(1 319))
        (= xx4 Random(1 319))
        (= yy1 Random(26 161))
        (= yy2 Random(26 161))
        (= yy3 Random(26 161))
        (= yy4 Random(26 161))
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            (case 28

				(send gEgo:
					posn(289 125)
					loop(1)
				)
            )
            (case 295

				(send gEgo:
					posn(50 125)
					loop(0)
				)
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (if(== ridingscooter TRUE)
           (send gEgo:view(20))
        )
        (cactus1:init()
          posn (xx1 yy1)
        )
        (cactus2:init()
          posn (xx2 yy2)
        )
        (cactus3:init()
          posn (xx3 yy3)
        )
        (cactus4:init()
          posn (xx4 yy4)
        )

	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
    (var dyingScript)
            (if(== (send gEgo:onControl()) ctlGREY)
                   (++desertcount)
                   (send gRoom:newRoom(28))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (++desertcount)
                   (send gRoom:newRoom(295))
            )
            (if(== (send gEgo:onControl()) 2)
               (if(== desertcount 6)

                  = dyingScript ScriptID(DYING_SCRIPT)
                  (send dyingScript:
                   caller(3)
                   register("It was hotter than a dead goat!")
                  )
                  (send gGame:setScript(dyingScript))
               )
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around'))
               Print("You are in a seemingly endless desert. Dang it's hot out here")
            )
            (if(Said('look/sand'))
               Print("There's plenty of sand to look at.")
            )
            (if(Said('look/cactus'))
               Print("It's just scenery.")
            )

            (if(Said('look/sky,sun'))
               Print("The sun is slowly killing you.")
            )
            (if(Said('leave,exit/desert'))
                Print("Maybe you can't! MWA HA HA HA.")
                Print("MWA HA HA. Ha.")
            )
            (if(Said('ride,use/scooter'))
               (if(send gEgo:has(INV_SCOOTER))
                   Print("o.k")
                  (send gEgo:view(20))
                  = ridingscooter TRUE
                 )(else
                   Print("you don't have it!")
               )
            )
            (if(Said('walk'))
               (if(send gEgo:has(INV_SCOOTER))
                   Print("o.k")
                  (send gEgo:view(0))
                  = ridingscooter FALSE
                 )(else
                   Print("you don't have it!")
               )
            )

    )
)
/******************************************************************************/
(instance cactus1 of Prop
 (properties
     y 60
     x 250
     view 511
 )
)
(instance cactus2 of Prop
 (properties
     y 60
     x 250
     view 511
 )
)
(instance cactus3 of Prop
 (properties
     y 60
     x 250
     view 511
 )
)
(instance cactus4 of Prop
 (properties
     y 60
     x 250
     view 511
 )
)

