/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 30)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm030 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
           (case 295
                (Print("You made it just in time to avoid dying of thirst!"))
                (send gEgo:
					posn(295 125)
					loop(1)
				)
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (if(not(send gEgo:has (INV_FRUIT)))
      (if(not(== givenfruit TRUE))
               (fruit:init()
               setCycle(Fwd)
               cycleSpeed(10))))

        (= ridingscooter FALSE)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(295))
            )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around'))
               Print("You have reached an oasis, with one lone tree surrounded by water")
            )
            (if(Said('look/sand'))
               Print("There's plenty of sand to look at.")
            )
            (if(Said('look/tree'))
               Print("It is a rare wire tree. The one lone tree has one lone fruit.")
            )
            (if(Said('look/fruit'))
               Print("Looking doesn't help you.")
            )
            (if(Said('look/water'))
               Print("Man, you're thirsty enough to drink spit.")
            )
            (if(Said('look/bridge'))
               Print("It's safe enough.")
            )
            (if(Said('look/sky,sun'))
               Print("The sun is slowly killing you.")
            )
            (if(Said('look [<under]/bridge'))
               Print("There's no troll, if that's what you mean.")
            )
            (if(Said('leave,exit/desert'))
                Print("Maybe you can't! MWA HA HA HA.")
                Print("MWA HA HA. Ha.")
            )
            (if(Said('eat/fruit'))
               Print("It's not for you.")
            )
            (if(Said('swim'))
               Print("As nice as that sounds, there's no time.")
            )
            (if(Said('drink'))
               (if(send gEgo:inRect(26 39 208 181))
                   Print("The water is warm, but at least it's stagnant!")
                   (= desertcount 0)
                   (send gGame:changeScore(2))
                )(else
                   Print("Get closer.")
               )
            )
            (if(Said('take/fruit'))
              (if(send gEgo:has(INV_FRUIT))
                       Print("You already have it!")
               )(else
                    (if(send gEgo:inRect(72 74 138 151))
                      Print("Congratulations! You have found the fruit of the wire tree!")
                      (send gGame:changeScore(10))
                      (send gEgo:get(INV_FRUIT))
                      (fruit:hide())
                     )(else
                      Print("You're not close enough!")
                    )
              )
             (if(Said('ride,use/scooter'))
               (if(send gEgo:has(INV_SCOOTER))
                   Print("there's no need to ride in the oasis.")

               )(else
                   Print("you don't have it!")
                )
            )

        )
            
     )
    
)
/******************************************************************************/
(instance fruit of Prop
 (properties
     y 99
     x 115
     view 512
 )
)

