/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 31)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm031 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 1
				(send gEgo:
					posn(17 159)
					loop(2)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (if(not(send gEgo:has (INV_PEZ)))
           (if(not(== givenpez TRUE))
               (dispenser:init()
               setCycle(Fwd)
               cycleSpeed(5))))
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
        (var dyingScript)
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(1))
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (Print("You stepped off the path"))
                   = dyingScript ScriptID(DYING_SCRIPT)
                    (send dyingScript:
                     caller(3)
                     register("There are worse ways to go.")
                    )
                    (send gGame:setScript(dyingScript))
           )
    )
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('get/pez'))
              (if(send gEgo:has(INV_PEZ))
                       Print("You already have it!")
               )(else
                    (if(send gEgo:inRect(261 109 305 132))
                      Print("Congratulations! You have found the golden pez dispenser!")
                      (send gGame:changeScore(10))
                      (send gEgo:get(INV_PEZ))
                      (dispenser:hide())
                     )(else
                      Print("You're not close enough!")
                    )
              )

            )
            (if(Said('look/around'))
               Print("You are in a strange place, where a trail leads to the golden pez dispenser of legend.")
            )
            (if(Said('look/trail'))
               Print("It's treacherous. Tread softly.")
            )
            (if(Said('look/mountains'))
               Print("You'd better watch your step, instead of the scenery.")
            )
            (if(Said('look/dispenser'))
               Print("Looking at it won't help you.")
            )
            (if(Said('look/cave'))
               Print("It leads back the way you came.")
            )
    )

    
)
(instance dispenser of Prop
 (properties
  x 282
  y 123
  view 514
 )
)
/******************************************************************************/
