/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 175)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm175 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(150 130)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init()
                   hide())
        (if(not(send gEgo:has (INV_CHIPS)))
           (if(not(== usedchips TRUE))
               (chips:init())
           )
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (handleEvent pEvent)
    (super:handleEvent(pEvent))

         (if(Said('look/cheetos'))
            Print("They look tasty.")
         )
         (if(Said('look/stove,oven,microwave'))
            Print("It's not important.")
         )
         (if(Said('leave,exit'))
            (send gRoom:newRoom(17))
         )
         (if(Said('close/cupboard'))
            (send gRoom:newRoom(17))
         )
         (if(Said('take/chips'))

              (if((send gEgo:has(INV_CHIPS)) or (== usedchips TRUE))
                       Print("You already have them!")
              )(else

                      Print("You've got a bag of cheetos!")
                      (send gGame:changeScore(4))
                      (send gEgo:get(INV_CHIPS))
                      (chips:hide())



               )

         )
         (if(Said('look/around,cupboard'))
            (if((send gEgo:has(INV_CHIPS)) or (== usedchips TRUE))
                Print ("You are getting a close-up look at a kitchen cupboard.A bag of chips is all that remains.")
            )(else
               Print("You are getting a close-up look at a kitchen cupboard.")
             )
         )
         (if(Said('eat/cheetos'))
            Print("You'll need them later.")
         )
         (if(Said('open/microwave'))
            Print("There's nothing in the microwave.")
         )
         (if(Said('open/cupboard'))
            Print("It's already open.")
         )
    )
)
/******************************************************************************/
(instance chips of Prop
 (properties
     y 94
     x 158
     view 408
 )
)
