/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 menubar.sc
 Contains the customized Menubar class. This is the script you modify if you 
 want to customize the menu.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MENUBAR_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "gauge")
(use "sound")
(use "user")
(use "sciAudio")
(use "narrate")
(local
    snd
)
/******************************************************************************/
(class TheMenuBar of MenuBar
	(properties
		state 0
	)
	(method (init)
		AddMenu(
			"  "
				"About This Game`^a:"+
				"Help`#1"
		)
		AddMenu(
			" File "
				"Restart Game`#9:"+
				"Save Game`#5:"+
				"Restore Game`#7:"+
				"--! :"+
				"Quit`^q"
		)
		AddMenu(
			" Action "
				"Pause Game`^p:"+
				"Inventory`^I:"+
				"Retype`#3:"+
				"--! :"+
				"Colors`^c"
		)
		AddMenu(
			" Speed "
				"Change...`^s:"+
				"--!:"+
				"Faster`+:"+
				"Normal`=:"+
				"Slower`-:"
		)



		(if(DoSound(sndSET_SOUND))
            (if (== gNarrate PRINT_AND_SPEAK or == gNarrate PRINT_ONLY)
                (if (== gNarrate PRINT_AND_SPEAK)
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn Off Sound`#2=1:"+
                            "Turn Off Text`#2=1:"+
                            "Turn Off Narration`#2=1"
			         )
                )(else
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn Off Sound`#2=1:"+
                            "Turn Off Text`#2=1:"+
                            "Turn On Narration`#2=1"
			         )
                )
            )(else
                 (if (== gNarrate PRINT_AND_SPEAK or == gNarrate SPEAK_ONLY)
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn Off Sound`#2=1:"+
                            "Turn On Text`#2=1:"+
                            "Turn Off Narration`#2=1"
			         )
                )(else
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn Off Sound`#2=1:"+
                            "Turn On Text`#2=1:"+
                            "Turn On Narration`#2=1"
			         )
                )
            )
        )(else
            (if (== gNarrate PRINT_AND_SPEAK or == gNarrate PRINT_ONLY)
                (if (== gNarrate PRINT_AND_SPEAK)
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn On Sound`#2=1:"+
                            "Turn Off Text`#2=1:"+
                            "Turn Off Narration`#2=1"
			         )
                )(else
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn On Sound`#2=1:"+
                            "Turn Off Text`#2=1:"+
                            "Turn On Narration`#2=1"
			         )
                )
            )(else
                 (if (== gNarrate PRINT_AND_SPEAK or == gNarrate SPEAK_ONLY)
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn On Sound`#2=1:"+
                            "Turn On Text`#2=1:"+
                            "Turn Off Narration`#2=1"
			         )
                )(else
			         AddMenu(
				        " Sound "
					        "Volume...`^v:"+
					        "Turn On Sound`#2=1:"+
                            "Turn On Text`#2=1:"+
                            "Turn On Narration`#2=1"
			         )
                )
            )
        )

		(if(< Graph(grGET_COLOURS) 9)
			SetMenu(MENU_COLOURS 32 0)
		)(else
			SetMenu(MENU_COLOURS smMENU_SAID '/color')
		)
		SetMenu(MENU_SAVE		smMENU_SAID 'save[/game]')
		SetMenu(MENU_RESTORE	smMENU_SAID 'restore[/game]')
		SetMenu(MENU_RESTART	smMENU_SAID 'restart[/game]')
		SetMenu(MENU_QUIT		smMENU_SAID 'done[/game]')
		SetMenu(MENU_PAUSE		smMENU_SAID 'delay[/game]')
		SetMenu(MENU_INVENTORY	smMENU_SAID 'all')
	)
	(method (handleEvent pEvent)
		(var menuItem, hGauge, newSpeed, newVolume, wndCol, wndBack, hPause)
		= menuItem (super:handleEvent(pEvent))
		(switch(menuItem)
			(case MENU_ABOUT
				Print(
					"            LockerGnome Quest\n"+
                    "Created for Chris Pirillo of TechTV\n\n"+
					"           By Brian Provinciano\n\n"+
					"               March 5th, 2003"
					#title "About"
				)
			)
			(case MENU_HELP
				Print(
					"Play the game!"
					#title "How To Play"
				)
			)
			(case MENU_RESTART
				(if(Print(
					  "Are you serious? You really want to start all the way back at the beginning again?"
					  #title "Restart"
					  #font gDefaultFont
					  #button "Restart" 1
					  #button " Oops " 0
                      #icon 15
					)
				   )
					(send gGame:restart())						
				)
			)
			(case MENU_RESTORE   
				(send gGame:restore())
			)
			(case MENU_SAVE		  		    
				(send gGame:save())
			)
			(case MENU_QUIT		  	
				(if(Print(
					  "Do you really want to quit?"
					  #title "Quit"
					  #font gDefaultFont
					  #button " Quit " 1
					  #button " Oops " 0
                      #icon 15
					)
				   )
						= gQuitGame TRUE					
				)
			)
			(case MENU_PAUSE
				= hPause (Sound:pause())
 				PrintSpeak(997 0) /* Game Paused */
 				(Sound:pause(hPause))
			)
			(case MENU_INVENTORY
				(if(PrintCantDoThat($400))
					(send gInv:showSelf(gEgo))
		    	)
			)
			(case MENU_RETYPE
				(send pEvent:
					claimed(FALSE)
					type(evKEYBOARD)
					message( (User:echo) )
				)
			)
			(case MENU_COLOURS
				= wndCol 16
				(while(>u wndCol 15 and <> wndCol -1)
					= wndCol GetNumber("New Text Color: (0-15)")
				)
				(if(<> wndCol -1)
					= wndBack 16
					(while(<> wndBack -1 and >u wndBack 15 or == wndCol wndBack)
						= wndBack GetNumber("New Background Color: (0-15)")
					)
					(if(<> wndBack -1)
						= gWndColor wndCol
						= gWndBack wndBack
						(send gTheWindow:
							color(gWndColor)
							back(gWndBack)
						)
					)
				)
			)
			(case MENU_CHANGESPEED
				= hGauge (Gauge:new())
				= newSpeed
					(send hGauge:
						text("Game Speed")
						description("Use the mouse or the left and right arrow keys to select the game speed.")
						higher("Faster")
						lower("Slower")
						normal(NORMAL_SPEED)
						doit(- 15 gSpeed)
					)
				(send gGame:setSpeed(- 15 newSpeed))
				DisposeScript(GAUGE_SCRIPT)
			)
			(case MENU_FASTERSPEED
				(if(gSpeed)
					(send gGame:setSpeed(--gSpeed))
				)
			)
			(case MENU_NORMALSPEED
				(if(gSpeed)
					(send gGame:setSpeed(12))
				)
			)
			(case MENU_SLOWERSPEED
				(if(< gSpeed 15)
					(send gGame:setSpeed(++gSpeed))
				)
			)
			(case MENU_VOLUME
				= hGauge (Gauge:new())
				= newVolume
					(send hGauge:
						text("Sound Volume")
						description("Use the mouse or the left and right arrow keys to adjust the volume.")
						higher("Louder")
						lower("Softer")
						normal(15)
						doit(sndVOLUME newVolume)
					)
				DoSound(sndVOLUME newVolume)
				DisposeScript(GAUGE_SCRIPT)
			)
			(case MENU_TOGGLESOUND
				ToggleSound()
			)

            (case MENU_TOGGLEPRINT
                TogglePrint()
            )

            (case MENU_TOGGLESPEECH
                ToggleSpeech()
            )
		)
	)
)
(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)
/******************************************************************************/
(procedure public (ToggleSound) // mute, unmute
    Print("ToggleSound")

	(if(DoSound(sndSET_SOUND)) // if true, mute
            DoSound(sndSET_SOUND FALSE)
            (if(== gNarrate PRINT_AND_SPEAK)
               = gNarrate PRINT_ONLY
               SetMenu(MENU_TOGGLESPEECH smMENU_TEXT "Turn On Narration")	
			)(else
			   = gNarrate NULL
			)
            SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn On Sound")
    )
	(else  // must be false, unmute
            DoSound(sndSET_SOUND TRUE)
            SetMenu(MENU_TOGGLESOUND smMENU_TEXT "Turn Off Sound")
            (if(== gNarrate PRINT_ONLY)
            	= gNarrate PRINT_AND_SPEAK
            	SetMenu(MENU_TOGGLESPEECH smMENU_TEXT "Turn Off Narration")
			)
    )
)
/******************************************************************************/
/******************************************************************************/
(procedure public (TogglePrint)
    Print("TogglePrint")

    (if(== gNarrate PRINT_AND_SPEAK)
       = gNarrate SPEAK_ONLY
    )(else
       (if(== gNarrate PRINT_ONLY)
          = gNarrate NULL
       )(else
          (if(== gNarrate SPEAK_ONLY)
             = gNarrate PRINT_AND_SPEAK
          )
       )
    )
    
	(if(== gNarrate PRINT_AND_SPEAK or == gNarrate PRINT_ONLY)
		SetMenu(MENU_TOGGLEPRINT smMENU_TEXT "Turn Off Text")
	)(else
		SetMenu(MENU_TOGGLEPRINT smMENU_TEXT "Turn On Text")
	)
)
/******************************************************************************/
/******************************************************************************/
(procedure public (ToggleSpeech)
    Print("ToggleSpeech")
    
    (if(== gNarrate PRINT_AND_SPEAK)
       = gNarrate PRINT_ONLY
    )(else
       (if(== gNarrate SPEAK_ONLY)
          = gNarrate NULL
       )(else
          (if(== gNarrate PRINT_ONLY)
             = gNarrate PRINT_AND_SPEAK
        )
       )
    )
    
	(if(== gNarrate PRINT_AND_SPEAK or == gNarrate SPEAK_ONLY)
		SetMenu(MENU_TOGGLESPEECH smMENU_TEXT "Turn Off Narration")
	)(else
		SetMenu(MENU_TOGGLESPEECH smMENU_TEXT "Turn On Narration")
	)

)
/******************************************************************************/
