/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(use "rev")
(use "dpath")
(use "door")
(use "sciAudio")
(use "narrate")
(use "wait")
(local
    magiColID = 0
    magiCol[4] = ( clBROWN clYELLOW clWHITE clSILVER)
    DRAW_AUTHOR = FALSE
    CAN_CONTINUE = FALSE
    snd
    DO_CREDITS = FALSE
)
/******************************************************************************/


(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)

(instance aud2 of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)

(instance public TitleScreen of Rm
	(properties
		picture 800
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE

		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
		)
		

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)       */


        = snd aud
        (send snd:
            command("play")
            fileName("music\\Constancy Part Two.sciAudio")
            volume("100")
            loopCount("-1")
            init()
         )

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/


    
	)
    (method (doit)
        (super:doit())

        (if(DRAW_AUTHOR and (Title:isStopped))
            = magiColID ( & (+ magiColID 1) 3)
	       Display(
			"By Brian Provinciano"
			dsCOORD 184 181
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )
		  Display(
			"By Brian Provinciano"
			dsCOORD 185 180
			dsCOLOUR magiCol[magiColID]
			dsBACKGROUND clTRANSPARENT
		  )	  
        )
        
        
        (if(DRAW_AUTHOR and (Title:isStopped) and == DO_CREDITS FALSE)
          (send gGame:setCursor(999 TRUE))
           = CAN_CONTINUE TRUE
	       Display(
			"Reduxers:"
			dsCOORD 0 150
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		  )           	

	       Display(
			"Reduxers:"
			dsCOORD 1 151
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )    
		    
	       Display(
			"Music: Kevin McLeod"
			dsCOORD 0 160
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		  )

	       Display(
			"Music: Kevin McLeod"
			dsCOORD 1 161
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )		      
		  
		  
	       Display(
			"Narration: Tawmis Logue"
			dsCOORD 0 170
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		  )           	

	       Display(
			"Narration: Tawmis Logue"
			dsCOORD 1 171
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )		  
		  
		  
		  Display(
			"Development: Gumby"
			dsCOORD 0 180
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		  )           	

	      Display(
			"Development: Gumby"
			dsCOORD 1 181
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )  


		  Display(
			"Original development:"
			dsCOORD 184 170
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		  )           	

	      Display(
			"Original development:"
			dsCOORD 185 171
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		  )  

		         	
		  = DO_CREDITS TRUE
		 
		)	
    )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
    
    
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
                 //ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game
				(if(CAN_CONTINUE)
    
			         = snd aud
			            (send snd:
			            command("stop")
			            fileName("music\\Constancy Part Two.sciAudio")
			            fadeOutMillisecs("5000")
			            loopCount("0")
			            init()
			         )
			         
                    (send gRoom:newRoom(INITROOMS_SCRIPT))
                )
		    )
		)
	)
    (method (changeState newState)
        = state newState
        (switch(state)
            (case 0
		        (send gGame:setSpeed(8))
                = cycles 2
            )
            (case 1
                (Logo:
                    init()
                    setCycle(Fwd)
                )
                = cycles 4
            )
            (case 2
		          Display(
			         "Developed With SCI Studio 3"
			         dsCOORD 75 170
			         dsCOLOUR clSILVER
			         dsBACKGROUND clTRANSPARENT
		          )
		          Display(
			         "http://www.bripro.com"
			         dsCOORD 95 180
			         dsCOLOUR clSILVER
			         dsBACKGROUND clTRANSPARENT
		          )
                (Logo:
                    setCycle(NULL)
                )
                = cycles 4
            )
            (case 3
		          Display(
			         "Developed With SCI Studio 3"
			         dsCOORD 75 170
			         dsCOLOUR clGREY
			         dsBACKGROUND clTRANSPARENT
		          )
		          Display(
			         "http://www.bripro.com"
			         dsCOORD 95 180
			         dsCOLOUR clGREY
			         dsBACKGROUND clTRANSPARENT
		          )
                (Logo:
                    setCycle(Rev)
                )
                = cycles 4
            )
            (case 4
		        (send gGame:setSpeed(6))
                (TitleScreen:drawPic(800))
                (Logo:
                    hide()
                )
                = cycles 1
            )
            (case 5
                (Logo:dispose())
                (TitleScreen:drawPic(2))
                (LockerDoor:
                    doorState(DOOR_OPEN)
                    init()
                    setPri(0)
                )
                
			    (send gEgo:
					view(0)
				    loop(2)
				    posn(202 138)
					setStep(4 4)
					setMotion(MoveTo 202 138)
					setCycle(Walk)
					init()
		            show()
				)
                (send gGame:setCursor(997 TRUE))

                PrintSpeak(800 1 NULL 1) /* You are LockerGnome, the great master of the Gnome Locker, the safe where you store all your valuables.After just getting your hands on a rare copy of Microsoft Windows 1.0, you are on your way to put it in the locker for safe keeping... */
                Wait(* 17 60)

                (send gEgo:
                    setCycle(Walk)
                    setMotion(
                        DPath
                        160 130
                        160 58
                    )
                )

                = cycles 24
            )
            (case 6
                (send gEgo:hide())
                = cycles 1
            )
            (case 7
                (LockerDoor:close())

		        = snd aud2
		        (send snd:
		            command("play")
		            fileName("effects\\doorslam.sciAudio")
		            volume("100")
		            loopCount("0")
		            init()
		        )
                
                = cycles 8
            )
            (case 8
                ShakeScreen(4  ssFULL_SHAKE)
                = cycles 1
            )
            (case 9
                PrintSpeak(800 0 NULL 1) /* When suddenly the door closes! You find yourself stuck inside the super secure Gnome Locker! How on earth are you going to get out? */
                Wait(* 7 60)
                ProgramControl()
                (Title:
                    init()
                    setPri(15)
                    setStep(0 8)
                    setCycle(Fwd)
                    setMotion(MoveTo 160 140)
                )

                = DRAW_AUTHOR TRUE
                = cycles 8
            )
            /*
            (case 10
                = CAN_CONTINUE TRUE
            )
            */
        )
    )
)
/******************************************************************************/
(instance Title of Act
  (properties
    y 0
    x 160
    view 8
  )
)
/******************************************************************************/
(instance LockerDoor of Door
  (properties
    y 104
    x 166
    view 10
  )
)
/******************************************************************************/
(instance Logo of Act
  (properties
    y 141
    x 160
    view 99
  )
)
/******************************************************************************/
