(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 972)
(use "controls")
(use "sciAudio")
(use "main")
/******************************************************************************/

(procedure public (PrintSpeak resNum index p_font p_time)
    (var font, time)
    
    (if (>= paramTotal 3) = font p_font)(else = font NULL)
    (if (>= paramTotal 4) = time p_time)(else = time NULL)

    (if (== gNarrate PRINT_AND_SPEAK or == gNarrate SPEAK_ONLY)
       // play the current narration exclusively (stop any currently playing narration)
   	   Speak(resNum index)
    )

    (if (== gNarrate PRINT_AND_SPEAK or == gNarrate PRINT_ONLY)
       (if(font)
       	   (if(time) // usually 1 second...
              // Display the window, then dispose of it, it will be closed automatically
              // after 1 second.  Then issue a wait() for the # of seconds the narration
              // takes to playback (which will block any other commands from executing
              // including the 1 second countdown to dispose of the window).
              // After the wait clears, the print window will disappear
              //
              // If you want a non-blocking solution (without using Wait()),
              // specify a greater number of seconds for the print window to
              // remain open before disposal
       	      Print(resNum index #font font #time p_time #dispose)
		   )(else
		   	  Print(resNum index #font font)
		   )
       )(else
       	   (if(time)
       	      Print(resNum index #time p_time #dispose)
		   )(else
   	          Print(resNum index)
		   )
	   )
    )
)

(procedure public (Speak resNum index)
	(var filename[20])
    Format(@filename "speech\\%03d-%03d.sciAudio" resNum index)

    (if (== gNarrate PRINT_AND_SPEAK or == gNarrate SPEAK_ONLY)
      // play the current narration exclusively (stop any currently playing narration)
   	  (narrate:
          command("playx")
          soundClass("narration")
          conductorFile("sciAudio\\narrate.con")
          fileName(@filename)
          playXFadeOutMillisecs("1500") // will fade currently playing sound only
          volume("200")
          init()
      )
    )
)

(instance narrate of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)
