/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(use "sciAudio")
(use "narrate")
(use "timer")

/******************************************************************************/
(local
    LAMP_HAS_BULB
    SPEAKER_CUT
    FIRST_TIME_ON_CHAIR
    ON_CHAIR
    FOUND_KNIFE
    snd
)
/******************************************************************************/


(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
        (var mbResult)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))

        (send gGame:setCursor(999 TRUE))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:
  					posn(160 160)
  					loop(2)
  				)
  			)
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:
            init()
            observeControl(ctlCYAN)
        )

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/


        = snd aud
        
        (send snd:
           command("play")
           fileName("effects\\aircon.sciAudio")
           volume("100")
           loopFadeInMillisecs("2000")
           loopFadeOutMillisecs("2000")
           loopCount("-1")  // loop forever
           
           init()
        )
    
        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
        = LAMP_HAS_BULB TRUE
        = SPEAKER_CUT  FALSE
        = FIRST_TIME_ON_CHAIR TRUE
        = ON_CHAIR FALSE
        = FOUND_KNIFE FALSE
        
        (send gEgo:get(INV_WINDOWS))

        (LightBulb:
            init()
            setCycle(Fwd)
        )
        (Speaker:
            init()
            ignoreActors(FALSE)
        )

        = mbResult Print("Select gameplay option"
		                 #title "Text & Speech Options"
  			             #button "Text & Speech"  1
	                     #button "Speech only" 2
                         #button "Text only" 3
                   )
                   
  		(switch(mbResult)
  			(case 1
               = gNarrate PRINT_AND_SPEAK
		    )
            (case 2
               = gNarrate SPEAK_ONLY
            )
		    (case 3
               = gNarrate PRINT_ONLY
            )
        )
    )
)


/******************************************************************************/
(instance RoomScript of Script
	(properties)

		(method (changeState mainState)
		        = state mainState
		        (switch(state)
		            (case 0) // since there's no case 1 identified, it won't go to case 2 unless told
		            (case 2 
                         ProgramControl()
                        = seconds 3
		            )  
		            (case 3
		            	(LightBulb:
                          setLoop(1)
                          posn(132 120)
                          doit()
                        ) 
                        = seconds 6
		            ) 
					(case 4
                        (send snd:
                           command("play")
                           fileName("effects\\score.sciAudio")
                           volume("35")
                           loopCount("0")
                           init()
                        )
                        (send gGame:changeScore(4))
		            	(send gGame:setCursor(999 TRUE))

		                 PlayerControl()
		                = seconds 1
					)
				    (case 10
                		= cycles 20
            		)
            		(case 11
						(send gRoom:newRoom(2))
            		)
		         )  
		) 
	
	(method (handleEvent pEvent)
		(var i)
        (super:handleEvent(pEvent))



        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
        
    /*
        (if(== (send pEvent:type) evMOUSEBUTTON
        	and == (send pEvent:modifiers) 515)
        	FormatPrint("x:%d, y:%d" (send pEvent:x) (send pEvent:y) )	 
		)
 	*/				
        (if(Said('help')) 
          PrintSpeak(1 0) /* You are on your own. */
		)
		
		(if(Said('kick,punch,attack/*'))
		  PrintSpeak(1 1) /* Trust me, violence is not the answer. */	
		)

        (if(Said('inventory'))
          (send gInv:showSelf(gEgo))	
		) 
		
	    // Validate the objects are accessible	    
	    (if(Said('*/knife>') or Said('*/*/knife>'))
	    	(if(not FOUND_KNIFE)
	    		PrintSpeak(1 2) /* What knife? Where? */
	    		(send pEvent:claimed(TRUE))	
			)
		)	
		
		(if(  Said('look,(look<in),(dig<in),search,empty/box>')
			or (BoxesLeftLook:rightClicked(pEvent))
			or (BoxesRightLook:rightClicked(pEvent))
			or (OpenBoxLook:rightClicked(pEvent))	
		   )
            (if(& (send gEgo:onControl()) (ctlFUCHSIA))
                (if(not FOUND_KNIFE)
                	
                	(send gGame:setCursor(997 TRUE))
                    PrintSpeak(1 3 NULL 1) /* You dig through the box to find a knife! */
                    Wait(* 3 60)
                    (send gGame:setCursor(999 TRUE))
                    
                    (send snd:
                        command("play")
                        fileName("effects\\score.sciAudio")
                        volume("35")
                        loopCount("0")
                        init()
                    )
                    
                    (send gGame:changeScore(1))
                    = FOUND_KNIFE TRUE
                )(else
                	(if(send gEgo:has(INV_KNIFE))
                	   PrintSpeak(1 4) /* There isn't anything else in the box. */
					)(else
                       PrintSpeak(1 5) /* You found a knife in the box. */
					)
                )
            )(else
            	(if(Said('(look<in),(dig<in),search,empty/box')
            		or (OpenBoxLook:rightClicked(pEvent))
            	   )
            		PrintSpeak(1 6) /* The only box that is open is near the back wall, and you aren't close enough to examine it's contents. */
			    )(else
                    PrintSpeak(1 7) /* You see many boxes, all of which are securely sealed except for one. */
				)
            )		
            (send pEvent:claimed(TRUE))	
		)
		
		(if(Said('look<under/table') or UnderTableLook:rightClicked(pEvent))
		   PrintSpeak(1 8) /* There's nothing under the table */	
		)
		
        (if(Said('look[<on,at]/table') or TableLook:rightClicked(pEvent))
           PrintSpeak(1 9) /* There's nothing of any importance on the table. */
		)
		
		(if(Said('look<under/chair') or UnderChairLook:rightClicked(pEvent))
		   PrintSpeak(1 10) /* There doesn't appear to be anything under the chair. */
		)
		
        (if(Said('(look,sit)/chair') or ChairLook:rightClicked(pEvent))
           PrintSpeak(1 11) /* This is no time for sitting down, but you might want to consider heightening your strategy. */	
		)
		
        (if(Said('look/barrel') or BarrelLook:rightClicked(pEvent))
           PrintSpeak(1 12) /* The barrel looks pretty unsteady! I wouldn't open it if I were you! */	
		)
		
        (if(Said('look/bucket,pail,can,paint,(paint<can)') or PaintCanLook:rightClicked(pEvent))
           PrintSpeak(1 13) /* The paint can has paint all over it. One bad move and the locker will get some unneeded redecorating! */
		)
					
        (if(Said('look/speaker') or SpeakerLook:rightClicked(pEvent))
           PrintSpeak(1 14) /* A top of the line super fantastic MEGA-BLAST speaker! So fantastic, you wonder why you left it here to collect dust. */
		)
		
        (if(Said('look/bag,(garbage<bag)') or BagsLook:rightClicked(pEvent))
           PrintSpeak(1 15) /* The garbage bags look pretty old. Shouldn't they be in a waste dump? */
		)
		
		(if(Said('look/wall') or WallsLook:rightClicked(pEvent))
		   PrintSpeak(1 16) /* When you built this locker, walls constructed of three-foot thick cement seemed like an good idea... */
		)

		(if(Said('look/floor') or FloorLook:rightClicked(pEvent))
		   PrintSpeak(1 17) /* You take great pride in keeping the floor clean. */
		)

        (if(    Said('look/light,bulb') 
             or (LightBulbLook:rightClicked(pEvent)) 
        	 or (LightBulbBrokenLook:rightClicked(pEvent))
        	 or (LightLook:rightClicked(pEvent))
        	 )
            (if(LAMP_HAS_BULB)
                PrintSpeak(1 19) /* There's not much of a bulb left now */
            )(else
                PrintSpeak(1 18) /* That's a fine looking light bulb. It looks obtainable. */
            )	
		)
	
	    (if(Said('look/briefcase,suitcase,case') or BriefcaseLook:rightClicked(pEvent))
	       PrintSpeak(1 20) /* That's a fine looking suitcase. It seems to be locked as well though. */	
		)		
		
		(if(Said('look/(vent,grate)') or VentLook:rightClicked(pEvent))
		   PrintSpeak(1 21) /* There is a vent high up on the far wall and out of reach. */	
		)	
		
		(if(Said('look[/around]'))
           PrintSpeak(1 72) /* You are stuck in the Gnome Locker and must get out! You see some boxes, a lamp, a chair, a table, a speaker, and all of your other valuables. */			
		)

        (if( Said('(stand<on),(climb[<(up,on)]),(go<on),(get<on)/chair'))
            (if(& (send gEgo:onControl()) (ctlCYAN))
                // already on the chair
                PrintSpeak(1 22)  /* You can't climb any further */
            )(else
                (if(& (send gEgo:onControl()) (ctlRED))
                    // at the chair
                    (if(FIRST_TIME_ON_CHAIR)
                    	
                    	(send gGame:setCursor(997 TRUE))
                        PrintSpeak(1 23 NULL 1)  /* Good idea! Think of what you can reach now! */
                        Wait(* 3 60)
                        (send gGame:setCursor(999 TRUE))
                        
                        = FIRST_TIME_ON_CHAIR FALSE
                        
                        (send snd:
	                        command("play")
	                        fileName("effects\\score.sciAudio")
	                        volume("35")
	                        loopCount("0")
	                        init()
                        )
                        (send gGame:changeScore(3))
                    )
                    = ON_CHAIR TRUE

                    (send gEgo: stopUpd() posn(142 94))
                )(else
                    PrintNotCloseEnough()
                )
            )
		)
		
		(if(Said('(stand<on),(climb[<(up,on)]),(go<on),(get<on)/table'))
			PrintSpeak(1 24) /* Not a bad idea, but then what would you do? */	
        )
        
        (if(Said('(stand<on),(climb[<(up,on)]),(go<on),(get<on)/box'))
            PrintSpeak(1 25) /* None of these cardboard boxes would support your weight. */
		)
		
        (if(Said('(stand<on),(climb[<(up,on)]),(go<on),(get<on)/barrel'))
            PrintSpeak(1 26) /* You don't dare. The bulging lid on the barrel makes you uneasy. */
		)

		(if(Said('climb,scale,(go<up)/wall'))
			PrintSpeak(1 27) /* You don't possess that talent as your blood isn't radioactive. */
		)
		
		(if(Said('(stand<on),(climb[<(up,on)]),(go<on),(get<on)[/!*]'))
		    PrintSpeak(1 28) /* What do you want to climb up on? */	
		)
    
        (if(Said('(get<down),(climb<down),(climb<off),jump,((get,go)<off)'))
            (if(ON_CHAIR)
                // already on the chair
                = ON_CHAIR FALSE
                (send gEgo: startUpd() posn(156 118))
            )(else
                PrintSpeak(1 29) /* Climb down from where? */
            )
        )
      
        
        (if(Said('(take,(pick<up),move,push,pull)/(boxes,box)'))
        	PrintSpeak(1 30) /* What do you need to move the box for? It's fine where it is. */
		)

        (if(Said('(take,(pick<up))/knife'))
            (if(send gEgo:has(INV_KNIFE))
                PrintSpeak(1 31) /* You already have it! */
            )(else
                (if(& (send gEgo:onControl()) (ctlFUCHSIA))
                	
                	(send gGame:setCursor(997 TRUE))
                    PrintSpeak(1 32 NULL 1) /* You pick up the knife, but how will it help you get out? */
                    Wait(* 4 60)
                    (send gGame:setCursor(999 TRUE))
                    
                    (send gEgo:get(INV_KNIFE))
                    
                    (send snd:
                        command("play")
                        fileName("effects\\score.sciAudio")
                        volume("35")
                        loopCount("0")
                        init()
                    )
                    
                    (send gGame:changeScore(4))
                )(else
                    PrintNotCloseEnough()
                )
            )
        )

        (if(Said('(take,move,push,pull,(pick<up))/table'))
            PrintSpeak(1 33) /* The table is much too heavy for you to move around. */
		)
		
        (if(Said('(take,move,push,pull,(pick<up))/chair'))
            PrintSpeak(1 34) /* The chair is just fine where is. But perhaps you can use it for something else. */	
		)
		
        (if(Said('(take,move,push,pull,(pick<up))/barrel'))
            PrintSpeak(1 35) /* That's waaaay to heavy! */
		)
		
        (if(Said('(take,(pick<up))/can,paint,bucket,pail,(paint<can)'))
            PrintSpeak(1 36) /* The only thing a paint can would do for you is ruin your pocket protector! */
		)				
			
        (if(Said('(take,(pick<up))/speaker'))
            (if(send gEgo:has(INV_SPEAKER))
                PrintSpeak(1 31) /* You already have it! */
            )(else
                (if(& (send gEgo:onControl()) (ctlYELLOW))
                	
                	
                    (send gGame:setCursor(997 TRUE))
                    PrintSpeak(1 38 NULL 1) /* You pick up the speaker, but what good will it do you you without electricity? */
                    Wait(* 4 60)
                    
                    (send gGame:setCursor(999 TRUE))
                    
                    // Can't look at the speaker on the floor any more
                    (SpeakerLook:xMax(-1))
                    (SpeakerLook:yMax(-1))
                    
                    (send gEgo:get(INV_SPEAKER))
                    (Speaker:hide())
                    
                    (send snd:
                        command("play")
                        fileName("effects\\score.sciAudio")
                        volume("35")
                        loopCount("0")
                       init()
                    )
                             
                    (send gGame:changeScore(4))
                )(else
                    PrintNotCloseEnough()
                )
            )
        )

        (if(Said('(take,(pick<up))/bag,(garbage<bag)'))
            PrintSpeak(1 39) /* The garbage bags are a little too smelly for the taking. */ 
		)       			
			

        (if(Said('(take,unscrew,remove)/light,bulb,lamp'))
            (if(LAMP_HAS_BULB)
                (if(ON_CHAIR)
                
                    (send snd:
                        command("play")
                        fileName("effects\\lightbulb.sciAudio")
                        volume("100")
                        loopCount("0")
                        init()
                    )
                    
                    (send gGame:setCursor(997 TRUE))
 
                    PrintSpeak(1 40 NULL 9) /* You remove the bulb, oooouch! and drop it. It sure isn't any good use to you now that it's broken! */
 
                    = LAMP_HAS_BULB FALSE
                    
                    (LightBulbBrokenLook:xMax(143))
                    (LightBulbBrokenLook:yMax(120))

                    (RoomScript:changeState(2)) 
                )(else
                    PrintSpeak(1 41) /* Your arms aren't that long! You can't reach it from there! You might want to try standing on something. */
                )
            )(else
                PrintSpeak(1 42) /* It's broken and useless! Plus, it's sharp! You might hurt yourself! */
            )
        )
        
        (if(Said('(take,(pick<up))/briefcase,suitcase,case'))
            PrintSpeak(1 43) /* It's a collectible.  You'd hate to scratch it and lower it's value.  Best to leave it where it lies. */
		)
		
        (if(Said('(take,(pick<up))/*'))
            PrintSpeak(1 44) /* You can't take that! */
		)

        (if(Said('open/bag,(garbage<bag)'))
            PrintSpeak(1 45) /* The garbage smells pretty bad in the bags! Being stuck in this small room, you really wouldn't want to open them! */
		)
		
		(if(Said('open/box'))
            (if(& (send gEgo:onControl()) (ctlFUCHSIA))
	             PrintSpeak(1 46) /* It already is open! It's an open box! */
            )(else
	             PrintSpeak(1 47) /* The boxes are so well sealed, not even a knife could open them! */
            )
        )	

        (if(Said('open/door'))
            PrintSpeak(1 48) /* The door is locked! Haven't you been paying attention? */
        )  
        
	    (if(Said('open/speaker'))
	        PrintSpeak(1 49) /* Open the speaker!? What are you talking about? */
	    )

        (if(Said('open/barrel'))
            PrintSpeak(1 50) /* Who knows what hazardous material could be in there. It wouldn't be safe to open. */
        )	    
        
        (if(Said('open/vent'))
            PrintSpeak(1 51) /* It's impossible to reach the vent. */	
		)
		
		(if(Said('open/briefcase,suitcase,case/knife'))
	        PrintSpeak(1 52) /* You can't find a good edge to insert the knife into. Besides, you'd probably break the blade if you did. */	
		)
		
	    (if(Said('open/briefcase,suitcase,case[/!*]'))
	        PrintSpeak(1 53) /* It's a Sampsonite and it's locked.  Not even a gorilla could get into it. */	
		)
        
 	    (if(Said('open/bucket,pail,can,paint,(paint<can)'))
	        PrintSpeak(1 54) /* You don't need to do any painting right now. Besides, you don't have a paint brush. */	
		)
		       	
    	(if(   Said('use/knife/speaker')
    		or Said('cut[<off]/wire[/knife]')
            or Said('cut/speaker/knife')
    	   )
    		(if(send gEgo:has(INV_KNIFE))
    		     (if(send gEgo:has(INV_SPEAKER))
                        (if(not SPEAKER_CUT)
                        	
                            (send gGame:setCursor(997 TRUE))
                            PrintSpeak(1 55 NULL 1) /* You cut the cord on the speaker to reveal it's open wires. */
                            Wait(* 4 60)
                            (send gGame:setCursor(999 TRUE))
                            
                            (send snd:
		                        command("play")
		                        fileName("effects\\score.sciAudio")
		                        volume("35")
		                        loopCount("0")
		                        init()
                            )
                            
                            (send gGame:changeScore(4))
                            = SPEAKER_CUT TRUE
                        )(else
                            PrintSpeak(1 56) /* You already cut the cord on the speaker. */
                            (send pEvent:claimed(TRUE))
                        )
                 )(else
                    PrintSpeak(1 57) /* You don't have the speaker! */
                    (send pEvent:claimed(TRUE))
				 )
            )(else
              	PrintSpeak(1 58) /* You don't have the knife! */
              	(send pEvent:claimed(TRUE))
			)
		)
		 
		(if(   Said('use/knife/*')
		    or Said('cut/*/knife'))
		    (if (send gEgo:has(INV_KNIFE))
		       PrintSpeak(1 59) /* You can't use the knife with that. */
			)(else
		       PrintSpeak(1 58) /* You don't have the knife! */	
			)	
		)
					
		(if(Said('cut/*'))
		    PrintSpeak(1 60) /* What do want to cut it with? */	
		)			
	
		(if(  Said('(use,(plug[<in]),attach,stick,connect)/(speaker,wire)/(light,lamp)')
		   or Said('(use,(plug[<in]),attach,stick,connect)/(light,lamp)/(speaker,wire)'))
	     	(if(send gEgo:has(INV_SPEAKER))
	     		(if(LAMP_HAS_BULB)
                    PrintSpeak(1 61) /* You can't use the lamp while the bulb is still in it! */
                )(else
                    (if(not SPEAKER_CUT)
                        PrintSpeak(1 62) /* The plug won't fit! */
                    )(else
                        DoWinGame()
                    )
                )
			)(else
				PrintSpeak(1 63) /* You don't have the speaker! */
			)		
	    )
		    
	    (if(Said('(use,(plug[<in]),attach,stick,connect)/speaker/*'))
		   PrintSpeak(1 64) /* You can't use the speaker with that. */
	    )
			               
        (if(Said('use/windows'))
           PrintSpeak(1 65) /* As incredible as it is, there's nothing you can do with it now! */
		)
		
		(if(Said('turn<off/light'))
		   PrintSpeak(1 66) /* You can't. In your infinite wisdom you placed the light switch outside the locker! */
		)
		
		(if(Said('swing/light,lamp'))
		   PrintSpeak(1 67) /* The light fixture is suspended by a rigid steel rod and won't budge. */ 	
		)
		
		(if(   (Said('drop/knife') and send gEgo:has(INV_KNIFE))
		    or (Said('drop/speaker') and send gEgo:has(INV_SPEAKER))
		    or Said('drop/windows'))
		   PrintSpeak(1 68) /* Drop Bill Gates pride and joy? Never! */
		)
						
		(if(Said('drop/*'))
		   PrintSpeak(1 69) /* You don't have it! */	
		)

        (if(Said('use/*'))
           PrintSpeak(1 70) /* There isn't anything to use it with! */
        )
    
 	)
)
/******************************************************************************/
(instance LightBulb of Prop
  (properties
    y 61
    x 137
    view 12
  )
)
(instance aKey of Act
  (properties
    y 150
    x 160
    view 801
  )
)
/******************************************************************************/
(instance Speaker of Prop
  (properties
    y 150
    x 222
    view 11
  )
)
(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)

(instance narrate of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)
/******************************************************************************/

(procedure (DoWinGame)
	
	(send gGame:setCursor(997 TRUE))
    PrintSpeak(1 74 LARGE_FONT 1) // (Don't try this at home kids!)
    Wait(* 3 60)
    
    PrintSpeak(1 73 NULL 1) /* You connect the speaker's open wires to the lamp. After receiving the shock, the speakers begin to blare an earth shattering sound! */
    Wait(* 8 60)

    (send snd:
        command("play")
        fileName("effects\\dooropen.sciAudio")
        volume("100")
        loopCount("0")
        init()
    )
    ShakeScreen(3 ssFULL_SHAKE)
    Wait(* 2 60)
     
    PrintSpeak(1 71 NULL 1) /* Wow! The sound from the speakers has shaken the door's lock enough to unlock it! */
    Wait(* 6 60)
    (send gGame:setCursor(999 TRUE))
    
    (send snd:
        command("play")
        fileName("effects\\score.sciAudio")
        volume("35")
        loopCount("0")
        init()
    )
    (send gGame:changeScore(8))
    
    ProgramControl()

    (send gEgo:
        startUpd()
        posn(156 118)
        setMotion(MoveTo 160 172)
    )
    (RoomScript:changeState(10))
)




(class MouseLookObj
   (properties
      priorityColor $0000
      xMin 0
      xMax 0
      yMin 0
      yMax 0
   )
   (method (rightClicked pEvent)
   	  MouseAction(pEvent 515)
   )   
   (method (leftClicked pEvent)
      MouseAction(pEvent 512)
   )
)

(procedure (MouseAction pEvent whichButton) of MouseLookObj
       (if (== (send pEvent:type) evMOUSEBUTTON
    	    and == (send pEvent:modifiers) whichButton
    	    and == priorityColor OnControl(ocPRIORITY (send pEvent:x) (send pEvent:y))
    		and > (send pEvent:x) xMin
    		and < (send pEvent:x) xMax
    		and > (send pEvent:y) yMin
    		and < (send pEvent:y) yMax)
    		
    		(if(== whichButton 512)  // if left-clicked, claim the event
    			(send pEvent:claimed(TRUE))	
			)
	      return(TRUE)
	   )
	   return(FALSE)
)

(instance public BoxesLeftLook  of MouseLookObj (properties priorityColor $0004 xMin  51 xMax 114 yMin  74 yMax 123))
(instance public BagsLook       of MouseLookObj (properties priorityColor $0002 xMin  93 xMax 132 yMin  78 yMax 110))
(instance public BarrelLook     of MouseLookObj (properties priorityColor $0008 xMin 109 xMax 141 yMin  69 yMax 102))
(instance public ChairLook      of MouseLookObj (properties priorityColor $0002 xMin 129 xMax 162 yMin  77 yMax 112))
(instance public UnderChairLook of MouseLookObj (properties priorityColor $0004 xMin 129 xMax 162 yMin  77 yMax 112))
(instance public LightLook      of MouseLookObj (properties priorityColor $0002 xMin 116 xMax 154 yMin  15 yMax  49))
(instance public OpenBoxLook    of MouseLookObj (properties priorityColor $0040 xMin 149 xMax 194 yMin  66 yMax  96))
(instance public VentLook       of MouseLookObj (properties priorityColor $0002 xMin 228 xMax 259 yMin  21 yMax  45))
(instance public TableLook      of MouseLookObj (properties priorityColor $0100 xMin 205 xMax 241 yMin  90 yMax 123))
(instance public UnderTableLook of MouseLookObj (properties priorityColor $0008 xMin 205 xMax 241 yMin  90 yMax 123))
(instance public BoxesRightLook of MouseLookObj (properties priorityColor $0002 xMin 225 xMax 277 yMin  88 yMax 128))
(instance public PaintCanLook   of MouseLookObj (properties priorityColor $1000 xMin  24 xMax  44 yMin 143 yMax 162))
(instance public BriefcaseLook  of MouseLookObj (properties priorityColor $0800 xMin  66 xMax 108 yMin 142 yMax 166))
(instance public SpeakerLook    of MouseLookObj (properties priorityColor $0004 xMin 184 xMax 255 yMin 119 yMax 153))
(instance public LightBulbLook  of MouseLookObj (properties priorityColor $0004 xMin 131 xMax 142 yMin  43 yMax  48))
(instance public LightBulbBrokenLook    of MouseLookObj (properties priorityColor $0010 xMin 118 xMax -1 yMin 107 yMax -1))
(instance public FloorLook      of MouseLookObj (properties priorityColor $0020 xMin   0 xMax 320 yMin   0 yMax 200))
(instance public WallsLook      of MouseLookObj (properties priorityColor $0001 xMin   0 xMax 320 yMin   0 yMax 200))
/******************************************************************************/
