/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 2)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "sciAudio")
(use "narrate")
(local
    snd
)
/******************************************************************************/
(instance public rm002 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

        (send gEgo:
		  posn(164 80)
		  loop(2)
          hide()
            //ignoreControl(ctlCYAN)
            //ignoreControl(ctlBLUE)
        )
        (LockerDoor:init())

        = snd aud
            (send snd:
            command("play")
            fileName("music\\Constancy Part Two.sciAudio")
            fadeOutMillisecs("5000")
            loopCount("0")
            init()
        )

		(send gEgo:init())
        (RoomScript:changeState(10))
	)
)
(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState newState)
        (var mbResult)
        = state newState
        (switch(state)
            (case 10
                (LockerDoor:open())
                = cycles 4
            )
            (case 11
                (send gEgo:
                    show()
                    setMotion(MoveTo 160 144)
                )
                = cycles 40
            )
            (case 12
            	(send gGame:setCursor(997 TRUE))
                PrintSpeak(2 0 NULL 1) /* Congratulations! You have completed LockerGnome Quest! */
                Wait(* 4 60)
                PrintSpeak(2 1 NULL 1) /* Make your own games for free just like this with SCI Studio! Go to: http://www.BriPro.com */
                Wait(* 10 60)
                (send gGame:setCursor(999 TRUE))
                
  				(while(1)
  					Speak(2 2) // What would you like to do now?
  					= mbResult Print(
  						"What would you like to do now?"
  						#title "Thank you for playing!"
  						#button "Play Again"  1
  						#button "  Quit  " 2
  					)
  					(switch(mbResult)
		    			(case 1
                             = snd aud
                            (send snd:
                              command("stop")
                              fileName("music\\Constancy Part Two.sciAudio")
                              fadeOutMillisecs("5000")
                              loopCount("0")
                              init()
                            )
  							(send gGame:restart())
  							return
		    			)
		    		    (case 2
                           = snd aud
                           (send snd:
                             command("stop")
                             fileName("music\\Constancy Part Two.sciAudio")
                             fadeOutMillisecs("5000")
                             loopCount("0")
                             init()
                           )
		    				= gQuitGame TRUE
		    				return
		    			)
		    		)
		    	)
            )
        )
    )
)
/******************************************************************************/
(instance LockerDoor of Door
  (properties
    y 104
    x 166
    view 10
  )
)
/******************************************************************************/
