(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 973)
/******************************************************************************/
(use "main")
(use "obj")
(use "controls")

(local
	msgBuf[1000]
	snd
)

/******************************************************************************/

(class sciAudio
	(properties
		command -111
		fileName -111
		soundClass -111
		volume -111
		fadeInMillisecs -111
		fadeOutMillisecs -111
		loopFadeInMillisecs -111
		loopFadeOutMillisecs -111
		loopCount -111
		conductorFile -111
		playXFadeOutMillisecs -111  // used only for playx command
	)
	(method (init)
	   (var hFile)

	   (if(== soundClass -111)
	   	  = soundClass "noSoundClass"
	   )
	   
	   StrCpy(@msgBuf "")
	   
	   /* if 'playx' (play exclusive), send command to stop all currently playing commands for sound class*/
	   
	   (if(== STRINGS_EQUAL StrCmp(command "playx"))
	      StrCat(@msgBuf "(sciAudio\n")
	      StrCat(@msgBuf "   command stop\n")
	      StrCat(@msgBuf "   soundClass ")
	      StrCat(@msgBuf soundClass)
	      StrCat(@msgBuf "\n")
	      
	      /* fade if requested */
		  (if(<> playXFadeOutMillisecs -111)
		      StrCat(@msgBuf "   fadeOutMillisecs ")
		      StrCat(@msgBuf playXFadeOutMillisecs)
		      StrCat(@msgBuf "\n")	   	
		  ) 	   
		  StrCat(@msgBuf ")\n")
	   )
	   
	   StrCat(@msgBuf "(sciAudio\n")

	   (if( == STRINGS_EQUAL StrCmp(command "play") or == STRINGS_EQUAL StrCmp(command "playx"))
	      StrCat(@msgBuf "   command play")
	      StrCat(@msgBuf "\n")
	   	  StrCat(@msgBuf "   fileName ")
          StrCat(@msgBuf "\"")
	      StrCat(@msgBuf fileName)
          StrCat(@msgBuf "\"")
	      StrCat(@msgBuf "\n")
	     
	      StrCat(@msgBuf "   soundClass ")
	      StrCat(@msgBuf soundClass)
	      StrCat(@msgBuf "\n")
	   )
  
	   (if( == STRINGS_EQUAL StrCmp(command "stop") or == STRINGS_EQUAL StrCmp(command "change")) 
    
	      StrCat(@msgBuf "   command stop")
	      StrCat(@msgBuf "\n")
       
	      (if(<> fileName -111)
	      	 StrCat(@msgBuf "   fileName ")
             StrCat(@msgBuf "\"")
	      	 StrCat(@msgBuf fileName)
             StrCat(@msgBuf "\"")
	      	 StrCat(@msgBuf "\n")	
		  )(else
	      	 StrCat(@msgBuf "   soundClass ")
	      	 StrCat(@msgBuf soundClass)
	      	 StrCat(@msgBuf "\n")		  	
		  )
	   )
	   
	   (if(<> volume -111)
	      StrCat(@msgBuf "   volume ")
	      StrCat(@msgBuf volume)
	      StrCat(@msgBuf "\n")	   	
	   ) 

	   (if(<> fadeInMillisecs -111)
	      StrCat(@msgBuf "   fadeInMillisecs ")
	      StrCat(@msgBuf fadeInMillisecs)
	      StrCat(@msgBuf "\n")	   	
	   ) 	   

	   (if(<> fadeOutMillisecs -111)
	      StrCat(@msgBuf "   fadeOutMillisecs ")
	      StrCat(@msgBuf fadeOutMillisecs)
	      StrCat(@msgBuf "\n")	   	
	   ) 	   

	   (if(<> loopFadeInMillisecs -111)
	      StrCat(@msgBuf "   loopFadeInMillisecs ")
	      StrCat(@msgBuf loopFadeInMillisecs)
	      StrCat(@msgBuf "\n")	   	
	   ) 	   

	   (if(<> loopFadeOutMillisecs -111)
	      StrCat(@msgBuf "   loopFadeOutMillisecs ")
	      StrCat(@msgBuf loopFadeOutMillisecs)
	      StrCat(@msgBuf "\n")	   	
	   ) 	   
	   
	   (if(<> loopCount -111)
	      StrCat(@msgBuf "   loopCount ")
	      StrCat(@msgBuf loopCount)
	      StrCat(@msgBuf "\n")	   	
	   ) 	   
  
       StrCat(@msgBuf ")")
	   
	   (if(<> conductorFile -111)
	   	   (if( <> NULL (= hFile FOpen(conductorFile fCREATE)) )
			FPuts(hFile @msgBuf)
			FClose(hFile)
	       ) 
	   )(else
	   	   (if( <> NULL (= hFile FOpen("sciAudio\\command.con" fCREATE)) )
			FPuts(hFile @msgBuf)
			FClose(hFile)
	       ) 	   	
	   )

	   	
	)
)
