DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION SoundCard$ ()
DECLARE FUNCTION SoundCardType% ()
DECLARE FUNCTION MIDIErrorOccured% ()
DECLARE FUNCTION MusicDone% ()
DECLARE FUNCTION MIDITime! ()

DECLARE SUB PlayMIDI ()

DECLARE FUNCTION CurrentMIDI$ (Switch%)

'$INCLUDE: 'vbdos.bi'

DECLARE SUB getLastUsed (x%)
DECLARE SUB omap (x%, y%, result%)
DECLARE SUB multikey (T%, result%)
DECLARE SUB getSingleKey (x%)
DECLARE SUB mtkinkey (x$)
DECLARE SUB particleweather (allblend%())
DECLARE SUB ParticleRender (allblend%())
DECLARE SUB particlesnow ()
DECLARE SUB setObjectShadow (x%)
DECLARE SUB fullredraw ()
DECLARE SUB battlebox ()

DECLARE SUB Script (BYVAL scriptno%)
DECLARE SUB sortobjects ()
DECLARE SUB gLOAD (x%)
DECLARE SUB objectbehave (objects%(), People() AS ANY)
DECLARE SUB xcls (pag%)
DECLARE SUB getpalette (l%, R%, g%, b%)
DECLARE SUB palatte (colr%, R%, g%, b%)
DECLARE SUB ParticleBehave ()
DECLARE SUB ParticleClip ()
DECLARE SUB ParticleRandomGenerator (colr%, ParticleType%)
DECLARE SUB moveobject (psprite%, MinorX%, MinorY%)
DECLARE SUB nocdmoveobject (psprite%, MinorX!, MinorY!)
DECLARE SUB pageflip ()
DECLARE SUB transbox (firstx%, lastx%, FirstY%, lasty%)
DECLARE FUNCTION wordwrap$ (line$, length%)
DECLARE SUB digitalJstk (up%, down%, left%, right%, but%())
DECLARE SUB putd (sx%, sy%, colr%)
DECLARE FUNCTION GetParameter2$ (commst$, x%)
DECLARE SUB xsprint (row%, column%, text$, colr%)
DECLARE SUB ConsoleMSG (message$)
DECLARE SUB drawall ()
DECLARE SUB MoveTransition ()
DECLARE SUB MoveWater ()
DECLARE SUB renderobjects ()
DECLARE SUB RenderObjectShadows ()

DECLARE SUB xINPUT (strg$, row%, colr%)
DECLARE SUB deinit ()
DECLARE SUB getpal ()
DECLARE SUB StopMidi ()
DECLARE SUB UnloadMIDI ()
DECLARE SUB showpage (page%)
DEFINT A-Z
DECLARE SUB dialogbox (ison%)
DECLARE SUB LoopMIDI ()
DECLARE SUB sprint (row%, text$, colr%)
COMMON SHARED SBMIDI, SBSIM, Segment&, BasePort, IRQ, DMA, CARDTYPE
COMMON SHARED MIDILoaded, MIDIPlaying, LastError, RevStereo, CurMIDI$
COMMON SHARED TimeMIDI AS SINGLE, PauseTime AS SINGLE, DetectSettingsCalled

DIM SHARED cbuffer$(1 TO 10)

	TYPE Player
	  hp AS LONG
	  mp AS LONG
	  maxhp AS LONG
	  maxmp AS LONG
	  time AS INTEGER
	  speed AS INTEGER
	  speedmod AS INTEGER
	  attack AS INTEGER
	  defence AS INTEGER
	  dead AS INTEGER
	  exists AS INTEGER
	  sname AS STRING * 7
	  ready AS INTEGER
	  Experience AS DOUBLE
	  level AS INTEGER
	  gold AS LONG
	  maxspells AS INTEGER
	  sprite AS INTEGER
	END TYPE

TYPE Person
	up(1 TO 3) AS INTEGER
	down(1 TO 3) AS INTEGER
	left(1 TO 3) AS INTEGER
	right(1 TO 3) AS INTEGER
	special(1 TO 3) AS INTEGER
	upbattle(1)  AS INTEGER
	downbattle(1)  AS INTEGER
	leftbattle(1)  AS INTEGER
	rightbattle(1) AS INTEGER

	upslash(1)  AS INTEGER
	downslash(1)  AS INTEGER
	leftslash(1)  AS INTEGER
	rightslash(1) AS INTEGER

	battleslash(1) AS INTEGER

	END TYPE

DEFINT A-Z

SUB battlebox ()

transbox 1, 319, 160, 240
END SUB

SUB console (page%, objects(), People() AS Person, cbuffer$())
showpage page


DIM SelectBuffer AS STRING

 dialogbox 1

sprint 14, cbuffer$(9), 1
sprint 15, cbuffer$(8), 1
sprint 16, cbuffer$(7), 1
sprint 17, cbuffer$(6), 1
sprint 18, cbuffer$(5), 1


15000

ConsoleMSG ""
'The same as sleep...almost.
xINPUT SelectBuffer, 13, 0
 cbuffer$(10) = SelectBuffer
cbuffer$(5) = cbuffer$(6)
cbuffer$(6) = cbuffer$(7)
cbuffer$(7) = cbuffer$(8)
cbuffer$(8) = cbuffer$(9)
cbuffer$(9) = cbuffer$(10)

SelectBuffer = LCASE$(LTRIM$(RTRIM$(SelectBuffer)))

SELECT CASE GetParameter2$(SelectBuffer, 1)
CASE "usejoystick"
	UseJoystick = VAL(GetParameter2$(SelectBuffer, 2))

CASE "trans"
	chce% = VAL(GetParameter2$(SelectBuffer, 2))
	'TransPoff
	TransPoff = chce%
	ConsoleMSG "Transparancy variable set to" + STR$(chce%)
CASE "script"
	lin% = VAL(MID$(SelectBuffer, 7))
	Script lin%
	ConsoleMSG "Finished script" + STR$(lin%)


CASE "exit"
	GOTO 15001


CASE "fps"
	DIM oldmanstimer AS DOUBLE
	oldmanstimer = TIMER
	FOR frames = 1 TO 200
	sprint 0, "frames" + STR$(frames), 1
	   
	'rendering and movement for this test.
	objectbehave objects(), People()'checks to see what the objects should be doing.
	flippedpvpvary% = -pvpvary
	flippedpvpvarx% = -pvpvarx
	  
	RenderFirstY% = flippedpvpvary% \ 20
	RenderSecondY% = (flippedpvpvary% + 240) \ 20
	RenderFirstX% = flippedpvpvarx% \ 20
	RenderSecondX% = (flippedpvpvarx% + 320) \ 20
	   
	drawall                'Draws everything on the screens background.
	IF ObjectShadows = 1 THEN RenderObjectShadows
	renderobjects          'Draws the objects (people & stuff)
	NEXT frames
	   
	dialogbox 1
	ConsoleMSG "Refresh on 200 frames calculated."
	ConsoleMSG "FPS:" + STR$(200 / (TIMER - oldmanstimer))

CASE "quit"
	deinit
CASE "objectshadows"
  setObjectShadow VAL(GetParameter2$(SelectBuffer, 2))

CASE ELSE
	IF SelectBuffer <> "" THEN
		ConsoleMSG "Unknown Command -- " + SelectBuffer
	END IF
END SELECT


sprint 14, cbuffer$(9), 1
sprint 15, cbuffer$(8), 1
sprint 16, cbuffer$(7), 1
sprint 17, cbuffer$(6), 1
sprint 18, cbuffer$(5), 1

GOTO 15000

15001
END SUB

SUB ctrlslp ()
	DIM button(4) AS INTEGER


	'This waits until you release the button before asking if you've
	'pressed the button. :)
	digitalJstk up, down, left, right, button()
	WHILE (button(1))
		digitalJstk up, down, left, right, button()
	WEND




	digitalJstk up, down, left, right, button()

	waiting = 1



	'This will wait under all circumstances.
	WHILE (waiting = 1)
	   getSingleKey ke%
	IF ke% THEN waiting = 0
	digitalJstk up, down, left, right, button()
	
	FOR a = 1 TO 4
	 IF button(a) THEN waiting = 0
	NEXT a



	WEND

	'it's crazy, but it just might work



END SUB

FUNCTION CurrentMIDI$ (Switch)
'----------------------------------------------------------------------------
' Returns the name of the MIDI currently loaded. If no MIDI is loaded, it'll
' return a null string and MIDI error 7. If switch is 0, the full filename is
' returned, otherwise the filename is returned in DOS 8:3 format.
'----------------------------------------------------------------------------

	IF MIDILoaded = False THEN LastError = 4: EXIT FUNCTION

	SELECT CASE Switch
	CASE 0: CurrentMIDI$ = CurMIDI$
	CASE ELSE
		FOR I = LEN(CurMIDI$) TO 1 STEP -1: IF MID$(CurMIDI$, I, 1) = "\" OR MID$(CurMIDI$, I, 1) = ":" THEN EXIT FOR
		NEXT: I = I + 1: CurrentMIDI$ = MID$(CurMIDI$, I)
	END SELECT

	LastError = 0

END FUNCTION

SUB deinit ()

CLOSE


SCREEN 13: SCREEN 0: WIDTH 80
END

END SUB

STATIC SUB DetectDrivers ()
'----------------------------------------------------------------------------
' Detects whether the SBMIDI and SBSIM drivers are present, and locates their
' IRQ numbers.
'----------------------------------------------------------------------------
EXIT SUB
	DIM MIDIRegs AS RegTypeX

	SBMIDI = 0: SBSIM = 0

	FOR I = &H80 TO &H8F ' Only &H80 to &H8F are searched as it's unlikely
			 ' the driver will be outside this range.

	' Get the Segment and Offset of the Interrupt code
	MIDIRegs.ax = I + 13568: CALL INTERRUPTX(&H21, MIDIRegs, MIDIRegs): Segment& = MIDIRegs.es: Offset& = MIDIRegs.bx
	IF Segment& = 0 THEN GOTO Skip

	' Check for SBMIDI
	IF SBMIDI = 0 THEN DEF SEG = Segment& - 17: temp$ = "": FOR j = 1 TO 6: temp$ = temp$ + CHR$(PEEK(271 + j)): NEXT: IF temp$ = "SBMIDI" THEN SBMIDI = I

	' Check for SBSIM
	IF SBSIM = 0 AND Segment& <> 0 THEN DEF SEG = Segment& - 1: temp$ = "": FOR j = 1 TO 5: temp$ = temp$ + CHR$(PEEK(274 + j)): NEXT: IF temp$ = "SBSIM" THEN SBSIM = I

Skip:
	NEXT I

	IF SBMIDI = 0 THEN PRINT "There will be no sound during this session because SBMIDI is not loaded.": PRINT "Press any key to continue.": SLEEP

END SUB

STATIC SUB DetectSettings ()
'----------------------------------------------------------------------------
' Checks the BLASTER environment variable to check whether a sound card
' exists, and its settings.
'----------------------------------------------------------------------------
EXIT SUB
	DetectSettingsCalled = True: BasePort = 0: IRQ = 0: DMA = 0: CARDTYPE = 0: Settings$ = ENVIRON$("BLASTER")

	FOR I = 1 TO LEN(Settings$) - 1
	SELECT CASE UCASE$(MID$(Settings$, I, 1))
		CASE "T": CARDTYPE = VAL(MID$(Settings$, I + 1, 1))
		CASE "A": BasePort = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I + 1, 3)))))
		CASE "I": IRQ = VAL(MID$(Settings$, I + 1, 2))
		CASE "D": DMA = VAL(MID$(Settings$, I + 1, 2))
	END SELECT
	NEXT I



END SUB

SUB DirectStick (x%, y%, But1%, But2%, But3%, but4%)
x = 0
y = 0
But1 = 1
But2 = 1
But3 = 1
but4 = 1

OUT &H201, 1


interm = INP(&H201)

WHILE interm AND 3
interm = INP(&H201)

 IF interm AND 1 THEN x% = x% + 1
 IF interm AND 2 THEN y = y + 1

WEND

IF interm AND 16 THEN But1 = 0
IF interm AND 32 THEN But2 = 0
IF interm AND 64 THEN But3 = 0
IF interm AND 128 THEN but4 = 0

END SUB

SUB drawgraph (x1%, y1%, leng%, maxval%, curval%, color1%, color2%)
 DIM LengthOfColor1 AS INTEGER

LengthOfColor1 = (leng% / maxval%) * curval%

FOR a% = x1% TO x1% + leng% - 1
  IF (a% - x1%) < LengthOfColor1 THEN col% = color2% ELSE col% = color1%
  putd a%, y1%, col%
  putd a%, y1% + 1, col%
  putd a%, y1% + 2, col%
  putd a%, y1% + 3, col%
  putd a%, y1% + 4, col%

NEXT a%

END SUB

SUB fullscrpic (Filename$, page%, bitmask%())


xcls page%
	 SELECT CASE page
		CASE 0: VidSegment% = &HA000
		CASE 1: VidSegment% = &HA4F0
		CASE 2: VidSegment% = &HA9E0
		CASE ELSE:  ERROR 5
	 END SELECT

	DEF SEG = VidSegment%



'SHARED bitmask%()
'This is a modified version of my drawall renderer, paired with a buffered read.

DIM po AS DOUBLE
DIM flno AS INTEGER
DIM ds%(0 TO 198)
flno = FREEFILE

OPEN LTRIM$(RTRIM$(Filename$)) FOR BINARY AS #flno
	  po = 2
FOR a = 0 TO 318
FOR b% = 0 TO 198
	po = po + 1
	GET #flno, po, ds%(b%)
	IF ds%(b) = 0 THEN ds%(b%) = 16
NEXT b

sy% = a \ 4
OUT &H3C5, bitmask%(a% AND 3)
FOR b = 0 TO 198
	sy% = sy% + 80
	POKE sy%, ds%(b)

NEXT b
NEXT a

CLOSE flno


END SUB

FUNCTION GetParameter2$ (commst$, x%)
Realcommst$ = LTRIM$(RTRIM$(commst$))
IF x% < 1 THEN x% = 1
FOR b% = 1 TO x%
  vin = INSTR(1, LTRIM$(RTRIM$(Realcommst$)), " ")
  IF vin = 0 THEN vin = 1: GetReadyToEnd = -1
  IF b% < x% THEN Realcommst$ = MID$(LTRIM$(RTRIM$(Realcommst$)), vin)
  IF GetReadyToEnd THEN
	GetParameter2$ = LTRIM$(RTRIM$(Realcommst$))
	EXIT FUNCTION
  END IF
NEXT b%
GetParameter2$ = LTRIM$(RTRIM$(LEFT$(Realcommst$, vin)))
END FUNCTION

SUB HealingTargetSelect (objects%(), players() AS Player, decision%)
DIM button(4) AS INTEGER
LeftKey$ = CHR$(0) + CHR$(75)
RightKey$ = CHR$(0) + CHR$(77)
UpKey$ = CHR$(0) + CHR$(72)
Downkey$ = CHR$(0) + CHR$(80)
BackKey$ = CHR$(27)
notchosen = -1
T% = 1

'gives you time to release the button!
digitalJstk up, down, left, right, button()

WHILE (button(1))
	digitalJstk up, down, left, right, button()
WEND



WHILE (notchosen)
	'Read the input and empty the buffer.
mtkinkey key$
	'more of that lovely hacking!
	digitalJstk up, down, left, right, button()
	IF up THEN key$ = UpKey$
	IF down THEN key$ = Downkey$
	IF left THEN key$ = LeftKey$
	IF right THEN key$ = RightKey$

	IF button(1) THEN key$ = " "
	IF button(4) THEN key$ = BackKey$


	'**First, we see where the user *wants* to go.
	SELECT CASE key$
		CASE " " ' space.
		 notchosen = 0
		CASE Downkey$
		T% = T% - 1
		dn% = 1
		CASE UpKey$
		T% = T% + 1
		CASE RightKey$
		T% = T% - 1
		dn% = 1
		CASE LeftKey$
		T% = T% + 1
		CASE CHR$(8)'Backspace(why not?).

		 'mirror the next one.
		 objects(137, 1) = 0
		 objects(137, 2) = 0
		 objects(137, 3) = 0
		 objects(137, 4) = 0
		 objects(137, 5) = 0


		 decision = 0
		 EXIT SUB
		CASE BackKey$

		 objects(137, 1) = 0
		 objects(137, 2) = 0
		 objects(137, 3) = 0
		 objects(137, 4) = 0
		 objects(137, 5) = 0

		 decision = 0
		 EXIT SUB

		'return 0, exit sub, tell other sub not to do anything.
		'And don't remove the players built up time.

	END SELECT
		IF T% = 0 THEN T% = 3
		IF T% = 4 THEN T% = 1

	'If the enemy doesn't exist there, keep shifting to find one.
	IF dn% = 0 THEN
	 WHILE players(T%).dead = 1
	  T% = T% + 1
	  IF T% = 4 THEN T% = 1
	 WEND
	ELSE

	 WHILE players(T%).dead = 1
	  T% = T% - 1
	  IF T% = 0 THEN T% = 3
	 WEND
	END IF

  'Pointer:Everywhere you want to be :)
  objects(137, 1) = objects(players(T%).sprite, 1)
  objects(137, 2) = objects(players(T%).sprite, 2)
  objects(137, 3) = 47
  objects(137, 4) = objects(players(T%).sprite, 4)
  objects(137, 5) = objects(players(T%).sprite, 5)

  fullredraw
  battlebox
  pageflip



WEND
	'Reseting the pointer object (we'll need it!)
	'and getting out of this sub.
objects(137, 1) = 0
objects(137, 2) = 0
objects(137, 3) = 0
objects(137, 4) = 0
objects(137, 5) = 0
decision = T%


END SUB

STATIC SUB LoadMidi (Filename$)

END SUB

STATIC SUB LoopMIDI ()
END SUB

FUNCTION MIDIError$ ()
'----------------------------------------------------------------------------
' Returns an error message generated by the MIDI functions.
'----------------------------------------------------------------------------

	SELECT CASE LastError
	CASE &H0: MIDIError$ = "Operation Successful."
	CASE &H1: MIDIError$ = "The SBMIDI Driver has not be detected."
	CASE &H2: MIDIError$ = "The BLASTER environment variable is not set."
	CASE &H3: MIDIError$ = "DetectSettings has not been called."
	CASE &H4: MIDIError$ = "A MIDI file has not been loaded."
	CASE &H5: MIDIError$ = "A MIDI file is already playing."
	CASE &H6: MIDIError$ = "No MIDI file is playing."
	CASE &H7: MIDIError$ = "The file could not be found."
	CASE &H8: MIDIError$ = "There was insufficient memory to complete the operation."
	CASE &H9: MIDIError$ = "The MIDI is not paused."
	CASE &HA: MIDIError$ = "Your Sound card does not support volume alteration."
	CASE &HB: MIDIError$ = "Support for older sound cards not yet included."
	CASE &HC: MIDIError$ = "Path not found."
	CASE &HD: MIDIError$ = "No filename supplied."
	CASE &HD: MIDIError$ = "A value is out of the valid range."
	CASE &HF: MIDIError$ = "Unknown error."
	END SELECT

END FUNCTION

FUNCTION MIDIErrorOccured ()
'----------------------------------------------------------------------------
' Returns error number if an error has occured, otherwise FALSE.
'----------------------------------------------------------------------------

	IF LastError <> 0 THEN MIDIErrorOccured = LastError ELSE MIDIErrorOccured = 0

END FUNCTION

FUNCTION MIDITime! ()
'----------------------------------------------------------------------------
' Returns the length of time the MIDI has been playing in seconds.
' Returns -1 if no MIDI is playing.
'----------------------------------------------------------------------------
'    IF MIDIPlaying = 1 THEN
'    MIDITime! = PauseTime
'    ELSEIF TimeMIDI >= 0 THEN
'    CurrentTime! = TIMER
'    IF CurrentTime! - TimeMIDI < 0 THEN CurrentTime! = 86400 + CurrentTime!
'    MIDITime! = CurrentTime! - TimeMIDI
'    ELSE
'    LastError = 6
'    MIDITime! = -1
'    END IF
END FUNCTION

STATIC FUNCTION MusicDone ()
'----------------------------------------------------------------------------
' Checks whether the MIDI has finished.
'----------------------------------------------------------------------------

	IF CARDTYPE = 0 AND DetectSettingsCalled THEN LastError = 2: EXIT FUNCTION
	IF CARDTYPE = 0 AND NOT DetectSettingsCalled THEN LastError = 3: EXIT FUNCTION
	IF SBMIDI = 0 THEN LastError = 1: EXIT FUNCTION
	IF MIDILoaded = False THEN LastError = 4: EXIT FUNCTION
	IF MIDIPlaying = False THEN LastError = 6: EXIT FUNCTION

	DIM MIDIRegs AS RegTypeX

	MIDIRegs.bx = 11: INTERRUPTX SBMIDI, MIDIRegs, MIDIRegs: IF MIDIRegs.ax = 0 THEN MusicDone = -1 ELSE MusicDone = 0

	LastError = 0

END FUNCTION

SUB objectbehave (objects%(), People() AS Person)

FOR a% = -100 TO 140
WHILE (objects(a%, 7) = 0) AND a% < 140
 a = a + 1
WEND

IF a% = 140 THEN EXIT FOR

SELECT CASE objects(a%, 7)
	CASE 60 'the "headbanger" prose. :P
	 IF objects(a%, 9) = 0 THEN
		objects%(a%, 3) = objects%(a%, 3) + 1
		objects(a%, 9) = 30'15 + INT(RND(1) * 30)
	 END IF
	 IF objects(a%, 9) = 15 THEN
		objects%(a%, 3) = objects%(a%, 3) - 1
	 END IF

	 objects(a%, 9) = objects(a%, 9) - 1
	CASE 100 'was a wait.Now it's follow the selected character like a lostdog

'(Spritenumber%, Sprite2number%, Shift%)

	Spritenumber% = a%
	Sprite2number% = objects(a%, 8)

	sssss% = Spritenumber%


	IF Spritenumber% >= 1 AND Spritenumber% <= 3 THEN KKJ% = Spritenumber%
	IF Sprite2number% >= 1 AND Sprite2number% <= 3 THEN KKJ% = Sprite2number%

	DIM slopex AS SINGLE
	DIM slopey AS SINGLE

	'DIM steps AS INTEGER
	DIM Xone AS SINGLE
	DIM Yone AS SINGLE
	DIM Xtwo AS SINGLE
	DIM Ytwo AS SINGLE

	Xone = (objects(Spritenumber%, 1) * 20) + objects(Spritenumber%, 4) - 10
	Yone = (objects(Spritenumber%, 2) * 20) + objects(Spritenumber%, 5) - 10

	Xtwo = (objects(Sprite2number%, 1) * 20) + objects(Sprite2number%, 4) - 10
	Ytwo = (objects(Sprite2number%, 2) * 20) + objects(Sprite2number%, 5) + Shift% - 10



	'steps = (ABS(Xone - Xtwo) + ABS(Yone - Ytwo)) \ 10


	'steps = (ABS(Xone - Xtwo) + ABS(Yone - Ytwo)) \ 10
	 pdistance = ((ABS(Xone - Xtwo) ^ 2) + (ABS(Yone - Ytwo) ^ 2)) ^ .5





	slopex = (Xtwo - Xone) / 20
	slopey = (Ytwo - Yone) / 20


	 'hehehe! walking sprites for the second guy!!!
	 '(am I evil? YES I AM!!!)
	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0


	IF pdistance > 30 THEN

	IF ABS(slopex) > ABS(slopey) THEN
	  IF slopex > 0 THEN
	   objects(a%, 3) = People(objects(a%, 10)).left(x)

	  END IF
	  IF slopex < 0 THEN

	   objects(a%, 3) = People(objects(a%, 10)).right(x)


	  END IF
	END IF


	IF ABS(slopey) > ABS(slopex) THEN

	  IF slopey > 0 THEN
	   objects(a%, 3) = People(objects(a%, 10)).down(x)

	  END IF
	  IF slopey < 0 THEN

	   objects(a%, 3) = People(objects(a%, 10)).up(x)


	  END IF




	END IF






		nocdmoveobject sssss%, slopex, slopey


	IF ABS(Xtwo - Xone) < 20 THEN
	   IF ABS(Xtwo - Xone) <> 0 THEN

		IF (Xtwo - Xone) > 0 THEN
		 nocdmoveobject sssss%, 1, 0
		END IF

		IF (Xtwo - Xone) < 0 THEN
		 nocdmoveobject sssss%, -1, 0
		END IF


	   END IF


	END IF

	IF ABS(Ytwo - Yone) < 20 THEN
	   IF ABS(Ytwo - Yone) <> 0 THEN

		IF (Ytwo - Yone) > 0 THEN
		 nocdmoveobject sssss%, 0, 1
		END IF

		IF (Ytwo - Yone) < 0 THEN
		 nocdmoveobject sssss%, 0, -1
		END IF


	   END IF


	END IF


	END IF




	CASE 6
	'Person walking. Up variation.

	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	moveobject a%, 0, -2

		objects%(a%, 3) = People(objects(a%, 10)).up(x)


	CASE 7
	'Person walking. down variation.


	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	IF objects(a%, 3) <> People(objects(a%, 10)).down(1) OR objects(a%, 3) <> People(objects(a%, 10)).down(2) THEN
		objects(a%, 3) = People(objects(a%, 10)).down(1)
	END IF

	moveobject a%, 0, 2

	objects%(a%, 3) = People(objects(a%, 10)).down(x)

	CASE 8
	'Person walking. left variation.



	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	 moveobject a%, -2, 0

	 objects%(a%, 3) = People(objects(a%, 10)).left(x)




	CASE 9
	'Person walking. right variation.



	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0


	moveobject a%, 2, 0

	objects%(a%, 3) = People(objects(a%, 10)).right(x)
	CASE 10
	'Person walking. Up/left variation.

	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	moveobject a%, -2, -2

		objects%(a%, 3) = People(objects(a%, 10)).left(x)


	CASE 11
	'Person walking. up/right variation.


	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	IF objects(a%, 3) <> People(objects(a%, 10)).right(1) OR objects(a%, 3) <> People(objects(a%, 10)).down(2) THEN
		objects(a%, 3) = People(objects(a%, 10)).right(1)
	END IF

	moveobject a%, 2, -2

		objects%(a%, 3) = People(objects(a%, 10)).right(x)

	CASE 12
	'Person walking. down/left variation.



	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0

	 moveobject a%, -2, 2

	 objects%(a%, 3) = People(objects(a%, 10)).left(x)




	CASE 13
	'Person walking. down/right variation.



	 objects(a%, 9) = objects(a%, 9) + 1

	 IF objects(a%, 9) < 10 THEN x = 1 ELSE x = 2
	 IF objects(a%, 9) > 20 THEN objects(a%, 9) = 0



	 moveobject a%, 2, 2

	 objects%(a%, 3) = People(objects(a%, 10)).right(x)


	CASE -1 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns.
			IF objects(a%, 10) = 0 THEN objects(a%, 10) = objects(a%, 3)

	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 1, 0
		  getLastUsed x

		 IF x THEN
		   objects(a%, 9) = 30
		   objects(a%, 3) = objects(a%, 10) + 1
	  
		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, -1, 0
		  getLastUsed x

		  IF x THEN
			   objects(a%, 3) = objects(a%, 10)

		   objects(a%, 9) = -30


		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF

	CASE -2 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns.
	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 0, 1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = 30

		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, 0, -1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = -30

		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF

	CASE -1 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns.
	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 1, 0
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = 30
		   objects(a%, 3) = objects(a%, 3) + 1


		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, -1, 0
		  getLastUsed x

		  IF x THEN
		   objects(a%, 3) = objects(a%, 3) - 1
		   objects(a%, 9) = -30

		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF

	CASE -2 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns.
	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 0, 1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = 30

		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, 0, -1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = -30

		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF
	CASE -11 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns. Sight active.
	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 1, 0
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = 30

		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, -1, 0
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = -30

		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF

	CASE -12 'Negatives will be AI behaviours.
			'This is at least part of the patrol behaviour.
			'left/right patrol, 90 degree turns, sight active.
	 IF objects(a%, 9) = 0 THEN
		  moveobject a%, 0, 1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = 30

		 END IF
	 END IF

	 IF objects(a%, 9) = 1 THEN
		  moveobject a%, 0, -1
		  getLastUsed x

		  IF x THEN

		   objects(a%, 9) = -30

		 END IF
	 END IF

	  IF objects(a%, 9) > 1 THEN
		objects(a%, 9) = objects(a%, 9) - 1

	  END IF
	  IF objects(a%, 9) < 0 THEN
		objects(a%, 9) = objects(a%, 9) + 1

	  END IF

END SELECT

NEXT a%



END SUB

SUB particlerain (allblend%())
		ParticleRandomGenerator -1, 2
		ParticleBehave
		ParticleClip
		ParticleRender allblend()

END SUB

SUB particlesnow ()
		DIM allblend%(0 TO 255)
		ParticleRandomGenerator 31, 1
		ParticleBehave
		ParticleClip
		ParticleRender allblend()

END SUB

STATIC SUB PauseMIDI ()
END SUB

STATIC SUB PlayMIDI ()

END SUB

SUB pwait (a!)
DIM oldtimer AS DOUBLE
oldtimer = TIMER

WHILE oldtimer + a! > TIMER: WEND

END SUB

STATIC SUB ResumeMIDI ()
'----------------------------------------------------------------------------
' Resumes the playing of a paused MIDI.
'----------------------------------------------------------------------------

	IF CARDTYPE = 0 AND DetectSettingsCalled THEN LastError = 2: EXIT SUB
	IF CARDTYPE = 0 AND NOT DetectSettingsCalled THEN LastError = 3: EXIT SUB
	IF SBMIDI = 0 THEN LastError = 1: EXIT SUB
	IF MIDILoaded = False THEN LastError = 4: EXIT SUB
	IF MIDIPlaying <> 1 THEN LastError = 9: EXIT SUB

	DIM MIDIRegs AS RegTypeX

	MIDIRegs.bx = 8: INTERRUPTX SBMIDI, MIDIRegs, MIDIRegs

	TimeMIDI = TIMER - PauseTime: PauseTime = 0
	MIDIPlaying = True
	LastError = 0

END SUB

 SUB set320x240mode ()
 'begin with standard 320x200x256 mode
 SCREEN 13
 CLS





 'disable "chain4" mode
 OUT &H3C4, &H4: OUT &H3C5, &H6
 'enable writes to all four planes
 OUT &H3C4, &H2: OUT &H3C5, &HF
 'clear video memory

 'synchronous reset while switching clocks
 OUT &H3C4, 0: OUT &H3C5, &H1
 'select 25 Mhz dot clock and 60 hz scanning rate
 OUT &H3C2, &HE3
 'restart the sequencer
 OUT &H3C4, 0: OUT &H3C5, &H3
 'to reprogram the CRT controller,
 'remove write protect from the registers
 OUT &H3D4, &H11: OUT &H3D5, INP(&H3D5) AND &H7F
 OUT &H3D4, &H6: OUT &H3D5, &HD     'total vertical pixels
 OUT &H3D4, &H7: OUT &H3D5, &H3E    'overflow
 OUT &H3D4, &H9: OUT &H3D5, &H41    'turn off double double-scan
 OUT &H3D4, &H10: OUT &H3D5, &HEA   'vertical sync start
 OUT &H3D4, &H11: OUT &H3D5, &HAC   'vertical sync end, reprotect registers
 OUT &H3D4, &H12: OUT &H3D5, &HDF   'vertical pixels displayed
 OUT &H3D4, &H14: OUT &H3D5, 0      'turn off dword mode
 OUT &H3D4, &H15: OUT &H3D5, &HE7   'vertical blank start
 OUT &H3D4, &H16: OUT &H3D5, &H6    'vertical blank end
 OUT &H3D4, &H17: OUT &H3D5, &HE3   'turn on byte mode


 'in an attempt to get this working on a TV, I've moved these here.

 OUT &H3C4, 2 'Whatever this is, it kicks ass against bugs!
 OUT &H3CE, 4 'This may be another of those routines that can be called once.
'Update: The above appears to set the EGA registers for a read from each
'plane. That would explain why it's needed only once.


 'Update: The above line appears to set the EGA registers to write.
 'Whatever that means, it sounds like I can do it once without problems.

' OUT &H3CE, 4 'This may be another of those routines that can be called once.
'Update: The above appears to set the EGA registers for a read from each
'plane. That would explain why it's needed only once.

 getpal 'This gets the pallette saved from a file.
 xcls 0
 xcls 1
 xcls 2

 END SUB

 SUB showpage (page%)
 SELECT CASE page%                          '0,&H4F, &H9E
	 CASE 0: OUT &H3D4, &HC: OUT &H3D5, 0
	 CASE 1: OUT &H3D4, &HC: OUT &H3D5, &H4F
	 CASE 2: OUT &H3D4, &HC: OUT &H3D5, &H9E
	 CASE ELSE: ERROR 5          'illegal function call
 END SELECT
 END SUB

STATIC SUB showText (words$, shadowdrop, allblend())
DIM line1$, line2$, line3$, line4$, line5$

	line1$ = wordwrap$(words$, 43)
	line2$ = wordwrap$(words$, 43)
	line3$ = wordwrap$(words$, 43)
	line4$ = wordwrap$(words$, 43)
	line5$ = wordwrap$(words$, 43)
	DIM buttons(4) AS INTEGER


	DIM oldtimer AS SINGLE

	DIM sEmpty AS STRING
	DIM waittime AS DOUBLE


	   a = 1
	   WHILE a <= LEN(line1$)

		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1 THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240

					 LoopMIDI
  sEmpty = MID$(line1$, 1, a)

		shadowdrop% = 1

		 sprint 14, sEmpty, 16

		shadowdrop% = 0

		 sprint 14, sEmpty, 0

  waiter = 0: a = a + 3
  WEND

	   a = 1
	   WHILE a <= LEN(line2$)

		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1  THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240
		shadowdrop% = 1
		 sprint 14, line1$, 16
		shadowdrop% = 0
		 sprint 14, line1$, 0

					 LoopMIDI
  sEmpty = MID$(line2$, 1, a)

		shadowdrop% = 1

		 sprint 15, sEmpty, 16

		shadowdrop% = 0

		 sprint 15, sEmpty, 0

  waiter = 0: a = a + 3

  WEND

	   a = 1
	   WHILE a <= LEN(line3$)
		IF waiter >= waittime THEN a = a + 1: waiter = 0
		waiter = waiter + 1

		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1 THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240
		shadowdrop% = 1
		 sprint 14, line1$, 16
		shadowdrop% = 0
		 sprint 14, line1$, 0
		shadowdrop% = 1
		 sprint 15, line2$, 16
		shadowdrop% = 0
		 sprint 15, line2$, 0

					 LoopMIDI
  sEmpty = MID$(line3$, 1, a)

		shadowdrop% = 1

		 sprint 16, sEmpty, 16

		shadowdrop% = 0

		 sprint 16, sEmpty, 0

  digitalJstk dummy%, dummy%, dummy%, dummy%, buttons()

  getSingleKey I
   waiter = 0: a = a + 3

  WEND

		a = 1
	   WHILE a <= LEN(line4$)
		IF waiter >= waittime THEN a = a + 1: waiter = 0
		waiter = waiter + 1

		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1 THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240
		shadowdrop% = 1
		 sprint 14, line1$, 16
		shadowdrop% = 0
		 sprint 14, line1$, 0
		shadowdrop% = 1
		 sprint 15, line2$, 16
		shadowdrop% = 0
		 sprint 15, line2$, 0
		shadowdrop% = 1
		 sprint 16, line3$, 16
		shadowdrop% = 0
		 sprint 16, line3$, 0

					 LoopMIDI
  sEmpty = MID$(line4$, 1, a)

		shadowdrop% = 1

		 sprint 17, sEmpty, 16

		shadowdrop% = 0

		 sprint 17, sEmpty, 0

   waiter = 0: a = a + 3

  WEND


	   a = 1
	   WHILE a <= LEN(line5$)
		IF waiter >= waittime THEN a = a + 1: waiter = 0
		waiter = waiter + 1

		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1 THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240
		shadowdrop% = 1
		 sprint 14, line1$, 16
		shadowdrop% = 0
		 sprint 14, line1$, 0
		shadowdrop% = 1
		 sprint 15, line2$, 16
		shadowdrop% = 0
		 sprint 15, line2$, 0
		shadowdrop% = 1
		 sprint 16, line3$, 16
		shadowdrop% = 0
		 sprint 16, line3$, 0
		shadowdrop% = 1
		 sprint 17, line4$, 16
		shadowdrop% = 0
		 sprint 17, line4$, 0

					 LoopMIDI
  sEmpty = MID$(line5$, 1, a)

		shadowdrop% = 1

		 sprint 18, sEmpty, 16

		shadowdrop% = 0

		 sprint 18, sEmpty, 0

   waiter = 0: a = a + 3

  WEND




END SUB

FUNCTION SoundCard$ ()
'----------------------------------------------------------------------------
' Returns the name of the sound card, eg. Sound Blaster 16/Sound Blaster Pro.
'----------------------------------------------------------------------------

	SELECT CASE CARDTYPE
	CASE -1: SoundCard$ = "DetectSettings has not been called."
	CASE 0: SoundCard$ = "No sound card detected"
	CASE 1: SoundCard$ = "Sound Blaster 1.0/1.5"
	CASE 2: SoundCard$ = "Sound Blaster Pro"
	CASE 3: SoundCard$ = "Sound Blaster 2.0"
	CASE 4, 5: SoundCard$ = "Sound Blaster Pro 2"
	CASE 6: SoundCard$ = "Sound Blaster 16/32/AWE32/AWE64"
	CASE ELSE: SoundCard$ = "Sound Card Unknown."
	END SELECT

END FUNCTION

FUNCTION SoundCardType ()
'----------------------------------------------------------------------------
' Returns the type number of the sound card (note: this is the same as the
' number after the 'T' in the BLASTER environment variable).
'----------------------------------------------------------------------------

	SoundCardType = CARDTYPE

END FUNCTION

SUB spal (R%, g%, b%)
'This function scrolls the entire built-in palette, which helps
'achieve kickass effects ;)
DIM rr AS SINGLE
DIM gg AS SINGLE
DIM bb AS SINGLE
rr = R%
gg = g%
bb = b%
FOR a% = 0 TO 255
	getpalette a%, Red, Green, Blue

	Red = Red + rr
	Green = Green + gg
	Blue = Blue + bb

	palatte a%, Red, Green, Blue
NEXT a%


END SUB

SUB startmenu () 'suprisingly, this isn't a sad attempt to copy a MS trademark.
'script 1
'loadchars
LeftKey$ = CHR$(0) + CHR$(75)
RightKey$ = CHR$(0) + CHR$(77)
UpKey$ = CHR$(0) + CHR$(72)
Downkey$ = CHR$(0) + CHR$(80)
BackKey$ = CHR$(27)

 notchosen = -1
 WHILE (notchosen)
 LoopMIDI

 getSingleKey keypress%

 SELECT CASE keypress%
  CASE 72 'up
   menuchoice = menuchoice - 1
  CASE 80    'dn
   menuchoice = menuchoice + 1
  CASE 57       'sp
   notchosen = False
 END SELECT

   'multikey 57, keycoden
   'IF keycoden THEN script 123: EXIT SUB


  IF menuchoice > 3 THEN menuchoice = 0

  IF menuchoice < 0 THEN menuchoice = 3
  xsprint 135, 125, "Start", (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 127, "Load", (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 115, "Controls", (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 127, "Exit", (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  pageflip


 WEND

 IF menuchoice = 0 THEN Script 123
 IF menuchoice = 1 THEN
  didntchoose = 0
  menuchoice = 0
  notchosen = -1'true
  WHILE NOT (INP(90) AND 128): WEND
  WHILE (notchosen)

  xsprint 135, 125, "Start", 19'(2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 127, "Load", 2'(2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 115, "Controls", 19'(2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 2))
  xsprint 180, 127, "Exit", 19'(2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 3))
  xsprint 135, 175, "Game 0", (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 175, "Game 1", (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 175, "Game 2", (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 175, "Game 3", (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 175, "Game 4", (2 * -(menuchoice = 4)) + (19 * -(menuchoice <> 4))
  pageflip

	 mtkinkey key$
	 
	 SELECT CASE key$
	  CASE UpKey$
	   menuchoice = menuchoice - 1
	  CASE Downkey$
	   menuchoice = menuchoice + 1
	  CASE " "
	   notchosen = False
	  CASE BackKey$
  xsprint 135, 175, "Game 0", 16' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 175, "Game 1", 16' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 175, "Game 2", 16' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 175, "Game 3", 16'(2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 175, "Game 4", 16'(2 * -(menuchoice = 4)) + (19 * -(menuchoice <> 4))
		   pageflip
  xsprint 135, 175, "Game 0", 16' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 175, "Game 1", 16' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 175, "Game 2", 16' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 175, "Game 3", 16'(2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 175, "Game 4", 16'(2 * -(menuchoice = 4)) + (19 * -(menuchoice <> 4))
		   pageflip
  xsprint 135, 175, "Game 0", 16' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 175, "Game 1", 16' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 175, "Game 2", 16' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 175, "Game 3", 16'(2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 175, "Game 4", 16'(2 * -(menuchoice = 4)) + (19 * -(menuchoice <> 4))

	   didntchoose = 1: notchosen = False
	 END SELECT
  IF menuchoice > 4 THEN menuchoice = 0

  IF menuchoice < 0 THEN menuchoice = 4



   WEND

 IF didntchoose = 0 THEN gLOAD menuchoice ELSE startmenu: EXIT SUB


 END IF

 IF menuchoice = 2 THEN
  waiting = 0

  WHILE (NOT waiting)
  xsprint 135, 125, "Start", 16'(2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 127, "Load", 16'(2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 115, "Controls", 16'(2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 2))
  xsprint 180, 127, "Exit", 16'(2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 3))
  xsprint 135, 15, "Arrow Keys:Movement", 31' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 15, "Spacebar:Activate", 31' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 15, "Backspace:Cancel(battles only)", 31' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 15, "Escape:Menu/cancel menu", 31' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 15, "Press Any Key.", 31' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))


								pageflip

  getSingleKey waiting

  WEND

  xsprint 135, 15, "Arrow Keys:Movement", 0' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 15, "Spacebar:Activate", 0' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 15, "Backspace:Cancel(battles only)", 0' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 15, "Escape:Menu/cancel menu", 0' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 15, "Press Any Key.", 16'31' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))


  pageflip
  xsprint 135, 15, "Arrow Keys:Movement", 0' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 15, "Spacebar:Activate", 0' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 15, "Backspace:Cancel(battles only)", 0' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 15, "Escape:Menu/cancel menu", 0' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 15, "Press Any Key.", 16'31' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))


  pageflip
  xsprint 135, 15, "Arrow Keys:Movement", 0' (2 * -(menuchoice = 0)) + (19 * -(menuchoice <> 0))
  xsprint 150, 15, "Spacebar:Activate", 0' (2 * -(menuchoice = 1)) + (19 * -(menuchoice <> 1))
  xsprint 165, 15, "Backspace:Cancel(battles only)", 0' (2 * -(menuchoice = 2)) + (19 * -(menuchoice <> 2))
  xsprint 180, 15, "Escape:Menu/cancel menu", 0' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))
  xsprint 195, 15, "Press Any Key.", 16'31' (2 * -(menuchoice = 3)) + (19 * -(menuchoice <> 3))




 END IF
 IF menuchoice = 2 THEN startmenu: EXIT SUB
 IF menuchoice = 3 THEN deinit

 xcls 0
 xcls 1
 xcls 2
END SUB

STATIC SUB StopMidi ()
CHAIN "slave stop" + " >> musicdebug.txt"
END SUB

SUB textwait (line1$, line2$, line3$, line4$, line5$, ObjectShadows%, allblend%())
	DIM button(4) AS INTEGER


	'This waits until you release the button before asking if you've
	'pressed the button. :)
	digitalJstk up, down, left, right, button()
	WHILE (button(1))
		digitalJstk up, down, left, right, button()
	WEND




	digitalJstk up, down, left, right, button()

	waiting = 1



	'This will wait under all circumstances.
	WHILE (waiting)
	digitalJstk up, down, left, right, button()
	FOR a = 1 TO 4
	 IF button(a) THEN waiting = 0
	NEXT a

	getSingleKey THISKEY
	IF THISKEY THEN waiting = 0




		pageflip
		MoveWater
		MoveTransition
		drawall
		'IF ObjectShadows = 1 THEN RenderObjectShadows
		renderobjects
		particleweather allblend()

		transbox 1, 319, 160, 240
		shadowdrop% = 1
		 sprint 14, line1$, 16
		shadowdrop% = 0
		 sprint 14, line1$, 0
		shadowdrop% = 1
		 sprint 15, line2$, 16
		shadowdrop% = 0
		 sprint 15, line2$, 0
		shadowdrop% = 1
		 sprint 16, line3$, 16
		shadowdrop% = 0
		 sprint 16, line3$, 0
		shadowdrop% = 1
		 sprint 17, line4$, 16
		shadowdrop% = 0
		 sprint 17, line4$, 0
		shadowdrop% = 1
		 sprint 18, line5$, 16
		shadowdrop% = 0
		 sprint 18, line5$, 0


					 




	WEND

	'it's crazy, but it just might work


END SUB

SUB TurnNumlockOff ()
END SUB

STATIC SUB UnloadMIDI ()
'----------------------------------------------------------------------------
' Frees the memory used by the MIDI and gives it back to QB.
'----------------------------------------------------------------------------

	IF CARDTYPE = 0 AND DetectSettingsCalled THEN LastError = 2: EXIT SUB
	IF CARDTYPE = 0 AND NOT DetectSettingsCalled THEN LastError = 3: EXIT SUB
	IF SBMIDI = 0 THEN LastError = 1: EXIT SUB
	IF MIDILoaded = False THEN LastError = 4: EXIT SUB
	IF MIDIPlaying = True THEN StopMidi

	DIM MIDIRegs AS RegTypeX

	MIDIRegs.es = Segment&: MIDIRegs.ax = &H4900: INTERRUPTX &H21, MIDIRegs, MIDIRegs: a& = SETMEM(650000)

	MIDILoaded = False
	CurMIDI$ = ""
	LastError = 0

END SUB

SUB UpdateDebug ()
END SUB

FUNCTION wordwrap$ (line$, length%)
line$ = line$ + " "
a = LEN(line$)
WHILE a > length% OR MID$(line$, a, 1) <> " "
	a = a - 1
WEND

oline$ = LEFT$(line$, a)
line$ = MID$(line$, a)
line$ = LTRIM$(RTRIM$(line$))

wordwrap$ = oline$

END FUNCTION

 SUB xcls (pag%)
 SELECT CASE pag%
	 CASE 0: idSegment% = &HA000
	 CASE 1: idSegment% = &HA4F0
	 CASE 2: idSegment% = &HA9E0
	 CASE ELSE: ERROR 5
 END SELECT

 OUT &H3C4, &H2: OUT &H3C5, &HF
 DEF SEG = idSegment%
 FOR address% = 0 TO 19199: POKE address%, 0: NEXT
 'Sets back to original page data and such...
 SELECT CASE page%
	 CASE 0: VidSegment% = &HA000
	 CASE 1: VidSegment% = &HA4F0
	 CASE 2: VidSegment% = &HA9E0
	 CASE ELSE: ERROR 5
 END SELECT
 DEF SEG = VidSegment%
 showpage page%



 END SUB

SUB xINPUT (strg$, row%, colr)
	DIM PlaceHolder AS STRING
strg$ = ""
WHILE getkey$ <> CHR$(13)

waitfive = waitfive + 1
IF waitfive = 16 THEN waitfive = 15



IF getkey$ <> CHR$(8) AND getkey$ <> CHR$(13) THEN
	PlaceHolder = ""
	FOR LoopInXinput = 0 TO LEN(strg$) - 2
		   PlaceHolder = PlaceHolder + " "

	NEXT LoopInXinput
	xsprint row% * 12, 0, PlaceHolder + "_", 25

	IF getkey$ <> "" THEN
	strg$ = strg$ + getkey$

	sprint row%, strg$ + "_", colr

	yah = yah + 1
	   END IF
ELSE
	sprint row%, strg$ + "_", 1
	IF yah > 0 THEN
	yah = yah - 1
		lastkey$ = (LEFT$(strg$, yah))
	 END IF
	strg$ = lastkey$

	dialogbox 1
 '   sPRINT 17, cbuffer$(9), 1
 '   sPRINT 16, cbuffer$(8), 1
 '   sPRINT 15, cbuffer$(7), 1
 '   sPRINT 14, cbuffer$(6), 1


	sprint row%, strg$ + "_", colr

END IF

mtkinkey getkey$

IF waitfive = 15 THEN IF getkey$ = CHR$(96) THEN strg$ = "exit": GOTO 142
'The line above is simply integration into the console.
'typing 'EXIT' was a pain compared to other consoles.
WEND

dialogbox 1
142 'my back door.
strg$ = LTRIM$(RTRIM$(strg$))

END SUB

