' BOMBRN-E-AHB a.k.a. AHIBOMBERS
' Version 1.0b
' Copyright (C) 1999-2005, Pc72

DEFINT A-Z
CONST DelayTime = 20
CONST ScreenColumns = 19, ScreenRows = 11
CONST Actors = 20, Bombs = 10, Anims = 50
DECLARE FUNCTION ActorFrame (Num)
DECLARE FUNCTION AreaFree (X, Y)
DECLARE FUNCTION Discover (X, Y)
DECLARE FUNCTION Exist (I$)
DECLARE FUNCTION FreeAnimation ()
DECLARE FUNCTION FreeBomb ()
DECLARE FUNCTION XYBomb (X, Y)
DECLARE SUB Delay (Ms)
DECLARE SUB DoMain ()
DECLARE SUB DrawEdit (X, Y)
DECLARE SUB DrawScreen ()
DECLARE SUB EditLevel ()
DECLARE SUB GenerateMap ()
DECLARE SUB GetDirs (Direction, XInc, YInc)
DECLARE SUB GetItem (X, Y)
DECLARE SUB MoveActor (Num, Direction)
DECLARE SUB ProcessScripts ()
DECLARE SUB ResetRecords ()
DECLARE SUB SendMore (X, Y, Allowed)
DECLARE SUB WaitKey ()
CONST MaxX = ScreenColumns - 1, MaxY = ScreenRows - 1
CONST FALSE = 0, TRUE = NOT FALSE
TYPE AnimationType
  X AS INTEGER
  Y AS INTEGER
  MapX AS INTEGER
  MapY AS INTEGER
  TiltX AS INTEGER
  TiltY AS INTEGER
  Tick AS INTEGER
  Kind AS INTEGER
  Exist AS INTEGER
END TYPE
TYPE BombType
  Inherited AS AnimationType
  Fuse AS INTEGER
  Range AS INTEGER
END TYPE
TYPE PlayerType
  Inherited AS AnimationType
  Direction AS INTEGER
  Die AS INTEGER
END TYPE
TYPE GameType
  Level AS INTEGER
  Time AS INTEGER
  Score AS LONG
  Bombs AS INTEGER
  BombsPut AS INTEGER
  Remoted AS INTEGER
  Tyme AS INTEGER
  TimerTick AS INTEGER
  Enemies AS INTEGER
  Range AS INTEGER
  Result AS INTEGER
END TYPE
DIM SHARED Ahib(0 TO 130 * 20), Enemy(0 TO 130 * 20), Object(0 TO 130 * 17), ActorTemp(0 TO 130 * (Actors + 1))
DIM SHARED Map(0 TO 19, 0 TO 11) AS INTEGER, Actor(0 TO Actors) AS PlayerType, Bomb(1 TO Bombs) AS BombType, Game AS GameType, Animation(1 TO Anims) AS AnimationType
DIM SHARED DelayProg(0 TO 8)
DEF SEG = VARSEG(DelayProg(0))
FOR I = 0 TO 17
  READ J
  POKE VARPTR(DelayProg(0)) + I, J
NEXT I
DEF SEG
DATA 144,186,000,000,184,232,003,247,226,139,202,139,208,180,134,205,021,203
SCREEN 13
RANDOMIZE TIMER
LOCATE 13, 6
PRINT "Copyright (C) 1999-2005 Pc72"
WaitKey
DEF SEG = &HA000
BLOAD "AHIBOMB2.DAT", 0
DEF SEG
FOR I = 0 TO 19
  GET (I * 16, 0)-(I * 16 + 15, 15), Ahib(I * 130)
  GET (I * 16, 16)-(I * 16 + 15, 31), Enemy(I * 130)
NEXT I
FOR I = 0 TO 16
  GET (I * 16, 32)-(I * 16 + 15, 47), Object(I * 130)
NEXT I
DEF SEG = &HA000
BLOAD "AHIBOMB1.DAT", 0
DEF SEG
WaitKey
Game.Remoted = FALSE
Game.Range = 1
Game.Bombs = 1
Remote$ = ""
FOR I = 1 TO 100
  Game.Level = I
  CLS
  LOCATE 13, 15
  PRINT "Level "; LTRIM$(STR$(Game.Level))
  WaitKey
  ResetRecords
  Ld$ = LTRIM$(STR$(Game.Level)) + ".lev"
  IF Exist(Ld$) THEN
    OPEN "B", 1, Ld$
      Rec = 1
      FOR Y = 0 TO MaxY
        FOR X = 0 TO MaxX
          GET #1, Rec, Map(X, Y)
          Rec = Rec + LEN(Map(X, Y))
      NEXT X, Y
    CLOSE 1
  ELSE
    GenerateMap
  END IF
Redraw:
  CLS
  DrawScreen
  DO
    DoMain
    WHILE INKEY$ <> "": WEND
    Patang = INP(96)
    SELECT CASE Patang
      CASE 72
        MoveActor 0, 1
      CASE 80
        MoveActor 0, 2
      CASE 75
        MoveActor 0, 3
      CASE 77
        MoveActor 0, 4
      CASE 29
        IF Actor(0).Inherited.Exist THEN
          X = Actor(0).Inherited.MapX
          Y = Actor(0).Inherited.MapY
          IF NOT XYBomb(X, Y) THEN
            J = FreeBomb
            IF J > 0 THEN
              Bomb(J).Inherited.MapX = X
              Bomb(J).Inherited.MapY = Y
              Bomb(J).Inherited.X = X * 16
              Bomb(J).Inherited.Y = Y * 16
              IF NOT Game.Remoted THEN
                Bomb(J).Fuse = 100
              ELSE
                Bomb(J).Fuse = -1
                Remote$ = Remote$ + CHR$(J)
              END IF
              Game.BombsPut = Game.BombsPut + 1
              Bomb(J).Range = Game.Range
              Bomb(J).Inherited.Tick = 0
              Bomb(J).Inherited.Exist = TRUE
            END IF
          END IF
        END IF
      CASE 56
        IF Remote$ <> "" THEN
          Bomb(ASC(RIGHT$(Remote$, 1))).Fuse = 0
          Remote$ = LEFT$(Remote$, LEN(Remote$) - 1)
        END IF
      CASE 31
        LOCATE 25, 1
        INPUT ; "Save to"; Cht$
        IF LEN(Cht$) > 8 THEN Cht$ = LEFT$(Cht$, 8)
        IF Cht$ <> "" THEN
          Cht$ = Cht$ + ".sav"
          OPEN "B", 1, Cht$
            Rec = 1
            PUT #1, Rec, Game
            Rec = Rec + LEN(Game)
            FOR K = 0 TO Actors
              PUT #1, Rec, Actor(K)
              Rec = Rec + LEN(Actor(K))
            NEXT K
            FOR K = 1 TO Anims
              PUT #1, Rec, Animation(K)
              Rec = Rec + LEN(Animation(K))
            NEXT K
            FOR K = 1 TO Bombs
              PUT #1, Rec, Bomb(K)
              Rec = Rec + LEN(Bomb(K))
            NEXT K
            FOR Y = 0 TO MaxY
              FOR X = 0 TO MaxX
                PUT #1, Rec, Map(X, Y)
                Rec = Rec + LEN(Map(X, Y))
            NEXT X, Y
            P = LEN(Remote)
            PUT #1, Rec, P
            Rec = Rec + 2
            PUT #1, Rec, Remote$
          CLOSE 1
        END IF
      CASE 38
        LOCATE 25, 1
        INPUT ; "Load from"; Cht$
        IF LEN(Cht$) > 8 THEN Cht$ = LEFT$(Cht$, 8)
        IF Cht$ <> "" THEN
          Cht$ = Cht$ + ".sav"
          IF Exist(Cht$) THEN
            OPEN "B", 1, Cht$
              Rec = 1
              GET #1, Rec, Game
              Rec = Rec + LEN(Game)
              FOR K = 0 TO Actors
                GET #1, Rec, Actor(K)
                Rec = Rec + LEN(Actor(K))
              NEXT K
              FOR K = 1 TO Anims
                GET #1, Rec, Animation(K)
                Rec = Rec + LEN(Animation(K))
              NEXT K
              FOR K = 1 TO Bombs
                GET #1, Rec, Bomb(K)
                Rec = Rec + LEN(Bomb(K))
              NEXT K
              FOR Y = 0 TO MaxY
                FOR X = 0 TO MaxX
                  GET #1, Rec, Map(X, Y)
                  Rec = Rec + LEN(Map(X, Y))
              NEXT X, Y
              GET #1, Rec, P
              Rec = Rec + 2
              SEEK #1, Rec
              Remote$ = INPUT$(P, 1)
            CLOSE 1
          END IF
          GOTO Redraw
        END IF
      CASE 15
        Map(Actor(0).Inherited.MapX, Actor(0).Inherited.MapY) = 255
        FOR K = 1 TO Actors
          IF Actor(K).Inherited.Exist THEN Map(Actor(K).Inherited.MapX, Actor(K).Inherited.MapY) = 240
        NEXT K
        ResetRecords
        EditLevel
        GOTO Redraw
      CASE 50
        LOCATE 25, 1
        INPUT ; "Load level from"; Cht$
        IF LEN(Cht$) > 8 THEN Cht$ = LEFT$(Cht$, 8)
        IF Cht$ <> "" THEN
          Cht$ = Cht$ + ".lev"
          IF Exist(Cht$) THEN
            OPEN "B", 1, Cht$
              Rec = 1
              FOR Y = 0 TO MaxY
                FOR X = 0 TO MaxX
                  GET #1, Rec, Map(X, Y)
                  Rec = Rec + LEN(Map(X, Y))
              NEXT X, Y
            CLOSE 1
          END IF
          GOTO Redraw
        END IF
      CASE 1
        LOCATE 25, 1
        PRINT "Are you sure (Y/N)?";
        IF UCASE$(INPUT$(1)) = "Y" THEN Game.Result = 1
    END SELECT
  LOOP UNTIL Game.Result > 0
  IF Game.Result < 3 THEN EXIT FOR
NEXT
CLS
LOCATE 13, 15
PRINT "Game Over"
WaitKey

FUNCTION ActorFrame (Num)
  IF Actor(Num).Die THEN
    ActorFrame = (4 - (Actor(Num).Inherited.Tick \ 8)) + 15
  ELSE
    ActorFrame = ((Actor(Num).Direction - 1) * 4) + (Actor(Num).Inherited.Tick \ 4)
  END IF
END FUNCTION

FUNCTION AreaFree (X, Y)
  IF (X < MaxX) AND (Y < MaxY) AND (X > 0) AND (Y > 0) THEN
    C = Map(X, Y) AND 1
    D = XYBomb(X, Y)
    AreaFree = (C = 0) AND (NOT D)
  END IF
END FUNCTION

SUB Delay (Ms)
  DelayProg(1) = Ms
  DEF SEG = VARSEG(DelayProg(0))
  CALL ABSOLUTE(VARPTR(DelayProg(0)))
  DEF SEG
END SUB

FUNCTION Discover (X, Y)
  C = Map(X, Y)
  Ofs = 16
  IF (C AND 1) = 1 THEN
    Ofs = 0
  END IF
  IF (C AND 2) = 2 THEN
    Ofs = 12
  END IF
  IF (C AND 4) = 4 THEN
    IF (C AND 1) = 0 THEN
      Tipe = (C AND &HF0) \ 16
      Ofs = Tipe MOD 4
    END IF
  END IF
  Discover = Ofs
END FUNCTION

SUB DoMain
  ProcessScripts
  IF Game.Enemies = 0 THEN Game.Result = 3
  IF NOT Actor(0).Inherited.Exist THEN Game.Result = 1
  IF Game.TimerTick < 31 THEN
    Game.TimerTick = Game.TimerTick + 1
  ELSE
    Game.TimerTick = 0
    IF Game.Tyme > 0 THEN
      Game.Tyme = Game.Tyme - 1
    ELSE
      FOR K = 0 TO Actors
        IF Actor(K).Inherited.Exist THEN
          IF NOT Actor(K).Die THEN
            Actor(K).Inherited.Tick = 32
            Actor(K).Die = TRUE
          END IF
        END IF
      NEXT K
    END IF
  END IF
  LOCATE 25, 1
  PRINT "Score:"; Game.Score; TAB(20); "Time:"; Game.Tyme;
  Delay DelayTime
  WAIT &H3DA, 8
  FOR K = 0 TO Actors
    IF Actor(K).Inherited.Exist THEN PUT (Actor(K).Inherited.X, Actor(K).Inherited.Y), ActorTemp(K * 130), PSET
  NEXT K
END SUB

SUB DrawEdit (X, Y)
  I = Map(X, Y)
  PUT (X * 16, Y * 16), Object(16 * 130), PSET
  IF I = 255 THEN
    PUT (X * 16, Y * 16), Ahib(4 * 130)
  ELSEIF I = 240 THEN
    PUT (X * 16, Y * 16), Enemy(4 * 130)
  ELSE
    IF (I AND 2) = 2 THEN
      PUT (X * 16, Y * 16), Object(12 * 130), OR
    ELSEIF (I AND 1) = 1 THEN
      PUT (X * 16, Y * 16), Object, OR
    END IF
    IF (I AND 4) = 4 THEN
      J = I \ 16
      J = J MOD 4
      SELECT CASE J
        CASE 1, 2, 3
          PUT (X * 16, Y * 16), Object(J * 130), OR
      END SELECT
    END IF
  END IF
END SUB

SUB DrawScreen
  FOR Y = 0 TO MaxY
    FOR X = 0 TO MaxX
      IF Map(X, Y) = 255 THEN
        Actor(0).Inherited.Exist = TRUE
        Actor(0).Inherited.X = X * 16
        Actor(0).Inherited.Y = Y * 16
        Map(X, Y) = 0
      ELSEIF Map(X, Y) = 240 THEN
        SendMore X, Y, 1
        Map(X, Y) = 0
      ELSE
        Ofs = Discover(X, Y)
        PUT (X * 16, Y * 16), Object(Ofs * 130), PSET
      END IF
  NEXT X, Y
END SUB

SUB EditLevel
RedrawEdit:
  CLS
  FOR Y = 0 TO MaxY
    FOR X = 0 TO MaxX
      DrawEdit X, Y
  NEXT X, Y
  K = 0
  X = 10
  Y = 6
  L = 1
  DO
    DrawEdit X, Y
    LINE (X * 16, Y * 16)-(X * 16 + 15, Y * 16 + 15), , B
    LINE (X * 16, Y * 16)-(X * 16 + 15, Y * 16 + 15)
    WAIT &H3DA, 8
    WaitKey
    Patang = INP(96)
    DrawEdit X, Y
    SELECT CASE Patang
      CASE 72
        IF Y > 0 THEN Y = Y - 1 ELSE Y = MaxY
      CASE 80
        IF Y < MaxY THEN Y = Y + 1 ELSE Y = 0
      CASE 75
        IF X > 0 THEN X = X - 1 ELSE X = MaxX
      CASE 77
        IF X < MaxX THEN X = X + 1 ELSE X = 0
      CASE 57
        Map(X, Y) = L * 16 + K
      CASE 15
        IF K < 7 THEN K = K + 1 ELSE K = 0
        IF (K = 5) OR (K = 6) THEN K = 7
        IF K = 2 THEN K = 3
        Map(X, Y) = L * 16 + K
      CASE 28
        IF L < 3 THEN L = L + 1 ELSE L = 1
        Map(X, Y) = L * 16 + K
      CASE 30
        Map(X, Y) = 255
      CASE 32
        Map(X, Y) = 240
      CASE 14
        Map(X, Y) = 0
      CASE 83
        FOR I = 0 TO MaxY
          FOR J = 0 TO MaxX
            Map(J, I) = 0
        NEXT J, I
        GOTO RedrawEdit
      CASE 1
        LOCATE 25, 1
        PRINT "Are you sure (Y/N)?";
        IF UCASE$(INPUT$(1)) = "Y" THEN EXIT DO
      CASE 31
        LOCATE 25, 1
        INPUT ; "Save to"; Cht$
        IF LEN(Cht$) > 8 THEN Cht$ = LEFT$(Cht$, 8)
        IF Cht$ <> "" THEN
          Cht$ = Cht$ + ".lev"
          OPEN "B", 1, Cht$
            Rec = 1
            FOR I = 0 TO MaxY
              FOR J = 0 TO MaxX
                PUT #1, Rec, Map(J, I)
                Rec = Rec + LEN(Map(J, I))
            NEXT J, I
          CLOSE 1
        END IF
      CASE 38
        LOCATE 25, 1
        INPUT ; "Load from"; Cht$
        IF LEN(Cht$) > 8 THEN Cht$ = LEFT$(Cht$, 8)
        IF Cht$ <> "" THEN
          Cht$ = Cht$ + ".lev"
          IF Exist(Cht$) THEN
            OPEN "B", 1, Cht$
              Rec = 1
              FOR I = 0 TO MaxY
                FOR J = 0 TO MaxX
                  GET #1, Rec, Map(J, I)
                  Rec = Rec + LEN(Map(J, I))
              NEXT J, I
            CLOSE 1
          END IF
          GOTO RedrawEdit
        END IF
    END SELECT
  LOOP
END SUB

FUNCTION Exist (I$)
  OPEN I$ FOR BINARY AS #1
    IF LOF(1) = 0 THEN
      CLOSE #1
      KILL I$
      GOTO NotFound
    END IF
  CLOSE #1
  GOTO Found
NotFound:
  Exist = FALSE
  EXIT FUNCTION
Found:
  Exist = TRUE
END FUNCTION

FUNCTION FreeAnimation
  FreeAnimation = 0
  FOR I = 1 TO Anims
    IF NOT Animation(I).Exist THEN
      FreeAnimation = I
      EXIT FOR
    END IF
  NEXT
END FUNCTION

FUNCTION FreeBomb
  FreeBomb = 0
  FOR I = 1 TO Bombs
    IF NOT Bomb(I).Inherited.Exist THEN
      FreeBomb = I
      EXIT FOR
    END IF
  NEXT
  IF Game.BombsPut >= Game.Bombs THEN FreeBomb = 0
END FUNCTION

SUB GenerateMap
  FOR Y = 0 TO MaxY
    FOR X = 0 TO MaxX
      Map(X, Y) = 0
  NEXT X, Y
  FOR Y = 0 TO MaxY
    Map(0, Y) = 1
    Map(MaxX, Y) = 1
  NEXT Y
  FOR X = 0 TO MaxX
    Map(X, 0) = 1
    Map(X, MaxY) = 1
  NEXT X
  FOR Y = 0 TO MaxY - 1 STEP 2
    FOR X = 0 TO MaxX - 1 STEP 2
      Map(X, Y) = 1
  NEXT X, Y
  Allowed = (ScreenRows * ScreenColumns) \ 2
  FOR I = 1 TO Allowed
    X = INT(RND * MaxX) + 1
    Y = INT(RND * MaxY) + 1
    IF Map(X, Y) = 0 THEN
      IF INT(RND * 10) = 3 THEN
        C = INT(RND * 3) + 1
        Map(X, Y) = 7 + (C * 16)
      ELSE
        Map(X, Y) = 3
      END IF
    END IF
  NEXT I
  Map(1, 1) = 255
  Map(1, 2) = 0
  Map(2, 1) = 0
  Allowed = (4 + Game.Level) \ 2
  IF Allowed > Actors THEN Allowed = Actors
  FOR K = 1 TO Allowed
    DO
      X = INT(RND * ScreenColumns)
      Y = INT(RND * ScreenRows)
    LOOP UNTIL (Map(X, Y) = 0) AND (X > 2) AND (Y > 2)
    Map(X, Y) = 240
  NEXT K
END SUB

SUB GetDirs (Direction, XInc, YInc)
  XInc = 0
  YInc = 0
  SELECT CASE Direction
    CASE 1
      YInc = -1
    CASE 2
      YInc = 1
    CASE 3
      XInc = -1
    CASE 4
      XInc = 1
  END SELECT
END SUB

SUB GetItem (X, Y)
  C = Map(X, Y)
  IF (C AND 4) = 4 THEN
    Tipe = (C AND &HF0) \ 16
    SELECT CASE Tipe
      CASE 1
        Game.Bombs = Game.Bombs + 1
      CASE 2
        Game.Range = Game.Range + 1
      CASE 3
        Game.Remoted = TRUE
    END SELECT
    Map(X, Y) = 0
    Game.Score = Game.Score + 100
    PUT (X * 16, Y * 16), Object(Discover(X, Y) * 130), PSET
  END IF
END SUB

SUB MoveActor (Num, Direction)
  IF NOT Actor(Num).Inherited.Exist THEN EXIT SUB
  IF Actor(Num).Die THEN EXIT SUB
  Dr = Direction
  Referred = FALSE
TopOff:
  Actor(Num).Direction = Dr
  X = Actor(Num).Inherited.X
  Y = Actor(Num).Inherited.Y
  A = X MOD 16
  B = Y MOD 16
  C = X \ 16
  D = Y \ 16
  SELECT CASE Dr
    CASE 1
      IF B <> 0 THEN D = D + 1
      Z = AreaFree(C, D - 1)
      IF A <> 0 THEN Z = Z AND AreaFree(C + 1, D - 1)
      IF Z THEN Actor(Num).Inherited.Y = Actor(Num).Inherited.Y - 1
    CASE 2
      Z = AreaFree(C, D + 1)
      IF A <> 0 THEN Z = Z AND AreaFree(C + 1, D + 1)
      IF Z THEN Actor(Num).Inherited.Y = Actor(Num).Inherited.Y + 1
    CASE 3
      IF A <> 0 THEN C = C + 1
      Z = AreaFree(C - 1, D)
      IF B <> 0 THEN Z = Z AND AreaFree(C - 1, D + 1)
      IF Z THEN Actor(Num).Inherited.X = Actor(Num).Inherited.X - 1
    CASE 4
      Z = AreaFree(C + 1, D)
      IF B <> 0 THEN Z = Z AND AreaFree(C + 1, D + 1)
      IF Z THEN Actor(Num).Inherited.X = Actor(Num).Inherited.X + 1
  END SELECT
  SELECT CASE Dr
    CASE 1, 2
      IF NOT Z THEN
        IF A = 0 THEN Referred = TRUE
        IF NOT Referred THEN
          Referred = TRUE
          IF A < 8 THEN Dr = 3 ELSE Dr = 4
          GOTO TopOff
        END IF
      END IF
    CASE 3, 4
      IF NOT Z THEN
        IF B = 0 THEN Referred = TRUE
        IF NOT Referred THEN
          Referred = TRUE
          IF B < 8 THEN Dr = 1 ELSE Dr = 2
          GOTO TopOff
        END IF
      END IF
  END SELECT
  C = X \ 16
  D = Y \ 16
  IF A > 7 THEN C = C + 1
  IF B > 7 THEN D = D + 1
  Actor(Num).Inherited.MapX = C
  Actor(Num).Inherited.MapY = D
  IF Num = 0 THEN GetItem Actor(Num).Inherited.MapX, Actor(Num).Inherited.MapY
  IF Actor(Num).Inherited.Tick < 15 THEN Actor(Num).Inherited.Tick = Actor(Num).Inherited.Tick + 1 ELSE Actor(Num).Inherited.Tick = 0
END SUB

SUB ProcessScripts
  DIM Through(0 TO 4) AS INTEGER
  FOR I = 1 TO Anims
    IF Animation(I).Exist THEN
      IF Animation(I).Tick > 0 THEN
        SELECT CASE Animation(I).Kind
          CASE 1, 3
            C = 3 - (Animation(I).Tick \ 4) + 8
            Map(Animation(I).MapX, Animation(I).MapY) = Map(Animation(I).MapX, Animation(I).MapY) OR 8
          CASE 2
            C = 3 - (Animation(I).Tick \ 4) + 12
            Map(Animation(I).MapX, Animation(I).MapY) = Map(Animation(I).MapX, Animation(I).MapY) OR 8
        END SELECT
        Animation(I).Tick = Animation(I).Tick - 1
      ELSE
        Animation(I).Exist = FALSE
        Map(Animation(I).MapX, Animation(I).MapY) = Map(Animation(I).MapX, Animation(I).MapY) AND 244
        IF Animation(I).Kind = 3 THEN
          Map(Animation(I).MapX, Animation(I).MapY) = Map(Animation(I).MapX, Animation(I).MapY) AND 240
          SendMore Animation(I).MapX, Animation(I).MapY, Actors
        END IF
        C = Discover(Animation(I).MapX, Animation(I).MapY)
      END IF
      PUT (Animation(I).X, Animation(I).Y), Object(C * 130), PSET
    END IF
  NEXT I
  FOR I = 1 TO Bombs
    IF Bomb(I).Inherited.Exist THEN
      A = Bomb(I).Inherited.MapX
      B = Bomb(I).Inherited.MapY
      IF (Map(A, B) AND 8) = 8 THEN
        Bomb(I).Fuse = 0
      END IF
      IF Bomb(I).Inherited.Tick < 31 THEN Bomb(I).Inherited.Tick = Bomb(I).Inherited.Tick + 1 ELSE Bomb(I).Inherited.Tick = 0
      Bmb = (Bomb(I).Inherited.Tick \ 8) + 4
      IF Bomb(I).Fuse > 0 THEN
        PUT (Bomb(I).Inherited.X, Bomb(I).Inherited.Y), Object(Bmb * 130), PSET
        Bomb(I).Fuse = Bomb(I).Fuse - 1
      ELSEIF Bomb(I).Fuse = -1 THEN
        PUT (Bomb(I).Inherited.X, Bomb(I).Inherited.Y), Object(Bmb * 130), PSET
      ELSE
        FOR P = 0 TO 4
          Through(P) = TRUE
        NEXT P
        Bomb(I).Inherited.Exist = FALSE
        Game.BombsPut = Game.BombsPut - 1
        FOR J = 1 TO Bomb(I).Range
          FOR P = 0 TO 4
            GetDirs P, K, L
            K = K * J
            L = L * J
            IF Through(P) THEN
              IF ((B + L) > 0) AND ((A + K) > 0) AND ((A + K) < MaxX) AND ((B + L) < MaxY) THEN
                IF Map(A + K, B + L) = 1 THEN
                  Through(P) = FALSE
                ELSE
                  C = FreeAnimation
                  IF C > 0 THEN
                    Animation(C).X = (A + K) * 16
                    Animation(C).Y = (B + L) * 16
                    Animation(C).MapX = A + K
                    Animation(C).MapY = B + L
                    Animation(C).Tick = 16
                    Animation(C).Exist = TRUE
                    IF (Map(A + K, B + L) AND 2) = 2 THEN
                      Through(P) = FALSE
                      Animation(C).Kind = 2
                    ELSEIF (Map(A + K, B + L) AND 4) = 4 THEN
                      Through(P) = FALSE
                      Animation(C).Kind = 3
                    ELSE
                      Animation(C).Kind = 1
                    END IF
                  END IF
                END IF
              END IF
            END IF
          NEXT P
        NEXT J
      END IF
    END IF
  NEXT I
  FOR I = 1 TO Actors
    IF Actor(I).Inherited.Exist THEN
      IF INT(RND * 20) = 2 THEN Actor(I).Direction = INT(RND * 4) + 1
      MoveActor I, Actor(I).Direction
      IF Actor(I).Inherited.MapX = Actor(0).Inherited.MapX THEN
        IF Actor(I).Inherited.MapY = Actor(0).Inherited.MapY THEN
          Game.Tyme = 0
        END IF
      END IF
    END IF
  NEXT I
  FOR I = 0 TO Actors
    IF Actor(I).Inherited.Exist THEN GET (Actor(I).Inherited.X, Actor(I).Inherited.Y)-(Actor(I).Inherited.X + 15, Actor(I).Inherited.Y + 15), ActorTemp(I * 130)
  NEXT I
  FOR I = 0 TO Actors
    IF Actor(I).Inherited.Exist THEN
      C = ActorFrame(I) * 130
      IF I = 0 THEN
        PUT (Actor(I).Inherited.X, Actor(I).Inherited.Y), Ahib(C)
      ELSE
        PUT (Actor(I).Inherited.X, Actor(I).Inherited.Y), Enemy(C)
      END IF
      IF Actor(I).Die THEN
        IF Actor(I).Inherited.Tick > 0 THEN
          Actor(I).Inherited.Tick = Actor(I).Inherited.Tick - 1
        ELSE
          PUT (Actor(I).Inherited.X, Actor(I).Inherited.Y), ActorTemp(I * 130), PSET
          Actor(I).Inherited.Exist = FALSE
        END IF
      END IF
    END IF
  NEXT I
  FOR I = 0 TO Actors
    IF Actor(I).Inherited.Exist THEN
      IF (Map(Actor(I).Inherited.MapX, Actor(I).Inherited.MapY) AND 8) = 8 THEN
        IF I > 0 THEN
          IF NOT Actor(I).Die THEN
            Game.Enemies = Game.Enemies - 1
            Game.Score = Game.Score + 1000
            Actor(I).Die = TRUE
            Actor(I).Inherited.Tick = 32
          END IF
        ELSE
          Game.Tyme = 0
        END IF
      END IF
    END IF
  NEXT I
END SUB

SUB ResetRecords
  Actor(0).Direction = 1
  Actor(0).Die = 0
  Actor(0).Inherited.Tick = 0
  Game.TimerTick = 0
  Game.Tyme = 200
  Game.Enemies = 0
  Game.Result = 0
  Game.BombsPut = 0
  FOR Enum = 1 TO Actors
    Actor(Enum).Inherited.Exist = FALSE
  NEXT Enum
  FOR Enum = 1 TO Bombs
    Bomb(Enum).Inherited.Exist = FALSE
  NEXT
  FOR Enum = 1 TO Anims
    Animation(Enum).Exist = FALSE
  NEXT
END SUB

SUB SendMore (X, Y, Allowed)
  Cnt = 0
  FOR Enum = 1 TO Actors
    IF NOT Actor(Enum).Inherited.Exist THEN
      IF Cnt < Allowed THEN
        Actor(Enum).Inherited.Exist = TRUE
        Game.Enemies = Game.Enemies + 1
        Cnt = Cnt + 1
      ELSE
        EXIT FOR
      END IF
      Actor(Enum).Inherited.MapX = X
      Actor(Enum).Inherited.MapY = Y
      Actor(Enum).Inherited.X = Actor(Enum).Inherited.MapX * 16
      Actor(Enum).Inherited.Y = Actor(Enum).Inherited.MapY * 16
      Actor(Enum).Direction = 1
      Actor(Enum).Die = 0
      Actor(Enum).Inherited.Kind = 1
      Actor(Enum).Inherited.Tick = 0
    END IF
  NEXT
END SUB

SUB WaitKey
  WHILE INKEY$ <> "": WEND
  WHILE INKEY$ = "": WEND
END SUB

FUNCTION XYBomb (X, Y)
  XYBomb = FALSE
  FOR I = 1 TO Bombs
    IF Bomb(I).Inherited.Exist THEN
      IF Bomb(I).Inherited.MapX = X THEN
        IF Bomb(I).Inherited.MapY = Y THEN
          XYBomb = TRUE
          EXIT FOR
        END IF
      END IF
    END IF
  NEXT
END FUNCTION

