/*
    mons_def.c - monster data initializer
    
    XRogue: Expeditions into the Dungeons of Doom
    Copyright (C) 1991 Robert Pietkivitch
    All rights reserved.
    
    Based on "Advanced Rogue"
    Copyright (C) 1984, 1985 Michael Morgan, Ken Dalka and AT&T
    All rights reserved.

    Based on "Rogue: Exploring the Dungeons of Doom"
    Copyright (C) 1980, 1981 Michael Toy, Ken Arnold and Glenn Wichman
    All rights reserved.
    
    See the file LICENSE.TXT for full copyright and licensing information.
*/

#include <ctype.h>
#include <curses.h>
#include "rogue.h"

#define HPT(x) x

struct monster monsters[NUMMONST+1] = {
/* {"Name",
                CARRY,  NORMAL, WANDER, APPEAR, INTEL,
                {ATTRIBUTES},
                "SUMMONED_CREATURE", NUMBER_SUMMONED,
                ADDED_EXPERIENCE/HIT_POINT,
                {str    dex,    move,   exp,    level,  "armor", hit_points,
                "damage"}}, */
{"unknown",
                0,      FALSE,  FALSE,  '\0',   "",
                {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
                "", 0,
                0,
                {0,     0,      0,      0,      0,      0,      HPT(""),
                ""}},
{"giant rat",
                0,      TRUE,   TRUE,   'R',    "2-6",
                {ISMEAN, CANDISEASE},
                "", 0,
                0,
                {10,    10,     6,      5,      1,      7,      HPT("1d4"),
                "1d3"}},
{"kobold",
                50,     TRUE,   TRUE,   'K',    "8-12",
                {ISMEAN, CANSHOOT, CARRYWEAPON},
                "", 0,
                2,
                {9,     9,      5,      8,      2,      7,      HPT("1d4"),
                "1d4"}},
{"bat",
                0,      TRUE,   TRUE,   'b',    "2-6",
                {ISMEAN, AREMANY, CANDISEASE, ISFLY},
                "", 0,
                0,
                {5,     5,      6,      5,      1,      10,     HPT("1d2"),
                "1d2"}},
{"gnome",
                50,     TRUE,   FALSE,  'G',    "10-15",
                {CANSHOOT, CARRYPOTION, CARRYWEAPON, NOSTAB},
                "", 0,
                3,
                {10,    10,     6,      8,      1,      5,      HPT("1d6"),
                "1d6"}},
{"halfling",
                50,     TRUE,   FALSE,  'H',    "11-16",
                {CANSHOOT, CARRYSCROLL, CARRYWEAPON, NOSTAB},
                "", 0,
                3,
                {8,     10,     6,      10,     1,      4,      HPT("1d8"),
                "1d6"}},
{"xvart",
                50,     TRUE,   TRUE,   'x',    "4-14",
                {ISMEAN, AREMANY, CARRYDAGGER, CANTELEPORT},
                "", 0,
                1,
                {8,     10,     7,      8,      1,      7,      HPT("1d2"),
                "1d3"}},
{"manes",
                0,      TRUE,   TRUE,   'M',    "2-8",
                {ISMEAN, ISUNDEAD, TURNABLE, CANDISEASE},
                "", 0,
                0,
                {5,     5,      5,      15,     2,      7,      HPT("1d8"),
                "1d2/1d2/1d4"}},
{"rot grub",
                0,      TRUE,   TRUE,   'r',    "10",
                {ISMEAN, CANDISEASE, CANINFEST, CANSMELL},
                "", 0,
                0,
                {10,    10,     8,      8,      1,      8,      HPT("1d6"),
                "1d6"}},
{"giant ant",
                0,      TRUE,   TRUE,   'A',    "1",
                {ISMEAN, CANPOISON},
                "", 0,
                3,
                {10,    10,     6,      30,     3,      3,      HPT("2d8"),
                "1d6/1d6"}},
{"orc",
                50,     TRUE,   TRUE,   'O',    "8",
                {ISMEAN, CANSHOOT, CARRYFOOD},
                "", 0,
                2,
                {12,    12,     5,      15,     4,      6,      HPT("2d8"),
                "1d8"}},
{"dwarf",
                50,     TRUE,   FALSE,  'D',    "10-14",
                {CARRYSCROLL, CARRYGOLD, CARRYDAGGER, NOSTAB},
                "", 0,
                4,
                {10,    10,     6,      20,     1,      4,      HPT("2d8"),
                "1d8"}},
{"elf",
                50,     TRUE,   FALSE,  'E',    "10-14",
                {CARRYPOTION, CARRYWEAPON, NOSTAB, CARRYFOOD},
                "", 0,
                4,
                {12,    10,     6,      20,     1,      4,      HPT("2d8+2"),
                "1d10"}},
{"hobgoblin",
                50,     TRUE,   TRUE,   'h',    "8-10",
                {ISMEAN, CANSHOOT, NOSLOW},
                "", 0,
                3,
                {14,    14,     4,      30,     4,      5,      HPT("1d8"),
                "1d8"}},
{"urchin",
                50,      TRUE,   TRUE,   'u',    "6-15",
                {ISMEAN, ISGREED, CARRYGOLD, CARRYRING},
                "", 0,
                1,
                {10,    10,     6,      25,     1,      3,      HPT("2d8"),
                "1d6"}},
{"fire beetle", 
                0,      TRUE,   TRUE,   'B',    "10",
                {ISMEAN, HASFIRE},
                "", 0,
                2,
                {10,    10,     6,      20,     1,      4,      HPT("1d8+2"),
                "2d4"}},
{"ear seeker",
                0,      TRUE,   TRUE,   'e',    "0",
                {ISMEAN, AREMANY, CANINFEST, CANSURPRISE},
                "", 0,
                0,
                {10,    10,     5,      10,     1,      8,      HPT("1d2"),
                "1d1"}},
{"shrieker",
                0,      TRUE,   TRUE,  'S',    "0",
                {ISMEAN, CANSHRIEK, NOMOVE, NOSTAB},
                "", 0,
                4,
                {10,    10,     7,      20,     2,      7,      HPT("3d8"),
                "0d0"}},
{"stirge",
                0,      TRUE,   TRUE,   's',    "1",
                {ISMEAN, CANDRAW, ISFLY},
                "", 0,
                2,
                {10,    10,     4,      30,     1,      8,      HPT("2d6"),
                "1d3"}},
{"troglodyte",
                50,     TRUE,   TRUE,   'T',    "5-15",
                {ISMEAN, CANSMELL, CANSTINK, CANSHOOT, HASFIRE},
                "", 0,
                3,
                {10,    10,     6,      30,     5,      4,      HPT("2d8"),
                "1d6/2d6"}},
{"zombie",
                0,      TRUE,   TRUE,   'Z',    "0",
                {ISMEAN, ISUNDEAD, TURNABLE, CANSURPRISE, ISSHADOW, NOSLEEP},
                "", 0,
                6,
                {10,    10,     5,      60,     1,      0,      HPT("2d8+5"),
                "2d8"}},
{"gas spore",
                0,      TRUE,   TRUE,  'a',    "0",
                {ISMEAN, CANEXPLODE, CANINFEST, ISFLY},
                "", 0,
                5,
                {10,    10,     8,     30,     2,      5,      HPT("2d8"),
                "1d2/1d4"}},
{"giant tick",
                0,      TRUE,   TRUE,   't',    "0",
                {ISMEAN, CANPOISON, CANROT},
                "", 0,
                1,
                {10,    10,     7,      70,     2,      4,      HPT("1d8"),
                "1d4"}},
{"lemure",
                0,      TRUE,   TRUE,   'L',    "5-10",
                {ISMEAN, ISREGEN, CANSUMMON, NOBOLT},
                "bat", 5,
                6,
                {12,    12,     5,      45,     4,      2,      HPT("3d8"),
                "1d6"}},
{"zoo spore",
                0,      TRUE,   TRUE,   'z',    "8-20",
                {ISMEAN, CANDISEASE, CANEXPLODE, TURNABLE, ISUNDEAD, ISFLY},
                "", 0,
                10,
                {20,    20,     4,      80,     2,      0,      HPT("2d8+6"),
                "1d8"}},
{"bugbear",
                30,     TRUE,   TRUE,   'b',    "5-12",
                {ISMEAN, CANSHOOT, CANSURPRISE, ISGREED},
                "", 0,
                3,
                {16,    10,     6,      60,     2,      5,      HPT("3d8+4"),
                "2d4"}},
{"gray ooze", 
                0,      TRUE,   TRUE,  'o',    "1",
                {ISMEAN, CANRUST, NOCOLD, NOFIRE, NOSTAB},
                "", 0,
                1,
                {10,    10,     9,     100,    2,      8,      HPT("1d8"),
                "1d8"}},
{"lonchu",
                50,     TRUE,   TRUE,   'l',    "6",
                {ISMEAN, CANTELEPORT, CARRYARMOR, NOBOLT},
                "", 0,
                3,
                {10,    10,     6,      120,    2,      3,      HPT("3d8+4"),
                "2d6"}},
{"wererat",
                50,     TRUE,   TRUE,   'r',    "10-15",
                {ISMEAN, CARRYPOTION, CANSUMMON, CANDRAW, NOSTAB},
                "giant rat", 3,
                5,
                {10,    10,     5,      70,     5,      4,      HPT("3d8+6"),
                "2d8"}},
{"ghoul",
                50,     TRUE,   TRUE,  'g',    "12-15",
                {ISMEAN, CARRYFOOD, CANPARALYZE, ISUNDEAD, TURNABLE, CANDRAW,
                 AREMANY},
                "", 0,
                7,
                {12,    12,     5,      75,     2,      2,      HPT("4d4"),
                "1d4/1d6"}},
{"leprechaun",
                75,     TRUE,   FALSE,  'l',    "10-16",
                {CARRYGOLD, STEALGOLD, ISGREED, CARRYSCROLL, CARRYPOTION,
                 NOSTAB},
                "", 0,
                9,
                {15,    15,     3,      100,     7,      0,      HPT("3d8"),
                "1d1/3d6"}},
{"junk monster", 
                100,    TRUE,   TRUE,   'j',    "10-14",
                {ISMEAN, CANSTINK, CANSMELL, ISSCAVENGE, ISGREED, CANDRAW,
                 ISREGEN, CANSHOOT, CARRYSTICK},
                "", 0,
                7,
                {12,    12,     5,      100,    2,      4,      HPT("3d8+3"),
                "1d6/2d8"}},
{"jacaranda",
                40,     TRUE,   TRUE,   'j',     "8-18",
                {ISMEAN, ISUNIQUE, ISREGEN, CANSUMMON, NOCOLD, NOFIRE, NOBOLT,
                 CANDANCE, CARRYGOLD, CANTELEPORT, CANBLIND, ISSHADOW, NOSTAB,
                 ISGREED, STEALGOLD, CARRYFOOD},
                "zombie", 4,
                20,
                {18,    18,     2,      40000,   10,    -15,    HPT("6d8+40"),
                "1d6/2d6/3d6"}},
{"gnoll",
                0,      TRUE,   TRUE,   'n',    "10-16",
                {ISMEAN, CANINFEST, CANROT, ISREGEN, TURNABLE},
                "", 0,
        4,
                {10,    10,     6,      140,    2,      4,      HPT("6d8"),
                "2d8"}},
{"fire toad", 
                0,      TRUE,   TRUE,   'f',    "5-7",
                {ISMEAN, CANBFIRE, NOFIRE, NOBOLT},
                "", 0,
                4,
                {10,    10,     6,      200,    2,      5,      HPT("5d8"),
                "1d8"}},
{"gelatinous cube", 
                50,     TRUE,   TRUE,   'c',    "0",
                {ISMEAN, CANPARALYZE, CARRYFOOD, NOCOLD},
                "", 0,
                4,
                {10,    10,     7,      160,    2,      1,      HPT("4d8"),
                "2d8"}},
{"moon dog",
                0,      TRUE,   TRUE,  'm',    "10-12",
                {ISMEAN, ISFLY, NOCOLD, NOFIRE, CANDRAW},
                "", 0,
                6,
                {12,    12,     4,     250,    2,      3,      HPT("3d8+3"),
                "2d10"}},
{"violet fungi", 
                0,      TRUE,   TRUE,   'F',    "0",
                {ISMEAN, CANSHRIEK, CANSUMMON, CANHOLD, NOMOVE, CANROT},
                "violet fungi", 1,
                5,
                {10,    10,     5,      150,    9,      0,      HPT("4d6+10"),
                "1d8/2d8/3d8"}},
{"ogre",
                50,     TRUE,   TRUE,   'O',    "7-12",
                {ISMEAN, CARRYGOLD, CARRYDAGGER, NOBOLT},
                "", 0,
                7,
                {18,    10,     6,      170,    3,      3,      HPT("4d8+8"),
                "2d10"}},
{"centaur",
                50,     TRUE,   FALSE,  'C',    "5-15",
                {STEALGOLD, CARRYGOLD, CARRYRING, NOSLEEP, NOSTAB},
                "", 0,
                9,
                {10,    10,     4,      180,    2,      4,      HPT("4d8+10"),
                "1d8/2d6"}},
{"nymph",
                75,     TRUE,   FALSE,  'N',    "10-16",
                {STEALMAGIC, CARRYSCROLL, CARRYPOTION, CARRYSTICK, NOSTAB,
                 CARRYFOOD, NOSLOW},
                "", 0,
                8,
                {16,    16,     3,      190,    5,      3,      HPT("3d8+10"),
                "1d1"}},
{"blindheim",
                0,      TRUE,   TRUE,   'b',    "10",
                {ISMEAN, CANBLIND, NOSLOW},
                "", 0,
                5,
                {8,     8,      5,      260,    3,      1,      HPT("4d8+6"),
                "2d10"}},
{"blink dog",
                0,      TRUE,   TRUE,   'B',    "8-10",
                {ISMEAN, CANBLINK, CANSEE, CANINFEST},
                "", 0,
                9,
                {10,    10,     6,      220,    3,      5,      HPT("4d8+4"),
                "1d8/2d4"}},
{"ghast",
                50,     TRUE,   TRUE,   'G',    "10-12",
                {ISMEAN, CANPARALYZE, CANSTINK, ISUNDEAD, TURNABLE, AREMANY,
                 NOBOLT},
                "", 0,
                10,
                {10,    10,     4,      250,    1,      1,      HPT("5d8+6"),
                "2d4/2d6"}},
{"rust monster", 
                0,      TRUE,   TRUE,   'R',    "1",
                {ISMEAN, CANRUST, CANDISEASE},
                "", 0,
                6,
                {10,    10,     7,      200,    4,      6,      HPT("2d8+6"),
                "1d1/1d1"}},
{"imp", 
                0,      TRUE,   TRUE,   'I',    "8-10",
                {ISMEAN, ISREGEN, CANPAIN, CANTELEPORT, NOCOLD, NOFIRE},
                "", 0,
                9,
                {10,    10,     6,      300,    3,      2,      HPT("3d8+12"),
                "2d8"}},
{"doppelganger", 
                50,     TRUE,   TRUE,   'D',    "10-15",
                {ISMEAN, CANSURPRISE, CARRYPOTION, NOSTAB, NOSLOW},
                "", 0,
                8,
                {10,    10,     5,      360,    5,      3,      HPT("7d8"),
                "1d12+2"}},
{"shadow",
                0,      TRUE,   TRUE,   'S',    "13",
                {ISMEAN, ISSHADOW, CANCHILL, ISUNDEAD, TURNABLE, CANINWALL},
                "", 0,
                9,
                {13,    13,     5,      370,    6,      1,      HPT("3d8+10"),
                "2d4/2d4"}},
{"very young dragon", 
                50,     TRUE,   TRUE,   'd',    "12-16",
                {ISMEAN, MAGICHIT, ISGREED, CARRYPOTION, CARRYGOLD, NOSTAB,
                 CANBRANDOM, CARRYMISC, NOBOLT},
                "", 0,
                11,
                {16,    16,     6,      300,    8,      -2,     HPT("4d8+20"),
                "2d4/1d6/1d8"}},
{"yeti",        
                0,      TRUE,   TRUE,   'Y',    "8-16",
                {ISMEAN, CANPARALYZE, CANSURPRISE, NOBOLT, NOSTAB, NOCOLD},
                "", 0,
                9,
                {13,    10,     5,      400,    3,      6,      HPT("5d8+6"),
                "1d8/2d8"}},
{"ice weasel",
                0,      TRUE,   TRUE,   'i',    "10-16",
                {ISMEAN, AREMANY, ISSHADOW, CANPAIN, NOCOLD, NOSLEEP},
                "", 0,
                7,
                {10,    10,     4,      400,   6,      1,      HPT("10d8+10"),
                "1d10"}},
{"mimic",
                50,     TRUE,   TRUE,  'M',    "2-16",
                {ISMEAN, ISDISGUISE, NODETECT, CANHOLD, NOMOVE, NOSTAB, NOBOLT,
                 CARRYRING},
                "", 0,
                12,
                {10,    10,     6,      500,    4,      8,      HPT("10d8"),
                "3d4"}},
{"owlbear",
                50,     TRUE,   TRUE,   'O',    "8-12",
                {ISMEAN, CANHUG, NOFEAR, NOSTAB, CARRYFOOD},
                "", 0,
                10,
                {10,    10,     3,      340,    3,      2,      HPT("5d8+10"),
                "1d6/1d6/2d6"}},
{"otyugh",
                50,     TRUE,   TRUE,   'o',    "5-10",
                {ISMEAN, ISFLY, CARRYARMOR, NOSLOW, NOFIRE},
                "", 0,
                11,
                {10,    10,     5,      750,   4,      4,      HPT("4d8+15"),
                "1d8/1d8/1d4+4"}},
{"gargoyle",
                50,     TRUE,   TRUE,   'g',    "5-7",
                {ISMEAN, MAGICHIT, CARRYWEAPON, NOSTAB},
                "", 0,
                9,
                {10,    10,     4,      290,    3,      5,      HPT("4d8+6"),
                "1d6/2d6"}},
{"su-monster",
                50,     TRUE,   TRUE,   's',    "8-10",
                {ISMEAN, CARRYGOLD, ISGREED, HASFIRE, CANSUMMON, CARRYSCROLL,
                 NOFEAR},
                "moon dog", 4,
                12,
                {10,    10,     5,      450,    4,      3,      HPT("5d8+10"),
                "2d4/2d4"}},
{"leucrotta", 
                0,      TRUE,   TRUE,   'L',    "8-10",
                {ISMEAN, NOFEAR, NOSLOW, NOSTAB, CANSEE},
                "", 0,
                10,      
                {10,    10,     2,      470,    3,      4,      HPT("6d8+10"),
                "3d6/1d6/1d6"}},
{"cockatrice", 
                50,      TRUE,   TRUE,   'C',    "1",
                {ISMEAN, CARRYSTICK, TOUCHSTONE, NOSTAB},
                "", 0,
                15,
                {12,    12,     5,      500,    6,      4,      HPT("5d8+8"),
                "4d4"}},
{"wight",
                0,      TRUE,   TRUE,   'W',    "8-10",
                {ISMEAN, CANDRAIN, MAGICHIT, NOSTONE, ISUNDEAD, TURNABLE,
                 NOBOLT},
                "", 0,
                12,
                {10,    10,     6,    550,    4,      2,      HPT("4d8+15"),
                "2d8"}},
{"phibian",
                0,      TRUE,   TRUE,   'p',    "2-16",
                {ISMEAN, NOBOLT, CANFRIGHTEN, TURNABLE, NOSLOW},
                "", 0,
                13,
                {10,    10,     2,     600,   8,      -2,     HPT("6d8"),
                "1d20"}},
{"fireworm",
                0,      TRUE,   TRUE,  'z',    "7-10",
                {ISMEAN, AREMANY, CANEXPLODE, NOFIRE, ISFLY, NOSLEEP},
                "", 0,
                15,
                {10,    10,     5,     500,    2,      0,      HPT("1d8"),
                "1d4"}},
{"flumph",
                50,      TRUE,   TRUE,   'f',    "10-16",
                {ISMEAN, AREMANY, CARRYGOLD, STEALGOLD, NOMOVE},
                "", 0,
                13,
                {12,    12,     3,      320,    3,      -7,      HPT("5d8+8"),
                "2d8"}},
{"treant",
                50,     TRUE,   TRUE,  't',    "10-14",
                {ISMEAN, CANSUMMON, CARRYGOLD, ISGREED, CANSTINK, CANSMELL},
                "treant", 1,
                16,
                {12,    12,     4,      1500,   2,      0,      HPT("5d8+10"),
                "3d8"}},
{"troll",
                50,     TRUE,   FALSE,  'T',    "10-15",
                {ISREGEN, CANSHOOT, CARRYGOLD, CARRYSCROLL, NOSTAB},
                "", 0,
                18,
                {18,    18,     6,      600,    7,      3,      HPT("6d8+10"),
                "1d4+4/1d4+4/2d6+2"}},
{"ettin",
                50,     TRUE,   TRUE,   'e',    "1-18",
                {ISMEAN, AREMANY, CARRYWEAPON, NOFIRE, CANROT},
                "", 0,
                10,
                {10,    10,     3,      1000,   3,      1,      HPT("8d8+8"),
                "2d8/2d6/2d6"}},
{"lava child", 
                0,      TRUE,   TRUE,   'l',    "8-10",
                {ISMEAN, NOMETAL, NOFIRE, NOBOLT, NOSTAB},
                "", 0,
                9,      
                {10,    10,     5,      700,    2,      4,      HPT("5d8+10"),
                "2d12"}},
{"erinyes",
                0,      TRUE,   TRUE,   'E',    "8-10",
                {ISMEAN, CANFRIGHTEN, TURNABLE, ISUNDEAD, CANPAIN, NOFIRE},
                "", 0, 
                11,
                {10,    10,     6,      750,    4,      3,      HPT("6d8+4"),
                "6d2+4"}},
{"ulodyte",
                0,      TRUE,   TRUE,   'u',    "9-13",
                {ISMEAN, CANSMELL, CANHUG, TURNABLE, NOSTAB, CANSURPRISE},
                "", 0,
                12,
                {10,    8,      6,      2000,   5,      3,      HPT("6d8+10"),
                "3d4/2d6"}},
{"wraith",
                0,      TRUE,   TRUE,   'w',    "10-14",
                {ISMEAN, CANDRAIN, MAGICHIT, ISUNDEAD, TURNABLE, NOBOLT,
                 NOSTAB, AREMANY},
                "", 0,
                16,
                {10,    10,     8,      800,    3,      2,      HPT("5d8+10"),
                "2d6/1d8"}},
{"jackalwere", 
                50,     TRUE,   TRUE,   'J',    "10-15",
                {ISMEAN, CANSMELL, CANSNORE, MAGICHIT},
                "", 0,
                10,
                {10,    10,     4,      900,    6,      3,      HPT("5d8+20"),
                "2d4/2d4"}},
{"basilisk",
                50,     TRUE,   TRUE,  'B',    "1",
                {ISMEAN, LOOKSTONE, CARRYSCROLL, NOSTAB, NOFIRE},
                "", 0,
                10,
                {10,    10,     6,      1000,   5,      4,      HPT("6d8+20"),
                "2d10"}},
{"vrock",
                0,      TRUE,   TRUE,   'v',    "10-12",
                {ISMEAN, CANSEE, TURNABLE, CANTELEPORT, CANDRAW},
                "", 0, 
                12,
                {10,    10,     6,      2300,   5,      1,      HPT("7d8+25"),
                "1d4/1d4/1d8/1d8/1d6/1d6"}},
{"hezrou",
                50,     TRUE,   TRUE,   'h',    "5-13",
                {ISMEAN, CANFRIGHTEN, TURNABLE, CANTELEPORT, CARRYSTICK},
                "", 0, 
                12,
                {10,    10,     6,      3000,   6,      -1,     HPT("9d8+10"),
                "1d4/2d4/4d4"}},
{"glabrezu",
                50,     TRUE,   TRUE,   'G',    "8-10",
                {ISMEAN, CANFRIGHTEN, CANSEE, TURNABLE, CANTELEPORT,
                 CARRYWEAPON, CARRYPOTION},
                "", 0, 
                12,
                {10,    10,     6,      2500,   6,      -4,     HPT("10d8+6"),
                "2d6/2d6/1d6/1d6"}},
{"wyvern",
                50,     TRUE,   TRUE,   'w',    "10-16",
                {ISMEAN, CANPAIN, CARRYGOLD, CANSUMMON, CANINFEST, NODETECT},
                "fireworm", 4,
                15,
                {10,    10,     5,      2200,   4,      -2,      HPT("8d8+10"),
                "2d8/2d8"}},
{"specter",
                0,      TRUE,   TRUE,   'S',    "10-16",
                {ISMEAN, DOUBLEDRAIN, ISUNDEAD, TURNABLE, NOFIRE, NOCOLD,
                NOSTAB, NOACID, NOGAS},
                "", 0,
                17,
                {12,    12,     6,      2000,   7,      1,      HPT("7d8+20"),
                "1d8/1d8"}},
{"mummy",
                0,      TRUE,   TRUE,   'm',    "5-14",
                {ISMEAN, CANROT, MAGICHIT, CANFRIGHTEN, HALFDAMAGE, ISUNDEAD,
                 NOGAS, NOACID, NOSTAB, TURNABLE},
                "", 0,
                18,
                {10,    10,     5,      2000,   5,      2,      HPT("8d8+10"),
                "1d12"}},
{"chimera",
                0,      TRUE,   TRUE,   'c',    "10-16",
                {ISMEAN, BMAGICHIT, NOFEAR, NOCOLD, ISREGEN, CANITCH},
                "", 0,
                19,
                {10,    10,     6,      2300,   5,      0,      HPT("6d8+25"),
                "1d3/1d3/1d4/1d4/2d4/2d4"}},
{"neo-otyugh",
                50,      TRUE,   TRUE,   'N',    "10-12",
                {ISMEAN, CARRYPOTION, CANINFEST, NOCOLD, NOFEAR, MAGICHIT},
                "", 0,
                17,
                {12,    10,     6,      2500,   6,      0,      HPT("12d8"),
                "2d8/2d6/1d3"}},
{"adult dragon", 
                80,     TRUE,   TRUE,   'd',    "12-16",
                {ISMEAN, CANBRANDOM, ISGREED, CANFRIGHTEN, NOSTAB, NOCOLD,
                 CARRYPOTION, CARRYMISC, CARRYRING, CANSURPRISE},
                "", 0,
                20,
                {18,    18,     5,      2600,   7,      -3,     HPT("7d8+20"),
                "2d6/2d6/2d6"}},
{"horned devil", 
                0,      TRUE,   TRUE,   'H',    "10-14",
                {ISMEAN, CANPOISON, NOBOLT, CANTELEPORT},
                "", 0, 
                17,
                {10,    10,     6,      2200,   5,      -2,     HPT("5d8+30"),
                "1d4/1d6/1d8"}},
{"barbed devil", 
                0,      TRUE,   TRUE,   'B',    "10-16",
                {ISMEAN, TOUCHFEAR, NOBOLT, CANHOLD, TURNABLE, NOFIRE},
                "", 0,
                17,
                {10,    10,     6,      2200,   5,      0,      HPT("8d8+20"),
                "2d4/2d4/3d4"}},
{"ice devil",
                0,      TRUE,   TRUE,   'I',    "12-15",
                {ISMEAN, ISREGEN, CANBICE, NOCOLD, NOBOLT},
                "", 0,
                17,
                {12,    10,     6,      2500,   6,      -4,     HPT("10d8+10"),
                "1d4/2d4/3d4"}},
{"bone devil",
                0,      TRUE,   TRUE,   'b',    "12-15",
                {ISMEAN, CANSURPRISE, CANCHILL, CANSEE, NOFIRE, NOACID,
                 NOGAS, CANFRIGHTEN, NOSTAB, NOCOLD, CANTELEPORT},
                "", 0, 
                17,
                {12,    12,     5,      3500,   8,      -1,     HPT("10d8+20"),
                "2d4/3d6"}},
{"rhinosphynx",
                80,     TRUE,   TRUE,   'r',    "13-18",
                {ISMEAN, CANPOISON, CANSURPRISE, CANCHILL, NOCOLD, CARRYGOLD,
                 ISGREED},
                "", 0, 
                18,
                {12,    12,     6,      3000,   7,      -1,     HPT("9d8+10"),
                "4d6"}},
{"lamia", 
                80,     TRUE,   TRUE,   'L',    "10-17",
                {ISMEAN, TAKEWISDOM, CARRYSTICK, NOFEAR, NOCOLD},
                "", 0,
                16,     
                {16,    16,     3,      2500,   7,      -2,     HPT("9d8+15"),
                "2d4/2d6"}},
{"intellect devourer",
                0,      TRUE,   TRUE,   'D',    "12-16",
                {ISMEAN, TAKEINTEL, BMAGICHIT, CANSURPRISE, NOBOLT, NOSTAB},
                "", 0,
                16,
                {16,    16,     3,      2500,   9,      -2,     HPT("10d8+15"), 
                "1d6/2d6/3d6"}},
{"quasit",
                80,     TRUE,   TRUE,   'Q',    "10-15",
                {ISMEAN, ISREGEN, BMAGICHIT, CANSURPRISE, CANITCH, NOGAS,
                 NOACID, CARRYSCROLL, CARRYPOTION, NOCOLD, NOBOLT},
                "", 0,
                20,
                {10,    10,     6,      3000,   6,      -2,     HPT("6d8+20"),
                "2d6/1d8/2d6"}},
{"will-o-wisp",
                80,     TRUE,   TRUE,   'W',    "12-16",
                {ISMEAN, CANSURPRISE, ISFLY, CARRYMISC, NOSTAB, NOBOLT},
                "", 0,
                20,
                {10,    10,     5,      4000,   6,      -5,     HPT("9d8+20"),
                "2d14"}},
{"invisible stalker", 
                0,      TRUE,   TRUE,   'i',    "12-16",
                {ISMEAN, ISINVIS, ISSHADOW, NOBOLT, CANINWALL, NOGAS, NOSTAB,
                 NOACID, TOUCHFEAR},
                "", 0,
                20,
                {10,    10,     4,      3800,   5,      -2,     HPT("8d8+20"),
                "2d12"}},
{"hellmaid",
                80,     TRUE,   TRUE,  'h',    "10-20",
                {ISMEAN, AREMANY, CANBRANDOM, CARRYFOOD, NOBOLT, NOGAS,
                 NOACID, NOCOLD, NOFIRE},
                "", 0,
                20,
                {12,   12,     7,      4000,   4,      1,      HPT("8d8+12"),
                "2d8/2d8"}},
{"shadow dragon",
                80,      TRUE,   TRUE,   'S',    "16-20",
                {ISMEAN, TURNABLE, CANDRAW, NOSTAB, HASFIRE, CANSMELL,
                 CARRYGOLD, STEALGOLD, ISINVIS, ISSHADOW, NOSLOW},
                "", 0,
                25,
                {10,    10,     2,      4800,   3,      -7,     HPT("8d8+18"),
                "3d4/2d8"}},
{"umber hulk",
                80,     TRUE,   TRUE,   'U',    "8-16",
                {ISMEAN, CANHUH, CANINWALL, CANTUNNEL, CARRYSCROLL, NOSTAB,
                 NOACID, NOGAS, BMAGICHIT, NOBOLT},
                "", 0,
                22,
                {14,    14,     5,      5000,   8,      -3,     HPT("10d8+20"),
                "3d4/3d4/3d4"}},
{"xorn",
                0,      TRUE,   TRUE,   'X',    "8-18",
                {ISMEAN, CANINWALL, NOFIRE, CANSURPRISE, NOBOLT, NOSTAB, NOGAS,
                 NOACID},
                "", 0,
                23,
                {13,    13,     4,      5000,   8,      -4,     HPT("7d8+25"),
                "2d6/4d6"}},
{"xenolith", 
                80,     TRUE,   TRUE,   'x',    "12-18",
                {ISMEAN, NOSTAB, NOFIRE, NOBOLT, NOCOLD, CANTELEPORT,
                 STEALGOLD, CARRYGOLD, ISGREED},
                "", 0,
                24,
                {12,    12,     4,      3500,   6,      -2,     HPT("9d8+20"),
                "2d8/2d10"}},
{"shambling mound", 
                80,    TRUE,   TRUE,   's',    "5-7",
                {ISMEAN, CANSUFFOCATE, NOCOLD, CANHOLD, CARRYGOLD, CANSUMMON,
                 NOGAS, NOSTAB, NOACID, CARRYPOTION, CARRYSCROLL, ISSCAVENGE},
                "mummy", 3,
                20,
                {10,    10,     5,      4500,   5,      0,      HPT("9d8+15"),
                "2d8/2d10"}},
{"black pudding", 
                80,     TRUE,   TRUE,  'P',    "0",
                {ISMEAN, CANRUST, NOCOLD, BOLTDIVIDE, BLOWDIVIDE, ISSCAVENGE, 
                 NOSTAB, NOGAS, CARRYRING},
                "", 0,
                20,
                {10,    10,     6,      4500,   6,      5,      HPT("10d8+10"),
                "3d8"}},
{"vampire",
                0,      TRUE,   TRUE,   'V',    "5-16",
                {ISMEAN, ISREGEN, CANSUCK, CANDRAW, CANDRAIN, ISUNDEAD,
                 NOACID, TURNABLE, TOUCHFEAR, NOGAS, NOSTAB, NOBOLT},
                "", 0,
                23,
                {16,    16,     5,      5000,   7,      -4,     HPT("8d8+25"),
                "2d6+6"}},
{"morkoth",
                80,     TRUE,   TRUE,  'm',    "10-18",
                {ISMEAN, ISSHADOW, CANSEE, HALFDAMAGE, CARRYARMOR, NOGAS,
         CANSUMMON, NOMETAL},
                "wyvern", 2,
                21,
                {11,    11,     8,      7000,   6,      -1,     HPT("12d8+10"),
                "4d8/4d8"}},
{"white pudding", 
                80,     TRUE,   TRUE,  'w',    "0",
                {ISMEAN, CANDISSOLVE, NOFIRE, BOLTDIVIDE, BLOWDIVIDE, NOGAS,
                 ISSCAVENGE, NOSTAB, CARRYMISC},
                "", 0,
                20,
                {10,    10,     4,      8000,   8,      5,      HPT("10d8+10"),
                "4d8"}},
{"purple worm", 
                0,      TRUE,   TRUE,   'p',    "10",
                {ISMEAN, CANPOISON, CANINWALL, CANTUNNEL, NOSTAB, NOFEAR,
                 NOBOLT, NOACID, CMAGICHIT, NOGAS},
                "", 0,
                25,
                {10,    10,     5,      9000,   8,      -3,     HPT("12d8+20"),
                "2d12/2d8+4"}},
{"pit fiend",
                80,     TRUE,   TRUE,   'f',    "12-18",
                {ISMEAN, CANSEE, BMAGICHIT, CANFRIGHTEN, CANHOLD, HASFIRE,
                 CARRYRING, CARRYSTICK, NOACID, NOGAS, NOSTAB},
                "", 0,
                26,
                {16,    16,     5,      10000,  6,      -2,     HPT("12d8+25"),
                "2d6+4/2d6+8"}},
{"ghost",       
                0,      TRUE,   TRUE,   'g',    "14-16",
                {ISMEAN, CANFRIGHTEN, CANAGE, ISUNDEAD, TURNABLE, BMAGICHIT,
                 NOGAS, NOACID, CANINWALL, CANSUMMON, NOSTAB, ISREGEN},
                "invisible stalker", 3,
                28,
                {13,    13,     5,      9500,   5,      -4,     HPT("10d8+25"),
                "2d10/2d4"}},
{"ancient black dragon", 
                80,     TRUE,   TRUE,   'a',    "12-16",
                {ISMEAN, CANBACID, NOSTAB, NOACID, ISGREED, CARRYGOLD, NOSLEEP,
                 CANMISSILE, CANTELEPORT, NOBOLT, NOCOLD, NOGAS, NOFIRE},
                "", 0,
                30,
                {14,    14,     6,      11000,  7,      -4,     HPT("10d8+50"),
                "2d6/3d4/4d6"}},
{"ancient blue dragon", 
                80,     TRUE,   TRUE,   'u',    "12-16",
                {ISMEAN, CANBBOLT, CANSEE, NOBOLT, CARRYMISC, NOSTAB, CANBPGAS,
                 NOACID, NOGAS, NOFIRE, NOCOLD, CANTELEPORT, NOFIRE, NOSLEEP},
                "", 0,
                30,
                {14,    14,     4,      11000,  7,      -6,     HPT("10d8+50"),
                "4d4/4d6/4d8"}},
{"ancient red dragon", 
                80,     TRUE,   TRUE,   'R',    "12-16",
                {ISMEAN, CANMISSILE, CANSEE, NOFIRE, CARRYRING, NOGAS, NOBOLT,
                 NOSTAB, CANBFIRE, NOFEAR, NOCOLD, NOFIRE, NOACID, CANTELEPORT},
                "", 0,
                30,
                {14,    14,     6,      11000,  7,      -8,     HPT("10d8+50"),
                "4d6/3d8/5d8"}},
{"ancient brass dragon", 
                80,     TRUE,   FALSE,  'r',    "12-16",
                {CANBFGAS, CANSEE, NOSLEEP, CANBSGAS, NOGAS, NOSTAB,
                 CANTELEPORT, NOACID, NOFIRE, CARRYSTICK, NOBOLT, NOCOLD},
                "", 0,
                30,
                {14,    14,     6,      11000,  7,      -4,     HPT("10d8+50"),
                "2d6/3d4/4d6"}},
{"frost giant",
                80,     TRUE,   TRUE,   'F',    "5-16",
                {ISMEAN, NOCOLD, CARRYGOLD, AREMANY, CANBICE, NOGAS, CANCHILL,
                 CANSMELL, NOCOLD, NOACID, ISGREED},
                "", 0,
                35,
                {18,    18,     4,      12000,  8,      0,      HPT("8d8+30"),
                "6d8"}},
{"lich",
                80,     TRUE,   TRUE,   'l',    "12-18",
                {ISMEAN, CANSEE, CANPARALYZE, CANFRIGHTEN, CMAGICHIT, NOSTAB,
                 NOBOLT, CANMISSILE, CARRYGOLD, CARRYSCROLL, CARRYPOTION,
         CARRYRING, NOCOLD, NOFIRE, NOACID, NOGAS},
                "", 0,
                35,
                {12,    12,     4,      14000,  8,      -5,     HPT("10d8+60"),
                "2d10/3d8"}},
{"ancient green dragon", 
                80,     TRUE,   TRUE,   'E',    "12-16",
                {ISMEAN,CANBGAS, ISGREED, CANSEE, CARRYGOLD, NOSTAB, NOGAS,
                 NOACID, CANMISSILE, NOBOLT, NOSLEEP, CANTELEPORT, NOFIRE},
                "", 0,
                40,
                {16,    16,     6,      16000,  8,      -6,     HPT("10d8+60"),
                "4d4/4d6/4d8"}},
{"ancient white dragon", 
                80,     TRUE,   TRUE,   'W',    "12-16",
                {ISMEAN, CANSEE, NOGAS, NOSTAB, CARRYSCROLL, CANTELEPORT,
                 NOACID, NOFIRE, CANBICE, CANMISSILE, NOBOLT, NOCOLD, NOSLEEP},
                "", 0,
                40,
                {16,    16,     4,      16000,  8,      -4,     HPT("10d8+60"),
                "2d6/3d4/4d6"}},
{"ancient bronze dragon", 
                80,     TRUE,   FALSE,  'L',    "12-16",
                {CANBBOLT, CANSEE, NOBOLT, NOSTAB, CANBCGAS, NOFIRE,
                 CARRYSCROLL, CARRYSTICK, NOCOLD, NOSLEEP, NOGAS, NOACID},
                "", 0,
                40,
                {16,    16,     8,      16000,  8,      -6,     HPT("10d8+60"),
                "4d4/4d6/4d8"}},
{"ancient copper dragon", 
                80,     TRUE,   FALSE,  'c',    "12-16",
                {NOACID, CANBSLGAS, CANSEE, NOFIRE, NOBOLT, NOSLEEP, NOCOLD,
                 CARRYMISC, CARRYPOTION, CANTELEPORT, NOSTAB, CANBACID, NOGAS},
                "", 0,
                40,
                {16,    16,     5,      16000,  8,      -6,     HPT("10d8+60"),
                "4d4/4d6/4d8"}},
{"fire giant",
                80,      TRUE,   TRUE,   'f',    "15-18",
                {ISMEAN, AREMANY, CARRYGOLD, ISGREED, NOSLOW, NOGAS, NOBOLT,
                 NOFIRE, CANSTINK, NOACID},
                "", 0,
                45,
                {15,    15,     3,      15000,  9,      -1,     HPT("8d8+30"),
                "8d6"}},
{"nemesis", 
                80,     TRUE,   TRUE,   'n',    "10-18",
                {ISMEAN, ISGREED, CANSEE, NOBOLT, STEALGOLD, CMAGICHIT, NOGAS,
                 NODETECT, CARRYFOOD, CANBLINK, NOCOLD},
                "", 0,
                45,
                {13,    13,     6,      18000,  9,      -7,     HPT("10d8+70"),
                "3d6/3d8/3d10"}},
{"ancient amethyst dragon", 
                80,     TRUE,   TRUE,   'y',    "12-16",
                {ISMEAN, CANSTINK, CANMISSILE, ISGREED, NOBOLT, NOGAS, NOSLEEP,
                 NOFIRE, NOCOLD, CARRYSCROLL, CANTELEPORT, NOSTAB, NOACID},
                "", 0,
                50,
                {18,    18,     4,      20000,  9,      -8,     HPT("10d8+70"),
                "4d6/3d8/5d8"}},
{"ancient silver dragon", 
                80,     TRUE,   FALSE,  'S',    "12-16",
                {CANBPGAS, NOSLEEP, CANBICE, NOCOLD, NOPARALYZE, NOGAS,
                 NOFIRE, NOACID, CARRYSTICK, NOSTAB, CANTELEPORT},
                "", 0,
                50,
                {18,    18,     8,      20000,  9,      -8,     HPT("10d8+70"),
                "4d6/3d8/5d8"}},
{"ancient saphire dragon", 
                80,     TRUE,   TRUE,   'H',    "12-16",
                {ISMEAN, NOBOLT, CANSEE, CARRYRING, NOSTAB, NOACID, CANSONIC,
                 CANTELEPORT, NOFIRE, NOCOLD, NOGAS, NOSLEEP},
                "", 0,
                50,
                {18,    18,     6,      20000,  9,      -6,     HPT("10d8+20"),
                "2d6/3d4/4d6"}},
{"ancient gold dragon", 
                80,     TRUE,   FALSE,  'G',    "12-16",
                {CANBGAS, ISGREED, NOACID, NOFIRE, NOGAS, CARRYGOLD,
                 CANBFIRE, CANTELEPORT, NOBOLT, NOSTAB, NOCOLD, NOSLEEP},
                "", 0,
                50,
                {18,    18,     5,      20000,  9,      -8,     HPT("10d8+70"),
                "4d6/3d8/5d8"}},
{"titan",
                80,     TRUE,   TRUE,   't',    "13-18",
                {ISMEAN, ISSHADOW, CANSEE, CARRYPOTION, NOSTAB, CANTELEPORT,
                 TOUCHFEAR, CANROT, NOGAS, NOACID, NOFEAR, NOBOLT},
                "", 0,
                55,
                {16,    16,     5,      22000,  10,     -5,     HPT("8d8+70"),
                "8d8"}},
{"storm giant",
                80,      TRUE,   TRUE,   's',    "10-16",
                {ISMEAN, NOBOLT, CANBBOLT, CANPAIN, NOGAS, NOSTAB, NOACID,
                 CARRYGOLD, ISGREED, CANBBOLT, NOBOLT, CANSUMMON},
                "shadow dragon", 2,
                55,
                {14,    14,     6,      20000,  10,     -7,     HPT("10d8+60"),
                "7d8/5d10"}},
{"lesser god (Hruggek)",
                100,     TRUE,   FALSE,  'H',    "20",
                {ISMEAN, ISUNIQUE, CARRYMSTAR, ISREGEN, MAGICHIT, CANSEE, NOGAS,
         NOFIRE, NOSTAB, CANMISSILE, CANTELEPORT, NOBOLT, CARRYFOOD},
                "", 0,
                60,
                {18,    18,     5,      40000,  10,     -5,     HPT("10d8+100"),
                "5d10/5d10"}},
{"lesser god (Surtur)",
                100,     TRUE,   FALSE,  'S',    "20",
                {ISMEAN, ISUNIQUE, CARRYSURTURRING, ISREGEN, MAGICHIT, CANSEE,
         NOFIRE, NOSTAB, CANMISSILE, CANTELEPORT, NOBOLT, CARRYRING},
                "", 0,
                60,
                {18,    18,     4,      40000,  10,     -5,     HPT("10d8+100"),
                "5d10/5d10"}},
{"demon prince (Yeenoghu)",
                100,     TRUE,   FALSE,   'Y',    "20",
                {ISMEAN, ISUNIQUE, CARRYFLAIL, CMAGICHIT, CANPOISON, NOBOLT,
         CANBBOLT, CANTELEPORT, NOFIRE, NOSTAB, NOGAS, CARRYSCROLL,
         NOCOLD, NOSLOW},
                "", 0,
                60,
                {18,    18,     5,      50000,  11,     -6,     HPT("10d8+100"),
                "2d8+4/2d6+8"}},
{"demon prince (Orcus)", 
                100,     TRUE,   FALSE,   'O',    "20",
                {ISMEAN, ISUNIQUE, CARRYWAND, CMAGICHIT, CANFRIGHTEN, CANSEE,
         CANBBOLT, NOBOLT, CANTELEPORT, NOFIRE, CARRYPOTION, NOSTAB},
                "", 0, 
                60,
                {18,    18,     5,      30000,  10,     -6,     HPT("10d8+90"),
                "2d8+4/2d6+8"}},
{"arch devil (Geryon)", 
                100,     TRUE,   FALSE,   'g',    "20",
                {ISMEAN, ISUNIQUE, CARRYHORN, BMAGICHIT, NOGAS, NOBOLT, NOSTAB,
         ISINVIS, CANTELEPORT, NOCOLD, NOFIRE, CARRYSTICK, CARRYHORN},
                "", 0,
                60,
                {18,    18,     5,      30000,  10,     -4,     HPT("10d8+90"),
                "3d6/3d8/3d10"}},
{"arch devil (Asmodeus)", 
                100,     TRUE,   FALSE,   'A',    "20",
                {ISMEAN, ISUNIQUE, CARRYROD, BMAGICHIT, NOGAS, NOBOLT, ISINVIS,
         NOSTAB, CANFRIGHTEN, CANTELEPORT, NOCOLD, NOFIRE, CARRYMISC},
                "", 0,
                60,
                {20,    20,     5,      40000,  10,     -4,     HPT("10d8+100"),
                "3d6/3d8/3d10"}},
{"poet (Brian)",
                100,     TRUE,   FALSE,   'p',    "20",
                {ISMEAN, ISUNIQUE, CARRYMANDOLIN, STEALGOLD, ISSHADOW, ISREGEN,
         NOCOLD, NOBOLT, NOFIRE, NOFEAR, CANTUNNEL, CANSEE, NOSTAB,
         CANINWALL, ISCLEAR, CARRYPOTION, NOGAS},
                "", 0,
                60,
                {20,    20,     4,      40000,  10,     -8,     HPT("10d8+100"),
                "4d4+20/4d4+20"}},
{"witch (Emori)",
                100,     TRUE,   FALSE,   'w',    "20",
                {ISMEAN, ISUNIQUE, CARRYCLOAK, CANMISSILE, ISINVIS, CANBBOLT,
         CANSEE, CANSUMMON, CANSNORE, ISFLY, NOBOLT, NOFIRE, NOSTAB,
         ISCLEAR, CARRYSTICK, NOSLOW, NOGAS},
                "nemesis", 4,
                60,
                {20,    20,     4,      50000,  11,     -8,     HPT("10d8+100"),
                "4d4+20/4d4+20"}},
{"hero (aklad)",
                100,     TRUE,   FALSE,  'k',    "20",
                {ISMEAN, ISUNIQUE, CARRYAXE, ISREGEN, NOBOLT, NOSLOW, NOGAS,
         CANSEE, ISCLEAR, CANBLINK, CARRYMISC, CANMISSILE, NOSTAB},
                "", 0,
                60,
                {20,    20,     5,      50000,  11,     -9,     HPT("10d8+100"),
                "2d8+15/2d8+15/1d6+15/1d6+15"}},
{"cleric of thoth (Heil)",
                100,     TRUE,   FALSE,   'h',    "20",
                {ISMEAN, ISUNIQUE, CARRYANKH, CARRYRING, CANSEE, NOFEAR,
         ISREGEN, CANHOLD, NOSTAB, DOUBLEDRAIN, NOCOLD, CANMISSILE,
         TAKEWISDOM, ISINVIS, NOGAS},
                "", 0,
                60,
                {20,   20,     4,      50000,  11,     -8,     HPT("10d8+100"),
                "3d6+10"}},
{"magician/thief (Nagrom)",
                100,     TRUE,   FALSE,   'N',    "20",
                {ISMEAN, ISUNIQUE, CARRYQUILL, STEALMAGIC, ISINVIS, ISREGEN,
         NOSTAB, NOGAS, CANMISSILE, CANSEE, CARRYRING, CANBSTAB, NOBOLT,
         CANBBOLT, CANSURPRISE, NODETECT, CANTELEPORT, CANSLOW},
                "", 0,
                60,
                {20,    20,     5,      60000,  12,     -8,     HPT("10d8+100"),
                "7d10/7d10"}},
{"magician (Tsoming Zen)",
                100,     TRUE,   FALSE,   'z',    "20",
                {ISMEAN, ISUNIQUE, CARRYSTAFF, ISINVIS, ISREGEN, CANBFIRE,
         CANBICE, NOSTAB, CANBBOLT, NOFIRE, NOCOLD, NOBOLT, CANHOLD,
         NOGAS, CANPAIN, NOSLOW, CARRYPOTION},
                "", 0,
                60,
                {20,   20,     4,      60000,  11,      -5,    HPT("10d8+100"),
                "2d8+10/2d8+10/2d8+10/2d8+10"}},
{"dwarven thief (Musty Doit)",
                100,     TRUE,   FALSE,   'm',    "20",
                {ISMEAN, ISUNIQUE, CARRYMDAGGER, NOFIRE, NOGAS, NOSTAB,
         STEALGOLD, STEALMAGIC, CANPAIN, CARRYGOLD, CANSURPRISE,
         NOBOLT, CARRYPOTION, CARRYSCROLL, ISSCAVENGE},
                "", 0,
                60,
                {20,    20,     5,      70000,  11,     -8,     HPT("10d8+100"),
                "4d8+10/4d8+10"}},
{"ruler of titans (Yendor)",
                100,     TRUE,   FALSE,   'y',     "20",
                {ISMEAN, ISUNIQUE, CARRYYAMULET, CANINWALL, BMAGICHIT, NOCOLD,
         CANSUMMON, CANMISSILE, CANFRIGHTEN, NOFIRE, NOGAS, NOSTAB, 
         TOUCHFEAR, ISSHADOW, NOBOLT, CARRYSTICK, CARRYSCROLL},
                "titan", 4,
                60,
                {20,    20,     5,      70000,  12,     -10,    HPT("10d8+100"),
                "2d10+5/2d10+5"}},
{"maker of rock (Stonebones)",
                100,     TRUE,   FALSE,   'b',    "20",
                {ISMEAN, ISUNIQUE, CARRYBAMULET, ISREGEN, CMAGICHIT, CANSEE,
         NOFIRE, NOSTAB, CANFRIGHTEN, CANMISSILE, CANTELEPORT, NOBOLT,
         CANITCH, NOGAS, CANINWALL, CANSONIC, CARRYSTICK},
                "", 0,
                60,
                {20,    20,     4,      70000,  12,     -10,    HPT("10d8+100"),
                "6d10/6d10"}},
{"creator of liches (Vecna)",
                100,     TRUE,   FALSE,   'V',     "20",
                {ISMEAN, ISUNIQUE, CARRYEYE, ISREGEN, CMAGICHIT, NOSTAB, NOGAS,
         CANSNORE, CANSUMMON, CANMISSILE, CANFRIGHTEN, NOFIRE, CANBBOLT,
         NOBOLT, CANSEE, ISINVIS, HALFDAMAGE, CARRYRING, LOOKSTONE},
                "lich", 4,
                60,
                {20,    20,     4,      70000,  12,     -10,    HPT("10d8+100"),
                "6d10/6d10"}},
{"lesser god (Thrym)",
                0,     TRUE,   TRUE,   'T',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, MAGICHIT, CANSEE, NOFIRE, NOSTAB,
                 CANMISSILE, CANTELEPORT, NOBOLT, CANITCH, NOGAS},
                "", 0,
                60,
                {18,    18,     5,      60000,  11,     -5,     HPT("10d8+100"),
                "5d10/5d10"}},
{"lesser god (Kurtulmak)",
                0,     TRUE,   TRUE,  'K',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, MAGICHIT, CANSEE, NOFIRE, NOSTAB,
                 CANMISSILE, CANTELEPORT, NOBOLT, NOGAS, CANITCH},
                "", 0,
                60,
                {18,    18,     5,      60000,  10,     -5,     HPT("10d8+100"),
                "5d10/5d10"}},
{"lesser god (\"The Destroyer\")",
                0,     TRUE,   TRUE,   'v',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, MAGICHIT, CANSEE, NOFIRE, NOSTAB,
                 CANMISSILE, CANTELEPORT, NOBOLT, CANITCH, NOGAS},
                "", 0,
                60,
                {18,    18,     5,      70000,  12,     -6,     HPT("10d8+100"),
                "5d10/5d10"}},
{"lesser god (Antar)", 
                100,     TRUE,   TRUE,   'A',    "17-25",
                {ISMEAN, ISUNIQUE, ISREGEN, NOCOLD, NOFIRE, NOBOLT, NOSTAB,
                 CANDANCE, CANTELEPORT, CANBLIND, CANSEE, ISSHADOW, NOSLOW,
                 ISGREED, CANSUMMON, CARRYFOOD, CANBRANDOM, CANINWALL, ISFLY},
                "ancient black dragon", 4,
                60,
                {22,    22,     2,      90000,  10,     -15,    HPT("10d8+100"),
                "6d10/6d10"}},
{"demon prince (Jubilex)", 
                0,     TRUE,   TRUE,   'J',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, CANPOISON, CANFRIGHTEN, CANBBOLT,
                 NOBOLT, CANTELEPORT, NOFIRE, NOSTAB, NOGAS},
                "", 0, 
                60,
                {18,    18,     5,      70000,  11,     -6,     HPT("10d8+100"),
                "2d8+4/2d6+8"}},
{"demon prince (Bone)", 
                0,     TRUE,   TRUE,   'B',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, CANPOISON, CANFRIGHTEN, CANBBOLT,
                 NOBOLT, CANTELEPORT, NOFIRE, NOSTAB},
                "", 0, 
                60,
                {18,    18,     5,      50000,  10,     -6,     HPT("10d8+90"),
                "2d8+4/2d6+8"}},
{"demon prince (Graz'zt)", 
                0,     TRUE,   TRUE,   'g',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, CANPOISON, CANFRIGHTEN, 
                 NOBOLT, CANTELEPORT, NOFIRE, NOSTAB, NOGAS},
                "", 0,
                60,
                {18,    18,     3,      60000,  11,     -6,     HPT("10d8+100"),
                "2d8+4/2d6+8"}},
{"demon prince (Demogorgon)", 
                0,     TRUE,   TRUE,  'D',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, CANPOISON, CANFRIGHTEN, CANBBOLT,
                 NOBOLT, CANTELEPORT, NOFIRE, NOSTAB, NOGAS},
                "", 0, 
                70,
                {18,    18,     5,      60000,  12,     -6,     HPT("10d8+120"),
                "2d8+4/2d6+8"}},
{"arch devil (Mammon)", 
                0,     TRUE,   TRUE,   'M',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, NOGAS, NOBOLT, ISINVIS, NOSTAB,
                 CANFRIGHTEN, CANPAIN, CANTELEPORT, NOCOLD, NOFIRE},
                "", 0, 
                60,
                {18,    18,     5,      80000,  10,     -4,     HPT("10d8+90"),
                "3d6/3d8/3d10"}},
{"arch devil (Baalzebul)", 
                0,     TRUE,   TRUE,   'B',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, NOGAS, NOBOLT, ISINVIS, NOSTAB,
                 CANFRIGHTEN, CANPAIN, CANTELEPORT, NOCOLD},
                "", 0, 
                60,
                {18,    18,     6,      80000,  11,     -4,     HPT("10d8+100"),
                "3d6/3d8/3d10"}},
{"arch devil (Moloch)", 
                100,     TRUE,   TRUE,   'M',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, NOGAS, NOBOLT, ISINVIS, ISGREED,
                 CANFRIGHTEN, CANPAIN, CANTELEPORT, NOCOLD, CARRYGOLD, NOSTAB},
                "", 0, 
                70,
                {18,    18,     6,      80000,  12,     -7,     HPT("10d8+120"),
                "3d6/3d8/3d10"}},
{"arch devil (Dispater)", 
                100,     TRUE,   TRUE,   'd',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, NOGAS, NOBOLT, ISINVIS, ISGREED,
                 CANFRIGHTEN, CANPAIN, CANTELEPORT, NOCOLD, CARRYGOLD, NOSTAB},
                "", 0, 
                70,
                {18,    18,     6,      80000,  12,     -7,     HPT("10d8+120"),
                "3d6/3d8/3d10"}},
{"platinum dragon (Bahamut)", 
                0,     TRUE,   FALSE,  'P',    "20",
                {ISUNIQUE, CANBGAS, CANBBOLT, NOBOLT, NOCOLD, NOFIRE, NOGAS,
         CANMISSILE, CANSUMMON, CANBACID, CANFRIGHTEN, NOACID, NOSTAB},
                "frost giant", 6,
                70,
                {20,    20,     5,      90000,  12,     -6,     HPT("10d8+120"),
                "2d10+10/2d10+10"}},
{"diablero (Prithivi)", 
                100,     TRUE,   TRUE,   'o',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANBACID, NOACID, NOGAS,
                 ISINVIS, ISSCAVENGE, CANDRAW, MAGICHIT, NOSTAB},
                "", 0,
                70,
                {18,    18,     3,      90000,  12,     -5,     HPT("10d8+120"),
                "3d12/4d8+6"}},
{"diablero (Apas)", 
                100,     TRUE,   TRUE,   'o',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANBACID, NOACID, NOGAS,
                 ISINVIS, ISSCAVENGE, CANDRAW, MAGICHIT, NOSTAB},
                "", 0,
                70,
                {18,    18,     3,      90000,  13,     -5,     HPT("10d8+120"),
                "3d12/4d8+6"}},
{"chromatic dragon (Tiamat)", 
                0,     TRUE,   FALSE,  'C',    "20",
                {ISUNIQUE, CANBGAS, CANBBOLT, NOBOLT, NOCOLD, NOFIRE, NOGAS,
         CANMISSILE, CANSUMMON, CANBACID, CANFRIGHTEN, NOACID, NOSTAB},
                "fire giant", 6,
                70,
                {20,    20,     5,      90000,  13,     -6,     HPT("10d8+120"),
                "2d10+10/2d10+10"}},
{"diablero (Vayu)", 
                100,     TRUE,   TRUE,   'o',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANBACID, NOACID, NOGAS,
                 ISINVIS, ISSCAVENGE, CANDRAW, MAGICHIT, NOSTAB},
                "", 0,
                70,
                {18,    18,     2,      90000,  13,     -7,     HPT("10d8+120"),
                "3d12/4d8+6"}},
{"diablero (Tejas)", 
                100,     TRUE,   TRUE,   'o',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANBACID, NOACID, NOGAS,
                 ISINVIS, ISSCAVENGE, CANDRAW, MAGICHIT, NOSTAB},
                "", 0,
                70,
                {18,    18,     2,      90000,  13,     -7,     HPT("10d8+120"),
                "3d12/4d8+6"}},
{"etheric dragon (Ishtar)", 
                0,     TRUE,   FALSE,   'E',    "20",
                {ISUNIQUE, CANBGAS, CANBBOLT, NOBOLT, NOCOLD, NOFIRE, NOGAS,
         CANMISSILE, CANSUMMON, CANBACID, CANFRIGHTEN, NOACID, NOSTAB},
                "storm giant", 6,
                70,
                {20,    20,     5,      90000,  13,     -8,     HPT("10d8+120"),
                "2d10+10/2d10+10"}},
{"diablero (Akasa)",
                100,     TRUE,   TRUE,   'o',    "15-20",
                {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANBACID, NOACID, NOGAS,
                 ISINVIS, ISSCAVENGE, CANDRAW, MAGICHIT, NOSTAB},
                "", 0,
                70,
                {18,    18,     2,      90000,  13,     -8,     HPT("10d8+120"),
                "3d12/4d8+6"}},
{"greater god (Maglubiyet)",
                100,     TRUE,   FALSE,  'm',    "20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, CANINWALL, NOGAS,
                 CANBBOLT, NOBOLT, ISCLEAR, CARRYRING, CARRYFOOD, CARRYPOTION,
         CARRYSCROLL, NOSTAB, NOFIRE, NOCOLD},
                "", 0,
                80,
                {18,    18,     5,      100000, 13,     -12,    HPT("10d8+120"),
                "6d10/6d10"}},
{"greater god (Gruumsh)",
                100,     TRUE,   FALSE,  'G',    "20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, NOGAS, CANINWALL,
                 CANBBOLT, NOBOLT, ISCLEAR, CARRYMISC, CARRYSCROLL, CARRYFOOD,
         CARRYPOTION, NOSTAB, NOFIRE, NOCOLD},
                "", 0,
                80,
                {18,    18,     5,      100000, 13,     -12,    HPT("10d8+120"),
                "6d10/6d10"}},
{"semi-demon (Cambion)",
                0,     TRUE,   TRUE,   'c',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 CANTELEPORT, CANFRIGHTEN, CANBRANDOM, NOBOLT},
                "", 0,
                80,
                {18,    18,     6,      100000, 13,     -5,     HPT("10d8+150"),
                "5d8/5d8"}},
{"minor demon (Dretch)",
                0,     TRUE,   TRUE,   'd',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 CANTELEPORT, CANFRIGHTEN, CANBRANDOM, NOBOLT},
                "", 0,
                80,
                {18,    18,     6,      100000, 13,     -6,     HPT("10d8+150"),
                "3d12/3d12"}},
{"major demon (Nabassu)",
                0,     TRUE,   TRUE,   'n',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 CANTELEPORT, CANFRIGHTEN, CANBRANDOM, NOBOLT},
                "", 0,
                80,
                {18,    18,     6,      110000, 14,     -7,     HPT("10d8+150"),
                "4d10/4d10"}},
{"demon lord (Baphomet)",
                0,     TRUE,   TRUE,   'B',    "20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 CANSUMMON, CANTELEPORT, CANFRIGHTEN, CANBRANDOM, NOBOLT},
                "ancient blue dragon", 2,
                90,
                {20,    20,     5,      110000, 14,     -8,     HPT("10d8+150"),
                "5d10/5d10"}},
{"incubus (Ravana)",
                0,     TRUE,   TRUE,   'R',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOCOLD, NOSTAB, NOGAS},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -7,     HPT("10d8+150"),
                "3d10/3d10"}},
{"succubus (Azazel)",
                0,     TRUE,   TRUE,   'a',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOFIRE, NOSTAB, NOGAS},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -9,     HPT("10d8+150"),
                "3d10/3d10"}},
{"incubus (Putana)",
                0,     TRUE,   TRUE,   'P',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOCOLD, NOSTAB, NOGAS},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -9,     HPT("10d8+150"),
                "3d10/3d10"}},
{"succubus (Sammael)",
                0,     TRUE,   TRUE,   'S',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOFIRE, NOGAS, NOSTAB},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -7,     HPT("10d8+150"),
                "3d10/3d10"}},
{"incubus (Aeshma)",
                0,     TRUE,   TRUE,   'A',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOCOLD, NOSTAB, NOGAS},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -8,     HPT("10d8+150"),
                "3d10/3d10"}},
{"succubus (Belial)",
                0,     TRUE,   TRUE,   'b',    "10-20",
                {ISMEAN, ISUNIQUE, LOOKSTONE, NOFEAR, ISUNDEAD, TURNABLE,
                 CANBRANDOM, TOUCHFEAR, NOFIRE, NOSTAB, NOGAS},
                "", 0,
                90,
                {18,    18,     6,      120000, 14,     -8,     HPT("10d8+150"),
                "3d10/3d10"}},
{"prince of hell (Hutijin)",
                0,     TRUE,   FALSE,   'h',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, CANSUMMON, CANBCGAS,
                 NOGAS, CANINWALL, CANFRIGHTEN, CANBRANDOM, NOBOLT, ISFLY,
                 NOSTAB, NOFIRE},
                "ancient green dragon", 2,
                90,
                {18,    18,     3,      130000, 14,     -10,    HPT("10d8+150"),
                "4d12+8/4d12+8"}},
{"princess of hell (Glasya)",
                0,     TRUE,   FALSE,   'G',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, CANSUMMON, CANBCGAS,
                 NOGAS, CANINWALL, CANFRIGHTEN, CANBRANDOM, NOBOLT, ISFLY,
                 NOSTAB, NOCOLD},
                "ancient red dragon", 2,
                90,
                {18,    18,     3,      130000, 14,     -10,    HPT("10d8+150"),
                "4d12+8/4d12+8"}},
{"prince of hell (Titivilus)",
                0,     TRUE,   FALSE,   't',    "15-20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, CANSUMMON, CANBCGAS,
                 NOGAS, CANINWALL, CANFRIGHTEN, CANBRANDOM, NOBOLT, ISFLY,
                 NOSTAB, NOFIRE},
                "ancient white dragon", 2,
                90,
                {18,    18,     3,      130000, 15,     -10,    HPT("10d8+150"),
                "4d12+8/4d12+8"}},
{"lesser daemon (Pisco)",
                0,     TRUE,   TRUE,   'P',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANPAIN, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -8,     HPT("10d8+160"),
                "10d12"}},
{"lesser daemon (Dergho)",
                0,     TRUE,   TRUE,   'd',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANPAIN, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -8,     HPT("10d8+160"),
                "10d12"}},
{"greater daemon (Ultro)",
                0,     TRUE,   TRUE,   'U',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANAGE, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -9,     HPT("10d8+160"),
                "10d10+10"}},
{"lesser daemon (Hydro)",
                0,     TRUE,   TRUE,   'H',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANPAIN, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -8,     HPT("10d8+160"),
                "10d12"}},
{"lesser daemon (Yagno)",
                0,     TRUE,   TRUE,   'y',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANPAIN, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -8,     HPT("10d8+160"),
                "10d12"}},
{"greater daemon (Arcana)",
                0,     TRUE,   TRUE,   'a',    "15-20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOSTAB,
                 TOUCHSTONE, CANAGE, NOSLOW, NOBOLT},
                "", 0,
                90,
                {18,    18,     5,      140000, 15,     -9,     HPT("10d8+160"),
                "10d10+10"}},
{"oino daemon (Anthraxus)",
                0,     TRUE,   FALSE,   'O',    "20",
                {ISMEAN, ISUNIQUE, BMAGICHIT, ISREGEN, CANBGAS, NOGAS, NOBOLT,
                 TOUCHSTONE, CANFRIGHTEN, CANPAIN, CANAGE, NOFIRE, CANMISSILE,
         CANHOLD, HALFDAMAGE, CANSUMMON, CANBBOLT, NOCOLD, NOSTAB},
                "ancient amethyst dragon", 4,
                90,
                {20,    20,     3,      150000, 15,     -12,    HPT("10d8+170"),
                "10d10+20"}},
{"ipsissimus (Alteran)",
                100,     TRUE,   FALSE,  'i',    "25",
                {ISUNIQUE, CARRYCARD, CARRYFOOD, CMAGICHIT, ISREGEN, NOGAS,
         CANINWALL, CANFRIGHTEN, CANBACID, NOACID, NOBOLT, ISCLEAR,
         NOSLOW, NOFEAR, NODETECT, NOFIRE, NOCOLD, NOSTAB, CANSONIC},
                "", 0,
                100,
                {25,    25,     2,      250000, 16,     -30,    HPT("10d8+200"),
                "10d10/10d10"}},
{"boatman (Charon)",
                0,     TRUE,   FALSE,   'c',    "20",
                {ISMEAN, ISUNIQUE, CMAGICHIT, ISREGEN, CANSUMMON, NOGAS, NOBOLT,
                 CANTELEPORT, CANFRIGHTEN, CANBRANDOM, NOSTAB, NOBOLT, NOFEAR,
                 CANPAIN, DOUBLEDRAIN, CANPOISON, CANHOLD, CANINWALL},
                "ancient saphire dragon", 4,
                100,
                {20,    20,     2,      250000, 18,     -20,    HPT("10d8+200"),
                "12d12/12d12"}},
{"anole", 
                0,      TRUE,   TRUE,   'a',    "10-15",
                {ISMEAN, CANDISEASE},
                "", 0, 
                1,
                {10,    10,     3,      10,      1,      5,      HPT("1d8+5"),
                "1d4"}},
{"creodont", 
                50,     TRUE,   TRUE,   'c',    "12-14",
                {ISMEAN, CANSTINK, NOSLOW},
                "", 0, 
                1,
                {10,    10,     6,      10,      1,      3,      HPT("2d8+5"),
                "1d4"}},
{"gorgosaur", 
                0,      TRUE,   TRUE,   'g',    "8-14",
                {ISMEAN, CANTELEPORT, CANINFEST, NOSTAB},
                "", 0, 
                3,
                {10,    10,     9,      30,      1,      2,      HPT("3d8+5"),
                "1d4/1d6"}},
{"giant cicada", 
                0,      TRUE,   TRUE,   'C',    "4",
                {ISMEAN, AREMANY, ISUNDEAD, TURNABLE, CANPOISON, NOSTAB},
                "", 0, 
                3,
                {10,    10,     6,      30,      2,      4,      HPT("4d8+5"),
                "1d6"}},
{"elasmosaurus", 
                50,      TRUE,   TRUE,   'e',    "10-15",
                {ISMEAN, CANDRAW, CANPARALYZE, CANSMELL},
                "", 0, 
                5,
                {10,    10,     12,      40,      2,      8,      HPT("2d8+10"),
                "2d8"}},
{"trilobite", 
                0,      TRUE,   TRUE,   't',    "10-20",
                {ISMEAN, AREMANY, NOFIRE, NOCOLD, CANINWALL},
                "", 0, 
                2,
                {12,    14,     3,      50,      2,      6,      HPT("2d8+20"),
                "2d8"}},
{"mammoth", 
                50,     TRUE,   TRUE,   'M',    "15",
                {ISMEAN, AREMANY, CANTELEPORT, CANSTINK, CARRYARMOR},
                "", 0,
                7,
                {12,    12,     15,      80,     3,      0,      HPT("3d8+50"),
                "2d4/2d6"}},
{"ichthyosaur", 
                50,     TRUE,   TRUE,   'i',    "10-14",
                {ISMEAN, CARRYWEAPON, CANPOISON, CANINFEST},
                "", 0, 
                4,
                {12,    12,     6,      70,      3,      2,      HPT("2d8+30"),
                "2d6"}},
{"grig", 
                50,     TRUE,   TRUE,   'g',    "8-16",
                {ISMEAN, CANBFIRE, CANCHILL, NOFIRE, NOCOLD},
                "", 0, 
                5,
                {12,    12,     3,      100,     3,      -1,     HPT("3d8+20"),
                "1d4/4d6"}},
{"saber-tooth", 
                0,      TRUE,   TRUE,   's',    "10-17",
                {ISMEAN, CANBICE, ISSHADOW, NOSTAB, NOBOLT, CANHUG, CANTUNNEL},
                "", 0,
                8,
                {12,    12,     6,      100,     4,      -2,     HPT("3d8+50"),
                "2d8/1d12"}},
{"merychippus", 
                0,      TRUE,   TRUE,   'm',    "16",
                {ISMEAN, CANSHRIEK, CANBLIND, CANHUG, CANSNORE},
                "", 0, 
                6,
                {12,    12,     9,      150,     4,      0,      HPT("3d8+30"),
                "4d8"}},
{"nematode", 
                100,    TRUE,   TRUE,   'n',    "8-14",
                {ISMEAN, CANINWALL, CANTELEPORT, NOSTAB, ISSCAVENGE, CARRYFOOD},
                "", 0, 
                10,
                {12,    12,     3,      150,     4,      3,      HPT("3d8+20"),
                "2d12"}},
{"tussah", 
                0,      TRUE,   TRUE,   't',    "12-18",
                {ISMEAN, CANBICE, NOCOLD, NOBOLT, NOSTAB, CANPAIN, NOFEAR},
                "", 0, 
                9,
                {12,    12,     4,       200,    4,      -3,     HPT("4d8+30"),
                "3d8"}},
{"theropod", 
                0,      TRUE,   TRUE,   'T',    "15-20",
                {ISMEAN, ISFLY, CANROT, CANSTINK, CANBFIRE, CANEXPLODE},
                "", 0, 
                8,
                {14,    14,     12,       200,    5,      0,      HPT("4d8+10"),
                "3d8+2"}},
{"mastodon", 
                0,      TRUE,   TRUE,   'm',    "10-15",
                {ISMEAN, CANBFIRE, NOBOLT, NOFIRE, NOCOLD, TURNABLE, NOSTAB},
                "", 0, 
                10,
                {14,    14,     15,      500,    5,      -10,    HPT("4d8+50"),
                "4d8"}},
{"sloth", 
                0,      TRUE,   TRUE,   'S',    "10-18",
                {ISMEAN, NOSTAB, CANSMELL, CANSTINK, NOCOLD, CANSUMMON,
         TOUCHSTONE},
                "trilobite", 4, 
                11,
                {14,    14,     18,       300,    5,     -1,     HPT("4d8+60"),
                "4d8"}},
{"pterodactyl", 
                0,      TRUE,   TRUE,   'P',    "15-20",
                {ISMEAN, AREMANY, ISFLY, NOSLOW, NOBOLT, NOSTAB, CANPAIN},
                "", 0, 
                9,
                {14,    14,     3,       250,    5,      0,      HPT("4d8+30"),
                "2d8/3d8/4d8"}},
{"brontosaurus", 
                0,      TRUE,   TRUE,   'b',    "1",
                {ISMEAN, NOFIRE, CANBFIRE, ISREGEN, CANHOLD, NOBOLT, NOSTAB},
                "", 0, 
                12,
                {14,    14,     12,      900,     5,      -3,     HPT("8d8+50"),
                "6d8"}},
{"sauropod", 
                0,      TRUE,   TRUE,   's',    "10-18",
                {ISMEAN, CANSONIC, NOPARALYZE, NOCOLD, NOSTAB, CANSUMMON,
         NOFIRE},
                "grig", 6,
                10,
                {14,    16,     6,       800,    6,      -4,      HPT("4d8+30"),
                "3d8"}},
{"wooly mammoth", 
                0,      TRUE,   TRUE,   'w',    "15-20",
                {ISMEAN, AREMANY, NOBOLT, NOGAS, NOFIRE, NOACID, CANHUH,
                 TAKEINTEL, NOSTAB},
                "", 0, 
                13,
                {14,    14,     12,     1000,    6,      -7,     HPT("8d8+60"),
                "4d8/6d8"}},
{"brontops", 
                0,      TRUE,   TRUE,  'B',    "10-14",
                {ISMEAN, NOGAS, NOFIRE, NOBOLT, NOFEAR, CANDRAW, TAKEWISDOM},
                "", 0, 
                12,
                {14,    14,     18,       900,    7,      -1,     HPT("8d8+80"),
                "8d8+2"}},
{"tricerotops", 
                0,      TRUE,   TRUE,   'T',    "15-20",
                {ISMEAN, CANSURPRISE, CANMISSILE, CANPOISON, NOBOLT, NOFIRE},
                "", 0, 
                8,
                {14,    14,     6,      1000,    7,      -2,     HPT("8d8+70"),
                "8d8/6d8"}},
{"sinanthropus", 
                50,     TRUE,   TRUE,   's',    "12-20",
                {ISMEAN, CANBACID, NOACID, NOBOLT, CANDRAW, NOFEAR, NOGAS,
                 CANFRIGHTEN, BMAGICHIT},
                "", 0, 
                13,
                {15,    15,     6,      2000,    8,      -8,     HPT("8d8+100"),
                "8d8+5"}},
{"stegosaurus", 
                0,      TRUE,   TRUE,   's',    "15-20",
                {ISMEAN, CANBGAS, CANROT, NOFEAR, NOGAS, CANTUNNEL, NOACID,
                 NOSTAB, CANBCGAS},
                "", 0,
                14,
                {16,    16,     4,      2500,    8,      -10,    HPT("8d8+75"),
                "8d8+7"}},
{"plesiosaurus", 
                0,      TRUE,   TRUE,   'p',    "8-15",
                {ISMEAN, NOGAS, NOSTAB, DOUBLEDRAIN, NOBOLT},
                "", 0, 
                11,
                {18,    18,     9,      2000,    8,      -8,     HPT("8d8+40"),
                "1d4/8d8"}},
{"tyranosaurus rex", 
                0,     TRUE,   TRUE,   'R',    "10-20",
                {ISMEAN, ISREGEN, CANTUNNEL, NOSTAB, NOGAS, NOFIRE, NOBOLT,
         AREMANY, CMAGICHIT, CANFRIGHTEN},
                "", 0,
                15,
                {18,    18,     2,      3000,    8,     -10,    HPT("10d8+100"),
                "6d8/8d8"}},
{"anaconda", 
                80,     TRUE,   TRUE,   'A',    "12-20",
                {ISMEAN, NOGAS, CANSUMMON, CARRYGOLD, STEALGOLD, NOSTAB,
                 NOFIRE, NOBOLT, CANAGE, CANFRIGHTEN},
                "nematode", 6,
                20,
                {18,    18,     4,      4000,   9,     -8,    HPT("10d8+150"),
                "8d8/8d8"}},
{"imperial mammoth", 
                0,      TRUE,   TRUE,   'I',    "15-20",
                {ISMEAN, AREMANY, NOFEAR, ISREGEN, CANHUH, NOCOLD, CANSURPRISE,
                 NOSTAB, CANBGAS, NOGAS, NOFIRE, NOACID, CANBACID},
                "", 0, 
                20,
                {18,    18,     12,     5000,    9,    -10,     HPT("10d8+200"),
                "6d8+10"}},
{"zinjanthropus", 
                80,     TRUE,   TRUE,   'Z',    "18-20",
                {ISMEAN, NOSLOW, CANBICE, CANBFIRE, CANSUMMON, LOOKSTONE,
         NOSTAB, NOBOLT, NOACID, NOCOLD, NOFIRE, NOSLOW},
                "mastodon", 6,
                20,
                {18,    18,     3,      5000,    9,     -15,    HPT("10d8+250"),
                "8d8+10"}},
{"positron", 
                0,      TRUE,   TRUE,   'X',    "1-18",
                {ISMEAN, CANEXPLODE, ISFLY, TURNABLE, ISUNDEAD, BLOWDIVIDE,
                 NOSLOW, HASFIRE, NOFIRE, NOBOLT, CANFRIGHTEN},
                "", 0, 
                25,
                {18,    18,     10,      10000,   9,    -1,     HPT("10d8+250"),
                "4d8/6d8"}},
{"quartermaster", 
                80,      FALSE,  TRUE,   'q',    "25",
                {CANSELL, ISCLEAR, CANTELEPORT, ISFLY, NOSLOW, NOSTAB, NOBOLT,
         NOSLEEP, NOFIRE, NOCOLD, NOFEAR, CANINWALL},
                "", 0,
                30,
                {25,    25,     5,      1000,    7,      -6,     HPT("2d8+20"),
                "8d10"}},
};

