/*
 * global variable declaration
 *
 * Advanced Rogue
 * Copyright (C) 1984, 1985 Michael Morgan, Ken Dalka and AT&T
 * All rights reserved.
 *
 * Based on "Rogue: Exploring the Dungeons of Doom"
 * Copyright (C) 1980, 1981 Michael Toy, Ken Arnold and Glenn Wichman
 * All rights reserved.
 *
 * See the file LICENSE.TXT for full copyright and licensing information.
 */

#include <ctype.h>
#include "curses.h"
#include "rogue.h"

/*
 * Now all the global variables
 */
struct trap traps[MAXTRAPS];
struct room rooms[MAXROOMS];		/* One for each room -- A level */
struct room *oldrp;			/* Roomin(&player.t_oldpos) */
struct thing player;			/* The rogue */
struct object *cur_armor;		/* What a well dresssed rogue wears */
struct object *cur_ring[NUM_FINGERS];	/* Which rings are being worn */
struct object  *cur_misc[NUM_MM];	/* which MM's are in use */
int cur_relic[MAXRELIC];		/* Currently used relics */
struct linked_list *lvl_obj = NULL; 
struct linked_list *mlist = NULL;
struct linked_list *tlist = NULL;	/* list of monsters fallen down traps */
struct linked_list *monst_dead = NULL;	/* monster killed by monster	*/
struct object *cur_weapon = NULL;
int char_type = -1;			/* what type of character is player */
int foodlev = 1;			/* how fast he eats food */
int ntraps;				/* Number of traps on this level */
int trader = 0;				/* no. of purchases */
int curprice = -1;			/* current price of item */
int no_move;				/* Number of turns held in place */
int seed;				/* Random number seed */
int dnum;				/* Dungeon number */
int max_level;				/* Deepest player has gone ever */
int cur_max;				/* Deepest player has gone currently */
int lost_dext;				/* amount of lost dexterity */
int mpos = 0;
int no_command = 0;
int level = 1;
int purse = 0;
int inpack = 0;
int total = 0;
int no_food = 0;			/* how long has he gone with no food */
int foods_this_level = 0;		/* foods made per level */
int count = 0;
int food_left = HUNGERTIME;
int group = 1;
int hungry_state = F_OKAY;
int infest_dam=0;
int lost_str=0;
int lastscore = -1;
int hold_count = 0;
int trap_tries = 0;
int pray_time = 0;
int spell_power = 0;
int turns = 0;				/* Number of turns player has taken */
int quest_item = 0;			/* Item player is looking for */
char nfloors = -1;			/* Number of floors in this dungeon */
char curpurch[15];			/* name of item ready to buy */
char PLAYER = VPLAYER;			/* what the player looks like */
char take;				/* Thing the rogue is taking */
char prbuf[LINELEN*2];			/* Buffer for sprintfs */
char outbuf[BUFSIZ];			/* Output buffer for stdout */
char runch;				/* Direction player is running */
char *s_names[MAXSCROLLS];		/* Names of the scrolls */
char *p_colors[MAXPOTIONS];		/* Colors of the potions */
char *r_stones[MAXRINGS];		/* Stone settings of the rings */
char *ws_made[MAXSTICKS];		/* What sticks are made of */
char whoami[LINELEN];			/* Name of player */
char fruit[LINELEN];			/* Favorite fruit */
char huh[LINELEN];			/* The last message printed */
char *s_guess[MAXSCROLLS];		/* Players guess at what scroll is */
char *p_guess[MAXPOTIONS];		/* Players guess at what potion is */
char *r_guess[MAXRINGS];		/* Players guess at what ring is */
char *ws_guess[MAXSTICKS];		/* Players guess at what wand is */
char *m_guess[MAXMM];			/* Players guess at what MM is */
char *ws_type[MAXSTICKS];		/* Is it a wand or a staff */
char file_name[LINELEN];		/* Save file name */
char score_file[LINELEN];		/* Score file name */
char home[LINELEN];			/* User's home directory */
WINDOW *cw;				/* Window that the player sees */
WINDOW *hw;				/* Used for the help command */
WINDOW *mw;				/* Used to store mosnters */
bool pool_teleport = FALSE;		/* just teleported from a pool */
bool inwhgt = FALSE;			/* true if from wghtchk() */
bool after;				/* True if we want after daemons */
bool waswizard;				/* Was a wizard sometime */
bool s_know[MAXSCROLLS];		/* Does he know what a scroll does */
bool p_know[MAXPOTIONS];		/* Does he know what a potion does */
bool r_know[MAXRINGS];			/* Does he know what a ring does */
bool ws_know[MAXSTICKS];		/* Does he know what a stick does */
bool m_know[MAXMM];			/* Does he know what a MM does */
bool playing = TRUE; 
bool running = FALSE; 
bool wizard = FALSE;
bool notify = TRUE; 
bool fight_flush = FALSE; 
bool terse = FALSE; 
bool auto_pickup = TRUE; 
bool door_stop = FALSE;
bool jump = FALSE; 
bool slow_invent = FALSE; 
bool firstmove = FALSE; 
bool askme = FALSE;
bool in_shell = FALSE; 
bool daytime = TRUE;
coord delta;				/* Change indicated to get_dir() */
LEVTYPE levtype;			/* type of level i'm on */

char *nothing  =	"Nothing seems to happen.";
char *spacemsg =	"--Press space to continue--";
char *morestr  =	"-- More --";
char *retstr   =	"[Press return to continue]";


/*
 * NOTE: the ordering of the points in this array is critical. They MUST
 *	 be listed in the following sequence:
 *
 *		7   4   6
 *		1   0   2
 *		5   3   8
 */

coord grid[9] = {{0,0},
		 { 0,-1}, { 0, 1}, {-1, 0}, { 1, 0},
		 {-1,-1}, { 1, 1}, { 1,-1}, {-1, 1}
		};

struct death_type deaths[DEATHNUM] = {
    { D_ARROW,		"an arrow"},
    { D_DART,		"a dart"},
    { D_BOLT,		"a bolt"},
    { D_POISON,		"poison"},
    { D_POTION,		"a cursed potion"},
    { D_PETRIFY,	"petrification"},
    { D_SUFFOCATION,	"suffocation"},
    { D_INFESTATION,	"a parasite"},
    { D_DROWN,		"drowning"},
    { D_ROT,		"body rot"},
    { D_CONSTITUTION,	"poor health"},
    { D_STRENGTH,	"being too weak"},
    { D_SIGNAL,		"a bug"},
    { D_CHOKE,		"dust of choking"},
    { D_STRANGLE,	"strangulation"},
    { D_FALL,		"a fall"},
    { D_RELIC,		"an artifact's wrath"},
};


/*
 * weapons and their attributes
 */
struct init_weps weaps[MAXWEAPONS] = {
    { "mace",		"2d4",  "1d3", NONE,		ISMETAL, 100, 8 },
    { "long sword",	"1d12", "1d2", NONE,		ISMETAL, 60, 18 },
    { "short bow",	"1d1",  "1d1", NONE,		0, 40, 15 },
    { "arrow",		"1d1",  "1d6", BOW,		ISMANY|ISMISL, 5, 1 },
    { "dagger",		"1d6",  "1d4", NONE,		ISMETAL|ISMISL|ISMANY, 10, 2 },
    { "rock",		"1d2",  "1d4", SLING,		ISMANY|ISMISL, 5, 1 },
    { "two-handed sword","3d6",  "1d2", NONE,		ISMETAL, 250, 40 },
    { "sling",		"0d0",  "0d0", NONE,  		0, 5, 1 },
    { "dart",		"1d1",  "1d3", NONE,  		ISMANY|ISMISL, 5, 1 },
    { "crossbow",	"1d1",  "1d1", NONE,  		0, 100, 15 },
    { "crossbow bolt",	"1d2", "1d12", CROSSBOW,	ISMANY|ISMISL, 7, 1 },
    { "spear",		"1d6",  "1d8", NONE,		ISMETAL|ISMISL, 50, 8 },
    { "trident",	"3d4",  "1d4", NONE,		ISMETAL, 50, 20 },
    { "spetum",		"2d6",  "1d3", NONE,		ISMETAL, 50, 20 },
    { "bardiche",	"3d4",  "1d2", NONE,		ISMETAL, 125, 20 },
    { "pike",		"1d12", "1d8", NONE,		ISMETAL, 80, 18 },
    { "bastard sword",	"2d8",  "1d2", NONE,		ISMETAL, 100, 30 },
    { "halberd",	"2d6",  "1d3", NONE,		ISMETAL, 175, 10 },
    { "battle axe", 	"1d8",	"1d3", NONE,		ISMETAL, 80, 10 },
};

struct init_armor armors[MAXARMORS] = {
	{ "leather armor",		11,  8,  70, 100 },
	{ "ring mail",			22,  7,  50, 250 },
	{ "studded leather armor",	33,  7,  50, 200 },
	{ "scale mail",			45,  6,  70, 250 },
	{ "padded armor",		57,  6, 150, 150 },
	{ "chain mail",			69,  5, 100, 300 },
	{ "splint mail",		80,  4, 150, 350 },
	{ "banded mail",		90,  4, 150, 350 },
	{ "plate mail",		 	96,  3, 400, 400 },
	{ "plate armor",		100, 2, 650, 450 },
};

struct magic_item things[NUMTHINGS] = {
    { "potion",			260,   10 },	/* potion		*/
    { "scroll",			260,   30 },	/* scroll		*/
    { "food",			180,   20 },	/* food			*/
    { "weapon",			 80,	0 },	/* weapon		*/
    { "armor",			 80,	0 },	/* armor		*/
    { "ring",			 50,	5 },	/* ring			*/
    { "stick",			 60,	0 },	/* stick		*/
    { "miscellaneous magic",	 30,   50 },	/* miscellaneous magic	*/
    { "artifact",		  0,   10 },	/* artifact		*/
};

struct magic_item s_magic[MAXSCROLLS] = {
    { "monster confusion",	 60, 125, 0, 0 },
    { "magic mapping",		 50, 150, 0, 0 },
    { "light",			 80, 100, 21, 15 },
    { "hold monster",		 30, 200, 33, 20 },
    { "sleep",			 30, 150, 20, 0 },
    { "enchantment",		180, 200, 9, 9 },
    { "identify",		200, 100, 0, 25 },
    { "scare monster",		 40, 250, 27, 21 },
    { "gold detection",		 30, 110, 0, 0 },
    { "teleportation",		 60, 165, 10, 20 },
    { "create monster",		 30,  75, 0, 0 },
    { "remove curse",		 70, 120, 9, 15 },
    { "petrification",		 10, 185, 0, 0 },
    { "genocide",		 10, 300, 0, 0 },
    { "cure disease",		 80, 160, 0, 0 },
    { "acquirement",		 10, 400, 0, 0 },
    { "protection",		 30, 190, 20, 0 },
};

struct magic_item p_magic[MAXPOTIONS] = {
    { "clear thought",		 60, 180, 27, 10 },
    { "gain ability",		160, 210, 15, 15 },
    { "see invisible",		 60, 150, 25, 15 },
    { "healing",		170, 130, 27, 27 },
    { "monster detection",	 60, 120, 0, 0 },
    { "magic detection",	 60, 105, 0, 0 },
    { "raise level",		 20, 350, 11, 10 },
    { "haste self",		100, 180, 30, 5 },
    { "restore abilities",	160, 140, 0, 0 },
    { "phasing",		 50, 210, 21, 20 },
    { "invisibility",		 50, 230, 0, 15 },
    { "flying",			 50, 130, 0, 20 },
};

struct magic_item r_magic[MAXRINGS] = {
    { "protection",		 50, 200, 33, 25 },
    { "add strength",		 60, 200, 33, 25 },
    { "sustain ability",	 50, 500, 0, 0 },
    { "searching",		 60, 400, 0, 0 },
    { "extra sight",		 40, 350, 0, 0 },
    { "alertness",		 40, 380, 0, 0 },
    { "aggravate monster",	 30, 100, 100, 0 },
    { "dexterity",		 60, 220, 33, 25 },
    { "increase damage",	 60, 220, 33, 25 },
    { "regeneration",		 40, 600, 0, 0 },
    { "slow digestion",		 40, 240, 15, 15 },
    { "teleportation",		 20, 100, 100, 0 },
    { "stealth",		 40, 300, 0, 0 },
    { "add intelligence",	 60, 240, 33, 25 },
    { "increase wisdom",	 60, 220, 33, 25 },
    { "sustain health",		 80, 500, 0,  0 },
    { "burden",			 20, 100, 100, 0 },
    { "illumination",		 30, 520, 0, 0 },
    { "delusion",		 20, 100, 75, 0 },
    { "fear",			 20, 100, 100, 0},
    { "heroism",		 30, 390, 0, 0 },
    { "fire resistance",	 40, 400, 0, 0 },
    { "warmth",	 		 40, 400, 0, 0 },
    { "vampiric regeneration",	 10,1000, 0, 0},
};

struct magic_item ws_magic[MAXSTICKS] = {
    { "light",			 90, 120, 20, 20 },
    { "striking",		 60, 115, 0,  0 },
    { "lightning",		 35, 200, 0,  0 },
    { "fire",			 35, 200, 0,  0 },
    { "cold",			 35, 200, 0,  0 },
    { "polymorph",		 80, 150, 0,  0 },
    { "magic missile",		 80, 170, 0,  0 },
    { "slow monster",		 80, 220, 25, 20 },
    { "drain life",		 90, 210, 20, 0 },
    { "charging",		 80, 400, 0,  0 },
    { "teleport monster",	 90, 140, 25, 20 },
    { "cancellation",		 40, 130, 0,  0 },
    { "confuse monster",   	 35, 100, 15,  0},
    { "disintegration",	  	 10, 300, 33, 0},
    { "petrification",		 10, 300, 0,  0},
    { "paralyze monster",	 30, 180, 15,  0},
    { "degenerate monster",	 30, 250, 30, 0},
    { "curing",			 10, 250, 25, 0},
    { "wonder",			 50, 110,  0, 0},
    { "fear",			 30, 180,  0, 0},
};

/*
 * WARNING: unique miscellaneous magic items must be put at the end
 *	    of this list. They MUST be the last items. The function
 *	    create_obj() in wizard.c depends on it.
 */
struct magic_item m_magic[MAXMM] = {
    { "alchemy jug",	 	  40,   240,  0, 0},
    { "beaker of potions",	  60,   300,  0, 0},
    { "book of spells",		  60,   300,  0, 0},
    { "boots of elvenkind",	  50,   500,  0, 0},
    { "bracers of defense",	 140,   100, 15, 0},
    { "chime of opening",	  50,   250,  0, 0},
    { "chime of hunger",	  50,   100,100, 0},
    { "cloak of displacement",	  60,   500,  0, 0},
    { "cloak of protection",	  70,   200, 15, 0},
    { "drums of panic",		  40,   350,  0, 0},
    { "dust of disappearance",	  40,   300,  0, 0},
    { "dust of choking",	  30,   100,100, 0},
    { "gauntlets of dexterity",	  30,   600, 25, 0},
    { "gauntlets of ogre power",  30,   600, 25, 0},
    { "jewel of attacks",	  40,   150,100, 0},
    { "keoghtoms ointment",	  50,   200,  0, 0},
    { "robe of powerlessness",	  30,   100,100, 0},
    { "gauntlets of fumbling",	  30,   100,100, 0},
    { "necklace of adaptation",	  20,   500,  0, 0},
    { "necklace of strangulation",30,   110,100, 0},
    { "boots of dancing",	  30,	120,100, 0},
    { "book of skills",		  20,	650,  0, 0},
};


struct magic_item rel_magic[MAXRELIC] = {
    { "Daggers of Musty Doit",	   0, 50000,  0, 0},
    { "Cloak of Emori",		   0, 50000,  0, 0},
    { "Ankh of Heil",		   0, 50000,  0, 0},
    { "Staff of Ming",		   0, 50000,  0, 0},
    { "Wand of Orcus",		   0, 50000,  0, 0},
    { "Rod of Asmodeus",	   0, 50000,  0, 0},
    { "Amulet of Yendor",	   0, 50000,  0, 0},
    { "Mandolin of Brian",	   0, 50000,  0, 0},
    { "Horn of Geryon",		   0, 50000,  0, 0},
    { "Morning Star of Hruggek",   0, 50000,  0, 0},
    { "Flail of Yeenoghu",	   0, 50000,  0, 0},
};

/*
 * these are the spells that a magic user can cast
 */
struct spells magic_spells[MAXSPELLS] = {
	{ P_TFIND,		3,	TYP_POTION,	0	  },
	{ S_IDENT,		5,	TYP_SCROLL,	0	  },
	{ S_LIGHT,		7,	TYP_SCROLL,	ISBLESSED },
	{ S_REMOVE,		7,	TYP_SCROLL,	0	  },
	{ S_CONFUSE,		10,	TYP_SCROLL,	0	  },
	{ S_MAP,		10,	TYP_SCROLL,	0	  },
	{ WS_MISSILE,		15,	TYP_STICK,	0	  },
	{ P_CLEAR,		20,	TYP_POTION,	0	  },
	{ S_TELEP,		20,	TYP_SCROLL,	0	  },
	{ S_SLEEP,		20,	TYP_SCROLL,	0	  },
	{ P_SEEINVIS,		20,	TYP_POTION,	0	  },
	{ WS_COLD,		25,	TYP_STICK,	0	  },
	{ WS_ELECT,		25,	TYP_STICK,	0	  },
	{ WS_FIRE,		25,	TYP_STICK,	0	  },
	{ P_HASTE,		30,	TYP_POTION,	0	  },
	{ WS_CANCEL,		30,	TYP_STICK,	0	  },
	{ P_PHASE,		40,	TYP_POTION,	0	  },
	{ S_HOLD,		50,	TYP_SCROLL,	0	  },
	{ S_PROTECT,		60,	TYP_SCROLL,	0	  },
	{ S_ALLENCH,		70,	TYP_SCROLL,	0	  },
};

/*
 * these are the spells that a cleric can cast
 */
struct spells cleric_spells[MAXPRAYERS] = {
	{ P_MFIND,		3,	TYP_POTION,	0	  },
	{ P_TFIND,		7,	TYP_POTION,	0	  },
	{ S_IDENT,		15,	TYP_SCROLL,	0	  },
	{ S_LIGHT,		15,	TYP_SCROLL,	ISBLESSED },
	{ S_REMOVE,		20,	TYP_SCROLL,	0	  },
	{ P_HEALING,		25,	TYP_POTION,	0	  },
	{ S_CURING,		30,	TYP_SCROLL,	0	  },
	{ S_MAP,		30,	TYP_SCROLL,	0	  },
	{ P_CLEAR,		30,	TYP_POTION,	0	  },
	{ P_SEEINVIS,		35,	TYP_POTION,	0	  },
	{ P_RESTORE,		40,	TYP_POTION,	0	  },
	{ P_PHASE,		40,	TYP_POTION,	0	  },
	{ S_TELEP,		45,	TYP_SCROLL,	0	  },
	{ WS_CURING,		50,	TYP_STICK,	ISBLESSED },
	{ WS_DRAIN,		50,	TYP_STICK,	0	  },
};

char *cnames[4][11] = {
{	"Veteran",		"Warrior",	
	"Swordsman",		"Hero",
	"Swashbuckler",		"Myrmidon",	
	"Champion",		"Superhero",
	"Lord",			"Lord",		
	"Lord"
},
{	"Prestidigitator",	"Evoker",	
	"Conjurer",		"Theurgist",
	"Thaumaturgist",	"Magician",	
	"Enchanter",		"Warlock",
	"Sorcerer",		"Necromancer",
	"Wizard"
},
{	"Acolyte",		"Adept",
	"Priest",		"Curate",
	"Prefect",		"Canon",
	"Lama",			"Patriarch",
	"High Priest",		"High Priest",
	"High Priest"
},
{	"Rogue",		"Footpad",
	"Cutpurse",		"Robber",
	"Burglar",		"Filcher",
	"Sharper",		"Magsman",
	"Thief",		"Master Thief",
	"Master Thief"
}
} ;

struct h_list helpstr[] = {
    '?',	"	prints help",
    '/',	"	identify object",
    'h',	"	left",
    'j',	"	down",
    'k',	"	up",
    'l',	"	right",
    'y',	"	up & left",
    'u',	"	up & right",
    'b',	"	down & left",
    'n',	"	down & right",
    'H',	"	run left",
    'J',	"	run down",
    'K',	"	run up",
    'L',	"	run right",
    'Y',	"	run up & left",
    'U',	"	run up & right",
    'B',	"	run down & left",
    'N',	"	run down & right",
    't',	"<dir>	throw something",
    'f',	"<dir>	forward until find something",
    'z',	"<dir>	zap a wand or staff",
    '>',	"	go down a staircase",
    '<',	"	go up a staircase",
    's',	"	search for trap/secret door",
    '.',	"	rest for a while",
    'i',	"	inventory",
    'I',	"	inventory single item",
    'q',	"	quaff potion",
    'r',	"	read paper",
    'e',	"	eat food",
    'w',	"	wield a weapon",
    'W',	"	wear something",
    'T',	"	take off something",
    'd',	"	drop object",
    'P',	"	pick up object(s)",
    'c',	"	call object (generic)",
    'm',	"	mark object (specific)",
    'o',	"	examine/set options",
    'C',	"	cast a spell",
    'p',	"	pray",
    'a',	"	affect the undead",
    '^',	"	set a trap",
    'G',	"	sense gold",
    'D',	"	dip something (into a pool)",
    CTRL('T'),	"<dir>	take (steal) from (direction)",
    CTRL('U'),	"	use miscellaneous magic item",
    CTRL('L'),	"	redraw screen",
    CTRL('R'),	"	repeat last message",
    ESCAPE,	"	cancel command",
    'v',	"	print program version number",
    '!',	"	shell escape",
    'S',	"	save game",
    'Q',	"	quit",
    0, 0
} ;

struct h_list wiz_help[] = {
    CTRL('A'),	"	system activity",
    CTRL('C'),	"	move to	another	dungeon	level",
    CTRL('D'),	"	down 1 dungeon level",
    CTRL('E'),	"	food remaining",
    CTRL('F'),	"	display entire level",
    CTRL('H'),	"	jump 9 experience levels",
    CTRL('I'),	"	inventory of level",
    CTRL('J'),	"	teleport",
    CTRL('N'),	"	recharge staff",
    CTRL('P'),	"	toggle wizard status",
    CTRL('U'),	"	up 1 dungeon level",
    CTRL('X'),	"	detect monsters",
    CTRL('Z'),	"	identify",
    'M',	"	make object",
    0, 0
};


#define HPT(x) x
struct monster monsters[NUMMONST+1] = {
/* {"Name",
		CARRY,	NORMAL,	WANDER,	APPEAR,	INTEL,
		{ATTRIBUTES},
		"SUMMONED_CREATURE", NUMBER_SUMMONED,
		ADDED_EXPERIENCE/HIT_POINT,
		{str	exp,	level,	"armor", hit_points,
		"damage"}}, */
{"unknown",
		0,	FALSE,	FALSE,	'\0',	"",
		{0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		0,
		0, 0,
		{10,	0,	0,	0,	HPT(""),
		""}},
{"bat",
		0,	TRUE,	FALSE,	'b',	"2-4",
		{ISMEAN, ISHUH, CANDISEASE, ISFLY, ISHASTE},
		0, 0,
		0,
		{10,	5,	2,	1,	HPT("1d4"),
		"1d2"}},
{"giant rat",
		0,	TRUE,	TRUE,	'R',	"2-4",
		{ISMEAN, CANDISEASE},
		0, 0,
		1,
		{10,	7,	1,	7,	HPT("1d4"),
		"1d3"}},
{"kobold",
		10,	TRUE,	TRUE,	'K',	"8",
		{ISMEAN, CANSHOOT, CARRYWEAPON},
		0, 0,
		1,
		{9,	5,	1,	7,	HPT("1d4"),
		"1d4"}},
{"gnome",
		10,	TRUE,	TRUE,	'G',	"11-12",
		{CANSHOOT, CARRYPOTION, CARRYWEAPON},
		0, 0,
		1,
		{10,	8,	1,	5,	HPT("1d6"),
		"1d6"}},
{"halfling",
		10,	TRUE,	TRUE,	'H',	"11-12",
		{CANSHOOT, CARRYPOTION, CARRYWEAPON},
		0, 0,
		1,
		{8,	9,	1,	4,	HPT("1d6"),
		"1d6"}},
{"dwarf",
		15,	TRUE,	TRUE,	'D',	"11-12",
		{CANSHOOT, CARRYPOTION, CARRYWEAPON},
		0, 0,
		1,
		{14,	10,	1,	4,	HPT("1d8"),
		"1d8"}},
{"orc",
		15,	TRUE,	TRUE,	'O',	"8",
		{ISMEAN, CANSHOOT, CARRYGOLD, CARRYWEAPON},
		0, 0,
		1,
		{12,	10,	1,	6,	HPT("1d8"),
		"1d8"}},
{"manes",
		0,	TRUE,	TRUE,	'M',	"2-4",
		{ISMEAN, MAGICHIT, ISUNDEAD, TURNABLE},
		0, 0,
		1,
		{10,	18,	1,	7,	HPT("1d8"),
		"1d2/1d2/1d4"}},
{"elf",
		50,	TRUE,	TRUE,	'E',	"13-20",
		{CANSHOOT, CARRYPOTION, CARRYSCROLL, CARRYWEAPON},
		0, 0,
		2,
		{12,	20,	1,	5,	HPT("1d8+1"),
		"1d10"}},
{"hobgoblin",
		10,	TRUE,	TRUE,	'h',	"8-10",
		{ISMEAN, CANSHOOT, CARRYWEAPON},
		0, 0,
		2,
		{14,	20,	1,	5,	HPT("1d8+1"),
		"1d8"}},
{"fire beetle", 
		0,	TRUE,	TRUE,	'B',	"0",
		{ISMEAN, HASFIRE},
		0, 0,
		2,
		{10,	20,	1,	4,	HPT("1d8+2"),
		"2d4"}},
{"giant ant",
		0,	TRUE,	TRUE,	'A',	"1",
		{ISMEAN, CANPOISON},
		0, 0,
		3,
		{10,	40,	2,	3,	HPT("2d8"),
		"1d6/1d6"}},
{"zombie",
		0,	TRUE,	TRUE,	'Z',	"0",
		{ISMEAN, ISUNDEAD, TURNABLE},
		0, 0,
		2,
		{10,	20,	2,	8,	HPT("2d8"),
		"1d8"}},
{"ear seeker",
		0,	TRUE,	TRUE,	'e',	"0",
		{ISMEAN, CANINFEST},
		0, 0,
		0,
		{10,	0,	1,	9,	HPT("1d1"),
		"0d0"}},
{"shrieker",
		0,	TRUE,	FALSE,	'S',	"0",
		{CANSHRIEK, NOMOVE, NOSTAB},
		0, 0,
		1,
		{10,	5,	3,	7,	HPT("3d8"),
		"0d0"}},
{"stirge",
		0,	TRUE,	TRUE,	's',	"1",
		{ISMEAN, CANDRAW, ISFLY},
		0, 0,
		2,
		{10,	36,	4,	8,	HPT("1d8+1"),
		"1d3"}},
{"gas spore",
		0,	TRUE,	FALSE,	'a',	"0",
		{ISMEAN, CANEXPLODE, CANINFEST, ISFLY},
		0, 0,
		5,
		{10,	90,	1,	9,	HPT("1d1"),
		"1d1"}},
{"troglodyte",
		5,	TRUE,	TRUE,	'T',	"5-7",
		{ISMEAN, CANSMELL, CANSHOOT, CARRYGOLD, CARRYWEAPON},
		0, 0,
		2,
		{10,	36,	2,	5,	HPT("2d8"),
		"1d3/1d3/2d5"}},
{"lemure",
		0,	TRUE,	FALSE,	'L',	"2-4",
		{ISMEAN, ISREGEN, MAGICHIT, ISUNDEAD, TURNABLE},
		0, 0,
		3,
		{10,	65,	3,	7,	HPT("3d8"),
		"1d3"}},
{"bugbear",
		5,	TRUE,	TRUE,	'b',	"5-8",
		{ISMEAN, CANSHOOT, CANSURPRISE, CARRYGOLD, CARRYPOTION,
		 CARRYWEAPON},
		0, 0,
		4,
		{16,	135,	3,	5,	HPT("3d8+1"),
		"2d4"}},
{"wererat",
		20,	TRUE,	TRUE,	'r',	"11-12",
		{ISMEAN, MAGICHIT, CARRYFOOD},
		0, 0,
		4,
		{10,	150,	3,	6,	HPT("3d8+1"),
		"1d8"}},
{"ghoul",
		0,	TRUE,	TRUE,	'g',	"5-7",
		{ISMEAN, CANPARALYZE, ISUNDEAD, TURNABLE},
		0, 0,
		2,
		{10,	65,	2,	6,	HPT("2d8"),
		"1d3/1d3/1d6"}},
{"leprechaun",
		100,	TRUE,	FALSE,	'l',	"15-16",
		{CARRYGOLD, STEALGOLD},
		0, 0,
		1,
		{10,	80,	6,	3,	HPT("1d4+1"),
		"0d0"}},
{"ogre",
		50,	TRUE,	TRUE,	'o',	"5-7",
		{ISMEAN, CARRYGOLD, CARRYWEAPON},
		0, 0,
		5,
		{18,	90,	4,	5,	HPT("4d8+1"),
		"1d10"}},
{"centaur",
		15,	TRUE,	TRUE,	'C',	"5-10",
		{CANSHOOT, CARRYPOTION, CARRYGOLD},
		0, 0,
		4,
		{10,	85,	4,	4,	HPT("4d8"),
		"1d6/1d6"}},
{"nymph",
		100,	TRUE,	FALSE,	'N',	"15-16",
		{STEALMAGIC, CARRYSCROLL, CARRYPOTION},
		0, 0,
		3,
		{10,	350,	4,	9,	HPT("3d8"),
		"0d0"}},
{"violet fungi", 
		0,	TRUE,	FALSE,	'F',	"0",
		{ISMEAN, CANHOLD, NOMOVE, CANROT, NOSTAB},
		0, 0,
		4,
		{10,	135,	3,	7,	HPT("3d8"),
		"5d1"}},
{"giant tick",
		0,	TRUE,	TRUE,	't',	"0",
		{ISMEAN, CANDRAW, CANDISEASE},
		0, 0,
		2,
		{10,	105,	3,	3,	HPT("3d8"),
		"1d4"}},
{"gelatinous cube", 
		90, TRUE,	TRUE,	'c',	"0",
		{ISMEAN, ISSCAVENGE, CANPARALYZE, NOSTAB, CARRYFOOD},
		0, 0,
		4,
		{10,	150,	4,	8,	HPT("4d8"),
		"2d4"}},
{"blink dog",
		0,	TRUE,	TRUE,	'B',	"8-10",
		{ISMEAN, CANBLINK},
		0, 0,
		5,
		{10,	170,	4,	5,	HPT("4d8"),
		"1d6"}},
{"very young dragon", 
		10,	TRUE,	FALSE,	'd',	"15-16",
		{ISMEAN, CANBRANDOM, ISGREED, CARRYGOLD, CARRYSTICK},
		0, 0,
		9,
		{10,	100,	9,	-1,	HPT("9d1"),
		"1d4/1d4/2d4"}},
{"rust monster", 
		0,	TRUE,	TRUE,	'R',	"1",
		{ISMEAN, CANRUST},
		0, 0,
		4,
		{10,	185,	5,	2,	HPT("3d8"),
		"0d0/0d0"}},
{"ghast",
		0,	TRUE,	TRUE,	'G',	"11-12",
		{CANPARALYZE, CANSTINK, ISMEAN, ISUNDEAD, TURNABLE},
		0, 0,
		4,
		{10,	190,	4,	4,	HPT("4d8"),
		"1d4/1d4/1d8"}},
{"blindheim",
		0,	TRUE,	FALSE,	'b',	"1",
		{CANBLIND, ISMEAN},
		0, 0,
		4,
		{8,	200,	2,	1,	HPT("4d8+2"),
		"1d8"}},
{"shadow",
		0,	TRUE,	TRUE,	'S',	"5-7",
		{ISSHADOW, ISMEAN, CANCHILL, ISUNDEAD, TURNABLE},
		0, 0,
		4,
		{10,	255,	3,	7,	HPT("3d8+3"),
		"1d4+1"}},
{"gargoyle",
		5,	TRUE,	TRUE,	'g',	"5-7",
		{ISMEAN, MAGICHIT, CARRYSTICK},
		0, 0,
		5,
		{10,	165,	4,	5,	HPT("4d8+4"),
		"1d3/1d3/1d6/1d4"}},
{"su-monster", 10,	TRUE,	TRUE,	's',	"8-10",
		{ISMEAN, CARRYSCROLL, CARRYGOLD, CARRYFOOD},
		0, 0,
		6,
		{10,	225,	5,	6,	HPT("5d8+5"),
		"4d4/2d4"}},
{"gray ooze", 
		50,	TRUE,	FALSE,	'o',	"1",
		{ISMEAN, NOMOVE, CANRUST, ISSCAVENGE, NOCOLD, NOFIRE, NOSTAB,
		 CARRYSTICK, CARRYFOOD},
		0, 0,
		5,
		{10,	200,	3,	8,	HPT("3d8+3"),
		"2d8"}},
{"owlbear",
		5,	TRUE,	TRUE,	'O',	"5-7",
		{ISMEAN, CANHUG, CARRYRING, CARRYFOOD},
		0, 0,
		8,
		{10,	225,	5,	5,	HPT("5d8+2"),
		"1d6/1d6/2d6"}},
{"quasit",
		30,	TRUE,	TRUE,	'Q',	"5-7",
		{ISMEAN, ISREGEN, MAGICHIT, CANSURPRISE, CANITCH,
		 CARRYSCROLL, CARRYGOLD, CARRYPOTION, NOCOLD, NOFIRE, NOBOLT},
		0, 0,
		3,
		{10,	325,	7,	2,	HPT("3d8"),
		"1d2/1d2/1d4"}},
{"doppleganger", 
		0,	TRUE,	TRUE,	'D',	"11-12",
		{ISMEAN, CANSURPRISE},
		0, 0,
		4,
		{10,	330,	10,	5,	HPT("4d8"),
		"1d12"}},
{"yeti",	
		30,	TRUE,	TRUE,	'Y',	"8-10",
		{ISMEAN, CANPARALYZE, CANHUG, NOCOLD, CANSURPRISE,
		 CARRYGOLD, CARRYPOTION},
		0, 0,
		8,
		{13,	500,	6,	6,	HPT("4d8+4"),
		"1d6/1d6"}},
{"leucrotta", 
		0,	TRUE,	FALSE,	'L',	"8-10",
		{ISMEAN},
		0, 0,
		8,	
		{10,	475,	6,	4,	HPT("6d8+1"),
		"3d6/1d6/1d6"}},
{"imp", 
		25,	TRUE,	TRUE,	'I',	"8-10",
		{ISMEAN, ISREGEN, MAGICHIT, CANPOISON, CANSURPRISE,
		 CANTELEPORT, CARRYRING, CARRYSTICK, NOCOLD, NOBOLT, NOFIRE},
		0, 0,
		3,
		{10,	275,	2,	2,	HPT("2d8+2"),
		"1d4"}},
{"cockatrice", 
		0,	TRUE,	TRUE,	'C',	"1",
		{ISMEAN, TOUCHSTONE},
		0, 0,
		5,
		{10,	315,	5,	6,	HPT("5d8"),
		"1d3"}},
{"wight",
		0,	TRUE,	TRUE,	'W',	"8-10",
		{ISMEAN, CANDRAIN, MAGICHIT, ISUNDEAD, TURNABLE},
		0, 0,
		5,
		{10,	540,	4,	5,	HPT("4d8+3"),
		"1d4"}},
{"troll",
		50,	TRUE,	FALSE,	'T',	"5-7",
		{ISMEAN, ISREGEN, CARRYFOOD, CARRYGOLD, CARRYSTICK},
		0, 0,
		8,
		{18,	600,	6,	4,	HPT("6d8+6"),
		"1d4+4/1d4+4/2d6"}},
{"jackalwere", 
		50,	TRUE,	TRUE,	'J',	"11-12",
		{ISMEAN, CANSHOOT, CANSNORE, MAGICHIT, CARRYFOOD, CARRYGOLD,
		 CARRYSCROLL},
		0, 0,
		4,
		{10,	800,	4,	4,	HPT("4d8"),
		"2d4"}},
{"wraith",
		0,	TRUE,	TRUE,	'w',	"11-12",
		{ISMEAN, CANDRAIN, MAGICHIT, ISUNDEAD, TURNABLE},
		0, 0,
		6,
		{10,	575,	5,	4,	HPT("5d8+3"),
		"1d6"}},
{"erinyes",
		25,	TRUE,	TRUE,	'E',	"8-10",
		{ISMEAN, CANFRIGHTEN, CANSUMMON, TURNABLE, CANPAIN, CANSEE, 
		 NOFIRE, CANTELEPORT, CARRYRING, CARRYSTICK},
		"ghoul", 3, 
		8,
		{10,	875,	7,	2,	HPT("6d8+6"),
		"2d4"}},
{"lava child", 
		0,	TRUE,	TRUE,	'l',	"8-10",
		{ISMEAN, NOMETAL},
		0, 0,
		8,	
		{10,	950,	5,	4,	HPT("5d8+1"),
		"1d6/1d6/2d12"}},
{"basilisk",
		0,	TRUE,	FALSE,	'B',	"1",
		{ISMEAN, LOOKSTONE},
		0, 0,
		8,
		{10,	1000,	6,	4,	HPT("6d8+1"),
		"1d10"}},
{"mummy",
		20,	TRUE,	FALSE,	'm',	"5-7",
		{ISMEAN,CANINFEST, MAGICHIT, CANFRIGHTEN, HALFDAMAGE, ISUNDEAD, 
		 TURNABLE, CARRYRING, CARRYSTICK},
		0, 0,
		8,
		{10,	1150,	6,	3,	HPT("6d8+3"),
		"1d12"}},
{"otyugh",
		0,	TRUE,	TRUE,	'o',	"5-10",
		{ISMEAN, CANDISEASE},
		0, 0,
		8,
		{10,	700,	7,	3,	HPT("7d8"),
		"1d8/1d8/1d4+1"}},
{"adult dragon", 
		30,	TRUE,	FALSE,	'd',	"15-16",
		{ISMEAN, CANBRANDOM, ISGREED, CANFRIGHTEN, CARRYGOLD,
		 CARRYPOTION, CARRYSTICK},
		0, 0,
		9,
		{10,	1000,	9,	-1,	HPT("45d1"),
		"1d6/1d6/2d6"}},
{"invisible stalker", 
		0, TRUE,	TRUE,	'i',	"13-14",
		{ISMEAN, ISINVIS},
		0, 0,
		10,
		{10,	1090,	8,	3,	HPT("8d8"),
		"4d4"}},
{"xorn",
		0,	TRUE,	TRUE,	'X',	"8-10",
		{ISMEAN, CANINWALL, NOCOLD, NOFIRE, CANSURPRISE, NOBOLT},
		0, 0,
		10,
		{10,	1275,	7,	-2,	HPT("7d8+7"),
		"1d3/1d3/1d3/4d6"}},
{"will-o-wisp", 100,	TRUE,	FALSE,	'W',	"15-16",
		{ISMEAN, CANSURPRISE, ISFLY, CARRYGOLD, CARRYMISC, NOBOLT},
		0, 0,
		12,
		{10,	2000,	9,	-8,	HPT("9d8"),
		"2d8"}},
{"chimera",
		0,	TRUE,	FALSE,	'c',	"2-4",
		{ISMEAN, CANBFIRE, NOFIRE},
		0, 0,
		12,
		{10,	1000,	9,	6,	HPT("9d8"),
		"1d3/1d3/1d4/1d4/2d4/3d4"}},
{"mimic",
		20,	TRUE,	FALSE,	'M',	"2-10",
		{ISDISGUISE, CANHOLD, CARRYFOOD, CARRYRING, CARRYGOLD},
		0, 0,
		12,
		{10,	1300,	9,	7,	HPT("9d8"),
		"3d4"}},
{"horned devil", 
		5,	TRUE,	TRUE,	'H',	"13-14",
		{ISMEAN, CANFRIGHTEN, CANINFEST, CANPOISON, MAGICHIT, CANSUMMON,
		 NOFIRE, CANTELEPORT, CARRYGOLD, CARRYRING, CARRYSTICK},
		"wight", 2, 
		6,
		{10,	1320,	7,	-3,	HPT("5d8+5"),
		"1d4/1d4/1d4+1/1d3"}},
{"specter",
		0,	TRUE,	TRUE,	'S',	"13-14",
		{ISMEAN, DOUBLEDRAIN, ISUNDEAD, TURNABLE},
		0, 0,
		10,
		{10,	1650,	7,	2,	HPT("7d8+3"),
		"1d8"}},
{"lamia", 
		0,	TRUE,	TRUE,	'L',	"13-14",
		{ISMEAN, TAKEWISDOM},
		0, 0,
		9,	
		{10,	1500,	9,	3,	HPT("9d8"),
		"1d4/1d4"}},
{"neo-otyugh",
		0,	TRUE,	TRUE,	'N',	"10-12",
		{ISMEAN, CANDISEASE},
		0, 0,
		10,
		{12,	1500,	10,	0,	HPT("12d8"),
		"2d6/2d6/1d3"}},
{"barbed devil", 
		0,	TRUE,	TRUE,	'B',	"11-12",
		{TOUCHFEAR, CANSUMMON, ISMEAN, CANHOLD, TURNABLE, NOFIRE,
		 CANTELEPORT},
		"ghast", 4, 
		10,
		{10,	1425,	8,	0,	HPT("8d8"),
		"2d4/2d4/3d4"}},
{"vrock",
		10,	TRUE,	TRUE,	'V',	"5-7",
		{ISMEAN, CANSUMMON, CANSEE, TURNABLE, CANTELEPORT, CARRYGOLD,
		 CARRYRING, CARRYSTICK},
		"erinyes", 2, 
		10,
		{10,	1500,	8,	0,	HPT("8d8"),
		"1d4/1d4/1d8/1d8/1d6"}},
{"shambling mound", 
		25, TRUE,	TRUE,	's',	"5-7",
		{ISMEAN, CANSUFFOCATE, NOCOLD, NOFIRE, CANHOLD, CARRYGOLD,
		 CARRYFOOD, CARRYRING},
		0, 0,
		10,
		{10,	1800,	9,	0,	HPT("9d8"),
		"2d8/2d8"}},
{"umber hulk",
		40,	TRUE,	TRUE,	'U',	"8-10",
		{ISMEAN, CANHUH, CANINWALL, CANTUNNEL, CARRYSCROLL,
		 CARRYPOTION, CARRYFOOD},
		0, 0,
		12,
		{10,	1700,	8,	2,	HPT("8d8+8"),
		"3d4/3d4/2d5"}},
{"ettin",
		0,	TRUE,	TRUE,	'e',	"0",
		{ISMEAN, CANSHOOT},
		0, 0,
		14,
		{10,	1950,	10,	3,	HPT("10d8"),
		"2d8/3d6"}},
{"black pudding", 
		30,	TRUE,	FALSE,	'P',	"0",
		{ISMEAN, CANRUST, NOCOLD, BOLTDIVIDE, BLOWDIVIDE, ISSCAVENGE, 
		 NOSTAB, CARRYSCROLL, CARRYSTICK, CARRYPOTION, CARRYRING},
		0, 0,
		14,
		{10,	2000,	10,	6,	HPT("10d8"),
		"3d8"}},
{"hezrou",
		15,	TRUE,	TRUE,	'h',	"5-7",
		{ISMEAN, CANFRIGHTEN, CANSEE, CANSUMMON, TURNABLE, CANTELEPORT,
		 CARRYPOTION, CARRYRING, CARRYSTICK},
		"wight", 3, 
		12,
		{10,	2000,	9,	-2,	HPT("9d8"),
		"1d3/1d3/4d4"}},
{"glabrezu",
		25,	TRUE,	FALSE,	'G',	"8-10",
		{ISMEAN, CANFRIGHTEN, CANSEE, CANSUMMON, TURNABLE, CANTELEPORT,
		 CARRYSCROLL, CARRYPOTION, CARRYGOLD},
		"wraith", 3, 
		14,
		{10,	2400,	10,	-4,	HPT("10d8"),
		"2d6/2d6/1d3/1d3/1d4+1"}},
{"bone devil",
		0,	TRUE,	TRUE,	'b',	"11-12",
		{ISMEAN, CANFRIGHTEN, CANSEE, CANSUMMON, CANSURPRISE, CANCHILL, 
		 TURNABLE, NOFIRE, NOCOLD, CANTELEPORT},
		"ghast", 3, 
		12,
		{10,	2800,	9,	-1,	HPT("9d8"),
		"2d4"}},
{"white pudding", 
		30,	TRUE,	FALSE,	'w',	"0",
		{ISMEAN, CANDISSOLVE, NOCOLD, BOLTDIVIDE, BLOWDIVIDE, 
		 ISSCAVENGE, NOSTAB, CARRYRING, CARRYSTICK, CARRYSCROLL,
		 CARRYPOTION},
		0, 0,
		14,
		{10,	2200,	9,	8,	HPT("10d8"),
		"7d4"}},
{"vampire",
		20,	TRUE,	TRUE,	'v',	"15-16",
		{ISMEAN, ISREGEN, CANSUCK, ISUNDEAD, TURNABLE, CARRYMISC},
		0, 0,
		12,
		{20,	3800,	8,	1,	HPT("8d8+3"),
		"1d6+4"}},
{"ghost",	
		20,	TRUE,	FALSE,	'g',	"13-14",
		{ISMEAN, CANFRIGHTEN, CANAGE, ISUNDEAD, TURNABLE, CARRYMISC, 
		 CMAGICHIT, CANINWALL},
		0, 0,
		10,
		{13,	5000,	12,	0,	HPT("10d8"),
		"1d12"}},
{"intellect devourer",
		0,	TRUE,	FALSE,	'D',	HPT("11-12"),
		{ISMEAN, TAKEINTEL, CMAGICHIT, HALFDAMAGE, CANSURPRISE, NOFIRE, 
		 NOCOLD},
		0, 0,
		9,
		{10,	5000,	7,	4,	HPT("6d8+6"),	
		"1d4/1d4/1d4/1d4"}},
{"ice devil",
		30,	TRUE,	FALSE,	'I',	"13-14",
		{ISMEAN, CANSEE, ISREGEN, CANFRIGHTEN, CANSUMMON, CANBICE, 
		 NOCOLD, NOFIRE, CANSLOW, CANTELEPORT, CARRYSCROLL, CARRYRING,
		 CARRYSTICK},
		"bone devil", 2, 
		16,
		{20,	4400,	11,	-4,	HPT("11d8"),
		"1d4/1d4/2d4/3d4"}},
{"purple worm", 
		70,	TRUE,	TRUE,	'p',	"0",
		{ISMEAN, CANPOISON, CANINWALL, CANTUNNEL, CARRYFOOD, CARRYGOLD},
		0, 0,
		20,
		{10,	4900,	15,	6,	HPT("15d8"),
		"2d12/2d4"}},
{"ancient brass dragon", 
		70,	TRUE,	FALSE,	'r',	"13-14",
		{CANBSGAS, CANBFGAS, ISGREED, CANSEE, NOSLEEP, NOFEAR,
		 CARRYGOLD, CARRYRING},
		0, 0,
		50,
		{10,	10000,	8,	2,	HPT("0d8+64"),
		"1d4/1d4/4d4"}},
{"pit fiend",
		100,	TRUE,	TRUE,	'f',	"15-16",
		{ISMEAN, CANSEE, BMAGICHIT, CANFRIGHTEN, CANHOLD, CANSUMMON, 
		 CANBFIRE, NOFIRE, CANTELEPORT, CARRYSTICK, HASFIRE},
		"barbed devil", 3, 
		18,
		{22,	10000,	13,	-3,	HPT("13d8"),
		"1d4+4/1d6+6"}},
{"ancient white dragon", 
		70,	TRUE,	TRUE,	'W',	"8-9",
		{ISMEAN, CANBICE, ISGREED, CANSEE, NOCOLD, CARRYGOLD,
		 CARRYRING},
		0, 0,
		50,
		{10,	15000,	7,	3,	HPT("0d8+56"),
		"1d4/1d4/2d8"}},
{"ancient black dragon", 
		70,	TRUE,	TRUE,	'a',	"8-10",
		{ISMEAN, CANBACID, NOACID, ISGREED, CANSEE, CARRYGOLD,
		 CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	8,	3,	HPT("0d8+64"),
		"1d4/1d4/3d6"}},
{"lich",
		60,	TRUE,	TRUE,	'l',	"19-20",
		{ISMEAN, CANDRAIN, CANSEE, CANPARALYZE, CANFRIGHTEN, MAGICHIT, 
		 ISUNDEAD, TURNABLE, NOBOLT, CANMISSILE, CANSUMMON, CARRYGOLD,
		 CARRYSCROLL, CARRYPOTION, CARRYRING},
		"specter", 2,
		16,
		{10,	20000,	17,	0,	HPT("11d8"),
		"1d10"}},
{"titan",
		80,	TRUE,	FALSE,	't',	"17-20",
		{ISSHADOW, CANSEE, CANMISSILE, CARRYRING, CARRYSTICK, 
		 CANTELEPORT},
		0, 0,
		30,
		{13,	20000,	19,	-3,	HPT("22d8"),
		"8d6"}},
{"ancient copper dragon", 
		70,	TRUE,	FALSE,	'c',	"13-14",
		{CANBACID, NOACID, CANBSLGAS, ISGREED, CANSEE, NOSLOW,
		 CARRYGOLD, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	9,	1,	HPT("0d8+72"),
		"1d4/1d4/5d4"}},
{"ancient green dragon", 
		50,	TRUE,	TRUE,	'E',	"10-12",
		{ISMEAN, CANBGAS, ISGREED, CANSEE, NOGAS, CARRYGOLD,
		 CARRYRING, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	9,	2,	HPT("0d8+72"),
		"1d6/1d6/2d10"}},
{"ancient bronze dragon", 
		50,	TRUE,	FALSE,	'L',	"15-16",
		{CANBCGAS, CANBBOLT, CANBFGAS, ISGREED, CANSEE, NOFEAR, NOBOLT, 
		 ISCLEAR, CARRYGOLD, CARRYRING, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	10,	0,	HPT("0d8+80"),
		"1d6/1d6/4d6"}},
{"ancient blue dragon", 
		50,	TRUE,	TRUE,	'u',	"12-14",
		{ISMEAN, CANBBOLT, ISGREED, CANSEE, NOBOLT, CARRYGOLD,
		 CARRYSCROLL, CARRYRING, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	10,	2,	HPT("0d8+80"),
		"1d6/1d6/3d8"}},
{"ancient silver dragon", 
		40,	TRUE,	FALSE,	'S',	"15-16",
		{CANBICE, CANBPGAS, ISGREED, CANSEE, CANMISSILE, NOCOLD, 
		 NOPARALYZE, CARRYGOLD, CARRYSCROLL, CARRYRING, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	11,	-1,	HPT("0d8+88"),
		"1d6/1d6/5d6"}},
{"frost giant",
		50,	TRUE,	TRUE,	'F',	"5-10",
		{ISMEAN, NOCOLD, CARRYGOLD, CARRYSTICK},
		0, 0,
		40,
		{25,	20000,	15,	4,	HPT("10d8+4"),
		"4d6"}},
{"ancient red dragon", 
		40,	TRUE,	TRUE,	'R',	"15-16",
		{ISMEAN, CANBFIRE, ISGREED, CANSEE, NOFIRE, CARRYGOLD,
		 CARRYPOTION, CARRYRING, CARRYSTICK},
		0, 0,
		50,
		{10,	20000,	11,	-1,	HPT("0d8+88"),
		"1d8/1d8/3d10"}},
{"ancient gold dragon", 
		50,	TRUE,	TRUE,	'G',	"17-18",
		{CANBFIRE, CANBGAS, ISGREED, CANSEE, CANMISSILE, NOFIRE, NOGAS,
		 CARRYGOLD, CARRYPOTION, CARRYRING, CARRYSTICK, CANTELEPORT},
		0, 0,
		50,
		{10,	20000,	12,	-2,	HPT("0d8+96"),
		"1d8/1d8/6d6"}},
{"fire giant",
		30,	TRUE,	TRUE,	'f',	"6-10",
		{ISMEAN, CARRYGOLD, NOFIRE, CARRYSTICK},
		0, 0,
		45,
		{27,	26000,	15,	4,	HPT("11d8+5"),
		"5d6"}},
{"storm giant",
		30,	TRUE,	TRUE,	's',	"8-10",
		{ISMEAN, NOBOLT, CANBBOLT, CARRYRING},
		0, 0,
		50,
		{30,	30000,	15,	2,	HPT("15d8+8"),
		"7d6"}},
{"dwarven thief (Musty Doit)",
		50,	TRUE,	TRUE,	'm',	"16",
		{ISMEAN, ISUNIQUE, ISINVIS, NOFIRE, NOGAS, NOSTAB, STEALGOLD,
		 STEALMAGIC, CANPAIN, ISFLY, CARRYGOLD, CANSURPRISE, CANSEE,
		 CARRYDAGGER, CARRYMISC, CARRYPOTION, CANBSTAB, ISSCAVENGE},
		0, 0,
		0,
		{11,	300000,	20,	-5,	HPT("0d8+95"),
		"6d4+70/6d4+70"}},
{"demon prince (Jubilex)", 
		100,	TRUE,	FALSE,	'J',	"18",
		{ISMEAN, ISUNIQUE, CANFRIGHTEN, ISREGEN, BMAGICHIT, ISSHADOW, 
		 CANHOLD, CANDISEASE, CANSUMMON, CANSEE, CANROT, CANINFEST, 
		 CANRUST, NOSTAB, CANTELEPORT, CARRYMISC},
		"black pudding", 4, 
		0,
		{10,	100000,	20,	-7,	HPT("0d8+88"),
		"4d10"}},
{"arch devil (Geryon)", 
		100,	TRUE,	FALSE,	'g',	"16",
		{ISMEAN, ISUNIQUE, BMAGICHIT, CANSEE, ISSHADOW, CANFRIGHTEN, 
		 CANHUH, CANPOISON, CANSUMMON, NOFIRE, CANTELEPORT,
		 CARRYMISC, CARRYHORN},
		"ice devil", 5, 
		0,
		{13,	110000,	30,	-3,	HPT("0d8+133"),
		"3d6/3d6/2d4"}},
{"arch devil (Dispater)", 
		100,	TRUE,	FALSE,	'd',	"18",
		{ISMEAN, ISUNIQUE, CANSEE, CANFRIGHTEN, CANHUH, BMAGICHIT, 
		 CANSUMMON, NOFIRE, CANTELEPORT, CARRYMISC},
		"ghost", 9, 
		0,
		{10,	120000,	36,	-2,	HPT("0d8+144"),
		"4d6"}},
{"demon prince (Yeenoghu)", 
		100,	TRUE,	FALSE,	'Y',	"16",
		{ISMEAN, ISREGEN, ISUNIQUE, MAGICHIT, CANSEE, ISSHADOW, CANHOLD,
		 CARRYFLAIL, CANFRIGHTEN, CANPARALYZE, CANSUMMON, CANHUH, 
		 CANMISSILE, CANTELEPORT, CARRYMISC},
		"lich", 5, 
		0,
		{10,	130000,	23,	-5,	HPT("0d8+100"),
		"3d6/3d6"}},
{"witch (Emori)",
		50,	TRUE,	FALSE,	'w',	"18",
		{ISMEAN, CANMISSILE, ISINVIS, CANBBOLT, CANBFIRE, CANBICE,
		 CANSEE, CANSUMMON, ISUNIQUE, CANSNORE, ISFLY, TAKEINTEL,
		 CANDANCE, CANDISEASE, NOBOLT, NOCOLD, NOFIRE, CARRYCLOAK,
		 ISCLEAR, CARRYSCROLL, CARRYSTICK, CANTELEPORT},
		"shambling mound", 5,
		0,
		{11,	240000,	25,	 6,	HPT("0d8+102"),
		"1d4/1d4"}},
{"cleric of Thoth (Heil)",
		100,	TRUE,	FALSE,	'h',	"16",
		{ISMEAN, CANSEE, NOFEAR, ISREGEN, CANHOLD, CANBFIRE, ISUNIQUE, 
		 DOUBLEDRAIN, CANSUMMON, NOFIRE, TOUCHFEAR, CANDISEASE,
		 CANSEE, TAKEWISDOM, CARRYANKH, CARRYRING, ISINVIS, ISFLY},
		 "mummy", 9,
		 0,
		 {15,	295000,	20,	-8,	HPT("0d8+116"),
		 "0d6+11"}},
{"magician (Tsoming Zen)",
		80,	TRUE,	FALSE,	'z',	"18",
		{ISMEAN, ISUNIQUE, ISINVIS, ISREGEN, CANBFIRE, CANBICE,
		 CANBBOLT, CANMISSILE, NOFIRE, CANHOLD, CANFRIGHTEN, CANDISEASE,
		 CANPAIN, CANSUMMON, CANSEE, ISFLY, CANBLINK, CANTELEPORT,
		 CARRYSTAFF, CARRYSTICK, NOSLOW, NOBOLT, NOCOLD},
		 "blink dog", 5,
		 0,
		 {16,	310000,	21,	  0,	HPT("0d8+125"),
		 "2d4+1/2d4+1/2d4+1/2d4+1"}},
{"poet (Brian)",
		80,	TRUE,	TRUE,	'p',	"16",
		{ISMEAN, ISUNIQUE, STEALGOLD, ISSHADOW, CANSUMMON, ISREGEN,
		 CANDISEASE, NOCOLD, NOBOLT, NOFIRE, NOFEAR, CANTUNNEL, CANSEE,
		 CANINWALL, ISCLEAR, CARRYMANDOLIN, CARRYPOTION, CARRYRING},
		"umber hulk", 6,
		0,
		{19,	320000,	20,	-2,	HPT("0d8+153"),
		"8d8+48/4d4+36"}},
{"lesser god (Hruggek)",
		100,	TRUE,	FALSE,	'H',	"17",
		{ISMEAN, CANSEE, ISUNIQUE, CANSUMMON, ISREGEN, 
		 CANTELEPORT, CARRYMISC, CARRYMSTAR},
		"purple worm", 6,
		0,
		{19,	140000,	25,	0,	HPT("0d8+221"),
		"2d8/2d8"}},
{"lesser god (Kurtulmak)",
		100,	TRUE,	TRUE,	'K',	"19",
		{ISMEAN, CANFRIGHTEN, CANPOISON, CANSEE, ISUNIQUE, CANSUMMON,
		 CANTELEPORT, CARRYMISC},
		"lich", 3,
		0,
		{19,	150000,	27,	0,	HPT("0d8+219"),
		"2d12/1d6"}},
{"demigod (Vaprak \"The Destroyer\")",
		100,	TRUE,	TRUE,	'v',	"18",
		{ISMEAN, ISUNIQUE, ISREGEN, MAGICHIT, CANSEE, CANSUMMON,
		 CANTELEPORT, CARRYMISC},
		"troll", 9,
		0,
		{16,	160000,	26,	0,	HPT("0d8+198"),
		"2d10/2d10/1d12"}},
{"platinum dragon (Bahamut)", 
		100,	TRUE,	FALSE,	'P',	"20",
		{ISUNIQUE, CANBICE, CANBGAS, CANBBOLT, CANBRANDOM, CANSEE, 
		 NOCOLD, NOBOLT, NOGAS, NOFIRE, NOFEAR, NOSLEEP, NOSLOW, 
		 NOPARALYZE, CANMISSILE, CANSONIC, CANFRIGHTEN, CANSUMMON,
		 CARRYSTICK, CARRYMISC, CANTELEPORT},
		"ancient gold dragon", 4,
		0,
		{10,	170000,	38,	-3,	HPT("0d8+168"),
		"2d6/2d6/6d8"}},
{"arch devil (Baalzebul)", 
		100,	TRUE,	FALSE,	'B',	"18",
		{ISMEAN, ISSHADOW, ISUNIQUE, BMAGICHIT, CANHOLD, CANPOISON, 
		 CANFRIGHTEN, CANHUH, CANSUMMON, CANSEE, NOFIRE, CANTELEPORT,
		 CARRYMISC},
		"horned devil", 9, 
		0,
		{10,	180000,	37,	-5,	HPT("0d8+166"),
		"2d6"}},
{"chromatic dragon (Tiamat)", 
		100,	TRUE,	FALSE,	'C',	"18",
		{ISMEAN, ISUNIQUE, CANBFIRE, CANBACID, CANBBOLT, CANBICE, 
		 CANBGAS, CANBRANDOM, CANSEE, NOFIRE, NOBOLT, NOCOLD, NOACID, 
		 NOGAS, CANSUMMON, CANMISSILE, CANFRIGHTEN, CARRYMISC,
		 CARRYRING, CANTELEPORT},
		"ancient red dragon", 6,
		0,
		{10,	190000,	29,	0,	HPT("0d8+128"),
		"2d8/3d6/2d10/3d8/3d10/1d6"}},
{"demon prince (Orcus)", 
		100,	TRUE,	FALSE,	'O',	"20",
		{ISMEAN, ISUNIQUE, BMAGICHIT, CANPOISON, CANFRIGHTEN, CANSEE, 
		 CANBBOLT, CANSUMMON, NOBOLT, CANTELEPORT, CARRYWAND, 
		 CARRYMISC, CANTELEPORT},
		"vampire", 9, 
		0,
		{13,	200000,	27,	-6,	HPT("0d8+120"),
		"1d10+3/2d4"}},
{"arch devil (Asmodeus)", 
		100,	TRUE,	FALSE,	'A',	"20",
		{ISMEAN, ISUNIQUE, CANSEE, ISSHADOW, CANHOLD, BMAGICHIT, 
		 CANFRIGHTEN, CANHUH, CANSLOW, CANSUMMON, NOFIRE,
		 CANTELEPORT, CARRYROD, CARRYMISC},
		"pit fiend", 5, 
		0,
		{10,	210000,	45,	-7,	HPT("0d8+199"),
		"1d10+4"}},
{"demon prince (Demogorgon)", 
		100,	TRUE,	FALSE,	'D',	"20",
		{ISMEAN, CANHUH, BMAGICHIT, DOUBLEDRAIN, CANINFEST, CANSEE, 
		 CANFRIGHTEN, ISUNIQUE, CANSUMMON, CANROT, CANTELEPORT,
		 CANDISEASE, CARRYMISC},
		"glabrezu", 9, 
		0,
		{10,	220000,	45,	-8,	HPT("0d8+200"),
		"1d6/1d6"}},
{"greater god (Maglubiyet)",
		100,	TRUE,	FALSE,	'M',	"19",
		{ISMEAN, ISUNIQUE, CMAGICHIT, CANSEE, ISREGEN, CANSUMMON,
		 CANTELEPORT, CARRYMISC},
		"lich", 6,
		0,
		{10,	230000,	45,	-1,	HPT("0d8+350"),
		"4d10"}},
{"greater god (Gruumsh)",
		100,	TRUE,	FALSE,	'G',	"19",
		{ISMEAN, ISUNIQUE, CMAGICHIT, CANSEE, ISREGEN, CANSUMMON,
		 CANTELEPORT, CARRYMISC},
		"lich", 9,
		0,
		{10,	240000,	45,	-1,	HPT("0d8+350"),
		"4d10"}},
{"lesser god (Thrym)",
		100,	TRUE,	FALSE,	'T',	"16",
		{ISMEAN, NOCOLD, ISUNIQUE, ISREGEN, CMAGICHIT, CANSEE, 
		 CANSUMMON, CARRYMISC, CANTELEPORT},
		"frost giant", 9,
		0,
		{25,	250000,	45,	-2,	HPT("0d8+300"),
		"4d10/4d10"}},
{"lesser god (Surtur)",
		100,	TRUE,	FALSE,	't',	"19",
		{ISMEAN, NOFIRE, ISUNIQUE, ISREGEN, CMAGICHIT, CANSEE, 
		 CANSUMMON, CANMISSILE, CANTELEPORT, CARRYMISC},
		"fire giant", 9,
		0,
		{25,	260000,	45,	-2,	HPT("0d8+380"),
		"5d10/5d10"}},
{"lesser god (Skoraeus Stonebones)",
		100,	TRUE,	FALSE,	'b',	"19",
		{ISMEAN, ISUNIQUE, ISREGEN, CMAGICHIT, CANSEE, CANSUMMON, 
		 CANMISSILE, CANINWALL, CANTELEPORT, CARRYMISC, CARRYSTICK},
		"storm giant", 9,
		0,
		{25,	270000,	45,	-1,	HPT("0d8+380"),
		"6d10/6d10"}},
{"ruler of greater titans (Yendor)",
		100,	TRUE,	TRUE,	'y',	 "25",
		{ISMEAN, CANINWALL, ISUNIQUE, ISREGEN, CMAGICHIT,
		 CANSUMMON, CANMISSILE, CANFRIGHTEN, CANBFIRE, NOFIRE, 
		 CANHOLD, CARRYAMULET, CANSEE, CANDANCE, ISSHADOW,
		 CANTELEPORT, CARRYMISC, CARRYRING, CARRYSTICK},
		"titan", 15,
		0,
		{25,	300000, 45,	-3,	HPT("0d8+400"),
		"7d10/7d10"}},
{"quartermaster", 
		50,	FALSE,	TRUE,	'q',	"18",
		{CANSELL, CARRYPOTION, CARRYSCROLL, CARRYMISC, CARRYRING,
		 CARRYSTICK, CANTELEPORT},
		0, 0,
		2,
		{12,	20,	1,	-4, 	HPT("1d8+1"),
		"1d10"}},
};
