'This program is free software; you can redistribute it and/or modify it
'under the terms of the GNU General Public License as published by the Free
'Software Foundation; either version 2 of the License, or (at your option)
'any later version.
'
'This program is distributed in the hope that it will be useful, but WITHOUT
'ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
'FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
'more details.
'
'You should have received a copy of the GNU General Public License along
'with this program; if not, write to the Free Software Foundation, Inc.,
'59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
'
DECLARE FUNCTION Sort% (String1$, String2$)
DECLARE SUB Fin ()
DECLARE SUB Looser (Word$, Snd$)
DECLARE SUB PrintLogo (num%)
DECLARE SUB FSleep (x%)
DECLARE SUB Delmouth ()
DECLARE SUB Winner (Snd$)
DECLARE FUNCTION Check% (Word$, letter$, Tried$)
DECLARE SUB PlayGame (Snd$)

CONST pVer$ = "1.04"
CONST pDate$ = "2006"

SCREEN 1
Snd$ = "On "
ReLoad:
choice% = 1
CLS
COLOR 1
LOCATE 25, 1: PRINT " Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " "; pDate$;

FOR x% = 0 TO 7
  CALL PrintLogo(x%)
NEXT x%

LOCATE 11, 18: PRINT "Ŀ";
LOCATE 12, 18: PRINT "             ";
LOCATE 13, 18: PRINT "             ";
LOCATE 14, 18: PRINT "             ";
LOCATE 15, 18: PRINT "             ";
LOCATE 16, 18: PRINT "             ";
LOCATE 17, 18: PRINT "";

LOCATE 8, 19: PRINT "Hangman v"; pVer$
LOCATE 13, 22: PRINT "Play";
LOCATE 15, 22: PRINT "Exit";
GoAgain:
LOCATE 14, 22: PRINT "Sound "; Snd$;

DO
    IF LastKey$ = CHR$(0) + "H" THEN choice% = choice% - 1
    IF LastKey$ = CHR$(0) + "P" OR LastKey$ = CHR$(9) THEN choice% = choice% + 1
    IF choice% < 1 THEN choice% = 3
    IF choice% > 3 THEN choice% = 1
    LOCATE 13, 20: IF choice% = 1 THEN PRINT "*";  ELSE PRINT " ";
    LOCATE 14, 20: IF choice% = 2 THEN PRINT "*";  ELSE PRINT " ";
    LOCATE 15, 20: IF choice% = 3 THEN PRINT "*";  ELSE PRINT " ";
    DO: SLEEP: LastKey$ = INKEY$: LOOP UNTIL LastKey$ <> ""
    IF LastKey$ = CHR$(27) THEN choice% = 3: LastKey$ = CHR$(13)
LOOP UNTIL LastKey$ = CHR$(13)
IF choice% = 1 THEN CALL PlayGame(Snd$)
IF choice% = 2 THEN IF Snd$ = "On " THEN Snd$ = "Off" ELSE Snd$ = "On "
IF choice% = 2 THEN GOTO GoAgain
IF choice% = 3 THEN CALL Fin
GOTO ReLoad

FUNCTION Check% (Word$, letter$, Tried$)
valeur% = 0
FOR x% = 1 TO LEN(Word$)
      IF UCASE$(MID$(Word$, x%, 1)) = UCASE$(letter$) THEN valeur% = 1
NEXT x%
IF ASC(UCASE$(letter$)) < 65 OR ASC(UCASE$(letter$)) > 90 THEN valeur% = -1
FOR x% = 1 TO LEN(Tried$) - 1
      IF UCASE$(MID$(Tried$, x%, 1)) = UCASE$(letter$) THEN valeur% = -1
NEXT x%
Check% = valeur%
END FUNCTION

SUB Delmouth
LINE (232 - 15, 60 + 24)-(232 + 15, 60 + 24), 1
CIRCLE (232, 60 + 28), 15, 1, 0 * 3.1415 / 180, 180 * 3.1415 / 180, .4
CIRCLE (232, 60 + 22), 15, 1, 180 * 3.1415 / 180, 0 * 3.1415 / 180, .4
END SUB

SUB Fin

SCREEN 0
WIDTH 80
CLS
PRINT
PRINT "            HANGMAN V"; pVer$; " COPYRIGHT (C) MATEUSZ VISTE "; CHR$(34); "FOX"; CHR$(34); " "; pDate$
PRINT
PRINT " ---------------------------------------------------------------------------"
PRINT
PRINT " This program  is free software;  you can  redistribute it  and/or modify it"
PRINT " under the terms of the  GNU General Public License as published by the Free"
PRINT " Software Foundation;  either version 2 of the License,  or (at your option)"
PRINT " any later version."
PRINT
PRINT " This program is distributed in the hope that it will be useful, but WITHOUT"
PRINT " ANY  WARRANTY;  without even  the implied  warranty of  MERCHANTABILITY  or"
PRINT " FITNESS FOR A PARTICULAR  PURPOSE.  See the GNU  General Public License for"
PRINT " more details."
PRINT
PRINT " You should  have received  a copy of  the GNU General Public  License along"
PRINT " with this program;  if not,  write to the  Free Software Foundation,  Inc.,"
PRINT " 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA."
PRINT
PRINT " ---------------------------------------------------------------------------"
PRINT " Hangman's homepage  ->  http://www.the.killer.webpark.pl"
PRINT
SYSTEM

END SUB

SUB FSleep (x%)
FOR z% = 1 TO x%
    t! = TIMER
    DO: LOOP UNTIL t! <> TIMER
NEXT z%
DO: LOOP UNTIL INKEY$ = ""
END SUB

SUB Looser (Word$, Snd$)
PALETTE 2, 4: PALETTE 1, 4: COLOR 4

IF Snd$ = "On " THEN
    FOR x% = 600 TO 100 STEP -15
        SOUND x%, 1
    NEXT x%
END IF
CALL FSleep(10)

CLS
PRINT : PRINT "Game Over! The correct word was:": PRINT : PRINT Word$;
LOCATE 25, 1: PRINT "Press any key...": DO: SLEEP: LOOP UNTIL INKEY$ <> ""
END SUB

SUB PlayGame (Snd$)
DIM VocFiles(1 TO 20) AS STRING * 12
DIM SortTable(1 TO 20) AS STRING * 12
RANDOMIZE TIMER * 100
CLS
LOCATE 2, 5: PRINT "Please select a vocabulary file:"

File$ = DIR$("*.VOC")
IF File$ = "" THEN SCREEN 0: WIDTH 80: PRINT "Error: there isn't any vocabulary file in current directory!": SYSTEM

VocNumb% = 0
DO
   VocNumb% = VocNumb% + 1
   SortTable(VocNumb%) = UCASE$(MID$(File$, 1, 1)) + LCASE$(MID$(File$, 2, LEN(File$) - 1))
   File$ = DIR$
LOOP UNTIL VocNumb% = 20 OR File$ = ""

FOR x% = 1 TO VocNumb%         ' Initializes empty VocFiles array's values
   VocFiles(x%) = CHR$(255)    ' to be at the end of the ASCII table.
NEXT x%                        ' Otherwise sorting would fails...

FOR Death% = 1 TO VocNumb%
   FOR x% = 1 TO VocNumb%
      IF Sort%(VocFiles(x%), SortTable(Death%)) = 0 THEN EXIT FOR
   NEXT x%
   FOR Correct% = VocNumb% TO x% + 1 STEP -1      ' I am using variables
      VocFiles(Correct%) = VocFiles(Correct% - 1) ' Death% and Correct% here
   NEXT Correct%                                  ' only for memory saving!
   VocFiles(x%) = SortTable(Death%)
NEXT Death%

LOCATE 4, 14: PRINT "Ŀ";
FOR x% = 1 TO VocNumb% + 2
   LOCATE x% + 4, 14: PRINT "            ";
NEXT x%
LOCATE VocNumb% + 7, 14: PRINT "";

choice% = 1
DO: LastKey$ = INKEY$
  FOR x% = 1 TO VocNumb%
    LOCATE x% + 5, 16
    IF x% = choice% THEN PRINT "*";  ELSE PRINT " ";
    LOCATE x% + 5, 18: PRINT MID$(VocFiles(x%), 1, LEN(RTRIM$(VocFiles(x%))) - 4);
  NEXT x%
  IF LastKey$ = CHR$(0) + "H" THEN choice% = choice% - 1
  IF LastKey$ = CHR$(0) + "P" THEN choice% = choice% + 1
  IF LastKey$ = CHR$(27) THEN GOTO Finish
  IF choice% = 0 THEN choice% = VocNumb%
  IF choice% > VocNumb% THEN choice% = 1
LOOP UNTIL LastKey$ = CHR$(13)
File$ = VocFiles(choice%)

ReStart:
Death% = 0
Correct% = 0
CLS
OPEN File$ FOR INPUT AS #1
Count! = 0
DO
   Count! = Count! + 1
   LINE INPUT #1, Word$
LOOP UNTIL EOF(1)
CLOSE #1

FOR RandSeed% = 0 TO INT(RND * 10)  '
    x! = INT(RND(1) * Count!)       ' Here is the random generator...
NEXT RandSeed%                      '

OPEN File$ FOR INPUT AS #1
FOR Count! = 0 TO x!
   LINE INPUT #1, Word$
NEXT Count!
CLOSE #1

PALETTE 2, 9
PALETTE 1, 1
FOR x% = 1 TO 300
      PSET (INT(RND * 320), INT(RND * 200)), 2
NEXT x%
CIRCLE (232, 60), 40, , , , 1.1
CIRCLE (232 - 16, 60 - 9), 8, , , , .7
CIRCLE (232 + 16, 60 - 9), 8, , , , .7
CIRCLE (232 - 16, 60 - 9), 2, 2
CIRCLE (232 + 16, 60 - 9), 2, 2
CIRCLE (232 - 16, 60 - 9), 1, 2
CIRCLE (232 + 16, 60 - 9), 1, 2
CIRCLE (232 - 16, 60 - 11), 10, , 30 * 3.1415 / 180, (180 - 30) * 3.1415 / 180, .6
CIRCLE (232 + 16, 60 - 11), 10, , 30 * 3.1415 / 180, (180 - 30) * 3.1415 / 180, .6
CIRCLE (232, 60 + 2), 9, , 180 * 3.1415 / 180, 360 * 3.1415 / 180, 2.5

CALL PrintLogo(0)

LOCATE 24, 2
FOR Count% = 1 TO LEN(Word$)
   PRINT "_";
NEXT Count%
FOR Count% = 1 TO LEN(Word$)
   a$ = MID$(Word$, Count%, 1)
   IF ASC(UCASE$(a$)) < 65 OR ASC(UCASE$(a$)) > 90 THEN
      LOCATE 24, 1 + Count%: PRINT a$;
      Correct% = Correct% + 1
   END IF
NEXT Count%
Tried$ = ""
LOCATE 16, 21: PRINT "Choose a letter...";
LOCATE 18, 21: PRINT "A B C D E F G H I";
LOCATE 19, 21: PRINT "J K L M N O P Q R";
LOCATE 20, 21: PRINT "S T U V W X Y Z";
LINE (140, 0)-(140, 170)
LINE (0, 170)-(320, 170)
LINE (232 - 15, 60 + 24)-(232 + 15, 60 + 24)

DO
ReLoop:
DO: LastKey$ = INKEY$: LOOP UNTIL LastKey$ <> ""
IF LastKey$ = CHR$(27) THEN GOTO Finish
IF ASC(LastKey$) < 32 OR LEN(LastKey$) <> 1 THEN GOTO ReLoop
LastKey$ = UCASE$(LastKey$)
Tried$ = Tried$ + LastKey$
CALL Delmouth
a% = Check%(Word$, LastKey$, Tried$)
IF a% >= 0 THEN LOCATE 18 + (ASC(LastKey$) - 65) \ 9, 21 + ((ASC(LastKey$) - 2) MOD 9) * 2: PRINT "*";
IF a% = 1 THEN
   CIRCLE (232, 60 + 22), 15, , 180 * 3.1415 / 180, 0 * 3.1415 / 180, .4
   IF Snd$ = "On " THEN SOUND 1000, 1

   FOR x% = 1 TO LEN(Word$)
       IF UCASE$(MID$(Word$, x%, 1)) = UCASE$(LastKey$) THEN Correct% = Correct% + 1: LOCATE 24, 1 + x%: PRINT LastKey$;
   NEXT x%
   IF Correct% = LEN(Word$) THEN CALL Winner(Snd$): GOTO ReStart
 ELSEIF a% = 0 THEN
      CIRCLE (232, 60 + 28), 15, , 0 * 3.1415 / 180, 180 * 3.1415 / 180, .4
      Death% = Death% + 1
      CALL PrintLogo(Death%)
      IF Snd$ = "On " THEN SOUND 100, 2
      IF Death% = 7 THEN CALL Looser(Word$, Snd$): GOTO Finish
 ELSE
      Tried$ = LEFT$(Tried$, LEN(Tried$) - 1)
      LINE (232 - 15, 60 + 24)-(232 + 15, 60 + 24)
END IF

LOOP
Finish:
END SUB

SUB PrintLogo (num%)

SELECT CASE num%
   CASE 0
    LINE (20, 145)-(110, 140) 'Ziemia
    LINE (90, 50)-(88, 140)   'Pal
    LINE (52, 48)-(89, 50)    'Ga
    LINE (75, 50)-(89, 64)    'Wzmocnienie
   CASE 1
    LINE (52, 48)-(52, 67)    'Sznur
   CASE 2
    CIRCLE (52, 74), 7        'Gowa
   CASE 3
    LINE (52, 80)-(52, 100)   'Korpus
   CASE 4
    LINE (52, 100)-(46, 128)  'Lewa noga
   CASE 5
    LINE (52, 100)-(56, 129)  'Prawa noga
   CASE 6
    LINE (52, 85)-(45, 103)   'Lewa rka
   CASE 7
    LINE (52, 84)-(59, 105)   'Prawa rka
END SELECT
END SUB

FUNCTION Sort% (tString1$, tString2$)
'
' The Sort function is used to two elements.
'
' Invocation:  Sort%(String1$, String2$)
'
' Result: Sort% = 1 if String1$ and String2$ are already sorted,
'         otherwise Sort% = 0
'
' Example: Sort%("Annie", "Michel") will give 1,
'          Sort%("Monika", "Mathew") will give 0.
'

String1$ = LCASE$(tString1$)
String2$ = LCASE$(tString2$)

IF LEN(String1$) > LEN(String2$) THEN
    String2$ = String2$ + SPACE$(LEN(String1$) - LEN(String2$))
  ELSE
    String1$ = String1$ + SPACE$(LEN(String2$) - LEN(String1$))
END IF

x% = 0
DO: x% = x% + 1
IF x% > LEN(String1$) THEN x% = 1: EXIT DO
IF MID$(String1$, x%, 1) < MID$(String2$, x%, 1) THEN x% = 1: EXIT DO
IF MID$(String1$, x%, 1) > MID$(String2$, x%, 1) THEN x% = 0: EXIT DO
LOOP

Sort% = x%
END FUNCTION

SUB Winner (Snd$)

FOR x = .7 TO .1 STEP -.08
  CIRCLE (232 + 16, 60 - 9), 8, , , , x
  CALL FSleep(1)
  CIRCLE (232 + 16, 60 - 9), 8, 0, , , x
NEXT x

LINE (232 + 16 - 8, 60 - 9)-(232 + 16 + 8, 60 - 9)

IF Snd$ = "On " THEN PLAY "MFMNT200O3E4D8C4C8C4D8E4E8E8D8C8D8E8D8C4O2B8O3MLC2C8": CALL FSleep(5) ELSE CALL FSleep(30)
END SUB

