DECLARE SUB setDifficulty ()
DECLARE SUB drawBridgeGround ()
DECLARE SUB niceHouse (dialog%)
DECLARE SUB drawSnow (amount%)
DECLARE SUB hurrayForEarth ()
DECLARE SUB drawHalfForest ()
DECLARE SUB itsGoodToBeTheKing ()
DECLARE SUB drawCaveScene ()
DECLARE SUB hellbentOi ()
DECLARE SUB drawTrees ()
DECLARE SUB wtfJustHappened ()
DECLARE SUB checkEvents (areaNum%)
DECLARE SUB hotDogDialog ()
DECLARE SUB cliffWoes ()
DECLARE SUB tutorialComplete ()
DECLARE SUB gameOver (fate%)
DECLARE SUB badMove (direction$, badNum%)
DECLARE SUB attack ()
DECLARE SUB setEventData (areaNum%)
DECLARE SUB preGame ()
DECLARE FUNCTION motd% (areaNum%)
DECLARE FUNCTION sureQuit% ()
DECLARE SUB instructions ()
DECLARE SUB aboutNE ()
DECLARE SUB redrawFace ()
DECLARE SUB timingControl (speed%)
DECLARE SUB initGfx ()
DECLARE SUB postGame ()
DECLARE FUNCTION menu% ()
DECLARE SUB preTitle ()
DECLARE SUB areaExit (direction$, areaNum%)
DECLARE SUB debugInfo ()
DECLARE SUB tips (areaNum%)
DECLARE SUB move (direction$)
DECLARE SUB console ()
DECLARE SUB drawArea (areaNum%)
DECLARE SUB init ()


'    Wry 3 version 3: Malodorous & Stale
'       By: Erik Eriksen

DEFINT A-Z                'defines unspecified variables as "int"s.
RANDOMIZE TIMER

'variable constants
CONST TRUE = 1
CONST FALSE = 0
CONST LEFT = 0
CONST RIGHT = 1
CONST EXITING = 3
CONST MAXEVENTS = 10
CONST XMAX = 300
CONST mrFaceHeight = 7
CONST mrFaceWidth = 13
CONST badGuyHeight = 8
CONST badMaskHeight = 10
CONST badGuyWidth = 13
CONST groundHeight = 8
CONST waterHeight = 6
CONST lavaHeight = 8
CONST spikeWidth = 5
CONST spikeHeight = 6
CONST signHeight = 20
CONST signWidth = 24
CONST hotDogHeight = 45
CONST hotDogWidth = 28
CONST groundY = 179
CONST MAXBAD = 5       'max number of bad guys at once.
CONST MAXHAZARDS = 15

'sprite arrays.
DIM SHARED CROWN(2, 5)
DIM SHARED CROWNMASK(2, 5)
DIM SHARED MRFACEFIRE(mrFaceHeight, mrFaceWidth) 'sprites are actually a global
DIM SHARED MRFACENOFIRE(mrFaceHeight, mrFaceWidth)
DIM SHARED BIGMRFACE(hotDogHeight, hotDogWidth)   'yeah he's the same size
DIM SHARED BIGMRFACELEGS(7, 5)
DIM SHARED GROUND(groundHeight, 1)              '2d or 1d array of colors pixels.
DIM SHARED DIRTGROUND(groundHeight, 1)
DIM SHARED SEMISNOWGROUND(groundHeight, 1)
DIM SHARED SNOWGROUND(groundHeight, 1)
DIM SHARED WATER(waterHeight, 1)
DIM SHARED LAVA(lavaHeight, 1)
DIM SHARED PIT(lavaHeight, 1)
DIM SHARED SPIKE(spikeHeight, spikeWidth)
DIM SHARED BRIDGE(groundHeight, 1)
DIM SHARED SIGNL(signHeight, signWidth)
DIM SHARED SIGNR(signHeight, signWidth)
DIM SHARED BADGUYFIRE(badGuyHeight, badGuyWidth)
DIM SHARED BADGUYNOFIRE(badGuyHeight, badGuyWidth)
DIM SHARED BADMASKCLEAN(badGuyHeight, badGuyWidth)
DIM SHARED BADMASK(badMaskHeight, badGuyWidth)
DIM SHARED BADABSORB(badMaskHeight, badGuyWidth)
DIM SHARED HOTDOGSTAND(hotDogHeight, hotDogWidth)

DIM SHARED eventXmin(MAXEVENTS) AS INTEGER
DIM SHARED eventXmax(MAXEVENTS) AS INTEGER
DIM SHARED eventText(MAXEVENTS) AS STRING
DIM SHARED numOfEvents AS INTEGER

DIM SHARED waterHazardXmin(MAXHAZARDS) AS INTEGER
DIM SHARED waterHazardXmax(MAXHAZARDS) AS INTEGER
DIM SHARED waterHazardWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfWaterHazards AS INTEGER

DIM SHARED lavaHazardXmin(MAXHAZARDS) AS INTEGER
DIM SHARED lavaHazardXmax(MAXHAZARDS) AS INTEGER
DIM SHARED lavaHazardWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfLavaHazards AS INTEGER

DIM SHARED pitHazardXmin(MAXHAZARDS) AS INTEGER
DIM SHARED pitHazardXmax(MAXHAZARDS) AS INTEGER
DIM SHARED pitHazardWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfPitHazards AS INTEGER

DIM SHARED specialPitHazardXmin(MAXHAZARDS) AS INTEGER
DIM SHARED specialPitHazardXmax(MAXHAZARDS) AS INTEGER
DIM SHARED specialPitHazardWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfSpecialPitHazards AS INTEGER

DIM SHARED spikeHazardXmin(MAXHAZARDS) AS INTEGER
DIM SHARED spikeHazardXmax(MAXHAZARDS) AS INTEGER
DIM SHARED spikeHazardWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfSpikeHazards AS INTEGER

DIM SHARED bridgeXmin(MAXHAZARDS) AS INTEGER
DIM SHARED bridgeXmax(MAXHAZARDS) AS INTEGER
DIM SHARED bridgeWidth(MAXHAZARDS) AS INTEGER
DIM SHARED numOfBridgeSprites AS INTEGER

'life would be easier if Qbasic had classes (or even STRUCTS!)
DIM SHARED badHealth(MAXBAD) AS INTEGER
DIM SHARED badX(MAXBAD) AS INTEGER
DIM SHARED badY(MAXBAD) AS INTEGER
DIM SHARED badRangeMin(MAXBAD) AS INTEGER
DIM SHARED badRangeMax(MAXBAD) AS INTEGER
DIM SHARED badInRange(MAXBAD) AS INTEGER
DIM SHARED badAlive(MAXBAD) AS INTEGER
DIM SHARED badGuyFiring(MAXBAD) AS INTEGER
DIM SHARED badAbsorbed(MAXBAD) AS INTEGER

'variable declarations
DIM SHARED numberOfEvents AS INTEGER
DIM SHARED areaNum AS INTEGER
DIM SHARED pX AS INTEGER
DIM SHARED pY AS INTEGER
DIM SHARED game AS INTEGER
DIM SHARED mainLoop AS INTEGER
DIM SHARED redraw AS INTEGER
DIM SHARED speed AS INTEGER
DIM SHARED inJump AS INTEGER
DIM SHARED goingUp AS INTEGER
DIM SHARED inputScreen AS INTEGER
DIM SHARED maxJumpHeight AS INTEGER
DIM SHARED pHealth AS INTEGER
DIM SHARED numOfBadGuys AS INTEGER
DIM SHARED eventsSet AS INTEGER
DIM SHARED gunFireOn AS INTEGER
DIM SHARED pDirection AS STRING
DIM SHARED absorbRequest AS INTEGER
DIM SHARED steppedInPit AS INTEGER
DIM SHARED condition AS INTEGER
DIM SHARED hasCrown AS INTEGER
DIM SHARED crownX AS INTEGER
DIM SHARED crownXmin AS INTEGER
DIM SHARED crownXmax AS INTEGER
DIM SHARED crownThere AS INTEGER
DIM SHARED drawSnowfall AS INTEGER
DIM SHARED difficultyLevel AS INTEGER 'health boost at input screen.
DIM SHARED difficultyDamage AS INTEGER 'factor for bad guy damage
DIM SHARED difficultyDamageJump AS INTEGER 'another factor for bg damage
DIM SHARED invincible AS INTEGER

speed = 1  'default debug.

mainLoop = TRUE

CALL initGfx            'game graphics initialization sub.
CALL preTitle           'nukem enterprises logo

DO WHILE mainLoop = TRUE

  playGame% = menu%            'main menu

  IF playGame% = FALSE THEN    'if quit selected
    CALL postGame              'display post game info
    mainLoop = FALSE           'set main program loop to stop
    game = FALSE               'set actual game loop to stop

  ELSEIF playGame% = TRUE THEN 'if play game was selected
    game = TRUE                'set game loop to run
    CALL preGame               'display game story
    SCREEN 13
    CALL init                  'initialize in game variables.

  END IF                       'end of menu function return if-block

  'the actual game
  DO WHILE game = TRUE         'the in-game will loop to here
   
    IF eventsSet = FALSE THEN  'reset to false in areaExit
      CALL setEventData(areaNum)    'sets eventsSet to true
    END IF
   
    IF redraw = TRUE THEN      'if something called for a redraw...
      CALL drawArea(areaNum)   'DO IT!
    END IF
   
'    IF drawSnowfall = TRUE THEN
'      CALL drawSnow(0)
'    END IF

    IF inputScreen = TRUE THEN
      direction% = motd(areaNum)
    END IF

    in$ = INKEY$               'scan for user input
   
    CALL checkEvents(areaNum)
    CALL debugInfo             'display debug information

    'movement to the left the or is for "decision screen animation".
    IF in$ = CHR$(0) + CHR$(75) OR (inputScreen = EXITING AND direction% = LEFT) THEN
      CALL move("l")
      pDirection = "l"
    END IF
   
    'movement to the right
    IF in$ = CHR$(0) + CHR$(77) OR (inputScreen = EXITING AND direction% = RIGHT) THEN
      CALL move("r")
      pDirection = "r"
    END IF
   
    'jump movement (set it so that you're jumping)
    IF in$ = " " THEN
      CALL move("u")
    END IF
   
    'fire pistol (F key)
    IF in$ = "F" OR in$ = "f" THEN
      CALL attack
    END IF
   
    'absorb enemy health
    IF in$ = "A" OR in$ = "a" THEN
      absorbRequest = TRUE

    'F1 help/tip press
    ELSEIF in$ = CHR$(0) + CHR$(59) THEN
      CALL tips(areaNum)

    'open game console. (to debug stuff)
    ELSEIF in$ = "~" THEN
      CALL console
 
    'quit handling
    ELSEIF in$ = "q" OR in$ = CHR$(27) THEN
      game = sureQuit% 'returns false or true
      
    END IF

    IF pX > 300 THEN     'if it's time to move to next screen
      CALL areaExit("r", areaNum)

    ELSEIF pX < 15 THEN 'if it's time to move to previous screen
      CALL areaExit("l", areaNum)

    ELSEIF steppedInPit = TRUE THEN
      steppedInPit = FALSE
      CALL areaExit("b", areaNum)
    END IF

    'Jump movement.
    IF inJump = TRUE AND goingUp = TRUE THEN
     
      IF condition = 0 THEN
        PUT (pX, pY), MRFACENOFIRE
        IF hasCrown = TRUE THEN
          PUT (pX, pY - 2), CROWN
        END IF
       
        pY = pY - 1
        PUT (pX, pY), MRFACENOFIRE, XOR
       
        IF hasCrown = TRUE THEN
          PUT (pX, pY - 2), CROWN, XOR
        END IF
       
        IF pY <= maxJumpHeight THEN
          goingUp = FALSE
        END IF

      ELSEIF condition = 1 THEN        'uh oh!
        PUT (pX, pY + 2), BIGMRFACELEGS
        PUT (pX - 10, pY - 43), BIGMRFACE

        pY = pY - 1

        PUT (pX, pY + 2), BIGMRFACELEGS, XOR
        PUT (pX - 10, pY - 43), BIGMRFACE, XOR
        IF pY <= maxJumpHeight THEN
          goingUp = FALSE
        END IF
     
      END IF

    ELSEIF inJump = TRUE AND goingUp = FALSE THEN
      IF condition = 0 THEN
        PUT (pX, pY), MRFACENOFIRE
        IF hasCrown = TRUE THEN
          PUT (pX, pY - 2), CROWN
        END IF
        pY = pY + 1
        PUT (pX, pY), MRFACENOFIRE, XOR
        IF hasCrown = TRUE THEN
          PUT (pX, pY - 2), CROWN, XOR
        END IF

        IF pY >= groundY THEN
          pY = groundY
          inJump = FALSE
        END IF

      ELSEIF condition = 1 THEN        'uh oh!
        PUT (pX, pY + 2), BIGMRFACELEGS
        PUT (pX - 10, pY - 43), BIGMRFACE

        pY = pY + 1

        PUT (pX, pY + 2), BIGMRFACELEGS, XOR
        PUT (pX - 10, pY - 43), BIGMRFACE, XOR
        IF pY >= groundY THEN
          pY = groundY
          inJump = FALSE
        END IF

      END IF
    END IF
     
    
  

    CALL timingControl(speed)       'regulates game time.

  LOOP 'end of game loop

LOOP   'end of program loop

END


'Sprite data follows below:
'--------------------------

MRFACENOFIRE:
'Mr. Face not firing Data
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 00, 06, 00, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 00, 06, 00, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 08, 08, 08, 00, 00, 00, 00, 00
DATA 06, 00, 00, 00, 06, 08, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00

MRFACEFIRE:
'mr face firing data
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 00, 06, 00, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 00, 06, 00, 06, 00, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 08, 08, 08, 14, 14, 14, 14, 00
DATA 06, 00, 00, 00, 06, 08, 00, 00, 00, 00, 00, 00, 00
DATA 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00

GROUND:
'ground texture data
DATA 02
DATA 02
DATA 02
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06

DIRTGROUND:
'dirt ground texture
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06

SEMISNOWGROUND:
'not fully snow covered yet.
DATA 15
DATA 15
DATA 15
DATA 06
DATA 06
DATA 06
DATA 06
DATA 06

SNOWGROUND:
'snowy ground texture
DATA 15
DATA 15
DATA 15
DATA 15
DATA 15
DATA 15
DATA 15
DATA 15

WATER:
'water texture data
DATA 00
DATA 09
DATA 09
DATA 01
DATA 01
DATA 01

LAVA:
'lava texture data
DATA 00
DATA 04
DATA 04
DATA 14
DATA 04
DATA 04
DATA 04
DATA 04

PIT:
'bottomless pit blankspace
DATA 00
DATA 00
DATA 00
DATA 00
DATA 00
DATA 00
DATA 00
DATA 00

SPIKE:
'spike pit texture data
DATA 00, 00, 00, 00, 00
DATA 00, 00, 07, 00, 00
DATA 00, 07, 07, 07, 00
DATA 07, 07, 07, 07, 07
DATA 07, 07, 07, 07, 07
DATA 07, 07, 07, 07, 07

BRIDGE:
'bridge sprite data
DATA 00
DATA 06
DATA 06
DATA 06
DATA 00
DATA 00
DATA 00
DATA 00


BADGUYFIRE:
'Bad guy firing data
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 04, 07, 04, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 04, 07, 04, 07
DATA 14, 14, 14, 14, 14, 08, 08, 08, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 08, 07, 04, 04, 04, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07

BADGUYNOFIRE:
'bad guy not firing data
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 04, 07, 04, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 04, 07, 04, 07
DATA 00, 00, 00, 00, 00, 08, 08, 08, 07, 07, 07, 07, 07
DATA 00, 00, 00, 00, 00, 00, 00, 08, 07, 04, 04, 04, 07
DATA 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07

BADMASKCLEAN:
'bad guy dead mask w/o blood (used for falling off cliffs)
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00

BADMASK:
'bad guy dead mask
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04
DATA 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04, 04

BADABSORB:
'bad guys mask after absorbed
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07
DATA 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07, 07



SIGNL:
'left sign sprite
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06, 15, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 15, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 15, 15, 15, 15, 15, 15, 15, 15, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 15, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 15, 15, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00

SIGNR:
'right sign sprite
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 15, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06
DATA 06, 06, 15, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 15, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 15, 15, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 15, 15, 15, 15, 15, 06, 06
DATA 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 15, 15, 06, 06, 06
DATA 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 15, 06, 06, 06, 06
DATA 06, 06, 06, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 15, 06, 06, 06, 06, 06
DATA 06, 06, 15, 15, 15, 15, 15, 15, 06, 06, 06, 06, 06, 06, 06, 06, 06, 15, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00


HOTDOGSTAND:
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 14, 06, 14, 06, 06, 06, 06, 06, 06, 14, 06, 06, 06, 14, 06, 06, 06, 06, 06, 06, 14, 06, 06, 06, 06, 06, 06
DATA 06, 14, 06, 14, 06, 06, 06, 06, 06, 06, 14, 06, 06, 06, 14, 06, 06, 06, 06, 06, 14, 06, 14, 06, 06, 06, 06, 06
DATA 06, 14, 06, 14, 06, 14, 14, 14, 06, 14, 14, 14, 06, 06, 14, 06, 06, 06, 06, 06, 14, 06, 14, 06, 14, 14, 14, 06
DATA 06, 14, 06, 14, 06, 14, 06, 14, 06, 06, 14, 06, 06, 06, 14, 06, 06, 06, 06, 06, 14, 06, 14, 06, 14, 06, 06, 06
DATA 06, 14, 14, 14, 06, 14, 06, 14, 06, 06, 14, 06, 06, 06, 14, 06, 06, 06, 06, 06, 14, 06, 14, 06, 14, 14, 14, 06
DATA 06, 14, 06, 14, 06, 14, 06, 14, 06, 06, 14, 06, 14, 14, 14, 06, 14, 14, 14, 06, 06, 14, 14, 06, 06, 06, 14, 06
DATA 06, 14, 06, 14, 06, 14, 06, 14, 06, 06, 14, 06, 14, 06, 14, 06, 14, 06, 14, 06, 06, 06, 14, 06, 14, 14, 14, 06
DATA 06, 14, 06, 14, 06, 14, 14, 14, 06, 06, 14, 06, 14, 14, 14, 06, 14, 14, 14, 06, 14, 06, 14, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 14, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07, 07, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07, 07, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 01, 01, 07, 07, 01, 01, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 01, 01, 07, 07, 01, 01, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 01, 01, 07, 07, 01, 01, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 01, 01, 07, 07, 01, 01, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07, 07, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 15, 15, 15, 15, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07, 07, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 07, 07, 07, 07, 07, 07, 07, 07, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06

BIGMRFACE:
'big mr face head
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06
DATA 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06, 06

BIGMRFACELEGS:
'what the play actually controls
DATA 00, 06, 06, 00, 00
DATA 00, 06, 06, 00, 00
DATA 06, 00, 00, 06, 00
DATA 06, 00, 00, 00, 06
DATA 06, 00, 00, 00, 06
DATA 06, 00, 00, 00, 06
DATA 06, 00, 00, 00, 06

CROWN:
'what the games all about!
DATA 14, 00, 14, 00, 14
DATA 14, 14, 14, 14, 14

CROWNMASK:
DATA 00, 00, 00, 00, 00
DATA 00, 00, 00, 00, 00

SUB aboutNE
CLS

FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

COLOR 10
LOCATE 1, 20
PRINT "About Nukem Enterprises"
LOCATE 2, 19
PRINT ""

COLOR 7
LOCATE 3
PRINT "           Nukem Enterprises (NE for short) is a company alias that I"
PRINT "create programs under. I program in both Basic and C++. I started this"
PRINT "programming alias way back in 1999. Back then it was called Eriksen Inc."
PRINT "This soon changed to Sublime Inc. for a short period of time before "
PRINT "finally ending at it's current name."
PRINT "          As of the make of this game I think I can say I have an ok"
PRINT "grasp on programming concepts and such. (Even though this source is "
PRINT "a little jumbled, that's b/c I didn't plan anything out, I just wrote)"
PRINT "I'm mostly programming in C++ now for the Linux platform. Qbasic has "
PRINT "sort of taken the ~side road~ for me. "
PRINT "         I've created many programs over the years and they can all be"
PRINT "found at my website. If the site is down or no longer exists you can"
PRINT "always ICQ me or e-mail me and I'll direct you to the location of the"
PRINT "current address of the website. (I think it's changed a good 4 times"
PRINT "in the past 7 years)."
PRINT "                                                    -Erik Eriksen"
PRINT " Web site: http://eriks.servehttp.com"
PRINT "           http://www.geocities.com/nukemn0w/"
PRINT "      ICQ: 17951293"
PRINT "   E-mail: shamrice@optonline.net"
COLOR 4
PRINT "                                      Press any key to go back"



DO: LOOP WHILE INKEY$ = ""

END SUB

SUB areaExit (direction$, areaNum%)
'I know this isn't the nicest way of doing this but it works
'I should have thought of a way to increase #'s to display the
'next area but There's a lot of forks and alternate paths.
'(I tried that w/ hellbent and it gave me a headache lol)


SELECT CASE areaNum 'change depending on what area they're in

  CASE 0:  'first area
    IF direction$ = "l" THEN        'exit to the left of the screen
      areaNum = 300                 'send them to the tutorials!
      pX = 16

    ELSEIF direction$ = "r" THEN        'exit to the right of the screen
      areaNum = 1                       'send them to gamplay area 1
      pX = 16
    END IF

  CASE 300:    'first tutorial area.
    IF direction$ = "l" THEN        'exit to the left of the screen
      areaNum = 0
      pX = 140

    ELSEIF direction$ = "r" THEN        'exit to the right of the screen
      areaNum = 301                       'send them to second tutorial
      pX = 16
    END IF

  CASE 301:     'second tutorial area.
    IF direction$ = "l" THEN
      areaNum = 300
      pX = 290

    ELSEIF direction$ = "r" THEN
      areaNum = 302
      pX = 16
    END IF

  CASE 302:     'final tutorial area.
    IF direction$ = "l" THEN
      areaNum = 301
      pX = 290

    ELSEIF direction$ = "r" THEN
      CALL tutorialComplete
      pHealth = 100
      areaNum = 1
      pX = 16
    END IF
 
  CASE 1: 'first gameplay area
    IF direction$ = "l" THEN        'exit to the left of the screen
      pX = 140
      areaNum = 0

    ELSEIF direction$ = "r" THEN        'exit to the right of the screen
      areaNum = 2                       'send them to gamplay area 2
      pX = 16
    END IF

  CASE 2:  'second gameplay area
    IF direction$ = "l" THEN
      areaNum = 1
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 3
      pX = 140
      pHealth = pHealth + difficultyLevel
    END IF

  CASE 3:   'second input screen. (cliff decision)
    IF direction$ = "l" THEN
      areaNum = 4              'never ending dirt map
      pX = 16
    END IF

    IF direction$ = "r" THEN
      CALL cliffWoes
      areaNum = 5              'yodle at edge of cliff
      pX = 16
      pY = 75        'to make them fall down
      inJump = TRUE
    END IF

  CASE 4:     'never ending dirt map
    IF direction$ = "l" THEN
     
      LOCATE 10: COLOR 15
      PRINT "Looks like there's no other way around"
      COLOR 7
      PRINT "Press space to continue..."
      DO: LOOP WHILE INKEY$ <> " "

      areaNum = 3              'back to second input screen
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 4              'forever going...
      pX = 16
    END IF


  CASE 5                     'in the river at the bottom...
    IF direction$ = "l" THEN
      areaNum = 5              'you can't go back!
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 6              'ah! dry land...
      pX = 16
    END IF

  CASE 6                      'at the bottom of cliff level
    IF direction$ = "l" THEN
      areaNum = 5              'you can't go back!
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 7              '3rd input screen
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

  CASE 7                      '3rd input screen. (forge river or scale wall)
    IF direction$ = "l" THEN
      areaNum = 8             'top of cliff
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 9              'in the water again
      pX = 16
    END IF

  CASE 8                       'in the river
    IF direction$ = "l" THEN
     
      LOCATE 10: COLOR 15
      PRINT "You should have known that was a bad"
      PRINT "idea!"
      COLOR 7
      PRINT "Press space to continue..."
      DO: LOOP WHILE INKEY$ <> " "
     
      areaNum = 7
      pX = 140
    END IF

    IF direction$ = "r" THEN   'yeah that's right. I'm a bastard.
      areaNum = 8
      pX = 16
    END IF

  CASE 9
    IF direction$ = "l" THEN
      areaNum = 7             'send them back to the input screen
      pX = 140
    END IF

    IF direction$ = "b" THEN   'if they didn't make the jump...
      areaNum = 5              'back into the river...
      pX = 16
      pY = 45
      inJump = TRUE
    END IF

    IF direction$ = "r" THEN
      areaNum = 10            'other side of cliff. (i hope they're jumping!)
      pX = 16
      pY = 150
      inJump = TRUE
    END IF

  CASE 10
    IF direction$ = "l" THEN
      areaNum = 9             'send them back to otherside of canyon
      pX = 140
    END IF

    IF direction$ = "b" THEN   'if they didn't make the jump...
      areaNum = 5              'back into the river...
      pX = 16
      pY = 45
      inJump = TRUE
    END IF

    IF direction$ = "r" THEN
      areaNum = 11            'next input screen
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

  CASE 11                     'post canyon input screen.
    IF direction$ = "l" THEN
      areaNum = 12             'hot dog stand
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 14            'woods path
      pX = 16
    END IF

  CASE 12                     'hot dog stand
    IF direction$ = "l" THEN
      areaNum = 11             'back to input screen
      pX = 140
    END IF

    IF direction$ = "r" THEN
      LOCATE 10: COLOR 15
      PRINT "What? You don't want a hotdog???"
      COLOR 7
      PRINT "Press space to continue..."
      DO: LOOP WHILE INKEY$ <> " "

      areaNum = 12            'repeat, they have to go back or eat hotdog
      pX = 290
    END IF

  CASE 13                    'large mr face path
    IF direction$ = "l" THEN
      areaNum = 12             'back to hotdog stand
      pX = 285
    END IF

    IF direction$ = "r" THEN
      areaNum = 14            'woods path
      pX = 16
    END IF

  CASE 14                    'woods path 1
    IF direction$ = "l" THEN
      areaNum = 11           'send them back to input screen
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 15           'send them to woods path 2
      pX = 16
    END IF

  CASE 15                    'woods path 2
    IF direction$ = "l" THEN
      areaNum = 14           'back to woods 1
      pX = 290
    END IF

    IF direction$ = "r" THEN
      CALL hellbentOi
      pHealth = pHealth + difficultyLevel
      areaNum = 16
      pX = 140
    END IF

  CASE 16                    'caves or swamps input screen
    IF direction$ = "l" THEN
      areaNum = 17           'caves level 1
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 20           'swamps level 1
      pX = 16
    END IF

  CASE 17                    'caves level 1
    IF direction$ = "l" THEN
      areaNum = 16           'input screen (caves or swamp)
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 18           'caves level 2
      pX = 16
    END IF

  CASE 18                    'caves level 2
    IF direction$ = "l" THEN
      areaNum = 17           'caves level 1
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 19           'caves end
      pX = 16
    END IF

  CASE 19                    'caves end
    IF direction$ = "l" THEN
      areaNum = 18           'caves level 2
      pX = 290
    END IF

    IF direction$ = "r" THEN
      LOCATE 10: COLOR 15
      PRINT "Ahem, Sire. There's A WALL THERE!"
      COLOR 7
      PRINT "Press space to continue..."
      DO: LOOP WHILE INKEY$ <> " "
      areaNum = 19           'can't go that way!
      pX = 290
    END IF

  CASE 20                    'swamps level 1
    IF direction$ = "l" THEN
      areaNum = 16           'input screen (caves or swamps)
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 21           'swamps level 2
      pX = 16
    END IF

  CASE 21                    'swamps level 2
    IF direction$ = "l" THEN
      areaNum = 20           'Swamps level 1
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 22           'swamps exit
      pX = 16
    END IF

  CASE 22                     'swamps exit
    IF direction$ = "l" THEN
      areaNum = 21           'swamps level 2
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 23           'next input screen
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

  CASE 23                    'in river input screen
    IF direction$ = "l" THEN
      areaNum = 25           'fight way upstream
      pX = 30
    END IF

    IF direction$ = "r" THEN
      areaNum = 24           'row, row, row your boat...
      pX = 16
    END IF

  CASE 24                    'going w/ the flow
    IF direction$ = "l" THEN
      areaNum = 23           'so you didn't want to die?
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 24           'THEY WILL DIE!!!
      pX = 280               'right on the falls MUHAHAHA
    END IF

  CASE 25                     'fighting way upstream
    IF direction$ = "l" THEN
      areaNum = 23           'back to the path selection screen
      pX = 140
    END IF

    IF direction$ = "r" THEN
      CALL hurrayForEarth
      areaNum = 26           'sweet sweet LAND!!!
      pX = 30
    END IF

  CASE 26                    'land, but snow!
    IF direction$ = "l" THEN
      areaNum = 25           'why!?!
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 27           'getting worse...
      pX = 16
    END IF
   
  CASE 27                    'semi-snow in action
    IF direction$ = "l" THEN
      areaNum = 26           'back to snow level1
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 28           'even worse!
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

  CASE 28                    'worse of all
    IF direction$ = "l" THEN
      CALL niceHouse(1)
      areaNum = 30           'post storm
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 29           'rough it in the snow.
      pX = 16
    END IF

  CASE 29                    'alone in the snow
    IF direction$ = "l" THEN
      areaNum = 28           'storm input screen
      pX = 140
    END IF

    IF direction$ = "r" THEN
      areaNum = 29           'continue to rough it in the snow.
      pX = 16
    END IF

  CASE 30                    'back to the spike tundra
    IF direction$ = "l" THEN
      CALL niceHouse(2)
      areaNum = 30
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 31
      pX = 16
    END IF

  CASE 31                     '1/4 of bridge
    IF direction$ = "l" THEN
      areaNum = 30
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 32
      pX = 16
    END IF

  CASE 32                     '2/4 of bridge
    IF direction$ = "l" THEN
      areaNum = 31
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 33
      pX = 16
    END IF

  CASE 33                     '3/4 of bridge
    IF direction$ = "l" THEN
      areaNum = 32
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 34
      pX = 16
    END IF
  
  CASE 34                     '4/4 of bridge
    IF direction$ = "l" THEN
      areaNum = 33
      pX = 290
    END IF

    IF direction$ = "r" THEN
      areaNum = 35
      pHealth = pHealth + difficultyLevel
      pX = 140
    END IF

  CASE 35                    'after bridge input screen
    IF direction$ = "l" THEN
      areaNum = 36           'to the mountains
      pX = 16
    END IF

    IF direction$ = "r" THEN
      areaNum = 40           'to the valley
      pX = 16
    END IF

END SELECT

eventsSet = FALSE         'new area, new events.
redraw = TRUE

END SUB

SUB attack
'this sub handles the firing of mr. face's pistol

  
  IF condition = 0 THEN
    'draw gun on right side
    IF gunFireOn = TRUE THEN
      PUT (pX, pY), MRFACENOFIRE, PSET
      gunFireOn = FALSE

    ELSEIF gunFireOn = FALSE THEN
      PUT (pX, pY), MRFACEFIRE, PSET
      gunFireOn = TRUE
    END IF
  END IF

     
        

  'if they're in range... hurt them!
  FOR i% = 0 TO numOfBadGuys
    IF badInRange(i%) = TRUE AND badAlive(i%) = TRUE THEN
      IF hasCrown = FALSE THEN
        badHealth(i%) = badHealth(i%) - 20
      ELSEIF hasCrown = TRUE THEN
        badHealth(i%) = badHealth(i%) - 50
      END IF
     
      IF badHealth(i%) <= 0 THEN    'if you kill them...
        badAlive(i%) = FALSE        'they're dead.
        PUT (badX(i%), badY(i%)), BADMASK, PSET
      END IF

    END IF
  NEXT i%


END SUB

SUB badMove (direction$, badNum%)

'moves bad guy

SELECT CASE direction$

  CASE "l"                                              'move badguy left
    IF badGuyFiring(badNum%) = TRUE THEN
      PUT (badX(badNum%), badY(badNum%)), BADGUYFIRE        'draw him
      badX(badNum%) = badX(badNum%) - 1                    'move him
      PUT (badX(badNum%), badY(badNum%)), BADGUYFIRE, PSET
      badGuyFiring(badNum%) = FALSE

    ELSEIF badGuyFiring(badNum%) = FALSE THEN
      PUT (badX(badNum%), badY(badNum%)), BADGUYNOFIRE         'draw him
      badX(badNum%) = badX(badNum%) - 1                    'move him
      PUT (badX(badNum%), badY(badNum%)), BADGUYNOFIRE, PSET
      badGuyFiring(badNum%) = TRUE
    END IF
     
   
    badRangeMin(badNum%) = badRangeMin(badNum%) - 1   'update range info
    badRangeMax(badNum%) = badRangeMax(badNum%) - 1
     

  CASE "r"                                        'move badguy right
    IF badGuyFiring(badNum%) = TRUE THEN
      PUT (badX(badNum%), badY(badNum%)), BADGUYFIRE, AND        'draw him
      badX(badNum%) = badX(badNum%) + 1                    'move him
      PUT (badX(badNum%), badY(badNum%)), BADGUYFIRE, PSET
      badGuyFiring(badNum%) = FALSE

    ELSEIF badGuyFiring(badNum%) = FALSE THEN
      PUT (badX(badNum%), badY(badNum%)), BADGUYNOFIRE, AND        'draw him
      badX(badNum%) = badX(badNum%) + 1                        'move him
      PUT (badX(badNum%), badY(badNum%)), BADGUYNOFIRE, PSET
      badGuyFiring(badNum%) = TRUE
    END IF

    badRangeMin(badNum%) = badRangeMin(badNum%) + 1  'update range info
    badRangeMax(badNum%) = badRangeMax(badNum%) + 1

END SELECT

END SUB

SUB checkEvents (areaNum%)

  IF (pX >= crownXmin) AND (pX <= crownXmax) AND (crownThere = TRUE) AND (hasCrown = FALSE) THEN
    hasCrown = TRUE
    CALL itsGoodToBeTheKing
    pHealth = pHealth + 300
    eventsSet = FALSE
    redraw = TRUE
  END IF


  FOR i% = 1 TO numOfEvents           'view event data for level.
    IF (pX >= eventXmin(i%)) AND (pX <= eventXmax(i%)) THEN 'if you're on an event...

      IF (areaNum% = 12) THEN           'hot dog stand
        CALL hotDogDialog
       
        IF game = TRUE THEN
          CALL wtfJustHappened
          areaNum = 13
          pX = 16
          eventsSet = FALSE         'new area, new events.
          redraw = TRUE
        END IF
        
      ELSE
        LOCATE 10, 10                     'locate
        COLOR 15
        PRINT eventText(i%)               'print the event
        DO: LOOP WHILE INKEY$ = ""        'wait for keypress
      END IF

      eventXmax(i%) = -5
      eventXmin(i%) = eventXmax(i%)     'so they don't keep hitting it
      redraw = TRUE                     'so it erases the message

    END IF
  NEXT i%
 
  FOR i% = 1 TO numOfWaterHazards
    IF (pX > waterHazardXmin(i%) AND pX < waterHazardXmax(i%)) AND inJump = FALSE THEN
      pHealth = pHealth - 1
    END IF
  NEXT i%
 
 
  FOR i% = 1 TO numOfLavaHazards
    IF (pX > lavaHazardXmin(i%) AND pX < lavaHazardXmax(i%)) AND inJump = FALSE THEN
      pHealth = pHealth - 2
    END IF
  NEXT i%


  FOR i% = 1 TO numOfPitHazards
    IF (pX > pitHazardXmin(i%) AND pX < pitHazardXmax(i%)) AND inJump = FALSE THEN
      gameOver (3)
    END IF
  NEXT i%

  FOR i% = 1 TO numOfSpecialPitHazards
    IF (pX > specialPitHazardXmin(i%) AND pX < specialPitHazardXmax(i%)) AND inJump = FALSE THEN
      steppedInPit = TRUE
     END IF
  NEXT i%

  FOR i% = 1 TO numOfSpikeHazards
    IF (pX > spikeHazardXmin(i%) AND pX < spikeHazardXmax(i%)) AND inJump = FALSE THEN
      IF condition = 1 THEN       'if they're large & in charge
        pHealth = pHealth - 50    'they're not.
      ELSE
        pHealth = pHealth - 4
      END IF
    END IF
  NEXT i%

  
  'check for badguy damage and if they walked off cliffs and such
  FOR i% = 1 TO numOfBadGuys
    IF (pX > badRangeMin(i%) AND pX < badRangeMax(i%)) AND badAlive(i%) = TRUE THEN  'in range!
     
      IF inJump = FALSE THEN
        pHealth = pHealth - difficultyDamage               'hurt player
      
      ELSEIF inJump = TRUE THEN
        pHealth = pHealth - difficultyDamageJump

      END IF
     
      IF (pX < badX(i%)) THEN   'run at them to the LEFT!
        CALL badMove("l", i%)
     
      ELSEIF (pX > badX(i%)) THEN  'run at them to the RIGHT!
        CALL badMove("r", i%)
      END IF
     
      badInRange(i%) = TRUE
      absorbRequest = FALSE
   
    ELSEIF (pX > badRangeMin(i%) AND pX < badRangeMax(i%)) AND badAlive(i%) = FALSE AND badAbsorbed(i%) = FALSE AND absorbRequest = TRUE THEN
      pHealth = pHealth + 10
      absorbRequest = FALSE
      badAbsorbed(i%) = TRUE
      PUT (badX(i%), badY(i%)), BADABSORB, XOR

    ELSE
      badInRange(i%) = FALSE

    END IF
  NEXT i%

 
  'test to see if bad guys are stepping on hazards or falling off cliffs.
  FOR h% = 1 TO numOfWaterHazards
    FOR i% = 1 TO numOfBadGuys STEP 1
      IF (badX(i%) > waterHazardXmin(h%) AND badX(i%) < waterHazardXmax(h%)) AND badAlive(i%) = TRUE THEN
        badHealth(i%) = badHealth(i%) - 1
        IF badHealth(i%) <= 0 THEN
          badAlive(i%) = FALSE
          PUT (badX(i%), badY(i%)), BADMASK, PSET
        END IF
      END IF
    NEXT i%
  NEXT h%
 
  FOR h% = 1 TO numOfLavaHazards
    FOR i% = 1 TO numOfBadGuys STEP 1
      IF (badX(i%) > lavaHazardXmin(h%) AND badX(i%) < lavaHazardXmax(h%)) AND badAlive(i%) = TRUE THEN
        badHealth(i%) = badHealth(i%) - 2
        IF badHealth(i%) <= 0 THEN
          badAlive(i%) = FALSE
          PUT (badX(i%), badY(i%)), BADMASK, PSET
        END IF
      END IF
    NEXT i%
  NEXT h%
      
 
  FOR h% = 1 TO numOfPitHazards
    FOR i% = 1 TO numOfBadGuys STEP 1
      IF (badX(i%) > pitHazardXmin(h%) AND badX(i%) < pitHazardXmax(h%)) AND badAlive(i%) = TRUE THEN
        badAlive(i%) = FALSE
        PUT (badX(i%), badY(i%)), BADMASKCLEAN, PSET
      END IF
    NEXT i%
  NEXT h%


  FOR h% = 1 TO numOfSpikeHazards
    FOR i% = 1 TO numOfBadGuys STEP 1
      IF (badX(i%) > spikeHazardXmin(h%) AND badX(i%) < spikeHazardXmax(h%)) AND badAlive(i%) = TRUE THEN
        badHealth(i%) = badHealth(i%) - 4
        IF badHealth(i%) <= 0 THEN
          badAlive(i%) = FALSE
          PUT (badX(i%), badY(i%)), BADMASK, PSET
        END IF
      END IF
    NEXT i%
  NEXT h%



  IF pHealth <= 0 AND invincible% = FALSE THEN   'if they die.
    CALL gameOver(0)                              'game over!
  END IF


  'setting max health.
  IF pHealth > 100 AND hasCrown = FALSE THEN
    pHealth = 100

  ELSEIF pHealth > 150 AND hasCrown = TRUE THEN
    pHealth = 150

  END IF


END SUB

SUB cliffWoes

SCREEN 12
CLS

COLOR 10
PRINT "                         Yodle-yay-eeeEee-OOoo!!!"
PRINT "                       "
COLOR 7
PRINT "  You decide to Yodle at the edge of the cliff. That was a bright idea if"
PRINT "I ever heard one. As you stand there, screaming off the edge, the rocks"
PRINT "begin to give way and you fall... and fall... and fall... all the way down"
PRINT "to the bottom of the cliff. "
PRINT
PRINT "  There's good news though! You about to land in a river at the bottom so "
PRINT "you're not dead! The bad news you ask? You don't know how to swim. Have fun"
PRINT "getting out of this next area before you drown to death! :P"
COLOR 4
PRINT "                   ...Press space bar to start paddling out..."
DO: LOOP WHILE INKEY$ <> " "

SCREEN 13
CLS


END SUB

SUB console

'debug console sub
'-------------------
'debug console allows you to manipulate many aspects of the game
'by changed the value of the the variables during play time.
   
    LOCATE 3, 1: COLOR 7
    INPUT " > ", debug$

    SELECT CASE debug$
      CASE "c"                      'change game attribute mode
        LOCATE 3, 1
        INPUT "?> ", change$        'what val to change
        IF change$ = "x" THEN       'change player X value
          LOCATE 3, 1
          INPUT "pX to> ", pX

        ELSEIF change$ = "y" THEN   'change player Y value
          LOCATE 3, 1
          INPUT "pY to> ", pY

        ELSEIF change$ = "a" THEN   'change area number
          LOCATE 3, 1
          INPUT "areaNum to> ", areaNum
        END IF

      CASE "r"          'force redraw screen
        redraw = TRUE

      CASE "q"          'forced quit game
        CLS
        PRINT "Forced quit called!"
        END

      CASE "llama mode"
        COLOR 10
        LOCATE 5, 10
        PRINT "LLAMA MODE ON!"
        invincible = TRUE
        SLEEP
        redraw = TRUE

    END SELECT

    'clean up.
    LOCATE 3, 1: COLOR 7
    PRINT "                                      "
   

END SUB

SUB debugInfo

  'debug: display x & y coords
  'LOCATE 2, 1: COLOR 15
  'PRINT "X: "; pX
  'LOCATE 3, 1: COLOR 15
  'PRINT "Y: "; pY


  'print health.
  LOCATE 1, 1: COLOR 15
  PRINT "Health: "
 
  IF pHealth >= 75 THEN
    COLOR 15

  ELSEIF pHealth < 75 AND pHealth >= 50 THEN
    COLOR 10

  ELSEIF pHealth < 50 AND pHealth >= 25 THEN
    COLOR 14

  ELSEIF pHealth < 25 THEN
    COLOR 4

  END IF

  LOCATE 1, 9
  PRINT pHealth


END SUB

SUB drawArea (areaNum)

CLS


'draw level.
direction% = 0

'make impossible mode look hellish!
IF difficultyLevel = 0 THEN
  PAINT (1, 1), 4
END IF


SELECT CASE areaNum
 
  CASE 0                            'tutorial or gampelay choice screen
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawSun% = TRUE
    drawSigns% = TRUE
    inputScreen = TRUE


  CASE 1                            'gameplay screen 1
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawWater% = TRUE
    drawSun% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE
    numberOfEvents = 1

  CASE 2                             'gameplay screen 2
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawBadGuy% = TRUE
    drawWater% = TRUE
    drawSun% = TRUE
    numberOfEvents = 0
    inputScreen = FALSE

  CASE 3                          'second inputscreen
    drawSun% = TRUE
    drawSigns% = TRUE
    inputScreen = TRUE

    'custom ground draw (so you can see cliff)
    FOR i% = 0 TO 250
      PUT (i%, 187), DIRTGROUND
    NEXT i%


  CASE 4                          'never ending dirt screen
    drawDirtGround% = TRUE
    drawGround% = FALSE
    drawSun% = TRUE
    drawSigns% = FALSE
    inputScreen = FALSE

  CASE 5                          'bottom of the cliff river
    drawDirtGround% = TRUE
    drawSun% = TRUE
    drawWater% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 6                          'bottom of the cliff after water
    drawDirtGround% = TRUE
    drawSun% = TRUE
    drawBadGuy% = TRUE
    drawSpikes% = TRUE
    inputScreen = FALSE

  CASE 7                          '3rd input screen. forge river or jump
    drawDirtGround% = TRUE
    drawSun% = TRUE
    drawSigns% = TRUE
    inputScreen = TRUE

  CASE 8                           '"attempt" to forge river *snicker*
    drawSun% = TRUE
    drawWater% = TRUE
    inputScreen = FALSE

  CASE 9                           'jump the gorge. =-o!
    drawSun% = TRUE
    drawDirtGround% = TRUE
    drawSpecialPit% = TRUE
    PUT (230, 167), SIGNR
    PUT (50, 167), SIGNR
    inputScreen = FALSE

  CASE 10                          'other side of gorge
    drawSun% = TRUE
    drawBadGuy% = TRUE
    drawDirtGround% = TRUE
    drawSpecialPit% = TRUE
    inputScreen = FALSE

  CASE 11                          'input screen after canyon fun
    drawSun% = TRUE
    drawDirtGround% = TRUE
    drawSigns% = TRUE
    inputScreen = TRUE

  CASE 12                           'hot dog stand screen
    drawSun% = TRUE
    drawGround% = TRUE
    drawHotDogStand% = TRUE
    inputScreen = FALSE

  CASE 13                           'pop-n-fresh screen
    drawSun% = TRUE
    drawGround% = TRUE
    drawSpikes% = TRUE
    inputScreen = FALSE

  CASE 14                           'woods screen 1
    drawForest% = TRUE
    drawGround% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 15                           'woods screen 2
    drawForest% = TRUE
    drawGround% = TRUE
    drawBadGuy% = TRUE
    drawPit% = TRUE
    inputScreen = FALSE

  CASE 16                           'caves or swamps input screen
    drawForest% = TRUE
    drawGround% = TRUE
    drawSigns% = TRUE
    inputScreen = TRUE

  CASE 17                            'caves level 1
    drawCaves% = TRUE
    drawSpikes% = TRUE
    drawBadGuy% = TRUE
    drawLava% = TRUE
    inputScreen = FALSE

  CASE 18                            'caves level 2
    drawCaves% = TRUE
    drawBadGuy% = TRUE
    drawLava% = TRUE
    inputScreen = FALSE

  CASE 19                           'end of cave. (crown there)
    drawCaves% = TRUE
    drawBadGuy% = TRUE
    drawLava% = TRUE
    drawPit% = TRUE

    LINE (300, 0)-(310, 187), 8, BF    'cave wall

    IF (crownThere = TRUE) AND (hasCrown = FALSE) THEN
      PUT (crownX, 183), CROWN, PSET
    END IF

    inputScreen = FALSE

  CASE 20                           'swamps area 1
    drawDirtGround% = TRUE
    drawForest% = TRUE
    drawWater% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 21                           'swamps area 2
    drawDirtGround% = TRUE
    drawForest% = TRUE
    drawWater% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 22                            'swamps exit
    drawDirtGround% = TRUE
    drawWater% = TRUE
    drawBadGuy% = TRUE
    drawSun% = TRUE
    CALL drawHalfForest
    inputScreen = FALSE

  CASE 23                           'in river input screen
    drawWater% = TRUE
    drawSigns% = TRUE
    drawSun% = TRUE
    inputScreen = TRUE

  CASE 24                          'flow down river
    drawWater% = TRUE
    drawSun% = TRUE                'input screen isn't changed so it pulls
                                   'them towards the edge
  CASE 25                          'fight up river
    drawWater% = TRUE
    drawSun% = TRUE
    inputScreen = FALSE

  CASE 26                           'first snow level (no snow)
    drawGround% = TRUE
    drawWater% = TRUE
    drawBadGuy% = TRUE
    drawSpikes% = TRUE
    inputScreen = FALSE

  CASE 27                            'second snow level (some snow)
    CALL drawSnow(1)
    drawBadGuy% = TRUE
    drawSpikes% = TRUE
    inputScreen = FALSE

  CASE 28                            'snow storm input screen
    CALL drawSnow(0)
    CALL drawSnow(2)
    drawSigns% = TRUE
    inputScreen = TRUE
  
  CASE 29                             'rough it in the snow
    CALL drawSnow(2)
    inputScreen = FALSE

  CASE 30
    CALL drawSnow(1)
    drawSpikes% = TRUE
    drawSun% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE


  CASE 31
    CALL drawSnow(1)
    drawSpikes% = TRUE
    drawSun% = TRUE
    drawBridge% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 32
    CALL drawBridgeGround
    drawSun% = TRUE
    drawBadGuy% = TRUE
    drawPit% = TRUE
    inputScreen = FALSE

  CASE 33
    CALL drawBridgeGround
    drawSun% = TRUE
    drawBadGuy% = TRUE
    drawPit% = TRUE
    inputScreen = FALSE

  CASE 34
    CALL drawSnow(1)
    drawSpikes% = TRUE
    drawSun% = TRUE
    drawBridge% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

  CASE 35                            'post bridge input screen
    CALL drawSnow(1)
    drawSigns% = TRUE
    inputScreen = TRUE

  CASE 300               'tutorial 1
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawWater% = TRUE
    drawLava% = TRUE
    drawPit% = TRUE
    drawSpikes% = TRUE
    drawSun% = TRUE
    inputScreen = FALSE
   
    'display tutorial title
    LOCATE 7, 5
    COLOR 15
    PRINT "Tutorial 1: Hazards!"
    LOCATE 8, 5
    PRINT "(Press F1 for Help)"

  CASE 301               'tutorial 2
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawSun% = TRUE
    drawBadGuy% = TRUE
    inputScreen = FALSE

    'display tutorial title
    LOCATE 7, 5
    COLOR 15
    PRINT "Tutorial 2: Fighting Enemies"

  CASE 302               'tutorial 3
    drawGround% = TRUE
    drawDirtGround% = FALSE
    drawSun% = TRUE
    drawBadGuy% = TRUE
    drawLava% = TRUE
    drawPit% = TRUE
    inputScreen = FALSE

    'display tutorial title
    LOCATE 7, 5
    COLOR 15
    PRINT "Tutorial 3: Putting it together..."


  CASE ELSE
    inputScreen = FALSE    'so not to get those BSOD's

END SELECT

'draw what you set to draw...

IF drawForest% = TRUE THEN
  'this is a big one. drawing trees
  CALL drawTrees
END IF

IF drawCaves% = TRUE THEN
  CALL drawCaveScene
END IF


IF drawGround% = TRUE THEN
  'draw the ground
  FOR i% = 0 TO 310
    PUT (i%, 187), GROUND
  NEXT i%
END IF

IF drawDirtGround% = TRUE THEN
  'draw the dirt ground
  FOR i% = 0 TO 310
    PUT (i%, 187), DIRTGROUND
  NEXT i%
END IF


IF drawWater% = TRUE THEN
  'draw water
  FOR h% = 1 TO numOfWaterHazards
    FOR i% = 0 TO waterHazardWidth(h%) STEP 1
      PUT ((i% + waterHazardXmin(h%)), 187), WATER, PSET
    NEXT i%
  NEXT h%
END IF

IF drawLava% = TRUE THEN
  'draw lava
  FOR h% = 1 TO numOfLavaHazards
    FOR i% = 0 TO lavaHazardWidth(h%) STEP 1
      PUT ((i% + lavaHazardXmin(h%)), 187), LAVA, PSET
    NEXT i%
  NEXT h%
END IF

IF drawPit% = TRUE THEN
  'draw bottom less pt
  FOR h% = 1 TO numOfPitHazards
    FOR i% = 0 TO pitHazardWidth(h%) STEP 1
      PUT ((i% + pitHazardXmin(h%)), 187), PIT, PSET
    NEXT i%
  NEXT h%
END IF

IF drawSpecialPit% = TRUE THEN
  'draw canyon not killer pit
  FOR h% = 1 TO numOfSpecialPitHazards
    FOR i% = 0 TO specialPitHazardWidth(h%) STEP 1
      PUT ((i% + specialPitHazardXmin(h%)), 187), PIT, PSET
    NEXT i%
  NEXT h%
END IF

IF drawSpikes% = TRUE THEN
  'draw the spikes
  FOR h% = 1 TO numOfSpikeHazards
    FOR i% = 0 TO spikeHazardWidth(h%) STEP spikeWidth
      PUT ((i% + spikeHazardXmin(h%)), 187), SPIKE, PSET
    NEXT i%
  NEXT h%
END IF

IF drawBridge% = TRUE THEN
  'draw bridge sprite
  FOR h% = 1 TO numOfBridgeSprites
    FOR i% = 0 TO bridgeWidth(h%) STEP 1
      PUT ((i% + bridgeXmin(h%)), 187), BRIDGE, PSET
    NEXT i%
  NEXT h%
END IF


IF drawSun% = TRUE THEN
  'draw the sun
  CIRCLE (220, 30), 10, 14
  PAINT (220, 30), 14
END IF

IF drawBadGuy% = TRUE THEN
  'place badGuy
  FOR i% = 1 TO numOfBadGuys STEP 1
    PUT (badX(i%), badY(i%)), BADGUYNOFIRE
  NEXT i%
END IF

IF drawSigns% = TRUE THEN
  'place path signs
  PUT (50, 167), SIGNL
  PUT (230, 167), SIGNR
END IF


IF drawHotDogStand% = TRUE THEN
  'place the stand!
  PUT (200, 142), HOTDOGSTAND
END IF


IF condition = 0 THEN
  'place mr face
  PUT (pX, pY), MRFACENOFIRE
 
  IF hasCrown = TRUE THEN
    PUT (pX, pY - 2), CROWN
  END IF

ELSEIF condition = 1 THEN      'fat ass!
  'place big mr face
  PUT (pX, pY + 2), BIGMRFACELEGS
  PUT (pX - 10, pY - 43), BIGMRFACE
END IF


redraw = FALSE      'no need to redraw, it was just done

END SUB

SUB drawBridgeGround
 
  FOR i% = 0 TO 310
    PUT (i%, 187), BRIDGE
  NEXT i%

END SUB

SUB drawCaveScene
PSET (1, 1), 8
DRAW "r310 d30 g30 h30 g30 h30 g30 h30 g30 h30 g30 h30 g10 u40"
PAINT (2, 2), 8

LINE (0, 187)-(310, 195), 8, BF
END SUB

SUB drawHalfForest
'this is used for the swamp exit.


'trunks
LINE (30, 20)-(50, 186), 6, BF
LINE (90, 20)-(110, 186), 6, BF

'canopy
PSET (1, 1), 2
DRAW "r160 d30 g30 h30 g30 h30 g30 h10 u50"
PAINT (2, 2), 2

END SUB

SUB drawSnow (amount%)
                                          'yeah it works for snow too!

  SELECT CASE amount%
    CASE 0

      FOR starGenerator = 1 TO 1000
        XCoordinate = CINT(RND * 800)
        YCoordinate = CINT(RND * 500)
        PSET (XCoordinate, YCoordinate), 15
      NEXT starGenerator
     
      'theres a slow down bug in impossible mode w/ the snowfall
      IF difficultyLevel <> 0 THEN
        redraw = TRUE
      END IF

    CASE 1       'semi snow
      FOR i% = 0 TO 310
        PUT (i%, 187), SEMISNOWGROUND
      NEXT i%



    CASE 2       'mega snow!!!
      FOR i% = 0 TO 310
        PUT (i%, 187), SNOWGROUND
      NEXT i%

  END SELECT

END SUB

SUB drawTrees
'draw trees in a level

x1% = INT(50 * RND(1) + 1)
x2% = x1% + 20

x3% = INT(150 * RND(1) + 51)
x4% = x3% + 20

x5% = INT(200 * RND(1) + 151)
x6% = x5% + 20

x7% = INT(250 * RND(1) + 201)
x8% = x7% + 20

x9% = INT(300 * RND(1) + 251)
x10% = x9% + 20


'trunks
LINE (x1%, 20)-(x2%, 186), 6, BF
LINE (x3%, 20)-(x4%, 186), 6, BF
LINE (x5%, 20)-(x6%, 186), 6, BF
LINE (x7%, 20)-(x8%, 186), 6, BF
LINE (x9%, 20)-(x10%, 186), 6, BF

'canopy
PSET (1, 1), 2
DRAW "r310 d30 g30 h30 g30 h30 g30 h30 g30 h30 g30 h30 g10 u40"
PAINT (2, 2), 2
END SUB

SUB gameOver (fate%)

  SCREEN 12
  CLS
 
  'eventually make this into a big graphic?
  COLOR 6
  LOCATE 5
  PRINT "                         Y O U                  D I E D !"

  COLOR 7
  LOCATE 10

  SELECT CASE fate%

    CASE 0:      'death by zombie.
      PRINT "  Ah, what a way to go. You got killed by a zombie like dude with a gun. I think"
      PRINT "  a child could have done better than that! I mean, it's not even like you could"
      PRINT "  say you didn't see it coming! Way to go. Well, after you're dead they eat"
      PRINT "  your body and use your clothes to make a bed."

    CASE 1:     'death by hazard
      PRINT "  Ok so you either got here for 1 of 3 reasons. ~Ouch! it's hot!~ or maybe"
      PRINT "  ~oooOOooo! That's pointy!~ and even possibly, ~Oh shit! I can't swim!~. I hope"
      PRINT "  You're aware there's a jump command. Well I guess that doesn't matter now"
      PRINT "  You're dead."

    CASE 3:    'death by walking off a cliff
      PRINT "  You decide that your life has no meaning and that it's time to end it. You"
      PRINT "  do so by walking right off a cliff and/or into a bottomless pit. The only"
      PRINT "  problem is, that it does have a bottom... and you are obliterated when you"
      PRINT "  hit into it."

    CASE 4:    'death by hot dog guy. (they went back!)
      PRINT "  You know, we shouldn't even be at this screen right now. You ate all the guys"
      PRINT "  hot dogs and then you had the nerve to go back and talk to him? Of course he's"
      PRINT "  going to be pissed off! In any case you're already inflated like a balloon so"
      PRINT "  it's not hard for him to ~deflate~ you. He pokes you with a pin and you are"
      PRINT "  gone. Shucks!"

  END SELECT'

  'display game over
  LOCATE 20, 20
  COLOR 4
  PRINT "GAME OVER!"
  LOCATE 21, 25
  COLOR 8
  PRINT "Press space bar..."

  DO
  LOOP WHILE INKEY$ <> " "

  game = FALSE    'set the game as over.

END SUB

SUB hellbentOi
CLS

SCREEN 8
      
LOCATE 15, 10
COLOR 7
PRINT "...There's something in the clearing!"
LOCATE 16, 15
COLOR 4
PRINT "Press space to continue"

DO
LOOP WHILE INKEY$ <> " "

CLS
COLOR 10, 2
LOCATE 1
PRINT
PRINT
PRINT ""
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
PRINT "                                                                              "
COLOR 8, 2
PRINT "                  "

LOCATE 5, 29: COLOR 6, 2: PRINT "ܱ"
LOCATE 6, 29: COLOR 6, 2: PRINT ""
LOCATE 7, 29: COLOR 6, 2: PRINT "߱"

LOCATE 2, 2: COLOR 15, 2: PRINT "S-Head"
LOCATE 3, 2: COLOR 15, 2: PRINT "HP: 43/54"
LOCATE 4, 2: COLOR 15, 2: PRINT "MP: 121/157"

LOCATE 20, 30
COLOR 10, 2
PRINT CHR$(2)

LOCATE 10, 30
COLOR 15, 2
PRINT ""

SLEEP 1             'ew!!!

LOCATE 9, 31
COLOR 15, 2
PRINT "Die you FIEND!"

SLEEP 1

LOCATE 9, 31
COLOR 2, 2
PRINT "              "

LOCATE 10, 30
COLOR 2, 2
PRINT " "
LOCATE 11, 30
COLOR 15, 2
PRINT ""

SLEEP 1

LOCATE 11, 30
COLOR 2, 2
PRINT " "
LOCATE 12, 30
COLOR 15, 2
PRINT ""

LOCATE 20, 30
COLOR 9
PRINT ""

SLEEP 1

LOCATE 12, 30
COLOR 2, 2
PRINT " "
LOCATE 13, 30
COLOR 15, 2
PRINT ""

LOCATE 20, 30
COLOR 2, 2
PRINT " "
LOCATE 19, 30
COLOR 10, 2
PRINT CHR$(2)

SLEEP 1

LOCATE 13, 30
COLOR 2, 2
PRINT " "
LOCATE 14, 30
COLOR 15, 2
PRINT ""

LOCATE 19, 30
COLOR 2, 2
PRINT " "
LOCATE 18, 30
COLOR 9
PRINT ""

SLEEP 1

LOCATE 14, 30
COLOR 2, 2
PRINT " "
LOCATE 15, 30
COLOR 15, 2
PRINT ""

LOCATE 18, 30
COLOR 2, 2
PRINT " "
LOCATE 17, 30
COLOR 10, 2
PRINT CHR$(2)

SLEEP 1

LOCATE 15, 30
COLOR 2, 2
PRINT " "
LOCATE 16, 30
COLOR 15, 2
PRINT ""

LOCATE 17, 30
COLOR 4
PRINT "'argh!"

SLEEP 1

LOCATE 15, 30
COLOR 2, 2
PRINT " "
LOCATE 16, 30
COLOR 15, 2
PRINT ""

LOCATE 17, 30
COLOR 4
PRINT "      "

LOCATE 16, 2
COLOR 6
PRINT CHR$(2); "'"
LOCATE 15, 3
COLOR 15, 2
PRINT "Hey! What's going on?!?"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
PRINT "Oh, well... you know. Killin' zombies."

LOCATE 17, 30
COLOR 4
PRINT ""

LOCATE 16, 2
COLOR 2, 2
PRINT " "
LOCATE 15, 2
PRINT "                        "
LOCATE 16, 3
COLOR 6
PRINT " "; CHR$(2)

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
PRINT "                                       "

LOCATE 17, 30
COLOR 2
PRINT " "

LOCATE 16, 3
COLOR 2, 2
PRINT "    "
LOCATE 15, 7
COLOR 15, 2
PRINT "Aren't we all?"
LOCATE 16, 6
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
PRINT "Um... no? *confused*"

LOCATE 16, 6
COLOR 2, 2
PRINT "    "
LOCATE 15, 7
COLOR 2, 2
PRINT "Aren't we all?"
LOCATE 16, 10
COLOR 6
PRINT CHR$(2)

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Um... no? *confused*"

LOCATE 16, 10
COLOR 2, 2
PRINT "    "
LOCATE 15, 16
COLOR 15, 2
PRINT "Like flap jacks are good!"
LOCATE 16, 15
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Dude, wtf are you talking about?"

LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 16
COLOR 2, 2
PRINT "Like flap jacks"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2)

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?"

LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "Oh you know... things."
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "No! I don't know! *annoyed*"

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?       "

LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "I'm looking to take over this castle!     "
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Well you're out of luck. These are ruins!  "

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "


SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?            "

LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "Shucks! Hey what's up with the graphics?"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Uh... this is the Hellbent ~demo~...            "

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?              "
                                       
LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "Oops! I must have made a wrong turn somewhere."
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Yeah, must have. *underbreath* idiot.           "

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "

SLEEP 2

LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?                   "
                                      
LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "Fine, I'll go! but don't think I didn't hear that!"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"
LOCATE 16, 30
COLOR 15, 2
PRINT " "

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Whatever. Hey! If you see Erik...             "

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?         "
                                     
LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "Yeah?"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT "'"
LOCATE 15, 31
COLOR 15, 2
PRINT "Tell him to finish this damn game!       "

LOCATE 15, 21
COLOR 2, 2
PRINT "1234567890"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); " "

SLEEP 2

LOCATE 16, 30
COLOR 15, 2
PRINT " "
LOCATE 15, 31
COLOR 2, 2
PRINT "Dude, wtf are you talking about?       "
                                    
LOCATE 16, 15
COLOR 2, 2
PRINT "    "
LOCATE 15, 21
COLOR 15, 2
PRINT "~Whatever~ *leaves*"
LOCATE 16, 20
COLOR 6
PRINT CHR$(2); "'"

'going back.
LOCATE 13, 10
COLOR 4, 2
PRINT "PRESS SPACEBAR TO CONTINUE"
DO
LOOP WHILE INKEY$ <> " "
SCREEN 13
CLS


'do an information screen so everyone isn't confused!

END SUB

SUB hotDogDialog

IF condition = 0 THEN
  LOCATE 10                     'locate
  COLOR 10
  PRINT "Hey there fella! Want a hotdog?"  'print

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress

  LOCATE 10                     'locate
  COLOR 15
  PRINT "Does a monkey talk!?!          "  'print

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress
  
  LOCATE 10                     'locate
  COLOR 10
  PRINT "I'm not seeing the relevance of"  'print
  PRINT "that and no, no they do not.   "

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress

  LOCATE 10                     'locate
  COLOR 15
  PRINT "What ever just give me a hotdog!"  'print
  PRINT "                                "
 
  DO: LOOP WHILE INKEY$ = ""        'wait for keypress

  LOCATE 10                    'locate
  COLOR 10
  PRINT "Sure thing, That'll be- HEY BUDDY!"  'print
  PRINT "YOU CAN'T EAT THAT MANY HOTDOGS!!!"

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress

  LOCATE 10                     'locate
  COLOR 15
  PRINT "Watch me!                         "  'print
  PRINT "*Stomach starts to expand...*     "

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress

ELSEIF condition = 1 THEN      'they've been here before!
  
  LOCATE 10                     'locate
  COLOR 10
  PRINT "Hey! You're the jerk who ate all my"  'print
  PRINT "hot dogs! GAAAAAAAAAAAAAAAAARRRR!!!"

  DO: LOOP WHILE INKEY$ = ""        'wait for keypress
  gameOver (4)
END IF

END SUB

SUB hurrayForEarth
SCREEN 12
CLS

COLOR 10
PRINT "                         Water Deep Enough?"
PRINT "                       "
COLOR 7
PRINT "  Well you managed to make it up and to the other side of the river! It's a good"
PRINT "thing too because if you would have went with the flow we'd be scraping you"
PRINT "off the rocks at the bottom of the falls! "
PRINT
PRINT "  On this side of the river there's a large clearing... but what's this? Snow?"
PRINT "in the middle of Summer!?! (Hey! My game, my rules!) Well in anycase you have"
PRINT "a short time before the snow gets bad and you start to freeze to death. Find"
PRINT "shelter as fast as you can!"
PRINT
PRINT
COLOR 4
PRINT "                   ...Press space bar to continue..."
PRINT
PRINT
PRINT
PRINT
PRINT
COLOR 8
PRINT "                   (I'm not quite sure how I'm going to program this yet...)"
DO: LOOP WHILE INKEY$ <> " "

SCREEN 13
CLS


END SUB

SUB init

'variable initialization
pX = 140
pY = 179
pHealth = 100
pDirection = "r"
game = TRUE
areaNum = 0
redraw = TRUE
inJump = FALSE
maxJumpHeight = groundY - 20
inputScreen = FALSE
eventsSet = FALSE
numOfHazards = 0
numOfBadGuys = 0
gunFireOn = FALSE
absorbRequest = FALSE
steppedInPit = FALSE
condition = 0            'not a big fatass.
hasCrown = FALSE         'does not have the crown (not good ending)
crownThere = FALSE
drawSnowfall = FALSE
invincible = FALSE


FOR i% = 1 TO MAXBAD
  badY(i%) = groundY
  badHealth(i%) = 100
  badInRange(i%) = FALSE
  badAlive(i%) = TRUE
  badGuyFiring(i%) = FALSE
  badAbsorbed(i%) = FALSE
NEXT i%

END SUB

SUB initGfx
'initializes graphics and related variables.

SCREEN 13

'get sprites (aka initialize arrays)
LOCATE 15, 30: COLOR 15
PRINT "Loading and initializing sprites..."

FOR y% = 1 TO mrFaceHeight
  FOR x% = 1 TO mrFaceWidth
    READ MRFACENOFIRE
    PSET (x%, y%), MRFACENOFIRE
  NEXT x%
NEXT y%

GET (1, 1)-(mrFaceWidth, mrFaceHeight), MRFACENOFIRE

FOR y% = 1 TO mrFaceHeight
  FOR x% = 1 TO mrFaceWidth
    READ MRFACEFIRE
    PSET (x%, y%), MRFACEFIRE
  NEXT x%
NEXT y%

GET (1, 1)-(mrFaceWidth, mrFaceHeight), MRFACEFIRE


'get ground sprite
FOR y% = 1 TO groundHeight
  READ GROUND
  PSET (1, y%), GROUND
NEXT y%

GET (1, 1)-(1, groundHeight), GROUND

'get dirt ground sprite
FOR y% = 1 TO groundHeight
  READ DIRTGROUND
  PSET (1, y%), DIRTGROUND
NEXT y%

GET (1, 1)-(1, groundHeight), DIRTGROUND

'semi-snow covered ground spirte
FOR y% = 1 TO groundHeight
  READ SEMISNOWGROUND
  PSET (1, y%), SEMISNOWGROUND
NEXT y%

GET (1, 1)-(1, groundHeight), SEMISNOWGROUND

'snowy ground sprite
FOR y% = 1 TO groundHeight
  READ SNOWGROUND
  PSET (1, y%), SNOWGROUND
NEXT y%

GET (1, 1)-(1, groundHeight), SNOWGROUND


'get water sprite
FOR y% = 1 TO waterHeight
  READ WATER
  PSET (1, y%), WATER
NEXT y%

GET (1, 1)-(1, waterHeight), WATER

'lava sprite
FOR y% = 1 TO lavaHeight
  READ LAVA
  PSET (1, y%), LAVA
NEXT y%

GET (1, 1)-(1, lavaHeight), LAVA

'pit data
FOR y% = 1 TO lavaHeight
  READ PIT
  PSET (1, y%), PIT
NEXT y%

GET (1, 1)-(1, lavaHeight), PIT

'spike pit sprite
FOR y% = 1 TO spikeHeight
  FOR x% = 1 TO spikeWidth
    READ SPIKE
    PSET (x%, y%), SPIKE
  NEXT x%
NEXT y%

GET (1, 1)-(spikeWidth, spikeHeight), SPIKE


'bridge sprite
FOR y% = 1 TO groundHeight
  READ BRIDGE
  PSET (1, y%), BRIDGE
NEXT y%

GET (1, 1)-(1, groundHeight), BRIDGE



'init bad guy firing sprite data
FOR y% = 1 TO badGuyHeight
  FOR x% = 1 TO badGuyWidth
    READ BADGUYFIRE
    PSET (x%, y%), BADGUYFIRE
  NEXT x%
NEXT y%


GET (1, 1)-(badGuyWidth, badGuyHeight), BADGUYFIRE

'bad guy not firing sprite
FOR y% = 1 TO badGuyHeight
  FOR x% = 1 TO badGuyWidth
    READ BADGUYNOFIRE
    PSET (x%, y%), BADGUYNOFIRE
  NEXT x%
NEXT y%

GET (1, 1)-(badGuyWidth, badGuyHeight), BADGUYNOFIRE

'bad guy clean mask fanta
FOR y% = 1 TO badGuyHeight
  FOR x% = 1 TO badGuyWidth
    READ BADMASKCLEAN
    PSET (x%, y%), BADMASKCLEAN
  NEXT x%
NEXT y%

GET (1, 1)-(badGuyWidth, badGuyHeight), BADMASKCLEAN


'bad guy mask 7up
FOR y% = 1 TO badMaskHeight
  FOR x% = 1 TO badGuyWidth
    READ BADMASK
    PSET (x%, y%), BADMASK
  NEXT x%
NEXT y%

GET (1, 1)-(badGuyWidth, badMaskHeight), BADMASK

'bad absorb coke
FOR y% = 1 TO badMaskHeight
  FOR x% = 1 TO badGuyWidth
    READ BADABSORB
    PSET (x%, y%), BADABSORB
  NEXT x%
NEXT y%

GET (1, 1)-(badGuyWidth, badMaskHeight), BADABSORB


'initialize left sign data
FOR y% = 1 TO signHeight
  FOR x% = 1 TO signWidth
    READ SIGNL
    PSET (x%, y%), SIGNL
  NEXT x%
NEXT y%

GET (1, 1)-(signWidth, signHeight), SIGNL

'init right sign data
FOR y% = 1 TO signHeight
  FOR x% = 1 TO signWidth
    READ SIGNR
    PSET (x%, y%), SIGNR
  NEXT x%
NEXT y%

GET (1, 1)-(signWidth, signHeight), SIGNR

'get the hot dog stand SPEEEeeeeeeEE RITE!!!!
FOR y% = 1 TO hotDogHeight
  FOR x% = 1 TO hotDogWidth
    READ HOTDOGSTAND
    PSET (x%, y%), HOTDOGSTAND
  NEXT x%
NEXT y%

GET (1, 1)-(hotDogWidth, hotDogHeight), HOTDOGSTAND

'huge mr face head
FOR y% = 1 TO hotDogHeight
  FOR x% = 1 TO hotDogWidth
    READ BIGMRFACE
    PSET (x%, y%), BIGMRFACE
  NEXT x%
NEXT y%

GET (1, 1)-(hotDogWidth, hotDogHeight), BIGMRFACE

'hhuuuuuge mr face legs
FOR y% = 1 TO 7
  FOR x% = 1 TO 5
    READ BIGMRFACELEGS
    PSET (x%, y%), BIGMRFACELEGS
  NEXT x%
NEXT y%

GET (1, 1)-(5, 7), BIGMRFACELEGS


'crown!
FOR y% = 1 TO 2
  FOR x% = 1 TO 5
    READ CROWN
    PSET (x%, y%), CROWN
  NEXT x%
NEXT y%

GET (1, 1)-(5, 2), CROWN

'crown mask!
FOR y% = 1 TO 2
  FOR x% = 1 TO 5
    READ CROWNMASK
    PSET (x%, y%), CROWNMASK
  NEXT x%
NEXT y%

GET (1, 1)-(5, 2), CROWNMASK


END SUB

SUB instructions
CLS

FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

COLOR 10
PRINT
PRINT "                            Instructions on how to play"
PRINT "                           ============================="
COLOR 7
PRINT
PRINT " In this game, the objective is to progress to the end. Wow, that's a really bad"
PRINT " definiton of the game... so...general. Well, in more detail, you fight your way"
PRINT " from level to level using your trusty 9mm and killing bad guys.You have to jump"
PRINT " over obsticles and other stuff. Not that hard of a concept to understand."
PRINT
COLOR 15
PRINT "  Controls:"
PRINT " -----------"
COLOR 7
PRINT " Space bar -  Jump (and it's actually DECENT!)"
PRINT " ~F~ Key - Fire pistol"
PRINT " ~A~ Key - Absorb dead enemy's health"
PRINT " Right Arrow - Move right"
PRINT " Left Arrow - Move left (lost yet?)"
PRINT
COLOR 15
PRINT "  Weapons and Fighting:"
PRINT " -----------------------"
COLOR 7
PRINT " 9mm - This is your primary and only weapon. It's good for taking down any "
PRINT "       baddies you may encounter. It does 20 damage to an enemy without a power"
PRINT "       up. Enemies only have 100 health so that's 5 shots to kill them."
PRINT ""
PRINT " Enemy's Attack - Yes, thats right! The enemies can fire back at you. If you are"
PRINT "                  close enough they can shoot you. After they see you they will"
PRINT "                  continue shooting and running after you until you until one of"
PRINT "                  3 things happens: you get out of range, they die, you die."
COLOR 4
PRINT "Press any key for next page..."
DO: LOOP WHILE INKEY$ = ""

CLS

FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

COLOR 10
PRINT
PRINT "                            Frequently Asked Questions"
PRINT "                           ============================"
COLOR 15
PRINT
PRINT " Q: What's the differences between difficulty modes?"
COLOR 7
PRINT " A: Standard difficulty mode advancement. In easy mode bad guys do very little"
PRINT "    damage and you get large health boosts for making it to a path selection"
PRINT "    screen. As the difficulty goes up, the more damage bad guys do (with you"
PRINT "    still doing the same) and the smaller health bonus you get."
PRINT
COLOR 15
PRINT " Q: I understand that, but what's the deal with ~IMPOSSIBLE~ mode?"
COLOR 7
PRINT " A: You know all those arcade games that are literally impossible to beat?"
PRINT "    This is sort of a play on that. Bad guys do a TON of damage and there are no"
PRINT "    health bonuses for making it to a path selection screen. (Also the game"
PRINT "    takes on a very ~hellish~ look. :P Perhaps try again after you beat the game"
PRINT "    on a different difficulty first. There may be a reward that'll enable you to"
PRINT "    play it!"
PRINT
COLOR 15
PRINT " Q: What is this ~reward~?"
COLOR 7
PRINT " A: Beat the game and find out! I'm sure you won't be disappointed. (That's no"
PRINT "     guarantee though!)"
PRINT
COLOR 15
PRINT " Q: Are there any cheat codes in the game?"
COLOR 7
PRINT " A: It's a Wry series game! OF COURSE there's cheat codes! What they are and how"
PRINT "    they're entered, I'll leave that to you to figure out. Enjoy!"
PRINT
COLOR 4
PRINT "Press any key for next page..."
DO: LOOP WHILE INKEY$ = ""


CLS
FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

COLOR 10
PRINT "                            History of the Wry Series:"
PRINT "                           ============================"
COLOR 7
PRINT " The Wry series started with one of my first full length programs I worked on in"
PRINT " Qbasic. It started before this ~company~ came into existince way back in about"
PRINT " December or november of 1998. (company was formed in Feb/Jan. 1999). It was a"
PRINT " text based comedy game started by me and my friend. (who goes under the allias"
PRINT " of sk8er). Almost single handedly inspired by A Beefinian Tale. "
PRINT ""
PRINT " The original name of the game was ~Lost~, and it was a good name that went"
PRINT " along with the ramshackle story of the first episode. (final ver. episode 3)."
PRINT " Well, episodes one and two where completed.. or almost completed when we got "
PRINT " tired of the constant programming and stopped for a long time. In this time gap"
PRINT " a bunch of progammers known as ~Groovy Concepts~ released their game called"
PRINT " ~Lost~. (now a legendary RPG) One day a guy from ~Groovy Concepts~ told me that"
PRINT " I had to change the name of the game... ~BAH!~ I thought, but did it anyway."
PRINT
PRINT " That week in english class we had the vocab word ~Wry~. It meant a dry sense of"
PRINT " humor. I thought it fit perfect, so off I went, changed the title screen and"
PRINT " game name and started to program again. This time desiding to add 2 more "
PRINT " episodes. (one hidden). I sorta sluggishly finished the project due to my bad"
PRINT " programming skills, but it was released. Bug filled, typo infested, and just"
PRINT " plain corny. "
PRINT
PRINT " Most of the responses I recieved from it where good. Seeing that it was my"
PRINT " first full length project finished. (I'm known for starting many projects and"
PRINT " never finishing them). With this great response, one year later I desided to"
PRINT " make a sequel..."
COLOR 4
PRINT " Press any key for next page..."
DO: LOOP WHILE INKEY$ = ""

CLS
FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

COLOR 10
PRINT "                               History of the Wry Series:"
PRINT "                              ============================"
COLOR 7
PRINT " I looked up in the thesaurus what was another word that meant ~Wry~, the"
PRINT " closest word I came up with was ~Grimace~. Desiding that it was a good name"
PRINT " I desided to start programming again. This time I was going for a side view"
PRINT " action game that had more gameplay than the original. When I started I had no"
PRINT " idea of how in the hell I was going to do this. Programming a moving player"
PRINT " jumping, shooting, and then also enemies and pits. I started thinking this"
PRINT " would be impossible."
PRINT
PRINT " So I asked on my message board how I should go about making the character"
PRINT " move. JMB responded and told me a basic theory of how to do it. I tryed it"
PRINT " and with a little tinkering it worked. (BTW, the method he suggested back"
PRINT " then, I no longer use... too complicated) I set up everything, took me quite"
PRINT " a while to finish, but I did. The response was less than Wry, but better than"
PRINT " a lot of my other programs. "
PRINT
PRINT " One year later I decided to create the sequel (now 2 years after the"
PRINT " original). I got demo length through it, maybe 5 levels. It looked better"
PRINT " than Grimace, but the playing just wasn't as good. I released the demo and it"
PRINT " faired ok I believe, but I didn't like programming for it nor the current"
PRINT " layout. So it was put in ~The forever delayed~ folder. Not touched since now"
PRINT " about another year later. I scrapped the whole thing and started anew. "
PRINT ""
PRINT " I guess that's all there is to the history of Wry."
COLOR 8
PRINT "     (For all those who didn't notice I liked the instructions from Wry 3"
PRINT "     version .0.2.5 (Second Demo) and just updated them a bit to fit)"
COLOR 4
PRINT " Press anykey to return to the menu."
DO: LOOP WHILE INKEY$ = ""

END SUB

SUB itsGoodToBeTheKing
SCREEN 12
CLS

COLOR 10
PRINT "                         Ah! A true king!"
PRINT "                       "
COLOR 7
PRINT "  Wow! It's the Holy Crown of Wintenmasketshire! With this crown you gain by"
PRINT "devine right the power to rule these lands and everyone/thing on it! Atleast"
PRINT "now you won't have to worry about paying your debts back but you still have"
PRINT "no place to live!"
PRINT
PRINT "  Go forth brave king and find a home for yourself, for the winters are cold"
PRINT "and she be coming pretty soon! (hint hint) Anyway, on to what you really care"
PRINT "about..."
PRINT
PRINT "  For being king you now do 2.5x the damage to every enemy. "
PRINT "  You also get a health boost of +50 to your max for putting the crown on."
PRINT "                                       (it's also maxed out for you too. :D)"
PRINT
PRINT
PRINT "                            ...the bad news you ask?"
PRINT
PRINT "  You have to back track all the way back to the swamps. Muhahaha!!!"
PRINT
PRINT
COLOR 14
PRINT "                              Have fun!"
COLOR 4
PRINT "                   ...Press space bar to continue..."
PRINT
PRINT
PRINT
PRINT
PRINT
COLOR 8
PRINT "                   (When did this game start taking place in the Middle Ages?)"
DO: LOOP WHILE INKEY$ <> " "

SCREEN 13
CLS

END SUB

FUNCTION menu%

' main menu function. returns a zero if they decide to quit
' and not play the game. otherwise the game will proceed to
' the first level.

returnVal% = 1
choice% = 1
chosen = FALSE
cursorY = 17
cursorYmask = 16
inMenu = TRUE

SCREEN 12
WHILE inMenu = TRUE
  CLS

  'the classic Wry "stars"
  FOR starGenerator = 1 TO 1000
    XCoordinate = CINT(RND * 800)
    YCoordinate = CINT(RND * 500)
    PSET (XCoordinate, YCoordinate), 7
  NEXT starGenerator

  'Ok so I went a pretty much "straight line" code form of the
  'title screen similar to that you would see in the old "Terror" source
  'code. It seemed the best way to go though. The bitmap was WAYYYY too
  'large and the draw command wasn't flexible enough (only 45degree angles).

  'W
  LINE (40, 15)-(105, 150), 6
  LINE (105, 150)-(135, 100), 6
  LINE (135, 100)-(165, 150), 6
  LINE (165, 150)-(230, 15), 6
  LINE (230, 15)-(190, 15), 6
  LINE (190, 15)-(165, 70), 6
  LINE (165, 70)-(135, 50), 6
  LINE (135, 50)-(105, 70), 6
  LINE (105, 70)-(80, 15), 6
  LINE (80, 15)-(40, 15), 6
  PAINT (45, 20), 6

  'R
  LINE (220, 150)-(240, 80), 6, BF
  LINE (240, 90)-(260, 80), 6
  LINE (260, 90)-(240, 100), 6
  LINE (260, 80)-(280, 80), 6
  LINE (260, 90)-(280, 90), 6
  LINE (280, 80)-(300, 90), 6
  LINE (280, 90)-(290, 95), 6
  LINE (290, 95)-(300, 90), 6
  PAINT (241, 95), 6

  'Y
  LINE (310, 80)-(340, 135), 6
  LINE (340, 135)-(360, 115), 6
  LINE (360, 115)-(330, 80), 6
  LINE (330, 80)-(310, 80), 6
  PAINT (315, 85), 6
  LINE (280, 200)-(390, 80), 6
  LINE (390, 80)-(410, 80), 6
  LINE (410, 80)-(300, 200), 6
  LINE (300, 200)-(280, 200), 6
  PAINT (299, 199), 6

'3 (check out that one massive draw command string)
PSET (440, 15), 7
DRAW "r120 f20 d50 g20 f20 d50 g20 l120 u30 r80 e20 u20 h20 e20 u20 h20 l80 u30"
PAINT (445, 20), 7

COLOR 8
LOCATE 25, 25
PRINT "(c) 2006 Nukem Enterprises"

COLOR 7
LOCATE 16, 45
PRINT "ver. 0.2.3 build Late June 2006"

COLOR 7
LOCATE 17, 12
PRINT "Play game"
LOCATE 18, 12
PRINT "Instructions"
LOCATE 19, 12
PRINT "About NE"
LOCATE 20, 12
PRINT "Quit"

DO
 
  a$ = INKEY$
  COLOR 15
  LOCATE cursorY, 9
  PRINT "-"

  COLOR 0
  LOCATE cursorYmask, 9
  PRINT "  "

  IF a$ = CHR$(0) + CHR$(80) THEN
    IF cursorY + 1 <= 20 THEN
      cursorYmask = cursorY
      cursorY = cursorY + 1
      choice% = choice% + 1
    END IF

  ELSEIF a$ = CHR$(0) + CHR$(72) THEN
    IF cursorY - 1 >= 17 THEN
      cursorYmask = cursorY
      cursorY = cursorY - 1
      choice% = choice% - 1
    END IF

  ELSEIF a$ = CHR$(13) AND (cursorY = 17 OR cursorY = 20) THEN
    chosen = TRUE
    inMenu = FALSE

  ELSEIF a$ = CHR$(13) THEN
    SELECT CASE cursorY
      CASE 18: 'instructions
        chosen = TRUE
       
      CASE 19: 'about NE
        chosen = TRUE
        
    END SELECT

  END IF


LOOP WHILE chosen = FALSE

SELECT CASE choice%

  CASE 1:
    CALL setDifficulty
    returnVal% = 1

  CASE 2:
    CALL instructions
    chosen = FALSE

  CASE 3:
    CALL aboutNE
    chosen = FALSE

  CASE 4:
    returnVal% = 0

END SELECT
WEND
menu% = returnVal%

END FUNCTION

FUNCTION motd% (areaNum%)
'stands for "motd" I took the acronym from Linux/Unix systems logon message
'I'm using it here to display the choices that people can pick

IF areaNum% > 0 THEN
  COLOR 10
  LOCATE 6, 15
  PRINT "Health +"; difficultyLevel
END IF

LOCATE 10
COLOR 7

chosen = FALSE

SELECT CASE areaNum

  CASE 0:
    PRINT "You enter a clearing near what used to"
    PRINT "be you're castle. The sky is black and "
    PRINT "the sun is out (don't ask). So what do"
    PRINT "you want to do?"
    PRINT
    PRINT "        1. Play Tutorial"
    PRINT "        2. Start game"

  CASE 3:       'after first 2 gameplay screens.
    PRINT "At the end of the clearing there seems"
    PRINT "to be a cliff. It looks pretty steep."
    PRINT "Perhaps there's another way around?"
    PRINT
    PRINT "        1. Look for alternative route"
    PRINT "        2. Yodle at the edge"

  CASE 7:        'after they fell off the cliff
    PRINT "Well you're back at the wall you fell"
    PRINT "off of. (Only at the bottom). You could"
    PRINT "climb back up and attempt to jump the"
    PRINT "canyon thingy or you could kill yourself"
    PRINT "and try to forge the river. The ball is"
    PRINT "in your court..."
    PRINT
    PRINT "  1. Prove that more than one person"
    PRINT "     could walk on water..."
    PRINT "  2. Attempt to jump it"
    

  CASE 11:         'after the whole canyon ordeal
    PRINT "After jumping over the canyon, you "
    PRINT "notice there WAS a bridge there the "
    PRINT "whole time! Oh well, it's too late now."
    PRINT "Well now, where do you want to go?"
    PRINT
    PRINT "      1. Go to the hotdog stand"
    PRINT "      2. Enter path into the woods"

  CASE 16:         'after hb clip embarrasement (spelling?)
    IF hasCrown = FALSE THEN
      PRINT "Well it appears you've managed to vear"
      PRINT "completely off course. What course might"
      PRINT "that be? I have no idea... but perhaps"
      PRINT "one these two choices might be correct?"
    
      LOCATE 15, 5
      PRINT "1. Check for bears in that cave"
      LOCATE 16, 5
      PRINT "2. Go swimming in the swamps."
   
    ELSEIF hasCrown = TRUE THEN
      PRINT "Ok, so you made it back to the edge of"
      PRINT "the woods. Now, I think this one's a"
      PRINT "no brainer but I'm sure someone will"
      PRINT "prove me wrong."

      LOCATE 15, 5
      PRINT "1. BACK INTO THE CAVE! (why?)"
      LOCATE 16, 5
      PRINT "2. Continue into the swamps."
    END IF

  CASE 23:           'in river input box.
    IF hasCrown = TRUE THEN
      PRINT "Ah, what a strange place for a path"
      PRINT "selection wouldn't you say? Well tough"
      PRINT "cookies! Just because you're some BS"
      PRINT "king doesn't mean you get special"
      PRINT "treatment. You're caught in the river"
      PRINT "NOT bad enough that you can't fight it!"
      PRINT "Which way to your salvation?"
      PRINT
      PRINT "      1. Fight your way upstream!"
      PRINT "      2. Flow with the current."
   
    ELSE
      PRINT "Ah, what a strange place for a path"
      PRINT "selection wouldn't you say? Well tough"
      PRINT "cookies! You're caught in the river but"
      PRINT "not bad enough that you can't fight it!"
      PRINT "Which way to salvation?"
      PRINT
      PRINT "      1. Fight your way upstream!"
      PRINT "      2. Flow with the current."
    END IF

  CASE 28:           'in the snow storm.
    IF hasCrown = TRUE THEN
      PRINT "The snow has gotten so bad you can't"
      PRINT "go on. You have to find some sort of"
      PRINT "shelter ASAP! Good thing there just so"
      PRINT "happens to be a house here! They'll"
      PRINT "certainly let their king stay! ...right?"
      PRINT
      PRINT "1. Enter the house! I want hot pants!!!"
      PRINT "2. Nah, I'm good. I like the cold."
  
    ELSE
      PRINT "The snow has gotten so bad you can't"
      PRINT "go on. You have to find some sort of"
      PRINT "shelter ASAP! Good thing there just so"
      PRINT "happens to be a house there, but then"
      PRINT "again it might be dangerous."
      PRINT
      PRINT "1. Go in the house! I want hot cocoa!!!"
      PRINT "2. Nah, I'm good. I like the cold."
    END IF
  
  CASE 35             'post bridge input screen
    IF hasCrown = TRUE THEN
      PRINT "Your journey over the bridge saved "
      PRINT "you months off your quest. (Actually"
      PRINT "not, if you fall you die). But anyway"
      PRINT "you now have to choose between 2 paths"
      PRINT "to your newly awaiting kingdome? (I am"
      PRINT "sooooo winging this :P)"
      PRINT
      PRINT "1. Go forth through perilous mountains"
      PRINT "2. Chicken out and go through the valley"

    ELSE
      PRINT "Your journey over the bridge saved "
      PRINT "you months off your quest. (Actually"
      PRINT "not, if you fall you die). But anyway"
      PRINT "you now have to choose between 2 paths"
      PRINT "to continue your journey.(This story"
      PRINT "needs some substance ASAP...)"
      PRINT
      PRINT "1. Go over the dinky mountains."
      PRINT "2. Brave it through the valley of death!"
    END IF

END SELECT

WHILE chosen = FALSE

  a$ = INKEY$

  IF a$ = "1" THEN
    returnVal% = LEFT
    chosen = TRUE
    inputScreen = EXITING

  ELSEIF a$ = "2" THEN
    returnVal% = RIGHT
    chosen = TRUE
    inputScreen = EXITING
  END IF
WEND

motd% = returnVal%

END FUNCTION

SUB move (direction$)

SELECT CASE direction$
 
  CASE "l"                 'move player left
    IF condition = 0 THEN
      IF gunFireOn = FALSE THEN
        PUT (pX, pY), MRFACENOFIRE
      ELSE
        PUT (pX, pY), MRFACEFIRE
        gunFireOn = FALSE
      END IF
   
      IF hasCrown = TRUE THEN
        PUT (pX, pY - 2), CROWN
      END IF

      pX = pX - 3
   
      PUT (pX, pY), MRFACENOFIRE, XOR
     
      IF hasCrown = TRUE THEN
        PUT (pX, pY - 2), CROWN, XOR
      END IF

    ELSEIF condition = 1 THEN        'uh oh!
      PUT (pX, pY + 2), BIGMRFACELEGS
      PUT (pX - 10, pY - 43), BIGMRFACE

      pX = pX - 3

      PUT (pX, pY + 2), BIGMRFACELEGS, XOR
      PUT (pX - 10, pY - 43), BIGMRFACE, XOR
    END IF

 
  CASE "r"                 'move player right
    
    IF condition = 0 THEN
      IF gunFireOn = FALSE THEN
        PUT (pX, pY), MRFACENOFIRE
      ELSE
        PUT (pX, pY), MRFACEFIRE
        gunFireOn = FALSE
      END IF

      IF hasCrown = TRUE THEN
        PUT (pX, pY - 2), CROWN
      END IF

      pX = pX + 3
      PUT (pX, pY), MRFACENOFIRE, XOR
     
      IF hasCrown = TRUE THEN
        PUT (pX, pY - 2), CROWN, XOR
      END IF

    ELSEIF condition = 1 THEN        'uh oh!
      PUT (pX, pY + 2), BIGMRFACELEGS
      PUT (pX - 10, pY - 43), BIGMRFACE

      pX = pX + 3

      PUT (pX, pY + 2), BIGMRFACELEGS, XOR
      PUT (pX - 10, pY - 43), BIGMRFACE, XOR
    END IF


  CASE "u"                 'make player jump
    IF inJump = FALSE THEN
      inJump = TRUE
      goingUp = TRUE
    END IF

END SELECT

END SUB

SUB niceHouse (dialog%)
SCREEN 12
CLS

SELECT CASE dialog%

  CASE 1
    IF hasCrown = TRUE THEN

    COLOR 10
    PRINT "                         Nice home ya got here."
    PRINT "                       "
    COLOR 7
    PRINT "  You barge into this random house that was lining your path. The people inside"
    PRINT "jump in fear and confusion. You attempt to explain to them that there's a storm"
    PRINT "going on outside but they have no idea what you're saying. This being because"
    PRINT "you write and speak in your own made up language that no one can understand but"
    PRINT "you. (This would explain why dialogs make no sense in this game)."
    PRINT
    PRINT "  The family does have pity on you though. They allow you to spend the storm"
    PRINT "out inside. Well, maybe they didn't but you did anyway because you're the KING!"
    PRINT "...and no one can talk back to the king!"
    PRINT
    PRINT "       The storm ends and you are sent off with a big ol' boot to the ass."
    COLOR 4
    PRINT "                   ...Press space bar to continue..."
    DO: LOOP WHILE INKEY$ <> " "

    ELSE
    COLOR 10
    PRINT "                         Nice home ya got here."
    PRINT "                       "
    COLOR 7
    PRINT "  You barge into this random house that was lining your path. The people inside"
    PRINT "jump in fear and confusion. You attempt to explain to them that there's a storm"
    PRINT "going on outside but they have no idea what you're saying. This being because"
    PRINT "you write and speak in your own made up language that no one can understand but"
    PRINT "you. (This would explain why dialogs make no sense in this game)."
    PRINT
    PRINT "  The family does have pity on you though. They allow you to spend the storm"
    PRINT "out inside. Well, maybe they didn't but you did anyway because you're a mooch!"
    PRINT "...and no one can take that away from you."
    PRINT
    PRINT "       The storm ends and you are sent off with a big ol' boot to the ass."
    COLOR 4
    PRINT "                   ...Press space bar to continue..."
    DO: LOOP WHILE INKEY$ <> " "


    END IF

  CASE 2

    IF hasCrown = TRUE THEN
    COLOR 10
    PRINT "                         Hey Honey! I'm home!"
    PRINT "                       "
    COLOR 7
    PRINT "  You yet again barge into the same random house that was lining your path as "
    PRINT "before. The people yet jump in fear and confusion. This time they aren't as "
    PRINT "forgiving as they were the fist time. (There's no storm going on this time)."
    PRINT "They start yelling at you until they're blue in the face. You don't seem to care"
    PRINT "because YOU ARE THE KING! So you smack the father in the face in the middle of"
    PRINT "his tantrum."
    PRINT
    PRINT "       He doesn't like this and punches you in the head, sending you flying"
    PRINT "       out the window."
    COLOR 4
    PRINT "                   ...Press space bar to continue..."
    COLOR 8
    LOCATE 22, 25
    PRINT "(ouch!)"
    DO: LOOP WHILE INKEY$ <> " "

    ELSE
    COLOR 10
    PRINT "                         Hey Honey! I'm home!"
    PRINT "                       "
    COLOR 7
    PRINT "  You yet again barge into the same random house that was lining your path as "
    PRINT "before. The people yet jump in fear and confusion. This time they aren't as "
    PRINT "forgiving as they were the fist time. (There's no storm going on this time)."
    PRINT "They start yelling at you until they're blue in the face. You don't seem to care"
    PRINT "because YOU'RE DEAF!"
    PRINT
    PRINT "OMG! When did this happen!?! Wait a second... there's no sound in this game."
    PRINT "There's no reason for you to have hearing! Stupid me. So anyway, continuing"
    PRINT "on..."
    PRINT
    PRINT "You smack the father in the face in the middle of his tantrum. "
    PRINT
    PRINT "       He doesn't like this and punches you in the head, sending you flying"
    PRINT "       out the window."
    COLOR 4
    PRINT "                   ...Press space bar to continue..."
    COLOR 8
    LOCATE 22, 25
    PRINT "(idiot!)"
    DO: LOOP WHILE INKEY$ <> " "

    END IF

END SELECT
SCREEN 13
CLS

END SUB

SUB postGame

CLS
COLOR 7
PRINT "             Wry 3 : Stale & Malodorous"
PRINT "                  By: Erik Eriksen"
PRINT "           "
PRINT
PRINT " Thank you for playing Wry 3! It's only taken over 4 years of production"
PRINT " to bring you this stellar piece of crap. I must say though it was a lot"
PRINT " of fun to program and it's a hell of a lot better than the last two "
PRINT " demos of this game. (If you played them, I'm sure you'd agree :P)"
PRINT
PRINT " I hope you enjoyed playing this game and it didn't give you any kind of"
PRINT " weird diseases or rashes. If you're thinking it might have, I'd suggest"
PRINT " taking a better look at that there keyboard before you point your fingers"
PRINT " at me!"
PRINT
PRINT "       ...see? Dirty just as I insinuated. "
PRINT
PRINT " Anyway, If you want to go to my website or contact me, here's all the "
PRINT " info right here:"
PRINT
PRINT " Website: http://eriks.servehttp.com"
PRINT "          http://www.geocities.com/nukemn0w"
PRINT "  E-mail: shamrice@optonline.net"
PRINT "     ICQ: 17951293"


END SUB

SUB preGame
'displays the games story.
CLS
COLOR 10
PRINT "                         Wry 3.3!"
PRINT "                       "
COLOR 7
PRINT "  Ah, it's time for another Wry installment. Actually, it was apparently"
PRINT "time for another ~installment~ 4 years ago! But things don't always work"
PRINT "out as we plan now do they?  ...DO THEY!?!"
PRINT
PRINT "                 ...OKAY! Moving on..."
PRINT
PRINT "  One day you're just sitting in your Castle in all your own glory when"
PRINT "all of a sudden a bulldozer crashes through the Dining room wall and starts"
PRINT "to tear your house down. You attempt to stop the bulldozer but a 4x6 pixel"
PRINT "sprite is no match for a 10 ton piece of construction equipment. (Who saw"
PRINT "that one coming?). "
PRINT ""
PRINT "  After jumping up and down for 45 minutes like Rumplstiltskin the wrecking"
PRINT "crew gets freaked out and runs away. You figure the reason they're knocking"
PRINT "your house down is because you're a few days late on your usual morgage "
PRINT "payment of 500 hotdogs a month. (You know, not because you've been paying"
PRINT "IN HOT DOGS!). So to make a long and boring story short, you decide to"
PRINT "go to the bank and pay your bill."
COLOR 8
PRINT "            (btw the reset of your castle fell down as you walked away)"
COLOR 4
PRINT "                                 ...press space bar to begin "
DO
LOOP WHILE INKEY$ <> " "
END SUB

SUB preTitle

'Displays the NE logo... that's all.
CLS
SCREEN 12

FOR starGenerator = 1 TO 1000
  XCoordinate = CINT(RND * 800)
  YCoordinate = CINT(RND * 500)
  PSET (XCoordinate, YCoordinate), 7
NEXT starGenerator

LOCATE 3, 1: COLOR 6
PRINT "                   "
PRINT "                  "
PRINT "                 "
PRINT "             "
PRINT "                     "
PRINT "                    "
PRINT "                    "
PRINT "              "
PRINT "                           << E n t e r p r i s e s >>"
LOCATE 16, 30: COLOR 15
PRINT "-=:: PRESENTS ::=-"

LOCATE 20: COLOR 8
PRINT "  ...yes I'm aware this company ~splash~ screen is over 7 years old..."
SLEEP 3


END SUB

SUB setDifficulty
CLS
  

choice% = 1
chosen = FALSE
cursorY = 17
cursorYmask = 16

inMenu = TRUE


WHILE inMenu = TRUE


  'the classic Wry "stars"
  FOR starGenerator = 1 TO 1000
    XCoordinate = CINT(RND * 800)
    YCoordinate = CINT(RND * 500)
    PSET (XCoordinate, YCoordinate), 7
  NEXT starGenerator

  'Ok so I went a pretty much "straight line" code form of the
  'title screen similar to that you would see in the old "Terror" source
  'code. It seemed the best way to go though. The bitmap was WAYYYY too
  'large and the draw command wasn't flexible enough (only 45degree angles).

  'W
  LINE (40, 15)-(105, 150), 6
  LINE (105, 150)-(135, 100), 6
  LINE (135, 100)-(165, 150), 6
  LINE (165, 150)-(230, 15), 6
  LINE (230, 15)-(190, 15), 6
  LINE (190, 15)-(165, 70), 6
  LINE (165, 70)-(135, 50), 6
  LINE (135, 50)-(105, 70), 6
  LINE (105, 70)-(80, 15), 6
  LINE (80, 15)-(40, 15), 6
  PAINT (45, 20), 6

  'R
  LINE (220, 150)-(240, 80), 6, BF
  LINE (240, 90)-(260, 80), 6
  LINE (260, 90)-(240, 100), 6
  LINE (260, 80)-(280, 80), 6
  LINE (260, 90)-(280, 90), 6
  LINE (280, 80)-(300, 90), 6
  LINE (280, 90)-(290, 95), 6
  LINE (290, 95)-(300, 90), 6
  PAINT (241, 95), 6

  'Y
  LINE (310, 80)-(340, 135), 6
  LINE (340, 135)-(360, 115), 6
  LINE (360, 115)-(330, 80), 6
  LINE (330, 80)-(310, 80), 6
  PAINT (315, 85), 6
  LINE (280, 200)-(390, 80), 6
  LINE (390, 80)-(410, 80), 6
  LINE (410, 80)-(300, 200), 6
  LINE (300, 200)-(280, 200), 6
  PAINT (299, 199), 6

'3 (check out that one massive draw command string)
PSET (440, 15), 7
DRAW "r120 f20 d50 g20 f20 d50 g20 l120 u30 r80 e20 u20 h20 e20 u20 h20 l80 u30"
PAINT (445, 20), 7

COLOR 8
LOCATE 25, 25
PRINT "(c) 2006 Nukem Enterprises"

COLOR 7
LOCATE 16, 45
PRINT "ver. 0.2.3 build Late June 2006"

COLOR 15
LOCATE 16, 12
PRINT "Select Difficulty:"
COLOR 7
LOCATE 17, 12
PRINT "Easy"
COLOR 10
LOCATE 18, 12
PRINT "Normal"
COLOR 14
LOCATE 19, 12
PRINT "Hard"
LOCATE 20, 12
COLOR 4
PRINT "IMPOSSIBLE"

DO

  a$ = INKEY$
  COLOR 15
  LOCATE cursorY, 9
  PRINT "-"

  COLOR 0
  LOCATE cursorYmask, 9
  PRINT "  "

  IF a$ = CHR$(0) + CHR$(80) THEN
    IF cursorY + 1 <= 20 THEN
      cursorYmask = cursorY
      cursorY = cursorY + 1
      choice% = choice% + 1
    END IF

  ELSEIF a$ = CHR$(0) + CHR$(72) THEN
    IF cursorY - 1 >= 17 THEN
      cursorYmask = cursorY
      cursorY = cursorY - 1
      choice% = choice% - 1
    END IF

  ELSEIF a$ = CHR$(13) AND (cursorY = 17 OR cursorY = 20) THEN
    chosen = TRUE
    inMenu = FALSE

  ELSEIF a$ = CHR$(13) THEN
    SELECT CASE cursorY
      CASE 18: 'instructions
        chosen = TRUE
      
      CASE 19: 'about NE
        chosen = TRUE
       
    END SELECT

  END IF


LOOP WHILE chosen = FALSE

SELECT CASE choice%

  CASE 1:
    difficultyLevel = 50
    chosen = TRUE
    inMenu = FALSE

  CASE 2:
    difficultyLevel = 20
    chosen = TRUE
    inMenu = FALSE

  CASE 3:
    difficultyLevel = 5
    chosen = TRUE
    inMenu = FALSE

  CASE 4:
    LOCATE 22, 10
    COLOR 4
    PRINT "WARNING: "
    LOCATE 22, 19
    COLOR 15
    PRINT "This difficulty isn't even remotely fair."
    LOCATE 23, 19
    INPUT "Continue anyway? [y/n] ", contin$

    IF contin$ = "y" OR contin$ = "Y" THEN
      difficultyLevel = 0
      chosen = TRUE

    ELSE
      chosen = FALSE
      inMenu = TRUE
      CLS

    END IF

END SELECT

WEND

'set bad guy damage depending on difficulty level...

IF difficultyLevel = 50 THEN 'easy
  difficultyDamage = 2
  difficultyDamageJump = 1

ELSEIF difficultyLevel = 20 THEN 'normal
  difficultyDamage = 3
  difficultyDamageJump = 2

ELSEIF difficultyLevel = 5 THEN 'hard
  difficultyDamage = 5
  difficultyDamageJump = 3

ELSEIF difficultyDamage = 0 THEN 'impossible
  difficultyDamage = 10
  difficultyDamageJump = 5
END IF


END SUB

SUB setEventData (areaNum%)
 
  SELECT CASE areaNum      'set event data for level.

    CASE 300              'tutorial level 1
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfSpecialPitHazards = 0
      numOfWaterHazards = 1
      waterHazardXmin(1) = 40
      waterHazardXmax(1) = 60
      waterHazardWidth(1) = 20
     
      numOfLavaHazards = 1
      lavaHazardXmin(1) = 100
      lavaHazardXmax(1) = 120
      lavaHazardWidth(1) = 20

      numOfPitHazards = 1
      pitHazardXmin(1) = 160
      pitHazardXmax(1) = 180
      pitHazardWidth(1) = 20
     
      numOfSpikeHazards = 1
      spikeHazardXmin(1) = 210
      spikeHazardXmax(1) = 235
      spikeHazardWidth(1) = 20
      

    CASE 301              'tutorial level 2
      numOfBadGuys = 4
      badGuysThere = TRUE
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      badX(1) = 70
      badX(2) = 100
      badX(3) = 140
      badX(4) = 220

    CASE 302              'tutorial level 3
      numOfBadGuys = 3
      badGuysThere = TRUE

      numOfWaterHazards = 0
      numOfSpikeHazards = 0

      numOfLavaHazards = 1
      lavaHazardXmin(1) = 50
      lavaHazardXmax(1) = 100
      lavaHazardWidth(1) = 50
     
      numOfPitHazards = 1
      pitHazardXmin(1) = 150
      pitHazardXmax(1) = 200
      pitHazardWidth(1) = 50
      

      numOfSpecialPitHazards = 0
      badX(1) = 100
      badX(2) = 220
      badX(3) = 250
      

    CASE 0                'first input screen
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

    CASE 1
      numOfBadGuys = 1    'num - 1 b/c starts at element 0
      badGuysThere = TRUE

      badX(1) = 200       'array element is the badguy #

      numOfEvents = 1
      eventXmin(1) = 20
      eventXmax(1) = 25
      eventText(1) = "...the adventure begins"

      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      'water trap location
      numOfWaterHazards = 1
      waterHazardXmin(1) = 80
      waterHazardXmax(1) = 126     'actually ends at 120, draw goes over though
      waterHazardWidth(1) = 46

    CASE 2                      'second gameplay screen
      badGuysThere = TRUE
      numOfBadGuys = 2
 
      badX(1) = 70
      badX(2) = 160

      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
     
      'water traps
      numOfWaterHazards = 2
      waterHazardXmin(1) = 100
      waterHazardXmax(1) = 150
      waterHazardWidth(1) = 50
      waterHazardXmin(2) = 170
      waterHazardXmax(2) = 270
      waterHazardWidth(2) = 100

    CASE 3                    'second input screen
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
   
    CASE 4
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
   
    CASE 5
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
     
      badX(1) = 250
      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 230
      waterHazardWidth(1) = 230

    CASE 6
      numOfBadGuys = 3
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 3
      numOfSpecialPitHazards = 0
     
      badX(1) = 75
      badX(2) = 140
      badX(3) = 250

      spikeHazardXmin(1) = 30
      spikeHazardXmax(1) = 70
      spikeHazardWidth(1) = 40

      spikeHazardXmin(2) = 90
      spikeHazardXmax(2) = 130
      spikeHazardWidth(2) = 40

      spikeHazardXmin(3) = 170
      spikeHazardXmax(3) = 220
      spikeHazardWidth(3) = 50


    CASE 7            'input screen
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

    CASE 8            'forging the river
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 310
      waterHazardWidth(1) = 310

    CASE 9             'attempting to jump the canyon.
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 1

      specialPitHazardXmin(1) = 250
      specialPitHazardXmax(1) = 310
      specialPitHazardWidth(1) = 60

    CASE 10             'other side of canyon...
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 1

      badX(1) = 200
      specialPitHazardXmin(1) = 0
      specialPitHazardXmax(1) = 100
      specialPitHazardWidth(1) = 100

    CASE 11                'input screen after canyon
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      eventXmin(1) = -5
      eventXmax(1) = -5


    CASE 12                 'hot dog stand
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 1
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      numOfEvents = 1
      eventXmin(1) = 170
      eventXmax(1) = 290
      eventText(1) = "Do you want a hotdog?"

    CASE 13                 'inflated mr face
      numOfBadGuys = 0
      condition = 1         'big fat ass contition.
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 7
      numOfSpecialPitHazards = 0
     
      spikeHazardXmin(1) = 20
      spikeHazardXmax(1) = 40
      spikeHazardWidth(1) = 20
     
      spikeHazardXmin(2) = 50
      spikeHazardXmax(2) = 80
      spikeHazardWidth(2) = 30
     
      spikeHazardXmin(3) = 100
      spikeHazardXmax(3) = 130
      spikeHazardWidth(3) = 30
     
      spikeHazardXmin(4) = 140
      spikeHazardXmax(4) = 160
      spikeHazardWidth(4) = 20

      spikeHazardXmin(5) = 170
      spikeHazardXmax(5) = 200
      spikeHazardWidth(5) = 30

      spikeHazardXmin(6) = 210
      spikeHazardXmax(6) = 240
      spikeHazardWidth(6) = 30

      spikeHazardXmin(7) = 245
      spikeHazardXmax(7) = 285
      spikeHazardWidth(7) = 40

    CASE 14                    'woods level 1
      condition = 0
      numOfBadGuys = 3
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      badX(1) = 80
      badX(2) = 95
      badX(3) = 200

    CASE 15                    'woods level 2
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 2
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      badX(1) = 80
      badX(2) = 95
      
      pitHazardXmin(1) = 120
      pitHazardXmax(1) = 178
      pitHazardWidth(1) = 60

      pitHazardXmin(2) = 185
      pitHazardXmax(2) = 250
      pitHazardWidth(2) = 65

    CASE 16                    'caves or swamps input screen
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

    CASE 17                   'caves level 1
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 2
      numOfPitHazards = 0
      numOfSpikeHazards = 1
      numOfSpecialPitHazards = 0

      lavaHazardXmin(1) = 50
      lavaHazardXmax(1) = 120
      lavaHazardWidth(1) = 70

      spikeHazardXmin(1) = 130
      spikeHazardXmax(1) = 200
      spikeHazardWidth(1) = 70

      lavaHazardXmin(2) = 210
      lavaHazardXmax(2) = 280
      lavaHazardWidth(2) = 70

      badX(1) = 120
      badX(2) = 200

    CASE 18                   'caves level 2
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 5
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      crownThere = FALSE

      lavaHazardXmin(1) = 20
      lavaHazardXmax(1) = 60
      lavaHazardWidth(1) = 40

      lavaHazardXmin(2) = 70
      lavaHazardXmax(2) = 110
      lavaHazardWidth(2) = 40

      lavaHazardXmin(3) = 125
      lavaHazardXmax(3) = 165
      lavaHazardWidth(3) = 40

      lavaHazardXmin(4) = 170
      lavaHazardXmax(4) = 220
      lavaHazardWidth(4) = 50

      lavaHazardXmin(5) = 222
      lavaHazardXmax(5) = 277
      lavaHazardWidth(5) = 55

      badX(1) = 110
      badX(2) = 277

    CASE 19                    'caves level 3. (where crown is at)
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 2
      numOfPitHazards = 1
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      IF hasCrown = FALSE THEN
        crownThere = TRUE
        crownX = 285
        crownXmin = 282
        crownXmax = 288
      END IF

      pitHazardXmin(1) = 170
      pitHazardXmax(1) = 250
      pitHazardWidth(1) = 80

      lavaHazardXmin(1) = 30
      lavaHazardXmax(1) = 80
      lavaHazardWidth(1) = 50

      lavaHazardXmin(2) = 90
      lavaHazardXmax(2) = 140
      lavaHazardWidth(2) = 50

      badX(1) = 80
      badX(2) = 140

    CASE 20                    'swamps area 2
      condition = 0
      numOfBadGuys = 3
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 9
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 25
      waterHazardXmax(1) = 30
      waterHazardWidth(1) = 5

      waterHazardXmin(2) = 35
      waterHazardXmax(2) = 45
      waterHazardWidth(2) = 10
     
      waterHazardXmin(3) = 50
      waterHazardXmax(3) = 55
      waterHazardWidth(3) = 5

      waterHazardXmin(4) = 60
      waterHazardXmax(4) = 70
      waterHazardWidth(4) = 10

      waterHazardXmin(5) = 80
      waterHazardXmax(5) = 100
      waterHazardWidth(5) = 20

      waterHazardXmin(6) = 125
      waterHazardXmax(6) = 150
      waterHazardWidth(6) = 25

      waterHazardXmin(7) = 155
      waterHazardXmax(7) = 200
      waterHazardWidth(7) = 45

      waterHazardXmin(8) = 225
      waterHazardXmax(8) = 230
      waterHazardWidth(8) = 5

      waterHazardXmin(9) = 250
      waterHazardXmax(9) = 285
      waterHazardWidth(9) = 35

      badX(1) = 70
      badX(2) = 100
      badX(3) = 200
 
    CASE 21                         'swamp area 2
      condition = 0
      numOfBadGuys = 4
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 6
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 25
      waterHazardXmax(1) = 50
      waterHazardWidth(1) = 25

      waterHazardXmin(2) = 55
      waterHazardXmax(2) = 105
      waterHazardWidth(2) = 50
    
      waterHazardXmin(3) = 110
      waterHazardXmax(3) = 155
      waterHazardWidth(3) = 45

      waterHazardXmin(4) = 160
      waterHazardXmax(4) = 170
      waterHazardWidth(4) = 10

      waterHazardXmin(5) = 180
      waterHazardXmax(5) = 230
      waterHazardWidth(5) = 50

      waterHazardXmin(6) = 235
      waterHazardXmax(6) = 285
      waterHazardWidth(6) = 50

      badX(1) = 170
      badX(2) = 105
      badX(3) = 155
      badX(4) = 230

    CASE 22                  'swamps exit
      condition = 0
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 140
      waterHazardXmax(1) = 310
      waterHazardWidth(1) = 170

      badX(1) = 75

    CASE 23                 'in river input screen
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 0
      waterHazardWidth(1) = 310

    CASE 24                   'flow to the falls
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 1
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      drawSnowfall = FALSE

      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 175
      waterHazardWidth(1) = 175

      pitHazardXmin(1) = 175
      pitHazardXmax(1) = 310
      pitHazardWidth(1) = 135

    CASE 25                  'fight upstream
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0

      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 310
      waterHazardWidth(1) = 310

    CASE 26                     'snow level 1
      condition = 0
      numOfBadGuys = 3
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 3
      numOfSpecialPitHazards = 0
      drawSnowfall = TRUE

      waterHazardXmin(1) = 0
      waterHazardXmax(1) = 25
      waterHazardWidth(1) = 25

      spikeHazardXmin(1) = 40
      spikeHazardXmax(1) = 75
      spikeHazardWidth(1) = 35

      spikeHazardXmin(2) = 100
      spikeHazardXmax(2) = 150
      spikeHazardWidth(2) = 50

      spikeHazardXmin(3) = 200
      spikeHazardXmax(3) = 250
      spikeHazardWidth(3) = 50

      badX(1) = 90
      badX(2) = 175
      badX(3) = 250

    CASE 27                        'snow level 2
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 2
      numOfSpecialPitHazards = 0
      drawSnowfall = TRUE

      spikeHazardXmin(1) = 100
      spikeHazardXmax(1) = 160
      spikeHazardWidth(1) = 60

      spikeHazardXmin(2) = 170
      spikeHazardXmax(2) = 230
      spikeHazardWidth(2) = 60

      badX(1) = 160
      badX(2) = 240

    CASE 28                         'snow storm input screen
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      drawSnowfall = FALSE

    CASE 29                     'rough it in the snow = death
      condition = 0
      numOfBadGuys = 0
      badGuysThere = FALSE
      numberOfEvents = 0
      numOfWaterHazards = 1
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      drawSnowfall = TRUE

      waterHazardXmin(1) = 0           'pretty clever eh? Looks like the
      waterHazardXmax(1) = 310         'cold is hurting them when playing..
      waterHazardWidth(1) = 310


    CASE 30
      condition = 0
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 3
      numOfSpecialPitHazards = 0
      numOfBridgeSprites = 0
      drawSnowfall = FALSE

      spikeHazardXmin(1) = 20
      spikeHazardXmax(1) = 75
      spikeHazardWidth(1) = 55

      spikeHazardXmin(2) = 85
      spikeHazardXmax(2) = 165
      spikeHazardWidth(2) = 80

      spikeHazardXmin(3) = 250
      spikeHazardXmax(3) = 300
      spikeHazardWidth(3) = 50

      badX(1) = 200


    CASE 31
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 1
      numOfSpecialPitHazards = 0
      numOfBridgeSprites = 1
      drawSnowfall = FALSE
     
      spikeHazardXmin(1) = 25
      spikeHazardXmax(1) = 105
      spikeHazardWidth(1) = 80

      bridgeXmin(1) = 160
      bridgeXmax(1) = 310
      bridgeWidth(1) = 150

      badX(1) = 130
      badX(2) = 275

    CASE 32
      condition = 0
      numOfBadGuys = 2
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 4
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      numOfBridgeSprites = 0
    
      pitHazardXmin(1) = 25
      pitHazardXmax(1) = 55
      pitHazardWidth(1) = 30

      pitHazardXmin(2) = 75
      pitHazardXmax(2) = 95
      pitHazardWidth(2) = 20
     
      pitHazardXmin(3) = 140
      pitHazardXmax(3) = 175
      pitHazardWidth(3) = 35
     
      pitHazardXmin(4) = 220
      pitHazardXmax(4) = 265
      pitHazardWidth(4) = 45

      badX(1) = 120
      badX(2) = 200
   
    CASE 33
      condition = 0
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 2
      numOfSpikeHazards = 0
      numOfSpecialPitHazards = 0
      numOfBridgeSprites = 0
    
      pitHazardXmin(1) = 40
      pitHazardXmax(1) = 110
      pitHazardWidth(1) = 70

      pitHazardXmin(2) = 120
      pitHazardXmax(2) = 200
      pitHazardWidth(2) = 80
     
      badX(1) = 230

    CASE 34
      condition = 0
      numOfBadGuys = 1
      badGuysThere = TRUE
      numberOfEvents = 0
      numOfWaterHazards = 0
      numOfLavaHazards = 0
      numOfPitHazards = 0
      numOfSpikeHazards = 3
      numOfSpecialPitHazards = 0
      numOfBridgeSprites = 1

      bridgeXmin(1) = 0
      bridgeXmax(1) = 150
      bridgeWidth(1) = 150


      spikeHazardXmin(1) = 170
      spikeHazardXmax(1) = 190
      spikeHazardWidth(1) = 20

      spikeHazardXmin(2) = 200
      spikeHazardXmax(2) = 235
      spikeHazardWidth(2) = 35

      spikeHazardXmin(3) = 250
      spikeHazardXmax(3) = 290
      spikeHazardWidth(3) = 40

      badX(1) = 236


  END SELECT

  'set the bad guys range and make sure they're alive...

  IF badGuysThere = TRUE THEN
    FOR i% = 1 TO numOfBadGuys STEP 1
      badRangeMin(i%) = badX(i%) - 50
      badRangeMax(i%) = badX(i%) + 50
      badAlive(i%) = TRUE
      badHealth(i%) = 100
      badAbsorbed(i%) = FALSE
      badInRange(i%) = FALSE
      badGuyFiring = FALSE
    NEXT i%
  END IF
 
  eventsSet = TRUE

END SUB

FUNCTION sureQuit%
'asks if they want to quit from ingame.
'returns a false if they do (think want to still play? FALSE!)
'or true if they don't want to quit.

chosen = FALSE

LOCATE 10, 10
COLOR 15
PRINT "Are you sure you want to quit? [y/n]"

WHILE chosen = FALSE

  a$ = INKEY$

  IF a$ = "y" OR a$ = "Y" THEN
    sureQuit% = FALSE
    chosen = TRUE
  
  ELSEIF a$ = "n" OR a$ = "N" THEN
    sureQuit = TRUE
    chosen = TRUE
    redraw = TRUE
  
  END IF

WEND


END FUNCTION

SUB timingControl (speed%)
'regulates the game speed. The speed parameter recieves and argument
'that determines how fast the game runs.
'
'  1 = Fast (slow computer)
'  2 = Medium (average computer)
'  3 = Slow (fast computer)
'
SELECT CASE speed

  CASE 1:   'fast game .: slow computer
    gameSpeed = .65

  CASE 2:   'medium game .: medium computer
    gameSpeed = 1.1

  CASE 3:   'slow game .: fast computer
    gameSpeed = 1.5

END SELECT

FOR i! = 1 TO gameSpeed     'the closer the numbers, the quicker the prog
  t! = TIMER               't represents the timer
  WHILE t! = TIMER         'while this is true
    WAIT &H3DA, 8         'waits for an 8 bit (1byte) reply from time
'    WAIT &H3DA, 8, 8      'same but uses XOR to make sure
  WEND                    'wend=loop while true
NEXT i!                    'incriment the for loop

END SUB

SUB tips (areaNum)

LOCATE 9
PRINT "Tips for Area "; areaNum; ":"
PRINT ""
LOCATE 11

SELECT CASE areaNum

  CASE 300:         'tutorial 1
    PRINT "Arrow keys move, space bar is jump."
    PRINT "Hazards do damage to you if you step"
    PRINT "on them. Try to avoid any contact with"
    PRINT "them by jumping over them. Bottomless"
    PRINT "pits are an instant death! You can press"
    PRINT "F1 any time for area tips. Exit to the"
    PRINT "right of the screen to move to the"
    PRINT "next tutorial..."

  CASE 301:         'tutorial 2
    PRINT "Same controls apply in all ~gameplay~"
    PRINT "screens. This tutorial will challenge"
    PRINT "you in combat. When a bad guy starts"
    PRINT "running at you fire back at them with"
    PRINT "your pistol (~F~ key) to kill them!"
    PRINT "After they die you can absorb their "
    PRINT "health by pressing ~A~ over them."
    PRINT "Again, exit to the right to move on..."

  CASE 302:         'tutorial 3
    PRINT "This is the final tutorial screen. It's"
    PRINT "basically the ~sum of all fears~. Use"
    PRINT "the skills you learned in the first two"
    PRINT "to over come this combonation level."
    PRINT "Don't fret though, bad guys are just as"
    PRINT "hurt by hazards as you are. Maybe you"
    PRINT "could use this to your advantage???"
    PRINT "Exit the right of the screen to finish"
    PRINT "the tutorial! "

  CASE 1:
    PRINT "Arrow keys move, space bar is jump"
    PRINT "Press ~F~ to fire your pistol. Also"
    PRINT "pressing ~A~ near a dead enemy will"
    PRINT "absorb their health. This is screen 1"
    PRINT "of your epic adventure, Don't stop now!"
    PRINT "                  Good Luck! :)"

  CASE 2:        'second gameplay area
    PRINT "Ah, well you've made it this far. I'm"
    PRINT "sure you know the controls. There are"
    PRINT "two water pits. Hazards do damage to"
    PRINT "enemies too! Keep that in mind..."

  CASE 4:        'forever walking area next to cliff
    PRINT "Keep going! you're almost there! Just 2"
    PRINT "more screens and you cut out 1/2 the "
    PRINT "game! Ah, I'm just joshing ya. There's "
    PRINT "nothing over here. You're just wasting "
    PRINT "your time."

  CASE 5:        'bottom of cliff in river
    PRINT "Do you really have time to be asking for"
    PRINT "tips? Get out of the water before you "
    PRINT "drown to death moron!"

  CASE 6:        'bottom of cliff after river
    PRINT "Ah, nice and dry are we? Well this area"
    PRINT "is simple. Don't step on the spikes! "
    PRINT "They hurt a whole lot more than water! "
    PRINT "(and strangely lava too...)"

  CASE 8:        'forging the river.
    PRINT "I feel no need to give tips to morons."
    PRINT "You can't get across the river by "
    PRINT "walking. If you're lucky you'll be able"
    PRINT "to get back to shore... (to the left)"

  CASE 9:        'jumping the cliff
    PRINT "This is a do or die type of thing. You"
    PRINT "have to not only clear this side but "
    PRINT "also have enough momentum to get across"
    PRINT "the second half of the gap on the other"
    PRINT "side... Good luck!"

  CASE 10:        'other side of the cliff
    PRINT "I assume you've made it to the other"
    PRINT "side before you pressed this. If not, it"
    PRINT "IS possible. Keep trying. Oh and watch"
    PRINT "out for that bad guy... He's having a"
    PRINT "a bad day."

  CASE 12         'hot dog stand
    PRINT "Mmm!!! Hot dogs! They're good stuff. I"
    PRINT "bet you could go for one right now..."
    PRINT "right!?!. Well you have no choice. "
    PRINT "(Unless you want to go into the woods!)"

  CASE 13          'large Mr Face screen
    PRINT "Holy shit! IT'S BIG FOOT! Those hotdogs"
    PRINT "bloated you quite a bit. Make it into"
    PRINT "the woods before you step on a spike and"
    PRINT "pop!"

  CASE 14           'woods path
    PRINT "Welcome to the woods. I know it doesn't"
    PRINT "really look like one, but it is. If you"
    PRINT "were bloated you're not any more, if you"
    PRINT "don't know what I'm talking about don't"
    PRINT "worry about it. Just keep going!"

  CASE 15           'woods path continued
    PRINT "You're still in the woods. When jumping"
    PRINT "the pits make sure to land on the little"
    PRINT "piece of land inbetween or you won't "
    PRINT "make it!"

  CASE 17            'caves level 1
    PRINT "Ack! It's all hot and wet in here! Some"
    PRINT "might call it humid... I do not. These"
    PRINT "caves look pretty perilous, I'd watch"
    PRINT "your step. (unless you want to lose your"
    PRINT "foot)."
   
  CASE 18            'caves 2
    PRINT "Is it getting warming in here or is it"
    PRINT "just me? ;) Anyway, watch your jumping"
    PRINT "with these lava pits. (The last one's a"
    PRINT "doosey!) And yes, it is possible not to"
    PRINT "get burned!"

  CASE 19            'the king the king!
    IF hasCrown = FALSE THEN
      PRINT "Hey! What's that over on that ledge"
      PRINT "over there? Maybe you should check it"
      PRINT "out? I'd be careful though, that pit"
      PRINT "looks mighty wide..."
    ELSEIF hasCrown = TRUE THEN
      PRINT "Well Hello new self-proclaimed king that"
      PRINT "most likely has no real power! You're"
      PRINT "stronger now and your health is up. This"
      PRINT "is good b/c it's a pain in the ass to "
      PRINT "get out of here going backwards! Good"
      PRINT "luck!"
    END IF


  CASE 20              'swamps level 1
    PRINT "Welcome to the swamps, where the surface"
    PRINT "area of water outweighs that of dry land"
    PRINT "This area should be no trouble though."
    PRINT "Just keep you toes dry!"

  CASE 21             'swamps level 2
    PRINT "Bet ya didn't expect this area to go"
    PRINT "more than one screen did you? (Due to"
    PRINT "it's very unoriginal look.) Same goes"
    PRINT "for here as it did in the last area..."

  CASE 22             'swamps/forest exit
    PRINT "Hey! You've reached the end of the woods"
    PRINT "or swamps or whatever. It seems to end"
    PRINT "abruptly at the river side. I wonder"
    PRINT "what you should do??? (so much for tips"
    PRINT "eh?)"

  CASE 24              'flowing down the river
    PRINT "Well, you should have known rivers flow"
    PRINT "somewhere. This one flows down a water"
    PRINT "fall! Oh no! Well there's not really "
    PRINT "anything you can do... you're pretty"
    PRINT "much dead. Sorry..."

  CASE 25              'fighting upstream
    PRINT "Oh these rivers... pain in the ass"
    PRINT "aren't they? Well just keep jumping and"
    PRINT "and you'll make it to the otherside "
    PRINT "without MUCH injury..."

  CASE 26
    PRINT "Brrr! It's getting cold! I bet you"
    PRINT "didn't see this one coming! (Unless you"
    PRINT "found the hint...) Keep on trucking and"
    PRINT "looking for some shelter from the storm"
    PRINT "And by the by, dead bad guys freeze as"
    PRINT "statues after they're killed here."

  CASE 27          'snow level 2
    PRINT "Ah! It's getting colder by the screen!"
    PRINT "You better find some sort of shelter"
    PRINT "quick! I'm not sure how much more of"
    PRINT "this you can take before you die!"

  CASE 29        'outside. (chose no shelter)
    PRINT "Well, that was dumb. You chose to not"
    PRINT "go in the warm house and now you're "
    PRINT "stuck out in the cold. It won't be "
    PRINT "long before you freeze to death..."

  CASE 30        'spiked area before bridge
    PRINT "What a nice family eh? Well time to"
    PRINT "get booking. This area shouldn't be"
    PRINT "more than review for you. Becareful of"
    PRINT "the second spike pit though, it's wide"

  CASE 31        'begining of bridge (1/4)
    PRINT "What's the strange thin brown line up"
    PRINT "ahead? What? ...are you serious? Ok,"
    PRINT "so apparently that stupid ass looking"
    PRINT "line is this game's idea of a BRIDGE."
    PRINT "...It doesn't look so sturdy if you"
    PRINT "ask me..."

  CASE 32       'first half of bridge (1/2)
    PRINT "Well, who was right? Yep, ME! The"
    PRINT "bridge is filled with holes! No I"
    PRINT "don't know how it's being supported."
    PRINT "Did you ask Mario how the bridge parts"
    PRINT "were supported in World 2-3??? NO! So"
    PRINT "shut up and don't fall!"

  CASE 33       'middle of bridge (3/4)
    PRINT "Lalalala... huh? what? Oh... This?"
    PRINT "Do you really need help? It's the same"
    PRINT "level layout as the one before. Hole"
    PRINT "filled bridge w/ badguys. Enjoy."

  CASE 34      'end of bridge
    PRINT "Finally the end of that physics defying"
    PRINT "nightmare! Nothing really to say about"
    PRINT "this area, it's a mirror of the bridge"
    PRINT "entrance with a few more spike pits."


END SELECT

DO
LOOP WHILE INKEY$ = ""

redraw = TRUE

END SUB

SUB tutorialComplete

SCREEN 12
CLS

COLOR 10
PRINT "                         Tutorial Complete!"
PRINT "                       "
COLOR 7
PRINT "  Congratulations! You've managed to beat probably the hardest tutorial in"
PRINT "any game! EVER! (Or easiest depending on if you figured out the ~trick~ yet)"
PRINT "You should stop for a second right now and give yourself a nice big pat on the"
PRINT "back. "
PRINT
PRINT "    ...go on! You deserve it!"
PRINT
PRINT "  Ok, enough of me being a complete jackass. Now that you've complete the"
PRINT "tutorial I have faith in you that you can tackle the obsticles (or lack"
PRINT "there of) in the game. So magically the 3 screens out of the way you went"
PRINT "some how looped back (How? It actually made a ~C~ shape and ended directly"
PRINT "where path 2 started). "
PRINT
PRINT "      Feeling empowered (or disempowered) you leave off on your journey!"
PRINT "                             GOOD LUCK!"
PRINT
PRINT
COLOR 8
PRINT "                            (Btw your health has been restored.)"
COLOR 4
PRINT "                   ...Press space bar to continue..."
DO: LOOP WHILE INKEY$ <> " "

SCREEN 13
CLS

END SUB

SUB wtfJustHappened
SCREEN 12
CLS

COLOR 10
PRINT "                         Hot Dog Deja Vu!"
PRINT "                       "
COLOR 7
PRINT "  Surprise, surpise. You bit off more than you could chew. Well, not exactly."
PRINT "You chewed it quite well it's the ~keeping it down~ that's the problem. After"
PRINT "eating a hot dog stand worth of hot dogs there's undoubtably going to be some"
PRINT "expansion south of the thyroid. (We're talking stomachville!)"
PRINT
PRINT "  So congratulations, for being a pig! You now weigh 5,000lbs and suffer from"
PRINT "heart disease! (Yet again, feel free to pat yourself on the back at any time)."
PRINT "Well you're going to have to lose this weight but it appears the only path to"
PRINT "do so is ridden with spikes."
PRINT
PRINT "        ...and we all know inflated things pop on sharp objects."
PRINT
PRINT
COLOR 8
PRINT "       (I'm going to leave you wonding ~wtf~ until the next screen.)"
COLOR 4
PRINT "                   ...Press space bar to continue..."
DO: LOOP WHILE INKEY$ <> " "

SCREEN 13
CLS

END SUB

