/******************************************************************************/
(include "sci.sh")(include "game.sh")                                 (script 1)
/******************************************************************************/
(use "main")(use "controls")(use "cycle")(use "game")
(use "feature")(use "obj")(use "inv")
/******************************************************************************/
(local
      // gpowerDrain        // used to track fish energy, global
      // gcurrentHealth     // Current health, global
      moveHealthdrain = 1   // drain health each cycle of movement
      hitHealthdrain = 5    // drain health upon impact (light, heat)
      drainRation = 50      // how many drains  equals one health
      buBblecount = 0       // used to time fish's bubbles
      dieing= FALSE
      Dead_yet = FALSE
      alterView = FALSE

      
      myEvent                // used to track mouse cursor position
      ranCount = 65          // length till lilFish goes onPatrol

      lengthFirstday = 150
      addPerday = 50 
      lengthCurrentday = 150 // it gets reset alot later
      currentTime = 0    
      nextDay           
      
      correctedy        // replaces y values outside controllable area, prevents constant drain
      correctedx        // replaces x values outside controllable area, prevents constant drain
      shaded            // is the fish under a plant
      luredIn = FALSE   // gonna eat the worm
      welllit = FALSE   // are the lights on
      heated = FALSE    // is the heat on
      burnt = FALSE
      heaterCount = 0
      onPatrol = FALSE  // lilfish out and about
      eaTen = FALSE     // lilfish has eaten us
      eatenCount        // used to delay before death handler
            
      aBobber           // instance name
      castleDoor        // instance name
      lilFish           // instance name
)
/******************************************************************************/
(instance public rm001 of Rm
(properties picture scriptNumber style 4)
  (method (init)
  (super:init())
  (self:setScript(RoomScript))

  (send (Prop:new()):view(30)loop(1)posn(70 151)setPri(0)cel(2)setCycle(Fwd)cycleSpeed(2)ignoreActors()init()) // weed
  (send (Prop:new()):view(30)loop(1)posn(65 153)setPri(15)cel(0)setCycle(Fwd)cycleSpeed(2)ignoreActors()init())// weed
  (send (Prop:new()):view(30)posn(195 156)setPri(15)setCycle(Fwd)cycleSpeed(2)ignoreActors()init()) // weed
  (send (Prop:new()):view(12)loop(0)posn(30 136)setPri(0)setCycle(Fwd)cycleSpeed(3)ignoreActors()init())// left corner bubbles
  
  (heater:init()setScript(heaterScript)cycleSpeed(2)setCycle(Fwd)ignoreActors())// heater
  (thing:init()setScript(thingScript)setCycle(Fwd))// fish
  (healthbar:init()setScript(healthScript))// health
  (buBbles:init()setScript(buBbleScript)ignoreActors())// fish bubbles
  (lights:init()hide()setCycle(Fwd)cycleSpeed(2)setScript(lightemup)ignoreActors())// lights above tank
  
  = aBobber (Act:new())
  (send aBobber:view(31)posn(98 140)setPri(12)ignoreActors()setScript(passingBy)moveSpeed(2)init())
      
  = castleDoor (Prop:new())
    (send castleDoor:view(32)loop(3)setPri(0)posn(261 150)ignoreActors()init()) // castle door
    
  = lilFish (Act:new())
      (send lilFish:setCycle(Fwd)view(32)loop(1)setPri(13)posn(260 137)ignoreActors()setScript(lilBiter)init()hide()) // lil fish
      
   Print(1 12)
   Print(1 13)
   Print(1 14)


 )// end method
)// end instance
/******************************************************************************/
(instance healthbar of Prop(properties x 160 y 180 view 020 cel 10))
(instance thing of Act(properties x 150 y 130 view 000))
(instance buBbles of Prop(properties x 150 y 130 view 010 loop 0))
(instance lights of Prop(properties x 160 y 46 view 033 loop 0))
(instance heater of Prop(properties x 38 y 134 view 33 loop 1))

 
(instance buBbleScript of Script
    (properties
      client 0
      state -1
      start 0
      timer 0
      cycles 0
      seconds 0
      lastSeconds 0
      register 0
      script 0
      caller 0
      next 0
    )

    (method (doit)
    // because all i need to do is stick it in one of them
    // this doit method will do
    
    
    ++currentTime
    (if(>= currentTime lengthCurrentday)
    	= nextDay (+gwhichDay 1)
    	FormatPrint(1 3 gwhichDay)
    	++gwhichDay
    	FormatPrint(1 2 nextDay)
    	(send gGame:changeScore(1))
         = currentTime 0


  // Making the game get harder
   = moveHealthdrain (+ moveHealthdrain gwhichDay)
   = hitHealthdrain  (+ hitHealthdrain gwhichDay)
  // and longer
   = lengthCurrentday (+ lengthFirstday (* addPerday gwhichDay))
  	    		  
	)	
    	
    	
     (buBbles:posn((thing:x) (thing:y))loop(thing:loop))
        (super:doit())

     ++buBblecount
     (if(>= buBblecount  (/ drainRation 2))
       (buBbles:cel(0)setCycle(End)cycleSpeed(1))
       = buBblecount (- buBblecount drainRation)
     )
        
        
    )
)


//***************************************************************
(instance RoomScript of Script
(properties)

  (method (doit)
  (super:doit())
  )// end method

  (method (changeState newState)
  = state newState
    (switch (state)
      (case 0 = cycles 10)
      (case 1 (send gTheMusic:prevSignal(0)stop()number(000)loop(1)play()))
    )
  )
  
  (method (handleEvent pEvent)
  (super:handleEvent(pEvent))
    (if(send pEvent:type(evKEYBOARD))
      (if(== (send pEvent:message) KEY_TAB)Print(1 15))
      (else
          (if(== (send pEvent:message) KEY_ESC)  // Quit shortcut
               (send pEvent:claimed(TRUE))
               (if(Print(1 16  #title "Options"  #font gDefaultFont #button " Quit " 1 #button " Continue " 0)) Print(1 0) = gQuitGame TRUE)
          )
          (else
          (if(== (send pEvent:message) KEY_SPACE)
               Print(1 17)
          )
          (else
          (if((== (send pEvent:message) KEY_ADD) or (== (send pEvent:message) KEY_SUBTRACT))
               Print(1 18)
          )
           (else
          (if(== (send pEvent:message) KEY_HELP)
               Print(1 19)
               Print(1 20)
          )

            (else
          (if(== (send pEvent:message) KEY_BACK)
              (if (== alterView TRUE)
                = alterView FALSE
              )
              (else
               = alterView TRUE
              )

          )
       )
       )
       )
       )
      )
    ) // end if keyboard



  )// end method
  
)// end instance
//***************************************************************
(instance lilBiter of Script
(properties)
   (method (changeState newState)
  = state newState
    (switch (state)
      (case 0 = cycles ranCount)
      (case 1 = onPatrol TRUE
      	      (send castleDoor:cel(1))
   	         // (send aBobber:setCycle(Walk)setMotion(MoveTo 282 140 passingBy)))
   	          (send lilFish:show()setMotion(MoveTo 230 137 lilBiter ))
   	  )
      (case 2 (if(==eaTen FALSE)
      		  = seconds 4)
	  )
      (case 3 (if(==eaTen FALSE)
      		    (send lilFish:setMotion(MoveTo 265 137 lilBiter )))
	  )
      (case 4 (if(==eaTen FALSE)
      		   = onPatrol FALSE
               (send lilFish:hide())
               (send castleDoor:cel(0))
               = ranCount Random(65 120)
               (self:changeState(0)))
	  )
    ) // switch end
  ) // method end 
  
)// end instance
//**************************************************************

(instance thingScript of Script
   (properties)
   (method (doit)
      (var dyingScript)
      (super:doit())
      (= myEvent Event:new(evNULL))

  // check and correct y values if outside moveable area, prevents
  // drain if caught on control color, by replacing y to inside area
      (if(>= (send myEvent:y) 161) = correctedy 160)
      (else
        (if(<= (send myEvent:y) 70) = correctedy 71)
        (else = correctedy (send myEvent:y))
      )
//**************************************************************
      

  // check and correct x values if outside moveable area, prevents
  // drain if caught on control color, by replacing y to inside area
  // +35 for fish offset, hot spot is the middle bottom.
  
      (if(>= (send myEvent:x) 283) = correctedx 282)
      (else
        (if(<= (send myEvent:x) 38) = correctedx 39)
        (else = correctedx (send myEvent:x))
      )
//**************************************************************
// Is our fish getting burnt

       (if(== heated TRUE)
          (if(< (thing:x) 73)
             // lose health and shake screen
             = burnt TRUE
             = gpowerDrain (+ gpowerDrain hitHealthdrain )
          )
          (else = burnt FALSE)
       )
       (else = burnt FALSE)

//**************************************************************
// Handling getting too close to the little fish
    (if(== luredIn FALSE)
      (if(== eaTen FALSE)
        (if(== onPatrol TRUE)
          (if(< (thing:distanceTo(lilFish)) 30)
          (thing:setMotion(MoveTo (thing:x) (send lilFish:y)))	
          (send lilFish:loop(2)cel(0)setCycle(End))
          = eaTen TRUE
          = eatenCount 0
          )
        )
       )
       (else
         (if(== eatenCount 10)
         (send lilFish:loop(1)cel(0)setCycle(Fwd))
         (thing:hide())
               = dieing TRUE
               = Dead_yet TRUE
               = dyingScript ScriptID(DYING_SCRIPT)
                (send dyingScript:caller(977)register(6))
                (send gGame:setScript(dyingScript))
          )
           (else
            ++eatenCount)
        )
	   )
//**************************************************************
 
      // Are they as close to the cursor as the room allows.
      // Yes, Fish should Stand still and get energy back 

      (if((== correctedx (thing:x))  and  (== correctedy (thing:y)))
         // depending on tank location and conditions
        (if(== luredIn FALSE)
          (if(== shaded TRUE) // under plant

            (if(== alterView TRUE)
            (send client:view(99))
            )
            (else
            (send client:view(003))
            )

            = gpowerDrain --gpowerDrain
          )
          (else
            (if(== welllit TRUE) // lamps on
            (if(== alterView  TRUE)
            (send client:view(99))
            )
            (else
               (send client:view(005))
             )
               = gpowerDrain (+ gpowerDrain hitHealthdrain )

            )
            (else
                           (if(== alterView  TRUE)
            (send client:view(99))
            )
            (else
            (send client:view(001))
            )
               = gpowerDrain --gpowerDrain
            )
         )
		)
      )
      (else
      (if(== dieing FALSE)
      (if(== luredIn FALSE)
        (if(== eaTen FALSE)
      // No, Fish is in motion and energy drains
         (if(== shaded TRUE)
            (if(== alterView  TRUE)
            (send client:view(99)setMotion(MoveTo correctedx correctedy))
            )
            (else
            (send client:view(002)setMotion(MoveTo correctedx correctedy))
            )
             = gpowerDrain ++gpowerDrain
         )
          (else
          (if(== welllit TRUE)// lamps on
                         (if(== alterView  TRUE)
            (send client:view(99)setMotion(MoveTo correctedx correctedy))
            )
            (else
            (send client:view(004)setMotion(MoveTo correctedx correctedy))
            )
             = gpowerDrain (+ gpowerDrain hitHealthdrain )
          )
          (else
                         (if(== alterView  TRUE)
            (send client:view(99)setMotion(MoveTo correctedx correctedy))
            )
            (else
            (send client:view(000)setMotion(MoveTo correctedx correctedy))
            )
             = gpowerDrain ++gpowerDrain
          )
          )
		)
	    (else (thing:setMotion(MoveTo (thing:x) (send lilFish:y))) )// is eaten
      )
      )
	  )	

// cursor facing right or left
      (if(>(send myEvent:x) (thing:x))
      (send gGame:setCursor(998 SET_CURSOR_VISIBLE))
      )
      (else
         (if(<(send myEvent:x) (thing:x))
         (send gGame:setCursor(999 SET_CURSOR_VISIBLE))
         )
      )
//**************************************************************
// Is the fish under a plant
      (if((((>= (thing:x) 170) and (<= (thing:x) 240)) and ((>= (thing:y) 125) and (<= (thing:y) 190)))
       or(((>= (thing:x) 60) and (<= (thing:x) 70))and(>= (thing:y) 125)))
       = shaded TRUE)
       
      (else  = shaded FALSE )
//**************************************************************
      (send myEvent:dispose())
   )
)
//**************************************************************
 (instance heaterScript of Script
   (properties)
   (method (changeState newState)
     = state newState
     (switch (state)
       (case 0 = seconds Random(4 10))
       (case 1 = heated TRUE = seconds Random(3 9) (heater:loop(2)))
       (case 2 = heated FALSE = seconds Random(8 16) (heater:loop(1)))
       (case 3 (self:changeState(0)) = cycles 1)
     )
   )// end method
 )
//**************************************************************
 (instance lightemup of Script
   (properties)
   (method (changeState newState)
     = state newState
     (switch (state)
       (case 0 = seconds Random(8 16))
       (case 1 = welllit TRUE = seconds Random(3 9) (lights:show()))
       (case 2 = welllit FALSE = seconds Random(8 16) (lights:hide()))
       (case 3 (self:changeState(0)) = cycles 1)
     )
   )// end method
 )
//**************************************************************
   
   

(instance healthScript of Script
   (properties)
   (method (doit)(var dyingScript)
   (super:doit())

(if(== dieing FALSE)
(if(== Dead_yet FALSE)
    (if(>= gpowerDrain  drainRation)
     = gcurrentHealth (- gcurrentHealth 1)
       (if  (
             ((== welllit TRUE) and (== shaded FALSE))
            or
             (== burnt TRUE)
            )
       		
		   	
       ShakeScreen(1))
     = gpowerDrain (- gpowerDrain drainRation)
     (healthbar:cel(gcurrentHealth))
     )


     (if(< gpowerDrain  0)
       (if(>= gcurrentHealth 10)
          = gcurrentHealth 10
          = gpowerDrain 0
       )
       (else
          = gcurrentHealth (+ gcurrentHealth 1)
          = gpowerDrain (+ gpowerDrain drainRation)
          (healthbar:cel(gcurrentHealth))
       )
     )
     
     (if(<= gcurrentHealth 0)
        (healthbar:cel(gcurrentHealth))
        = dieing TRUE
        = Dead_yet TRUE
        = dyingScript ScriptID(DYING_SCRIPT)
               (if((== shaded TRUE) or (== welllit FALSE)) // we didn't die in the light
               	 (if((== heated TRUE) and (< (thing:x) 87) )//  got burnt
                 (send dyingScript:caller(977)register(11))	
				 )
				 (else	
                 (send dyingScript:caller(977)register(7)) // must be out of juice
				 )
               )
               (else
                (send dyingScript:caller(977)register(8)) // out in the light
               )

       (send gGame:setScript(dyingScript))
     )
   )
)
  )// end method
)// end instance
/**************************************************************************/
(instance passingBy of Script
(properties)
   (method (doit)(var dyingScript)
   (super:doit())
      (if(
      	  (>= (thing:y) 122)
          and
          (< (send aBobber:distanceTo(thing)) 35)
         )
         = luredIn TRUE
         (send aBobber:setMotion(NULL))
         (if(> (send aBobber:x) (thing:x))
         	(if(< (send aBobber:distanceTo(thing)) 16)
         	   (if(== dieing FALSE)
         	   = dieing TRUE
               = Dead_yet TRUE
               = dyingScript ScriptID(DYING_SCRIPT)
                (send dyingScript:
                 caller(977)
                 register(9)
                )
                (send gGame:setScript(dyingScript))
			   )	
			)
			(else
			(thing:loop(0)setMotion(MoveTo (-(send aBobber:x)15) (send aBobber:y) ))
		    )
		  )   
		 (else
         	(if(< (send aBobber:distanceTo(thing)) 16)
         	   (if(== dieing FALSE)
         	   = dieing TRUE	
               = Dead_yet TRUE
               = dyingScript ScriptID(DYING_SCRIPT)

                (send dyingScript:
                 caller(977)
                 register(10)
                )
                (send gGame:setScript(dyingScript))
         	   
			   )	
			)
			(else
			(thing:loop(1)setMotion(MoveTo (+(send aBobber:x)15) (send aBobber:y) ))
		    )
		 )
										  
	  )
   )
  (method (changeState newState)
  = state newState
    (switch (state)
      (case 0 (send aBobber:setCycle(Walk)setMotion(MoveTo Random(50 100) 140 passingBy)))
      (case 1 (send aBobber:setCycle(Walk)setMotion(MoveTo Random(196 225) 140 passingBy)))
      (case 2 (send aBobber:setCycle(Walk)setMotion(MoveTo Random(100 195) 140 passingBy)))
      (case 3 (send aBobber:setCycle(Walk)setMotion(MoveTo Random(196 225) 140 passingBy)))
      (case 4 (self:changeState(0)))
    ) // switch end
  ) // method end
 ) // instance end

