/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl() 
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())
		
		(super:init())
		(self:setScript(RoomScript))
		
		(send gEgo:
			init()
			hide()
		)	
		Display(
			"SCI Capture\n\n     the Flag"
			dsCOORD 110 50
			dsCOLOUR clBLUE
			dsBACKGROUND clTRANSPARENT
		)
        Display(
			"Reading Instructions highly\nsuggested before playing."
			dsCOORD 15 105
			dsCOLOUR clMAROON
			dsBACKGROUND clTRANSPARENT
		)
        Display(
			"< 2007 Profile Games"
			dsCOORD 40 160
			dsCOLOUR 1
			dsBACKGROUND clTRANSPARENT
		)
        (medium:init())
        (hard:init()loop(1))
        (instructions:init()loop(2))
	)
)
/******************************************************************************/
(instance RoomScript of Script
    (properties)
    (method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if (== (send pEvent:type()) evMOUSEBUTTON)
            (if( (> (send pEvent:x) (medium:nsLeft))and
                    (< (send pEvent:x) (medium:nsRight))and
                    (> (send pEvent:y) (medium:nsTop))and
                    (< (send pEvent:y) (medium:nsBottom))
                    )
                (send gRoom:newRoom(INITROOMS_SCRIPT))
            )(else
                (if((> (send pEvent:x) (hard:nsLeft))and
                        (< (send pEvent:x) (hard:nsRight))and
                        (> (send pEvent:y) (hard:nsTop))and
                        (< (send pEvent:y) (hard:nsBottom))
                        )
                        = gHard 1
                        (send gRoom:newRoom(INITROOMS_SCRIPT))
                )(else
                    (if((> (send pEvent:x) (instructions:nsLeft))and
                            (< (send pEvent:x) (instructions:nsRight))and
                            (> (send pEvent:y) (instructions:nsTop))and
                            (< (send pEvent:y) (instructions:nsBottom))
                            )
                            (Instructions)
                     )//end if
                )//end else
		    )//end else
		)//end MouseEvent
	)// end method
)//end instance
(instance medium of Prop
    (properties y 40 x 50 view 101)
)
(instance hard of Prop
    (properties y 70 x 50 view 101)
)
(instance instructions of Prop
    (properties y 100 x 53 view 101)
)
/******************************************************************************/
