/******************************************************************************/
/*         March SCI Community AI Compitition Game by Ryan Slattery           */
/******************************************************************************/
(include "sci.sh")(include "game.sh")
(script 1)
/******************************************************************************/
(use "main")(use "controls")(use "cycle")(use "game")(use "feature")
(use "obj")(use "inv")(use "jump")(use "dpath")

(local
/************* COMPUTER GAME/BOARD VARIABLES ***************/
rCompHp = 7     // Opponent's Character's Health
rCompLp = 10    // Opponent's Overall Life
rCompPower = 0  // gPlayerPower is in the main script to be accessed by Menubar.sc

/************** PLAYER GAME/BOARD VARIABLES ****************/
rPlayerHp = 7   // Player's Character's Health
rPlayerLp = 10  // Player's Overall Life

/******************** TOTEM VARIABLES **********************/
noOneTotem = 1  // No one has moved the Totem Yet
yourTotem = 0   // The Totem is on Player's Side
dondeTotem      // A Variable to Randomize the Destination of the Totem

quad1 = 0  /********************************************  | **********/
quad2 = 0  /* Represents the Mathematical               2 | 1        */
           /*   Quadrant of the Totem                 ----+---- x    */
quad3 = 0  /* As Seen on the Game Field                 3 | 4        */
quad4 = 0  /********************************************  |y *********/

/********************* FLAG VARIABLES **********************/
playerHasFlag = 0   // Pretty Obvious
compHasFlag = 0     // ^ Yup, Obvious

/***************** SCREEN AND TEXT VARIABLES ***************/
screenFlash = 0 // Allows the Screen to Flash before being Darkened
mountainDew     // Randomizing variable Screen Easter Egg

writingStay = 0 // Allows Text at Bottom of Screen to Remain From State Case 1 - 4
htext = 0       // Text Variable used to Display and Remove Text Related to the Actions of the Opponent

playerFlagWin = 0
playerDead = 0
compDead = 0

/*********************************************************************************/
/* NOTE on Variables: Some coders set variables with "TRUE" and "FALSE"          */
/*                    I tend to use "1" and "0" for the same values respectively */
/*********************************************************************************/
)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		north 0 east 0 south 0 west 0
	)
	(method (init)
  		(super:init())
  		(self:setScript(RoomScript))
  		(switch(gPreviousRoomNumber)
  			(default(send gEgo:posn(267 115)loop(1)))
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init())
        /*      INITS FOR THE SCORE:INFO BOARD        */
        (screen:init())
        (compScreen:init()ignoreActors()setPri(1))
        (playerScreen:init()ignoreActors()setPri(1))
        
        (compLifeBar:init()cel(rCompLp))
        (compHpBar:init()cel(rCompHp))
        (complp:init()cel(rCompLp))
        (comphp:init()cel(rCompHp))
        (compPower:init()cel(rCompPower))
        
        (playerLifeBar:init()cel(rPlayerLp))
        (playerHpBar:init()cel(rPlayerHp))
        (playerlp:init()cel(rPlayerLp))
        (playerhp:init()cel(rPlayerHp))
        (playerPower:init()cel(gPlayerPower))
        
        /*        INITS FOR THE PLAYING FIELD          */
        (opponent:init()ignoreActors)
        (totem:init()setScript(totemScript)ignoreActors()) // Includes setScript(totemScript) written @ 555
        (compFlag:init()ignoreActors())
        (playerFlag:init()ignoreActors())
        (compHealer:init()ignoreActors()setCycle(Fwd)cycleSpeed(2))
        (playerHealer:init()ignoreActors()setCycle(Fwd)cycleSpeed(2))


  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState game)
        (var button)
        =state game
        (switch(state)
            (case 0 = seconds 1
            )(case 1 = cycles 25
                = mountainDew Random (1 500)
                (if(>= mountainDew 450)     // Easter egg to "go off" 10% of the time.
                    (screen:loop(3)cel(0)setCycle(End)cycleSpeed(1))
                )
            )(case 2 = cycles 25
                (if(>= mountainDew 450)
                    (screen:loop(4)cel(0)setCycle(Fwd)cycleSpeed(1))
                )
                (addPower)  // See Procedures - gives each player power for abilities
            )(case 3 = cycles 25
                (if(not(screenFlash))   // Allows full RoomScript State Cycle...
                    = screenFlash 1     // ...Before setting the Main Screen to Black
                )(else
                    (screen:loop(0)cel(0))  // Set Main Screen to Black
                )
                (if(not(screenFlash))   // Allows full RoomScript State Cycle...
                    = screenFlash 1     // ...Before allowing the erase Display Text
                )(else
                    Display(                /**************************/
                    ""                      /*  Removes any Text that */
                    dsRESTOREPIXELS htext   /*   Existed Previously   */
                    )                       /**************************/
                )
                (addPower)
            )(case 4
                (RoomScript:changeState(1))
            )(case 6 = cycles 50 // 50 cycles until Player plays again
                (send gEgo:hide())
                (ProgramControl)
            )(case 7
                (send gEgo:show()posn(267 115)loop(1))
                = rPlayerHp 7
                = playerDead 0
                (PlayerControl)
                (RoomScript:changeState(1))
            )(case 8 = cycles 50 // 50 cycles until comp can play again
                (opponent:hide()posn(53 115)xStep(0)yStep(0))
            )(case 9
                (opponent:show()posn(53 115)xStep(1)yStep(1))
                = rCompHp 7
                = compDead 0
                (RoomScript:changeState(1))
            )(case 10 = seconds 2   // Game has been won
                (ProgramControl)
            )(case 11
                (if(playerFlagWin)
                    = button Print("You have successfully captured the opponent's flag! Congratulations"
                        #title "You Win!"
                        #button "Play" 0 #button "Quit" 1)
                    (if(== button 1)
                        = gQuitGame TRUE
                    )(else
                        (send gGame:restart())
                    )
                )(else
                    = button Print("You have successfully depleted the opponent's life and won the Game! Congratulations"
                        #title "You Win!"
                        #button "Play" 0 #button "Quit" 1)
                    (if(== button 1)
                        = gQuitGame TRUE
                    )(else
                        (send gGame:restart())
                    )
                )
            )(case 12 = seconds 2   // Game has been lost
                (ProgramControl)
            )(case 13
                = button Print("You put up a valient fight, but he's got the best of you. Try again?"
                    #title "You Lose"
                    #button "Play" 0 #button "Quit" 1)
                (if(== button 1)
                    = gQuitGame TRUE
                )(else
                     (send gGame:restart())
                )
            )
        )
    )

    (method (handleEvent pEvent)
        (var str)  // Local variable
        (super:handleEvent(pEvent))
        (switch( (send pEvent:type) )
            (case evKEYBOARD
                (if(== (send pEvent:message) KEY_S )  // Check if S was pressed
                    (playerAbility) // Procedure defined @ 475
                    (send pEvent:claimed(TRUE))
                )
            )
        )
        (if(Said('use,cast/magic,power,spell'))
            (playerAbility)
        )
        (if(Said('help'))
            (Instructions) // Procedure defined in Main.sc b/c accessed by Titlescreen.sc and MenuBar.sc
        )
        
    )
    /*********************************************************************/
    /*                         DOIT METHOD                               */
    /*********************************************************************/
    (method (doit)
        (super:doit)
        
    /**************************************************************************************************/
    /**************************** COMPUTER AI ************************* What this month's compitition */
    /******************************************************************       is really all about     */
                                                                       /*******************************/
        /*              Opponent's Motion Priorities              */
        (if(noOneTotem)
            (opponent:setCycle(Walk)setMotion(MoveTo (totem:x) (totem:y) )) // Chase the totem
        )
        (if(== (send gEgo:onControl()) ctlGREY) // Player on opponent's side of the field
            (if(not(yourTotem))
                (opponent:setCycle(Walk)setMotion(MoveTo (totem:x) (totem:y) )) // Chase the totem
            )(else
                (opponent:setCycle(Walk)setMotion(MoveTo (playerFlag:x) (playerFlag:y) )) // go for the flag
            )
        )
        (if(compHasFlag)
            (if(not(playerHasFlag))
                (opponent:setCycle(Walk)setMotion(MoveTo (compFlag:x) (compFlag:y) )) // Return to home flag
            )(else
                (if(not(yourTotem))
                    (opponent:setCycle(Walk)setMotion(MoveTo (totem:x) (totem:y) )) // Chase the totem
                )(else
                    (if(< rCompHp 5)
                        (opponent:setCycle(Walk)setMotion(MoveTo (compHealer:x) (compHealer:y) )) // restore health
                    )(else
                        (opponent:setCycle(Walk)setMotion(MoveTo 110 106)) // Stationary Posn
                    )
                )
            )
        )
        (if(not(yourTotem))
            (if(< rCompHp 5)
                (opponent:setCycle(Walk)setMotion(MoveTo (compHealer:x) (compHealer:y) )) // restore health
            )(else
                (opponent:setCycle(Walk)setMotion(MoveTo (totem:x) (totem:y) )) // Chase the totem
            )
        )(else
            (if(not(compHasFlag))
                (if(< rCompHp 5)
                    (if((gHard) or (gImpossible)) // gImpossible is a variable for a difficulty not included in the actual game
                        (if(< (+ (- (playerFlag:x) (opponent:x)) 20) (- (opponent:x) (compHealer:x)) )
                        // ^the above equation looks like this algebraically: if ((a - b) +20) < (b - c)...
                        // ...it basically measures the horizontal distance between the character and 2 objects.
                            (opponent:setCycle(Walk)setMotion(MoveTo (playerFlag:x) (playerFlag:y) )) // go for the flag
                        )(else
                            (if(< (+ (- (totem:x) (opponent:x)) 6) (- (opponent:x) (compHealer:x)) )
                                (opponent:setCycle(Walk)setMotion(MoveTo (totem:x) (totem:y) )) // Chase the totem
                            )(else
                                (opponent:setCycle(Walk)setMotion(MoveTo (compHealer:x) (compHealer:y) )) // restore health
                            )
                        )
                    )(else
                        (opponent:setCycle(Walk)setMotion(MoveTo (compHealer:x) (compHealer:y) )) // restore health
                    )
                )(else
                    (if(not(== (send gEgo:onControl()) ctlGREY)) // Player not on opponent's side
                        (opponent:setCycle(Walk)setMotion(MoveTo 110 106)) // Stationary Posn
                    )
                )
            )
        )
        /*                Opponent's Power Priorities                 */
        (if(== rCompPower 4)
            (if(== rPlayerLp 1)
                (compZap)   // This will win the game by life points
            )(else
                (if(< rPlayerHp 4)
                    (compBolt)  // This will kill the Player's Health
                )(else
                    (if(== (send gEgo:onControl()) ctlGREY)
                        (if ((<= rPlayerHp 5) or (playerHasFlag))
                            (compBlast) // This will either kill Player or damage him while carrying the flag
                        )
                    )
                )
            )
        )
        (if(== rCompPower 4)
            (if(== (send gEgo:onControl()) ctlMAROON) // If player is close to middle and totem on Player's side...
                (compZap)                             // ...deal 1 damage to player's life bar.
            )
        )
        (if(== rCompPower 4)
            (if(== (send gEgo:onControl()) ctlSILVER) // If player is near Player's own health rejuvenator...
                (if(> rPlayerLp 4)
                    (compBolt)                        // ...deal 3 damage to player character's health
                )(else
                    (compZap)   // If Player's life is less than 4, opponent will focus on that instead of Hp
                )
            )
        )
    /******************* NON-COMPUTER AI DOIT METHOD **************************/
    
        /*               CAPTURING THE FLAG                    */
        (if(< (send gEgo:distanceTo(compFlag)) 10)
            (if(not(playerHasFlag))
                (compFlag:hide())
                = playerHasFlag 1   // Player takes flag
                (screen:loop(1)cel(0)setCycle(Fwd)cycleSpeed(1))    // Red Flag Taken
                (compScreen:loop(1)setCycle(Fwd)cycleSpeed(1))      // Warning Signal
            )
        )
        (if(< (opponent:distanceTo(playerFlag)) 10)
            (if(not(compHasFlag))
                (playerFlag:hide())
                = compHasFlag 1     // Computer takes flag
                (screen:loop(2)cel(0)setCycle(Fwd)cycleSpeed(1))    // Blue Flag Taken
                (playerScreen:loop(3)setCycle(Fwd)cycleSpeed(1))    // Warning Signal
            )
        )
        /*               WINNING BY FLAG CAPTURE               */
        (if(< (send gEgo:distanceTo(playerFlag)) 10)
            (if(playerHasFlag)
                (if(not(compHasFlag))   // Opponent must not have flag
                    = playerFlagWin 1
                    (RoomScript:changeState(10))
                    (compScreen:loop(0))    // Remove Warning Signal
                )
            )
        )
        (if(< (opponent:distanceTo(compFlag)) 10)
            (if(compHasFlag)
                (if(not(playerHasFlag))   // Player must not have flag
                    (RoomScript:changeState(12))
                    (playerScreen:loop(2))    // Remove Warning Signal
                )
            )
        )
        /*            WINNING BY DEPLETED LIFE BAR             */
        (if(<= rCompLp 0)   // If Computer's life is fully depleted
            (RoomScript:changeState(10))
        )
        (if(<= rPlayerLp 0) // If Player's life is fully depleted
            (RoomScript:changeState(12))
        )
        /*                 CHARACTER DEATH                     */
        (if(<= rCompHp 0)
            (if(not(compDead))
                = compDead 1
                (RoomScript:changeState(8))
                (if(compHasFlag)
                    = compHasFlag 0
                    (playerFlag:show())
                    (playerScreen:loop(2))
                )
            )
        )
        (if(<= rPlayerHp 0)
            (if(not(playerDead))
                = playerDead 1
                (RoomScript:changeState(6))
                (if(playerHasFlag)
                    = playerHasFlag 0
                    (compFlag:show())
                    (compScreen:loop(0))    // Remove Warning Signal
                )
            )
        )
        (if(<= rPlayerHp 0)
            = rPlayerHp 0   //ensures that health bars don't go into negative numbers
        )
        (if(<= rCompHp 0)
            = rCompHp 0
        )
        /*                MOVING THE TOTEM                     */
        (if(< (send gEgo:distanceTo(totem)) 8)
            (if((yourTotem) or (noOneTotem))
                = dondeTotem Random(0 1)
                = yourTotem 0
                (if(dondeTotem)             // If it eqauls 1 (TRUE) it will be sent to the...
                    (quadNull)  /* Remove all quadrant values */                //          //
                    (totem:posn( 119 165))  //                ...bottom-left (opponent's side)
                    = quad3 1
                )(else                      // Else, that is, if dondeTotem equals 0 (FALSE)...
                    (quadNull)              // It will be sent to the...
                    (totem:posn( 119 65))   // ...top-left (opponent's side)
                    = quad2 1
                )
            )
        )
        (if(< (opponent:distanceTo(totem)) 8)
            (if((not(yourTotem)) or (noOneTotem))
                = dondeTotem Random(0 1)    // dondeTotem will equal either 0 or 1
                = yourTotem 1
                (if(dondeTotem)             // If it eqauls 1 (TRUE) it will be sent to the...
                    (quadNull)  /* Remove all quadrant values */                //          //
                    (totem:posn( 193 165))  //                     ...bottom-right (your side)
                    = quad4 1
                )(else                      // Else, that is, if dondeTotem equals 0 (FALSE)...
                    (quadNull)              // It will be sent to the...
                    (totem:posn( 193 65))   // ...top-right (your side)
                    = quad1 1
                )
            )
        )

        /*             RESTORING HEALTH                  */
        (if(< (send gEgo:distanceTo(playerHealer)) 8)
            (if(<= rPlayerHp 6) // player cannot exceed 7 Health Points - 7 is FULL
                (++rPlayerHp)   // Heals every cycle
            )
        )
        (if(< (opponent:distanceTo(compHealer)) 8)
            (if(<= rCompHp 6)   // opponent cannot exceed 7 Health Points - 7 is FULL
                (++rCompHp)     // Heals every cycle
            )
        )
        
        /*                    UPDATING MAIN BOARD                     */
        /* In the Doit Method, these are updated every computer cycle */
        (compLifeBar:cel(rCompLp))
        (compHpBar:cel(rCompHp))
        (complp:cel(rCompLp))
        (comphp:cel(rCompHp))
        (compPower:cel(rCompPower))
        
        (playerLifeBar:cel(rPlayerLp))
        (playerHpBar:cel(rPlayerHp))
        (playerlp:cel(rPlayerLp))
        (playerhp:cel(rPlayerHp))
        (playerPower:cel(gPlayerPower))

     )
)
/**********************************************************************/
/*                     PROCEDURES for calculations                    */
/**********************************************************************/

/*         TOTEM-BASED PROCEDURES        */
(procedure (quadNull)
    = quad1 0       /*******************************/
    = quad2 0       /* Removes Totem Value from    */
    = quad3 0       /* Each Quadrant to prapare    */
    = quad4 0       /* It's move to a new Quadrant */
    = noOneTotem 0  /*******************************/
)
(procedure (quadDamage)
    (if((quad1) or (quad4)) // Checks if Totem is one the Player's Side
        -- rPlayerLp        // Player Loses Life Point
        (totem:cel(0)setCycle(End))
    )(else
        (if((quad2) or (quad3)) // Checks if Totem is one the Opponent's Side
            -- rCompLp          // Computer Loses Life Point
            (totem:cel(0)setCycle(End)cycleSpeed(3))
        )
    )
)
(procedure (totemGuard)
    (if((quad1) or (quad4)) // Checks if Totem is one the Player's Side
        (if(== (send gEgo:onControl()) ctlGREY) // Player on opponent's side of the field
            -- rPlayerHp
            (totem:cel(0)setCycle(End)cycleSpeed(3))
        )
    )(else
        (if((quad2) or (quad3)) // Checks if Totem is one the Opponent's Side
            (if( (== (opponent:onControl()) ctlSILVER) or (== (opponent:onControl()) ctlMAROON)) // Opponent on Player side
                -- rCompHp
                (totem:cel(0)setCycle(End)cycleSpeed(2))
            )
        )
    )
)
/*        INCREASING POWER BARS          */
(procedure (addPower)
    (if (< gPlayerPower 4)  // Power Cannot Exceed 4 - 4 is Full
        ++gPlayerPower
    )(if (< rCompPower 4)
        ++rCompPower
    )
)
/*         PLAYER POWER PROCEDURE         */
(procedure (playerAbility)
    (var button)
    (if(== gPlayerPower 4) // Powerbar must be Full (FOUR)
        (if( (== (opponent:onControl()) ctlSILVER) or (== (opponent:onControl()) ctlMAROON)) // Opponent on Player side
            = button Print(0 6
                #title "How would you like to use your power?"
                #button "1 pt" 0 #button "5 pts" 1 #button "Nothing" 2)
            (if(== button 0)
                --rCompLp
                (ShakeScreen(2))
                = gPlayerPower 0  // Resets Player's power at ZERO (0)
            )(else
                (if(== button 1)
                    = rCompHp (- rCompHp 5)
                    (ShakeScreen(2))
                    = gPlayerPower 0  // Resets Player's power at ZERO (0)
                )(else
                    (if(== button 2)
                    )
                )
            )
        )(else
            = button Print(0 7
                #title "How would you like to use your power?"
                #button "1 pt" 0 #button "3 pts" 1 #button "Nothing" 2)
            (if(== button 0)
                --rCompLp
                (ShakeScreen(2))
                = gPlayerPower 0  // Resets Player's power at ZERO (0)
            )(else
                (if(== button 1)
                    = rCompHp (- rCompHp 3)
                    (ShakeScreen(2))
                    = gPlayerPower 0  // Resets Player's power at ZERO (0)
                )(else
                    (if(== button 2)
                    )
                )
            )
        )
    )(else
        Print(0 8)
    )
)
/*       OPPONENT POWER PROCEDURES        */
(procedure (compZap)        // compZap deals ONE (1) pt of damage to the Player's Game-Life
    = rPlayerLp (- rPlayerLp 1)
    (ShakeScreen(2))        // Shaking the Screen helps Player know Opponent did something
    = htext Display(1 0     // Displays text on bottom for Player's Info
        dsCOORD 10 181
        dsCOLOUR clMAROON
        dsBACKGROUND clTRANSPARENT
        dsSAVEPIXELS
    )
    = rCompPower 0  // Resets Opponent's power at ZERO (0)
)
(procedure (compBolt)       // compBolt deals THREE (3) pts of damage to Player's Character Health
    = rPlayerHp (- rPlayerHp 3)
    (ShakeScreen(2))        // Shaking the Screen helps Player know Opponent did something
    = htext Display(1 1     // Displays text on bottom for Player's Info
        dsCOORD 10 181
        dsCOLOUR clMAROON
        dsBACKGROUND clTRANSPARENT
        dsSAVEPIXELS
    )
    = rCompPower 0  // Resets Opponent's power at ZERO (0)
)
(procedure (compBlast)      // compBolt deals FIVE (5) pts of damage to Player's Character Health
    = rPlayerHp (- rPlayerHp 5)
    (ShakeScreen(2))        // Shaking the Screen helps Player know Opponent did something
    = htext Display(1 2     // Displays text on bottom for Player's Info
        dsCOORD 10 181
        dsCOLOUR clMAROON
        dsBACKGROUND clTRANSPARENT
        dsSAVEPIXELS
    )
    = rCompPower 0  // Resets Opponent's power at ZERO (0)
)

/***************************************************************/
/*           Separate Time-Script for Quadrant Damage          */
/***************************************************************/

(instance totemScript of Script
    (properties)
    (method (changeState newState)
        = state newState
        (switch (state)
            (case 0 = cycles 15
                (totemGuard)
            )(case 1 = cycles Random(10 40)
            )(case 2 = cycles 15
                (quadDamage)
                (totemGuard)
            )(case 3 = cycles Random (20 40)
            )(case 4
                (totemScript:changeState(0))
            )
        )
    )
)
    
/*********************INSTANCES********************************/
/*            INSTANCES FOR THE SCORE/INFO BOARD              */
(instance screen of Prop                     //               //
    (properties y 37 x 157 view 50)          //               //
)                                            //               //
(instance compScreen of Prop                 //               //
    (properties y 67 x 51 view 51)           //               //
)                                            //               //
(instance playerScreen of Prop               //               //
    (properties y 69 x 269 view 51 loop 2)   //               //
)                                            //               //
/*             Computer                                       */
(instance compLifeBar of Prop                //               //
    (properties y 23 x 98 view 20)           //               //
)                                            //               //
(instance compHpBar of Prop                  //               //
    (properties y 37 x 98 view 21)           //               //
)                                            //               //
(instance complp of Prop                     //               //
    (properties y 22 x 130 view 19)          //               //
)                                            //               //
(instance comphp of Prop                     //               //
    (properties y 36 x 130 view 19)          //               //
)                                            //               //
(instance compPower of Prop                  //               //
    (properties y 37 x 140 view 22)          //               //
)                                            //               //
/*              Player                                        */
(instance playerLifeBar of Prop              //               //
    (properties y 23 x 219 view 20)          //               //
)                                            //               //
(instance playerHpBar of Prop                //               //
    (properties y 37 x 219 view 21)          //               //
)                                            //               //
(instance playerlp of Prop                   //               //
    (properties y 22 x 186 view 19)          //               //
)                                            //               //
(instance playerhp of Prop                   //               //
    (properties y 36 x 186 view 19)          //               //
)                                            //               //
(instance playerPower of Prop                //               //
    (properties y 37 x 174 view 22)          //               //
)                                            //               //
/*        INSTANCES FOR OBJECTS IN THE PLAYING FIELD          */
(instance opponent of Act                                     //
    (properties y 115 x 53 view 1)                            //
)                                                             //
(instance totem of Prop                                       //
    (properties y 148 x 156 view 10)                          //
)                                                             //
(instance compFlag of Prop                                    //
    (properties y 95 x 41 view 11 loop 1)                     //
)                                                             //
(instance playerFlag of Prop                                  //
    (properties y 95 x 280 view 11)                           //
)                                                             //
(instance compHealer of Prop                                  //
    (properties y 130 x 42 view 5)                            //
)                                                             //
(instance playerHealer of Prop                                //
    (properties y 130 x 276 view 5)                           //
)                                                             //
/**************************************************************/

/******************************************************************************/
