/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
		)

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)       */

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  Print(
  "SCI-MAN                                By Jesse Tyler"
  dsCOORD 90 80
  dsCOLOUR clBLUE
  #title "SCI-MAN!"
  #font LARGE_FONT
  #icon 0 0 0


)
 )

  )


  /*Display(
			"SCI-MAN"
            #font LARGE_FONT
            dsCOORD 100 80
			dsCOLOUR clBLUE
			dsBACKGROUND clTRANSPARENT
		)
	)
)   */

/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))

        (Print(
  "According to Spanish Tradition: On New Year's Eve eat 12 grapes in under a minute - or 12 chimes of the clock, this brings a year of good luck.  To eat a grape go near it and change directions."
  dsCOORD 90 80
  dsCOLOUR clBLUE
  #title "SCI-MAN!"
  #font LARGE_FONT
  #icon 0 0 0


)
 )
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game

/*Print(
  "SCI-MAN                                By Jesse Tyler"
  #title "SCI-MAN!"
  dsCOORD 90 80
  dsCOLOUR clBLUE
  #font LARGE_FONT
  #icon 0 0 0


)*/
/*(var button)
= button Print(
  "Do you want to click Yes or No?"
  #title "Click What?"
  #font LARGE_FONT
  #icon 0 0 0
  #button " Yes " 1
  #button " No " 0
)
(if(== button 1)
  Print("You clicked YES")
)(else
  Print("You clicked NO")
) */
				(send gRoom:newRoom(INITROOMS_SCRIPT))
		    )
		)
	)
)
/******************************************************************************/
