/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(use "wander")
(use "follow")
 /*so the ghost moves*/
 
(local countdownminutes = 0 // the count
countdownseconds = 59 // the count
milsec = 5 // cycles per second
countmilsec = 5) // the count
 
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
 (method (init)
	// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
     (default
  				(send gEgo:
  					posn(150 130)
  					loop(1)
  				)
  			)
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init())

  Writemin()                     // update minutes displayed -- All clock code supplied by Cloudee1
 Writesec()

(aMan:
ignoreControl(ctlWHITE)
init()
setCycle(Walk)
setMotion(Follow gEgo)
setMotion(Wander)
)
/*(aMan:
  ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
) */
(aMan2:
  ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(aMan3:
  ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(aMan4:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape1:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape2:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
 (Grape3:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape4:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape5:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape6:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape7:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape8:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape9:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape10:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape11:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
(Grape12:
 ignoreControl(ctlWHITE)
  init()
  setMotion(Wander)
)
  /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)
/******************************************************************************/
(instance RoomScript of Script
(properties)
 (method (doit)
 (var dyingScript)
 (super:doit())



 (if(not(gProgramControl))             //Death-handler script provided by Cloudee1
    (if(< (send gEgo:distanceTo(aMan)) 15)
       ProgramControl()
       = dyingScript ScriptID(DYING_SCRIPT)
       (send dyingScript:caller(3)register("Pinky Pink got you... for directions start a new game and type look."))
       (send gGame:setScript(dyingScript))
    )

    (if(< (send gEgo:distanceTo(aMan2)) 15)
       ProgramControl()
       = dyingScript ScriptID(DYING_SCRIPT)
       (send dyingScript: caller(4)register("Redman got you...try again, maybe type look at start!!! "))
       (send gGame:setScript(dyingScript))
    )

    (if(< (send gEgo:distanceTo(aMan3)) 15)
       ProgramControl()
       = dyingScript ScriptID(DYING_SCRIPT)
       (send dyingScript:caller(5)register("Greenie got you... for directions start a new game and type look."))
       (send gGame:setScript(dyingScript))
    )

   (if(< (send gEgo:distanceTo(aMan4)) 15)
       ProgramControl()
       = dyingScript ScriptID(DYING_SCRIPT)
       (send dyingScript:caller(6)
       register("Purple Nurple got you... for directions start a new game and type look."))
       (send gGame:setScript(dyingScript))
    )
  ) // ends not program control
// end method


    (if(== countmilsec 0)
      (if(== countdownseconds 0)
        (if(== countdownminutes 0)  // all three timers reach 0

           //  ... countdown at 0, now what

       ProgramControl()
       = dyingScript ScriptID(DYING_SCRIPT)
       (send dyingScript:caller(19)register("Out of time.  Oh yeah, you must eat all of the grapes in under 60 seconds.  It is nearly impossible, yet people try every year.  Some die trying.    0-3 Grapes = Lame Year        4-6 Grapes = Normal Year      7-10 Grapes = Great Year      11 Grapes So Close            12 Grapes = You are the Luckiest Person Ever!!! "))
       (send gGame:setScript(dyingScript))



        )
        (else   // milsec and sec at 0 but not min
        = countdownminutes --countdownminutes  // so subtract one minute
        = countdownseconds 59  // changes the 0 to 60 to keep timer counting down
        Writemin()  // update minutes displayed
        Writesec()
        = countmilsec milsec // resets milsec to cycle delay
        )
      )
      (else  // milisec at 0 but not seconds
      = countdownseconds --countdownseconds  // so subtract one second
      Writesec()  // update seconds displayed
      = countmilsec milsec     // resets milsec to cycle delay
      )
 )


    = countmilsec --countmilsec  // subtract one from milisec each cycl
(if(== gScore 12) // I'm not sure what the score variable is called exactly
  /*Print ("You've done it you are the winner.")*/
  (Print(
  "You've done it you are the winner.  You will now have good luck for a whole year."
  dsCOORD 90 80
  dsCOLOUR clBLUE
  #title "SCI-MAN!"
  #font LARGE_FONT
  #icon 0 0 0


)
 )

) // end method

        )

 (method (handleEvent pEvent)
 (super:handleEvent(pEvent))


 (if(Said('look>'))
                             (if(Said('/room,(a)'))
                             Print("There are grapes and ghosts everywhere.")
                    )(else
                              (if(Said('/(ghost)'))
                             Print("They look scary, better to stay away from them.")
                    )(else
                            (if(Said('/(grape)'))
                             Print("They look good enough to eat.")
                    )(else
                             (if(Said('[ /* , !* ]')
                             Print("There are grapes with numbers in this room... Use arrow keys to move, to eat grapes go near them and CHANGE DIRECTIONS...you will eat the grape. According to a tradition in Spain, eat 12 grapes before the New Year and you will have good luck for the whole year.")

)
)
)
)
)


/*the brackets above close the special look different things option*/
                           )(else

/*(if(Said('eat>'))
                     (if(Said('/grape1'))
                            (if(send gEgo:has(INV_GRAPE1))
                           Print("You already have it!")
                          )(else
                            (if(< (send gEgo:distanceTo(Grape1)) 15)
                           Print("O.K.")
                            (send gEgo:get(INV_GRAPE1))
                            (Grape1:hide())
                            (send gGame:changeScore(1))
                          )(else
                           Print("You're not close enough!")
                     )*/


        (if(< (send gEgo:distanceTo(Grape1)) 20)
            (if(send gEgo:has(INV_GRAPE1))
            )(else
          (send gEgo:get(INV_GRAPE1))
          (Grape1:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape2)) 20)
            (if(send gEgo:has(INV_GRAPE2))
            )(else
          (send gEgo:get(INV_GRAPE2))
          (Grape2:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape3)) 20)
            (if(send gEgo:has(INV_GRAPE3))
            )(else
          (send gEgo:get(INV_GRAPE3))
          (Grape3:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape4)) 20)
            (if(send gEgo:has(INV_GRAPE4))
            )(else
          (send gEgo:get(INV_GRAPE4))
          (Grape4:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape5)) 20)
            (if(send gEgo:has(INV_GRAPE5))
            )(else
          (send gEgo:get(INV_GRAPE5))
          (Grape5:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape6)) 20)
            (if(send gEgo:has(INV_GRAPE6))
            )(else
          (send gEgo:get(INV_GRAPE6))
          (Grape6:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape7)) 20)
            (if(send gEgo:has(INV_GRAPE7))
            )(else
          (send gEgo:get(INV_GRAPE7))
          (Grape7:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape8)) 20)
            (if(send gEgo:has(INV_GRAPE8))
            )(else
          (send gEgo:get(INV_GRAPE8))
          (Grape8:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape9)) 20)
            (if(send gEgo:has(INV_GRAPE9))
            )(else
          (send gEgo:get(INV_GRAPE9))
          (Grape9:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape10)) 20)
            (if(send gEgo:has(INV_GRAPE10))
            )(else
          (send gEgo:get(INV_GRAPE10))
          (Grape10:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape11)) 20)
            (if(send gEgo:has(INV_GRAPE11))
            )(else
          (send gEgo:get(INV_GRAPE1))
          (Grape11:hide())
          (send gGame:changeScore(1))
          )
          )
        (if(< (send gEgo:distanceTo(Grape12)) 20)
            (if(send gEgo:has(INV_GRAPE12))
            )(else
          (send gEgo:get(INV_GRAPE12))
          (Grape12:hide())
          (send gGame:changeScore(1))
          )
          )



)
)

/* the bracket below this line closes the Room Instance Script*/
)


  /* (if(Said('look'))
    Print("You are in a room...ahhhh there are ghosts all around you stay away from them!!!  But hey, there is also a grape wandering around... According to a tradition in Spain, eat 12 grapes before the New Year and you will have good luck for the whole year.")
   )// end said look

 ) // end method
) // end roomscript instance*/

(instance aMan of Act  (properties y 185 x 220  view 3))
(instance aMan2 of Act  (properties y 18 x 20    view 4))
(instance aMan3 of Act (properties y 85 x 200 view 5))
(instance aMan4 of Act (properties y 50 x 10 view 6))
(instance Grape1 of Act (properties y 100 x 100 view 7))
(instance Grape2 of Act (properties y 100 x 100 view 8))
(instance Grape3 of Act (properties y 100 x 100 view 9))
(instance Grape4 of Act (properties y 185 x 220 view 10))
(instance Grape5 of Act (properties y 185 x 220 view 11))
(instance Grape6 of Act (properties y 185 x 220 view 12))
(instance Grape7 of Act (properties y 50 x 10 view 13))
(instance Grape8 of Act (properties y 50 x 10 view 14))
(instance Grape9 of Act (properties y 50 x 10 view 15))
(instance Grape10 of Act (properties y 185 x 220 view 16))
(instance Grape11 of Act (properties y 185 x 220 view 17))
(instance Grape12 of Act (properties y 18 x 20 view 18))

(procedure public (Writemin)                                  // display Minutes
	(var textstring[50])
    Format(@textstring "%2d" countdownminutes)
    Display(@textstring dsCOORD  144 8  dsCOLOR 00 dsFONT 4 dsBACKGROUND 15 dsWIDTH 10)
)

(procedure public (Writesec)                                  // display Seconds
	(var textstring[50])
    (if(< countdownseconds 0)   = countdownseconds 0) // resets seconds if it dips negative

    Format(@textstring "%2d" countdownseconds)
    Display(@textstring dsCOORD 156 8 dsCOLOR 00 dsFONT 4 dsBACKGROUND 15 dsWIDTH 12)
)

