/*
 *    CaveMan Game, by Neil Chinnery.
 */



#include <stdlib.h>
#include <stdio.h>
#include <sys/farptr.h>
#include <sys/segments.h>
#include <sys/movedata.h>
#include "allegro.h"
#include "caveman.h" /* Data file Index */
#include "hactions.h" /* Hero Action Index */

#define XSIZE 100
#define YSIZE 100
#define FR 10   /* Milliseconds between updates to frme counter */
#define FR4 33 /* Counter for delay between tile 98 & 99 change (water) */
#define FIRE_HOTSPOTS   48
#define MAXLEVELS 3 /* Number of available levels */
#define GAME_SPEED 15

int hotspot[FIRE_HOTSPOTS]; 


DATAFILE *data;
BITMAP *s, *s2; 

int curlev=1; /* Current level */
int level[XSIZE][YSIZE]; /* Holds tile data of Level */
int lve_fle[XSIZE*YSIZE+1506]; /* Buffer for all of level data */
int lve_point=0;
int fsize=11506;
int kp;
int norm_jump_height=33;
int norm_jump_length=44;
int norm_hero_speed=2;
int tend=0; /* End flag: 0=Carry on, 1=Stop */
int lxoff=0, lyoff=0; /* X & Y Offsets for level */
int lxoff2=0, lyoff2=0; /* X and Y Offsets for Drawing Level */
int ncount=0; /* Nasty Count */
int subntype=0; /* Nasty Type */
int startx, starty; /* Hero's Starting Position */
int water_timer=0; /* Used for animation delay in water tiles (98 and 99) */
int water_pointer=273;
int can_mve_left=NULL;
int can_mve_right=NULL;
int hero_hit=0;
int hero_hit2=0;
int startx, starty; /* Starting Position on Level */
int c_mov[510];
int paralax=0; /*Starting Position of Parallax Scroll */
int deadanim, deadanimx,deadanimy; /* Used for Dying Monster Anims */
int deadanimfr, deadanimtm1, deadanimtm2; /* Used for Dying Monster Anims */
int nme2[15]={59,64,68,74,78,82,93,96,102,109,112,116,119,130}; /* Enemy Frame to display */

int nme3[15]={0,0,1,0,0,0,0,0,0,0,0,0,0,0}; /* Enemy Initial Direction */

int nme4[15]={2,2,6,2,2,2,3,2,3,0,9,10,-3,11}; /* Enemy Y offsets (make sure they touch the ground ;-) */

/* this array hold the index of the sample to play when items are picked up */
int smple[36]={524,524,517,532,532,532,533,524,534,524,524,524,522,529,534,529,524,521,524,524,
               532,524,524,527,524,523,532,532,524,524,524,524,534,526,532,519};
volatile char sync; /* Controls Game Speed */
volatile int frme, tme; /* Counter for Interrupt to update */
volatile int tme2, tme3;
/* Defines 3 arrays pointing to animation frame no's for certain actions */

int hrun[7]={43,42,44,48,45,46,41}; /* Hero Running */
int hrun_point=0;
int hwack[7]={50,51,52,56,52,51,50}; /* Hero Wacking */
int hwack_point=0;
int hjump[5]={54,55,53,57,58}; /* Hero Jumping */
int hjump_point=0;
int spec_flag=0; /* Anything special happening to hero */
int invince_flag=0; /* Hero Invincible Flag */
int reverse_flag=0; /* Controls Reversed Flag */
/* Define 5 arrays: 1st is Animation Frame no's for certain nasty actions
		    2nd is How many Frames for each nasty animation
		    3rd is current time since last frame change
		    4th is delay time between changes 
		    5th is Pointer to 1st array holding current frame */

int nmve[14][7]={59,60,61,62,63,0,0,
		 66,67,66,65,64,0,0,
		 0,0,0,0,0,0,0,
		 76,77,76,75,74,0,0,
		 80,81,80,79,78,0,0,
		 82,83,84,85,0,0,0,
		 93,94,95,0,0,0,0,
		 97,98,99,100,99,98,0,
		 102,103,104,105,106,107,108,
		 109,110,111,110,0,0,0,
		 112,113,114,115,0,0,0,
		 117,118,116,0,0,0,0,
		 121,120,119,0,0,0,0,
		 136,137,136,135,134,0,0};
int nfr[14]={5,5,0,5,5,4,3,6,7,4,4,3,3,5};
int ndly[14]={0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int ndly2[14]={5,8,0,8,8,18,18,8,15,18,8,18,20,8};
int mvpoint[14]={0,0,0,0,0,0,0,0,0,0,0,0,0,0};		    
int nastydim[14][2]={16,16,
		     30,30,
		     44,26,
		     30,30,
		     30,30,
		     16,20,
		     30,30,
		     53,25,
		     40,30,
		     43,37,
		     65,40,
		     28,23,
		     43,20,
		     30,30};

struct nasty { /* Enemy Type, start & end X and Y */
 int ntype,startx, starty, endx, endy, pixelx, pixely, anim_frame;
 int thrown_flag, tilex, tiley, direction, obj_tilex, obj_tiley;
 int obj_pixelx, obj_pixely, obj_distance, obj_direction, wack_flag;
 int wack_timer;
} nasty[300];

struct hero { 
 int tilex, tiley; /* Tile the Hero is currently on */
 int pixelx, pixely; /* Pixel X and Y in the current Tile */
 int direction; /* 0=left, 1=right */
 int speed; /* Hero's current speed */
 int anim_frame; /* Current Animation Frame */
 int jump_vel1; /* Jumping Controls */
 int jump_vel2;
 int jump_vel3;
 int jump_vel4;
 int jump_height; /* holds max jump height */
 int jump_length; /* holds max jump length */
 int rdelay; /* Holds delay on animation for hero running */
 int jdelay; /* Holds delay on animation for hero jumping */
 int wdelay; /* Holds delay on animation for hero wacking */
 int delay_timer; /* Holds last frme value */
 int next_action; /* Next action Hero will perform (from hactions.h) */
 int lives; /* How many lives has Hero got left */
 int score; /* What is current score? */
 int wack_flag; /* Is Hero 'wacking' something? */
 int jump_flag; /* Is Hero jumping? */
 int special_flag; /* Is power-up active? */
 int special_timer; /* Time left for power-up */
} hero;

void init_hero() /* Initialise Hero Structure */
{
 hero.tilex=0;
 hero.tiley=0;
 hero.pixelx=0;
 hero.pixely=0;
 hero.direction=1;
 hero.speed=norm_hero_speed;
 hero.anim_frame=41;
 hero.jump_vel1=0;
 hero.jump_vel2=0;
 hero.jump_vel3=0;
 hero.jump_vel4=0;
 hero.jump_height=norm_jump_height;
 hero.jump_length=norm_jump_length;
 hero.rdelay=6;
 hero.jdelay=8;
 hero.wdelay=3;
 hero.delay_timer=0;
 hero.next_action=HP_STAND;
 hero.lives=3;
 hero.score=0;
 hero.wack_flag=0;
 hero.jump_flag=0;
 hero.special_flag=0;
 hero.special_timer=0;
 hero_hit=0;
 hero_hit2=0;
}

void intro()
{
 int c, ix1, ix2, ix3, iy1, iy2, iy3, ix1p, iy1p, ix2p, iy2p, ix3p, iy3p;
 PALLETE pallete;
 RGB temp;

 set_volume (255,130);
 kp=0;
 clear_to_color(s,0);
 clear_to_color(screen,0);
 set_pallete(data[xpal1].dat);
 play_midi(data[xsong2].dat, TRUE);   
 ix1=0;
 iy1=0;
 ix2=0;
 iy2=200;
 ix3=200;
 iy3=150;
 ix1p=1;
 ix2p=1;
 ix3p=1;
 iy1p=1;
 iy2p=1;
 iy3p=1;

 while (kp==0)
 {
  blit(data[xtitle].dat,s,0,0,0,0,318,199); /* Yes, the snails are a comment on
                                               my code - something along the lines of
                                               "Yes, I know the code is slow
                                               but it gets there in the end" */
  draw_sprite (s, data[xtitle2].dat,ix2,iy2); 
  draw_sprite (s, data[xtitle3].dat, ix3, iy3); 
  blit(data[ytitlei].dat, s,ix2,0,0,170,320,29);
  vsync();
  blit(s,screen,0,0,0,0,318,199);
  if (key[KEY_S]) kp=1;
  if (key[KEY_ESC]) kp=2;
  ix2+=ix2p;
  ix3+=ix3p;
  if (ix2>150) ix2p=-1;
  if (ix2<-50) ix2p=+1;
  if (ix3>190) ix3p=-1;
  if (ix3<0) ix3p=+1;
  iy2+=iy2p;
  iy3+=iy3p;
  if (iy2>200) iy2p=-1;
  if (iy2<0) iy2p=+1;
  if (iy3>150) iy3p=-1;
  if (iy3<0) iy3p=+1;
 }
 set_pallete(data[PALETTE_01].dat);
 for (c=192;c<255; c++)
 {
  pallete[c].r=0;
  pallete[c].g=0;
  pallete[c].b=255-c;
 }
 set_pallete_range(pallete,160,255,0);
 clear_keybuf();
 set_volume(255,70);
}

/* This function updates the bottom line of the screen with a pattern
 * of varying intensities which are then moved upwards and faded out
 * by the code in credits(). - I pinched this routine from ex11 in the 
 * Allegro examples directory, I liked the fire-effect and needed a credit
 * sequence for the game
 */
void draw_bottom_line_of_fire()
{
   int c, c2;
   unsigned char temp[320];

   /* zero the buffer */
   for (c=0; c<SCREEN_W; c++)
      temp[c] = 0;

   for (c=0; c<FIRE_HOTSPOTS; c++) { 
      /* display the hotspots */
      for (c2=hotspot[c]-20; c2<hotspot[c]+20; c2++)
	 if ((c2 >= 0) && (c2 < SCREEN_W))
	    temp[c2] = MIN(temp[c2] + 20-ABS(hotspot[c]-c2), 192);

      /* move the hotspots */
      hotspot[c] += (random() & 7) - 3; 
      if (hotspot[c] < 0)
	 hotspot[c] += SCREEN_W;
      else
	 if (hotspot[c] >= SCREEN_W)
	    hotspot[c] -= SCREEN_W;
   }

   /* display the buffer */
   for (c=0; c<SCREEN_W; c++)
      putpixel(screen, c, SCREEN_H-1, temp[c]);
}

void credits()
{
   PALLETE pallete;
   int c;
   int x, y;
   unsigned long address;
   unsigned char temp[320];


   for (c=0; c<FIRE_HOTSPOTS; c++)
      hotspot[c] = random() % SCREEN_W;

   /* fill our pallete with a gradually altering sequence of colors */
   for (c=0; c<64; c++) {
      pallete[c].r = c;
      pallete[c].g = 0;
      pallete[c].b = 0;
   }
   for (c=64; c<128; c++) {
      pallete[c].r = 63;
      pallete[c].g = c-64;
      pallete[c].b = 0;
   }
   for (c=128; c<192; c++) {
      pallete[c].r = 63;
      pallete[c].g = 63;
      pallete[c].b = c-192;
   }
   for (c=192; c<256; c++) {
      pallete[c].r = 63;
      pallete[c].g = 63;
      pallete[c].b = 63;
   }

   set_pallete(pallete);
   clear_to_color(screen,0);
   textout(screen, data[FONT2].dat, "Design & Coding = Neil Chinnery",0,0,38);
   textout(screen, data[FONT2].dat, "Graphics = Ari Feldman",0,20,44);
   textout(screen, data[FONT2].dat, "Allegro Library = Shawn Hargreaves",0,40,46);
   set_volume(255,255);
   play_midi(data[xsong1].dat, TRUE);    
   /* it's even faster if we transfer the data in big blocks */
   clear_keybuf();
   while (!key[KEY_ESC]) {
      draw_bottom_line_of_fire();

      for (y=64; y<SCREEN_H-1; y++) {
	 /* get an address for reading line y+1 */
	 address = bmp_read_line(screen, y+1);

	 /* read the line */
	 movedata(screen->seg, address, _my_ds(), (unsigned)temp, SCREEN_W);

	 /* adjust it */
	 for (x=0; x<SCREEN_W; x++)
	    if (temp[x] > 0)
	       temp[x]--;

	 /* get an address for writing line y */
	 address = bmp_write_line(screen, y);

	 /* write the line */
	 movedata(_my_ds(), (unsigned)temp, screen->seg, address, SCREEN_W);
      }
   }

}


void init_dead_stuff() /* Just used for dying monster animation */
{
 deadanim=-1;
 deadanimx=-1;
 deadanimy=-1;
 deadanimfr=33;
 deadanimtm1=0;
 deadanimtm2=8;
}

void loadlevl(filename) /* Load level data */
char *filename;
{
 FILE *input;
 int count,xspan,yspan;
 
 input=fopen(filename, "rb");
 fread (lve_fle, sizeof(int), fsize, input); /* Stick data into buffer */
 fclose(input);
  
 count=0;
 for (xspan=0; xspan<XSIZE; xspan++) /* Get tile info from buffer */
  for (yspan=0; yspan<YSIZE; yspan++)
   {
    level[xspan][yspan]=lve_fle[count];
    if (level[xspan][yspan]==41)  /* Have we found the Starting Position? */
     {
      hero.tilex=xspan;
      hero.tiley=yspan;
      startx=xspan;
      starty=yspan;
      level[xspan][yspan]=-1;
     }
    count++;
   }
 ncount=lve_fle[count]; /* Get nasty count from buffer */
 count++;
 for (xspan=0; xspan<301; xspan++) /* Get nasty info from buffer */
  {
   nasty[xspan].obj_tilex=-1;
   nasty[xspan].obj_tiley=-1;
   nasty[xspan].obj_pixelx=-1;
   nasty[xspan].obj_pixely=-1;
   nasty[xspan].obj_distance=-1;
   nasty[xspan].obj_direction=-1;
   nasty[xspan].wack_flag=-1;
   nasty[xspan].wack_timer=-1;
   nasty[xspan].ntype=lve_fle[count];
   nasty[xspan].anim_frame=nme2[lve_fle[count]];
   nasty[xspan].direction=nme3[lve_fle[count]];
   nasty[xspan].pixely=nme4[lve_fle[count]];
   count++;
   nasty[xspan].startx=lve_fle[count];
   nasty[xspan].tilex=lve_fle[count];
   nasty[xspan].pixelx=0;
   count++;
   nasty[xspan].starty=lve_fle[count];
   nasty[xspan].tiley=lve_fle[count];
   count++;
   nasty[xspan].endx=lve_fle[count];
   count++;
   nasty[xspan].endy=lve_fle[count];
   count++;
  }
}

void loadlevel()
{
  char levl[20];
  if (curlev==1) sprintf(levl, "level1.npc");
  if (curlev==2) sprintf(levl, "level2.npc");
  if (curlev==3) sprintf(levl, "level3.npc");
  if (file_exists(levl, NULL,NULL)!=0)
    {
     loadlevl(levl);
    }
   else
   {
   printf("Can't find level data");
   exit(0);
   }
}

void timer_sync(void) /* Used to control overall Game Speed */
{
   sync++;
}
END_OF_FUNCTION(timer_sync);

void fr_inc()
{
 frme++;
 if (frme>1000) frme=0;
}
END_OF_FUNCTION(fr_inc); 

void tm_inc()
{
 tme++;
 if (tme>1000) tme=0;
}
END_OF_FUNCTION(tm_inc); 

void disp_scrn(filename)
char *filename;
{
  int x1, y1;
  char msg[80];
   
}

void reset_special()
{
 hero.jump_height=norm_jump_height;
 hero.jump_length=norm_jump_length;
 hero.speed=norm_hero_speed;
 invince_flag=0;
 reverse_flag=0;
 spec_flag=0;
 tme3=0;
}



void gen_backdrop()
{
 int ex1, ex2, ey1;
 clear_to_color(s2,0); 
 ex2=0;
 ex1=192;
 for (ey1=0; ey1<233; ey1++)
 {
  hline(s2,0,ey1,800,ex1);
  ex2++;
  if (ex2>3)
  {
   ex2=0;
   ex1++;
  }
  if (ex1>254) ex1=192;
 }  
 draw_sprite(s2, data[ytmountain].dat,0,14); 
}

void dead_animation() /* Do we need to update dead anim frame? */
{
 int temp;

 if (deadanimtm1>frme)
  temp=(1000+frme)-deadanimtm1;
 else
  temp=frme-deadanimtm1;  /* get value for timer */
  
 if ((temp>deadanimtm2) && (temp<deadanimtm2+8)) /* is it within range? */
 {
  deadanimfr++;          /* update animation frame */
  deadanimtm1=frme;    /* update delay_timer variable */
 }
} 


void disp_submp(BITMAP *s) /* Display Level on Screen */
{
 int ex1, ey1, ex2, ey2, ncc, nsc, mx1,my1,hx1,hy1;
 int xmin1,xmax1,xmin2,xmax2,ymin1,ymax1,ymin2,ymax2;
 char stat[80];
 
 blit(s2,s,0+paralax,0,0+lxoff2,0+lyoff2,320,200);
 
 ex2=0;
 for (ex1=(0+lxoff); ex1<(21+lxoff); ex1++)
 {
  ey2=0;
  for (ey1=(0+lyoff); ey1<(14+lyoff); ey1++)
   {
    if ((level[ex1][ey1]!=273) && (level[ex1][ey1]!=274) && (level[ex1][ey1]!=-1) && (level[ex1][ey1]>174)) draw_sprite (s,data[level[ex1][ey1]].dat,ex2*16,ey2*16);    else
    if ((level[ex1][ey1]!=-1) && (level[ex1][ey1]<175)) draw_sprite (s, data[level[ex1][ey1]].dat,ex2*16,(ey2*16)+2);
    else
    if ((level[ex1][ey1]>272) && (level[ex1][ey1]<274)) draw_sprite (s,data[water_pointer].dat,ex2*16,ey2*16);

    ey2++;
   } 
   ex2++;
  }   
 ex2=0;
 hx1=((hero.tilex-lxoff)*16)+hero.pixelx;
 hy1=((hero.tiley-lyoff)*16)+hero.pixely;
 for (ex1=(0+lxoff); ex1<(23+lxoff); ex1++)
 {
  ey2=0;
  for (ey1=(0+lyoff); ey1<(14+lyoff); ey1++)
   {
    for (nsc=0; nsc<ncount+1; nsc++)
     {
      if ((nasty[nsc].ntype!=-1) && ((nasty[nsc].tilex==ex1) && (nasty[nsc].tiley==ey1)))
        {
        mx1=(ex2*16)+nasty[nsc].pixelx;
        my1=(ey2*16)+nasty[nsc].pixely;
        if (nasty[nsc].direction==0) draw_sprite (s, data[nasty[nsc].anim_frame].dat,mx1,my1);
        else
        draw_sprite_h_flip (s, data[nasty[nsc].anim_frame].dat,mx1,my1);
        
        /* Check to see if nasty has hit hero */
        
        hero_hit=1; /* Hero has been hit flag set to yes*/
        
        /* X coordinates of hero */
        xmin1=hx1;
        if (hero.direction==0)
         hx1-=4;
        else
         hx1+=4;
        xmax1=hx1+16;
        /* X coordinates of nasty */
        xmin2=mx1;
        if (nasty[nsc].direction==0)
         mx1-=4;
        else
         mx1+=4;
        xmax2=(mx1+nastydim[nasty[nsc].ntype][0])-6;
        /* Y coordinates of hero */
        ymin1=hy1;
        ymax1=hy1+20;
        /* Y coordinates of nasty */
        ymin2=my1+6;
        ymax2=(my1+nastydim[nasty[nsc].ntype][1])-5;               
        
        /* if hero is has not been hit, reset hero_hit flag */
        if (xmax2<xmin1) hero_hit=0;
        if (xmin2>xmax1) hero_hit=0;
        if (ymax2<ymin1) hero_hit=0;
        if (ymin2>ymax1) hero_hit=0;
        if (invince_flag!=0) hero_hit=0;
        if ((hero.tilex==startx) && (hero.tiley==starty) &&
            (hero.pixelx==0) && (hero.pixely==0)) hero_hit=0;
        if (hero_hit==1)
        {
         if (hero.wack_flag==1)
         {
          if (((hero.direction==1) && (nasty[nsc].direction==0)) ||
             ((hero.direction==0) && (nasty[nsc].direction==1)))
             {
              hero.score+=nasty[nsc].ntype*100;
              deadanim=1;
              deadanimfr=33;
              deadanimtm1=frme;
              deadanimx=mx1;
              deadanimy=my1;
              nasty[nsc].ntype=-1;
              nasty[nsc].startx=-1;
              nasty[nsc].starty=-1;
              nasty[nsc].endx=-1;
              nasty[nsc].endy=-1;
              nasty[nsc].pixelx=-1;
              nasty[nsc].pixely=-1;
              nasty[nsc].tilex=-1;
              nasty[nsc].tiley=-1;
              nasty[nsc].anim_frame=nmve[nsc][0];
              nasty[nsc].thrown_flag=-1;
              nasty[nsc].direction=-1;
              nasty[nsc].obj_tilex=-1;
              nasty[nsc].obj_tiley=-1;
              nasty[nsc].obj_pixelx=-1;
              nasty[nsc].obj_pixely=-1;
              nasty[nsc].obj_distance=-1;
              nasty[nsc].obj_direction=-1;
              nasty[nsc].wack_flag=-1;
              play_sample(data[ysfx11].dat, 55,55,1000,0);
             }
             else
             {
              hero_hit2=1;
              play_sample(data[ysfx9009].dat, 55, 55,1000,0);
             }
          }
          else
          {
           hero_hit2=1;
           play_sample(data[ysfx9009].dat, 55, 55, 1000, FALSE);
          }
        }
      }
     }    
    ey2++;
   } 
   ex2++;
  }   
}

void init3() /* Called when level has been completed */
{
 int c, cx,cy,x1,y1;

  for (c=0; c<15; c++) ndly[c]=0;
 
  for (c=0; c < 301; c++) /* Initialise all nasty positions to be -1 */
   {
    nasty[c].ntype=-1;
    nasty[c].startx=-1;
    nasty[c].starty=-1;
    nasty[c].endx=-1;
    nasty[c].endy=-1;
    nasty[c].pixelx=-1;
    nasty[c].pixely=-1;
    nasty[c].tilex=-1;
    nasty[c].tiley=-1;
    nasty[c].anim_frame=nmve[c][0];
    nasty[c].thrown_flag=-1;
    nasty[c].direction=-1;
    nasty[c].obj_tilex=-1;
    nasty[c].obj_tiley=-1;
    nasty[c].obj_pixelx=-1;
    nasty[c].obj_pixely=-1;
    nasty[c].obj_distance=-1;
    nasty[c].obj_direction=-1;
    nasty[c].wack_flag=-1;
   }
   loadlevel();
   lxoff=0;
   lyoff=85; /* Start at bottom left-hand corner */
   lxoff2=0;
   lyoff2=0;
   water_timer=0;
   gen_backdrop();
   disp_submp(s); /* display the level 'window' */
   frme=0;
   tme=0;
   tme2=0;
   tme3=0;
}



void chk_drop() /* Ensure Hero is standing on a tile, if not then drop down */
{
 char msg[80];
 int px1, py1, px2, py2;
 int eolx, eoly, eolpc; 
 int spk1, spk2; /* just used to check for spikes (saves typing in a long string for every tile ;-) */
  py1=hero.tiley+1; /* Heros feet are at bottom of 23x30 BMP
                      so automatically need to add 1 to hero.tiley (tiles
                      are 16x16) */

  if (hero.pixely+14>15) py1+=1; /* Additional length of heros body */

  if ((level[hero.tilex][py1]==438) || (level[hero.tilex+1][py1]==438) ||
      (level[hero.tilex][py1]==439) || (level[hero.tilex+1][py1]==439)) /* End of level */
      {
       eolx=78;
       eoly=0;
       play_sample(data[ysfx9007].dat, 55, 55, 1000, FALSE);
       for (eoly=0; eoly<100; eoly++)
       {
        clear_to_color(s, 0);
        draw_sprite (s, data[ytitlej].dat, eolx, eoly);
        textout(s,data[FONT2].dat,"Bonus 1000",0,0,89);
        vsync();
        blit(s,screen,0,0,0,0,320,200);
       }
       for(eolx=78; eolx<320; eolx++)
       {
        clear_to_color(s,0);
        draw_sprite (s, data[ytitlej].dat, eolx, eoly);
        textout(s,data[FONT2].dat,"Bonus 1000",0,0,89);
        vsync();
        blit(s,screen,0,0,0,0,320,200);
       }
       curlev++;
       hero.score+=1000;
       if (curlev>MAXLEVELS) curlev=1;
       reset_special();
       init3();
      }
       
  if ((level[hero.tilex][py1] == 273) || (level[hero.tilex+1][py1] == 273) ||
      (level[hero.tilex][py1] == 274) || (level[hero.tilex+1][py1] == 274))  /* Water tile */
   {
     hero_hit2=1; /* Make hero dead */
     play_sample(data[ysfx9010].dat, 55, 55, 1000, FALSE);
   }
  spk1=level[hero.tilex][py1];
  spk2=level[hero.tilex+1][py1];
  if ((spk1 == 183) || (spk2 == 183) || (spk1==186) || (spk2==186) ||
      (spk1==187) || (spk2==187) || (spk1==285) || (spk2==285) ||
      (spk1==316) || (spk2==316) || (spk1==317) || (spk2==317) ||
      (spk1==318) || (spk2==318))    /* Hero landed on a 'Spike' tile */
      {
       hero_hit2=1; /* Make hero dead */
       play_sample(data[ytisfx1].dat, 55,55,1000,FALSE);
      }
  if ((level[hero.tilex][py1] < 175) && (level[hero.tilex+1][py1] <175))
   {
    hero.anim_frame=57;
    hero.pixely+=hero.speed;
    if (hero.pixely>15)
    {
     hero.pixely-=16;
     hero.tiley+=1;
    }
   }
   else
   {
    hjump_point=0;  
    hero.next_action=HP_STAND;
    hero.jump_flag=0;
   }
}

void can_mve() /* Check to see if Hero can move left and right */
{
 int hx1, hx2, hx3;
 
 can_mve_left=1;
 can_mve_right=1;
 hx1=((hero.tilex-lxoff)*16)+hero.pixelx;
 if (hx1<1) can_mve_left=NULL;
 if (hx1>300) can_mve_right=NULL;
 hx2=level[hero.tilex+1][hero.tiley+1];
 if ((hero.tilex-1)<0) hx3=level[0][hero.tiley+1];
 else  hx3=level[hero.tilex-1][hero.tiley+1];
 if (hx2>174)
 {
  if ((hero.pixelx>1) && (c_mov[hx2]==-1)) can_mve_right=NULL;
 }
 if (hx3>174)
 {
  if ((hero.pixelx<5) && (c_mov[hx3]==-1)) can_mve_left=NULL;
 }
}

void chk_scroll() /* Check if Hero is approaching edge of screen
                     and scroll in the appropriate direction */ 
{
 if (((hero.tilex-lxoff)*16)+hero.pixelx > 215)
 {
  lxoff2+=hero.speed;
  paralax+=(hero.speed/2);
  if (paralax>480) paralax=480;
 }
 if ((lxoff2>15) && (lxoff<XSIZE-22))
  {
   lxoff2-=16;
   lxoff++;
  }
  if (lxoff2>15) lxoff2=15;
 if (((hero.tilex-lxoff)*16)+hero.pixelx < 105)
 {
  lxoff2-=hero.speed;
  paralax-=(hero.speed/2);
  if (paralax<0) paralax=0;
 }
 if ((lxoff2<0) && (lxoff>0))
  {
   lxoff2+=16;
   lxoff--;
  }

  if (((hero.tiley-lyoff)*16)+hero.pixely > 134) lyoff2+=hero.speed;
 if ((lyoff2>15) && (lyoff<YSIZE-14))
  {
   lyoff2-=16;
   lyoff++;
  }
  if (lyoff2>15) lyoff2=15;
 if (((hero.tiley-lyoff)*16)+hero.pixely < 66) lyoff2-=hero.speed;
 if ((lyoff2<0) && (lyoff>0))
  {
   lyoff2+=16;
   lyoff--;
  }
  if (lxoff2<0)
  {
   lxoff2=0;
   lxoff=0;
  }
  if (lyoff2<0)
  {
   lyoff2=0;
   lyoff=0;
  }


}  

void nasty_animation() /* Do we need to update current animation frame? */
{
 int temp, ncc;

 for (ncc=0; ncc<(ncount+1); ncc++)
 {
  if (nasty[ncc].ntype!=-1)
  {
   if (ndly[nasty[ncc].ntype]>frme)
    temp=(1000+frme)-ndly[nasty[ncc].ntype];
   else
    temp=frme-ndly[nasty[ncc].ntype];  /* get value for timer */
  
   if ((temp>ndly2[nasty[ncc].ntype]) && (temp<ndly2[nasty[ncc].ntype]+8)) /* is it within range? */
   {
    mvpoint[nasty[ncc].ntype]++;          /* update animation frame */
    ndly[nasty[ncc].ntype]=frme; /* update delay_timer variable */
   }
 
   if (mvpoint[nasty[ncc].ntype]>nfr[nasty[ncc].ntype]-1) mvpoint[nasty[ncc].ntype]=0;
   nasty[ncc].anim_frame=nmve[nasty[ncc].ntype][mvpoint[nasty[ncc].ntype]];
  }
 }
} 


void mve_nasties() /* Duh! I think you can work out what this does! */
{
 int temp,nadd, ncc;
 
 nasty_animation();
 
 for (ncc=0; ncc<ncount+1; ncc++)
 {
  if (nasty[ncc].ntype!=-1)
  {
   nadd=norm_hero_speed;
   if (nasty[ncc].startx>nasty[ncc].endx) nadd=0-norm_hero_speed;
   nasty[ncc].pixelx+=nadd;
   
   if (nasty[ncc].pixelx>15)
   {
    nasty[ncc].pixelx-=16;
    nasty[ncc].tilex+=1;
   }
   if (nasty[ncc].pixelx<0)
   {
    nasty[ncc].pixelx+=16;
    nasty[ncc].tilex-=1;
   }
   if (nasty[ncc].tilex==nasty[ncc].endx)
   {
    temp=nasty[ncc].startx;
    nasty[ncc].startx=nasty[ncc].endx;
    nasty[ncc].endx=temp;
    nasty[ncc].direction=1-nasty[ncc].direction;
   }
  }
 }
}


void col_detect() /* Has hero hit anything? */
{
 int val1, val2, val3, val4, col_num;
 
 col_num=0; 
 val1=level[hero.tilex][hero.tiley];
 val2=level[hero.tilex+1][hero.tiley];
 val3=level[hero.tilex+1][hero.tiley+1];
 val4=level[hero.tilex][hero.tiley+1];

 /* check for pick-ups and power-ups (items) */
 if ((hero.direction==0) && (val1<175) && (val1>138) && (hero.pixelx< 8))
  {
   col_num=val1;
   level[hero.tilex][hero.tiley]=-1;
  }
 if ((hero.direction==1) && (hero.pixelx>0) && (val2<175) && (val2>138))
  {
   col_num=val2;
   level[hero.tilex+1][hero.tiley]=-1;
  }
  
 if ((hero.direction==0) && (val4<175) && (val4>138) && (hero.pixelx< 8))
  {
   col_num=val4;
   level[hero.tilex][hero.tiley+1]=-1;
  }
 if ((hero.direction==1) && (hero.pixelx>0) && (val3<175) && (val3>138))
  {
   col_num=val3;
   level[hero.tilex+1][hero.tiley+1]=-1;
  }
 
 if (col_num!=0) play_sample(data[smple[col_num-139]].dat, 55, 55, 1000, FALSE);
 
 /* Calculate aditions to score */
 if ((col_num>138) && (col_num<141)) hero.score+=100;
 if (col_num==141) hero.lives+=1;
 if ((col_num>141) && (col_num<145)) hero.score+=100;
 if (col_num==146) hero.score+=100;
 if ((col_num>147) && (col_num<151)) hero.score+=100;
 if ((col_num>154) && (col_num<162)) hero.score+=100;
 if (col_num==163) hero.score+=100;
 if ((col_num>164) && (col_num<172)) hero.score+=100;
 if (col_num==173) hero.score+=100;
 if (col_num==174) hero.score*=2;
 
 /* Now the 'specials' */
   
 if (col_num==147) /* Double Speed */
 {
 reset_special();
 hero.speed=norm_hero_speed*2;
 tme2=tme;
 tme3=10;
 spec_flag=1;
 }
 if (col_num==153) /* Triple Speed */
 {
 reset_special();
 hero.speed=norm_hero_speed*3; 
 tme2=tme;
 tme3=10;
 spec_flag=1;
 }
 if ((col_num==145) && (spec_flag!=0)) tme3=10; /* Reset timer to 60 */
 if (col_num==162) /* Invincible */
 {
  reset_special();
  tme2=tme;
  tme3=10;
  spec_flag=3;
  invince_flag=1;
 }
 if (col_num==164) /* Double Jump */
 {
  reset_special();
  tme2=tme;
  tme3=10;
  spec_flag=4;
  hero.jump_height=norm_jump_height*2;
  hero.jump_length=norm_jump_length*2;
 }
 if (col_num==151) /* Reverse Meanings of Keys */
 {
  reset_special();
  tme2=tme;
  tme3=10;
  spec_flag=2;
  reverse_flag=1;
 }
 if (col_num==152)  /* Die in 60 Seconds */
 {
  reset_special();
  tme2=tme;
  tme3=60;
  spec_flag=6;
 }
 if (col_num==154)  /* Die in 60 Seconds */
 {
  reset_special();
  tme2=tme;
  tme3=60;
  spec_flag=6;
 }
 if (col_num==172) /* Cancel All Specials */
 {
  reset_special();
  tme3=0;
 }
}   

void drw_hero(BITMAP *s) /* Draw our Main-Man on Screen */
{
 char stat[80];
 if (hero.direction==1)
  draw_sprite(s, data[hero.anim_frame].dat,((hero.tilex-lxoff)*16)+hero.pixelx,((hero.tiley-lyoff)*16)+hero.pixely);
 else
  draw_sprite_h_flip(s, data[hero.anim_frame].dat,((hero.tilex-lxoff)*16)+hero.pixelx,((hero.tiley-lyoff)*16)+hero.pixely);
 sprintf(stat, "SCORE:%d   LIVES:%d       POWER-UP:%d    ", hero.score, hero.lives, tme3);
 textout(s,data[FONT1].dat,stat,0+lxoff2,0+lyoff2,89);
 if (deadanim==1)
 {
  dead_animation();
  draw_sprite(s, data[deadanimfr].dat, deadanimx, deadanimy);
  if (deadanimfr==38)
  {
   deadanim=-1;
   deadanimx=-1;
   deadanimy=-1;
  }
 }

 blit (s, screen, lxoff2,lyoff2,0,0,320,200); /* Draw it all on Visible Screen */
}

void run_animation() /* Do we need to update current animation frame? */
{
 int temp;

 if (hero.delay_timer>frme)
  temp=(1000+frme)-hero.delay_timer;
 else
  temp=frme-hero.delay_timer;  /* get value for timer */
  
 if ((temp>hero.rdelay) && (temp<hero.rdelay+8)) /* is it within range? */
 {
  hrun_point++;          /* update animation frame */
  hero.delay_timer=frme; /* update delay_timer variable */
 }
 
 if (hrun_point>6) hrun_point=0;
 hero.anim_frame=hrun[hrun_point];
} 

void jump_animation() /* Do we need to update current animation frame? */
{
 int temp;

 if (hero.delay_timer>frme)
  temp=(1000+frme)-hero.delay_timer;
 else
  temp=frme-hero.delay_timer;  /* get value for timer */
  
 if ((temp>hero.jdelay) && (temp<hero.jdelay+8)) /* is it within range? */
 {
  hjump_point++;          /* update animation frame */
  hero.delay_timer=frme; /* update delay_timer variable */
 }
 if (hjump_point>3) 
  {
   hrun_point=0;
   hjump_point=4;
  }
  else hero.anim_frame=hjump[hjump_point];
} 

void water_animation() /* Do we need to update current animation frame? */
{
 int temp;

 if (water_timer>frme)
  temp=(1000+frme)-water_timer;
 else
  temp=frme-water_timer;  /* get value for timer */
  
 if ((temp>FR4) && (temp<FR4+8)) /* is it within range? */
 {
  water_pointer++;          /* update animation frame */
  water_timer=frme; /* update delay_timer variable */
 }
 
 if (water_pointer==275) water_pointer=273;
} 

void hp_jumpup()
{
 jump_animation();
 hero.pixely+=hero.jump_vel3;
 hero.jump_vel1+=hero.jump_vel2;
 if (hero.jump_vel1>(hero.jump_height/hero.speed)) 
  {
   hero.jump_vel3=0;
   hero.next_action=HP_JUMPUP;
   chk_drop();
  }
  else hero.next_action=HP_JUMPUP;
 if (hero.pixely<0)
  {
   hero.pixely+=16;
   hero.tiley-=1;
  }
  
 if (hero.pixely>15)
  {
   hero.pixely-=16;
   hero.tiley+=1;
  }
 if ((hero.jump_vel1==1) && (hero.jump_vel2==-1))
  {
  hjump_point++;
  hero.anim_frame=hjump[hjump_point];
  }
}

void hp_jright()
{
 hero.direction=1;
 jump_animation();
 hero.pixely+=hero.jump_vel3;
 can_mve();
 if (can_mve_right) hero.pixelx+=hero.speed;
 hero.jump_vel4+=1;
 hero.jump_vel1+=hero.jump_vel2;
 if (hero.jump_vel1>(hero.jump_height/hero.speed))
  {
   hero.jump_vel3=0;
   hero.jump_vel2=-1;
  }
 if (hero.jump_vel4>(hero.jump_length/hero.speed))
  {
   hero.jump_vel3=0;
   chk_drop();
  }
  else hero.next_action=HP_JRIGHT;
  
 if (hero.pixely<0)
  {
   hero.pixely+=16;
   hero.tiley-=1;
  }
  
 if (hero.pixely>15)
  {
   hero.pixely-=16;
   hero.tiley+=1;
  }
  if (hero.pixelx>15)
   {
    hero.pixelx-=16;
    hero.tilex+=1;
  }
  if (hero.tilex>XSIZE)
  {
   hero.tilex=XSIZE;
   hero.pixelx=0;
  }
}

void hp_jleft()
{
 hero.direction=0;
 jump_animation();
 hero.pixely+=hero.jump_vel3;
 can_mve();
 if (can_mve_left) hero.pixelx-=hero.speed;
 hero.jump_vel4+=1;
 hero.jump_vel1+=hero.jump_vel2;
 if (hero.jump_vel1>(hero.jump_height/hero.speed))
  {
   hero.jump_vel3=0;
   hero.jump_vel2=-1;
  }
 if (hero.jump_vel4>(hero.jump_length/hero.speed))
  {
   hero.jump_vel3=0;
   chk_drop();
  }
  else hero.next_action=HP_JLEFT;
  
 if (hero.pixely<0)
  {
   hero.pixely+=16;
   hero.tiley-=1;
  }
  
 if (hero.pixely>15)
  {
   hero.pixely-=16;
   hero.tiley+=1;
  }
  if (hero.pixelx<0)
   {
    hero.pixelx+=16;
    hero.tilex-=1;
  }
  if (hero.tilex<0)
  {
   hero.tilex=0;
   hero.pixelx=0;
  }
}


void hrun_left() /* Hero to move left */
{
 run_animation(); /* Check to see if we need to update current animation frame */
 hero.direction=0;
 if (can_mve_left) hero.pixelx-=hero.speed;
 if (hero.pixelx<0) /* Has Hero moved onto a new tile? */
  {
   hero.pixelx+=16; 
   hero.tilex-=1;
  }
 chk_drop();
 hero.next_action=HP_STAND;
}

void hrun_right() /* Hero to move right */
{
 run_animation(); /* Check to see if we need to update the current anim_frame */
 hero.direction=1;
 if (can_mve_right) hero.pixelx+=hero.speed;
 if (hero.pixelx>15) /* Has Hero moved onto a new tile? */
  {
   hero.pixelx-=16;
   hero.tilex+=1;
  }
  chk_drop();
  hero.next_action=HP_STAND;
}    

void wack_animation() /* Do we need to update current animation frame? */
{
 int temp;

 if (hero.delay_timer>frme)
  temp=(1000+frme)-hero.delay_timer;
 else
  temp=frme-hero.delay_timer;  /* get value for timer */
  
 if ((temp>hero.wdelay) && (temp<hero.wdelay+8)) /* is it within range? */
 {
  hwack_point++;          /* update animation frame */
  hero.delay_timer=frme; /* update delay_timer variable */
 }
 if (hwack_point>6) 
  {
   hrun_point=0;
   hwack_point=0;
  }
  else hero.anim_frame=hwack[hwack_point];
}

void hp_wack()
{
 wack_animation();
 if (hwack_point==0) 
  {
   hero.wack_flag=0;
   hero.next_action=HP_STAND;
  }
  else hero.next_action=HP_WACK;
} 

void hp_stand() /* Hero Just Standing There */
{
 hero.delay_timer=frme;
 hero.anim_frame=50;
 chk_drop();
}

void do_action() /* Decide What Player is Going to Do */
{
 switch (hero.next_action)
	     {
	     case HP_STAND: hp_stand(); break;
	     case HP_RLEFT: hrun_left(); break;
	     case HP_RRIGHT: hrun_right(); break;
	     case HP_JUMPUP: hp_jumpup(); break;
	     case HP_JLEFT: hp_jleft(); break;
	     case HP_JRIGHT: hp_jright(); break;
	     case HP_WACK: hp_wack(); break;
	     }
}

void chk_action() /* Check what keys the player is pressing */
{
 int eolx, eoly;
 char msg[80];

if (reverse_flag==0) /* Normal Keys in effect */
{
 if ((key[KEY_S]) && (key[KEY_SPACE]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
   {
    hero.jump_flag=1;
    hero.jump_vel1=0;
    hero.jump_vel2=1;
    hero.jump_vel3=0-hero.speed;
    hero.jump_vel4=0;
    hero.next_action=HP_JLEFT;
    play_sample(data[520].dat, 55, 55, 1000, FALSE);    
   }
   else
 if ((key[KEY_D]) && (key[KEY_SPACE]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.jump_flag=1;
   hero.jump_vel1=0;
   hero.jump_vel2=1;
   hero.jump_vel3=0-hero.speed;
   hero.jump_vel4=0;
   hero.next_action=HP_JRIGHT;
   play_sample(data[520].dat, 55, 55, 1000, FALSE);
  }
 else
 if ((key[KEY_S]) && (hero.jump_flag!=1) && (hero.wack_flag!=1)) hero.next_action=HP_RLEFT;
 else
 if ((key[KEY_D]) && (hero.jump_flag!=1) && (hero.wack_flag!=1)) hero.next_action=HP_RRIGHT;
 else
 if ((key[KEY_SPACE]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.jump_flag=1;
   hero.jump_vel1=0;
   hero.jump_vel2=1;
   hero.jump_vel3=0-hero.speed;
   hero.next_action=HP_JUMPUP;
   play_sample(data[520].dat, 55, 55, 1000, FALSE);
  }
 else
 if ((key[KEY_M]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.wack_flag=1;
   hero.next_action=HP_WACK;
  }
}

if (reverse_flag==1) /* Reverse keys in effect */
{
  if ((key[KEY_D]) && (key[KEY_M]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
   {
    hero.jump_flag=1;
    hero.jump_vel1=0;
    hero.jump_vel2=1;
    hero.jump_vel3=0-hero.speed;
    hero.jump_vel4=0;
    hero.next_action=HP_JLEFT;
    play_sample(data[520].dat, 55, 55, 1000, FALSE);    
   }
   else
 if ((key[KEY_S]) && (key[KEY_M]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.jump_flag=1;
   hero.jump_vel1=0;
   hero.jump_vel2=1;
   hero.jump_vel3=0-hero.speed;
   hero.jump_vel4=0;
   hero.next_action=HP_JRIGHT;
   play_sample(data[520].dat, 55, 55, 1000, FALSE);
  }
 else
 if ((key[KEY_D]) && (hero.jump_flag!=1) && (hero.wack_flag!=1)) hero.next_action=HP_RLEFT;
 else
 if ((key[KEY_S]) && (hero.jump_flag!=1) && (hero.wack_flag!=1)) hero.next_action=HP_RRIGHT;
 else
 if ((key[KEY_M]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.jump_flag=1;
   hero.jump_vel1=0;
   hero.jump_vel2=1;
   hero.jump_vel3=0-hero.speed;
   hero.next_action=HP_JUMPUP;
   play_sample(data[520].dat, 55, 55, 1000, FALSE);
  }
 else
 if ((key[KEY_SPACE]) && (hero.jump_flag!=1) && (hero.wack_flag!=1))
  {
   hero.wack_flag=1;
   hero.next_action=HP_WACK;
  }
 }
}

void check_dead()
{
 int eolx, eoly;
 char msg[80];

   if (spec_flag>0)
  {
   if (tme2!=tme)
   {
    tme2=tme;
    tme3--;
    if (tme3<1)
    {
     if (spec_flag==6) hero_hit2=1;
    else reset_special();
    }
   }
  }
  if (hero_hit2==1) /* Player Dead */
  {
   reset_special();
   hero.lives--;
   paralax=0;
   hero.tilex=startx;
   hero.tiley=starty;
   hero.pixelx=0;
   hero.pixely=0;
   hero_hit=0;
   hero_hit2=0;
   if (hero.lives==0) /* Game Over */
   {
       eolx=78;
       eoly=0;
       play_sample(data[ysfx9003].dat, 55, 55, 1000, FALSE);
       for (eoly=0; eoly<100; eoly++)
       {
        clear_to_color(s, 0);
        sprintf(msg, "Final Score: %d",hero.score);
        textout(s,data[FONT2].dat,msg,0,0,89);
        draw_sprite (s, data[ytitlek].dat, eolx, eoly);
        vsync();
        blit(s, screen, 0,0,0,0,320,200);
       }
       for(eolx=78; eolx<320; eolx++)
       {
        clear_to_color(s,0);
        textout(s,data[FONT2].dat, msg, 0,0,89);
        draw_sprite (s, data[ytitlek].dat, eolx, eoly);
        vsync();
        blit(s,screen,0,0,0,0,320,200);
       }
    tend=1;
    hero.next_action=HP_STAND;
   }
  }
}


void init_c_mov() /* Set up Array holding which tiles can be walked through 
		      -1 = can't be passed, 0=can be passed */
{
 int c1;
 
 for (c1=0; c1<511; c1++) c_mov[c1]=-1;
 
 for (c1=189; c1<192; c1++) c_mov[c1]=0;
 for (c1=211; c1<223; c1++) c_mov[c1]=0;
 for (c1=246; c1<258; c1++) c_mov[c1]=0;
 for (c1=281; c1<285; c1++) c_mov[c1]=0;
 for (c1=288; c1<292; c1++) c_mov[c1]=0;
 for (c1=312; c1<316; c1++) c_mov[c1]=0;
 for (c1=319; c1<322; c1++) c_mov[c1]=0;
 for (c1=340; c1<352; c1++) c_mov[c1]=0;
 for (c1=355; c1<363; c1++) c_mov[c1]=0;
 c_mov[369]=0;
 for (c1=375; c1<381; c1++) c_mov[c1]=0;
 for (c1=401; c1<403; c1++) c_mov[c1]=0;
 for (c1=406; c1<412; c1++) c_mov[c1]=0;
 for (c1=431; c1<433; c1++) c_mov[c1]=0;
 c_mov[437]=0;
 c_mov[440]=0;
 for (c1=466; c1<471; c1++) c_mov[c1]=0;
 for (c1=492; c1<496; c1++) c_mov[c1]=0;
}


 
void init2() /* Called when re-starting a game */
{
 int c, cx,cy,x1,y1;

  for (c=0; c<15; c++) ndly[c]=0;
 
  for (c=0; c < 301; c++) /* Initialise all nasty positions to be -1 */
   {
    nasty[c].ntype=-1;
    nasty[c].startx=-1;
    nasty[c].starty=-1;
    nasty[c].endx=-1;
    nasty[c].endy=-1;
    nasty[c].pixelx=-1;
    nasty[c].pixely=-1;
    nasty[c].tilex=-1;
    nasty[c].tiley=-1;
    nasty[c].anim_frame=nmve[c][0];
    nasty[c].thrown_flag=-1;
    nasty[c].direction=-1;
    nasty[c].obj_tilex=-1;
    nasty[c].obj_tiley=-1;
    nasty[c].obj_pixelx=-1;
    nasty[c].obj_pixely=-1;
    nasty[c].obj_distance=-1;
    nasty[c].obj_direction=-1;
    nasty[c].wack_flag=-1;
   }
   curlev=1;
   init_hero();
   loadlevel();
   lxoff=0;
   lyoff=85; /* Start at bottom left-hand corner */
   lxoff2=0;
   lyoff2=0;
   water_timer=0;
   paralax=0;
   gen_backdrop();
   disp_submp(s); /* display the level 'window' */
   init_dead_stuff();
   frme=0;
   tme=0;
   tme2=0;
   tme3=0;
}

void main()
{
  char msg[80];
  int c, cx,cy,x1,y1;
  PALLETE pallete;
  RGB temp;
  int tend2=0;
  
  init_c_mov();
  for (c=0; c < 301; c++) /* Initialise all nasty positions to be -1 */
   {
    nasty[c].ntype=-1;
    nasty[c].startx=-1;
    nasty[c].starty=-1;
    nasty[c].endx=-1;
    nasty[c].endy=-1;
    nasty[c].pixelx=-1;
    nasty[c].pixely=-1;
    nasty[c].tilex=-1;
    nasty[c].tiley=-1;
    nasty[c].anim_frame=nmve[c][0];
    nasty[c].thrown_flag=-1;
    nasty[c].direction=-1;
    nasty[c].obj_tilex=-1;
    nasty[c].obj_tiley=-1;
    nasty[c].obj_pixelx=-1;
    nasty[c].obj_pixely=-1;
    nasty[c].obj_distance=-1;
    nasty[c].obj_direction=-1;
    nasty[c].wack_flag=-1;
   }
   
   /* Initialise Allegro Units */
   allegro_init();
   install_keyboard(); 
   install_timer();
   install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
   set_volume(255, 130);
   
   
   /* Initialise Hero Structure */
   
   init_hero();
   
   /* Load the Level */
   
   loadlevel();

   /* Load the Allgero datafile */
   data=load_datafile("caveman.dat");
   
   /* Create Main Screen */
   set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
   clear_to_color(screen, 96);
   clear_keybuf();
   
   /* Create 'window' for level display */
   s=create_bitmap(352,232);
   s2=create_bitmap(800,232);
   clear(s); 
   tend=0;
   intro();
   if (kp==2)
   {
    tend=1;
    tend2=1;
   }
   set_pallete(data[PALETTE_01].dat);
   for (c=192;c<255; c++)
   {
    pallete[c].r=0;
    pallete[c].g=0;
    pallete[c].b=255-c;
   }
   set_pallete_range(pallete,160,255,0);
   gen_backdrop();
   lyoff=85; /* Start at bottom left-hand corner */
   disp_submp(s); /* display the level 'window' */
   frme=0;
   LOCK_VARIABLE(frme);
   LOCK_FUNCTION(fr_inc);
   install_int(fr_inc, FR);
   sync=0;
   LOCK_VARIABLE(sync);
   LOCK_FUNCTION(timer_sync);
   if(install_int(timer_sync, GAME_SPEED)!=0) exit(-1);
   tme=0;
   tme2=0;
   tme3=0;
   LOCK_VARIABLE(tme);
   LOCK_FUNCTION(tm_inc);
   install_int(tm_inc, 1000);
   init_dead_stuff();
   tend2=0;
   while (tend2==0)
   {
    do
    {
     sync=0;
     water_animation(); 
     disp_submp(s);
     drw_hero(s);
     chk_action();
     can_mve();
     do_action();
     chk_scroll();
     mve_nasties();
     col_detect(); 
     check_dead();
     while(!sync);
     } while ((!key[KEY_ESC]) && (tend==0));
     clear_keybuf();
     init2();
     tend=0;
     intro();
     if (kp==2)
     {
      tend=1;
      tend2=1;
     }
   } 
   clear_keybuf();
   credits();
   exit(0);
}
