/*
 *    Level Editor for CaveMan Game, by Neil Chinnery.
 */


#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"
#include "caveman.h"
#define XSIZE 100
#define YSIZE 100

DATAFILE *data;
BITMAP *s, *s2;

int level[XSIZE][YSIZE]; /* Holds Level Data */
int lve_fle[XSIZE*YSIZE+1506];
int lve_point=0;
int fsize=11506;
int tmouse=0;  /* Current State of Mouse: 0 = Normal anything else = Tile no. */
int tend=0; /* End of Edit flag: 0=Still Editing, 1=Stop Editing */
int lxoff=0, lyoff=0; /* X & Y Offsets for level being edited */
int edstatus=1; /* Editing Status 1=Tiles, 2=Powers, 3=Nasties */
int ncount=0; /* Nasty Count */
int nstatus=0; /* Current Nasty Status 0=Start 1=End */
int subntype=0; /* Nasty Type */

struct tile {
 int x1,y1,x2,y2; /* Top R and Bottom L corner of tile */
} tile[400];

struct pwr {
 int x1,y1,x2,y2; /* As above for Items */
} pwr[40];

struct nme {
 int x1,y1,x2,y2; /* As above for Enemies */
} nme[15];

int nme2[15]={59,64,68,74,78,82,93,96,102,109,112,116,119,130}; /* Enemy Frame to display */

struct nasty { /* Enemy Type, start & end X and Y, written as part of level data */
 int ntype,startx, starty, endx, endy;
} nasty[300];

void svelevl(filename)
char *filename;
{
 FILE *output;
 int count,xspan,yspan;
 
 count=0;
 for (xspan=0; xspan<XSIZE; xspan++)
  for (yspan=0; yspan<YSIZE; yspan++)
   {
    lve_fle[count]=level[xspan][yspan];
    count++;
   }
 lve_fle[count]=ncount;
 count++;
 for (xspan=0; xspan<301; xspan++)
  {
   lve_fle[count]=nasty[xspan].ntype;
   count++;
   lve_fle[count]=nasty[xspan].startx;
   count++;
   lve_fle[count]=nasty[xspan].starty;
   count++;
   lve_fle[count]=nasty[xspan].endx;
   count++;
   lve_fle[count]=nasty[xspan].endy;
   count++;
  }
 output=fopen(filename, "wb");
 fwrite (lve_fle, sizeof(int), fsize, output);
 fclose(output);
}

void loadlevl(filename)
char *filename;
{
 FILE *input;
 int count,xspan,yspan;
 
 input=fopen(filename, "rb");
 fread (lve_fle, sizeof(int), fsize, input);
 fclose(input);
  
 count=0;
 for (xspan=0; xspan<XSIZE; xspan++)
  for (yspan=0; yspan<YSIZE; yspan++)
   {
    level[xspan][yspan]=lve_fle[count];
    count++;
   }
 ncount=lve_fle[count];
 count++;
 for (xspan=0; xspan<301; xspan++)
  {
   nasty[xspan].ntype=lve_fle[count];
   count++;
   nasty[xspan].startx=lve_fle[count];
   count++;
   nasty[xspan].starty=lve_fle[count];
   count++;
   nasty[xspan].endx=lve_fle[count];
   count++;
   nasty[xspan].endy=lve_fle[count];
   count++;
  }
}

void disp_scrn(filename)
char *filename;
{
  int x1, y1;
  char msg[80];
   /*Display Status and 'Buttons' */
   
   sprintf(msg, "Editing Level:%s", filename);
   textout(screen,data[FONT1].dat,msg, 400,28,250); 
   sprintf(msg,"SAVE Level");
   textout(screen,data[FONT2].dat,msg,400,42,250);
   sprintf(msg,"RE-LOAD Level");
   textout(screen,data[FONT2].dat,msg,400,62,250);
   sprintf(msg, "QUIT Editor");
   textout(screen,data[FONT2].dat,msg,400,82,250);
   sprintf(msg, "SELECT Start Position");
   textout(screen,data[FONT2].dat, msg, 400,120,250);
   sprintf(msg, "PLACE Tiles");
   textout(screen,data[FONT2].dat,msg, 400, 145, 250);
   sprintf(msg, "PLACE Items");
   textout(screen,data[FONT2].dat,msg, 400,170,250);
   sprintf(msg, "PLACE Enemies");
   textout(screen, data[FONT2].dat,msg,400,195,250);
   sprintf(msg, "RESET Cursor");
   textout(screen,data[FONT2].dat,msg, 400, 220,250);
   
    /* the following code just draw up,down,left,right arrows around the
    level 'window' */
    
    x1=0;
    y1=210;
    draw_sprite_h_flip(screen, data[TILE318].dat,x1,y1);
    x1+=16;
    draw_sprite_h_flip(screen, data[TILE317].dat,x1,y1);
    x1=300;
    draw_sprite(screen,data[TILE317].dat,x1,y1);
    x1+=16;
    draw_sprite(screen,data[TILE318].dat,x1,y1);
    x1=330;
    y1-=32;
    draw_sprite(screen,data[TILE319].dat,x1,y1);
    x1+=16;
    draw_sprite(screen,data[TILE320].dat,x1,y1);
    y1=0;
    x1-=16;
    draw_sprite(screen,data[TILE294].dat,x1,y1);
    x1+=16;
    draw_sprite(screen,data[TILE295].dat,x1,y1);
}    

void shw_tiles() /* Display available tiles on screen */
{
 int x1, y1, cnt1;
 
 x1=0;
 y1=250;
 for (cnt1=175; cnt1 < 511; cnt1++)
 {
  blit(data[cnt1].dat, screen,0,0,x1,y1,16,16);
  tile[cnt1-175].x1=x1;
  tile[cnt1-175].y1=y1;
  tile[cnt1-175].x2=x1+16;
  tile[cnt1-175].y2=y1+16;
  x1+=17;
  if (x1>620)
  {
   x1=0;
   y1+=17;
  }
 }
}
 
void shw_nmes() /* Display available tiles on screen */
{
 int x1, y1, cnt1;
 
 x1=0;
 y1=250;
 for (cnt1=0; cnt1 < 14; cnt1++)
 {
  draw_sprite(screen, data[nme2[cnt1]].dat,x1,y1);
  nme[cnt1].x1=x1;
  nme[cnt1].y1=y1;
  nme[cnt1].x2=x1+32;
  nme[cnt1].y2=y1+32;
  x1+=64;
  if (x1>580)
  {
   x1=0;
   y1+=64;
  }
 }
}
  
 
void shw_powers() /* Display available Items on screen */
{
 int x1, y1, cnt1;
 
 x1=0;
 y1=250;
 for (cnt1=139; cnt1 < 174; cnt1++)
 {
  draw_sprite(screen,data[cnt1].dat,x1,y1);
  pwr[cnt1-139].x1=x1;
  pwr[cnt1-139].y1=y1;
  pwr[cnt1-139].x2=x1+16;
  pwr[cnt1-139].y2=y1+16;
  x1+=20;
  if (x1>620)
  {
   x1=0;
   y1+=20;
  }
 }
 y1=350;
 draw_sprite(screen,data[PWR002].dat,x1,y1);
 textout(screen, data[FONT1].dat,"Double Speed", x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR008].dat,x1,y1);
 textout(screen,data[FONT1].dat,"Triple Speed",x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR000].dat,x1,y1);
 textout(screen,data[FONT1].dat, "Reset Timer",x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR017].dat,x1,y1);
 textout(screen,data[FONT1].dat, "Invincible", x1,y1+16,250);
 x1+=200;
 y1=350;
 draw_sprite(screen,data[PWR019].dat,x1,y1);
 textout(screen,data[FONT1].dat, "Double Jump", x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR006].dat,x1,y1);
 textout(screen, data[FONT1].dat, "Reverse Keys",x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR007].dat,x1,y1);
 draw_sprite(screen,data[PWR009].dat,x1+20,y1);
 textout(screen,data[FONT1].dat, "Die in 60 Seconds",x1,y1+16,250);
 y1+=30;
 draw_sprite(screen,data[PWR027].dat,x1,y1);
 textout(screen,data[FONT1].dat, "Cancel all Effects",x1,y1+16,250);
} 

void disp_zoom()
{
 int zx, zy;

 clear(s2);
 for (zx=0; zx<101; zx++)
 {
  for (zy=0; zy<101; zy++)
  {
   if (level[zx][zy]!=-1) putpixel(s2, zx,zy, 255);
  }
 }
 blit(s2, screen, 0,0,537,140,100,100);
}


void disp_submp(BITMAP *s) /* Display Level on Screen */
{
 int ex1, ey1, ex2, ey2, ncc;
 char stat[80];
 clear(s);
 sprintf(stat,"                                  ");
 textout(screen, data[FONT1].dat,stat,400,0,250);
 sprintf(stat, "Xoffset=%d", lxoff);
 textout(screen, data[FONT1].dat,stat, 400,0,250);
 sprintf(stat,"                                  ");
 textout(screen, data[FONT1].dat,stat,400,14,250);
 sprintf(stat, "Yoffset=%d", lyoff);
 textout(screen, data[FONT1].dat,stat, 400,14,250);
 
 ex2=0;
 for (ex1=(0+lxoff); ex1<(21+lxoff); ex1++)
 {
  ey2=0;
  for (ey1=(0+lyoff); ey1<(12+lyoff); ey1++)
   {
    if ((level[ex1][ey1]!=-1) && (level[ex1][ey1]>174)) blit (data[level[ex1][ey1]].dat, s, 0,0,ex2*16,ey2*16,16,16);
    if ((level[ex1][ey1]!=-1) && (level[ex1][ey1]<175)) draw_sprite (s, data[level[ex1][ey1]].dat,ex2*16,(ey2*16)+2);
    for (ncc=1; ncc<(ncount+1); ncc++)
    {
     if ((nasty[ncc].startx==ex1) && (nasty[ncc].starty==ey1))
      {
       draw_sprite (s, data[nme2[nasty[ncc].ntype]].dat,ex2*16,(ey2*16));
      }
     if ((nasty[ncc].endx==ex1) && (nasty[ncc].endy==ey1))
      {
       draw_sprite_h_flip (s, data[nme2[nasty[ncc].ntype]].dat,ex2*16,(ey2*16));
      }
     }
    ey2++;
   } 
   ex2++;
  }   
   
 blit(s, screen, 0,0,0,0,320,200);
 disp_zoom();
}

void grab_tile()
{

int cnt1, cnt2;

for (cnt1=0; cnt1 < 340; cnt1++)
  {
  if ((mouse_x > tile[cnt1].x1) && (mouse_x < tile[cnt1].x2) && (mouse_y > tile[cnt1].y1) &&
      (mouse_y < tile[cnt1].y2)) /* which tile is it? */
   {
    /* make mouse sprite look like tile  */
    show_mouse(NULL); 
    tmouse=cnt1+175; 
    set_mouse_sprite(data[cnt1+175].dat);
    set_mouse_sprite_focus(0,0);
    show_mouse(screen);
   }
  }
}

void grab_nme()
{

int cnt1, cnt2;

for (cnt1=0; cnt1 < 14; cnt1++)
  {
  if ((mouse_x > nme[cnt1].x1) && (mouse_x < nme[cnt1].x2) && (mouse_y > nme[cnt1].y1) &&
      (mouse_y < nme[cnt1].y2)) /* which tile is it? */
   {
    /* make mouse sprite look like item  */
    show_mouse(NULL); 
    subntype=cnt1;
    tmouse=nme2[cnt1]; 
    set_mouse_sprite(data[nme2[cnt1]].dat);
    set_mouse_sprite_focus(0,0);
    show_mouse(screen);
   }
  }
}

void grab_power()
{

int cnt1, cnt2, ncnt;

for (cnt1=0; cnt1 < 40; cnt1++)
  {
  if ((mouse_x > pwr[cnt1].x1) && (mouse_x < pwr[cnt1].x2) && (mouse_y > pwr[cnt1].y1) &&
      (mouse_y < pwr[cnt1].y2)) /* which tile is it? */
   {
    /* make mouse sprite look like item  */
    show_mouse(NULL); 
    tmouse=cnt1+139; 
    set_mouse_sprite(data[cnt1+139].dat);
    set_mouse_sprite_focus(0,0);
    show_mouse(screen);
   }
  }
}



/* Check to see if Mouse Button has been Clicked 
   and trigger appropriate action */
void chk_action(filename)
char *filename;
{
 int cnt1, xoff, yoff, ncnt;


 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>145) &&
     (mouse_y<165) && (edstatus!=1)) /* Pressed "PLACE Tiles" Button */
     {
      edstatus=1;
      show_mouse(NULL);
      clear_to_color(screen,96);
      shw_tiles();
      disp_submp(s);
      disp_scrn(filename);
      show_mouse(screen);
     }
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>170) &&
     (mouse_y<185) && (edstatus!=2)) /* Pressed "PLACE Items" Button */
     {
      edstatus=2;
      show_mouse(NULL);
      clear_to_color(screen,96);
      shw_powers();
      disp_submp(s);
      disp_scrn(filename);
      show_mouse(screen);
     }
  if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>195) &&
     (mouse_y<220) && (edstatus!=3)) /* Pressed "PLACE Enemies" Button */
     {
      edstatus=3;
      show_mouse(NULL);
      clear_to_color(screen,96);
      shw_nmes();
      disp_submp(s);
      disp_scrn(filename);
      show_mouse(screen);
     }    
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>120) &&
     (mouse_y<132)) /* Pressed "Select Start Position" Button */
     {
     show_mouse(NULL);
     tmouse=41; 
     set_mouse_sprite(data[41].dat);
     set_mouse_sprite_focus(0,0);
     show_mouse(screen);
     }
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>42) &&
     (mouse_y<61)) svelevl(filename); /* Pressed "SAVE" button */
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>62) &&
     (mouse_y<81)) /* Pressed "RELOAD" button */
     {
      loadlevl(filename);    
      show_mouse(NULL);
      disp_submp(s);
      show_mouse(screen);
     }
     
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<450) && (mouse_y>220) &&
     (mouse_y<250)) /* Pressed "RESET Cursor" button */
     {
      show_mouse(NULL);
      set_mouse_sprite(NULL);
      show_mouse(screen);
     }
     
 if ((mouse_b & 1) && (mouse_x>400) && (mouse_x<430) && (mouse_y>82) &&
     (mouse_y<101)) tend=1; /* pressed "QUIT" button */
     
 if ((mouse_b & 1) && (mouse_x>0) && (mouse_x<16) && (mouse_y>209) && 
     (mouse_y<227) && (lxoff>0)) /* LMOUSE to move level 'window' left */
   {
   lxoff-=1;
   show_mouse(NULL);
   disp_submp(s);
   show_mouse(screen);
  }
  
 if ((mouse_b & 1) && (mouse_x>299) && (mouse_x<317) && (mouse_y>209) && 
     (mouse_y<227) && (lxoff<(XSIZE-21))) /* LMOUSE to move level 'window' right */
   {
   lxoff+=1;
   show_mouse(NULL);
   disp_submp(s);
   show_mouse(screen);
  } 
  
 if ((mouse_b & 1) && (mouse_x>329) && (mouse_x<347) && (mouse_y>0) && 
     (mouse_y<17) && (lyoff>0)) /* LMOUSE to move level 'window' up */
   {
   lyoff-=1;
   show_mouse(NULL);
   disp_submp(s);
   show_mouse(screen);
  }
  
 if ((mouse_b & 1) && (mouse_x>329) && (mouse_x<347) && (mouse_y>168) && 
     (mouse_y<184) && (lyoff<(YSIZE-13))) /* LMOUSE to move level 'window'down */
   {
   lyoff+=1;
   show_mouse(NULL);
   disp_submp(s);
   show_mouse(screen);
  }   
  
 if ((mouse_b & 2) && (mouse_y<200) && (mouse_x <325) &&
     (edstatus==3)) /* RMOUSE pressed to clear a nasty */
  {
   xoff=(mouse_x/16)+lxoff; 
   yoff=(mouse_y/16)+lyoff;
   for (ncnt=1; ncnt<(ncount+1); ncnt++)
    {
    if (((nasty[ncnt].startx==xoff) && (nasty[ncnt].starty==yoff)) ||  
        ((nasty[ncnt].endx==xoff) && (nasty[ncnt].endy==yoff)))
     {
      nasty[ncnt].ntype=-1;
      nasty[ncnt].startx=-1;
      nasty[ncnt].starty=-1;
      nasty[ncnt].endx=-1;
      nasty[ncnt].endy=-1;
     }
    }
   show_mouse(NULL);
   disp_submp(s);
   show_mouse(screen);
  }
  
 if ((mouse_b & 2) && (mouse_y<200) && (mouse_x < 325)) /* RMOUSE pressed within edit screen - clear tile */
  {
  xoff=(mouse_x/16)+lxoff;
  yoff=(mouse_y/16)+lyoff;
  level[xoff][yoff]=-1;     
  show_mouse(NULL);
  disp_submp(s);
  show_mouse(screen);
  }
 if ((mouse_b & 1) && (mouse_y>250) && (edstatus==1))
    grab_tile(); /* LMOUSE pressed - Grab tile */
 if ((mouse_b & 1) && (mouse_y>250) && (edstatus==2))
    grab_power(); /* LMOUSE pressed - Grab Power */
 if ((mouse_b & 1) && (mouse_y>250) && (edstatus==3))
    grab_nme(); /* LMOUSE pressed - Grab Enemy */
    
 if ((mouse_b & 1) && (mouse_y<200) && (tmouse!=0) && (mouse_x < 325) &&
    (edstatus==3)) /* start and end of nasty travel path */
    {
     if (nstatus==0)
      {
       nstatus++;
       ncount++;
       nasty[ncount].ntype=subntype;
       nasty[ncount].startx=(mouse_x/16)+lxoff;
       nasty[ncount].starty=(mouse_y/16)+lyoff;
       nasty[ncount].endx=-1;
       nasty[ncount].endy=-1;
       show_mouse(NULL);
       disp_submp(s);
       show_mouse(screen);
      }
     else 
      {
       nasty[ncount].endx=(mouse_x/16)+lxoff;
       nasty[ncount].endy=nasty[ncount].starty;
       nstatus=0;
       show_mouse(NULL);
       disp_submp(s);
       show_mouse(screen);
      }
     } 
           
    
 if ((mouse_b & 1) && (mouse_y < 200) && (tmouse!=0) && (mouse_x < 325) &&
    (edstatus!=3))
    {
     xoff=(mouse_x/16)+lxoff;
     yoff=(mouse_y/16)+lyoff;
     level[xoff][yoff]=tmouse;     
     xoff=xoff*16;
     yoff=yoff*16;
     show_mouse(NULL);
     disp_submp(s);
     show_mouse(screen);
    }
  rest(100);
}
 
 
main(argc, argv)
int argc;
char *argv[];
{
  char msg[80];
  int c, cx,cy,x1,y1;
  
  for (c=0; c < 301; c++) /* Initialise all nasty positions to be -1 */
   {
    nasty[c].ntype=-1;
    nasty[c].startx=-1;
    nasty[c].starty=-1;
    nasty[c].endx=-1;
    nasty[c].endy=-1;
   }
  
   if (argc !=2)
    {
     printf("You need to specify a filename!");
     exit(-1);
    }
    
   /* Set up Allegro Units */
   allegro_init();
   install_keyboard(); 
   install_timer();
   install_mouse();
   if (file_exists(argv[1], NULL,NULL)!=0)
    {
     loadlevl(argv[1]);
    }
   else
   {
    nstatus=0;
    ncount=0;
    lxoff=0;
    lyoff=0; /* Initialise all level to be -1 */
    for (cx=0; cx < XSIZE; cx++)
     for (cy=0; cy < YSIZE; cy++) level[cx][cy]=-1;
   }
   for (c=0; c < 401; c++) /* Initialize all tile positions to zero */
   {
    tile[c].x1=0;
    tile[c].y1=0;
    tile[c].x2=0;
    tile[c].y2=0;
   }
   
   for (c=0; c<41; c++) /* Initialize all pwr positions to zero */
   {
    pwr[c].x1=0;
    pwr[c].y1=0;
    pwr[c].x2=0;
    pwr[c].y2=0;
   }
   
   for (c=0; c<16;c++) /* Iniatialize all nmw positions to zero */
   {
    nme[c].x1=0;
    nme[c].y1=0;
    nme[c].x2=0;
    nme[c].y2=0;
   }
   
   /* Load the Allgero datafile */
   data=load_datafile("caveman.dat");
   
   /* Create Main Screen */
   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
   clear_to_color(screen, 96);
   clear_keybuf();
   
   /* Create 'window' for level display */
   s=create_bitmap(320,200);
   s2=create_bitmap(100,100);
   clear(s);
   clear(s2);
   set_pallete(data[PALETTE_01].dat);
   lyoff=87; /* Start at bottom left-hand corner */
   disp_submp(s); /* display the level 'window' */
   shw_tiles(); /* display the available tiles */
   disp_scrn(argv[1]);

   show_mouse(screen);
   tmouse=0;
   tend=0;
   do
   {
   chk_action(argv[1]);
   
   } while (tend==0);
   show_mouse(NULL);


   exit(0);
}
