\BMP2XPL.xpl	24-Mar-2009
\Convert a 320x240, 256-color .BMP file to a 32-bit XPL constant data array.
\Compile with 32-bit XPL0 (xpx.bat)

include	c:\cxpl\codes;		\intrinsic code definitions (including Paint)

def	ImageWidth=320, ImageHeight=240;	\dimensions of Image
def	ImageSize = ImageWidth * ImageHeight;

char	Pal(256*3),		\256-color palette
	Data(ImageSize);	\8 bits per pixel



proc	WriteFile(Name);	\Write palette and image data as constant arrays
char	Name;	\file name
int	H, I;	\handle, index
int	Pal4, Data4;		\access palette and image data 4 bytes at a time
begin
H:= FOpen(Name, 1);			\open file for output and get its handle
FSet(H, ^O);				\set device 3 to output to this handle
OpenO(3);				\initialize output to device 3

\output image palette array
Pal4:= Pal;   Data4:= Data;		\access 4 bytes at a time
Text(3, "Palette:= [
");
for I:= 0, 256*3/4-1 do
	begin
	ChOut(3, ^$);
	HexOut(3, Pal4(I));
	if I # 256*3/4-1 then ChOut(3, ^,);
	if (I&$7) = 7 then CrLf(3);
	end;
Text(3, "];

");

\output image data array
Text(3, "TileImage:= [
");
for I:= 0, ImageSize/4-1 do
	begin
	ChOut(3, ^$);
	HexOut(3, Data4(I));
	if I # ImageSize/4-1 then ChOut(3, ^,);
	if (I&$7) = 7 then CrLf(3);
	end;
Text(3, "];
");
Close(3);
FClose(H);				\release handle
end;	\WriteFile



proc	LoadBmp(Name);	\Load a 256 color .BMP file into Data & Pal
char	Name;		\file name
int	H, I, T, X, Y;	\handle, index, trash, and coordinates
begin
H:= FOpen(Name, 0);			\open file and get its handle
FSet(H, ^I);				\set device 3 to input from this handle
OpenI(3);				\initialize input from device 3
for I:= 0, 53 do T:= ChIn(3);		\skip unused header info
for I:= 0, 255 do			\load Pal array
	begin
	Pal(I*3+2):= ChIn(3)>>2;	\blue
	Pal(I*3+1):= ChIn(3)>>2;	\green
	Pal(I*3+0):= ChIn(3)>>2;	\red
	T:= ChIn(3);			\unused
	end;
for Y:= -(ImageHeight-1), 0 do		\load Data array
    for X:= 0, ImageWidth-1 do		\(.bmp files are upside down!)
	Data(X-Y*ImageWidth):= ChIn(3);
FClose(H);				\release handle
end;	\LoadBmp



begin	\Main
LoadBmp("TILES.BMP");
WriteFile("TILES.XPL");
end;	\Main
