\MakeDict.xpl	19-Apr-2009	Loren Blaney	loren.blaney@idcomm.com
\Program to make the dictionary file for Textris
\Compile with 32-bit XPL (xpx.bat)

include	c:\cxpl\codes;

def	LF=$0A, CR=$0D, EOF=$1A;

int	TotalWords,
	FilteredWords,
	InHand,
	OutHand;



func	ToUpper(Ch);	\Convert character to uppercase
int	Ch;
return if Ch>=^a & Ch<=^z then Ch&$DF else Ch;



proc	Encode;
int	I, N, Len, Ch;
char	Word(12), LastWord(12);
begin
for I:= 0, 12-1 do LastWord(I):= ^X;
loop	begin
	Len:= 0;
	loop	begin		\read in a word
		repeat Ch:= ChIn(3) until Ch # LF;
		if Ch = EOF then return;
		if Ch<^A ! Ch>^Z then quit;
		Word(Len):= Ch;
		Len:= Len+1;
		end;

	\Output the number of first letters that are the same as last word
	N:= 0;
	loop	begin
		if Word(N) # LastWord(N) then quit;
		N:= N+1;
		end;
	IntOut(3, N);

	for I:= N, Len-1 do ChOut(3, Word(I));	\output rest of the letters

	for I:= 0, Len-1 do LastWord(I):= Word(I);
	LastWord(I):= CR;			\terminate string
	end;
end;	\Encode



proc	Filter;		\Filter out all words not between 3 and 7 letters long
int	Len, Ch, I;
char	Word(100);
begin
repeat	Len:= 0;
	loop	begin		\read in a word
		Ch:= ToUpper(ChIn(3));
		if Ch<^A ! Ch>^Z then quit;
		Word(Len):= Ch;
		Len:= Len+1;
		end;
	TotalWords:= TotalWords+1;

	\If it's between 3 and 7 characters long then write it
	if Len>=3 & Len<=7 then
		begin
		for I:= 0, Len-1 do ChOut(3, Word(I));
		CrLf(3);
		FilteredWords:= FilteredWords+1;
		end;
until Ch = EOF;
end;	\Filter



begin	\Main
TotalWords:= 0;
FilteredWords:= 0;

InHand:= FOpen("TWL06.TXT", 0);
FSet(InHand, ^I);
OpenI(3);

OutHand:= FOpen("WORDS37.TXT", 1);
FSet(OutHand, ^O);
OpenO(3);

Text(0, "Filtering word list...
");
Filter;
Close(3);
FClose(InHand);
FClose(OutHand);

Text(0, "Total number of words = ");
IntOut(0, TotalWords);
CrLf(0);
Text(0, "Number of words between 3 and 7 letters = ");
IntOut(0, FilteredWords);
CrLf(0);

InHand:= FOpen("WORDS37.TXT", 0);
FSet(InHand, ^I);
OpenI(3);

OutHand:= FOpen("DICT.XPL", 1);
FSet(OutHand, ^O);
OpenO(3);

Text(3, "Dict:= ^"");
Encode;
Text(3, " ^";
");
Close(3);
FClose(InHand);
FClose(OutHand);
end;	\Main
