\Inv.xpl	24-Jun-2007	Loren Blaney	loren_blaney@idcomm.com
\
\                    Taito Space Invaders Clone
\
\                               
\                              
\                             
\                              
\                            
\                                
\                               
\                                
\
\Converted from a GW-BASIC program by James Eibisch, dated December 2000
\Compile with 16-bit XPL0 (xx.bat)

include	c:\cxpl\codesi;		\include code definitions for intrinsic routines
string 0			\use zero-terminated strings (instead of MSB)

def	ScreenWidth = 256,	\width of CRT screen (pixels)
	ScreenX = 32,		\offset to center CRT screen (pixels)
	ShipWidth = 15,	ShipHeight = 8,	\ship (the player) dimensions (pixels)
	ShipMinX = 50,		\horizontal travel limits (pixels)
	ShipMaxX = 270-ShipWidth,
	BulletHeight = 3,	\height of bullet fired by ship (pixels)
	BulletD = 3,		\speed of bullet fired by ship
	InvWidth = 12,	InvHeight = 8,	\invader sprite dimensions
	InvBombHeight = 5,	\invader's bomb sprite height (pixels)
	InvDirY = 7,		\amount invaders advance toward ship (pixels)
	InvZapTime = 15,	\duration of invader explosion
	SaucerWidth = 16, SaucerHeight = 7,	\flying saucer sprite dimensions
	SaucerY = 28,		\Y coordinate of saucer
	ShelterY = 156,		\Y coordinate of shelters
	ShelterWidth = 24, ShelterHeight = 16,	\dimensions of shelter sprites

	ShipColor = 255,	\color registers used for displaying colors
	BulletColor = 254,	\(they're all set to either green or white)
	BombColor = 253,
	ShipExplodeColor = 252,
	ShelterColor = 251,
	TextColor = 250,
	InvExplodeWhiteColor = 249,
	InvExplodeGreenColor = 248,
	PlanetColor = 247,
	SaucerColor = 246,
	CrtColor = 245,

	InvVoice = 1,		\invader sound channel
	BulletVoice = 2,	\flying bullet sound
	InvZapVoice = 3,	\invader exploding sound
	SaucerVoice = 4,	\flying saucer sound and exploding (hit) sound
	ShipExpVoice = 5;	\ship exploding sound

def	Esc = $1B;		\Escape key

int	II,			\scratch for Main
	BombChance,		\determines rate at which invaders release bombs
	BulletS,		\flag: ship's bullet is traveling on the screen
	BulletSound,		\flag: make bullet sound
	BulletSoundD,		\duration
	BulletX, BulletY,	\flying bullet's coordinates (pixels)
	CanFire,		\flag: bullet can be fired
	ChangedDir,		\left-to-right direction of invaders
	DamageCounter,		\damage to shelter
	Deathroes,		\timer for exploding ship
	Dying,			\flag: ship is exploding
	EndingLevel,		\flag: all invaders have been eliminated
	EndingLevelD,		\duration counter, pauses action at end of level
	EndLevel,		\flag: time duration reached
	GameOver,		\flag: all ships (lives) have been destroyed
	Inv,			\invader array index
	InvAnim,		\0 or 1 to alternate invader images
	InvDirX,		\invader horizontal direction (moves +2 or -2)
	InvLeft,		\number of invaders remaining
	InvNote,		\invader note frequency
	InvNoteTbl,		\table of (4) invader notes
	InvNoteD,		\invader note duration counter
	InvNoteLength,		\invader note duration
	InvNoteS,		\flag: alternates invader notes on and off
	InvZapTicks,		\timer for invader explosion
	InvZapX, InvZapY,	\coordinates of exploded invader 
	Level,			\count of waves of invaders
	Lives,			\number of ships left
	NumBombs,		\number of bombs currently falling
	MaxBombs,		\maximum bombs that can be falling at one time
	SaucerCount,		\number of saucer flights since start of level
	SaucerCycles,		\count of animation frames since saucer flight
	SaucerD,		\duration counter: determines saucer speed
	SaucerDeathroes,	\timer for exploding saucer sound
	SaucerDirX,		\saucer flight direction and speed (+1 or -1)
	SaucerDying,		\flag: saucer is exploding
	SaucerNote,		\note sounds for saucer flight and explosion
	SaucerS,		\flag: saucer is flying
	Score,			\number of points accumulated during game
	ShipX, ShipY,		\ship (player) coordinates
	Shots,			\number of player's shots since start of level
	SwitchOff;		\flag: Esc key has been struck (aborts game)

\arrays to hold sprite images
def	ShipGSize = ShipWidth*ShipHeight+2;	\ship graphic size for sprite
def	InvGSize = InvWidth*InvHeight+2;
char	ShipG(ShipGSize),
	ShipExpG(2, ShipGSize),
	InvG(2*55, InvGSize),
	InvBombG(2, (3*5+2)),
	InvExpG(InvGSize),
	SaucerG(SaucerWidth*SaucerHeight+2),
	ShelterG(ShelterWidth*ShelterHeight+2),
	CharSet(^V-^0+1, (5*7+2));		\incomplete set; see InvData.xpl

int	DamageX(256), DamageY(256),		\damage to shelter
	InvX(56), InvY(56),			\coordinates for each invader
	InvS(56),				\invader is alive
	BombX(21), BombY(21),			\coordinates for dropping bombs
	BombS(21),				\bomb is falling
	BombType(21);				\slow bombs or fast rays



func	StrLen(Str);		\Returns the number of characters in a string
char	Str;			\Str must be <= 32766 characters long
int	I;
for I:= 0, 32766 do
	if Str(I) = 0 then return I;



proc	WaitVB;			\Wait for start of vertical blank
begin				\(actually waits for start of vertical retrace)
while port($3DA) & $08 do [];	\wait for vertical retrace to go away
repeat until port($3DA) & $08;	\wait for vertical retrace
end;	\WaitVB



proc	DrawRectangle(X0, Y0, W, H, C);	\Draw a filled rectangle
int	X0, Y0, W, H,	\upper left corner coordinates, width, height (pixels)
	C;		\color
int	Y;
begin
for Y:= Y0, Y0+H-1 do
	[Move(X0, Y);   Line(X0+W-1, Y, C)];
end;	\DrawRectangle



proc	DrawSprite(X0, Y0, Sp, Trans);	\Draw a sprite
int	X0, Y0;	\coordinates of upper-left corner
char	Sp;	\address of sprite data
int	Trans;	\flag: make (0) background transparent (instead of opaque)
int	X, Y, C,
	W, H;	\width and height of sprite (pixels)
begin
W:= Sp(0);
H:= Sp(1);
Sp:= Sp + 2;
for Y:= Y0, Y0+H-1 do
    for X:= X0, X0+W-1 do
	begin
	C:= Sp(0);			\get pixel's color
	Sp:= Sp + 1;
	if C ! ~Trans then Point(X, Y, C);
	end;
end;	\DrawSprite



proc	GetSprite(X0, Y0, W, H, Sp);	\Load sprite data array from Screen
int	X0, Y0,		\coordinates in Screen to get sprite from
	W, H;		\width and height of sprite (pixels)
char	Sp;		\address of array in which to load sprite data
int	X, Y;
begin
Sp(0):= W;
Sp(1):= H;
Sp:= Sp + 2;
for Y:= Y0, Y0+H-1 do
    for X:= X0, X0+W-1 do
	begin
	Sp(0):= ReadPix(X, Y);
	Sp:= Sp + 1;
	end;
end;	\GetSprite



proc	ClearScreen;			\Clear the CRT "Screen" area
begin
Clear;
DrawRectangle(ScreenX, 0, ScreenWidth, 200-1, CrtColor);
end;	\ClearScreen



proc	ClearScreen2Crt;		\Clear entire screen to CRT color
DrawRectangle(0, 0, 320-1, 200-1, CrtColor);



proc	SetColor(Color, R, G, B);	\Set up color register
int	Color, R, G, B;
begin
port($3C6):= $FF;
port($3C8):= Color;
port($3C9):= R;
port($3C9):= G;
port($3C9):= B;
end;	\SetColor



proc	Delay(T);			\Delay T 1/18ths of a second
int	T;
int	N;
begin
for N:= 0, T-1 do
	Sound(0, 1, 1);
	if ChkKey then
	  if ChIn(1) = Esc then [SwitchOff:= true;  return];
end;	\Delay



proc	DisplayString(X, Y, Str);
int	X, Y;	\coordinates at upper-left corner of string
char	Str;	\string: WARNING: Not all characters are available
int	I, Ch;
begin
for I:= 0, StrLen(Str)-1 do
	begin
	Ch:= Str(I);
	if Ch # $20 \space\ then 
		DrawSprite(ScreenX+X+I*8, Y, addr CharSet(Ch-$30,0), false)
	else	DrawRectangle(ScreenX+X+I*8, Y, 5, 7, CrtColor);
	end;
end;	\DisplayString



proc	DisplayLife(Life, Visible);	\Display the number of ships remaining
int	Life, Visible;
int	X, Y;
begin
X:= ScreenX + 16*8 + (Life-1)*ShipWidth*3/2;
Y:= 3*8/2;
if Visible then
	DrawSprite(X, Y, ShipG, false)
else	DrawRectangle(X, Y, ShipWidth, ShipHeight, CrtColor);
end;	\DisplayLife



proc	DisplayScore;			\Display the accumulated points
int	S, I;
begin
S:= Score;
for I:= -3, 0 do
	begin
	S:= S/10;
	DrawSprite(ScreenX-I*8, 9, addr CharSet(rem(0),0), false);
	end;
end;	\DisplayScore



proc	DrawPlanet;			\Merely a horizontal line
begin
DrawRectangle(ScreenX, 200-1, ScreenWidth, 1, PlanetColor);
end;	\DrawPlanet



proc	DrawShelters(Visible);		\Draw (or erase) shelters
int	Visible;
int	N, X, ShelterSpace, XStep;
begin
ShelterSpace:= ShipMaxX + ShipWidth/10 - (ShipMinX + ShipWidth*9/10);
XStep:= (ShelterSpace - 4*ShelterWidth)/3 + ShelterWidth;

for N:= 0, 4-1 do
	begin
	X:= ShipMinX + ShipWidth*9/10 + N*XStep;
	if Visible then
	      DrawSprite(X, ShelterY, ShelterG, false)
	else  DrawRectangle(X, ShelterY, ShelterWidth, ShelterHeight, CrtColor);
	end;
end;	\DrawShelters



proc	ErodeShelter(X, Y);		\Due to invader bomb damage
int	X, Y;
int	N;
begin
for N:= 1, 35 do
  Point(X+DamageX(DamageCounter+N)-2, Y+DamageY(DamageCounter+N+1)-4, CrtColor);
DamageCounter:= DamageCounter + 20;
if DamageCounter > 255-N then DamageCounter:= 0;
end;	\ErodeShelter



proc	IncScore(ScoreGain);		\Increment score
int	ScoreGain;
begin
Score:= Score + ScoreGain;
if Score>=1000 & Score<1000+ScoreGain then
	begin				\extra ship at 1000 points
	Lives:= Lives + 1;
	DisplayLife(Lives, true);
	end;
DisplayScore;
end;	\IncScore

\===============================================================================

proc	DefineGraphics;			\Set up sprite images
int	I, X, Y,
	Data, DI,	\image data array, index into data array
	InvType, Anim, Rows, ArrayInx, InvColor,
	Ch;
char	Str;
begin
include InvData;
DI:= 0;


ClearScreen2Crt;					\define ship
for Y:= 0, ShipHeight-1 do	\convert "#" in data array to points on screen
	begin
	Str:= Data(DI);
	DI:= DI+1;
	for X:= 0, ShipWidth-1 do
		if Str(X) = ^# then Point(X, Y, ShipColor);
	end;
GetSprite(0, 0, ShipWidth, ShipHeight, ShipG);		\save screen image


for I:= 0, 2-1 do					\define ship explosions
	begin
	DrawRectangle(0, 0, ShipWidth, ShipHeight, CrtColor);	\erase image
	for Y:= 0, ShipHeight-1 do
		begin
		Str:= Data(DI);
		DI:= DI+1;
		for X:= 0, ShipWidth-1 do
			if Str(X) = ^# then Point(X, Y, ShipExplodeColor);
		end;
	GetSprite(0, 0, ShipWidth, ShipHeight, addr ShipExpG(I,0));
	end;


ClearScreen2Crt;					\define invaders
for InvType:= 0, 3-1 do			\3 kinds of invaders
    for Anim:= 0, 2-1 do		\each with 2 different positions
	begin
	DrawRectangle(0, 0, InvWidth, InvHeight, CrtColor);	\erase image
	for Y:= 0, InvHeight-1 do
		begin
		Str:= Data(DI);
		DI:= DI+1;
		for X:= 0, InvWidth-1 do
			if Str(X) = ^# then Point(X, Y, 255);
		end;

	Rows:= 2;			\most invaders get two rows each
	if InvType = 2 then Rows:= 1;	\top invaders get a single row
	for Inv:= InvType*22, InvType*22+Rows*11-1 do
		begin				\0..21, 22..43, 44..54
		ArrayInx:= Inv*2 + Anim;	\0..109
		\55 versions of white distinguish each invader by its color
		InvColor:= Inv*2 + 1;		\1..109
		SetColor(InvColor, 63, 63, 63);
		for Y:= 0, InvHeight-1 do
		    for X:= 0, InvWidth-1 do
			if ReadPix(X, Y) # CrtColor then Point(X, Y, InvColor);
		GetSprite(0, 0, InvWidth, InvHeight, addr InvG(ArrayInx,0));
		end;
	end;


ClearScreen2Crt;				       \define invader explosion
for Y:= 1, InvHeight do
	begin
	Str:= Data(DI);
	DI:= DI+1;
	for X:= 0, InvWidth-1 do
		if Str(X) = ^# then Point(X, Y, InvExplodeWhiteColor);
	end;
GetSprite(0, 0, InvWidth, InvHeight, InvExpG);


ClearScreen2Crt;					\define bombs
for I:= 0, 2-1 do
	begin
	for Y:= 0, InvBombHeight-1 do
		begin
		Str:= Data(DI);
		DI:= DI+1;
		for X:= 0, 3-1 do
			if Str(X) = ^# then Point(X, Y, BombColor);
		end;
	GetSprite(0, 0, 3, InvBombHeight, addr InvBombG(I,0));
	ClearScreen2Crt;
	end;


ClearScreen2Crt;					\define Saucer
for Y:= 0, SaucerHeight-1 do
	begin
	Str:= Data(DI);
	DI:= DI+1;
	for X:= 0, SaucerWidth-1 do
		if Str(X) = ^# then Point(X, Y, SaucerColor);
	end;
GetSprite(0, 0, SaucerWidth, SaucerHeight, SaucerG);


ClearScreen2Crt;					\define shelter
for Y:= 0, ShelterHeight-1 do
	begin
	Str:= Data(DI);
	DI:= DI+1;
	for X:= 0, ShelterWidth-1 do
		if Str(X) = ^# then Point(X, Y, ShelterColor);
	end;
GetSprite(0, 0, ShelterWidth, ShelterHeight, ShelterG);


ClearScreen2Crt;					\define character set
for I:= 0, 21-1 do			\note that many characters are missing
	begin
	Ch:= Data(DI);
	DI:= DI+1;
	for Y:= 0, 7-1 do
		begin
		Str:= Data(DI);
		DI:= DI+1;
		for X:= 0, 5-1 do
			if Str(X) = ^# then Point(X, Y, TextColor);
		end;
	GetSprite(0, 0, 5, 7, addr CharSet(Ch-^0,0));
	DrawRectangle(0, 0, 5, 7, CrtColor);
	end;
ClearScreen2Crt;
end;	\DefineGraphics

\=========================== SOUND BLASTER ROUTINES ============================
\This uses the FM registers (which unfortunately have gone the way of the
\ dinosaur and are generally not supported on newer computers).

proc	SBWriteReg(Reg, Byte);
int	Reg, Byte;
int	I, T;
begin
port($388):= Reg;
for I:= 0, 5 do T:= port($388);		\delay at least 3.3usec
port($389):= Byte;
for I:= 0, 34 do T:= port($388);	\delay at least 23usec
end;	\SBWriteReg



func	SBVoice2Reg(Voice);
int	Voice;
int	Offset;
begin
if Voice <= 3 then Offset:= -1
else if Voice <= 6 then Offset:= 4
else Offset:= 9;
return Voice + Offset;
end;	\SBVoice2Reg



proc	SBVolume(Voice, Volume);
int	Voice, Volume;
SBWriteReg($43+SBVoice2Reg(Voice), $3F-Volume);



proc	SBModulate(Voice, Volume);
int	Voice, Volume;
SBWriteReg($40+SBVoice2Reg(Voice), $3F-Volume);



proc	SBVoiceOff(Voice);
int	Voice;
SBWriteReg($B0-1+Voice, 0);



proc	SBSetupVoice(Voice);		\Sets up one voice
int	Voice;
begin
\modulator volume  = silent
\modulator attack  = fastest
\modulator decay   = slowest
\modulator sustain = medium
\modulator release = medium
\tone volume       = loudest
\tone attack       = fastest
\tone decay        = slowest
\tone sustain      = medium
\tone release      = medium

SBWriteReg($20+SBVoice2Reg(Voice), $01);
SBWriteReg($40+SBVoice2Reg(Voice), $3F);
SBWriteReg($60+SBVoice2Reg(Voice), $F0);
SBWriteReg($80+SBVoice2Reg(Voice), $77);
SBWriteReg($23+SBVoice2Reg(Voice), $01);
SBWriteReg($43+SBVoice2Reg(Voice), $00);
SBWriteReg($63+SBVoice2Reg(Voice), $F0);
SBWriteReg($83+SBVoice2Reg(Voice), $77);
end;	\SBSetupVoice



proc	SBPlayNote(Voice, Octave, Note);
int	Voice, Octave, Note;
begin
SBWriteReg($A0-1 + Voice,  Note & $00FF);
SBWriteReg($B0-1 + Voice,  $20 \KeyOn\ ! Octave<<2 ! (Note>>8 & $03));
end;	\SBPlayNote



proc	SBResetCard;
int	I;
for I:= 1, $F5 do SBWriteReg(I, 0);

\===============================================================================

proc	NextCycle;		\Next frame of animation
int	I, A, B, T, X,
	Keys,
	Tbl,
	SaucerX,		\flying saucer horizontal position (pixels)
	SaucerScore,		\number of points for shooting flying saucer
	Obstructed;		\only the bottom-most invader can drop bombs
begin
WaitVB;				\regulate speed

\move invaders
if not Dying & not EndingLevel & InvZapTicks=0 then
	begin
	Inv:= Inv + 1;			\next invader
	if Inv = 56 then		\if all 55 invaders have moved then...
		begin
		Inv:= 1;			\start again with first one
		InvAnim:= InvAnim | $01;	\use alternate invader image
		case ChangedDir of
		  1:	ChangedDir:= 2;
		  2:	begin
			InvDirX:= -InvDirX;	\reverse horizontal direction
			ChangedDir:= 0;
			end
		other	[];
		end;

	while InvS(Inv) = false do	\skip over dead invaders
		begin
		Inv:= Inv + 1;		\next invader
		if Inv = 56 then	\if all 55 invaders have moved then...
			begin
			Inv:= 1;	\start again with first one
			InvAnim:= InvAnim | $01;
			case ChangedDir of
			  1:	ChangedDir:= 2;
			  2:	begin
				InvDirX:= -InvDirX;
				ChangedDir:= 0;
				end
			other	[];
			end;
		end;

	DrawRectangle(InvX(Inv), InvY(Inv), InvWidth, InvHeight, CrtColor);

	if ChangedDir = 2 then
	     begin
	     InvY(Inv):= InvY(Inv) + InvDirY;		\move down a row
	     if InvY(Inv) > ShipY - InvHeight then	\invaders reached bottom
		begin
		Lives:= 1;				\game over
		DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);
		Dying:= true;
		Deathroes:= 0;
		end;
	     end
	else begin
	     InvX(Inv):= InvX(Inv) + InvDirX;		\move horizontally
	     if InvX(Inv) <= ShipMinX-InvWidth ! InvX(Inv) >= ShipMaxX+ShipWidth
	        then ChangedDir:= 1;
	     end;
	DrawSprite(InvX(Inv), InvY(Inv), addr InvG((Inv-1)*2+InvAnim,0), false);
	end;

\invader move sound: plays 4 notes, each separated by silence (staccato)
InvNoteD:= InvNoteD - 1;	\decrement note duration timer
if InvNoteD = 0 then		\timed out
	begin
	if InvNoteS then	\if note was playing
		begin
		if InvLeft > 11 then SBVoiceOff(InvVoice);	\turn it off
		InvNoteD:= InvLeft - InvNoteLength;		\reset duration
		if InvNoteD < 1 then InvNoteD:= 1;
		end
	else	begin
		if InvLeft>0 & not Dying & not EndingLevel then
			begin
			SBPlayNote(InvVoice, 1, InvNoteTbl(InvNote)); \play note
			InvNote:= InvNote+1 & $03;		\cycle 4 notes
			end;
		InvNoteD:= InvNoteLength;
		end;
	InvNoteS:= not InvNoteS;
	end;

\drop bomb
if not Dying & not EndingLevel then
	begin
	if NumBombs<MaxBombs & Ran(100)>BombChance then
		begin
		Obstructed:= false;	\only bottom invader gets to drop bombs
		I:= Inv - 11;
		while I >= 1 do
			begin
			if InvS(I) then
				begin
				Obstructed:= true;
				I:= 1;
				end;
			I:= I - 11;
			end;

		if not Obstructed then
			begin
			I:= 1;
			while BombS(I) do I:= I + 1;
			BombX(I):= InvX(Inv) + 5;
			BombY(I):= InvY(Inv) + 8;
			BombS(I):= true;
			if Ran(100) > 85 then
				BombType(I):= 1
			else	BombType(I):= 0;
			NumBombs:= NumBombs + 1;
			end;
		end;
	end;

\move bombs
for I:= 1, MaxBombs do			\for all the falling bombs...
    if BombS(I) then
	begin
	DrawRectangle(BombX(I), BombY(I), 3, 5, CrtColor);	\erase old posn.

	if BombType(I) = 0 then
		BombY(I):= BombY(I) + 1
	else	BombY(I):= BombY(I) + 2;		\rays fall twice as fast
	A:= ReadPix(BombX(I), BombY(I) + 5);		\see what bomb hits
	B:= ReadPix(BombX(I) + 2, BombY(I) + 5);
	if BombY(I) > 194 then				\off bottom of screen
		begin
		BombS(I):= false;
		NumBombs:= NumBombs - 1;
		end
	else if A = ShelterColor ! B = ShelterColor then \hit shelter
		begin
		ErodeShelter(BombX(I), BombY(I) + 7);
		BombS(I):= false;
		NumBombs:= NumBombs - 1;
		end
	else if A = ShipColor ! B = ShipColor then	\hit ship
		begin
		BombS(I):= false;
		NumBombs:= NumBombs - 1;
		DisplayLife(Lives, false);
		DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);

		SBVoiceOff(InvVoice);
		Dying:= true;
		Deathroes:= 0;
		end
	else	DrawSprite(BombX(I), BombY(I), addr InvBombG(BombType(I),0),
			false);				\draw bomb at new posn.
	end;

\launch saucer
if not SaucerS & not SaucerDying then
	begin
	if SaucerCycles=25*70 & InvLeft>9 then
		begin
		if Ran(2) \=1\ then			\randomly select side
			begin				\ that saucer enters
			SaucerX:= ScreenX;
			SaucerDirX:= 1;
			end
		else	begin
			SaucerX:= ScreenX + ScreenWidth - SaucerWidth;
			SaucerDirX:= -1;
			end;
		SaucerNote:= $202;
		SaucerD:= 1;
		SaucerS:= true;
		SaucerCount:= SaucerCount + 1;
		end;
	end;

\move saucer
if SaucerS then
    begin
    SaucerD:= SaucerD - 1;
    if SaucerD = 0 then
	begin
	DrawRectangle(SaucerX, SaucerY, SaucerWidth, SaucerHeight, CrtColor);
	SaucerX:= SaucerX + SaucerDirX;
	if SaucerX > ScreenX+ScreenWidth-SaucerWidth ! SaucerX < ScreenX then
		begin				\exited screen
		SBVoiceOff(SaucerVoice);
		SaucerS:= false;
		SaucerCycles:= 0;
		end
	else	begin
		DrawSprite(SaucerX, SaucerY, SaucerG, false);
		SaucerNote:= SaucerNote - 15;
		if SaucerNote < $1B0 then SaucerNote:= $202;
		SBPlayNote(SaucerVoice, 5, SaucerNote);
		SaucerD:= 2;			\move every other time
		end;
	end;
    end;

\explode saucer
if SaucerDying then
	begin
	SaucerDeathroes:= SaucerDeathroes - 1;
	if SaucerDeathroes = 0 then
		begin
		DrawRectangle(SaucerX, SaucerY, 3*8, 1*9, CrtColor);
		SBVoiceOff(SaucerVoice);
		SaucerCycles:= 0;
		SaucerDying:= false;
		end
	else	begin
		SaucerNote:= SaucerNote + 4;
		if SaucerNote > $202 then SaucerNote:= $1B0;
		SBPlayNote(SaucerVoice, 4, SaucerNote);
		end;
	end;

\move player and fire Bullet
if not Dying then
	begin
	Keys:= Peek(0, $417);	\keyboard shift flags
	DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);
	if (Keys & 4) & ShipX > ShipMinX then ShipX:= ShipX - 1;
	if (Keys & 8) & ShipX < ShipMaxX then ShipX:= ShipX + 1;
	DrawSprite(ShipX, ShipY, ShipG, false);

	if CanFire & (Keys & 1) & BulletS=false & InvZapTicks=0 then
		begin
		BulletX:= ShipX + 7;
		BulletY:= ShipY - BulletHeight;
		BulletSound:= true;
		BulletSoundD:= 10;
		BulletS:= true;
		Shots:= Shots + 1;
		end;
	CanFire:= (BulletS=false) & (InvZapTicks=0) & (Keys & 1) = 0;
	end;

\move bullet
if BulletS then
    begin
    DrawRectangle(BulletX, BulletY, 1, BulletHeight, CrtColor);
    BulletY:= BulletY - BulletD;
    if BulletSound then
	begin
	BulletSoundD:= BulletSoundD - 1;
	if BulletSoundD = 0 then
		begin
		SBVoiceOff(BulletVoice);
		BulletSound:= false;
		end
	else	SBPlayNote(BulletVoice, 5, Ran(255)+256);
	end;
    if BulletY < SaucerY then BulletS:= false
    else begin
	 A:= ReadPix(BulletX, BulletY);
	 B:= ReadPix(BulletX, BulletY+2);
	 if A>0 & A<111 ! B>0 & B<111 then
		begin
		BulletSound:= false;
		SBVoiceOff(BulletVoice);
		if A = CrtColor then A:= B;
		A:= (A-1)/2 + 1;
		InvS(A):= false;
		InvLeft:= InvLeft - 1;
		InvZapX:= InvX(A);
		InvZapY:= InvY(A);
		DrawRectangle(InvZapX, InvZapY, InvWidth, InvHeight, CrtColor);
		DrawSprite(InvZapX, InvZapY, InvExpG, false);

		InvZapTicks:= InvZapTime;
		if InvLeft > 11 then
			InvNoteLength:= 12
		else if InvLeft > 0 then
			begin
			Tbl:= [6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11];
			InvNoteLength:= Tbl(InvLeft-1);
			end
		else	SBVoiceOff(InvVoice);

		case of
		 A<=22:	IncScore(10);
		 A<=44:	IncScore(20)
		other	IncScore(30);

		BulletS:= false;
		end
	else if A = ShelterColor then
		begin
		ErodeShelter(BulletX, BulletY);
		BulletSound:= false;
		SBVoiceOff(BulletVoice);
		BulletS:= false;
		end
	else if A=SaucerColor ! B=SaucerColor then
		begin
		DrawRectangle(SaucerX, SaucerY, SaucerWidth, SaucerHeight, CrtColor);
		if Shots=23 & SaucerCount=1 ! Shots=15 & SaucerCount>=2 then
			SaucerScore:= 300
		else	SaucerScore:= (Ran(3)+1) * 50;

		T:= SaucerScore;
		X:= SaucerX + 2*8;
		repeat	T:= T/10;
			DrawSprite(X, SaucerY, addr CharSet(rem(0),0), false);
			X:= X - 8;
		until T = 0;

		IncScore(SaucerScore);
		SaucerS:= false;
		SaucerDying:= true;
		SaucerDeathroes:= 120;
		SaucerNote:= $1B0;
		BulletS:= false;
		Shots:= 0;
		end
	else	DrawRectangle(BulletX, BulletY, 1, BulletHeight, BulletColor);
	end;
    end;

\explode ship
if Dying then
    begin
    Deathroes:= Deathroes + 1;
    if Deathroes < 130 ! NumBombs > 0 then
	begin
	DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);
	DrawSprite(ShipX, ShipY, addr ShipExpG((Deathroes&4)/4,0), false);
	SBPlayNote(ShipExpVoice, 1, Ran(255)+$100);
	end
    else begin
	 SBVoiceOff(ShipExpVoice);
	 SBVoiceOff(SaucerVoice);
	 DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);
	 Dying:= false;
	 Lives:= Lives - 1;
	 if Lives = 0 then
		begin
		SBVoiceOff(InvVoice);
		GameOver:= true;
		end
	 else	begin
		ShipX:= ShipMinX;
		ShipY:= 199 - ShipHeight*2;
		Delay(18);
		end;
	 end;
    end;

\count down exploding invader
if InvZapTicks \#0\ then
	begin
	InvZapTicks:= InvZapTicks - 1;
	SBPlayNote(InvZapVoice, 6, $280+InvZapTicks*40);
	if InvZapTicks = 0 then
		begin
		SBVoiceOff(InvZapVoice);
		DrawRectangle(InvZapX, InvZapY, InvWidth, InvHeight, CrtColor);
		if InvLeft = 0 then
			begin
			EndingLevel:= true;
			EndingLevelD:= 0;
			end;
		end;
	end;

\counting down at end of level
if EndingLevel then
	begin
	EndingLevelD:= EndingLevelD + 1;
	if EndingLevelD>200 & NumBombs=0 & not BulletS & Dying=false then
		begin
		DrawRectangle(ShipX, ShipY, ShipWidth, ShipHeight, CrtColor);
		EndingLevel:= false;
		EndLevel:= true;
		end;
	end;

if ChkKey then
    if ChIn(1) = Esc then SwitchOff:= true;

SaucerCycles:= SaucerCycles + 1;
end;	\NextCycle

\-------------------------------------------------------------------------------

proc	NextLevel;	\next wave of invaders
int	I, X, Y;
char	Str;
begin
DrawPlanet;
if Level < 5 then DrawShelters(true);
MaxBombs:= MaxBombs - (MaxBombs < 20);		\trick to increment up to 20
BombChance:= BombChance + (BombChance > 80);	\trick to decrement down to 80
ShipX:= ShipMinX;
ShipY:= 199 - ShipHeight*2;
CanFire:= false;
SaucerS:= false;
Inv:= 1;
for Y:= 0, 4 do
    for X:= 0, 10 do
	begin
	InvX(Inv):= ShipMinX + ShipWidth + X*16;
	InvY(Inv):= ShipY - 2 - InvHeight - (6-Level)*14 - Y*14;
	InvS(Inv):= true;
	Inv:= Inv + 1;
	end;

InvLeft:= 55;
Inv:= 0;
InvAnim:= 0;
InvNote:= 0;
InvNoteLength:= 12;
InvNoteD:= 1;
InvNoteS:= true;
InvDirX:= 2;
ChangedDir:= 0;
NumBombs:= 0;
for I:= 1, MaxBombs do BombS(I):= false;
EndingLevel:= false;
Delay(11);
SaucerCycles:= 0;
Shots:= 0;
SaucerCount:= 0;

while not EndLevel & not GameOver & not SwitchOff do NextCycle;

if GameOver then
    begin
    Str:= "GAME OVER";
    for I:= 0, StrLen(Str)-1 do
	begin
	if Str(I) # $20 then
	     DrawSprite(ScreenX+(11+I)*8, 4*9, addr CharSet(Str(I)-^0,0), false)
	else DrawRectangle(ScreenX+(11+I)*8, 4*9, 5, 7, CrtColor);
	Delay(3);
	end;
    Delay(54);
    end;

if EndLevel then
	begin
	DrawPlanet;
	DrawShelters(false);
	Delay(16);
	Level:= Level + 1;
	if Level > 6 then Level:= 6;
	EndLevel:= false;
	end;
end;	\NextLevel

\===============================================================================

begin	\Main
SetVid($13);				\320x200 graphics in 256 colors

Dying:= false;
SaucerDying:= false;
InvZapTicks:= 0;
BulletS:= false;

SetColor(ShipColor, 0, 63, 0);		\green (R,G,B)
SetColor(BulletColor, 63, 63, 63);	\white
SetColor(BombColor, 63, 63, 63);
SetColor(ShipExplodeColor, 0, 63, 0);
SetColor(ShelterColor, 0, 63, 0);
SetColor(TextColor, 63, 63, 63);
SetColor(InvExplodeWhiteColor, 63, 63, 63);
SetColor(InvExplodeGreenColor, 0, 63, 0);
SetColor(PlanetColor, 0, 63, 0);
SetColor(SaucerColor, 63, 0, 0);
SetColor(CrtColor, 14, 14, 14);

for II:= 0, 255 do
	begin
	DamageX(II):= Ran(4);
	DamageY(II):= Ran(6);
	end;

InvNoteTbl:= [$2AE,$287,$263,$241];	\bom, bom, bom, bom
SBResetCard;
for II:= 1, 5 do SBSetupVoice(II);
SBModulate(InvVoice, 40);
SBModulate(BulletVoice, 45);
SBVolume(BulletVoice, 45);
SBModulate(InvZapVoice, 20);
SBVolume(InvZapVoice, 53);
SBVolume(SaucerVoice, 55);
SBModulate(ShipExpVoice, 63);

DefineGraphics;

Score:= 0;
SwitchOff:= false;
while not SwitchOff do			\display opening screen until keystroke
	begin
	ClearScreen;
	OpenI(0);			\flush keyboard buffer

	DisplayString(0, 0, "SCORE");
	DisplayScore;

	loop	begin
		WaitVB;
		DisplayString(11*8, 10*9, "GAME OVER");
		for II:= 1, 2 do WaitVB;
		DisplayString(11*8, 10*9, "         ");
		if ChkKey then
			begin
			SwitchOff:= ChIn(1) = Esc;
			quit;
			end;
		end;

	if not SwitchOff then		\start game
		begin
		Score:= 0;
		Lives:= 3;
		Level:= 1;
		DamageCounter:= Ran(200);
		MaxBombs:= 12;
		BombChance:= 95;
		GameOver:= false;
		ClearScreen;
		DisplayString(0, 0, "SCORE");
		DisplayScore;
		DisplayString(16*8, 0, "LIVES");
		for II:= 1, Lives do DisplayLife(II, true);
		end;

	while not GameOver & not SwitchOff do NextLevel;	\play game
	end;

for II:= 1, 5 do SBVoiceOff(II);	\turn off all sounds
SBResetCard;

SetVid(3);				\restore normal text screen
end;	\Main
