unit sound;

interface

uses
	timer;

const
	sound_none=0;
	sound_pcSpeaker=1;
	sound_tandy=2;

	tandyFreq=3579545;
	tandyDivider=tandyFreq/32;
	tandyIntDivider=round(tandyDivider);

	notes:array[1..84] of word=(
		{ C   C#,D-   D   D#,E-   E     F   F#,G-   G   G#,A-   A   A#,B-   B }
		0065, 0070, 0073, 0078, 0082, 0087, 0093, 0098, 0104, 0110, 0117, 0123,
		0131, 0139, 0147, 0156, 0165, 0175, 0185, 0196, 0208, 0220, 0233, 0247,
		0262, 0277, 0294, 0311, 0330, 0349, 0370, 0392, 0415, 0440, 0466, 0494,
		0523, 0554, 0587, 0622, 0659, 0698, 0740, 0784, 0831, 0880, 0932, 0987,
		1047, 1109, 1175, 1245, 1329, 1397, 1480, 1568, 1661, 1760, 1865, 1976,
		2093, 2217, 2349, 2489, 2637, 2794, 2960, 3136, 3322, 3520, 3729, 3951,
		4186, 4435, 4699, 4978, 5274, 5588, 5920, 6272, 6645, 7040, 7459, 7902
	);

var
	blaster_basePort:word;

procedure startSound;
procedure killSound;
procedure setVoice(iChannel,iFreq,iLevel,iPriority:word);

implementation

const
	SPK_Control=$61;

type
	voice=record
		freq,
		priority:word;
	end;

var
	soundSource:word;
	soundActive:boolean;
	voiceTable:array[0..2] of voice;

	oldExitProc:pointer;

	blaster_reset,
	blaster_read,
	blaster_write,
	blaster_dataWaiting:word;

procedure speakerSound(interval:word); assembler;
asm
	mov  ax,interval
	cmp  ax,0
	jnz  @setLevel
	{ speaker off }
	in   al,SPK_Control
	and  al,$FC;
	out  SPK_Control,al
	ret
@setLevel:
  { speaker on }
	in   al,SPK_Control
	or   al,$03
	out  SPK_Control,al
	mov  al,PIT_Select2 or PIT_LSBMSB or PIT_Mode3
	out  PIT_Control,al
	mov  ax,interval
	out  PIT_Data2,al
	mov  al,ah
	out  PIT_Data2,al
end;

procedure tandySound(voice:byte; tone:word; level:byte); assembler;
asm

{	port[$C0]:=$80 or (voice*$20) or (tone and $0F); }

	mov  dx,$C0

	mov  cl,voice
	mov  al,$10
	shl  al,cl
	and  al,$60
	or   al,$80
	mov  ch,al { save channel for level set }
	mov  bx,tone
	mov  ah,bl
	and  ah,$0F
	or   al,ah
	out  dx,al

{	port[$C0]:=tone shr 4; }

	shr  bx,1
	shr  bx,1
	shr  bx,1
	shr  bx,1
	mov  al,bl
	out  dx,al

{	port[$C0]:=$90 or (voice*$20) or (level and $0F); }

	mov  al,level
	and  al,$0F
	or   al,ch
	or   al,$10
	out  dx,al

end;

procedure setVoice(iChannel,iFreq,iLevel,iPriority:word);
var
	outFreq,
	testPriority,
	t:word;
begin
	with voiceTable[iChannel] do begin
		freq:=iFreq;
		priority:=iPriority+1;
	end;
	case soundSource of
		sound_pcSpeaker:begin
			testPriority:=0;
			for t:=0 to 2 do with voiceTable[t] do begin
				if priority>testPriority then begin
					testPriority:=priority;
					outFreq:=freq;
				end;
			end;
			if (outFreq=0) then begin
				speakerSound(1);
			end else speakerSound(intClock8253 div outFreq);
		end;
		sound_tandy:begin
			if (iFreq>0) then begin
				tandySound(iChannel,tandyIntDivider div iFreq,15-round(iLevel/4.2));
			end else tandySound(iChannel,0,15);
		end;
	end;
end;

procedure setNote(iChannel,iNote,iLevel,iPriority:word);
begin
	case soundSource of
		sound_pcSpeaker,
		sound_tandy:begin
			setVoice(iChannel,notes[iNote],iLevel,iPriority);
		end;
	end;
end;

procedure startSound;
var
	t:integer;
	d:word;
begin
	for t:=0 to 2 do with voiceTable[t] do begin
		freq:=1;
		priority:=0;
	end;
	case soundSource of
		sound_tandy:asm
			{ 1k/jr }
			mov  ax,$8003
			int  $1A
			{ manually set for older machines just in case }
			mov  al,$6C
			out  $61,al
			mov  ax,$8003
			int  $1A
		end;
	end;
	soundActive:=true;
end;

procedure killSound;
begin
	case soundSource of
		sound_pcSpeaker:asm
			{ speaker off }
			in   al,SPK_Control
			and  al,$FC;
			out  SPK_Control,al
		end;
		sound_tandy:asm
			mov  dx,$C0
			mov  al,$9F
			out  dx,al
			mov  al,$BF
			out  dx,al
			mov  al,$DF
			out  dx,al
		end;
	end;
	soundActive:=false;
end;

procedure safeExit; far;
begin
	if soundActive then killSound;
	exitProc:=oldExitProc;
end;

function detectTandy:boolean; assembler;
asm
	mov  bx,$FFFF
	mov  es,bx
	mov  di,$000E
	mov  al,$FD
	cmp  es:[di],al
	jne  @notJr
	mov  ax,bx
	ret
@notJr:
	mov  al,$FF
	cmp  es:[di],al
	jne  @notTandy
	mov  ax,$FC00
	mov  es,ax
	xor  di,di
	mov  al,$21
	cmp  es:[di],al
	jne  @notTandy
	mov  ax,bx
	ret
@notTandy:
	xor  ax,ax
end;

begin
	soundActive:=false;
	write('Sound card detected: ');
	if detectTandy then begin
		soundSource:=sound_tandy;
		writeln('Tandy/PCJr detected');
	end else begin
		soundSource:=sound_pcSpeaker;
		writeln('None, using PC Speaker');
	end;
	oldExitProc:=exitproc;
	exitproc:=@safeExit;
end.paku