 '  program QuickBasic
 '  Resolution  on Rubik's Cube by Alain Renier anne 2011.
	' - Run on Windows XP. 
	' - SET the CMD.EXE in mode full screen, taille caracteres 8 x 8.
	' - Line of commande QuickBasic:  QB /H /L /AH
	' WARNING!   If QBASIC is in another disk that "E:\"
	' - then change the line "Monv$" on CUBRNEN.BI
	' - The program must have a subdirectory  of Quickbasic  named "RUBIK".
	' - In this subdirectory must be set the files:
	' - CUBDATA.RBK	 et	TRANSIND.RBK
	' - CUBRNEN.BI		 et	CUBRNEN.BAS
	'    also the files  "RUBIK1.RBK to "RUBIKX.RBK"  (X= order number)
	'   if this already existes.
	' - IF the  files das'nt in the subdirectory, the program don't run
	'   {STOP WITH WARNING !.}
	' - Another part, you can save until 16 files, of data facettes
	'   enter one by one. 
	' - The files of data saved have the name  "RUBIK1.RBK  to  RUBIK16.RBK"
	' - some details on  the arrays of  variables used:
	' - CF%(i%,j%)	Array miror,  container of color facets
	' - TF%(k%)		number of cube who must have a position k
	' - Current configuration
	' - C%(i%,j%) 	Color of facet i%,j%; and weight binary of cube elementary
	' - T%(K%)	 	number of cube occupant the position k
	' - Z%(K%)		position occupy by the cube k
	' - CO%(6)		Contain the color by default
	' - VO%(6)		Suite of weight binary of values 1, 2, 4, 8, 16 ou 32.
	' - Colors of the cube by default
	' - white	=	1,	green	=	2,	Red	=	3,
	' - Blue	=	4,	Orange	=	5,	yellow	=	6 
	' - P% array of 9 positions, but 6 are  used for the cube
	' - Colors realles
	' - P%(1 )  (6) 	Contain the color realle for the screen (SCREEN 12 MS-DOS) in order :
	' - white	=	15,	green	=	2,	Red		=	4,
	' - Blue	=	9,	Orange	=	12,	yellow	=	14
	' - P%(7)  (9) for use in the program
	' - Cyan	=	11,	Grey		=	8, greenlight		=	10
	' - SS%(20) 	summe of weight 2^x-1  of summit and ridges
	' - Init
	' - array of  container of mouvements (contain in CUBDATA.RBK)
	' 	Bf1$(112)	-->	data		"Rf1$" : 	Printing
	' 	Bc1$(112)	-->	data		"Cm1$" : 	execute
	' 	Bf2$(99)	-->	data		"Rf2$" :	Printing
	' 	Bc2$(99) 	-->	data		"Cm2$" :	execute
	' 	Bf3$(27) 	-->	data		"Rf3$" :	Printing
	' 	Bc3$(27)	-->	data		"Cm3$" :	execute
	' - array d'index:   (contain in TRASIND.RBK)
	'	Id1% integer	-->	pointer on data of Bf1$ and Bc1$
	'	Id2% integer	-->	pointer on data of Bf2$ and Bc2$
	'	Id3% integer	-->	pointer on data of Bf3$ and Bc3$
	'	so%(54) integer-->	used for calculate the coefficient K% in calcv
	'************************************************************************************************  
5	' $INCLUDE: 'cubrnEN.bi'
	' $DYNAMIC 
	CLS
	CHDIR (Monv$)
	' delta time = 0
	drl# = 0
	' coefficient sinus x ( on degr)
	Kfsn% = (CINT(angl * (SIN(angl * (pi# / 180)))))  '  sin30 = 1/2 --> Kfsn% = 15
	' In  case possible of error
	ON ERROR GOTO traiterreur
	Infic1$ = "cubdata.rbk"
	Infich% = FREEFILE
	OPEN Infic1$ FOR INPUT AS #Infich%
	'Init the array  of data Bf1$ and Bc1$
	Tablo 224, Infich%, Bf1$(), Bc1$()
	'Init the array  of data Bf2$ and Bc2$
	Tablo 198, Infich%, Bf2$(), Bc2$()
	'Init the array  of data Bf3$ and Bc3$
	Tablo 54, Infich%, Bf3$(), Bc3$()
	CLOSE #Infich%
	Infich$ = "transind.rbk"
	Infich% = FREEFILE
	OPEN Infich$ FOR BINARY AS #Infich%
	'Init the array of index
	Tablau 36, Infich%, Id1%(), Id2%()
	Tablax 6, Infich%, Id3%()
	'Init the array of jumps
	Tablax 54, Infich%, so%()
	'Init the array of call  Test and TestT1
	Tablat 78, Infich%, Aptst(), Aptsk(), 1
	'Init the array of call  TestK1 and TestK2
	Tablat 35, Infich%, Aptst(), Aptsk(), 2
	' Init array of ensembles summit (8) and ridges(12)
	Tablax 20, Infich%, SS%()
	CLOSE #Infich%
	FOR i% = 1 TO nbfac%
		' color virtuale of faces
		CO%(i%) = i%
		' value (weight of facets) VO%(x) = 1, 2, 4, 8, 16 or 32
		VO%(i%) = 2 ^ (i% - 1)
		' W%(x) contain the color checking by the value of weight  of the  facette.
		W%(VO%(i%)) = i%
	NEXT i%
	' at the start, the array of files is empty. 
	FOR i% = 1 TO UBOUND(Cdir$)
		Cdir$(i%) = ""
	NEXT i%
	' Init general.
	FaiLinit 2
	tconf% = 0
	xtdir% = False
	xtfich% = False
	' for obtain only the directorys.
	attr1$ = "/A:D/B"
	' <dir.rep> for contain the directorys.
	attr2$ = "dir.rep"
	' name of  directory and/or the files by default
	attr3$ = "rubik"
	Collect attr1$, attr2$, attr3$, Cdir$()
	' for obtain only the names of files with  extend ".rbk" by default
	attr1$ = "*.rbk /B"
	' to make in file  <dir.txt>
	attr2$ = "dir.txt"
	' rubik = name  automatically  by default, attr3$ = "rubik"
	Collect attr1$, attr2$, attr3$, Cdir$()
	IF xtfich% THEN	' = True 
		' find the upper limit on the number of files
		FOR i% = 1 TO UBOUND(Cdir$)
			IF Cdir$(i%) <> "" THEN
				Mind% = i%
			ELSEIF Cdir$(i%) = "" THEN
				EXIT FOR
			END IF
		NEXT i%
	Tri Cdir$()
	END IF
	SCREEN 12
	DO
		q$ = " Final "
		hf% = Mconfig%(q$)
		' Wait  HF = 1  Cube normal, or 	HF = 2  Rotate the faces
		' Cas 1, cube normal
		FaiLinit 1
		FaiLinit 2
		efface
		q$ = " Initial "
		hi% = Mconfig%(q$)
		IF (hf% = 1) AND (hi% = 1) THEN
			Locate 6, 4
			PRINT " *** You can not have an initial configuration = Cube normal***"
			Locate 8, 14: PRINT " ***and a final configuration = Cube Normal !  ***"
			Locate 9, 14: PRINT " *****In this case, the software does nothing  !  ****"
			Locate 12, 14
			PRINT " *********   Repeat your selection S.V.P. ********* "
			Delier# = 5:Delay
			' delete the message on screen
			efface
		ELSEIF	(hf% = 2 AND hi% = 2) OR (hf% = 1 AND hi% = 2)_
			OR	(hf% = 1 AND hi% = 3) OR (hf% = 2 AND hi% = 3) THEN
			EXIT DO
		END IF
	LOOP
	' Rotate the faces
	IF (hi% = 2) AND (hf% = 1) THEN
		movself 1
		Affect
		tconf% = 1
	ELSEIF (hi% = 2) AND (hf% = 2) THEN
		movself 0
		locate 27, 2
		PRINT " Do you want another exercice <Y>es     <N>o";
		DO UNTIL nc$ = "Y" OR nc$ = "N"
			nc$ = UCASE$(INKEY$)
		LOOP
		IF nc$ = "Y" THEN
			CLEAR
			RUN 5
		END IF
		END
	ELSEIF (hi% = 3) AND (hf% = 2) THEN
		' for extension future if  needed...
	END IF
	IF hi% = 3 THEN
		AffCadr 10
		' If files already existe
		IF xtfich% THEN
			color P%(7): Locate 4, 2
			FOR i% = 1 to 6
				PRINT STRING$(50, " ")
				Locate csrlin, 2
			NEXT i%
			Locate 4, 4: PRINT " Retrieve data ?  <Y / N> ";
			psa$ = Req$(psa$, "Y", "N")
		END IF
		Locate 6, 4: PRINT " operation step by step ? <Y / N> ";
		pmsa$ = Req$(pmsa$, "Y", "N")
		Locate 4, 4: PRINT STRING$(40, " ")
		Locate 6, 4: PRINT STRING$(40, " ")
		IF (psa$ = "Y") AND (xtfich%) THEN
			' print the files
			IF Mind% <> 0 THEN Affichier Mind%, Cdir$()
			Locate Csrlin + 2, 4: PRINT "What file ? 1 to ";Mind%;"  ";
			Loq% = CSRLIN: Posa% =  POS(0)
			Locate 27, 2: PRINT "wait 2 car.  If selection from 1 to 9 press <Enter>"
			i% = 0
			DO UNTIL (i% > 0) AND (i% <= Mind%) 
				i% =  VAL(INPUT$(2))
			LOOP
			effa27
			Locate Loq%, Posa%
			Color P%(1): PRINT i%
			Locate 27, 2: PRINT " press a key to continue "
			sleep
			effa27
			Color P%(7)
			nomfic$ = Cdir$(i%)
			Nfich% = FREEFILE
			OPEN nomfic$ FOR BINARY AS Nfich%
			LirEcrir Nfich%, C%(), 1
			CLOSE #Nfich%
			color P%(1)
			Affect
			tconf% = 2
		ELSE
			CLS
			Dkolfac
			tconf% = 1
		END IF
	END IF
	IF tconf% = 1 THEN
		CLS
		AffCadr 10 
		Locate 4, 4: PRINT " Save the data <Y / N> ";
		sa$ = Req$(sa$, "Y", "N")
		IF sa$ = "Y" THEN
			Nfich% = FREEFILE
			Locate 5, 4
			IF xtfich% = False THEN
				Cfichier Mind%, Mname$
				OPEN Mname$ FOR BINARY AS Nfich%
			ELSEIF Mind% < UBOUND(Cdir$) THEN
				Cfichier Mind%, Mname$
				OPEN Mname$ FOR BINARY AS Nfich%
			ELSEIF Mind% = UBOUND(Cdir$) THEN
				PRINT "The maximum file already exists! "
				Locate CSRLIN, 4
				PRINT "replace on ? <Y> ou <N>"
				sa1$ = Req$(sa1$, "Y", "N")'				
				Locate 5, 4 :PRINT STRING$(50," ")
				Locate 5, 4 :PRINT STRING$(50," ")
				'CLS
				IF sa1$ = "N" THEN
					PRINT " File not saved";
					PRINT " limit is reached. (limit = ";UBOUND(Cdir$)
				ELSE
					AFFichier Mind%, Cdir$()
					PRINT " Which file ? " ;
					Rng% = VAL(INPUT$(2))
					Mname$ = Cdir$(Rng%)
					OPEN Mname$ FOR BINARY AS Nfich%
				END IF
			END IF
			LirEcrir Nfich%, C%(), 2
			CLOSE #Nfich%
			PRINT "File ";Mname$, " recorded" 
		ELSE
			ta% = 11
			IF (hi% = 2) AND (hf% = 1) THEN
				locate 3, 1
				PRINT COIbdG$ + STRING$(77, HOriD$) + COIbdD$
			END iF
			FOR ii% = 4 to ta%
				Locate ii%, 1: PRINT STRING$(79, " ")
			NEXT ii%
		END IF
	END IF
	'******** RECONSTITUTION OF THE CUBE ********
	color P%(1)
	Locate 27, 5: PRINT "< press a key to continue >"
	wll$ = UCASE$(INPUT$(1))
	effa27
	CLS
	Affcadr 2
	Color P%(1)
	Locate 4, 19: PRINT STRING$(24, "*")
	Locate Csrlin, 20: PRINT "Reconstitution of the cube"
	Locate Csrlin, 19: PRINT STRING$(24, "*")
'	AFFcol
	' identificator of  progress in the loop main.
	B% = 0
	' variable of jump "Saut()"
	dx% = 1
	DO	' Loop main
		IF pmsa$ = "N" THEN
			Color P%(9)
			Locate 27, 2: PRINT "stopped temporarily, press T "
			PRINT " then press <enter> to resume ";
			color P%(1)
		END IF
		' calculate  B%, K%, V%
		CalcV B%, K%, V%, so%(dx%), so%(dx% + 1), so%(dx% + 2)
		' Printing on the screen
		Posit B%, K%, V%
		' progress  index for 3 steps
		dx% = dx% + 3
		Ta$ = UCASE$(INKEY$)
		IF Ta$ = "Q" THEN
			Lign% = Csrlin :col% = POS(0)
			Locate 27, 5: PRINT "Would you leave  ?  press  <Q> or <N> to continue"
			Delier# = 5:Delay
			effa27
			Locate 27, 5 
			PRINT "Please confirm  <Q>uit or <N>o "
			Ta$ = Req$(Ta$, "Q", "N")
			effa27
			IF Ta$ = "Q" THEN
				EXIT DO
			ELSE
				effa27
				Locate Lign%, Col%
			END IF
		END IF
		SELECT CASE B%
			' cas 1 to 4 , and 9 to 14   call at " Test"  and  "TestT1"
			CASE 1 TO 4, 9 TO 14
				' 2 parameters are  needed
				Atrib 0, 13, 1, 13, 1, 0, q0%, q1%, 0, 0, 0
				' cas K% = 1
				IF K% = 1 THEN
					Test q0%, q1%, V%, Rf1$, Cm1$
				' cas K% de 2  12
				ELSEIF (K% > 1) AND (K% < 13) THEN
					TestT1 q0%, q1%, V%, Rf1$, Rf2$, Cm1$, Cm2$
				END IF
			'  cas 5 to 8 , and 16, 17  make call to "TestK1" and "TestK2"
			CASE 5 TO 8, 16, 17
				' 4 parameters are needed
				Atrib 0, 9, 0, 9, 0, 0, q0%, q1%, q2%, q3%, 1
				IF B% < 9 THEN mg% = Id3%(B% - 4) + K% - 1
				IF B% = 16 OR B% = 17 THEN mg% = Id3%(B% - 11) + K% - 1
				Rf3$ = Bf3$(mg%)
				Cm3$ = Bc3$(mg%)
				' cas K% = 1
				IF K% = 1 THEN
					TestK1 q0%, q1%, q2%, q3%, V%, Rf1$, Rf2$, Cm1$, Cm2$
				' cas K% of 2 to 8
				ELSEIF (K% > 1) AND (K% < 9) THEN
					TestK2 q0%, q1%, q2%, q3%, V%, Rf1$, Rf2$, Rf3$, Cm1$, Cm2$, Cm3$
				END IF
			' cas 15 special. make 2 times a call  "Test" if K% = 2
			CASE 15
				' cas K% = 1 and K% = 2
				Atrib 0, 3, 0, 0, 0, 0, q0%, q1%, 0, 0, 0
					Test q0%, q1%, V%, Rf1$, Cm1$
				' cas K% = 2
				IF K% = 2 THEN
					Locate Afli%, Afcol%
					Atrib 0, 3, 0, 0, 0, 1, q0%, q1%, 0, 0, 0
					Test q0%, q1%, V%, Rf1$, Cm1$
				END IF
			CASE 18
				' cas K% = 1
				Atrib 0, 2, 0, 2, 0, 0, q0%, q1%, q2%, q3%, 1
				IF K% = 1 THEN
					TestK1 q0%, q1%, q2%, q3%, V%, Rf1$, Rf2$, Cm1$, Cm2$
				ELSE
					' if B% = 18 and K% = 2, cannot resolve
					PRINT "POSITION NOT POSSIBLE"
				END IF
		END SELECT
		' If B% = 18  it's end !
	LOOP UNTIL B% = 18
	IF pmsa$ = "N" THEN
		Locate 5, 50: PRINT STRING$(30, " ")
		Locate 6, 50: PRINT STRING$(30, " ")
		effa27
		PRINT STRING$(50, " ");
	END IF
	Locate 27, 2: PRINT " "; stat%; " movements made! "; "  < any key to end >"
	SLEEP
	effa27
	PRINT "Do you want another exercice?   <Y>es     <N>o";
	DO UNTIL nc$ = "Y" OR nc$ = "N"
		nc$ = UCASE$(INKEY$)
	LOOP
	IF nc$ = "Y" THEN
		CLEAR
		RUN 5
	END IF
	END
	traiterreur:
	SELECT CASE ERR
		CASE 5
			PRINT "** Function call prohibited - ERROR "; ERR
			RESUME NEXT
		CASE 6
			PRINT "** Overflow - ERROR "; ERR
			Berre% = Berre% + 1
			IF Berre% > 10 THEN END
			RESUME NEXT
		CASE 7
			PRINT "** Insufficient memory - ERROR "; ERR
			PRINT "   termination of the program "
			PRINT " Correct the defect if possible ";
			PRINT "   and restart the program !  "
			END
		CASE 9
			PRINT "** Index out of bounds - ERROR "; ERR
			Cerre% = Cerre% + 1
			IF Crre% > 10 THEN END
			RESUME NEXT
		CASE 52, 64
			PRINT "** Bad file name - ERROR "; ERR
			Perre% = Perre% + 1
			IF Perre% > 10 THEN END
			RESUME NEXT
		CASE 71
			PRINT "** Disk not ready - ERROR "; ERR
			Derre% = Derre% + 1
			IF Derre% > 10 THEN
				PRINT "Error accessing the hard drive "
				END
			END IF
			RESUME NEXT
		CASE 53, 76:	
			PRINT "** File or path not found - ERROR "; ERR
			PRINT " The program does not find files cubdata.rbk "
			PRINT "  and/or transind.rbk which are necessary . "
			PRINT "  End of program! grind, and restart the program."
			END 
		CASE ELSE
			PRINT "** ERROR "; ERR
			'  assigne a 'label',  if  an error is possible
			' at the location identified of program
			PRINT ERL
		RESUME NEXT
	END SELECT
	'  **** End of cubrnEN.bas (Main)****
 '********************************************************************
SUB Cfichier (pa%, mn$)
 ' create a file
 '********************************************************************
		pa% = pa% + 1
		PRINT "a file Rubik" + LTRIM$(STR$(pa%));".RBK will be created "
		Mn$ = "RUBIK" + LTRIM$(STR$(pa%)) + ".RBK"
END SUB
 '********************************************************************
SUB Affichier (pb%, md$())
 ' Printing the files
 '********************************************************************
	Locate 4, 3: PRINT "availables files :"
	Locate 5, 3
	xu% = 0
	FOR i% = 1 to pb%
		xu% = xu% + 1
		IF LEN(md$(i%)) = 10 THEN
			PRINT i%;" "; md$(i%);" ";
		ELSE
			PRINT i%; md$(i%) ;
		END IF
		IF xu% = 5 THEN
			PRINT: Locate Csrlin, 3
			xu% = 0
		END IF
	NEXT i%	
END SUB
 '********************************************************************
SUB AffCadr (ap%)
 ' Printing a cadre on the screen
 '********************************************************************
	color P%(7)
	Boiteds 1, 1, 77, ap% 
	Locate 2, (78 - INT(LEN("* * * * R U B I K ' S   C U B E * * * *"))) / 2
	PRINT "* * * * R U B I K ' S   C U B E * * * *"
END SUB
 '********************************************************************
SUB AFFcol
 ' input: none
 ' output: Printing the colors of faces on the screen 
 '********************************************************************
	' --- Help at  colors of  faces
	Locate 1, 2
	FOR t% = 1 TO nbfac%
		Color P%(t%)
		IF t% = 1 THEN
			PRINT nocou(CO%(t%)).kol;" : "; CO%(t%);
		ELSEIF t% = 3 OR t% = 5 THEN
			PRINT " ";nocou(CO%(t%)).kol;" : "; CO%(t%);
		ELSE
			Locate csrlin, pos(0) + 1
			PRINT nocou(CO%(t%)).kol;" : "; CO%(t%)
		END IF
	NEXT t%
	color P%(1)
	PRINT
END SUB
 '********************************************************************
SUB Affect
 ' affecte the data on array of 20 steps
 '					it's come  8 summits of 3 facets
 '					and  12 ridges of 2 facets.
 ' input: 				array communs 	s%(),  C%()
 ' output: 				array  s%() ,
 '					 array  C(i%, j%)
 '					affect and control the valid data
 '********************************************************************
	FOR i% = 1 TO nbfac%
		FOR j% = 1 TO nfacet%
		' replace the value of C%(i, j) by the weight 2^(x-1)
			C%(i%, j%) = VO%(C%(i%, j%))
		NEXT j%
	NEXT i%
	CLS
	' ---- Reprage des petits cubes ----
	' **Summits**
	' for exemple, s%(1) = C%(face1, cube 7) + C%(face2, cube 3) + C%(face3, cube 1)
	s%(1)  = C%(1, 7) + C%(2, 3) + C%(3, 1)	' sum weight 2^x corner hight ahead left
	s%(2)  = C%(1, 1) + C%(2, 1) + C%(5, 3)	' sum weight 2^x corner hight rear left
	s%(3)  = C%(1, 3) + C%(4, 3) + C%(5, 1)	' sum weight 2^x corner hight rear right
	s%(4)  = C%(1, 9) + C%(3, 3) + C%(4, 1)	' sum weight 2^x corner hight ahead right
	s%(5)  = C%(2, 9) + C%(3, 7) + C%(6, 1)	' sum weight 2^x corner low ahead left
	s%(6)  = C%(2, 7) + C%(5, 9) + C%(6, 7)	' sum weight 2^x corner low rear left
	s%(7)  = C%(4, 9) + C%(5, 7) + C%(6, 9)	' sum weight 2^x corner low rear right
	s%(8)  = C%(3, 9) + C%(4, 7) + C%(6, 3)	' sum weight 2^x corner low ahead right
	' **ridges**
	s%(9)  = C%(1, 4) + C%(2, 2)				' sum weight 2^x ridge hight left
	s%(10) = C%(1, 2) + C%(5, 2)				' sum weight 2^x ridge hight rear
	s%(11) = C%(1, 6) + C%(4, 2)				' sum weight 2^x ridge hight right
	s%(12) = C%(1, 8) + C%(3, 2)				' sum weight 2^x ridge hight ahead
	s%(13) = C%(2, 6) + C%(3, 4)				' sum weight 2^x ridge medium ahead left
	s%(14) = C%(2, 4) + C%(5, 6)				' sum weight 2^x ridge medium rear left
	s%(15) = C%(4, 6) + C%(5, 4)				' sum weight 2^x ridge medium rear right
	s%(16) = C%(3, 6) + C%(4, 4)				' sum weight 2^x ridge medium ahead right
	s%(17) = C%(2, 8) + C%(6, 4)				' sum weight 2^x ridge low left
	s%(18) = C%(5, 8) + C%(6, 8)				' sum weight 2^x ridge low rear
	s%(19) = C%(4, 8) + C%(6, 6)				' sum weight 2^x ridge low right
	s%(20) = C%(3, 8) + C%(6, 2)				' sum weight 2^x ridge low ahead
	' controle
	FOR i% = 1 TO 20
		IF (s%(i%) > 56) AND (i% <= 20) THEN
			PRINT " Impossibles data "
			EXIT FOR
		END IF
		FOR pt% = 1 to 20
			IF SS%(pt%) = s%(i%) THEN
				T%(i%) = pt%  ' position occupy  by the  cube
				EXIT FOR
			END IF
		NEXT pt%
		Z%(T%(i%)) = i%	' position that must be the  cube
	NEXT i%
	IF i% = 21 THEN
		tem% = 1
		initC 3
		Affcub L%, gm$, tem%
		' If pm% <> 21, the data are mistakes !
	ELSEIF i% <> 21 THEN
		PRINT "The data are wrong! Fatal error - shutdown program"
		END
	END IF
END SUB
 '***********************************************************************
SUB Affcub (LI%, gm$, clm%) STATIC
 ' WARNING :  do not modify the order of  faces or be sure what you want to make !
 'The order directly affects the display of facets compared to the tables!
 ' input: Li% = N facet	gm$ = command to execute 	clm% = tem%
 ' output: draw the cube on the screen ; call to SUB TraceFace(...)
 '********************************************************************
	 ' ----- Graphic display routine -----
	' face 1, 3, 4, 2, 5, 6
	TraceFace 1, 3, 4, 2, 5 , 6
	' save the parametres line and colonne (texte) of the screen
	Lign% = Csrlin: col% = POS(0) + 1
	Locate 14, 21: PRINT "Face 1"
	Locate 21, 5: PRINT "Face 3"
	Locate 18, 33: PRINT "Face 4"
	Locate 14, 60: PRINT "Face 2"
	Locate 21, 43: PRINT "Face 5"
	Locate 25, 54: PRINT "Face 6"
	' get bak line and colonne
	IF col% > 80 then col% = 3
	Locate Lign%, col%
	IF clm% = 1 THEN
		Helpmov LI%, gm$
		Lign% = Csrlin: col% = POS(0)
		IF pmsa$ = "Y" THEN
			Locate 27, 5: PRINT "< press a key to continue >"
			wl$ = UCASE$(INPUT$(1))
			effa27
			IF wl$ = "Q" THEN END
		ELSE
			' It's used if "step by step"  = no
			wc$ = UCASE$(INKEY$)
			IF wc$ = "T" THEN
				sleep
			END IF
			Delier# = .110 + drl#:Delay
		END IF
		Locate Lign%, col%
	END IF
END SUB
 '***********************************************************************
SUB Atrib (e1%, e2%, e3%, e4%, e5%, e6%, e7%, e8%, e9%, e10%, e11%)
 ' get the printing and commands
 ' K% to controle --> e1%, e2% 	and	 	e3%, e4%
 ' e5% =  landmark for " K% - 1'
 ' e6% = landmark for "K% + 1"
 ' If  e11% = 0	  THEN	e7% = q0%, e8% = q1% 
 ' If  e11% = 1	  THEN	e7% = q0%, e8% = q1%, e9% = q2%, e10% = q3% 
 '***********************************************************************
	IF (K% > e1%) AND (K% < e2%) AND (e6% = 0) THEN mn% = Id1%(B%) + K%
	IF (K% > e1%) AND (K% < e2%) AND (e6% = 1) THEN mn% = Id1%(B%) + K% + 1
		Rf1$ = Bf1$(mn%)
		Cm1$ = Bc1$(mn%) 
		IF (K% > e3%) AND (K% < e4%) AND (e5% = 0) THEN mm% = Id2%(B%) + K%
		IF (K% > e3%) AND (K% < e4%) AND (e5% = 1) THEN mm% = Id2%(B%) + K% - 1
		Rf2$ = Bf2$(mm%)
		Cm2$ = Bc2$(mm%)
	' calculate the parameters to send
	IF e6% = 0 THEN jf% = (Calkoef%(bl%(), B%)) + K%
	IF e6% = 1 THEN jf% = (Calkoef%(bl%(), B%)) + K% + 1
	IF e11% = 0 THEN e7% = Aptst(jf%).tst1: e8% = Aptst(jf%).tst2
	IF e11% = 1 THEN e7% = Aptsk(jf%).tsk1: e8% = Aptsk(jf%).tsk2: e9% = Aptsk(jf%).tsk3: e10% = Aptsk(jf%).tsk4
END SUB
 '***********************************************************************
SUB Boiteds (Ligx%, Coly%, lng%, fin%) STATIC
 ' Draw a double line on  the screen
 '  input :				Ligx% = Line begin
 '					Coly% = colonne begin
 '					lng% = width of the frame
 '					fin% =  end of the frame
 ' output :				Display cadre on the screen
 '**********************************************************************
	Locate Ligx%, Coly%: PRINT COIhdG$ + STRING$(lng%, HOriD$) + COIhdD$
	DO
		Ligx% = Ligx% + 1
		Locate Ligx%, Coly%: PRINT DCOte$ + STRING$(lng%, " ") + DCOte$
	LOOP UNTIL Ligx% = fin%
	PRINT COIbdG$ + STRING$(lng%, HOriD$) + COIbdD$
END SUB
 '********************************************************************
SUB Efface
 ' delete some lines of the screen
 '********************************************************************
	Locate 4, 3: PRINT STRING$(54, " ")
	Locate 6, 3: PRINT STRING$(74, " ")
	Locate 7, 3: PRINT STRING$(74, " ")
	Locate 8, 3: PRINT STRING$(54, " ")
	Locate 9, 3: PRINT STRING$(54, " ")
	Locate 12, 14: PRINT STRING$(56, " ")
END SUB
 '********************************************************************
SUB Effa27
 ' delete line 27
 '********************************************************************
	Locate 27, 2: PRINT STRING$(70, " ")
END SUB
 '*********************************************************************
SUB CalcV (d%, e%, f%, g%, h%, al%)
 ' determines the value of:  B%,  K% , V%
 '  input:	B%, K%, V%, saut(dx%), saut(dx% + 1), saut(dx% + 2)
 ' Output:	B%, K%, V% updated
 '********************************************************************
	f% = CF%(g%, h%)			' V%
	e% = Z%(TF%(al%)) - (al% - 1)	' K%
	d% = d% + 1				' B%
END SUB
 '********************************************************************
FUNCTION Calkoef% (bl%(), B%)
 ' calculating the coefficients {jf%} appeal by Atrib for routines 
 '		Test,		TestT1,	TestK1,	TestK2
 ' input :		bl%(), B%,
 ' output  :  	kf1% ( = jf%) in the function Calkoef%
 '********************************************************************
	kf1% = 0
	' cas B% = 1
	IF B% = 1 THEN kf1% = bl%(B%)
	' cas B% between 2 and 4 or between 9 and 15
	IF (B% > 1 AND B% < 5) OR (B% >= 9 AND B% <= 15) THEN
		FOR nx% = 1 TO B%
			kf1% = kf1% + bl%(nx%)
			' if B% between 9 and 15 shorten the loop
			IF (B% >= 9 AND B% <= 15) AND nx% = 4 THEN nx% = 8
		NEXT nx%
	' cas B% between 5 and 8 or 16 to 18
	ELSEIF (B% >= 5 AND B% < 9) OR (B% > 15) THEN
		FOR nx% = 5 TO B%
			kf1% = kf1% + bl%(nx%)
			' If B% between 16 and 18 shorten the loop
			IF (B% > 15) AND (nx% = 8) THEN nx% = 15
		NEXT nx%
	END IF
	Calkoef% = kf1%
END FUNCTION
 '********************************************************************
SUB Collect (cha1$, cha2$, cha3$, Mir$())
 ' obtain the catalog of directories and files.
 '********************************************************************
	SHELL "dir " + cha1$ + " > " + cha2$	' directories or files
	Nfich% = FREEFILE
	OPEN cha2$ FOR INPUT AS Nfich%
	IF LOF(Nfich%) > 0 THEN
		jk% = 0
		DO UNTIL EOF(Nfich%)
			LINE INPUT #Nfich%, ir$
			ir$ = LCASE$(ir$)
			jk% = jk% + 1
			cha3$ = LCASE$(cha3$)
			IF INSTR(ir$, cha3$) THEN
				IF INSTR(ir$, ".rbk") THEN
					xtfich% = True
					Mir$(jk%) = ir$
				ELSE
					xtdir% = True
				END IF
			END IF
		LOOP
	END IF
	CLOSE #Nfich%
	KILL cha2$
END SUB
 '********************************************************************
SUB Chks
 ' Checksum if the entries facets are correct 
 ' We need to find 9 white, 9 green...  and 9 yellow.
 '********************************************************************
	REDIM ctrl%(0 TO 6) 
	FOR op% = 1 TO nbfac%
		FOR om% = 1 TO nfacet%
			' summing the facets of the same color
			ctrl%(C%(op%,om%)) = ctrl%(C%(op%,om%)) + C%(op%, om%)
		NEXT om%
	NEXT op%
	FOR op% = 20 to 27
		Locate op%, 2: PRINT STRING$(70, " ")
	NEXT op%
	dom% = 20
	FOR op% = 1 TO nbfac%
		IF ctrl%(op%) <> CO%(op%) * nfacet% THEN
			Locate dom%, 2 
			PRINT " you entered"; ctrl%(op%)/CO%(op%); " facets "; nocou(op%).kol
			dom% = dom% + 1
		ELSE
			ctrl%(0) = ctrl%(0) + ctrl%(op%)
		END IF
	NEXT op%
	' If checksum is correct, tem% = 1
	IF ctrl%(0) = 189 THEN
		tem% = 1
		ERASE ctrl% ' reclaim memory
	ELSE
		Locate 26, 2: PRINT " you have to restart entering the color of the facets ";
		tem% = 0
		Locate 27, 2: PRINT " <press a key to continue>" 
		sleep
		CLS
	END IF
END SUB
 '********************************************************************
SUB Delay
 ' Delay independent of the CPU speed. 
 ' Based on the timer ticks (18.2 times per second ) = 55ms 
 ' According to delier# in seconds. 
 ' If delier# = 0, no execution of the routine.
 '********************************************************************
	IF Delier# = 0 THEN EXIT SUB
	Debut# = TIMER
	WHILE TIMER - Debut# <= Delier#
	WEND
	Delier# = 0	' reset delier# to 0
END SUB
 '********************************************************************
SUB Dkolfac
 ' input: 		Interface homme-machine.
 '				The target facet  is black.
 ' output: 		Colors of the 54 facets in 6 groups of 9.
 ' 				facet 5 of each face is assigned, an ex-officio.
 ' 				At the start by default facets are gray.
 '********************************************************************
 ' Init color data of the facets
	DO
		IF tem% = 0 THEN
			FOR i% = 1 TO nbfac%
				FOR j% = 1 TO nfacet%
					C%(i%, j%) = P%(8)
					' color of the facet 5
					IF j% = 5 THEN C%(i%, j%) = i%
				NEXT j%
			NEXT i%
			Affcub j%, gm$, tem%
		END IF
		tem% = 0
		' Input data for the 6 faces
		FOR i% = 1 TO nbfac%
			AFFcol
			Locate 5, 2: PRINT "	Face"; i%,
			PRINT
			' and for the 9 facets
			FOR j% = 1 TO nfacet%
				DO
					Locate 7, 32: PRINT STRING$(4, " ")
					' if facet 5, do nothing
					IF j% = 5 THEN EXIT DO
					Locate 7, 2: PRINT " Color of the facet   : "; j%; " "
					C%(i%, j%) = 0
					Affcub j%, gm$, tem%
					DO UNTIL (C%(i%, j%) <= 6) AND (C%(i%, j%) > 0)
						C%(i%, j%) = VAL(INKEY$)
					LOOP
					Affcub j%, gm$, tem%
					EXIT DO
				LOOP
			NEXT j%
			Locate 27, 2: PRINT " Valid values (Y/N) :  ",
			Lm$ = "" 
			Lm$ = Req$(Lm$, "Y", "N") 
			' clear the message
			effa27
			' If incorrect entries
			IF Lm$ = "N" THEN
				' back facets gray
				FOR j% = 1 TO nfacet%
					C%(i%, j%) = P%(8)
					' color of the facet 5
					IF j% = 5 THEN C%(i%, j%) = i%
				NEXT j%
				' refresh the screen
				Affcub j%, gm$, tem%
				'  update  i%
				i% = i% - 1
			END IF
		NEXT i%
		'  control if no duplicate entries
		'  if OK the witness "tem%" = 1
		Chks
		IF tem% = 1 THEN Affect: EXIT DO
	LOOP
END SUB
 '********************************************************************
SUB exmov (exc%, gm$)
 ' shared execution routine rotations
 '********************************************************************
	IF exc% < 3 THEN ko% = 3
	IF exc% > 2 AND exc% < 5 THEN ko% = 5
	IF exc% > 4 AND exc% < 7 THEN ko% = 1
	IF exc% > 6 AND exc% < 9 THEN ko% = 6
	IF exc% > 8 AND exc% < 11 THEN ko% = 2
	IF exc% > 10 AND exc% < 13 THEN ko% = 4
	SELECT CASE exc%
		CASE 1, 3, 5, 7, 9, 11
			Sdlm Ko%, 3, 2, 1, 4, 7, 8, 9, 6
		CASE 2, 4, 6, 8, 10, 12
			Sdlm Ko%, 1, 2, 3, 6, 9, 8, 7, 4
	END SELECT
	Translat exc%, L%, gm$
END SUB
 '********************************************************************
SUB FaiLinit (vc%)
 ' Init the arrays C%() and TF%()
 ' vc% = config entry value based hi% and/or HF%
 '********************************************************************
	InitC vc%
	InitTF vc%
END SUB
 '********************************************************************
SUB Helpmov (g%, gm$)
 ' helping hand and display rotation movements
 '
 '********************************************************************
	IF bd% = 0 OR g% > LEN(gm$) THEN EXIT SUB
	IF Col% > 70 THEN	  ' for adjust the screen
		Lign% = Lign% + 1 :Col% = 2
		Locate Lign%, Col%
	END IF 
	DO
		IF g% > LEN(gm$) THEN PRINT "            "; : EXIT DO
		' consider a display for L% >= 10
		IF L% < 10 THEN Col% = Col% + 1:Locate Lign%, Col%
		SELECT CASE bd%
			CASE 1, 3, 5, 7, 9, 11
				m% = &H2B ' signe +
			CASE 2, 4, 6, 8, 10, 12
				m% = &H2D ' signe -
		END SELECT
		IF bd% = 1 OR bd% = 2 THEN mc$ = "FRont  ": EXIT DO
		IF bd% = 3 OR bd% = 4 THEN mc$ = "BAck   ": EXIT DO
		IF bd% = 5 OR bd% = 6 THEN mc$ = "UP     ": EXIT DO
		IF bd% = 7 OR bd% = 8 THEN mc$ = "DOwn   ": EXIT DO
		IF bd% = 9 OR bd% = 10 THEN mc$ = "LEft   ": EXIT DO
		IF bd% = 11 OR bd% = 12 THEN mc$ = "RIght  ": EXIT DO
	LOOP
	PRINT L%; mc$ + CHR$(m%);
END SUB
 '********************************************************************
SUB InitC (y%)
 ' Init array		C%() 	or
 ' 				CF%() depending on the value of y%
 '********************************************************************
	FOR i% = 1 TO nbfac%
		FOR j% = 1 TO nfacet%
			IF y% = 1 THEN CF%(i%, j%) = C%(i%, j%)
			IF y% = 2 THEN C%(i%, j%) = i%
			IF y% = 3 THEN C%(i%, j%) = W%(C%(i%, j%))
		NEXT j%
	NEXT i%
END SUB
 '********************************************************************
SUB InitTF (rl%)
 ' Init array TF%()  	or	 T%() and Z%() 	or Z%()
 ' according to value of rl%
 '********************************************************************
	FOR gk% = 1 TO 20
		IF rl% = 1 THEN TF%(gk%) = T%(gk%)
		IF rl% = 2 THEN T%(gk%) = gk%: Z%(gk%) = gk%
		IF rl% = 3 THEN Z%(T%(gk%)) = gk%
	NEXT gk%
END SUB
 '********************************************************************
FUNCTION invert$ (Miss AS STRING)
 ' Reversal of the message
	DIM ml$
	ml$ = LEFT$(Miss, 1) + MID$(Miss, 4, 1) + MID$(Miss, 3, 1) + MID$(Miss, 2, 1)
	ml$ = ml$ + MID$(Miss, 5, 1) + MID$(Miss, 8, 1) + MID$(Miss, 7, 1) + MID$(Miss, 6, 1)
	invert$ = ml$
END FUNCTION
 '********************************************************************
SUB invrc (chifr$())
 ' Reversal of TR$(1 to 4)
 ' 1 vers 1
	chifr$(1) = LEFT$(TR$(1), 1) + RIGHT$(TR$(1),1) + MID$(TR$(1),3,1) + MID$(TR$(1),2,1)
 ' 2 vers 4 chi$ = savegarde tr$(2)
	chi$ = chifr$(2)
	chifr$(2) = LEFT$(TR$(4), 1) + RIGHT$(TR$(4),1) + MID$(TR$(4),3,1) + MID$(TR$(4),2,1)
 ' 3 vers 3
	chifr$(3) = LEFT$(TR$(3), 1) + RIGHT$(TR$(3),1) + MID$(TR$(3),3,1) + MID$(TR$(3),2,1)
 ' 4 vers 2
	chifr$(4) = LEFT$(chi$, 1) + RIGHT$(chi$,1) + MID$(chi$,3,1) + MID$(chi$,2,1)
END SUB
 '********************************************************************
FUNCTION Mconfig% (cn$)
 ' user's Choice
 '********************************************************************
	SHARED hf%
	AffCadr 10
	Locate 4, 2: PRINT " Configuration ";
	Color P%(10): PRINT cn$;
	color P%(1): PRINT " desired : "
	Locate 6, 3: PRINT "	1. Cube normal"
	Locate 7, 3: PRINT "	2. Obtained by rotating the cube faces"
	IF hf% = 1 THEN Locate 8,3: PRINT "	3. Colors of the facets of your choice"
	PRINT
	Locate Csrlin, 3: PRINT " Number of your  choice : ";
	Choi% = 0
	DO UNTIL (Choi% > 0) AND (Choi% <= 3)
		Choi% = VAL(INKEY$)
	LOOP
	Locate csrlin, pos(0): PRINT LTRIM$(STR$(Choi%))
	Mconfig% = Choi%
END FUNCTION
 '********************************************************************
SUB movself (zx%)
 ' Hand movements (simulation)
 '********************************************************************
	CLS
	IF zx% = 1 THEN Lign% = Csrlin: col% = POS(0)
	j% = 0
	DO
		Color P%(3)
		PRINT "   ***	List of the commands  ***"
		PRINT " "
		color P%(7)
		PRINT "  F - Front face ", "  B - Back face "
		PRINT "  U - Up face  ", "  D - Down face"
		PRINT "  L - Left face  ", "  R - Right face"
		PRINT "  Q - Quit    If 'Q' is one, if not, ignored"
		PRINT "If letter is one = meaning of the watch, if '-' opposite "

		color P%(1)
		initTF 3
		Affcub L%, gm$, tem%
		INPUT " Command : "; gm$
		gm$ = UCASE$(gm$)
		IF (LEN(gm$) = 1) AND (gm$ = "Q") THEN EXIT DO
		tem% = 1
		FOR L% = 1 TO LEN(gm$)
			r$ = MID$(gm$, L%, 1)
			IF r$ = "-"  THEN j% = j% + 1: L% = L% + 1: r$ = MID$(gm$, L%, 1)
			IF r$ = "F" THEN	j% = j% + 1
			IF r$ = "B" THEN	j% = j% + 3
			IF r$ = "U" THEN	j% = j% + 5
			IF r$ = "D" THEN	j% = j% + 7
			IF r$ = "L" THEN	j% = j% + 9
			IF r$ = "R" THEN	j% = j% + 11
			Bd% = j%
			exmov j%, gm$
			j% = 0
		NEXT L%
		initTF 3
		Affcub L%, gm$, tem%
		Affect
	LOOP
END SUB
 '********************************************************************
SUB Posit (rr%, us%, tu%)	'STATIC
 '  Routine positioning on the screen
 ' values of	 B%,		K%,	   V%
 '********************************************************************
	Locate 7, 3: PRINT "B:"; rr%, "K:"; us%, "V:"; tu%, "COMMANDS"
	Color P%(9)
	Locate 8, 2: PRINT STRING$(38, CHR$(223)); STRING$(41, " ")
	color P%(1)
	Locate Afli%, Afcol%
END SUB
 '********************************************************************
FUNCTION Req$ (t$, rp1$, rp2$)
	DO UNTIL t$ = rp1$ OR t$ = rp2$
		t$ = UCASE$(INKEY$)
	LOOP
	Req$ = t$
END FUNCTION
 '********************************************************************
SUB Rotax (gm$)
 ' Executes the command placed in gm$: Rotate the faces
 '********************************************************************
	Lign% = 9 :col% = 2
	color P%(1)
	FOR L% = 1 TO LEN(gm$)
		Bd% = ASC(MID$(gm$, L%, 1)) - 64
		exmov bd%, gm$
	NEXT L%
	IF L% > LEN(gm$) THEN
		Delier# = 1.2:Delay
		Locate Afli%, Afcol%: PRINT STRING$(38, " ")
		For Gn% = 1 to 5
			Locate Afli% + Gn%, 1: PRINT STRING$(78, " ")
		NEXT Gn%
		Locate Lign%, col%
	END IF
	stat% = stat% + LEN(gm$)
	initTF 3
END SUB
 '********************************************************************
SUB LirEcrir (xfich%, C%(), nz%)
 ' Read from disk or write to disk
 ' depending on the value of nz%
 ' (nz% 	= 1	read.)	(nz%	= 2	write.)
 '********************************************************************
	FOR i% = 1 TO nbfac%
		FOR j% = 1 TO nfacet%
			IF nz% = 1 THEN GET #xfich%, ,C%(i%, j%)
			IF nz% = 2 THEN	PUT #xfich%, ,C%(i%, j%)
		NEXT j%
	NEXT i%
END SUB
 '********************************************************************
SUB Tablo (bor%, pfich%, Br$(), Ca$() )
 ' generators read from disk
 '********************************************************************
	FOR i% = 1 TO bor%
		IF i% <= bor%/2 THEN 
			INPUT #pfich%, Br$(i%)
		ELSE
			INPUT #Pfich%, Ca$(i% - bor%/2)
		END IF
	NEXT i%
END SUB
 '********************************************************************
SUB Tablau (bar%, kfich%, nd%(), na%())
 ' Index read from disk
 '********************************************************************
	FOR i% = 1 TO bar%
		IF i% <= bar%/2 THEN
			GET #kfich%, ,nd%(i%)
		ELSE
			GET #kfich%, ,na%(i% - bar%/2)
		END IF
	NEXT i%
END SUB
 '********************************************************************
SUB Tablax (ber%, lfich%, ncu%())
 ' Index read from disk
 '********************************************************************
	FOR i% = 1 TO ber%
		GET #lfich%, ,ncu%(i%)
	NEXT i%
END SUB
 '********************************************************************
SUB Tablat (bir%, ifich%, atu() AS bap, avu() AS sap, nt%)
 'read the index format TYPE from disk 
 '********************************************************************
	FOR i% = 1 TO bir%
		IF nt% = 1 THEN
			GET #ifich%, , atu(i%).tst1
			GET #ifich%, , atu(i%).tst2
		ELSE
			GET #ifich%, , avu(i%).tsk1
			GET #ifich%, , avu(i%).tsk2
			GET #ifich%, , avu(i%).tsk3
			GET #ifich%, , avu(i%).tsk4
		END IF
	NEXT i%
END SUB 
 '********************************************************************
SUB Sdlm (kt%, s1%, s2%, s3%, s4%, s5%, s6%, s7%, s8%)
 ' Translation based on the face of the cube
 ' Watch or reverse direction ( depending on the parameters s1% to s8% passed )
 ' input :
 ' kt% =identity of the face
 ' if s1% to s8% are 3, 2, 1, 4, 7, 8, 9, 6 then clockwise direction
 ' if s1% to.s8% are 1, 2, 3, 6, 9, 8, 7, 4 then the reverse of WATCH
 ' output:
 ' C%(kt%, sX%) translated according to the direction (sX% = of 1 to 8)
 '********************************************************************
	D1% = C%(kt%, s1%)
	D2% = C%(kt%, s2%)
	C%(kt%, s1%) = C%(kt%, s3%)
	C%(kt%, s2%) = C%(kt%, s4%)
	C%(kt%, s3%) = C%(kt%, s5%)
	C%(kt%, s4%) = C%(kt%, s6%)
	C%(kt%, s5%) = C%(kt%, s7%)
	C%(kt%, s6%) = C%(kt%, s8%)
	C%(kt%, s7%) = D1%
	C%(kt%, s8%) = D2%
END SUB
 '********************************************************************
SUB Test (c1%, c2%, av%, af$, cma$)
 ' display the contents of af$
 ' execution of the contents of coma$
 '********************************************************************
	IF (c1% > 0) AND (C%(c1%, c2%) = av%) THEN EXIT SUB
	color P%(7)
	PRINT af$: Rotax cma$
END SUB
 '********************************************************************
SUB TestT1 (d1%, d2%, vb%, f1a$, f2a$, mca1$, mca2$)
 ' display the contents of f1a$ OR f2a$
 ' execution of the contents of moca1$ OR moca2$
 '********************************************************************
	color P%(7)
	IF C%(d1%, d2%) = vb% THEN
		PRINT f1a$
		Rotax mca1$
	ELSE
		PRINT f2a$
		Rotax mca2$
	END IF
END SUB
 '********************************************************************
SUB TestK1 (a1%, a2%, a3%, a4%, va1%, af1$, af2$, ac1$, ac2$)
 ' display the contents of	af1$ OR af2$
 ' execution of the contents of	acmo1$ OR acmo2$
 '********************************************************************
	IF C%(a1%, a2%) = va1% THEN EXIT SUB
	color P%(7)
	IF C%(a3%, a4%) = va1% THEN
		PRINT af1$
		Rotax ac1$
	ELSE
		PRINT af2$
		Rotax ac2$
	END IF
END SUB
 '********************************************************************
SUB TestK2 (b1%, b2%, b3%, b4%, va%, fa1$, fa2$, fa3$, ca1$, ca2$, ca3$)
 ' display the contents of fa1$ OR fa2$ OR fa3$
 ' execution of the contents of camo1$ OR camo2$ OR camo3$
 '********************************************************************
	color P%(7)
	IF C%(b1%, b2%) = va% THEN
		PRINT fa1$
		Rotax ca1$
	ELSEIF C%(b3%, b4%) = va% THEN
		PRINT fa2$
		Rotax ca2$
	ELSE
		PRINT fa3$
		Rotax ca3$
	END IF
END SUB
 '********************************************************************
SUB TraceFace (v1%, v2%, v3%, v4%, v5%, v6%)
 ' allocation of items Transmits v1% to v6% = face
 ' The parameters t1% to t13% are different depending on the face
 ' t14% and t15% are used only for the face 5
 '********************************************************************
	' graphic cursor position X (Part 1)
	' graphic cursor position Y (Part 1)
	Kx1% = 175: Ky1% = 230
	Kx2% = 480: Ky2% = Ky1%
	u0% = 0: u1% = 30: u2% = 15: u3% = Kfsn% 
	dt% = (u1% + spr%): du% = (u3% + spr%)
	dv% = (u2% + spr%)
	FOR v7% = 1 TO 6
		t4% = u0%: t5% = u2%: t6% = -u1%
		t7% = u0%: t8% = u3%: t9% = -u1%
		t10% = u1%: t11% = u0%: t13% = 10
		IF v7% = 1 THEN
			t1% = v1%
			t2% = Kx1%: t3% = Ky1%
			t4% = -u3%: t9% = -u2%
			t12% = -15
		ELSEIF v7% = 2 THEN
			t1% = v2%
			t5% = u1%: t8% = u0%
			t12% = -10
		ELSEIF v7% = 3 THEN
			t1% = v3%
			t2% = t2% + (2 * dt%) + du%
			t3% = t3% - (3 * dt%) - u3% - spr% 
			t5% = u1%: t6% = -u3%
			t7% = u2%: t8% = u0%
			t10% = u3%: t11% = -u2%
			t12% = -3
		ELSEIF v7% = 4THEN
			t1% = v4%
			' graphic cursor position X (Part 2)
			' graphic cursor position Y (Part 2)
			t2% = Kx2%: t3% = Ky2%
			t5% = u1%: t8% = u0%
			t12% = -10
		ELSEIF v7% = 5 THEN
			t1% = v5%
			t2% = t2% - (2 * dt%) - spr%
			t3% = t3% - 2 * u1%
			t4% = -u3%: t6% = u0%
			t7% = u1%: t9% = -u2%
			t10% = u0%: t11% = -u1%
			t12% = -4 
			t14% = t2%: t15% = t3%
		ELSEIF v7% = 6 THEN
			t1% = v6%
			t2% = t2% + (3 * dt%) + (2 * spr%)
			t3% = t3% - (2 * dv%) - spr%
			t4% = -u3%: t6% = u1%
			t9% = -u2%: t10% = -u1%
			t12% = 15
		END IF
		FOR i% = 0 TO 2
			' I% from 0 instead of 1 for the calculation
			' used in PAINT.... P% ( C% (t1% (3 * i% +j% )))
			FOR j% = 1 TO 3
				' fixed coordinate x1, y1 Relative plot x1dx, y1  dy
				LINE (t2%, t3%)-STEP(t4%, t5%), 7
				' Relative plot x1 = x1  dx, y1 = y1   dy
				LINE -STEP(t6%, t7%), 7
				'  Relative plot x1 = x1  dx, y1 = y1  dy
				LINE -STEP(t8%, t9%), 7
				'  Relative plot x1 = x1  dx, y1 = y1  dy
				LINE -STEP(t10%, t11%), 7
				' facet color, the pointer must be inside the border closed!
				PAINT STEP(t12%, t13%), P%(C%(t1%, (3 * i% + j%))), 7
				' update (s) pointer (s) graphic (s) for future internal layout
				' of the corresponding face.
				' EX: In the face ( t1 % ) the procedure trace facets 1, 2 and 3
				IF t1% > 0 AND t1% < 4 THEN
					t2% = t2% + dt%
				ELSEIF t1% > 3 AND t1% < 6 THEN 
					t2% = t2% + du%
					IF t1% = 4 AND t2% = 242 THEN t2% = t2% -1
					t3% = t3% - dv%
				ELSE
					t2% = t2% - du%
					t3% = t3% + dv%
				END IF
			NEXT j%
			' update the graphics pointers x and y for the future path 
			' The procedure prepares the layout of the facets 4, 5 and 6 and 
			' The layout of the facets 7, 8 and 9   t1% = No Face 
			IF t1% = 1 THEN
				t2% = t2% - (3 * dt%) - u3% - 1
				t3% = t3% + dv%
			ELSEIF t1% = 2 OR t1% = 3 THEN
				t2% = t2% - (3 * dt%)
				t3% = t3% + dt%
			ELSEIF t1% = 4 THEN
				t2% = t2% - (3 * du%)
				t3% = t3% + (3 * (u1% - spr%))
			ELSEIF t1% = 5 THEN
				t2% = t14%
				t3% = t15% + dt%
				t14% = t2%
				t15% = t3%
			ELSE
				t2% = t2% + du% + spr% 
				t3% = t3% - (3 * du%)
			END IF
		NEXT i%
	NEXT v7%
END SUB
 '********************************************************************
SUB TRI (am$())
 '  put the files in order.
 '------------------------------------------------------------------------------
    DIM tbx$(16)
	SHARED Mind%
	FOR i% = 1 to Mind%
		IF INSTR(am$(i%), ".") = 7 THEN
			xi% = VAL(MID$(am$(i%), 6, 1))
			tbx$(xi%) = am$(i%)
		ELSE
			xi% = VAL(MID$(am$(i%), 6, 2))
			tbx$(xi%) = am$(i%)
		END IF
	NEXT I%
	FOR I% = 1 TO MIND%
		am$(i%) = tbx$(I%)
	NEXT i%
	ERASE tbx$
END SUB
 '********************************************************************
SUB Translat (mx%, lz%, ll$)	'STATIC
 ' Performs the translation of the elementary cubes after the rotation of the faces
 ' Using Variables bt%, bu%, bv%, bw% of value 1, 2, 3 and 4
 '********************************************************************
	DIM R.Ms AS STRING * 8
	SELECT CASE mx%
		CASE 1, 2
'   Rotation Front SENSE WATCH
			TR$(1) = "1987"
			TR$(2) = "2369"
			TR$(3) = "6123"
			TR$(4) = "4741"
			R.Ms = "AEHDPLMT"
'   Rotate front opposite direction of the WATCH
			IF mx% = 2 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = '"ADHEPTML"
		CASE 3, 4
'   Rear View Rotating clockwise direction
			TR$(1) = "1123"
			TR$(2) = "4369"
			TR$(3) = "6987"
			TR$(4) = "2741"
			R.Ms = "BCGFJORN"
'   Rear View Rotating opposite direction of the WATCH
			IF mx% = 4 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = "BFGCJNRO"
		CASE 5, 6
'   Rotation Facing high sense of the WATCH
			TR$(1) = "3123"
			TR$(2) = "4123"
			TR$(3) = "5123"
			TR$(4) = "2123"
			R.Ms = "ADCBILKJ"
'   Rotation Facing high opposite direction of the WATCH
			IF mx% = 6 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = "ABCDIJKL"
		CASE 7, 8
'   Rotate bottom face clockwise direction
			TR$(1) = "3987"
			TR$(2) = "2987"
			TR$(3) = "5987"
			TR$(4) = "4987"
			R.Ms = "EFGHQRST"
'   Rotate bottom wall opposite direction of the WATCH
			IF mx% = 8 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = "EHGFQTSR"
		CASE 9, 10
'   Rotate left face clockwise direction
			TR$(1) = "1741"
			TR$(2) = "5369"
			TR$(3) = "6741"
			TR$(4) = "3741"
			R.Ms = "ABFEINQM"
'   Rotate left side opposite direction of the WATCH
			IF mx% = 10 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = "AEFBIMQN"
		CASE 11, 12
'   Rotate right face clockwise direction
			TR$(1) = "1369"
			TR$(2) = "3369"
			TR$(3) = "6369"
			TR$(4) = "5741"
			R.Ms = "DHGCKPSO"
'   Rotate right face opposite direction of the WATCH
			IF mx% = 12 THEN invrc TR$(): R.Ms = Invert$(R.Ms) ' = "DCGHKOSP"
	END SELECT
	REDIM ma%(4), kf%(4, 3), E%(8)
	FOR ix% = 1 TO 4
		ma%(ix%)	= VAL(LEFT$(TR$(ix%), 1))
		kf%(ix%, bt%)	= VAL(MID$(TR$(ix%), 2, 1))
		kf%(ix%, bu%)	= VAL(MID$(TR$(ix%), 3, 1))
		kf%(ix%, bv%)	= VAL(RIGHT$(TR$(ix%), 1))
	NEXT ix%
	D1% = C%(ma%(bt%), kf%(bt%, bt%))
	D2% = C%(ma%(bt%), kf%(bt%, bu%))
	D3% = C%(ma%(bt%), kf%(bt%, bv%))
	C%(ma%(bt%), kf%(bt%, bt%))	= C%(ma%(bu%), kf%(bu%, bt%))
	C%(ma%(bt%), kf%(bt%, bu%))	= C%(ma%(bu%), kf%(bu%, bu%))
	C%(ma%(bt%), kf%(bt%, bv%))	= C%(ma%(bu%), kf%(bu%, bv%))
	C%(ma%(bu%), kf%(bu%, bt%))	= C%(ma%(bv%), kf%(bv%, bt%))
	C%(ma%(bu%), kf%(bu%, bu%))	= C%(ma%(bv%), kf%(bv%, bu%))
	C%(ma%(bu%), kf%(bu%, bv%))	= C%(ma%(bv%), kf%(bv%, bv%))
	C%(ma%(bv%), kf%(bv%, bt%))	= C%(ma%(bw%), kf%(bw%, bt%))
	C%(ma%(bv%), kf%(bv%, bu%))	= C%(ma%(bw%), kf%(bw%, bu%))
	C%(ma%(bv%), kf%(bv%, bv%))	= C%(ma%(bw%), kf%(bw%, bv%))
	C%(ma%(bw%), kf%(bw%, bt%))	= D1%
	C%(ma%(bw%), kf%(bw%, bu%))	= D2%
	C%(ma%(bw%), kf%(bw%, bv%))	= D3%
	FOR y% = 1 TO LEN(R.Ms)
		E%(y%) = ASC(MID$(R.Ms, y%, 1)) - 64
	NEXT y%
	FOR y% = 1 TO UBOUND(E%)
		IF y% = 1 THEN IT% = T%(E%(y%))
		IF y% < 4 THEN T%(E%(y%)) = T%(E%(y% + 1))
		IF y% = 4 THEN T%(E%(y%)) = IT%
		IF y% = 5 THEN IT% = T%(E%(y%))
		IF (y% >= 5) AND (y% < 8) THEN T%(E%(y%)) = T%(E%(y% + 1))
		IF y% = 8 THEN T%(E%(y%)) = IT%
	NEXT y%
	Affcub lz%, ll$, tem%
END SUB
'******************************************************************************
' End of file "cubrnEN.bas"
