\EdFont.xpl	MAR-18-94
\Font editor. This currently only handles 14-byte high fonts (.F14).
\by Loren Blaney

inc	C:\CXPL\CODESI;		\Include code definitions for intrinsic routines

char	FontTable;
def	FontSize=3584;

int	CpuReg,		\address of CPU registers
	PspSeg,		\address of PSP segment (for file I/O)
	DataSeg;	\address of data segment (heap & stack)

def	Nul=$00, Bel=$07, BS=$08, Tab=$09, LF=$0a, FF=$0c,	\Control chars
	CR=$0d, EOF=$1a, Esc=$1b, Sp=$20, Ctrl=$40;
def	Up=-$48, Dn=-$50, Lt=-$4b, Rt=-$4d, PgUp=-$49,		\-Scan codes
	PgDn=-$51, End=-$4f, Home=-$47, Del=-$53;

def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS, SS, ES;		\Getreg registers

def	Black, Blue, Green, Cyan, Red, Magenta, Brown, White,	\Attribute colors
	Gray, LBlue, LGreen, LCyan, LRed, LMagenta, Yellow, LWhite; \ EGA palette

\Global variables for DOS I/O routines:
int	InHandle,	\input file handle (= -1 if no input file)
	OutHandle;	\output file handle (= -1 if no output file)
addr	InFileName,	\input file name (all file names are zero terminated)
	OutFileName,	\output file name
	TmpFileName,	\temporary output file name (.$$$)
	BakFileName;	\backup output file name (.BAK)
def	NameSize=80;	\maximum number of chars in a file name (incl path)

\========================== DOS I/O ROUTINES ==========================

func	DosOpen(InExt, OutExt);	\Open MS-DOS files. Returns: 0 if no errors;
\ 1 if error opening input file; 2 if error opening output file.
addr	InExt, OutExt;	\input and output extensions
int	Inx;		\index into CmdLine
addr	CmdLine;	\command line tail


	proc	CopyName(From, To, Ext);
	\Copy file name and replace any existing extension with "Ext".
	\If "Ext" = "???" then use extension from "From".
	addr	From, To,	\strings are 0 terminated
		Ext;		\extension
	int	I, J, Ch;
	begin
	I:= 0;
	loop	begin				\copy file name
		Ch:= From(I);
		if Ch=^. ! Ch=0 then quit;
		To(I):= Ch;
		if I < NameSize-1 then I:= I +1;
		end;
	To(I):= ^.;				\copy extension
	if I < NameSize-1 then I:= I +1;
	for J:= 0, 2 do
		begin
		Ch:= Ext(J) & $7F;
		To(I):= if Ch=^? then From(I) else Ch;
		if I < NameSize-1 then I:= I +1;
		end;
	To(I):= 0;				\terminate string
	end;	\CopyName



	proc	GetName(Name);
	\Read file name from command line and return it in "Name".
	\The command line is terminated by a CR.
	addr	Name;
	int	I, Ch;


		proc	GetCh;	\Get character, stripping out switches
		begin
		loop	begin
			Ch:= CmdLine(Inx);
			Inx:= Inx +1;
			if Ch # ^/ then quit;
			Ch:= CmdLine(Inx);	\ignore any one-char switches
			Inx:= Inx +1;
			if Ch = CR then quit;	\handle wise guys
			end;
		end;	\GetCh


	begin	\GetName
	repeat GetCh until Ch # SP;		\skip any leading spaces
	I:= 0;
	loop	begin
		case Ch of SP, CR, ^,: Ch:= 0 other; \terminate Name with 0
		Name(I):= Ch;
		if Ch = 0 then quit;
		if I < NameSize-1 then I:= I +1;
		GetCh;
		end;
	end;	\GetName


begin	\DosOpen
CmdLine:= Reserve($7F);			\get command tail from PSP
Blit(PspSeg, $81, DataSeg, CmdLine, $7F);
CmdLine($7E):= CR;			\make sure it's terminated with a CR

InHandle:= -1;   OutHandle:= -1;	\set to illegal values

Inx:= 0;
if InExt(0) # SP then
	begin				\get the input file name
	GetName(InFileName);
	CopyName(InFileName, InFileName, InExt);

	Trap(false);
	InHandle:= Fopen(InFileName, 0);
	Trap(true);
	if Geterr # 0 then		\file or path does not exist,
		[InHandle:= -1;   return 1]; \ SHARE conflict, etc.
	Fset(InHandle, ^I);
	end;

if OutExt(0) # SP then
	begin				\get the output file name
	if Inx > 0 then Inx:= Inx -1;	\backup in case of CR
	GetName(OutFileName);
	if OutFileName(0) =0 then	\if no outfile then use the infile
		CopyName(InFileName, OutFileName, OutExt)
	else	CopyName(OutFileName, OutFileName, OutExt);

	CopyName(OutFileName, TmpFileName, "$$$");
	CopyName(OutFileName, BakFileName, "BAK");

	Trap(false);
	OutHandle:= Fopen(TmpFileName, 1);
	Trap(true);
	if Geterr # 0 then		\path does not exist, file already exists
		[OutHandle:= -1;   return 2]; \ root directory full, etc.
	Fset(OutHandle, ^O);
	end;

return 0;				\no errors
end;	\DosOpen

\----------------------------------------------------------------------

func	DosClose;	\Close MS-DOS files. Returns: 0 if no errors;
\ 1 if error closing input file; 2 if error closing output file.
begin
if InHandle # -1 then
	begin
	Trap(false);
	Fclose(InHandle);
	Trap(true);
	if Geterr # 0 then return 1;
	end;

if OutHandle # -1 then
	begin
	Trap(false);
	Fclose(OutHandle);

	CpuReg(\AX\0):= $4100;		\DEL OutFileName.BAK
	CpuReg(\DS\9):= DataSeg;
	CpuReg(\DX\3):= BakFileName;
	Softint($21);			\(.BAK file might not exist)

	CpuReg(\AX\0):= $5600;		\REN OutFileName.EXT OutFileName.BAK
	CpuReg(\DS\9):= DataSeg;
	CpuReg(\DX\3):= OutFileName;
	CpuReg(\ES\11):= DataSeg;
	CpuReg(\DI\4):= BakFileName;
	Softint($21);

	CpuReg(\AX\0):= $5600;		\REN OutFileName.$$$ OutFileName.EXT
	CpuReg(\DS\9):= DataSeg;
	CpuReg(\DX\3):= TmpFileName;
	CpuReg(\ES\11):= DataSeg;
	CpuReg(\DI\4):= OutFileName;
	Softint($21);

	Trap(true);
	if Geterr # 0 then return 2;	\disk write error when flushing buffers
	end;

return 0;				\no errors
end;	\DosClose

\======================================================================

func	Rol(N, C);		\Rotate byte N left C bits
int	N, C;
return N<<C ! N>>(8-C);



func	Ror(N, C);		\Rotate byte N right C bits
int	N, C;
return N>>C ! N<<(8-C);



func	SwapBits(N);		\Swap the order of the bits in N
int	N;
int	B, M;
begin
B:= 1;   M:= 0;
while N\#0\ do
	begin
	if N < 0 then M:= M +B;	\Or bit into M if MSB of N is set
	B:= B +B;		\Shift left
	N:= N +N;
	end;
return	M;
end;	\SwapBits



func	ShiftKey;		\Returns 'true' if a shift key is down
begin
Cpureg(AX):= $0200;
SoftInt($16);
return (Cpureg(AX)&$03) # 0;
end;	\ShiftKey



func	GetKey;			\Get character from keyboard (wait if necessary)
int	Ch;			\This is a low-level routine with no echo,
begin				\ no Ctrl-C, and no cursor.
Cpureg(AX):= 0;			\Function $00
SoftInt($16);			\Call BIOS routine
Ch:= Cpureg(AX) & $ff;
if Ch = 0 then			\Return non-ascii chars as negative scan code
	Ch:= -(Cpureg(AX)>>8);
return Ch;
end;	\GetKey



proc	Ctxt(X, Y, Str);	\Display a string on device 6 at X, Y
int	X, Y;
char	Str;
begin
Cursor(X, Y);
Text(6, Str);
end;	\Ctxt



proc	RCtxt(X, Y, Str);	\Display a string of raw text at X, Y
int	X, Y;
char	Str;
begin
Cursor(X, Y);
RawText(6, Str);
end;	\RCtxt



proc	Hex2out(Dev, N);	\Output two hex digits (a byte)
int	Dev, N;
char	HexDigit;
begin
HexDigit:= "0123456789ABCDEF ";
Chout(Dev, HexDigit(N>>4 & $0f));
Chout(Dev, HexDigit(N & $0f));
end;	\Hex2out

\======================================================================

proc	Show(Atb);
int	Atb;
int	Ch;
begin
Attrib($00);
Text(6, "        ");
Attrib(Atb);
for Ch:= 0, 255 do
	begin
	case Ch of
	  CR,LF:  Chout(6, ^.)
	other Chout(6, Ch);
	if (Ch&$3f) = $3f then
		[Crlf(6);
		Attrib($00);
		Text(6, "        ");
		Attrib(Atb)];
	end;
Crlf(6);
end;	\Show



proc	Edit;		\Edit character fonts
int	Ch,		\selected character
	I, J,		\scratch
	Xc, Yc,		\coordinates in character selection table
	X, Y,		\coordinates in big edit box
	Byte,
	Key;		\key command for editing
char	Copy;
def	X0=30, Y0=10;		\Coords for big character
def	X1= 8, Y1= 5;		\Coords for little characters
begin
Copy:= Reserve(14);

Xc:= 0;  Yc:= 0;
loop	begin
	Cursor(0, 0);
	Show($1f);
	Show($07);

	Attrib($07);	\white on black
	Ctxt(5, Y0+4, "Move:   ");  Chout(6, $1b);
	Chout(6, Sp); Chout(6, $1a);
	Chout(6, Sp); Chout(6, $18);
	Chout(6, Sp); Chout(6, $19);
	Ctxt(5, Y0+5, "Change: Space");
	Ctxt(5, Y0+6, "Shift:  Sh- ");  Chout(6, $1b);
	Chout(6, Sp); Chout(6, $1a);
	Chout(6, Sp); Chout(6, $18);
	Chout(6, Sp); Chout(6, $19);
	Ctxt(5, Y0+7, "Mirror: Tab");
	Ctxt(5, Y0+8, "Save:   Enter");
	Ctxt(5, Y0+9, "Exit:   Esc");

	\Test patterns:
	Ctxt(54, 12, "PACK MY BOX WITH FIVE");
	Ctxt(54, 13, "DOZEN LIQUOR JUGS.  ");
	Ctxt(54, 14, "pack my box with five");
	Ctxt(54, 15, "dozen liquor jugs.  ");
	RCtxt(54,16, "ĿĪ͸ ");
	RCtxt(54, 17,"/\=-߱ ");
	RCtxt(54, 18,"Ĵ=_͵ ");
	RCtxt(54, 19,"  ; ");
	RCtxt(54, 20,"ķ | ͻ ");
	RCtxt(54, 21,"+-= _   ݺ ");
	RCtxt(54, 22,"Ķ  ͹ ");
	RCtxt(54, 23,"Ľ  ͼ ");

	Attrib($1F);
	Ctxt(5, Y0+1, " Select Character ");

	loop	begin
		Ch:= Xc + Yc*64;
		Attrib($CF);				\Show cursor
		Cursor(X1+Xc, Y1+Yc);  Chout(6, Ch);

		Key:= GetKey;

		Attrib($07);
		Cursor(X1+Xc, Y1+Yc);  Chout(6, Ch);

		case Key of
		  Lt:	Xc:= (Xc - (if ShiftKey then 8 else 1)) & $3F;
		  Rt:	Xc:= (Xc + (if ShiftKey then 8 else 1)) & $3F;
		  Up:	[Yc:= Yc -1;  if Yc<0 then Yc:= 4-1];
		  Dn:	[Yc:= Yc +1;  if Yc>=4 then Yc:= 0];
		  CR,Sp:quit;
		  Esc:	return
		other	if Key>=0 & Key<=255 then
			    [Ch:= Key;  Xc:= Ch&$3F;  Yc:= Ch>>6;  quit]
			else Sound(1, 2, 1190);
		end;

	Attrib($00);		\Clear Select Character message
	Ctxt(5, Y0+1, "                  ");

	\Do actual editing
	\Save a copy of the font for the selected char for abort (=Esc)
	for J:= 0, 14-1 do Copy(J):= FontTable(Ch*14+J);

	X:= 0;  Y:= 0;
	loop	begin
		\Show small character
		Attrib($07);  Cursor(X0+16+3, Y0);
		Chout(6, ^$);  Hex2out(6, Ch);
		Attrib($1F);
		Cursor(X0+16+4, Y0+1);  Chout(6, Ch);

		\Display big image (8x14)
		for J:= 0, 14-1 do
			begin
			Byte:= FontTable(Ch*14+J);
			Cursor(X0, Y0+J);
			for I:= 0, 7 do
				begin
				if Byte & $80>>I then
					[Chout(6, ^);  Chout(6, ^)]
				else	[Chout(6, ^.);  Chout(6, ^ )];
				end;
			end;

		\Show cursor
		\Hilight(X0+X+X, Y0+Y, X0+X+X+1, Y0+Y, $C7);  XPL BUG
		Attrib($1C);
		Cursor(X0+X+X, Y0+Y);  Chout(6, ^);

		Key:= GetKey;

		\Hilight(X0+X+X, Y0+Y, X0+X+X+1, Y0+Y, $07);
		Attrib($1F);
		Cursor(X0+X+X, Y0+Y);
		if FontTable(Ch*14+Y) & $80>>X then
			Chout(6, ^)
		else	Chout(6, ^.);

		case Key of
		  Lt:	if ShiftKey then
			  for J:= 0, 14-1 do
			    FontTable(Ch*14+J):= Rol(FontTable(Ch*14+J), 1)
			else X:= (X -1) & 7;
		  Rt:	if ShiftKey then
			  for J:= 0, 14-1 do
			    FontTable(Ch*14+J):= Ror(FontTable(Ch*14+J), 1)
			else X:= (X +1) & 7;
		  Up:	if ShiftKey then
			  [I:= FontTable(Ch*14);
			  for J:= 0, 14-2 do
			    FontTable(Ch*14+J):= FontTable(Ch*14+J+1);
			  FontTable(Ch*14+14-1):= I]
			else [Y:= Y -1;  if Y<0 then Y:= 14-1];
		  Dn:	if ShiftKey then
			  [I:= FontTable(Ch*14+14-1);
			  for J:= -(14-1), -1 do
			    FontTable(Ch*14-J):= FontTable(Ch*14-J-1);
			  FontTable(Ch*14):= I]
			else [Y:= Y +1;  if Y>=14 then Y:= 0];
		  SP:	begin
			FontTable(Ch*14+Y):= FontTable(Ch*14+Y) | ($80>>X);
			end;
		  Tab:	for J:= 0, 14-1 do
			  FontTable(Ch*14+J):= Swap(SwapBits(FontTable(Ch*14+J)));
		  CR:	quit;
		  Esc:	[for J:= 0, 14-1 do 		\discard
				FontTable(Ch*14+J):= Copy(J);
			quit]
		other;
		end;
	end;
end;	\Edit



proc	Start;		\Example procedure
int	I, Ch;
begin
\Load font from file
Openi(3);
for I:= 0, FontSize-1 do
	begin
	FontTable(I):= Chin(3);
	end;

\Setvid($10);		\\640x350x16
SetVid($12);

\Set up font so it can be displayed, i.e. set up vector 43
Cpureg(AX):= $1121;
Cpureg(BX):= $0002;	\25 rows
Cpureg(CX):= 14;	\bytes per char
Cpureg(ES):= DataSeg;
Cpureg(BP):= FontTable;
Softint($10);

Edit;

\Write the font table to the output file
Openo(3);
for I:= 0, FontSize-1 do
	begin
	Chout(3, FontTable(I));
	end;
Close(3);

Setvid(3);
end;	\Start



begin	\Main
CpuReg:= Getreg;
PspSeg:= CpuReg(11);
DataSeg:= CpuReg(12);

FontTable:= Reserve(FontSize);

InFileName:= Reserve(NameSize);
OutFileName:= Reserve(NameSize);
TmpFileName:= Reserve(NameSize);
BakFileName:= Reserve(NameSize);

case DosOpen("F14", "F14") of
  1:	[Text(0, "Cannot open input file");  exit];
  2:	[Text(0, "Cannot open output file");  exit]
other;

Start;

case DosClose of
  1:	Text(0, "Cannot close input file");
  2:	Text(0, "Cannot close output file")
other;
end;	\Main
