\Font2XPL.XPL	24-Mar-2009
\Convert a font file to a 32-bit XPL constant data array.

include	c:\cxpl\codes;		\intrinsic code definitions

def	Points=14;		\size of font in points (height in dots)
char	FontTbl(256*Points);	\8xPoints font, for 256 characters



proc	WriteFile(Name);	\Write palette and image data as constant arrays
char	Name;	\file name
int	H, I;	\handle, index
int	FontTbl4;
begin
H:= FOpen(Name, 1);			\open file for output and get its handle
FSet(H, ^O);				\set device 3 to output to this handle
OpenO(3);				\initialize output to device 3

FontTbl4:= FontTbl;			\access 4 bytes at a time
Text(3, "Font:= [
");
for I:= 0, 256*Points/4-2 do
	begin
	ChOut(3, ^$);
	HexOut(3, FontTbl4(I));
	ChOut(3, ^,);
	if (I&$7) = 7 then CrLf(3);
	end;
ChOut(3, ^$);
HexOut(3, FontTbl4(I));
Text(3, "];
");

Close(3);
FClose(H);				\release handle
end;	\WriteFile



proc	LoadFont(Name);		\Load a font file
char	Name;			\file name
int	H, I;			\handle, index
begin
H:= FOpen(Name, 0);		\open file and get its handle
FSet(H, ^I);			\set device 3 to input from this handle
OpenI(3);			\initialize input from device 3

for I:= 0, 256*Points-1 do	\for 256 characters each Points dots high...
	FontTbl(I):= ChIn(3);

FClose(H);			\release handle
end;	\LoadFont



begin	\Main
LoadFont("FONT.F14");
WriteFile("FONT.XPL");
end;	\Main
