'    Created: 03/03/2012
'    Updated: 03/06/2012
'       Name: Frenzy
'    Version: 0.2
' Created By: Nukem Enterprises
'   Web Site: https://eriks.servehttp.com

' early beta. Still needs work.

DECLARE SUB drawBackground ()
DECLARE FUNCTION checkDeath! (player AS ANY, bg() AS ANY)
DECLARE FUNCTION checkGoal! (player AS ANY, goal() AS ANY)
DECLARE SUB titleScr ()
DECLARE SUB printObj (objIn AS ANY)
DECLARE FUNCTION checkCollision! (newXpos%, newYpos%, bg() AS ANY, wall() AS ANY)
DECLARE SUB moveObj (newXpos%, newYpos%, objIn AS ANY)
RANDOMIZE TIMER

CONST MAXOBJS = 5
CONST MAXWALLOBJS = 50
CONST TRUE = 1
CONST FALSE = 0
CONST VERSION = "0.2"

TYPE obj
  xPos AS INTEGER
  yPos AS INTEGER
  charVal AS STRING * 1
  objColor AS INTEGER
  health AS INTEGER
  healthTick AS INTEGER
END TYPE

CALL titleScr

DIM lvlNum AS INTEGER
lvlNum = 1

DIM score AS LONG
score = 0

'game loop
DO WHILE INP(96) <> 1
CLS
CALL drawBackground

'init badguy
DIM bg(MAXOBJS) AS obj
FOR i% = 0 TO MAXOBJS
  bg(i%).xPos = (RND * 50) + 1
  bg(i%).yPos = (RND * 20) + 1
  bg(i%).charVal = CHR$(4)
  bg(i%).objColor = 12
  LOCATE bg(i%).yPos, bg(i%).xPos
  COLOR bg(i%).objColor
  CALL printObj(bg(i%))
NEXT i%

'init walls
DIM wall(MAXWALLOBJS) AS obj
FOR i% = 0 TO MAXWALLOBJS
  wall(i%).xPos = (RND * 50) + 1
  wall(i%).yPos = (RND * 20) + 1
  wall(i%).charVal = ""
  wall(i%).objColor = 2
  LOCATE wall(i%).yPos, wall(i%).xPos
  COLOR wall(i%).objColor
  CALL printObj(wall(i%))
NEXT i%


'init goal
DIM goal(4) AS obj
goal(0).xPos = (RND * 50) + 1
goal(0).yPos = (RND * 20) + 1
goal(1).xPos = goal(0).xPos + 1
goal(1).yPos = goal(0).yPos
goal(2).xPos = goal(0).xPos + 1
goal(2).yPos = goal(0).yPos + 1
goal(3).xPos = goal(0).xPos
goal(3).yPos = goal(0).yPos + 1

FOR i% = 0 TO 4
  goal(i%).charVal = ""
  goal(i%).objColor = 14
  CALL printObj(goal(i%))
NEXT i%



'init player
DIM player AS obj
player.xPos = (RND * 50) + 1
player.yPos = (RND * 20) + 1
player.charVal = CHR$(2)
player.objColor = 15
CALL printObj(player)
'player specific
player.health = 100
player.healthTick = 51

'drawPlayerHealthBar
FOR i% = 1 TO player.healthTick
  LOCATE 23, i%
  IF i% <= 16 THEN
    COLOR 4
  ELSEIF i% > 16 AND i% <= 32 THEN
    COLOR 14
  ELSE
    COLOR 10
  END IF
  PRINT ""
NEXT i%

DIM goalCol AS INTEGER
goalCol = FALSE

DIM dead AS INTEGER
dead = FALSE

LOCATE 5, 53
COLOR 15
PRINT "Level: "; lvlNum

'read keyboard from buffer much faster
DO WHILE INP(96) <> 1 AND goalCol = FALSE
   
'  LOCATE 23, 20
'  COLOR 7
'  PRINT "("; player.xPos; ","; player.yPos; ")"

  LOCATE 6, 53
  COLOR 15
  PRINT "Score: "; score
 

  'up
  IF INP(96) = 72 THEN
    colDec = checkCollision(player.xPos, player.yPos - 1, bg(), wall())
    IF colDec = FALSE THEN
      CALL moveObj(player.xPos, player.yPos - 1, player)
      score = score + 1
    END IF
  END IF
 
  'down
  IF INP(96) = 80 THEN
    colDec = checkCollision(player.xPos, player.yPos + 1, bg(), wall())
    IF colDec = FALSE THEN
      CALL moveObj(player.xPos, player.yPos + 1, player)
      score = score + 1
    END IF
  END IF

  'left
  IF INP(96) = 75 THEN
    colDec = checkCollision(player.xPos - 1, player.yPos, bg(), wall())
    IF colDec = FALSE THEN
      CALL moveObj(player.xPos - 1, player.yPos, player)
      score = score + 1
    END IF
  END IF


  'right
  IF INP(96) = 77 THEN
    colDec = checkCollision(player.xPos + 1, player.yPos, bg(), wall())
    IF colDec = FALSE THEN
      CALL moveObj(player.xPos + 1, player.yPos, player)
      score = score + 1
    END IF
  END IF
 
  'move bad guys
  moveRand = (RND * 100) + 1
  IF moveRand > 85 - lvlNum THEN
  FOR i% = 0 TO MAXOBJS

    wrongMoveRand = (RND * 100) + 1
    IF player.xPos > bg(i%).xPos THEN
      IF wrongMoveRand > 60 + lvlNum THEN
        CALL moveObj(bg(i%).xPos - 1, bg(i%).yPos, bg(i%))
      ELSE
        CALL moveObj(bg(i%).xPos + 1, bg(i%).yPos, bg(i%))
      END IF
      
    END IF

    IF player.xPos < bg(i%).xPos THEN
      IF wrongMoveRand > 60 + lvlNum THEN
        CALL moveObj(bg(i%).xPos + 1, bg(i%).yPos, bg(i%))
      ELSE
        CALL moveObj(bg(i%).xPos - 1, bg(i%).yPos, bg(i%))
      END IF
      
    END IF

    IF player.yPos > bg(i%).yPos THEN
      IF wrongMoveRand > 60 + lvlNum THEN
        CALL moveObj(bg(i%).xPos, bg(i%).yPos - 1, bg(i%))
      ELSE
        CALL moveObj(bg(i%).xPos, bg(i%).yPos + 1, bg(i%))
      END IF
    END IF

    IF player.yPos < bg(i%).yPos THEN
      IF wrongMoveRand > 60 + lvlNum THEN
        CALL moveObj(bg(i%).xPos, bg(i%).yPos + 1, bg(i%))
      ELSE
        CALL moveObj(bg(i%).xPos, bg(i%).yPos - 1, bg(i%))
      END IF
    END IF
  NEXT i%
  END IF
  'check for goal
  goalCol = checkGoal(player, goal())
  FOR i% = 0 TO 4
    CALL printObj(goal(i%))
  NEXT i%

  dead = checkDeath(player, bg())
  IF dead > 0 THEN
    IF player.healthTick > 0 THEN
      LOCATE 23, player.healthTick
      COLOR 0
      PRINT ""
      player.healthTick = player.healthTick - 1
    END IF
    score = score - 25
  END IF
 
  'no health, player dead
  IF player.healthTick <= 0 THEN
    CLS
    LOCATE 10, 15
    COLOR 14
    PRINT "You have died."
    LOCATE 11, 15
    PRINT "Final Score: "; score
    COLOR 7
    LOCATE 14, 16
    PRINT "Press q to exit"
    DO: LOOP WHILE INKEY$ <> "q"
    END
  END IF

LOOP
lvlNum = lvlNum + 1
score = score + 500 'lvl complete bonus
LOOP

FUNCTION checkCollision (newXpos%, newYpos%, bg() AS obj, wall() AS obj)

collisionFound% = FALSE

'check not out of bounds
IF newXpos% <= 0 OR newYpos% <= 0 OR newXpos% >= 51 OR newYpos% >= 22 THEN
  collisionFound% = TRUE
END IF

FOR i% = 0 TO MAXOBJS
  IF newXpos% = bg(i%).xPos AND newYpos% = bg(i%).yPos THEN
    collisionFound% = TRUE
  END IF
NEXT i%

FOR i% = 0 TO MAXWALLOBJS
  IF newXpos% = wall(i%).xPos AND newYpos% = wall(i%).yPos THEN
    collisionFound% = TRUE
  END IF
NEXT i%


checkCollision = collisionFound%

END FUNCTION

FUNCTION checkDeath (player AS obj, bg() AS obj)

dead = FALSE
deadFlags = 0

FOR i% = 0 TO MAXOBJS
  IF player.xPos = bg(i%).xPos AND player.yPos = bg(i%).yPos THEN
    deadFlags = deadFlags + 1
  END IF
NEXT i%

IF deadFlags >= MAXOBJS - 5 THEN
  dead = TRUE
END IF

checkDeath = deadFlags

END FUNCTION

FUNCTION checkGoal (player AS obj, goal() AS obj)

goalFound = FALSE

FOR i% = 0 TO 4
  IF player.xPos = goal(i%).xPos AND player.yPos = goal(i%).yPos THEN
    goalFound = TRUE
  END IF
NEXT i%
checkGoal = goalFound

END FUNCTION

SUB drawBackground

'draws gamebackground

FOR i% = 1 TO 51
  COLOR 7
  LOCATE 22, i%
  PRINT ""
NEXT i%

FOR i% = 1 TO 21
  COLOR 7
  LOCATE i%, 51
  PRINT ""
NEXT i%

COLOR 14
LOCATE 10, 53
PRINT "Directions:"
COLOR 7
LOCATE 11, 53
PRINT "Avoid bad guys."
LOCATE 12, 53
PRINT "Arrow keys move."
LOCATE 13, 53
PRINT "Press ESC to quit."


END SUB

SUB moveObj (newXpos%, newYpos%, objIn AS obj)

DIM mask AS obj
mask.xPos = objIn.xPos
mask.yPos = objIn.yPos
mask.charVal = ""
mask.objColor = 0

'update object info
objIn.xPos = newXpos%
objIn.yPos = newYpos%

CALL printObj(mask)
CALL printObj(objIn)



END SUB

SUB printObj (objIn AS obj)

IF objIn.yPos > 0 AND objIn.yPos < 22 AND objIn.xPos > 0 AND objIn.xPos < 51 THEN
  LOCATE objIn.yPos, objIn.xPos
  COLOR objIn.objColor
  PRINT objIn.charVal
END IF

END SUB

SUB titleScr
CLS
LOCATE 10, 10
COLOR 10
PRINT "Nukem Enterprises Presents..."

LOCATE 11, 15
COLOR 14
PRINT "<< F R E N Z Y >>"

LOCATE 12, 22
COLOR 8
PRINT "v "; VERSION

LOCATE 14, 20
COLOR 15
PRINT "Press any key to begin"

LOCATE 20, 30
COLOR 4
PRINT "Created 03/2012"

DO
LOOP WHILE INKEY$ = ""

END SUB

