DECLARE SUB drawPreLevelScreen (playerIn AS ANY, levelNum AS INTEGER)
'     R - E - B - E - L
'          v0.3
'     By: Erik Eriksen
'   Date: 03/10/2012
'Updated: 03/16/2012
'    Web: http://eriks.servehttp.com
'
' Early version. Basic level design and simple bad guys.


DECLARE FUNCTION checkDiamondCollision! (playerIn AS ANY, diamondIn() AS ANY)
DECLARE SUB drawDiamonds (daimondsIn() AS ANY)
DECLARE FUNCTION checkBadGuyCollision! (playerIn AS ANY, bgIn() AS ANY)
DECLARE SUB moveBadGuys (bgIn() AS ANY, ghIn() AS ANY)
DECLARE SUB displayDebug (player AS ANY, inputIn AS INTEGER)
DECLARE FUNCTION checkHighGroundCollision! (xPosIn AS INTEGER, yPosIn AS INTEGER, groundHeightIn() AS INTEGER)
DECLARE SUB drawGround (groundHeightIn() AS INTEGER)
DECLARE SUB drawScore (scoreIn%, diamondsIn%, livesIn%)
DECLARE SUB printObj (objIn AS ANY)
DECLARE SUB moveObj (newXpos%, newYpos%, objIn AS ANY)

CLS

RANDOMIZE TIMER
ON ERROR GOTO Handler

CONST TRUE = 0
CONST FALSE = -1
CONST UP = 2
CONST DOWN = 3
CONST LEFT = 4
CONST RIGHT = 5
CONST SCREENWIDTH = 80
CONST SCREENHEIGHT = 23
CONST MAXBADGUYS = 4
CONST MAXDIAMONDS = 25
CONST DIRECTORY = ".\LEVELS\"

TYPE obj
  xPos AS INTEGER
  yPos AS INTEGER
  charVal AS STRING * 1
  objColor AS INTEGER
  score AS INTEGER
  diamonds AS INTEGER
  lives AS INTEGER
  dead AS INTEGER
  maxJumpHeight AS INTEGER
  jumpHeight AS INTEGER
  isJumping AS INTEGER
  jumpDirection AS INTEGER
  jumpEndTime AS LONG
  direction AS INTEGER
  bgMoveMax AS INTEGER
  bgMoveCurrent AS INTEGER
END TYPE

DIM groundHeight(SCREENWIDTH)  AS INTEGER

DIM lvlNumber AS INTEGER
DIM player AS obj
DIM bg(MAXBADGUYS) AS obj

lvlNumber = 1
game% = TRUE
player.score = 0
player.diamonds = 0
player.lives = 5
CHDIR DIRECTORY

DO WHILE game% = TRUE
  'set up player
  player.xPos = 2
  player.yPos = 1
  player.dead = FALSE
  player.charVal = CHR$(2)
  player.objColor = 6
  player.isJumping = FALSE
  player.maxJumpHeight = 5
  player.jumpHeight = player.yPos - player.maxJumpHeight
  player.jumpDirection = DOWN
  player.jumpEndTime = TIMER
  player.direction = RIGHT
  player.bgMoveMax = 5
  player.bgMoveCurrent = 0

  'set up bad guys
  FOR i% = 0 TO MAXBADGUYS
    bg(i%).xPos = (RND * 75) + 17
    bg(i%).yPos = 1
    bg(i%).score = 0
    bg(i%).dead = FALSE
    bg(i%).lives = 0
    bg(i%).charVal = CHR$((RND * 254) + 1)
    bg(i%).objColor = (RND * 15) + 1
    bg(i%).isJumping = FALSE
    bg(i%).maxJumpHeight = 0
    bg(i%).jumpHeight = 0
    bg(i%).jumpDirection = UP
    bg(i%).direction = LEFT
    bg(i%).bgMoveMax = 0
    bg(i%).bgMoveCurrent = 0
  NEXT i%
   
  colDec% = FALSE

  CLS

  'populate level data
  levelFileName$ = "LEVEL" + STR$(lvlNumber) + ".LVL"
  OPEN levelFileName$ FOR INPUT AS #1
    FOR x% = 1 TO SCREENWIDTH
      INPUT #1, groundHeightTemp
      IF groundHeightTemp = 0 THEN
        groundHeight(x%) = 50
      ELSE
        groundHeight(x%) = groundHeightTemp
      END IF
    NEXT x%
  CLOSE #1

  'populate diamonds NEEDS MORE WORK
  DIM diamonds(MAXDIAMONDS) AS obj
 
  levelFileName$ = "LEVEL" + STR$(lvlNumber) + ".DAT"
  OPEN levelFileName$ FOR INPUT AS #1
 
  FOR i% = 0 TO MAXDIAMONDS
    
    INPUT #1, xTemp%, yTemp%
    diamonds(i%).xPos = xTemp%
    diamonds(i%).yPos = yTemp%
    
    diamonds(i%).score = 0
    diamonds(i%).dead = FALSE
    diamonds(i%).charVal = CHR$(4)
    diamonds(i%).objColor = 14
    diamonds(i%).isJumping = FALSE
    diamonds(i%).maxJumpHeight = 0
    diamonds(i%).jumpHeight = 0
    diamonds(i%).jumpDirection = UP
    diamonds(i%).direction = LEFT
  NEXT i%
  CLOSE #1

  CALL drawPreLevelScreen(player, lvlNumber)

  CALL drawGround(groundHeight())
  CALL drawDiamonds(diamonds())

  'Level loop
  DO WHILE game% = TRUE AND player.dead = FALSE AND player.xPos < 75
   
    startTime# = TIMER

    CALL drawScore(player.score, player.diamonds, player.lives)
    CALL printObj(player)
    CALL displayDebug(player, INP(96))

    'left
    IF INP(96) = 75 THEN
      colDec% = checkHighGroundCollision(player.xPos - 1, player.yPos, groundHeight())
      IF colDec% = FALSE THEN
        CALL moveObj(player.xPos - 1, player.yPos, player)
        player.direction = LEFT
      END IF
    END IF

    'right
    IF INP(96) = 77 THEN
      colDec% = checkHighGroundCollision(player.xPos + 1, player.yPos, groundHeight())
      IF colDec% = FALSE THEN
        CALL moveObj(player.xPos + 1, player.yPos, player)
        player.direction = RIGHT
      END IF
    END IF

    'space bar
    IF INP(96) = 57 THEN
      IF player.isJumping = FALSE THEN
        player.isJumping = TRUE
        player.jumpDirection = UP
        player.jumpHeight = player.yPos - player.maxJumpHeight
        CALL moveObj(player.xPos, player.yPos - 1, player)
      END IF
    END IF

    'esc key
    IF INP(96) = 1 THEN
      game% = FALSE
    END IF

    IF player.isJumping = TRUE AND player.yPos > player.jumpHeight AND player.jumpDirection = UP THEN
      player.jumpDirection = UP
      CALL moveObj(player.xPos, player.yPos - 1, player)
    ELSEIF player.isJumping = TRUE AND player.yPos = player.jumpHeight AND player.jumpDirection = UP THEN
      player.jumpDirection = DOWN
      CALL moveObj(player.xPos, player.yPos + 1, player)
    ELSEIF player.isJumping = TRUE AND player.yPos < groundHeight(player.xPos) - 1 AND player.jumpDirection = DOWN THEN
      'player.jumpDirection = DOWN
      CALL moveObj(player.xPos, player.yPos + 1, player)
    ELSEIF player.yPos = groundHeight(player.xPos) - 1 AND player.isJumping = TRUE THEN
      player.jumpEndTime = TIMER
      player.isJumping = FALSE
    END IF

    'touch diamond, get it.
    touchedDiamond% = checkDiamondCollision(player, diamonds())
    IF touchedDiamond% = TRUE THEN
      player.diamonds = player.diamonds + 1
    END IF

    'if players diamonds reach >= 100, extra life. reset to 0.
    IF player.diamonds >= 100 THEN
      player.lives = player.lives + 1
      player.diamonds = 0
    END IF

    'make player fall if walks off ledge
    IF player.isJumping = FALSE AND player.yPos + 1 < groundHeight(player.xPos) THEN
      player.isJumping = TRUE
      CALL moveObj(player.xPos, groundHeight(player.xPos) - 1, player)
    END IF

    'fell down a pit, you're dead
    IF player.yPos > 24 THEN
      player.dead = TRUE
    END IF

    'if player is hit by bad guy, he's dead.
    touchedBadGuy% = checkBadGuyCollision(player, bg())
    IF touchedBadGuy% >= TRUE AND player.isJumping = FALSE AND TIMER - player.jumpEndTime > .3 THEN
        player.dead = TRUE
    ELSEIF touchedBadGuy% >= TRUE AND TIMER - player.jumpEndTime < .3 THEN
       player.score = player.score + 100
       bg(touchedBadGuy%).dead = TRUE
    END IF

    'move bad guys
    IF player.bgMoveCurrent = player.bgMoveMax THEN
      CALL moveBadGuys(bg(), groundHeight())
      player.bgMoveCurrent = 0
    ELSE
      player.bgMoveCurrent = player.bgMoveCurrent + 1
    END IF

    
 
    'if too quick. delay .03 a second...
    endTime# = TIMER
    IF endTime# - startTime# < .03 THEN
      diff = .03
      DO
      LOOP WHILE TIMER <= startTime# + diff
    END IF



  'end level loop
  LOOP

  IF player.dead = TRUE THEN
    IF player.lives <= 0 THEN
      game% = FALSE
    ELSE
      player.lives = player.lives - 1
    END IF
  ELSE
    lvlNumber = lvlNumber + 1
  END IF

LOOP

'post game
CLS


IF player.dead = TRUE THEN
  COLOR 14
  PRINT "Game over."
  PRINT "Press Q to quit"
  DO: LOOP WHILE INKEY$ <> "q"
END IF

COLOR 7
END

'error handler.
Handler:
  PRINT
  PRINT "Error "; ERR
  SELECT CASE ERR
    CASE 51:
      PRINT "Internal error"
    CASE 52:
      PRINT "Bad file name or number"
    CASE 53:
      PRINT "File not found"
    CASE 54:
      PRINT "Bad file mode"
    CASE 57:
      PRINT "Device I/O error"
    CASE 58:
      PRINT "File already exists"
    CASE 61:
      PRINT "Disk full."
    CASE 64:
      PRINT "Bad file name."
    CASE 70:
      PRINT "Permission denied"
    CASE 71:
      PRINT "Disk not ready"
    CASE 72:
      PRINT "Disk-media error"
    CASE 73:
      PRINT "Feature Unavailable."
    CASE 75:
      PRINT "Path/File access error"
    CASE 76:
      PRINT "Path not found"
  END SELECT
  RESUME EndProgram

EndProgram:
COLOR 7
PRINT "Program terminated by error handler."
END

FUNCTION checkBadGuyCollision (playerIn AS obj, bgIn() AS obj)

'checks to see if there's a collision and returns the
'index of the badguy touched. Returns false on none.

collision% = FALSE

FOR i% = 0 TO MAXBADGUYS
  IF playerIn.xPos = bgIn(i%).xPos AND playerIn.yPos = bgIn(i%).yPos THEN
    IF bgIn(i%).dead = FALSE THEN
      collision% = i%
    END IF
  END IF
NEXT i%
   
checkBadGuyCollision = collision%

END FUNCTION

FUNCTION checkDiamondCollision (playerIn AS obj, diamondIn() AS obj)

collision% = FALSE

FOR i% = 0 TO 25
  IF diamondIn(i%).dead = FALSE THEN
    IF playerIn.xPos = diamondIn(i%).xPos AND playerIn.yPos = diamondIn(i%).yPos THEN
      collision% = TRUE
      diamondIn(i%).dead = TRUE
    END IF
  END IF
NEXT i%
  
checkDiamondCollision = collision%

END FUNCTION

FUNCTION checkHighGroundCollision (xPosIn AS INTEGER, yPosIn AS INTEGER, groundHeightIn() AS INTEGER)

collision% = FALSE

IF xPosIn > 0 AND xPosIn < SCREENWIDTH THEN
  IF (yPosIn > groundHeightIn(xPosIn) - 1) THEN
    collision% = TRUE
  END IF
END IF

checkHighGroundCollision = collision%
END FUNCTION

SUB displayDebug (player AS obj, inputIn AS INTEGER)
  LOCATE 3, 2
  COLOR 7
  PRINT "("; player.xPos; ","; player.yPos; ")"

  LOCATE 4, 2
  PRINT "INP_VAL: "; INP(96)

  LOCATE 5, 2
  PRINT "player.jumpHeight: "; player.jumpHeight + player.maxJumpHeight


  LOCATE 6, 2
  PRINT "player.isJumping: "; player.isJumping

  LOCATE 7, 2
  PRINT "player.isJumpingTimer: "; TIMER - player.jumpEndTime
END SUB

SUB drawDiamonds (diamondsIn() AS obj)
  FOR x% = 0 TO MAXDIAMONDS
    IF diamondsIn(x%).yPos > 0 AND diamondsIn(x%).yPos < SCREENHEIGHT AND diamondsIn(x%).xPos > 0 AND diamondsIn(x%).xPos < SCREENWIDTH THEN
      LOCATE diamondsIn(x%).yPos, diamondsIn(x%).xPos
      COLOR diamondsIn(x%).objColor
      PRINT diamondsIn(x%).charVal
    END IF
  NEXT x%


END SUB

SUB drawGround (groundHeightIn() AS INTEGER)

FOR y% = 1 TO SCREENHEIGHT
  FOR x% = 1 TO SCREENWIDTH
    IF y% = groundHeightIn(x%) THEN
      LOCATE y%, x%
      COLOR 2
      PRINT ""
    ELSEIF y% > groundHeightIn(x%) THEN
      LOCATE y%, x%
      COLOR 6
      PRINT ""
    END IF
  NEXT x%
NEXT y%
END SUB

SUB drawPreLevelScreen (playerIn AS obj, levelNum AS INTEGER)

CLS

COLOR 15

LOCATE 10, 30
PRINT " L E V E L : "; levelNum

LOCATE 11, 33
PRINT "Mr Face"

LOCATE 11, 43
COLOR playerIn.objColor
PRINT playerIn.charVal

COLOR 15
LOCATE 12, 30
PRINT "    Lives:"; playerIn.lives

SLEEP
CLS

END SUB

SUB drawScore (scoreIn%, diamondsIn%, livesIn%)

LOCATE 2, 2
COLOR 15
PRINT "Score: "; scoreIn%

LOCATE 2, 15
COLOR 15
PRINT "Diamonds: "; diamondsIn%

LOCATE 2, 30
COLOR 15
PRINT "Lives: "; livesIn%

END SUB

SUB moveBadGuys (bgIn() AS obj, ghIn() AS INTEGER)


FOR i% = 0 TO MAXBADGUYS

  'move if not dead and on the screen.
  IF bgIn(i%).dead = FALSE AND bgIn(i%).xPos > 0 AND bgIn(i%).xPos < SCREENWIDTH THEN
   
    'make them walk but turn around at walls.
    IF bgIn(i%).direction = LEFT THEN
      wallCol = checkHighGroundCollision(bgIn(i%).xPos - 1, bgIn(i%).yPos, ghIn())
      IF wallCol = FALSE THEN
        CALL moveObj(bgIn(i%).xPos - 1, bgIn(i%).yPos, bgIn(i%))
      ELSE
        bgIn(i%).direction = RIGHT
      END IF
    ELSE
      wallCol = checkHighGroundCollision(bgIn(i%).xPos + 1, bgIn(i%).yPos, ghIn())
      IF wallCol = FALSE THEN
        CALL moveObj(bgIn(i%).xPos + 1, bgIn(i%).yPos, bgIn(i%))
      ELSE
        bgIn(i%).direction = LEFT
      END IF

    END IF

    'make them fall down pits
    IF bgIn(i%).yPos + 1 < ghIn(bgIn(i%).xPos) THEN
      CALL moveObj(bgIn(i%).xPos, ghIn(bgIn(i%).xPos) - 1, bgIn(i%))
    END IF


  'if they're dead. draw carcass.
  ELSEIF bgIn(i%).dead = TRUE THEN
    bgIn(i%).yPos = ghIn(bgIn(i%).xPos)
    bgIn(i%).charVal = CHR$(177)
    bgIn(i%).objColor = 4
    CALL printObj(bgIn(i%))

  END IF

  
NEXT i%

END SUB

SUB moveObj (newXpos%, newYpos%, objIn AS obj)

DIM mask AS obj
mask.xPos = objIn.xPos
mask.yPos = objIn.yPos
mask.charVal = ""
mask.objColor = 0

'update object info
objIn.xPos = newXpos%
objIn.yPos = newYpos%

CALL printObj(objIn)
CALL printObj(mask)


END SUB

SUB printObj (objIn AS obj)

IF objIn.yPos > 0 AND objIn.yPos < SCREENHEIGHT AND objIn.xPos > 0 AND objIn.xPos < SCREENWIDTH THEN
  LOCATE objIn.yPos, objIn.xPos
  COLOR objIn.objColor
  PRINT objIn.charVal
END IF

END SUB

