DECLARE SUB removeGroundHeight (xPosIn AS INTEGER, yPosIn AS INTEGER, ghIn() AS INTEGER)
DECLARE SUB removeDiamonds (xPosIn AS INTEGER, yPosIn AS INTEGER, dIn() AS ANY)
DECLARE SUB setDiamonds (xPosIn AS INTEGER, yPosIn AS INTEGER, dIn() AS ANY)
DECLARE SUB saveLevel (fileName$, groundHeight() AS INTEGER, dIn() AS ANY)
DECLARE SUB loadLevel (levelFileName$, groundHeight() AS INTEGER, diamonds() AS ANY)
DECLARE SUB displayHelp ()
DECLARE SUB drawDebugLevel (ghIn() AS INTEGER, dIn() AS ANY)
DECLARE SUB setGroundHeight (xPosIn AS INTEGER, yPosIn AS INTEGER, ghIn() AS INTEGER)
DECLARE SUB drawLevel (ghIn() AS INTEGER, dIn() AS ANY)
DECLARE SUB printObj (objIn AS ANY)
DECLARE SUB moveObj (xPosIn AS INTEGER, yPosIn AS INTEGER, objIn AS ANY)

ON ERROR GOTO Handler

CONST TRUE = 0
CONST FALSE = -1
CONST UP = 2
CONST DOWN = 3
CONST LEFT = 4
CONST RIGHT = 5
CONST SCREENWIDTH = 80
CONST SCREENHEIGHT = 23
CONST MAXBADGUYS = 4
CONST MAXDIAMONDS = 25
CONST DIRECTORY = "C:\QBASIC\LEVELS\"

TYPE obj
  xPos AS INTEGER
  yPos AS INTEGER
  charVal AS STRING * 1
  objColor AS INTEGER
  placed AS INTEGER
END TYPE

DIM pointer AS obj
  pointer.xPos = 10
  pointer.yPos = 10
  pointer.charVal = ""
  pointer.objColor = 15

DIM diamonds(MAXDIAMONDS) AS obj
  FOR i% = 0 TO 25
    diamonds(i%).xPos = 0
    diamonds(i%).yPos = 0
    diamonds(i%).charVal = CHR$(4)
    diamonds(i%).objColor = 14
    diamonds(i%).placed = FALSE
  NEXT i%


DIM groundHeight(SCREENWIDTH)  AS INTEGER

FOR i% = 0 TO SCREENWIDTH
  groundHeight(i%) = 22
NEXT i%

startTimestamp = 0

'program loop
DO WHILE INP(96) <> 1
  CLS
  'CALL drawBackground

  CALL printObj(pointer)
  'editor loop
  DO WHILE INP(96) <> 1
    startTimestamp = TIMER

    LOCATE 2, 2
    COLOR 7
    PRINT "("; pointer.xPos; ","; pointer.yPos; ")"
    LOCATE 3, 2
    PRINT "INP(96): "; INP(96)
    LOCATE 2, 15
    PRINT "groundHeight(x): "; groundHeight(pointer.xPos)

    'up
    IF INP(96) = 72 THEN
      CALL moveObj(pointer.xPos, pointer.yPos - 1, pointer)
    END IF

    'down
    IF INP(96) = 80 THEN
      CALL moveObj(pointer.xPos, pointer.yPos + 1, pointer)
    END IF

    'left
    IF INP(96) = 75 THEN
      CALL moveObj(pointer.xPos - 1, pointer.yPos, pointer)
    END IF

    'right
    IF INP(96) = 77 THEN
      CALL moveObj(pointer.xPos + 1, pointer.yPos, pointer)
    END IF

    'spacebar
    IF INP(96) = 57 THEN
      CALL setGroundHeight(pointer.xPos, pointer.yPos, groundHeight())
    END IF

    '"S" key
    IF INP(96) = 31 THEN
      LOCATE 4, 1
      COLOR 15
      PRINT "Do not include file extension. It will be added automatically."
      INPUT "Save Filename: ", fileName$
      CALL saveLevel(fileName$, groundHeight(), diamonds())
    END IF


    '"L" key
    IF INP(96) = 38 THEN
      LOCATE 4, 1
      COLOR 15
      INPUT "Load Filename: ", fileName$
      PRINT fileName$
      CALL loadLevel(fileName$, groundHeight(), diamonds())
      CLS
    END IF

    '"D" key
    IF INP(96) = 32 THEN
        CALL setDiamonds(pointer.xPos, pointer.yPos, diamonds())
    END IF

    '"E" key
    IF INP(96) = 18 THEN
        CALL removeDiamonds(pointer.xPos, pointer.yPos, diamonds())
    END IF

    '"C" key
    IF INP(96) = 46 THEN
        CALL removeGroundHeight(pointer.xPos, pointer.yPos, groundHeight())
    END IF


    'F1
    IF INP(96) = 59 THEN
      CALL displayHelp
    END IF


    'F5
    IF INP(96) = 63 THEN
      CALL drawLevel(groundHeight(), diamonds())
    END IF


    'delay
    endTimestamp = TIMER
    IF endTimestamp - startTimestamp < .03 THEN
      diff = .03
      DO
      LOOP WHILE TIMER <= startTimestamp + diff
    END IF

    CALL drawDebugLevel(groundHeight(), diamonds())
  LOOP
LOOP
COLOR 7
END

'error handler.
Handler:
  PRINT
  PRINT "Error "; ERR
  SELECT CASE ERR
    CASE 51:
      PRINT "Internal error"
    CASE 52:
      PRINT "Bad file name or number"
    CASE 53:
      PRINT "File not found"
    CASE 54:
      PRINT "Bad file mode"
    CASE 57:
      PRINT "Device I/O error"
    CASE 58:
      PRINT "File already exists"
    CASE 61:
      PRINT "Disk full."
    CASE 64:
      PRINT "Bad file name."
    CASE 70:
      PRINT "Permission denied"
    CASE 71:
      PRINT "Disk not ready"
    CASE 72:
      PRINT "Disk-media error"
    CASE 73:
      PRINT "Feature Unavailable."
    CASE 75:
      PRINT "Path/File access error"
    CASE 76:
      PRINT "Path not found"
  END SELECT
  RESUME EndProgram

EndProgram:
COLOR 7
PRINT "Program terminated by error handler."
END

SUB displayHelp

CLS
LOCATE 2
COLOR 15
PRINT " REBEL LEVEL EDITOR HELP"
PRINT
PRINT "   ESC - Quit (Does not auto-save!)"
PRINT "    F1 - Help Screen"
PRINT "    F5 - Show level as seen in Rebel"
PRINT " Space - Place ground height marker"
PRINT "     C - Remove ground height marker"
PRINT "     D - Place Diamond"
PRINT "     E - Remove Diamond"
PRINT "     L - Load Level"
PRINT "     S - Save Level"
PRINT
PRINT " Bad guy placement coming soon."
PRINT
PRINT
PRINT "    Press q to return..."
DO
LOOP WHILE INKEY$ <> "q"
CLS

END SUB

SUB drawDebugLevel (ghIn() AS INTEGER, dIn() AS obj)

DIM tile AS obj
  tile.xPos = 0
  tile.yPos = 0
  tile.charVal = ""
  tile.objColor = 7


FOR x% = 1 TO SCREENWIDTH
  IF ghIn(x%) <> 0 THEN
    tile.yPos = ghIn(x%)
    tile.xPos = x%
    CALL printObj(tile)
  END IF
  
NEXT x%

FOR i% = 0 TO MAXDIAMONDS
  IF dIn(i%).placed = TRUE THEN
    IF dIn(i%).yPos > 0 AND dIn(i%).yPos < SCREENHEIGHT AND dIn(i%).xPos > 0 AND dIn(i%).xPos < SCREENWIDTH THEN
      LOCATE dIn(i%).yPos, dIn(i%).xPos
      COLOR 7
      PRINT dIn(i%).charVal
    END IF
  END IF
NEXT i%

END SUB

SUB drawLevel (groundHeightIn() AS INTEGER, dIn() AS obj)
CLS

'draw diamonds first so that if they're under the ground
'they get painted over as you can't reach them anyway.
FOR i% = 0 TO MAXDIAMONDS
  IF dIn(i%).placed = TRUE THEN
    IF dIn(i%).yPos > 0 AND dIn(i%).yPos < SCREENHEIGHT AND dIn(i%).xPos > 0 AND dIn(i%).xPos < SCREENWIDTH THEN
      LOCATE dIn(i%).yPos, dIn(i%).xPos
      COLOR dIn(i%).objColor
      PRINT dIn(i%).charVal
    END IF
  END IF
NEXT i%

'draw ground
FOR y% = 1 TO SCREENHEIGHT
  FOR x% = 1 TO SCREENWIDTH
    IF groundHeightIn(x%) = 0 THEN
      'dont draw pits
    ELSEIF y% = groundHeightIn(x%) THEN
      LOCATE y%, x%
      COLOR 2
      PRINT ""
    ELSEIF y% > groundHeightIn(x%) THEN
      LOCATE y%, x%
      COLOR 6
      PRINT ""
    END IF
  NEXT x%
NEXT y%

'exit message
LOCATE 2, 15
COLOR 14
PRINT "Press q key to return"
DO
LOOP WHILE INKEY$ <> "q"
CLS
END SUB

SUB loadLevel (levelFileName$, groundHeight() AS INTEGER, diamonds() AS obj)



'change to correct directory
CHDIR DIRECTORY

IF levelFileName$ <> "" THEN
  'populate groundheight
  lvlFile$ = levelFileName$ + ".LVL"
  OPEN lvlFile$ FOR INPUT AS #1
    FOR x% = 1 TO SCREENWIDTH
      INPUT #1, groundHeightTemp
      groundHeight(x%) = groundHeightTemp
    NEXT x%
  CLOSE #1

  'populate diamonds
  dataFile$ = levelFileName$ + ".DAT"
  OPEN dataFile$ FOR INPUT AS #1

    FOR i% = 0 TO MAXDIAMONDS
   
      INPUT #1, xTemp%, yTemp%
      diamonds(i%).xPos = xTemp%
      diamonds(i%).yPos = yTemp%
      diamonds(i%).charVal = CHR$(4)
      diamonds(i%).objColor = 14

      IF diamonds(i%).xPos > 0 AND diamonds(i%).yPos > 0 THEN
        diamonds(i%).placed = TRUE
      ELSE
        diamonds(i%).placed = FALSE
      END IF
    
    NEXT i%
  CLOSE #1


END IF


END SUB

SUB moveObj (xPosIn AS INTEGER, yPosIn AS INTEGER, objIn AS obj)

DIM mask AS obj
mask.xPos = objIn.xPos
mask.yPos = objIn.yPos
mask.charVal = ""
mask.objColor = 0

'update object info
objIn.xPos = xPosIn
objIn.yPos = yPosIn

CALL printObj(objIn)
CALL printObj(mask)

END SUB

SUB printObj (objIn AS obj)

IF objIn.yPos > 0 AND objIn.yPos < SCREENHEIGHT AND objIn.xPos > 0 AND objIn.xPos < SCREENWIDTH THEN
  LOCATE objIn.yPos, objIn.xPos
  COLOR objIn.objColor
  PRINT objIn.charVal
END IF

END SUB

SUB removeDiamonds (xPosIn AS INTEGER, yPosIn AS INTEGER, dIn() AS obj)

IF xPosIn > 0 AND xPosIn < SCREENWIDTH AND yPosIn > 0 AND yPosIn < SCREENHEIGHT THEN
  FOR i% = 0 TO MAXDIAMONDS
    IF dIn(i%).xPos = xPosIn AND dIn(i%).yPos = yPosIn THEN
      dIn(i%).placed = FALSE
    END IF
  NEXT i%
END IF

END SUB

SUB removeGroundHeight (xPosIn AS INTEGER, yPosIn AS INTEGER, ghIn() AS INTEGER)

IF xPosIn > 0 AND xPosIn < SCREENWIDTH AND yPosIn > 0 AND yPosIn < SCREENHEIGHT THEN
  IF ghIn(xPosIn) = yPosIn THEN
    ghIn(xPosIn) = 0
  END IF
END IF

END SUB

SUB saveLevel (levelFileName$, groundHeight() AS INTEGER, dIn() AS obj)
CLS

'change to correct directory
CHDIR DIRECTORY

IF levelFileName$ <> "" THEN
 
  'save the ground height data
  fileName$ = levelFileName$ + ".LVL"
  OPEN fileName$ FOR OUTPUT AS #1
    FOR x% = 1 TO SCREENWIDTH
      WRITE #1, groundHeight(x%)
    NEXT x%
  CLOSE #1
 
  'save diamond data
  fileName$ = levelFileName$ + ".DAT"
  OPEN fileName$ FOR OUTPUT AS #1
    FOR i% = 0 TO MAXDIAMONDS
      WRITE #1, dIn(i%).xPos, dIn(i%).yPos
    NEXT i%
  CLOSE #1


  LOCATE 4, 1
  COLOR 15
  PRINT "Level "; levelFileName$; " has been saved."
ELSE
  LOCATE 4, 1
  COLOR 15
  PRINT "Bad File Name"
END IF

END SUB

SUB setDiamonds (xPosIn AS INTEGER, yPosIn AS INTEGER, dIn() AS obj)

placed% = FALSE
i% = 0
PRINT "Placed: "; placed%
IF xPosIn > 0 AND xPosIn < SCREENWIDTH AND yPosIn > 0 AND yPosIn < SCREENHEIGHT THEN
  WHILE placed% = FALSE AND i% < MAXDIAMONDS
    IF dIn(i%).placed = FALSE THEN
      dIn(i%).xPos = xPosIn
      dIn(i%).yPos = yPosIn
      dIn(i%).placed = TRUE
      placed% = TRUE
    END IF
    i% = i% + 1
  WEND
END IF

END SUB

SUB setGroundHeight (xPosIn AS INTEGER, yPosIn AS INTEGER, ghIn() AS INTEGER)

IF xPosIn > 0 AND xPosIn < SCREENWIDTH AND yPosIn > 0 AND yPosIn < SCREENHEIGHT THEN
 
  'mask it if it's currently at another y-value
  IF ghIn(xPosIn) <> 0 THEN
    LOCATE ghIn(xPosIn), xPosIn
    COLOR 0
    PRINT ""
  END IF

  'set
  ghIn(xPosIn) = yPosIn
  
END IF

END SUB

