DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'DIRECTQB.BI'
'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'VECTZ.BI'
'$INCLUDE: 'DOENTS.BI'

TYPE Star3Dtype
	x AS SINGLE
	y AS SINGLE
	z AS SINGLE
END TYPE

DIM SHARED xLPTaddr


'===========================================================================\
REM $STATIC
SUB DoParticles

	' Draw particles
	FOR P = 1 TO 256
		IF Particle(P).Active THEN

			Particle(P).x = Particle(P).x + Particle(P).xMove
			Particle(P).y = Particle(P).y + Particle(P).yMove

			xCoord = CENTERX + ((Particle(P).x - Camera.x) * CamScale)
			yCoord = CENTERY + ((Particle(P).y - Camera.y) * CamScale)

			'TriCol = ((ObjectTris(T).Col MOD 16) - Gamma)
			'IF TriCol < 0 THEN TriCol = 0
			'TriCol = (16 * (ObjectTris(T).Col \ 16)) + TriCol

			IF Particle(P).Active < 16 THEN
				col = ((Particle(P).col MOD 16) - (16 - Particle(P).Active))
				IF col < 0 THEN col = 0
				col = (16 * (Particle(P).col \ 16)) + col
			ELSE
				col = Particle(P).col
			END IF

			DQBpset 1, xCoord, yCoord, col

			Particle(P).Active = Particle(P).Active - 1

		END IF
	NEXT P

END SUB


'===========================================================================\
SUB ClearStuffs

DIM BlankParticle AS ParticleType
DIM BlankTriParticle AS TriParticleType
DIM BlankBullet AS BulletType
DIM BlankMissile AS MissileType

FOR P = 1 TO UBOUND(Particle)
   Particle(P) = BlankParticle
NEXT P

FOR P = 1 TO UBOUND(TriParticle)
   TriParticle(P) = BlankTriParticle
NEXT P

FOR P = 1 TO UBOUND(Bullet)
   Bullet(P) = BlankBullet
NEXT P

FOR P = 1 TO UBOUND(Missile)
   Missile(P) = BlankMissile
NEXT P

END SUB


'===========================================================================\
SUB DoTriParticles

DIM SinVal AS SINGLE, CosVal AS SINGLE

DIM Tx(1 TO 3), Ty(1 TO 3)

' Draw triangle particles
FOR P = 1 TO 64
	IF TriParticle(P).Active THEN

		TriParticle(P).x = TriParticle(P).x + TriParticle(P).xMove
		TriParticle(P).y = TriParticle(P).y + TriParticle(P).yMove
		TriParticle(P).Angle = TriParticle(P).Angle + TriParticle(P).aMove

		xCoord = (TriParticle(P).x - Camera.x) * CamScale
		yCoord = (TriParticle(P).y - Camera.y) * CamScale

		SinVal = SIN(TriParticle(P).Angle * ROTPI)
		CosVal = COS(TriParticle(P).Angle * ROTPI)

		Tx(1) = TriParticle(P).x1 * CamScale
		Ty(1) = TriParticle(P).y1 * CamScale
		Tx(2) = TriParticle(P).x2 * CamScale
		Ty(2) = TriParticle(P).y2 * CamScale
		Tx(3) = TriParticle(P).x3 * CamScale
		Ty(3) = TriParticle(P).y3 * CamScale

		FOR r = 1 TO 3
			Tx = Tx(r): Ty = Ty(r)
			Tx(r) = Tx * CosVal - Ty * SinVal
			Ty(r) = Ty * CosVal + Tx * SinVal
			Tx(r) = CENTERX + (Tx(r) + xCoord)
			Ty(r) = CENTERY + (Ty(r) + yCoord)
		NEXT r

		IF TriParticle(P).Active < 64 THEN
			col = ((TriParticle(P).col MOD 16) - (16 - (TriParticle(P).Active \ 4)))
			IF col < 0 THEN col = 0
			col = (16 * (TriParticle(P).col \ 16)) + col
		ELSE
			col = TriParticle(P).col
		END IF

		DQBtri 1, Tx(1), Ty(1), Tx(2), Ty(2), Tx(3), Ty(3), col

		TriParticle(P).Active = TriParticle(P).Active - 1

	END IF

NEXT P

END SUB


'===========================================================================\
SUB PAD.GetButtonStats

' Turn all pins on to power up the pad and reset the pad by turning the clock
' and latch pins on
OUT xLPTaddr, &HFF

' Read button stats
FOR PadButton = 1 TO 12

   ' Turn clock and latch pins off then read the port status
   OUT xLPTaddr, &HFC
   PortVal = INP(xLPTaddr + 1) XOR &HFF

   ' Separate the status bits
   FOR PadNum = 1 TO 4
      PAD.ButtonStatus(PadNum, PadButton) = PortVal AND (2 ^ (6 - (PadNum - 1)))
   NEXT PadNum

   ' Turn clock pin on
   OUT xLPTaddr, &HFD

NEXT PadButton

END SUB


'===========================================================================\
FUNCTION PAD.Init (LPTaddr)

' Checking if an SNES controller is attached can be done easily by checking if
' all 12 buttons are pressed at once which happens normally when no controller
' is detected and is impossible to pull it off on a real SNES controller due
' to the way how the D-Pad is designed. If 11 or less buttons are pressed at
' once, then its more likely that a controller is attached.

' Same thing in PAD.GetButtonStats with minor differences
OUT LPTaddr, &HFF

' Read button stats
FOR PadButton = 1 TO 12

	' Turn clock and latch pins off then read the port status
	OUT LPTaddr, &HFC
	PortVal = INP(LPTaddr + 1) XOR &HFF

	' Check all port stats
	ButtonState = PortVal AND (2 ^ 6)
	IF ButtonState THEN NoPadDetectedP1 = NoPadDetectedP1 + 1
	ButtonState = PortVal AND (2 ^ 5)
	IF ButtonState THEN NoPadDetectedP2 = NoPadDetectedP2 + 1
	ButtonState = PortVal AND (2 ^ 4)
	IF ButtonState THEN NoPadDetectedP3 = NoPadDetectedP3 + 1
	ButtonState = PortVal AND (2 ^ 3)
	IF ButtonState THEN NoPadDetectedP4 = NoPadDetectedP4 + 1

	' Turn clock pin on
	OUT LPTaddr, &HFD

NEXT PadButton

' If all 12 buttons are pressed which normally happens when no controller is
' connected return 0 and exit function.
IF NoPadDetectedP1 = 12 THEN
	PAD.Init = 0
	EXIT FUNCTION
END IF

PAD.Init = 1 ' One controller
IF NoPadDetectedP2 < 12 THEN
	PAD.Init = 2 ' Two controllers
	IF NoPadDetectedP3 < 12 THEN
		PAD.Init = 3 ' Three controllers
		IF NoPadDetectedP4 < 12 THEN
			PAD.Init = 4 ' Four controllers
		END IF
	END IF
END IF

xLPTaddr = LPTaddr

END FUNCTION


'===========================================================================\
SUB PutParticle (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Speed AS SINGLE, Angle AS SINGLE, Duration, col)

STATIC NextParticle

NextParticle = NextParticle + 1
IF NextParticle > 256 THEN NextParticle = 1

Particle(NextParticle).x = x
Particle(NextParticle).y = y
Particle(NextParticle).xMove = (Speed * SIN(Angle * ROTPI)) + xMove
Particle(NextParticle).yMove = (-Speed * COS(Angle * ROTPI)) + yMove
Particle(NextParticle).col = col
Particle(NextParticle).Active = Duration

END SUB


'===========================================================================\
SUB ParticlizeObject (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Speed, Angle AS SINGLE, Duration, ObjectVerts() AS VertType, ObjectTris() AS TriType)

STATIC NextTriParticle

DIM SinVal AS SINGLE, CosVal AS SINGLE
DIM rSpeed AS SINGLE
DIM Px(1 TO 3), Py(1 TO 3)

SinVal = SIN(Angle * ROTPI)
CosVal = COS(Angle * ROTPI)

FOR P = 1 TO UBOUND(ObjectTris)

	Px(1) = ObjectVerts(ObjectTris(P).P1).x
	Py(1) = ObjectVerts(ObjectTris(P).P1).y
	Px(2) = ObjectVerts(ObjectTris(P).P2).x
	Py(2) = ObjectVerts(ObjectTris(P).P2).y
	Px(3) = ObjectVerts(ObjectTris(P).P3).x
	Py(3) = ObjectVerts(ObjectTris(P).P3).y

	FOR r = 1 TO 3
		'Px = Px(R): Py = Py(R)
		'Px(R) = Px * CosVal - Py * SinVal
		'Py(R) = Py * CosVal + Px * SinVal
		Px(r) = Px(r) + x
		Py(r) = Py(r) + y
	NEXT r


	NextTriParticle = NextTriParticle + 1
	IF NextTriParticle > 64 THEN NextTriParticle = 1

	xCoord = (Px(1) + Px(2) + Px(3)) \ 3
	yCoord = (Py(1) + Py(2) + Py(3)) \ 3

	TriParticle(NextTriParticle).x = xCoord
	TriParticle(NextTriParticle).y = yCoord
	TriParticle(NextTriParticle).Angle = 0
	TriParticle(NextTriParticle).x1 = Px(1) - xCoord
	TriParticle(NextTriParticle).y1 = Py(1) - yCoord
	TriParticle(NextTriParticle).x2 = Px(2) - xCoord
	TriParticle(NextTriParticle).y2 = Py(2) - yCoord
	TriParticle(NextTriParticle).x3 = Px(3) - xCoord
	TriParticle(NextTriParticle).y3 = Py(3) - yCoord

	rAngle = Angle + ((RND * 360) - 180)
   rSpeed = Speed + (RND * 4)
   TriParticle(NextTriParticle).xMove = (rSpeed * SIN(rAngle * ROTPI)) + xMove
   TriParticle(NextTriParticle).yMove = (-rSpeed * COS(rAngle * ROTPI)) + yMove
	TriParticle(NextTriParticle).aMove = (RND * 9) - 4

	TriParticle(NextTriParticle).col = ObjectTris(P).col
	TriParticle(NextTriParticle).Active = Duration

NEXT P

END SUB


'===========================================================================\
SUB DrawLifeBars

FOR P = 1 TO NumPlayers

	xCoord = (CENTERX + ((Player(P).x - Camera.x) * CamScale))
	yCoord = (CENTERY + (((Player(P).y + 65) - Camera.y) * CamScale))

	IF Player(P).Dead = 0 THEN
		HitsTaken = 10 * (Player(P).HitsTaken / Player(P).MaxHits)
		SpecialsUsed = 10 * (Player(P).SpecialsUsed / Player(P).MaxSpecials)
		DQBline 1, xCoord - 5, yCoord, xCoord + 5, yCoord, 4
		DQBline 1, xCoord - 5, yCoord, xCoord + (5 - HitsTaken), yCoord, 14

		DQBline 1, xCoord - 5, yCoord + 2, xCoord + 5, yCoord + 2, 1
		IF SpecialsUsed < 10 THEN DQBline 1, xCoord - 5, yCoord + 2, xCoord + (5 - SpecialsUsed), yCoord + 2, 9

		xCoord = xCoord - 3
		yCoord = yCoord + 4
		DQBprint 1, "P" + LTRIM$(STR$(P)), xCoord, yCoord, 15
	END IF

	Tx = 1 + (30 * (P - 1))
	DQBprint 1, "P" + LTRIM$(STR$(P)) + ":" + LTRIM$(STR$(Player(P).Score)), Tx, 193, 15

NEXT P

END SUB


'===========================================================================\
SUB DoPlayerInputs

FOR P = 1 TO NumPlayers

	IF Player(P).Dead = 0 THEN

		SELECT CASE Player(P).ShipType
			CASE 1, 3
				IF PAD.ButtonStatus(P, PAD.R) THEN
					IF Player(P).SpecialState = 0 AND Player(P).SpecialsUsed < Player(P).MaxSpecials THEN Player(P).SpecialState = 1
				ELSE
					IF Player(P).SpecialState THEN

						' Missile fire stuff goes here
						IF Player(P).LockOnTo THEN
							FireMissile Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, Player(P).Angle, P, Player(P).LockOnTo, 0
							IF SOUNDON THEN
								ChanNum = 5 + (P - 1)
								PlaySample ChanNum, 14, 11025, 64, 8
							END IF
							Player(P).SpecialsUsed = Player(P).SpecialsUsed + 1
						END IF

						Player(P).SpecialState = 0
						Player(P).LockOnTo = 0
					END IF
				END IF

			CASE 2, 4
				IF PAD.ButtonStatus(P, PAD.R) AND Player(P).SpecialsUsed < Player(P).MaxSpecials THEN
					IF Player(P).SpecialState = 0 THEN

						FireMissile Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, Player(P).Angle, P, Player(P).LockOnTo, 1
						IF SOUNDON THEN
							ChanNum = 5 + (P - 1)
							PlaySample ChanNum, 13, 11025, 64, 8
						END IF
						Player(P).SpecialsUsed = Player(P).SpecialsUsed + 1

						Player(P).SpecialState = 1
					END IF
				ELSE
					Player(P).SpecialState = 0
				END IF

		END SELECT

		IF PAD.ButtonStatus(P, PAD.Y) THEN
			IF Player(P).FireHeld = FALSE THEN

				SELECT CASE Player(P).ShipType
               CASE 1
						FireBullet Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, Player(P).Angle, P
					CASE 2
						FireBullet Player(P).x + (40 * COS(Player(P).Angle * ROTPI)), Player(P).y + (40 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
						FireBullet Player(P).x - (40 * COS(Player(P).Angle * ROTPI)), Player(P).y - (40 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
					CASE 3
						FireBullet Player(P).x + (40 * SIN(Player(P).Angle * ROTPI)), Player(P).y - (40 * COS(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
						FireBullet Player(P).x + (60 * COS(Player(P).Angle * ROTPI)), Player(P).y + (60 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
						FireBullet Player(P).x - (60 * COS(Player(P).Angle * ROTPI)), Player(P).y - (60 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
               CASE 4
                  FireBullet Player(P).x + (20 * COS(Player(P).Angle * ROTPI)), Player(P).y + (10 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
                  FireBullet Player(P).x - (20 * COS(Player(P).Angle * ROTPI)), Player(P).y - (10 * SIN(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, Player(P).Angle, P
				END SELECT

				IF SOUNDON THEN
					Freq = 11025 + (INT(RND * 1000) - 500)
					ChanNum = 5 + (P - 1)
					PlaySample ChanNum, 11, CLNG(Freq), 64, 8
				END IF
				Player(P).FireHeld = TRUE
			END IF
		ELSE
			Player(P).FireHeld = FALSE
		END IF

      IF PAD.ButtonStatus(P, PAD.X) THEN

			SELECT CASE Player(P).ShipType
				CASE 1, 4
               Player(P).xMove = Player(P).xMove - .1 * SIN(Player(P).Angle * ROTPI)
               Player(P).yMove = Player(P).yMove + .1 * COS(Player(P).Angle * ROTPI)
				CASE 2
               Player(P).xMove = Player(P).xMove - .07 * SIN(Player(P).Angle * ROTPI)
               Player(P).yMove = Player(P).yMove + .07 * COS(Player(P).Angle * ROTPI)
				CASE 3
               Player(P).xMove = Player(P).xMove - .12 * SIN(Player(P).Angle * ROTPI)
               Player(P).yMove = Player(P).yMove + .12 * COS(Player(P).Angle * ROTPI)
			END SELECT

         PutParticle Player(P).x - (24 * SIN(Player(P).Angle * ROTPI)), Player(P).y + (24 * COS(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, (RND * 5), Player(P).Angle + ((RND * 41) - 20), 70, 111
		END IF

		IF PAD.ButtonStatus(P, PAD.B) THEN

			SELECT CASE Player(P).ShipType
				CASE 1, 4
					Player(P).xMove = Player(P).xMove + .1 * SIN(Player(P).Angle * ROTPI)
					Player(P).yMove = Player(P).yMove - .1 * COS(Player(P).Angle * ROTPI)
				CASE 2
					Player(P).xMove = Player(P).xMove + .07 * SIN(Player(P).Angle * ROTPI)
					Player(P).yMove = Player(P).yMove - .07 * COS(Player(P).Angle * ROTPI)
				CASE 3
					Player(P).xMove = Player(P).xMove + .12 * SIN(Player(P).Angle * ROTPI)
					Player(P).yMove = Player(P).yMove - .12 * COS(Player(P).Angle * ROTPI)
			END SELECT

			PutParticle Player(P).x - (24 * SIN(Player(P).Angle * ROTPI)), Player(P).y + (24 * COS(Player(P).Angle * ROTPI)), Player(P).xMove, Player(P).yMove, (RND * 5), (Player(P).Angle + 180) + ((RND * 41) - 20), 70, 111
		END IF

		' Turn left
		IF PAD.ButtonStatus(P, PAD.LEFT) THEN
			SELECT CASE Player(P).ShipType
				CASE 1: Player(P).aMove = Player(P).aMove - .5
				CASE 2: Player(P).aMove = Player(P).aMove - .3
				CASE 3, 4: Player(P).aMove = Player(P).aMove - .7
			END SELECT
		END IF

		' Turn right
		IF PAD.ButtonStatus(P, PAD.RIGHT) THEN
			SELECT CASE Player(P).ShipType
				CASE 1: Player(P).aMove = Player(P).aMove + .5
				CASE 2: Player(P).aMove = Player(P).aMove + .3
				CASE 3, 4: Player(P).aMove = Player(P).aMove + .7
			END SELECT
		END IF

	END IF

NEXT P

END SUB


'===========================================================================\
SUB FireBullet (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Angle AS SINGLE, Owner)

STATIC NextBullet

NextBullet = NextBullet + 1
IF NextBullet > 100 THEN NextBullet = 1

Bullet(NextBullet).x = x
Bullet(NextBullet).y = y
Bullet(NextBullet).xMove = (10 * SIN(Angle * ROTPI)) + xMove
Bullet(NextBullet).yMove = (-10 * COS(Angle * ROTPI)) + yMove
Bullet(NextBullet).Angle = Angle
Bullet(NextBullet).Owner = Owner
Bullet(NextBullet).Active = 280

END SUB


'===========================================================================\
SUB FireMissile (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Angle AS SINGLE, Owner, Target, MType)

STATIC NextMissile

NextMissile = NextMissile + 1
IF NextMissile > UBOUND(Missile) THEN NextMissile = 1

Missile(NextMissile).x = x
Missile(NextMissile).y = y
Missile(NextMissile).xMove = xMove
Missile(NextMissile).yMove = yMove
Missile(NextMissile).Angle = Angle
Missile(NextMissile).Owner = Owner
Missile(NextMissile).MType = MType
Missile(NextMissile).Target = Target
Missile(NextMissile).Active = 1

END SUB


'===========================================================================\
'===========================================================================\
'===========================================================================\
'===========================================================================\


'===========================================================================\
SUB CalcSmoothFadeIn (StepNum, sRed, sGrn, sBlu, ePalSeg, ePalOff AS LONG, fPalSeg, fPalOff AS LONG)

' NOTE: Uses PEEK and POKE to read and write palette values

DIM xPalOff AS LONG
DIM xxPalOff AS LONG
DIM Alpha AS SINGLE

Alpha = (StepNum / 63)

xPalOff = ePalOff
xxPalOff = fPalOff

FOR C = 0 TO 255

   DEF SEG = ePalSeg
   eRed = PEEK(xPalOff)
   eGrn = PEEK(xPalOff + 1)
   eBlu = PEEK(xPalOff + 2)

   cRed = (eRed * Alpha) + (sRed * (1! - Alpha))
   cGrn = (eGrn * Alpha) + (sGrn * (1! - Alpha))
   cBlu = (eBlu * Alpha) + (sBlu * (1! - Alpha))

   DEF SEG = fPalSeg
   POKE xxPalOff, cRed
   POKE xxPalOff + 1, cGrn
   POKE xxPalOff + 2, cBlu

   xPalOff = xPalOff + 3
   xxPalOff = xxPalOff + 3

NEXT C

DEF SEG

END SUB


'===========================================================================\
FUNCTION FindAngle! (x1 AS SINGLE, y1 AS SINGLE, x2 AS SINGLE, y2 AS SINGLE)

IF y2! = y1! THEN
   IF x1! = x2! THEN EXIT FUNCTION
   IF x2! > x1! THEN FindAngle = 90 ELSE FindAngle = 270
   EXIT FUNCTION
END IF
IF x2! = x1! THEN
   IF y2! > y1! THEN FindAngle = 180
   EXIT FUNCTION
END IF
IF y2! < y1! THEN
   IF x2! > x1! THEN
      FindAngle = ATN((x2! - x1!) / (y2! - y1!)) * -57.29578
   ELSE
      FindAngle = ATN((x2! - x1!) / (y2! - y1!)) * -57.29578 + 360
   END IF
ELSE
   FindAngle = ATN((x2! - x1!) / (y2! - y1!)) * -57.29578 + 180
END IF

END FUNCTION

SUB LoadCOL (COLfile AS STRING, Offset AS LONG, Pal AS STRING)

FileNum = FREEFILE
OPEN COLfile FOR BINARY ACCESS READ AS #FileNum

Pal = SPACE$(768)
GET #FileNum, Offset + 8, Pal

FOR C = 0 TO 255
   RedCol = ASC(MID$(Pal, (3 * C) + 1, 1)) \ 4
   GrnCol = ASC(MID$(Pal, (3 * C) + 2, 1)) \ 4
   BluCol = ASC(MID$(Pal, (3 * C) + 3, 1)) \ 4
   MID$(Pal, (3 * C) + 1) = CHR$(RedCol) + CHR$(GrnCol) + CHR$(BluCol)
NEXT C

CLOSE #FileNum

END SUB


'===========================================================================\
SUB LoadPCX (FileName$, Offset AS LONG, DestSeg AS INTEGER, DestOff AS LONG, Pal AS STRING)

DIM OutOffs AS LONG

OPEN FileName$ FOR BINARY ACCESS READ AS #1

SEEK #1, 129 + (Offset - 1) ' Just skip the headers

DEF SEG = DestSeg
OutOffs = DestOff

' Directly load image to memory
DO
   Byte = ASC(INPUT$(1, 1))

   IF (Byte AND &HC0) = &HC0 THEN
      RLen = Byte AND &H3F
      Byte = ASC(INPUT$(1, 1))
      FOR r = 1 TO RLen
         POKE OutOffs, Byte
         OutOffs = OutOffs + 1
      NEXT r
   ELSE
      POKE OutOffs, Byte
      OutOffs = OutOffs + 1
   END IF

LOOP UNTIL OutOffs >= 64000

Col$ = INPUT$(1, 1)
FOR C = 0 TO 255

   Col$ = INPUT$(3, 1)

   Red = ASC(MID$(Col$, 1, 1)) \ 4
   Grn = ASC(MID$(Col$, 2, 1)) \ 4
   Blu = ASC(MID$(Col$, 3, 1)) \ 4

   MID$(Pal, (3 * C) + 1) = CHR$(Red) + CHR$(Grn) + CHR$(Blu)

NEXT C

CLOSE #1

END SUB


'===========================================================================\
SUB LoadTSP (TSPfile AS STRING, Offset AS LONG, ObjectVerts() AS VertType, ObjectTris() AS TriType)

FileNum = FREEFILE
OPEN TSPfile FOR BINARY ACCESS READ AS #FileNum

SEEK #FileNum, Offset
GET #FileNum, , NumVerts
GET #FileNum, , NumTris
GET #FileNum, , Reserved

REDIM ObjectVerts(1 TO NumVerts) AS VertType
REDIM ObjectTris(1 TO NumTris) AS TriType

FOR P = 1 TO NumVerts: GET #FileNum, , ObjectVerts(P): NEXT
FOR P = 1 TO NumTris: GET #FileNum, , ObjectTris(P): NEXT

CLOSE #FileNum

END SUB

SUB RenderBox (x1, y1, x2, y2, Col)

DIM ScaleVal AS SINGLE

'ScaleVal = (2 ^ ((100 - (100 - Camera.Scale)) / 100)) - 1
ScaleVal = (100 - (100 - Camera.Scale)) / 100

IF ScaleVal < 0 THEN ScaleVal = 0

xCoord = (x - Camera.x) * ScaleVal
yCoord = (y - Camera.y) * ScaleVal

Bx1 = CENTERX + ((x1 * ScaleVal) + xCoord)
By1 = CENTERY + ((y1 * ScaleVal) + yCoord)
Bx2 = CENTERX + ((x2 * ScaleVal) + xCoord)
By2 = CENTERY + ((y2 * ScaleVal) + yCoord)

DQBline 1, Bx1, By1, Bx2, By1, Col
DQBline 1, Bx2, By1, Bx2, By2, Col
DQBline 1, Bx2, By2, Bx1, By2, Col
DQBline 1, Bx1, By2, Bx1, By1, Col

END SUB


'===========================================================================\
SUB RenderObject (x AS SINGLE, y AS SINGLE, Angle AS SINGLE, Scale AS SINGLE, ObjectVerts() AS VertType, ObjectTris() AS TriType)

DIM Tx(1 TO 3)
DIM Ty(1 TO 3)

DIM SinVal AS SINGLE
DIM CosVal AS SINGLE

DIM ScaleVal AS SINGLE
DIM CamScaleVal AS SINGLE

'ScaleVal = (2 ^ ((Scale - (100 - Camera.Scale)) / 100)) - 1
'CamScaleVal = (2 ^ (Camera.Scale / 100)) - 1

'ScaleVal = ((Scale - (100 - Camera.Scale)) / 100)

CamScaleVal = (Camera.Scale / 100)
ScaleVal = (Scale / 100) * CamScaleVal

IF ScaleVal < 0 THEN ScaleVal = 0
IF CamScaleVal < 0 THEN CamScaleVal = 0

xCoord = ((x - Camera.x) * CamScaleVal)
yCoord = ((y - Camera.y) * CamScaleVal)

'xCoord = (X * ScaleVal) - Camera.X
'yCoord = (Y * ScaleVal) - Camera.Y

SinVal = SIN(Angle * ROTPI)
CosVal = COS(Angle * ROTPI)

FOR T = 1 TO UBOUND(ObjectTris)

   Tx(1) = ObjectVerts(ObjectTris(T).P1).x * ScaleVal
   Ty(1) = ObjectVerts(ObjectTris(T).P1).y * ScaleVal
   Tx(2) = ObjectVerts(ObjectTris(T).P2).x * ScaleVal
   Ty(2) = ObjectVerts(ObjectTris(T).P2).y * ScaleVal
   Tx(3) = ObjectVerts(ObjectTris(T).P3).x * ScaleVal
   Ty(3) = ObjectVerts(ObjectTris(T).P3).y * ScaleVal

   FOR r = 1 TO 3
      Tx = Tx(r): Ty = Ty(r)
      Tx(r) = Tx * CosVal - Ty * SinVal
      Ty(r) = Ty * CosVal + Tx * SinVal
      Tx(r) = CENTERX + (Tx(r) + xCoord)
      Ty(r) = CENTERY + (Ty(r) + yCoord)
   NEXT r

   DQBtri 1, Tx(1), Ty(1), Tx(2), Ty(2), Tx(3), Ty(3), ObjectTris(T).Col

NEXT T

END SUB


'===========================================================================\
SUB RenderObjectGamma (x AS SINGLE, y AS SINGLE, Angle AS SINGLE, Scale AS SINGLE, Gamma, ObjectVerts() AS VertType, ObjectTris() AS TriType)

DIM Tx(1 TO 3)
DIM Ty(1 TO 3)

DIM SinVal AS SINGLE
DIM CosVal AS SINGLE

DIM ScaleVal AS SINGLE
DIM CamScaleVal AS SINGLE

'ScaleVal = (2 ^ ((Scale - (100 - Camera.Scale)) / 100)) - 1
'CamScaleVal = (2 ^ (Camera.Scale / 100)) - 1

'ScaleVal = ((Scale - (100 - Camera.Scale)) / 100)

CamScaleVal = (Camera.Scale / 100)
ScaleVal = (Scale / 100) * CamScaleVal

IF ScaleVal < 0 THEN ScaleVal = 0
IF CamScaleVal < 0 THEN CamScaleVal = 0

xCoord = ((x - Camera.x) * CamScaleVal)
yCoord = ((y - Camera.y) * CamScaleVal)

'xCoord = (X * ScaleVal) - Camera.X
'yCoord = (Y * ScaleVal) - Camera.Y

SinVal = SIN(Angle * ROTPI)
CosVal = COS(Angle * ROTPI)

FOR T = 1 TO UBOUND(ObjectTris)

   Tx(1) = ObjectVerts(ObjectTris(T).P1).x * ScaleVal
   Ty(1) = ObjectVerts(ObjectTris(T).P1).y * ScaleVal
   Tx(2) = ObjectVerts(ObjectTris(T).P2).x * ScaleVal
   Ty(2) = ObjectVerts(ObjectTris(T).P2).y * ScaleVal
   Tx(3) = ObjectVerts(ObjectTris(T).P3).x * ScaleVal
   Ty(3) = ObjectVerts(ObjectTris(T).P3).y * ScaleVal

   FOR r = 1 TO 3
      Tx = Tx(r): Ty = Ty(r)
      Tx(r) = Tx * CosVal - Ty * SinVal
      Ty(r) = Ty * CosVal + Tx * SinVal
      Tx(r) = CENTERX + (Tx(r) + xCoord)
      Ty(r) = CENTERY + (Ty(r) + yCoord)
   NEXT r

   TriCol = ((ObjectTris(T).Col MOD 16) - Gamma)
   IF TriCol < 0 THEN TriCol = 0
   TriCol = (16 * (ObjectTris(T).Col \ 16)) + TriCol
   DQBtri 1, Tx(1), Ty(1), Tx(2), Ty(2), Tx(3), Ty(3), TriCol

NEXT T

END SUB


'===========================================================================\
SUB RenderObject3D (x AS SINGLE, y AS SINGLE, z AS SINGLE, PanAng AS SINGLE, TilAng AS SINGLE, RolAng AS SINGLE, ObjectVerts() AS VertType, ObjectTris() AS TriType)

DIM Sx(1 TO 3)
DIM Sy(1 TO 3)

DIM Tx(1 TO 3) AS SINGLE
DIM Ty(1 TO 3) AS SINGLE
DIM Tz(1 TO 3) AS SINGLE

DIM PanSinVal AS SINGLE, PanCosVal AS SINGLE
DIM TilSinVal AS SINGLE, TilCosVal AS SINGLE
DIM RolSinVal AS SINGLE, RolCosVal AS SINGLE

DIM ScaleVal AS SINGLE
DIM CamScaleVal AS SINGLE

IF ScaleVal < 0 THEN ScaleVal = 0
IF CamScaleVal < 0 THEN CamScaleVal = 0


PanSinVal = SIN(PanAng * ROTPI)
PanCosVal = COS(PanAng * ROTPI)
TilSinVal = SIN(TilAng * ROTPI)
TilCosVal = COS(TilAng * ROTPI)
RolSinVal = SIN(RolAng * ROTPI)
RolCosVal = COS(RolAng * ROTPI)

FOR T = 1 TO UBOUND(ObjectTris)
   Tx(1) = ObjectVerts(ObjectTris(T).P1).x
   Ty(1) = ObjectVerts(ObjectTris(T).P1).y
   Tz(1) = 0

   Tx(2) = ObjectVerts(ObjectTris(T).P2).x
   Ty(2) = ObjectVerts(ObjectTris(T).P2).y
   Tz(2) = 0

   Tx(3) = ObjectVerts(ObjectTris(T).P3).x
   Ty(3) = ObjectVerts(ObjectTris(T).P3).y
   Tz(3) = 0

   DontDraw = FALSE
   FOR r = 1 TO 3
     
      ' Tilt
      Tz = Tz(r): Ty = Ty(r)
      Tz(r) = Tz * TilCosVal - Ty * TilSinVal
      Ty(r) = Ty * TilCosVal + Tz * TilSinVal

      ' Pan
      Tx = Tx(r): Tz = Tz(r)
      Tx(r) = Tx * PanCosVal - Tz * PanSinVal
      Tz(r) = Tz * PanCosVal + Tx * PanSinVal

      ' Roll
      Tx = Tx(r): Ty = Ty(r)
      Tx(r) = Tx * RolCosVal - Ty * RolSinVal
      Ty(r) = Ty * RolCosVal + Tx * RolSinVal

      Tx(r) = Tx(r) + x
      Ty(r) = Ty(r) + y
      Tz(r) = Tz(r) + z

      IF Tz(r) < 1 THEN DontDraw = TRUE

      Sx(r) = (Tx(r) * (CENTERX / Tz(r))) + CENTERX
      Sy(r) = (Ty(r) * (CENTERX / Tz(r))) + CENTERY

   NEXT r

   IF DontDraw = FALSE THEN DQBtri 1, Sx(1), Sy(1), Sx(2), Sy(2), Sx(3), Sy(3), ObjectTris(T).Col

NEXT T

END SUB


'===========================================================================\
SUB RenderObject3Dgamma (x AS SINGLE, y AS SINGLE, z AS SINGLE, PanAng AS SINGLE, TilAng AS SINGLE, RolAng AS SINGLE, Gamma, ObjectVerts() AS VertType, ObjectTris() AS TriType)

DIM Sx(1 TO 3)
DIM Sy(1 TO 3)

DIM Tx(1 TO 3) AS SINGLE
DIM Ty(1 TO 3) AS SINGLE
DIM Tz(1 TO 3) AS SINGLE

DIM PanSinVal AS SINGLE, PanCosVal AS SINGLE
DIM TilSinVal AS SINGLE, TilCosVal AS SINGLE
DIM RolSinVal AS SINGLE, RolCosVal AS SINGLE

DIM ScaleVal AS SINGLE
DIM CamScaleVal AS SINGLE

IF ScaleVal < 0 THEN ScaleVal = 0
IF CamScaleVal < 0 THEN CamScaleVal = 0


PanSinVal = SIN(PanAng * ROTPI)
PanCosVal = COS(PanAng * ROTPI)
TilSinVal = SIN(TilAng * ROTPI)
TilCosVal = COS(TilAng * ROTPI)
RolSinVal = SIN(RolAng * ROTPI)
RolCosVal = COS(RolAng * ROTPI)

FOR T = 1 TO UBOUND(ObjectTris)
   Tx(1) = ObjectVerts(ObjectTris(T).P1).x
   Ty(1) = ObjectVerts(ObjectTris(T).P1).y
   Tz(1) = 0

   Tx(2) = ObjectVerts(ObjectTris(T).P2).x
   Ty(2) = ObjectVerts(ObjectTris(T).P2).y
   Tz(2) = 0

   Tx(3) = ObjectVerts(ObjectTris(T).P3).x
   Ty(3) = ObjectVerts(ObjectTris(T).P3).y
   Tz(3) = 0

   DontDraw = FALSE
   FOR r = 1 TO 3
     
      ' Tilt
      Tz = Tz(r): Ty = Ty(r)
      Tz(r) = Tz * TilCosVal - Ty * TilSinVal
      Ty(r) = Ty * TilCosVal + Tz * TilSinVal

      ' Pan
      Tx = Tx(r): Tz = Tz(r)
      Tx(r) = Tx * PanCosVal - Tz * PanSinVal
      Tz(r) = Tz * PanCosVal + Tx * PanSinVal

      ' Roll
      Tx = Tx(r): Ty = Ty(r)
      Tx(r) = Tx * RolCosVal - Ty * RolSinVal
      Ty(r) = Ty * RolCosVal + Tx * RolSinVal

      Tx(r) = Tx(r) + x
      Ty(r) = Ty(r) + y
      Tz(r) = Tz(r) + z

      IF Tz(r) < 1 THEN DontDraw = TRUE

      Sx(r) = (Tx(r) * (CENTERX / Tz(r))) + CENTERX
      Sy(r) = (Ty(r) * (CENTERX / Tz(r))) + CENTERY

   NEXT r

   IF DontDraw = FALSE THEN
      
      TriCol = ((ObjectTris(T).Col MOD 16) - Gamma)
      IF TriCol < 0 THEN TriCol = 0
      TriCol = (16 * (ObjectTris(T).Col \ 16)) + TriCol

      DQBtri 1, Sx(1), Sy(1), Sx(2), Sy(2), Sx(3), Sy(3), TriCol
   END IF

NEXT T

END SUB


'===========================================================================\
SUB DoStars (Angle AS SINGLE, SpawnStars, StarsPresent)

STATIC StarField() AS Star3Dtype
STATIC DimDone

IF DimDone = FALSE THEN
   DIM StarField(1 TO 128) AS Star3Dtype
   DimDone = TRUE
END IF

StarsPresent = 0
FOR S = 1 TO 128
   IF StarField(S).z <= 1 AND SpawnStars THEN
      StarField(S).x = INT(RND * 160) - 100
      StarField(S).y = INT(RND * 160) - 100
      StarField(S).z = 127 + INT(RND * 127)
   END IF
   IF StarField(S).z >= 1 AND StarField(S).z < 127 THEN
      Sx1 = (StarField(S).x * (CENTERX / StarField(S).z))
      Sy1 = (StarField(S).y * (CENTERX / StarField(S).z))
      Sx2 = (StarField(S).x * (CENTERX / (StarField(S).z + 4)))
      Sy2 = (StarField(S).y * (CENTERX / (StarField(S).z + 4)))
      Tx = Sx1: Ty = Sy1
      Sx1 = (Tx * COS(Angle * ROTPI) - Ty * SIN(Angle * ROTPI)) + CENTERX
      Sy1 = (Ty * COS(Angle * ROTPI) + Tx * SIN(Angle * ROTPI)) + CENTERY
      Tx = Sx2: Ty = Sy2
      Sx2 = (Tx * COS(Angle * ROTPI) - Ty * SIN(Angle * ROTPI)) + CENTERX
      Sy2 = (Ty * COS(Angle * ROTPI) + Tx * SIN(Angle * ROTPI)) + CENTERY
      C = 31 - (StarField(S).z \ 8)
      IF C < 16 THEN C = 16
      DQBline 1, Sx1, Sy1, Sx2, Sy2, C
      StarsPresent = StarsPresent + 1
   END IF
   IF StarField(S).z > 0 THEN StarField(S).z = StarField(S).z - 1
NEXT S

END SUB


'===========================================================================\
FUNCTION ScanLine (PlayerNum, x1, y1, x2, y2)

r = x2 - x1
A = y2 - y1

IF A = 0 THEN
	FOR x = x1 TO x2 STEP SGN(r) * 60
		IF x1 = x2 THEN EXIT FOR

		FOR P = 1 TO NumPlayers
			IF PlayerNum <> P THEN
				IF InBox(x, y1, Player(P).x - 60, Player(P).y - 60, Player(P).x + 60, Player(P).y + 60) THEN
					ScanLine = P
					EXIT FUNCTION
				END IF
			END IF
		NEXT P

	NEXT x
ELSEIF r = 0 THEN
	FOR y = y1 TO y2 STEP SGN(A) * 60
		IF y1 = y2 THEN EXIT FOR

		FOR P = 1 TO NumPlayers
			IF PlayerNum <> P THEN
				IF InBox(x1, y, Player(P).x - 60, Player(P).y - 60, Player(P).x + 60, Player(P).y + 60) THEN
					ScanLine = P
					EXIT FUNCTION
				END IF
			END IF
		NEXT P

	NEXT y
ELSE
	IF ABS(r) >= ABS(A) THEN
		S! = A / r
		FOR x = x1 TO x2 STEP SGN(r) * 60
			IF x1 = x2 THEN EXIT FOR
			y = y1 + CINT(S! * (x - x1))
	  
			FOR P = 1 TO NumPlayers
				IF PlayerNum <> P THEN
					IF InBox(x, y, Player(P).x - 60, Player(P).y - 60, Player(P).x + 60, Player(P).y + 60) THEN
						ScanLine = P
						EXIT FUNCTION
					END IF
				END IF
			NEXT P

		NEXT x
	ELSE
		S! = r / A
		FOR y = y1 TO y2 STEP SGN(A) * 60
			IF y1 = y2 THEN EXIT FOR
			x = x1 + CINT(S! * (y - y1))

			FOR P = 1 TO NumPlayers
				IF PlayerNum <> P THEN
					IF InBox(x, y, Player(P).x - 60, Player(P).y - 60, Player(P).x + 60, Player(P).y + 60) THEN
						ScanLine = P
						EXIT FUNCTION
					END IF
				END IF
			NEXT P

		NEXT y
	END IF
END IF

END FUNCTION


'===========================================================================\
FUNCTION InBox (x, y, x1, y1, x2, y2)

IF x >= x1 AND x <= x2 THEN
	IF y >= y1 AND y <= y2 THEN
		InBox = TRUE
	END IF
END IF

END FUNCTION


'===========================================================================\
SUB DoLogo

DIM AngVal AS SINGLE
DIM ScaleVal AS SINGLE

FOR C = 0 TO 255
	DQBsetCol C, 0, 0, 0
NEXT C

WhiteCol = DQBfindPalCol(LogoPal, 62, 62, 62)

FOR S = 0 TO 139

	AngVal = 90 * (S / 139)

	ScaleVal = 1 * SIN(AngVal * ROTPI)

	Bx = CENTERX - (159 * ScaleVal)
	By = CENTERY - (99 * ScaleVal)
	Bwidth = (319 * ScaleVal)
	Bheight = (199 * ScaleVal)

	DQBboxf 1, 0, 0, 319, 199, WhiteCol
	IF Bwidth > 2 AND Bheight > 2 THEN
		DQBsPut 1, Bx, By, VARSEG(LogoImage(0)), VARPTR(LogoImage(0)), Bwidth, Bheight
	END IF

	FVal = 63 * (S / 139)
	CalcSmoothFadeIn FVal, 0, 0, 0, VARSEG(LogoPal), VARPTR(LogoPal), VARSEG(VideoPal), VARPTR(VideoPal)

	DQBwait 1
	DQBsetPal VideoPal
	DQBcopyLayer 1, VIDEO
	DQBclearLayer 1

NEXT S

FOR S = 0 TO 70
	DQBwait 1
NEXT S

FOR S = 63 TO 0 STEP -1
   FVal = S
	CalcSmoothFadeIn FVal, 0, 0, 0, VARSEG(LogoPal), VARPTR(LogoPal), VARSEG(VideoPal), VARPTR(VideoPal)
	DQBwait 1
	DQBsetPal VideoPal
NEXT S

DQBclearLayer 1
DQBclearLayer VIDEO
DQBsetPal DefaultPal

END SUB
