DECLARE SUB FireMissile (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Angle AS SINGLE, Owner%, Target%, MType%)
DECLARE SUB FireBullet (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Angle AS SINGLE, Owner%)
DECLARE SUB DoParticles ()
DECLARE SUB DoTriParticles ()
DECLARE SUB PAD.GetButtonStats ()
DECLARE FUNCTION PAD.Init% (LPTaddr%)
DECLARE SUB DoStars (StarAngle AS SINGLE, SpawnStars, StarsPresent)
DECLARE FUNCTION ScanLine% (PlayerNum%, x1%, y1%, x2%, y2%)
DECLARE FUNCTION InBox% (x%, y%, x1%, y1%, x2%, y2%)
DECLARE SUB ClearStuffs ()
DECLARE SUB DoLogo ()

' Button constants
CONST PAD.B = 1
CONST PAD.Y = 2
CONST PAD.SELECT = 3
CONST PAD.START = 4
CONST PAD.UP = 5
CONST PAD.DOWN = 6
CONST PAD.LEFT = 7
CONST PAD.RIGHT = 8
CONST PAD.A = 9
CONST PAD.X = 10
CONST PAD.L = 11
CONST PAD.R = 12


' For player entities
TYPE PlayerType
	x AS SINGLE
	y AS SINGLE
	Angle AS SINGLE
	xMove AS SINGLE
	yMove AS SINGLE
	aMove AS SINGLE
	FireHeld AS INTEGER
	ShipType AS INTEGER
	HitsTaken AS INTEGER
	MaxHits AS INTEGER
	Dead AS INTEGER
	SpecialsUsed AS INTEGER
	MaxSpecials AS INTEGER
	NextSpecialCount AS INTEGER
	SpecialState AS INTEGER
	LockOnTo AS INTEGER
	Score AS INTEGER
	HitBy AS INTEGER
END TYPE

' For bullet entities
TYPE BulletType
	x AS SINGLE
	y AS SINGLE
	xMove AS SINGLE
	yMove AS SINGLE
	Angle AS SINGLE
	Owner AS INTEGER
	Active AS INTEGER
END TYPE

' For missile entities
TYPE MissileType
	x AS SINGLE
	y AS SINGLE
	xMove AS SINGLE
	yMove AS SINGLE
	Angle AS SINGLE
	Owner AS INTEGER
	MType AS INTEGER
	Target AS INTEGER
	Active AS INTEGER
END TYPE

' For particle entities
TYPE ParticleType
	x AS SINGLE
	y AS SINGLE
	xMove AS SINGLE
	yMove AS SINGLE
	col AS INTEGER
	Active AS INTEGER
END TYPE

' Similar to ParticleType but its triangle particles
TYPE TriParticleType
	x AS SINGLE
	y AS SINGLE
	Angle AS SINGLE
	xMove AS SINGLE
	yMove AS SINGLE
	aMove AS SINGLE
	x1 AS INTEGER
	y1 AS INTEGER
	x2 AS INTEGER
	y2 AS INTEGER
	x3 AS INTEGER
	y3 AS INTEGER
	col AS INTEGER
	Active AS INTEGER
END TYPE

TYPE ConfigDataType
   SoundCardType AS INTEGER
   SoundCardAddr AS INTEGER
   SoundCardIRQ AS INTEGER
   SoundCardDMA AS INTEGER
   SoundQuality AS INTEGER
   InputDevice AS INTEGER
   NumControllers AS INTEGER
   LPTportAddr AS INTEGER
END TYPE

COMMON SHARED PAD.ButtonStatus()
COMMON SHARED Player() AS PlayerType
COMMON SHARED Bullet() AS BulletType
COMMON SHARED Missile() AS MissileType
COMMON SHARED Particle() AS ParticleType
COMMON SHARED TriParticle() AS TriParticleType
COMMON SHARED LogoImage()

COMMON SHARED LogoPal AS STRING * 768
COMMON SHARED DefaultPal AS STRING * 768
COMMON SHARED VideoPal AS STRING * 768
COMMON SHARED CamScale AS SINGLE
COMMON SHARED NumPlayers
COMMON SHARED SoundOn
COMMON SHARED ConfigData AS ConfigDataType

' Game variables
DIM SHARED PAD.ButtonStatus(1 TO 4, 1 TO 12)

' Entity arrays
DIM SHARED Player(1 TO 4) AS PlayerType
DIM SHARED Bullet(1 TO 100) AS BulletType
DIM SHARED Missile(1 TO 8) AS MissileType
DIM SHARED Particle(1 TO 256) AS ParticleType
DIM SHARED TriParticle(1 TO 64) AS TriParticleType
DIM SHARED LogoImage((64000 + 4) \ 2)
