' To run, load QB with /L SPACEWRZ

' A super-cheap and crude TSP file editor because I'm lazy to refine this...
' Anyway, I'll just note the keys:

' L      - Load TSP file (.TSP extension must be present)
' S      - Save TSP file (.TSP extension must be present)
' Space  - Plot vertex or triangle point when the cursor is on a vertex
' Delete - Delete vertex or triangle
' LMB    - Drag vertex
' RMB    - Scroll around
' G      - Set grid size
' C      - Center vertexes
' A      - Zoom in
' Z      - Zoom out
' Esc    - Exit program (doesn't warn if changes are not saved)

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'DIRECTQB.BI'

DECLARE SUB LoadFile ()
DECLARE SUB SaveFile ()
DECLARE SUB DeleteTri (TriNum%)
DECLARE FUNCTION ScanTri% (x%, y%)
DECLARE SUB DrawPanel (x1%, y1%, x2%, y2%, style%)
DECLARE SUB AddTri (P1%, P2%, P3%, Col%)
DECLARE FUNCTION InBox% (x%, y%, x1%, y1%, x2%, y2%)
DECLARE SUB DrawBox (x1%, y1%, x2%, y2%, Col%)
DECLARE SUB AddVert (x%, y%)
DECLARE SUB Init ()
DECLARE SUB Main ()

CONST PALX = 224
CONST PALY = 176

' Edit field coords
CONST FIELDX1 = 0
CONST FIELDX2 = 319
CONST FIELDY1 = 0
CONST FIELDY2 = 175
CONST FCENTERX = (FIELDX2 - FIELDX1) \ 2
CONST FCENTERY = (FIELDY2 - FIELDY1) \ 2

CONST CENTERX = 159
CONST CENTERY = 99

CONST PI = 3.14159762#
CONST ROTPI = PI / 180


TYPE VertType
   x AS INTEGER
   y AS INTEGER
END TYPE

TYPE TriType
   P1 AS INTEGER
   P2 AS INTEGER
   P3 AS INTEGER
   Col AS INTEGER
END TYPE

DIM SHARED ViewX, ViewY, Zoom

DIM SHARED ObjectNumVerts
DIM SHARED ObjectNumTris

DIM SHARED ObjectVerts(1 TO 300) AS VertType
DIM SHARED ObjectTris(1 TO 200) AS TriType

Init
Main

REM $STATIC
SUB AddTri (P1, P2, P3, Col)

IF ObjectNumTris = UBOUND(ObjectTris) THEN SOUND 200, 1: EXIT SUB
ObjectNumTris = ObjectNumTris + 1

ObjectTris(ObjectNumTris).P1 = P1
ObjectTris(ObjectNumTris).P2 = P2
ObjectTris(ObjectNumTris).P3 = P3
ObjectTris(ObjectNumTris).Col = Col

END SUB

SUB AddVert (x, y)

IF ObjectNumVerts = UBOUND(ObjectVerts) THEN SOUND 200, 1: EXIT SUB
ObjectNumVerts = ObjectNumVerts + 1

ObjectVerts(ObjectNumVerts).x = x
ObjectVerts(ObjectNumVerts).y = y

END SUB

SUB DeleteTri (TriNum)

FOR P = TriNum TO ObjectNumTris - 1
   SWAP ObjectTris(P), ObjectTris(P + 1)
NEXT P
ObjectNumTris = ObjectNumTris - 1

END SUB

SUB DrawBox (x1, y1, x2, y2, Col)

DQBline 1, x1, y1, x2, y1, Col
DQBline 1, x2, y1, x2, y2, Col
DQBline 1, x2, y2, x1, y2, Col
DQBline 1, x1, y2, x1, y1, Col

END SUB

SUB DrawPanel (x1, y1, x2, y2, style)

SELECT CASE style
   CASE 0 ' Outward
      ' Panel
      DQBline 1, x1, y1, x2, y1, 28
      DQBline 1, x1, y1, x1, y2, 28
      DQBline 1, x2, y1, x2, y2, 24
      DQBline 1, x1, y2, x2, y2, 24
      DQBboxF 1, x1 + 1, y1 + 1, x2 - 1, y2 - 1, 26

      ' Corners
      DQBpset 1, x1, y1, 30
      DQBpset 1, x2, y1, 25
      DQBpset 1, x1, y2, 25
      DQBpset 1, x2, y2, 22

   CASE 1 ' Inward
      ' Panel
      DQBline 1, x1, y1, x2, y1, 24
      DQBline 1, x1, y1, x1, y2, 24
      DQBline 1, x2, y1, x2, y2, 28
      DQBline 1, x1, y2, x2, y2, 28
      DQBboxF 1, x1 + 1, y1 + 1, x2 - 1, y2 - 1, 26

      ' Corners
      DQBpset 1, x1, y1, 22
      DQBpset 1, x2, y1, 25
      DQBpset 1, x1, y2, 25
      DQBpset 1, x2, y2, 30

   CASE 2 ' Inward with different fill color
      ' Panel
      'LINE (x1, y1)-(x2, y1), _RGB32(136, 136, 136)
      'LINE (x1, y1)-(x1, y2), _RGB32(136, 136, 136)
      'LINE (x2, y1)-(x2, y2), _RGB32(204, 204, 204)
      'LINE (x1, y2)-(x2, y2), _RGB32(204, 204, 204)
      'LINE (x1 + 1, y1 + 1)-(x2 - 1, y2 - 1), _RGB32(180, 180, 180), BF
      ' Corners
      'PSET (x1, y1), _RGB32(102, 102, 102)
      'PSET (x2, y1), _RGB32(170, 170, 170)
      'PSET (x1, y2), _RGB32(170, 170, 170)
      'PSET (x2, y2), _RGB32(221, 221, 221)

   CASE 3 ' Inward with no fill
      ' Panel
      DQBline 1, x1, y1, x2, y1, 24
      DQBline 1, x1, y1, x1, y2, 24
      DQBline 1, x2, y1, x2, y2, 28
      DQBline 1, x1, y2, x2, y2, 28

      ' Corners
      DQBpset 1, x1, y1, 22
      DQBpset 1, x2, y1, 25
      DQBpset 1, x1, y2, 25
      DQBpset 1, x2, y2, 30

END SELECT

END SUB

FUNCTION InBox (x, y, x1, y1, x2, y2)

IF x >= x1 AND x <= x2 THEN
   IF y >= y1 AND y <= y2 THEN
      InBox = TRUE
   END IF
END IF

END FUNCTION

SUB Init

DIM Pal AS STRING * 768

IF DQBinit(1, 0, 0) THEN PRINT DQBerror$: END
DQBfpu

Crap = DQBloadFont("MICRO.FNT")

OPEN "SPACEPAL.COL" FOR BINARY AS #1
GET #1, 9, Pal
CLOSE #1

FOR C = 0 TO 255
   RedVal = ASC(MID$(Pal, (3 * C) + 1, 1)) \ 4
   GrnVal = ASC(MID$(Pal, (3 * C) + 2, 1)) \ 4
   BluVal = ASC(MID$(Pal, (3 * C) + 3, 1)) \ 4
   MID$(Pal, (3 * C) + 1) = CHR$(RedVal) + CHR$(GrnVal) + CHR$(BluVal)
NEXT C

DQBinitVGA
DQBsetPal Pal

END SUB

SUB LoadFile

Count = 1
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ <> "" AND LEN(FileName$) < 12 THEN
      IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.", Press$) THEN
         FileName$ = FileName$ + Press$
      END IF
   END IF

   IF Press$ = CHR$(8) AND LEN(FileName$) THEN
      FileName$ = LEFT$(FileName$, LEN(FileName$) - 1)
   END IF

   Txt$ = "File name: " + FileName$
   IF Cursor THEN Txt$ = Txt$ + "_"
   DQBprint 1, Txt$, 1, 1, 15

   DQBwait 1
   DQBcopyLayer 1, VIDEO
   DQBclearLayer 1

   Count = Count + 1
   IF Count > 10 THEN Cursor = (Cursor + 1) AND 1: Count = 1

   IF Press$ = CHR$(27) THEN EXIT SUB

LOOP UNTIL Press$ = CHR$(13) AND FileName$ <> ""

OPEN FileName$ FOR BINARY AS #1

GET #1, , ObjectNumVerts
GET #1, , ObjectNumTris
GET #1, , Reserved

FOR W = 1 TO ObjectNumVerts: GET #1, , ObjectVerts(W): NEXT
FOR W = 1 TO ObjectNumTris: GET #1, , ObjectTris(W): NEXT

CLOSE #1

END SUB

SUB Main

DIM TriPlot(1 TO 3)
DIM sMouseX AS SINGLE
DIM sMouseY AS SINGLE

CurCol = 15
GridSize = 1
ViewX = 0
ViewY = 0

Zoom = 1

DO
   Press$ = UCASE$(INKEY$)

   OldMouseLB = MouseLB
   OldMouseRB = MouseRB

   OldMouseX = MouseX
   OldMouseY = MouseY

   MouseX = DQBmouseX
   MouseY = DQBmouseY
   MouseLB = DQBmouseLB
   MouseRB = DQBmouseRB

   MouseMoveX = MouseX - OldMouseX
   MouseMoveY = MouseY - OldMouseY
  

   IF MouseLB AND OldMouseLB = 0 THEN MouseLBclick = TRUE ELSE MouseLBclick = FALSE
   IF MouseRB AND OldMouseRB = 0 THEN MouseRBclick = TRUE ELSE MouseRBclick = FALSE


   IF Press$ = "A" THEN Zoom = Zoom + 1
   IF Press$ = "Z" AND Zoom > 1 THEN Zoom = Zoom - 1

   sMouseX = (MouseX - FCENTERX) / Zoom
   sMouseY = (MouseY - FCENTERY) / Zoom


   IF MouseRB THEN
      IF MouseRBclick AND InBox(MouseX, MouseY, FIELDX1, FIELDY1, FIELDX2, FIELDY2) AND MoveView = FALSE THEN
         MouseClickX = sMouseX
         MouseClickY = sMouseY
         ViewClickX = ViewX
         ViewClickY = ViewY
         MoveView = TRUE
      END IF
   ELSE
      MoveView = FALSE
   END IF

   IF MoveView THEN
      ViewX = ViewClickX + (sMouseX - MouseClickX)
      ViewY = ViewClickY + (sMouseY - MouseClickY)
   END IF


   ' Change grid size
   IF Press$ = "G" THEN
      GridSize = GridSize - 1
      IF GridSize < 1 THEN GridSize = 8
   END IF


   ' Plot vertex or triangle
   VertX = (sMouseX - ViewX)
   VertY = (sMouseY - ViewY)

   IF Press$ = " " THEN

      FOR P = 1 TO ObjectNumVerts
         IF InBox(INT(VertX), INT(VertY), ObjectVerts(P).x - 1, ObjectVerts(P).y - 1, ObjectVerts(P).x + 1, ObjectVerts(P).y + 1) THEN

            Bad = FALSE
            FOR C = 1 TO PlotStep
               IF TriPlot(C) = P THEN Bad = TRUE: EXIT FOR
            NEXT C

            IF Bad = FALSE THEN
               PlotStep = PlotStep + 1
               TriPlot(PlotStep) = P
            END IF

            EXIT FOR
         END IF
      NEXT P

      IF PlotStep = 0 THEN AddVert VertX, VertY

      IF PlotStep = 3 THEN
         AddTri TriPlot(1), TriPlot(2), TriPlot(3), CurCol
         FOR P = 1 TO 3: TriPlot(1) = 0: NEXT P
         PlotStep = 0
      END IF
           
   END IF


   ' Move clicked vertex
   DragVert = FALSE
   IF SelPoint AND MouseLB THEN

      'IF SGN((MouseX - ViewX) - FCENTERX) >= 0 THEN
      '   ObjectVerts(SelPoint).X = GridSize * ((((MouseX - ViewX) - FCENTERX) + (GridSize \ 2)) \ GridSize)
      'ELSE
      '   ObjectVerts(SelPoint).X = GridSize * ((((MouseX - ViewX) - FCENTERX) - (GridSize \ 2)) \ GridSize)
      'END IF

      'IF SGN((MouseY - ViewY) - FCENTERY) >= 0 THEN
      '   ObjectVerts(SelPoint).Y = GridSize * ((((MouseY - ViewY) - FCENTERY) + (GridSize \ 2)) \ GridSize)
      'ELSE
      '   ObjectVerts(SelPoint).Y = GridSize * ((((MouseY - ViewY) - FCENTERY) - (GridSize \ 2)) \ GridSize)
      'END IF

      IF SGN(VertX) >= 0 THEN
         ObjectVerts(SelPoint).x = GridSize * ((VertX + (GridSize \ 2)) \ GridSize)
      ELSE
         ObjectVerts(SelPoint).x = GridSize * ((VertX - (GridSize \ 2)) \ GridSize)
      END IF

      IF SGN(VertY) >= 0 THEN
         ObjectVerts(SelPoint).y = GridSize * ((VertY + (GridSize \ 2)) \ GridSize)
      ELSE
         ObjectVerts(SelPoint).y = GridSize * ((VertY - (GridSize \ 2)) \ GridSize)
      END IF

      DragVert = TRUE

   END IF

   
   ' Grab color from polygon
   IF Press$ = CHR$(9) AND InBox(MouseX, MouseY, FIELDX1, FIELDY1, FIELDX2, FIELDY2) THEN
      
      OnTri = ScanTri(MouseX, MouseY)
      IF OnTri THEN
         CurCol = ObjectTris(OnTri).Col
      END IF

   END IF


   ' Apply current color to polygon
   IF Press$ = CHR$(13) AND InBox(MouseX, MouseY, FIELDX1, FIELDY1, FIELDX2, FIELDY2) THEN

      OnTri = ScanTri(MouseX, MouseY)

      IF OnTri THEN
         ObjectTris(OnTri).Col = CurCol
      END IF

   END IF

   
   ' Bring triangle up
   IF Press$ = CHR$(0) + "I" THEN
      OnTri = ScanTri(MouseX, MouseY)
      IF OnTri AND OnTri < ObjectNumTris THEN
         SWAP ObjectTris(OnTri), ObjectTris(OnTri + 1)
      END IF
   END IF


   ' Send triangle back
   IF Press$ = CHR$(0) + "Q" THEN
      OnTri = ScanTri(MouseX, MouseY)
      IF OnTri > 1 THEN
         SWAP ObjectTris(OnTri), ObjectTris(OnTri - 1)
      END IF
   END IF


   ' Delete triangle or vertex
   IF Press$ = CHR$(0) + "S" THEN
  
      ' Delete vertex
      FOR P = 1 TO ObjectNumVerts
         IF InBox(MouseX - ViewX, MouseY - ViewY, ObjectVerts(P).x - 1, ObjectVerts(P).y - 1, ObjectVerts(P).x + 1, ObjectVerts(P).y + 1) THEN
            OnVert = P
         END IF
      NEXT P

      DeleteVert = FALSE
      IF OnVert THEN
         
         ' Delete any polygon connected to this vertex
         S = 0
         DO
            IF S THEN IF ObjectTris(S).P1 = OnVert THEN DeleteTri S: S = 0
            IF S THEN IF ObjectTris(S).P2 = OnVert THEN DeleteTri S: S = 0
            IF S THEN IF ObjectTris(S).P3 = OnVert THEN DeleteTri S: S = 0

            S = S + 1
         LOOP UNTIL S > ObjectNumTris

         FOR P = OnVert TO ObjectNumVerts - 1
            SWAP ObjectVerts(P), ObjectVerts(P + 1)
         NEXT P
         ObjectNumVerts = ObjectNumVerts - 1
         DeleteVert = TRUE

         ' Correct vertex numbers of existing triangles
         FOR P = 1 TO ObjectNumTris
            IF ObjectTris(P).P1 > OnVert THEN ObjectTris(P).P1 = ObjectTris(P).P1 - 1
            IF ObjectTris(P).P2 > OnVert THEN ObjectTris(P).P2 = ObjectTris(P).P2 - 1
            IF ObjectTris(P).P3 > OnVert THEN ObjectTris(P).P3 = ObjectTris(P).P3 - 1
         NEXT P

      END IF

      ' Delete triangle
      IF DeleteVert = FALSE THEN
         OnTri = ScanTri(MouseX, MouseY)
         IF OnTri AND ObjectNumTris > 0 THEN
            DeleteTri OnTri
         END IF
      END IF

   END IF


   ' Center all verts
   IF Press$ = "C" THEN

      Ox1 = 0
      Oy1 = 0
      Ox2 = 0
      Oy2 = 0
      FOR P = 1 TO ObjectNumVerts

         IF ObjectVerts(P).x < Ox1 THEN Ox1 = ObjectVerts(P).x
         IF ObjectVerts(P).x > Ox2 THEN Ox2 = ObjectVerts(P).x
        
         IF ObjectVerts(P).y < Oy1 THEN Oy1 = ObjectVerts(P).y
         IF ObjectVerts(P).y > Oy2 THEN Oy2 = ObjectVerts(P).y

      NEXT P

      Cx = (Ox1 + Ox2) \ 2
      Cy = (Oy1 + Oy2) \ 2

      ' Move verts to center object
      FOR P = 1 TO ObjectNumVerts

         ObjectVerts(P).x = ObjectVerts(P).x - Cx
         ObjectVerts(P).y = ObjectVerts(P).y - Cy

      NEXT P

   END IF

 
   ' Color selection
   IF MouseLBclick AND InBox(MouseX, MouseY, PALX, PALY, PALX + 95, PALY + 24) THEN
      PalClick = TRUE
   ELSE
      IF MouseLB = FALSE THEN PalClick = FALSE
   END IF

   IF PalClick THEN
      Mx = MouseX
      My = MouseY

      IF Mx < PALX THEN Mx = PALX
      IF Mx > PALX + 95 THEN Mx = PALX + 95
      IF My < PALY THEN My = PALY
      IF My > PALY + 24 THEN My = PALY + 24

      Cx = (Mx - PALX) \ 3
      Cy = (My - PALY) \ 3

      CurCol = Cx + (32 * Cy)
   END IF


   ' Cancel states
   IF Press$ = CHR$(27) AND PlotStep THEN PlotStep = 0: Press$ = ""


   ' Save and load
   IF Press$ = "S" THEN SaveFile
   IF Press$ = "L" THEN LoadFile


   ' Draw grid
   IF GridSize > 1 THEN
    
      zGridSize = GridSize * Zoom
      FOR Px = FIELDX1 TO FIELDX2 STEP zGridSize
         Lx = Px + (((ViewX * Zoom) + FCENTERX) MOD zGridSize)
         DQBline 1, Lx, 0, Lx, 175, 20
      NEXT Px
     
      FOR Py = FIELDY1 TO FIELDY2 STEP zGridSize
         Ly = Py + (((ViewY * Zoom) + FCENTERY) MOD zGridSize)
         DQBline 1, 0, Ly, 319, Ly, 20
      NEXT Py

   END IF

 
   ' Draw center cross
   Lx = (ViewX * Zoom) + FCENTERX
   Ly = (ViewY * Zoom) + FCENTERY
   DQBline 1, Lx, FIELDY1, Lx, FIELDY2, 4
   DQBline 1, FIELDX1, Ly, FIELDX2, Ly, 4

   'DQBpset 1, ViewX, ViewY, 15

 
   ' Draw triangles
   FOR P = 1 TO ObjectNumTris
      Lx1 = ((ObjectVerts(ObjectTris(P).P1).x + ViewX) * Zoom) + FCENTERX
      Ly1 = ((ObjectVerts(ObjectTris(P).P1).y + ViewY) * Zoom) + FCENTERY
      Lx2 = ((ObjectVerts(ObjectTris(P).P2).x + ViewX) * Zoom) + FCENTERX
      Ly2 = ((ObjectVerts(ObjectTris(P).P2).y + ViewY) * Zoom) + FCENTERY
      Lx3 = ((ObjectVerts(ObjectTris(P).P3).x + ViewX) * Zoom) + FCENTERX
      Ly3 = ((ObjectVerts(ObjectTris(P).P3).y + ViewY) * Zoom) + FCENTERY

      DQBtri 1, Lx1, Ly1, Lx2, Ly2, Lx3, Ly3, ObjectTris(P).Col

   NEXT P


   ' Draw vertexes
   IF DragVert = FALSE THEN SelPoint = 0
   OnVert = 0
   FOR P = 1 TO ObjectNumVerts

      Lx = FCENTERX + ((ObjectVerts(P).x + ViewX) * Zoom)
      Ly = FCENTERY + ((ObjectVerts(P).y + ViewY) * Zoom)

      IF InBox(MouseX, MouseY, Lx - 1, Ly - 1, Lx + 1, Ly + 1) THEN
         IF MouseLBclick AND InBox(MouseX, MouseY, FIELDX1, FIELDY1, FIELDX2, FIELDY2) THEN
            IF DragVert = FALSE THEN SelPoint = P
         END IF
         OnVert = P
         DrawBox Lx - 1, Ly - 1, Lx + 1, Ly + 1, 15
      ELSE
         DrawBox Lx - 1, Ly - 1, Lx + 1, Ly + 1, 14
      END IF

      IF DragVert AND SelPoint = P THEN DrawBox Lx - 1, Ly - 1, Lx + 1, Ly + 1, 15

   NEXT P


   ' Draw wireframe of new triangle
   SELECT CASE PlotStep
      CASE 1
         Lx = ((ObjectVerts(TriPlot(1)).x + ViewX) * Zoom) + FCENTERX
         Ly = ((ObjectVerts(TriPlot(1)).y + ViewY) * Zoom) + FCENTERY

         DQBline 1, Lx, Ly, MouseX, MouseY, CurCol

      CASE 2
         Lx1 = ((ObjectVerts(TriPlot(1)).x + ViewX) * Zoom) + FCENTERX
         Ly1 = ((ObjectVerts(TriPlot(1)).y + ViewY) * Zoom) + FCENTERY
        
         Lx2 = ((ObjectVerts(TriPlot(2)).x + ViewX) * Zoom) + FCENTERX
         Ly2 = ((ObjectVerts(TriPlot(2)).y + ViewY) * Zoom) + FCENTERY

         DQBline 1, Lx1, Ly1, Lx2, Ly2, CurCol
         DQBline 1, Lx1, Ly1, MouseX, MouseY, CurCol
         DQBline 1, Lx2, Ly2, MouseX, MouseY, CurCol

   END SELECT


   ' Draw status panel
   DrawPanel 0, 176, 223, 199, 0

   DQBprint 1, "X:" + LTRIM$(STR$(VertX)), 2, 178, 15
   DQBprint 1, "Y:" + LTRIM$(STR$(VertY)), 2, 184, 15

   DQBprint 1, "GridSize:" + LTRIM$(STR$(GridSize)), 30, 178, 15
   DQBprint 1, "Zoom:" + LTRIM$(STR$(Zoom)), 30, 184, 15

   DQBprint 1, "NumVerts:" + LTRIM$(STR$(ObjectNumVerts)), 80, 178, 15
   DQBprint 1, "NumTris:" + LTRIM$(STR$(ObjectNumTris)), 80, 184, 15


   ' Draw color palette
   FOR Cy = 0 TO 7
      FOR Cx = 0 TO 31
         Lx = PALX + (3 * Cx)
         Ly = PALY + (3 * Cy)
         Lx2 = Lx + 2
         Ly2 = Ly + 2
         Col = Cx + (32 * Cy)
         DQBboxF 1, Lx, Ly, Lx2, Ly2, Col
      NEXT Cx
   NEXT Cy


   Cx = PALX + (3 * (CurCol MOD 32))
   Cy = PALY + (3 * (CurCol \ 32))
   DQBbox 1, Cx, Cy, Cx + 2, Cy + 2, 23 + C


   DQBline 1, MouseX - 5, MouseY, MouseX - 1, MouseY, 14
   DQBline 1, MouseX + 5, MouseY, MouseX + 1, MouseY, 14
   DQBline 1, MouseX, MouseY - 5, MouseX, MouseY - 1, 14
   DQBline 1, MouseX, MouseY + 5, MouseX, MouseY + 1, 14

   DQBwait 1
   DQBcopyLayer 1, VIDEO
   DQBclearLayer 1

   C = 7 * SIN(A * ROTPI)
   A = (A + 6) MOD 360

LOOP UNTIL Press$ = CHR$(27)

DQBclose

END SUB

SUB RenderBox (x1, y1, x2, y2, Col)

ScaleVal! = 2! ^ (1 * ((Scale - (Camera.Scale - 100)) / 100))
IF ScaleVal! < 0 THEN ScaleVal! = 0

bx1 = CENTERX + ((x1 - Camera.X) * ScaleVal!)
by1 = CENTERY + ((y1 - Camera.Y) * ScaleVal!)
bx2 = CENTERX + ((x2 - Camera.X) * ScaleVal!)
by2 = CENTERY + ((y2 - Camera.Y) * ScaleVal!)

DQBline 1, bx1, by1, bx2, by1, Col
DQBline 1, bx2, by1, bx2, by2, Col
DQBline 1, bx2, by2, bx1, by2, Col
DQBline 1, bx1, by2, bx1, by1, Col

END SUB

SUB RenderObject (x, y, Angle, Scale AS SINGLE, ObjectVerts() AS VertType, ObjectTris() AS TriType)

DIM Tx(1 TO 3)
DIM Ty(1 TO 3)

ScaleVal! = 2! ^ (1 * ((Scale - (Camera.Scale - 100)) / 100))
IF ScaleVal! < 0 THEN ScaleVal! = 0

xCoord = (x - Camera.X) * ScaleVal!
yCoord = (y - Camera.Y) * ScaleVal!

FOR T = 1 TO UBOUND(ObjectTris)
   Tx(1) = ObjectVerts(ObjectTris(T).P1).x * ScaleVal!
   Ty(1) = ObjectVerts(ObjectTris(T).P1).y * ScaleVal!
   Tx(2) = ObjectVerts(ObjectTris(T).P2).x * ScaleVal!
   Ty(2) = ObjectVerts(ObjectTris(T).P2).y * ScaleVal!
   Tx(3) = ObjectVerts(ObjectTris(T).P3).x * ScaleVal!
   Ty(3) = ObjectVerts(ObjectTris(T).P3).y * ScaleVal!

   FOR R = 1 TO 3
      Tx = Tx(R): Ty = Ty(R)
      Tx(R) = Tx * COS(Angle * ROTPI) - Ty * SIN(Angle * ROTPI)
      Ty(R) = Ty * COS(Angle * ROTPI) + Tx * SIN(Angle * ROTPI)
      Tx(R) = CENTERX + (Tx(R) + xCoord)
      Ty(R) = CENTERY + (Ty(R) + yCoord)
   NEXT R

   DQBtri 1, Tx(1), Ty(1), Tx(2), Ty(2), Tx(3), Ty(3), ObjectTris(T).Col
NEXT T

END SUB

SUB SaveFile

Count = 1
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ <> "" AND LEN(FileName$) < 12 THEN
      IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.", Press$) THEN
         FileName$ = FileName$ + Press$
      END IF
   END IF

   IF Press$ = CHR$(8) AND LEN(FileName$) THEN
      FileName$ = LEFT$(FileName$, LEN(FileName$) - 1)
   END IF

   Txt$ = "File name: " + FileName$
   IF Cursor THEN Txt$ = Txt$ + "_"
   DQBprint 1, Txt$, 1, 1, 15

   DQBwait 1
   DQBcopyLayer 1, VIDEO
   DQBclearLayer 1

   Count = Count + 1
   IF Count > 10 THEN Cursor = (Cursor + 1) AND 1: Count = 1

   IF Press$ = CHR$(27) THEN EXIT SUB

LOOP UNTIL Press$ = CHR$(13) AND FileName$ <> ""

OPEN FileName$ FOR BINARY AS #1

IF LOF(1) THEN
   CLOSE #1: KILL FileName$
   OPEN FileName$ FOR BINARY AS #1
END IF

PUT #1, , ObjectNumVerts
PUT #1, , ObjectNumTris
PUT #1, , Reserved

FOR P = 1 TO ObjectNumVerts: PUT #1, , ObjectVerts(P): NEXT
FOR P = 1 TO ObjectNumTris: PUT #1, , ObjectTris(P): NEXT

CLOSE #1

END SUB

FUNCTION ScanTri (x, y)


FOR P = ObjectNumTris TO 1 STEP -1

   Lx1 = ((ObjectVerts(ObjectTris(P).P1).x + ViewX) * Zoom) + FCENTERX
   Ly1 = ((ObjectVerts(ObjectTris(P).P1).y + ViewY) * Zoom) + FCENTERY
   Lx2 = ((ObjectVerts(ObjectTris(P).P2).x + ViewX) * Zoom) + FCENTERX
   Ly2 = ((ObjectVerts(ObjectTris(P).P2).y + ViewY) * Zoom) + FCENTERY
   Lx3 = ((ObjectVerts(ObjectTris(P).P3).x + ViewX) * Zoom) + FCENTERX
   Ly3 = ((ObjectVerts(ObjectTris(P).P3).y + ViewY) * Zoom) + FCENTERY

   DQBtri 1, Lx1, Ly1, Lx2, Ly2, Lx3, Ly3, 1

   IF DQBpoint(1, x, y) THEN
      ScanTri = P
      DQBclearLayer 1
      EXIT FUNCTION
   END IF

   DQBclearLayer 1

NEXT P


END FUNCTION

