DECLARE SUB InputLPTaddress ()
DECLARE SUB CenterPrint (Txt$, y%)
DECLARE SUB DrawDialog (Txt$, TxtCol%, ForeCol%, BackCol%)
DECLARE SUB SoundTest ()
DECLARE SUB DrawPanel (x1%, y1%, x2%, y2%, sep%, Fcol%, Bcol%)
DECLARE SUB UpdateMainPanel ()
DECLARE SUB ControllerCount ()
DECLARE SUB InputDevice ()
DECLARE SUB InputSettings ()
DECLARE SUB SoundQuality ()
DECLARE SUB SoundCardDMA ()
DECLARE SUB SoundCardIRQ ()
DECLARE SUB SoundCardAddr ()
DECLARE SUB SoundCardType ()
DECLARE SUB SoundSettings ()
DECLARE SUB PrintHeader (Txt$)
DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$INCLUDE: 'SPACEDAT.BI'

TYPE ConfigDataType
   SoundCardType AS INTEGER
   SoundCardAddr AS INTEGER
   SoundCardIRQ AS INTEGER
   SoundCardDMA AS INTEGER
   SoundQuality AS INTEGER
   InputDevice AS INTEGER
   NumControllers AS INTEGER
   LPTportAddr AS INTEGER
END TYPE

DIM SHARED DummyArray(32000) AS INTEGER
DIM SHARED ConfigData AS ConfigDataType

OPEN "SETUP.DAT" FOR BINARY AS #1

IF LOF(1) = 0 THEN
   ConfigData.SoundCardType = 0
   ConfigData.SoundCardAddr = &HFFFF
   ConfigData.SoundCardIRQ = &HFF
   ConfigData.SoundCardDMA = &HFF
   ConfigData.SoundQuality = 0
   ConfigData.LPTportAddr = &H378
   PUT #1, , ConfigData
ELSE
   GET #1, , ConfigData
END IF

CLOSE #1

CLS
WIDTH 80, 25
VIEW PRINT

PrintHeader "SPACEWAR 4P - Cheap Setup Program               (?) 2013 Meido-Tek Productions"

COLOR 7, 0
FOR Py = 2 TO 25
   FOR Px = 1 TO 80
      LOCATE Py, Px
      PRINT "";
   NEXT Px
NEXT Py

DrawPanel 3, 3, 24, 9, 2, 15, 1
COLOR 14, 1
LOCATE 4, 9: PRINT "Main Menu"

Sel = 1
DO
   Press$ = INKEY$

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 1 THEN Sel = 3
   IF Sel > 3 THEN Sel = 1

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 1: SoundSettings
         CASE 2: InputSettings
         CASE 3: EXIT DO
      END SELECT
   END IF

   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 5: PRINT "  Sound settings  "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 5: PRINT "  Input settings  "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 5: PRINT "  Exit            "

LOOP UNTIL Press$ = CHR$(27)

DrawPanel 30, 10, 50, 15, 2, 15, 1
COLOR 14, 1
LOCATE 11, 34: PRINT "Save settings?"

Sel = 2
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 1 THEN Sel = 2
   IF Sel > 2 THEN Sel = 1

   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 13, 32: PRINT "  Yes            "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 14, 32: PRINT "  No             "

LOOP UNTIL Press$ = CHR$(13) OR Press$ = CHR$(27)
IF Press$ = CHR$(27) THEN Sel = 0

IF Sel = 1 THEN
   OPEN "SETUP.DAT" FOR BINARY AS #1
   PUT #1, , ConfigData
   CLOSE #1
END IF

COLOR 7, 0
CLS
END

REM $STATIC
SUB CenterPrint (Txt$, y)

Tx = 40 - ((LEN(Txt$) - 1) \ 2)

LOCATE y, Tx: PRINT Txt$;

END SUB

SUB ControllerCount

PCOPY 0, 2

DrawPanel 47, 3, 78, 10, 2, 15, 1
COLOR 14, 1
LOCATE 4, 49: PRINT "Select Number of Controllers"
COLOR 7, 1

SELECT CASE ConfigData.NumControllers
   CASE 0: Sel = 0
   CASE IS >= 2: Sel = ConfigData.NumControllers - 1
END SELECT

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 3
   IF Sel > 3 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 0: ConfigData.NumControllers = 0
         CASE IS >= 1: ConfigData.NumControllers = Sel + 1
      END SELECT
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 49: PRINT "  Autodetect                "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 49: PRINT "  2 controllers             "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 49: PRINT "  3 controllers             "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 49: PRINT "  4 controllers             "

LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB DrawDialog (Txt$, TxtCol, ForeCol, BackCol)

Tx1 = 40 - ((LEN(Txt$) - 1) \ 2)
Tx2 = 40 + ((LEN(Txt$) - 1) \ 2)

DrawPanel Tx1 - 2, 12, Tx2 + 2, 14, 0, ForeCol, BackCol

COLOR TxtCol
LOCATE 13, Tx1
PRINT Txt$

END SUB

SUB DrawPanel (x1, y1, x2, y2, sep, Fcol, Bcol)

COLOR Fcol, Bcol
LOCATE y1, x1: PRINT "";
LOCATE y1, x2: PRINT "";
LOCATE y2, x1: PRINT "";
LOCATE y2, x2: PRINT "";

FOR Px = x1 + 1 TO x2 - 1
   LOCATE y1, Px: PRINT "";
   LOCATE y2, Px: PRINT "";
NEXT Px

FOR Py = y1 + 1 TO y2 - 1
   LOCATE Py, x1: PRINT "";
   LOCATE Py, x2: PRINT "";
NEXT Py


FOR Py = y1 + 1 TO y2 - 1
   FOR Px = x1 + 1 TO x2 - 1
      LOCATE Py, Px: PRINT " ";
   NEXT Px
NEXT Py


IF sep THEN
   LOCATE y1 + sep, x1
   PRINT ""; STRING$((x2 - x1) - 1, ""); ""
END IF

END SUB

SUB InputDevice

PCOPY 0, 2

DrawPanel 47, 3, 70, 8, 2, 15, 1
COLOR 14, 1
LOCATE 4, 50: PRINT "Select Input Device"
COLOR 7, 1

Sel = ConfigData.InputDevice

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 1
   IF Sel > 1 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      ConfigData.InputDevice = Sel
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 49: PRINT "  Keyboard          "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 49: PRINT "  SNES controllers  "

LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB InputLPTaddress

PCOPY 0, 2

DrawPanel 47, 3, 69, 9, 2, 15, 1
COLOR 14, 1
LOCATE 4, 49: PRINT "Select port address"
COLOR 7, 1

SELECT CASE ConfigData.LPTportAddr
   CASE &H378: Sel = 0
   CASE &H278: Sel = 1
   CASE &H3BC: Sel = 2
END SELECT

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 2
   IF Sel > 2 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 0: ConfigData.LPTportAddr = &H378
         CASE 1: ConfigData.LPTportAddr = &H278
         CASE 2: ConfigData.LPTportAddr = &H3BC
      END SELECT
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 49: PRINT "  378h             "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 49: PRINT "  278h             "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 49: PRINT "  3BCh             "


LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0


END SUB

SUB InputSettings

PCOPY 0, 1

DrawPanel 24, 3, 47, 10, 2, 15, 1
COLOR 14, 1
LOCATE 4, 29: PRINT "Input Settings"
COLOR 7, 1

Sel = 1
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 1 THEN Sel = 4
   IF Sel > 4 THEN Sel = 1

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 1: InputDevice
         CASE 2: IF ConfigData.InputDevice = 1 THEN ControllerCount
         CASE 3: IF ConfigData.InputDevice = 1 THEN InputLPTaddress
         CASE 4: EXIT DO
      END SELECT
   END IF

   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 26: PRINT "  Input device      "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.InputDevice = 0 THEN COLOR 8
   LOCATE 7, 26: PRINT "  Controller count  "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.InputDevice = 0 THEN COLOR 8
   LOCATE 8, 26: PRINT "  LPT port address  "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 26: PRINT "  Exit              "

LOOP UNTIL Press$ = CHR$(27)

PCOPY 1, 0

END SUB

SUB PrintHeader (Txt$)

Tx = 40 - ((LEN(Txt$) - 1) \ 2)
COLOR 0, 7
LOCATE 1, 1
PRINT SPACE$(80);

LOCATE 1, Tx
PRINT Txt$;

END SUB

SUB SoundCardAddr

PCOPY 0, 2

DrawPanel 49, 3, 66, 15, 2, 15, 1
COLOR 14, 1
LOCATE 4, 51: PRINT "Select Address"
COLOR 7, 1

IF ConfigData.SoundCardAddr = &HFFFF THEN
   Sel = 0
ELSE
   Sel = (VAL(HEX$(ConfigData.SoundCardAddr)) - 200) \ 10
END IF

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 8
   IF Sel > 8 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      IF Sel = 0 THEN
         ConfigData.SoundCardAddr = &HFFFF
      ELSE
         ConfigData.SoundCardAddr = VAL("&H" + LTRIM$(STR$(200 + (10 * Sel))))
      END IF
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 51: PRINT "  Autodetect  "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 51: PRINT "  210h        "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 51: PRINT "  220h        "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 51: PRINT "  230h        "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 10, 51: PRINT "  240h        "
   IF Sel = 5 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 11, 51: PRINT "  250h        "
   IF Sel = 6 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 12, 51: PRINT "  260h        "
   IF Sel = 7 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 13, 51: PRINT "  270h        "
   IF Sel = 8 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 14, 51: PRINT "  280h        "



LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB SoundCardDMA

PCOPY 0, 2

DrawPanel 49, 3, 66, 13, 2, 15, 1
COLOR 14, 1
LOCATE 4, 53: PRINT "Select DMA"
COLOR 7, 1

SELECT CASE ConfigData.SoundCardDMA
   CASE &HFF: Sel = 0
   CASE 0: Sel = 1
   CASE 1: Sel = 2
   CASE 3: Sel = 3
   CASE 5: Sel = 4
   CASE 6: Sel = 5
   CASE 7: Sel = 6
END SELECT

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 6
   IF Sel > 6 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 0: ConfigData.SoundCardDMA = &HFF
         CASE 1: ConfigData.SoundCardDMA = 0
         CASE 2: ConfigData.SoundCardDMA = 1
         CASE 3: ConfigData.SoundCardDMA = 3
         CASE 4: ConfigData.SoundCardDMA = 5
         CASE 5: ConfigData.SoundCardDMA = 6
         CASE 6: ConfigData.SoundCardDMA = 7
      END SELECT

      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 51: PRINT "  Autodetect  "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 51: PRINT "  DMA 0       "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 51: PRINT "  DMA 1       "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 51: PRINT "  DMA 3       "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 10, 51: PRINT "  DMA 5       "
   IF Sel = 5 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 11, 51: PRINT "  DMA 6       "
   IF Sel = 6 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 12, 51: PRINT "  DMA 7       "


LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB SoundCardIRQ

PCOPY 0, 2

DrawPanel 49, 3, 66, 14, 2, 15, 1
COLOR 14, 1
LOCATE 4, 53: PRINT "Select IRQ"
COLOR 7, 1

SELECT CASE ConfigData.SoundCardIRQ
   CASE &HFF: Sel = 0
   CASE 2: Sel = 1
   CASE 5: Sel = 2
   CASE 7: Sel = 3
   CASE 10: Sel = 4
   CASE 11: Sel = 5
   CASE 12: Sel = 6
   CASE 15: Sel = 7
END SELECT

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 7
   IF Sel > 7 THEN Sel = 0

   IF Press$ = CHR$(13) THEN

      SELECT CASE Sel
         CASE 0: ConfigData.SoundCardIRQ = &HFF
         CASE 1: ConfigData.SoundCardIRQ = 2
         CASE 2: ConfigData.SoundCardIRQ = 5
         CASE 3: ConfigData.SoundCardIRQ = 7
         CASE 4: ConfigData.SoundCardIRQ = 10
         CASE 5: ConfigData.SoundCardIRQ = 11
         CASE 6: ConfigData.SoundCardIRQ = 12
         CASE 7: ConfigData.SoundCardIRQ = 15
      END SELECT

      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 51: PRINT "  Autodetect  "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 51: PRINT "  IRQ 2       "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 51: PRINT "  IRQ 5       "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 51: PRINT "  IRQ 7       "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 10, 51: PRINT "  IRQ 10      "
   IF Sel = 5 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 11, 51: PRINT "  IRQ 11      "
   IF Sel = 6 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 12, 51: PRINT "  IRQ 12      "
   IF Sel = 7 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 13, 51: PRINT "  IRQ 15      "


LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB SoundCardType

PCOPY 0, 2

DrawPanel 49, 3, 74, 13, 2, 15, 1
COLOR 14, 1
LOCATE 4, 51: PRINT "Select Sound Card Type"
COLOR 7, 1

Sel = ConfigData.SoundCardType
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 6
   IF Sel > 6 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      ConfigData.SoundCardType = Sel
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 51: PRINT "  No sound card       "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 51: PRINT "  Sound Blaster 1.x   "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 51: PRINT "  Sound Blaster 2.x   "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 51: PRINT "  Sound Blaster Pro   "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 10, 51: PRINT "  Sound Blaster 16    "
   IF Sel = 5 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 11, 51: PRINT "  Gravis Ultrasound   "
   IF Sel = 6 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 12, 51: PRINT "  Pro Audio Spectrum  "

LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB SoundQuality

PCOPY 0, 2

DrawPanel 49, 3, 74, 10, 2, 15, 1
COLOR 14, 1
LOCATE 4, 55: PRINT "Select Quality"
COLOR 7, 1

Sel = ConfigData.SoundQuality

DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 0 THEN Sel = 3
   IF Sel > 3 THEN Sel = 0

   IF Press$ = CHR$(13) THEN
      ConfigData.SoundQuality = Sel
      EXIT DO
   END IF

   IF Sel = 0 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 51: PRINT "  Low quality         "
   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 7, 51: PRINT "  Medium quality      "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 8, 51: PRINT "  High quality        "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 9, 51: PRINT "  Super-High Quality  "


LOOP UNTIL Press$ = CHR$(27)

PCOPY 2, 0

END SUB

SUB SoundSettings

PCOPY 0, 1

DrawPanel 24, 3, 49, 13, 2, 15, 1
COLOR 14, 1
LOCATE 4, 30: PRINT "Sound Settings"
COLOR 7, 1

Sel = 1
DO
   Press$ = UCASE$(INKEY$)

   IF Press$ = CHR$(0) + "H" THEN Sel = Sel - 1
   IF Press$ = CHR$(0) + "P" THEN Sel = Sel + 1

   IF Sel < 1 THEN Sel = 7
   IF Sel > 7 THEN Sel = 1

   IF Press$ = CHR$(13) THEN
      SELECT CASE Sel
         CASE 1: SoundCardType
         CASE 2: IF ConfigData.SoundCardType THEN SoundCardAddr
         CASE 3: IF ConfigData.SoundCardType THEN SoundCardIRQ
         CASE 4: IF ConfigData.SoundCardType THEN SoundCardDMA
         CASE 5: IF ConfigData.SoundCardType THEN SoundQuality
         CASE 6: IF ConfigData.SoundCardType THEN SoundTest
         CASE 7: EXIT DO
      END SELECT
   END IF

   IF Sel = 1 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 6, 26: PRINT "  Sound card type     "
   IF Sel = 2 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.SoundCardType = 0 THEN COLOR 8
   LOCATE 7, 26: PRINT "  Sound card address  "
   IF Sel = 3 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.SoundCardType = 0 THEN COLOR 8
   LOCATE 8, 26: PRINT "  Sound card IRQ      "
   IF Sel = 4 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.SoundCardType = 0 THEN COLOR 8
   LOCATE 9, 26: PRINT "  Sound card DMA      "
   IF Sel = 5 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.SoundCardType = 0 THEN COLOR 8
   LOCATE 10, 26: PRINT "  Sound quality       "
   IF Sel = 6 THEN COLOR 15, 7 ELSE COLOR 7, 1
   IF ConfigData.SoundCardType = 0 THEN COLOR 8
   LOCATE 11, 26: PRINT "  Test sound card     "
   IF Sel = 7 THEN COLOR 15, 7 ELSE COLOR 7, 1
   LOCATE 12, 26: PRINT "  Exit                "

LOOP UNTIL Press$ = CHR$(27)

PCOPY 1, 0

END SUB

SUB SoundTest

PCOPY 0, 2

DIM ModHead AS GDMheader
DIM CardOffs AS LONG
DIM VUval(1 TO 4)

Freemem& = FRE(-1) - 80000
A& = SETMEM(-Freemem&)

SELECT CASE ConfigData.SoundCardType
   CASE 1: CardOffs = oSB1X.MSE
   CASE 2: CardOffs = oSB2X.MSE
   CASE 3: CardOffs = oSBPRO.MSE
   CASE 4: CardOffs = oSB16.MSE
   CASE 5: CardOffs = oGUS.MSE
   CASE 6: CardOffs = oPAS.MSE
END SELECT


SELECT CASE ConfigData.SoundQuality
   CASE 0: Ov = 8
   CASE 1: Ov = 16
   CASE 2: Ov = 22
   CASE 3: Ov = 45
END SELECT


DrawDialog "Initializing...", 7, 15, 1

CardAddr = ConfigData.SoundCardAddr
CardIRQ = ConfigData.SoundCardIRQ
CardDMA = ConfigData.SoundCardDMA
Result = LoadMSE("SPACEWRZ.DAT", CardOffs - 1, Ov, 4096, CardAddr, CardIRQ, CardDMA)

IF Result THEN
   PCOPY 2, 0
   SELECT CASE Result
      CASE 1: DrawDialog "Failed to autodetect sound card address", 15, 15, 4
      CASE 2: DrawDialog "Failed to autodetect sound card IRQ", 15, 15, 4
      CASE 3: DrawDialog "Failed to autodetect sound card DMA", 15, 15, 4
      CASE 4: DrawDialog "Specified DMA channel is not supported", 15, 15, 4
      CASE 6: DrawDialog "The sound card is not responding", 15, 15, 4
      CASE 7: DrawDialog "Memory control blocks are destroyed", 15, 15, 4
      CASE 8: DrawDialog "Insufficient memory for the mixing buffers", 15, 15, 4
      CASE 9: DrawDialog "Insufficient memory for the MSE driver", 15, 15, 4
      CASE 10: DrawDialog "A MSE driver file might be corrupt", 15, 15, 4
      CASE 11: DrawDialog "Failed to load the MSE driver", 15, 15, 4
      CASE 12: DrawDialog "MVSOUND.SYS not loaded (required for PAS sound cards)", 15, 15, 4
      CASE ELSE: DrawDialog "Unknown error: #" + LTRIM$(STR$(Crap)), 15, 15, 4
   END SELECT
   WHILE INKEY$ = "": WEND
   PCOPY 2, 0
   EXIT SUB
END IF

PCOPY 2, 0
DrawDialog "Loading module...", 7, 15, 1

EMSpresent = EmsExist

IF EMSpresent = 0 THEN
   PCOPY 2, 0
   DrawDialog "EMS memory is required to test the sound engine", 15, 15, 4
   FreeMSE
   WHILE INKEY$ = "": WEND
   PCOPY 2, 0
   EXIT SUB
END IF


OPEN "SPACEWRZ.DAT" FOR BINARY AS #1
LoadGDM FILEATTR(1, 2), oTGETSOFF.GDM - 1, Crap, VARSEG(ModHead), VARPTR(ModHead)
CLOSE #1

IF Crap THEN
   PCOPY 2, 0
   SELECT CASE Crap
      CASE 1: DrawDialog "Module file is corrupt", 15, 15, 4
      CASE 2: DrawDialog "Could not autodetect module type", 15, 15, 4
      CASE 3: DrawDialog "Bad format ID", 15, 15, 4
      CASE 4: DrawDialog "Out of memory", 15, 15, 4
      CASE 5: DrawDialog "Cannot unpack samples", 15, 15, 4
      CASE 6: DrawDialog "Adlib samples not supported", 15, 15, 4
      CASE ELSE: DrawDialog "Unknown module error: #" + LTRIM$(STR$(Crap)), 15, 15, 4
   END SELECT
   FreeMSE
   WHILE INKEY$ = "": WEND
   PCOPY 2, 0
   EXIT SUB
END IF


FOR S = 1 TO 32
   IF ASC(MID$(ModHead.PanMap, S, 1)) <> &HFF THEN
      NumChannels = NumChannels + 1
   END IF
NEXT S

OverRate& = StartOutput(NumChannels, 0)

DO

   OldTime& = CLNG(TIMER): DO UNTIL (CLNG(TIMER) - OldTime&) >= 1: LOOP

   PCOPY 2, 0
   DrawDialog "Playing sound from the center...", 7, 15, 1
   PlaySample 1, 12, 11025, 63, 8
   OldTime& = CLNG(TIMER): DO UNTIL (CLNG(TIMER) - OldTime&) >= 2: LOOP

   PCOPY 2, 0
   DrawDialog "Playing sound from the left...", 7, 15, 1
   PlaySample 1, 12, 11025, 63, 0
   OldTime& = CLNG(TIMER): DO UNTIL (CLNG(TIMER) - OldTime&) >= 2: LOOP

   PCOPY 2, 0
   DrawDialog "Playing sound from the right...", 7, 15, 1
   PlaySample 1, 12, 11025, 63, 15
   OldTime& = CLNG(TIMER): DO UNTIL (CLNG(TIMER) - OldTime&) >= 2: LOOP

   PCOPY 2, 0
   DrawDialog "Play stereo test again? <Y/N>", 7, 15, 1

   DO
      Press$ = UCASE$(INKEY$)
   LOOP UNTIL Press$ = "Y" OR Press$ = "N"

LOOP UNTIL Press$ = "N"

PCOPY 2, 0
DrawPanel 5, 14, 76, 22, 2, 0, 7
CenterPrint "Music test...Press any key to stop", 15

LOCATE 17, 7: PRINT "[";
LOCATE 17, 74: PRINT "]";
FOR P = 8 TO 73
   LOCATE 17, P: PRINT "";
NEXT P


TotalRows = 64 * ASC(ModHead.NOO)


StartMusic
WHILE INKEY$ = ""

   CurOrder = MusicOrder(&HFF)
   CurPattern = MusicPattern(&HFF)
   CurRow = MusicRow

   FOR C = 1 TO 4
      NewVUVal = ChannelVU(C, ChannelVU(C, &HFF) - 1)
      VUval(C) = NewVUVal
      IF VUval(C) < 0 THEN VUval(C) = 0
   NEXT C

   CurrentRows = (64 * CurOrder) + CurRow
   OldProgVal = ProgVal
   ProgVal = 63 * (CurrentRows / TotalRows)


   WAIT &H3DA, 8
   WAIT &H3DA, 8, 8

   COLOR 0, 7
   LOCATE 18, 40: PRINT "Ch1 " + STRING$(31, "");
   COLOR 14, 7
   LOCATE 18, 44: PRINT STRING$(VUval(1), "");
   COLOR 0, 7
   LOCATE 19, 40: PRINT "Ch2 " + STRING$(31, "");
   COLOR 14, 7
   LOCATE 19, 44: PRINT STRING$(VUval(2), "");
   COLOR 0, 7
   LOCATE 20, 40: PRINT "Ch3 " + STRING$(31, "");
   COLOR 14, 7
   LOCATE 20, 44: PRINT STRING$(VUval(3), "");
   COLOR 0, 7
   LOCATE 21, 40: PRINT "Ch4 " + STRING$(31, "");
   COLOR 14, 7
   LOCATE 21, 44: PRINT STRING$(VUval(4), "");

   COLOR 0, 7
   LOCATE 18, 7: PRINT "Order:"; CurOrder
   LOCATE 18, 18: PRINT "Pattern:"; CurPattern
   LOCATE 18, 31: PRINT "Row:"; CurRow

   LOCATE 17, 8 + ProgVal: PRINT CHR$(16);
   IF ProgVal <> OldProgVal THEN LOCATE 17, 8 + OldProgVal: PRINT "";

WEND

StopMusic
StopOutput
UnloadModule
FreeMSE

A& = SETMEM(Freemem& + 2000)

PCOPY 2, 0


END SUB

