' Run COMPILE.BAT to compile

' There isn't much comments in this source because I'm lazy so sorry for that

DECLARE SUB DoPlayerInputs ()
DECLARE SUB DrawLifeBars ()
DECLARE SUB DoMissiles ()
DECLARE SUB DoBullets ()
DECLARE SUB PlayGDM (GDMfile$, Offs AS LONG)
DECLARE SUB DottedLine (x1%, y1%, x2%, y2%, DotVal%, col%)
DECLARE SUB SndInit ()
DECLARE SUB SndClose ()
DECLARE SUB ParticlizeObject (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Speed%, Angle AS SINGLE, Duration%, ObjectVerts() AS ANY, ObjectTris() AS ANY)
DECLARE SUB PutParticle (x AS SINGLE, y AS SINGLE, xMove AS SINGLE, yMove AS SINGLE, Speed AS SINGLE, Angle AS SINGLE, Duration%, col%)
DECLARE SUB Init ()
DECLARE SUB Main ()
DECLARE SUB DoMenu ()

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'SPACEWRZ.BI'
'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$INCLUDE: 'VECTZ.BI'

' Other constants
CONST PAD.DEFAULTADDR = &H378
'$INCLUDE: 'SPACEDAT.BI'

' For stars
TYPE StarType
	x AS INTEGER
	y AS INTEGER
   col AS INTEGER            
	ColDir AS INTEGER
END TYPE


' Common vartypes and vars
'$INCLUDE: 'DOENTS.BI'

' For BWSB
DIM SHARED ModHead AS GDMHeader


' For graphics stuff
DIM SHARED MicroFont AS STRING * 2305
DIM SHARED NumKillsToWin

' Object arrays
REDIM SHARED TitleV(1 TO 1) AS VertType, TitleT(1 TO 1) AS TriType
REDIM SHARED BulletV(1 TO 1) AS VertType, BulletT(1 TO 1) AS TriType
REDIM SHARED MissileV(1 TO 1) AS VertType, MissileT(1 TO 1) AS TriType
REDIM SHARED PMissileV(1 TO 1) AS VertType, PMissileT(1 TO 1) AS TriType
REDIM SHARED CoolShipV(1 TO 1) AS VertType, CoolShipT(1 TO 1) AS TriType
REDIM SHARED CrapShipV(1 TO 1) AS VertType, CrapShipT(1 TO 1) AS TriType
REDIM SHARED FighterShipV(1 TO 1) AS VertType, FighterShipT(1 TO 1) AS TriType
REDIM SHARED GoldShipV(1 TO 1) AS VertType, GoldShipT(1 TO 1) AS TriType


Init

'PlayGDM "STARDUST.GDM", 1
PlayGDM "SPACEWRZ.DAT", oSTARDUST.GDM

DoLogo
DO
   DoMenu
   'PlayGDM "TGETSOFF.GDM", 1
   PlayGDM "SPACEWRZ.DAT", oTGETSOFF.GDM
   Main
   'PlayGDM "STARDUST.GDM", 1
   PlayGDM "SPACEWRZ.DAT", oSTARDUST.GDM
LOOP


'===========================================================================\
REM $STATIC
SUB DoMenu

DIM StarAngle AS SINGLE
DIM ScaleVal AS SINGLE

DIM TitleZ AS SINGLE
DIM TitleTil AS SINGLE
DIM TitlePan AS SINGLE
DIM TitleRol AS SINGLE
DIM BlankPlayerVar AS PlayerType

DIM ButtonHeld(1 TO 4, 1 TO 3)
DIM PlayerReady(1 TO 4)

Camera.Scale = 100
Camera.x = 0
Camera.y = 0

FOR P = 1 TO 4
   Player(P) = BlankPlayerVar
   Player(P).ShipType = 1
NEXT

TitleZ = 160
TitleTil = 0
SpawnStars = TRUE

DO
   IF ConfigData.InputDevice = 1 THEN
      PAD.GetButtonStats
   ELSE

      ' Player 1 keyboard map
      PAD.ButtonStatus(1, PAD.B) = DQBkey(&H11) OR DQBkey(&H21)
      PAD.ButtonStatus(1, PAD.LEFT) = DQBkey(&H1E)
      PAD.ButtonStatus(1, PAD.RIGHT) = DQBkey(&H20)

      ' Player 2 keyboard map
      PAD.ButtonStatus(2, PAD.B) = DQBkey(KEYUP) OR DQBkey(&H52)
      PAD.ButtonStatus(2, PAD.LEFT) = DQBkey(KEYLEFT)
      PAD.ButtonStatus(2, PAD.RIGHT) = DQBkey(KEYRIGHT)

   END IF


   DoStars StarAngle, SpawnStars, StarsPresent

   OldButtonPressed = ButtonPressed
   ButtonPressed = FALSE
   FOR S = 1 TO 12
      IF PAD.ButtonStatus(1, S) THEN ButtonPressed = TRUE
   NEXT S

   IF OldButtonPressed = FALSE AND ButtonPressed THEN
      IF TitleShow = FALSE THEN
         TitleShow = TRUE
         TitleStep = 110
         TitleTil = 0
         Flash = 63         
      END IF
   END IF

	' Show epic (sort of) title
	IF TitleShow = FALSE THEN
      IF SOUNDON THEN
			IF MusicRow > 48 THEN TitleShow = TRUE
		ELSE
			TitleShow = TRUE
		END IF
	END IF


	IF TitleShow THEN

		' Note: Start screen-saver mode in order 18
      IF SOUNDON THEN
         IF MusicOrder(&HFF) = 18 AND MusicRow = 0 THEN
            IF ShowMenu = 1 THEN ScreenSave = TRUE
         END IF
      END IF

		IF TitleStep < 110 THEN

			TitleZ = 160 + (700 - (700 * (TitleStep / 110)))
			TitleTil = 360 * (TitleStep / 110)

			IF TitleStep = 109 THEN Flash = 63: TitleTil = 0
			TitleStep = TitleStep + 1

		ELSE

			IF ScreenSave THEN
				TitlePan = (INT(TitlePan) + 1) MOD 360
				TitleTil = (INT(TitleTil) + 1) MOD 360
				TitleRol = (INT(TitleRol) + 1) MOD 360
			ELSE
				TitlePan = TitlePan - (TitlePan / 16)
				TitleTil = TitleTil - (TitleTil / 16)
				TitleRol = TitleRol - (TitleRol / 16)
			END IF

		END IF

      IF ShowMenu < 3 THEN
         ColDown = 16 - (16 * (TitleStep / 110))
         RenderObject3Dgamma 0, 0, TitleZ, TitlePan, 45 - TitleTil, TitleRol, ColDown, TitleV(), TitleT()
      END IF

      IF TitleStep = 110 AND Flash = 0 and ShowMenu = 0 THEN ShowMenu = 1

	END IF


   SELECT CASE ShowMenu
      CASE 1
         DQBprint 1, "Press any button to begin", CENTERED, 160, 15         

         IF OldButtonPressed = FALSE AND ButtonPressed THEN
            IF ScreenSave = FALSE THEN
               ShowMenu = 2
            ELSE
               ScreenSave = FALSE
            END IF
         END IF

      CASE 2
         TitleZ = TitleZ - 2
         IF TitleZ < -10 THEN ShowMenu = 3

      CASE 3
         IF Ma < 90 THEN Ma = Ma + 1

      CASE 4
         IF Ma > 0 THEN Ma = Ma - 1

         IF FadeVal < 64 AND (Ta MOD 2) = 0 THEN
            FOR C = 1 TO 4
               Crap = MusicVolume(64 - FadeVal)
            NEXT C
            FadeVal = FadeVal + 1
         END IF

         SpawnStars = FALSE
         IF StarsPresent = 0 THEN EXIT DO

   END SELECT

   IF ShowMenu >= 3 AND ShowMenu <= 4 AND Ma > 0 THEN
      
      V = 299 * SIN(Ma * ROTPI)

      PlayersReady = 0
      FOR P = 1 TO NumPlayers

         By = 1 + (51 * (P - 1))

         IF Ma < 90 THEN
            SELECT CASE ((P - 1) MOD 2)
               CASE 0
                  DQBsetClipBox 10, By, 10 + V, By + 44
                  RELboxTransF 1, 10, By, 10 + V, By + 44, 79
                  IF (10 + V) >= 11 THEN
                     IF (10 + V) < 51 THEN
                        RELboxTransF 1, 11, By + 7, 10 + V, By + 43, 53
                     ELSE
                        RELboxTransF 1, 11, By + 7, 51, By + 43, 53
                     END IF                        
                  END IF

               CASE 1
                  DQBsetClipBox 309 - V, By, 309, By + 44
                  RELboxTransF 1, 309 - V, By, 309, By + 44, 79
                  IF (309 - V) >= 12 AND (309 - V) <= 51 THEN
                     RELboxTransF 1, (309 - V), By + 7, 51, By + 43, 53
                  ELSE
                     IF (309 - V) <= 51 THEN RELboxTransF 1, 11, By + 7, 51, By + 43, 53
                  END IF

            END SELECT

         ELSE

            RELboxTransF 1, 10, By, 309, By + 44, 79
            RELboxTransF 1, 11, By + 7, 51, By + 43, 53

         END IF

         SELECT CASE Player(P).ShipType
            CASE 1
               ShipName$ = "Empire class balanced fighter"
               ShipAccel$ = "Normal"
               ShipHandling$ = "Normal"
               ShipShield$ = "Normal"
               ShipBlasters = 1
               ShipSpecial$ = "2 Homing Missiles"

            CASE 2
               ShipName$ = "Derpinian class interceptor"
               ShipAccel$ = "Slow"
               ShipHandling$ = "Poor"
               ShipShield$ = "Tough"
               ShipBlasters = 2
               ShipSpecial$ = "2 Power Missiles"

            CASE 3
               ShipName$ = "Federal class starfighter"
               ShipAccel$ = "Fast"
               ShipHandling$ = "Tight"
               ShipShield$ = "Weak"
               ShipBlasters = 3
               ShipSpecial$ = "4 Homing Missiles"

            CASE 4
               ShipName$ = "Crystal class starfighter"
               ShipAccel$ = "Normal"
               ShipHandling$ = "Tight"
               ShipShield$ = "Normal"
               ShipBlasters = 2
               ShipSpecial$ = "4 Power Missiles"

         END SELECT

         DQBprint 1, ShipName$, 53, By + 9, 15
         DQBprint 1, "Acceleration: " + ShipAccel$, 53, By + 15, 15
         DQBprint 1, "Handling:     " + ShipHandling$, 53, By + 21, 15
         DQBprint 1, "Shield:       " + ShipShield$, 53, By + 27, 15
         DQBprint 1, "Blasters:     " + LTRIM$(STR$(ShipBlasters)), 53, By + 33, 15
         DQBprint 1, "Special:      " + ShipSpecial$, 53, By + 39, 15

         Txt$ = "Player " + LTRIM$(STR$(P)) + " - "
         IF PlayerReady(P) THEN
            IF ((Ta \ 16) MOD 2) = 0 THEN Txt$ = Txt$ + "READY!"
            PlayersReady = PlayersReady + 1
         ELSE
            Txt$ = Txt$ + "select your ship"
         END IF

         DQBprint 1, Txt$, 11, By + 1, 15

         SELECT CASE Player(P).ShipType
            CASE 1: RenderObject (10 + 20) - CENTERX, (By + 25) - CENTERY, CSNG(TTa), 20, CoolShipV(), CoolShipT()
            CASE 2: RenderObject (10 + 20) - CENTERX, (By + 25) - CENTERY, CSNG(TTa), 20, CrapShipV(), CrapShipT()
            CASE 3: RenderObject (10 + 20) - CENTERX, (By + 25) - CENTERY, CSNG(TTa), 20, FighterShipV(), FighterShipT()
            CASE 4: RenderObject (10 + 20) - CENTERX, (By + 25) - CENTERY, CSNG(TTa), 20, GoldShipV(), GoldShipT()
         END SELECT

         IF PlayerReady(P) = FALSE THEN

            IF PAD.ButtonStatus(P, PAD.RIGHT) THEN                                    
               IF ButtonHeld(P, 1) = FALSE AND Player(P).ShipType < 4 THEN Player(P).ShipType = Player(P).ShipType + 1
               ButtonHeld(P, 1) = TRUE                  
            ELSE
               ButtonHeld(P, 1) = FALSE
            END IF

            IF PAD.ButtonStatus(P, PAD.LEFT) THEN                                    
               IF ButtonHeld(P, 2) = FALSE AND Player(P).ShipType > 1 THEN Player(P).ShipType = Player(P).ShipType - 1
               ButtonHeld(P, 2) = TRUE
            ELSE
               ButtonHeld(P, 2) = FALSE
            END IF

            IF PAD.ButtonStatus(P, PAD.B) THEN
               PlayerReady(P) = TRUE
               ButtonHeld(P, 3) = TRUE
            ELSE
               ButtonHeld(P, 3) = FALSE
            END IF

         END IF
   
      NEXT P
      DQBsetClipBox 0, 0, 319, 199
      
      IF PlayersReady = NumPlayers THEN
         IF ShowMenu = 3 THEN

            DQBprint 1, "Race to:", CENTERED, 97, 15
            IF NumKillsToWin = 0 THEN
               DQBprint 1, CHR$(17) + " unlimited kills " + CHR$(16), CENTERED, 103, 15
            ELSE
               IF NumKillsToWin = 1 THEN
                  DQBprint 1, CHR$(17) + " " + LTRIM$(STR$(NumKillsToWin)) + " kill " + CHR$(16), CENTERED, 103, 15
               ELSE
                  DQBprint 1, CHR$(17) + " " + LTRIM$(STR$(NumKillsToWin)) + " kills " + CHR$(16), CENTERED, 103, 15
               END IF
            END IF
      
            IF PAD.ButtonStatus(1, PAD.LEFT) THEN
               IF ButtonHeld(1, 1) = FALSE AND NumKillsToWin > 0 THEN NumKillsToWin = NumKillsToWin - 1
               ButtonHeld(1, 1) = TRUE
            ELSE
               ButtonHeld(1, 1) = FALSE
            END IF

            IF PAD.ButtonStatus(1, PAD.RIGHT) THEN
               IF ButtonHeld(1, 2) = FALSE AND NumKillsToWin < 100 THEN NumKillsToWin = NumKillsToWin + 1
               ButtonHeld(1, 2) = TRUE
            ELSE
               ButtonHeld(1, 2) = FALSE
            END IF

            IF PAD.ButtonStatus(1, PAD.B) THEN
               IF ButtonHeld(1, 3) = FALSE THEN ShowMenu = 4
               ButtonHeld(1, 3) = TRUE
            ELSE
               ButtonHeld(1, 3) = FALSE
            END IF

         END IF         
      END IF

   END IF


	' Show menu stuff
   IF ShowMenu = 1 THEN
      IF SoftText < 5 THEN SoftText = SoftText + 1
   ELSE
      IF SoftText > 0 THEN SoftText = SoftText - 1   
   END IF


	IF SoftText THEN
		DQBprint 1, "Version 1.0", 276, 199 - SoftText, 15
		DQBprint 1, "(?) 2013 Meido-Tek Productions", 1, 199 - SoftText, 15
	END IF
  

	' Calculate the colors from all-white to normal
	IF Flash THEN
      CalcSmoothFadeIn 63 - Flash , 63, 63, 63, VARSEG(DefaultPal), VARPTR(DefaultPal), VARSEG(VideoPal), VARPTR(VideoPal)
		Flash = Flash - 1
      IF Flash = 1 THEN VideoPal = DefaultPal
	END IF


   IF DQBkey(KEYESC) THEN QuitGame = TRUE: Sval = 140

   IF QuitGame THEN

      DQBget 1, 0, 0, 319, 199, VARSEG(LogoImage(0)), VARPTR(LogoImage(0))
      DQBclearLayer 1

      ScaleVal = 1 * (Sval / 140)

      Bx = CENTERX - (159 * ScaleVal)
      By = CENTERY - (99 * ScaleVal)
      Bwidth = (319 * ScaleVal)
      Bheight = (199 * ScaleVal)
      
      IF Bwidth > 2 AND Bheight > 2 THEN
         DQBsPut 1, Bx, By, VARSEG(LogoImage(0)), VARPTR(LogoImage(0)), Bwidth, Bheight
      END IF

      IF FadeVal < 64 AND (Sval MOD 2) = 0 THEN
         FOR C = 1 TO 4
            Crap = MusicVolume(64 - FadeVal)
         NEXT C
         FadeVal = FadeVal + 1
      END IF

      CalcSmoothFadeIn 63 * ScaleVal, 0, 0, 0, VARSEG(DefaultPal), VARPTR(DefaultPal), VARSEG(VideoPal), VARPTR(VideoPal)      

      Sval = Sval - 1
      IF Sval = 0 THEN
         SndClose
         DQBclose
         END
      END IF

   END IF

      'FOR z = 100 TO 0 STEP -1
      '   DQBrPut 1, 0, 0, VARSEG(LogoImage(0)), VARPTR(LogoImage(0)), 
      'NEXT z

      'DQBsetPal DefaultPal
      'DQBprint 1, "Exit game? <Y/N>", CENTERED, 98, 15

      'DQBwait 1
      'DQBcopyLayer 1, VIDEO
      'DO

      '   IF DQBkey(&H15) THEN
      '      SndClose
      '      DQBclose
      '      END
      '   END IF
      '   IF DQBkey(&H31) THEN EXIT DO      
      '   DQBwait 1
      'LOOP



	DQBwait 1
   IF Flash OR QuitGame THEN DQBsetPal VideoPal
	DQBcopyLayer 1, VIDEO
	DQBclearLayer 1

	StarAngle = StarAngle + .2
	IF INT(StarAngle) >= 360 THEN StarAngle = StarAngle - 360

	Ta = (Ta + 1) MOD 360
	TTa = (TTa + 4) MOD 360

LOOP 

END SUB


'===========================================================================\
SUB DottedLine (x1, y1, x2, y2, DotVal, col)

r = x2 - x1
A = y2 - y1

IF A = 0 THEN
	FOR x = x1 TO x2 STEP SGN(r) * 4
		IF x1 = x2 THEN EXIT FOR
		DQBpset 1, x, y1, col
	NEXT x
ELSEIF r = 0 THEN
	FOR y = y1 TO y2 STEP SGN(A) * 4
		IF y1 = y2 THEN EXIT FOR
		DQBpset 1, x1, y, col
	NEXT y
ELSE
	IF ABS(r) >= ABS(A) THEN
		S! = A / r
		FOR x = x1 TO x2 STEP SGN(r) * 4
			IF x1 = x2 THEN EXIT FOR
			y = y1 + CINT(S! * (x - x1))
			DQBpset 1, x, y, col
		NEXT x
	ELSE
		S! = r / A
		FOR y = y1 TO y2 STEP SGN(A) * 4
			IF y1 = y2 THEN EXIT FOR
			x = x1 + CINT(S! * (y - y1))
			DQBpset 1, x, y, col
		NEXT y
	END IF
END IF

END SUB


'===========================================================================\
SUB DrawBox (Bx1, By1, Bx2, By2, col)

DQBline 1, Bx1, By1, Bx2, By1, col
DQBline 1, Bx2, By1, Bx2, By2, col
DQBline 1, Bx2, By2, Bx1, By2, col
DQBline 1, Bx1, By2, Bx1, By1, col

END SUB


'===========================================================================\
SUB Init

OPEN "SETUP.DAT" FOR BINARY AS #1
IF LOF(1) THEN
   GET #1, , ConfigData
ELSE
   PRINT "Please run SETUP.EXE before playing the game..."
   END
END IF
CLOSE #1

IF ConfigData.SoundCardType THEN SoundOn = TRUE

IF ConfigData.InputDevice = 1 THEN
   NumPlayers = PAD.Init(ConfigData.LPTportAddr)
   IF ConfigData.NumControllers = 0 THEN

      IF NumPlayers = 0 THEN
         PRINT "No SNES controller on port 1 connected."
         END
      ELSEIF NumPlayers = 1 THEN
         PRINT "There should be at least 2 controllers connected to play."
         END
      END IF

      ' Print how many controllers were found
      PRINT LTRIM$(STR$(NumPlayers)); " controller";
      IF NumPlayers > 1 THEN PRINT "s";
      PRINT " detected."

   ELSE

      ' Override
      NumPlayers = ConfigData.NumControllers

   END IF
ELSE
   NumPlayers = 2
END IF


' Load TSP model files
'LoadTSP "TITLE.TSP", 1, TitleV(), TitleT()
LoadTSP "SPACEWRZ.DAT", oTITLE.TSP, TitleV(), TitleT()

'LoadTSP "BULLET.TSP", 1, BulletV(), BulletT()
LoadTSP "SPACEWRZ.DAT", oBULLET.TSP, BulletV(), BulletT()

'LoadTSP "MISSILE.TSP", 1, MissileV(), MissileT()
LoadTSP "SPACEWRZ.DAT", oMISSILE.TSP, MissileV(), MissileT()

'LoadTSP "PMISSILE.TSP", 1, PMissileV(), PMissileT()
LoadTSP "SPACEWRZ.DAT", oPMISSILE.TSP, PMissileV(), PMissileT()

'LoadTSP "COOLSHIP.TSP", 1, CoolShipV(), CoolShipT()
LoadTSP "SPACEWRZ.DAT", oCOOLSHIP.TSP, CoolShipV(), CoolShipT()

'LoadTSP "CRAPSHIP.TSP", 1, CrapShipV(), CrapShipT()
LoadTSP "SPACEWRZ.DAT", oCRAPSHIP.TSP, CrapShipV(), CrapShipT()

'LoadTSP "FIGHTER.TSP", 1, FighterShipV(), FighterShipT()
LoadTSP "SPACEWRZ.DAT", oFIGHTER.TSP, FighterShipV(), FighterShipT()

'LoadTSP "GOLDSHIP.TSP", 1, GoldShipV(), GoldShipT()
LoadTSP "SPACEWRZ.DAT", oGOLDSHIP.TSP, GoldShipV(), GoldShipT()


' Load palette
'LoadCOL "SPACEPAL.COL", 1, DefaultPal
LoadCOL "SPACEWRZ.DAT", oSPACEPAL.COL, DefaultPal

' Load stuff
LogoImage(0) = 320 * 8
LogoImage(1) = 200
'LoadPCX "MTLOGO.PCX", 1, VARSEG(LogoImage(0)), VARPTR(LogoImage(2)), LogoPal
LoadPCX "SPACEWRZ.DAT", oMTLOGO.PCX, VARSEG(LogoImage(0)), VARPTR(LogoImage(2)), LogoPal

'OPEN "MICRO.FNT" FOR BINARY AS #1: GET #1, , MicroFont: CLOSE #1
OPEN "SPACEWRZ.DAT" FOR BINARY AS #1: GET #1, oMICRO.FNT, MicroFont: CLOSE #1

'============


' BWSB init
SndInit

END SUB


'===========================================================================\
SUB Main

DIM Star(1 TO 256) AS StarType

DIM CamCx AS SINGLE
DIM CamCy AS SINGLE

DIM NewScale AS SINGLE
DIM VortexAttract AS SINGLE

DIM OverallPx AS SINGLE
DIM OverallPy AS SINGLE

MapSize = 2048
VortexAttract = 1

FOR P = 1 TO 256
	Star(P).x = INT(RND * (MapSize * 4)) - (MapSize * 2)
	Star(P).y = INT(RND * (MapSize * 4)) - (MapSize * 2)
	Star(P).col = 16 + INT(RND * 16)
	Star(P).ColDir = INT(RND * 3) - 1
	IF Star(P).ColDir = 0 THEN Star(P).ColDir = 1
NEXT P

Camera.Scale = 100
ScreenSize = 319

' Player start coords
Player(1).x = -512
Player(2).x = 512
Player(3).y = -512
Player(4).y = 512

FOR P = 1 TO NumPlayers
	SELECT CASE Player(P).ShipType
		CASE 1 ' Empire class balanced fighter (COOLSHIP.TSP)
				' Abilities:
				'  Speed: Normal
				'  Handling: Normal
				'  Shields: Normal
				'  Blasters: 1
				'  Homing missiles, Shots: 2
			Player(P).MaxSpecials = 2
			Player(P).MaxHits = 10

		CASE 2 ' Derpinian class interceptor   (CRAPSHIP.TSP)
				' Abilities:
				'  Speed: Slow
				'  Handling: Slow
				'  Shields: High
				'  Blasters: 2
				'  Power missiles, Shots: 2
			Player(P).MaxSpecials = 2
			Player(P).MaxHits = 15

		CASE 3 ' Federal class starfighter     (FIGHTER.TSP)
				' Abilities:
				'  Speed: Fast
				'  Handling: Fast
				'  Shields: Low
				'  Blasters: 3
				'  Homing missiles, Shots: 4
			Player(P).MaxSpecials = 4
			Player(P).MaxHits = 5

		CASE 4 ' Crystal class starfighter     (GOLDSHIP.TSP)
				' Abilities:
				'  Speed: Normal
				'  Handling: Fast
				'  Shields: Normal
            '  Blasters: 2
				'  Power missiles, Shots: 4
			Player(P).MaxSpecials = 4
			Player(P).MaxHits = 10

	END SELECT
   Player(P).Score = 0
NEXT P

ClearStuffs

DO
   
   IF ConfigData.InputDevice = 1 THEN
      PAD.GetButtonStats
   ELSE

      ' Player 1 keyboard map
      PAD.ButtonStatus(1, PAD.B) = DQBkey(&H11)
      PAD.ButtonStatus(1, PAD.X) = DQBkey(&H1F)
      PAD.ButtonStatus(1, PAD.LEFT) = DQBkey(&H1E)
      PAD.ButtonStatus(1, PAD.RIGHT) = DQBkey(&H20)
      PAD.ButtonStatus(1, PAD.Y) = DQBkey(&H21)
      PAD.ButtonStatus(1, PAD.R) = DQBkey(&H22)

      ' Player 2 keyboard map
      PAD.ButtonStatus(2, PAD.B) = DQBkey(KEYUP)
      PAD.ButtonStatus(2, PAD.X) = DQBkey(KEYDOWN)
      PAD.ButtonStatus(2, PAD.LEFT) = DQBkey(KEYLEFT)
      PAD.ButtonStatus(2, PAD.RIGHT) = DQBkey(KEYRIGHT)
      PAD.ButtonStatus(2, PAD.Y) = DQBkey(&H52)
      PAD.ButtonStatus(2, PAD.R) = DQBkey(&H53)

   END IF

	DoPlayerInputs

	' Player physics
	ScaleBx1 = CamCx: ScaleBy1 = CamCy
	ScaleBx2 = CamCx: ScaleBy2 = CamCy
	PlayerDies = FALSE
	FOR P = 1 TO NumPlayers

		Player(P).aMove = Player(P).aMove * .9

      IF NumKillsToWin THEN
         IF Player(P).Score >= NumKillsToWin AND MatchOver = 0 THEN

            FOR B = 1 TO NumPlayers
               IF B <> P AND Player(B).Dead = 0 THEN
                  Player(B).HitBy = P
                  Player(B).HitsTaken = Player(B).MaxHits + 1
               END IF
            NEXT B

            MatchOver = P
         END IF
      END IF

		IF Player(P).Dead = 0 THEN

			' Move the players according to their velocities
			Player(P).x = Player(P).x + Player(P).xMove
			Player(P).y = Player(P).y + Player(P).yMove
			Player(P).Angle = Player(P).Angle + Player(P).aMove

			' Add a extra missile every 30 seconds
			IF Player(P).SpecialsUsed THEN
				Player(P).NextSpecialCount = Player(P).NextSpecialCount + 1
				IF Player(P).NextSpecialCount > 2100 THEN
					Player(P).SpecialsUsed = Player(P).SpecialsUsed - 1
					Player(P).NextSpecialCount = 0
				END IF
			END IF

		END IF

		' Death sequence
		IF Player(P).HitsTaken > Player(P).MaxHits AND Player(P).Dead = 0 THEN

			FOR A = 1 TO 50
            PutParticle Player(P).x, Player(P).y, 0, 0, (RND * 8), (RND * 360), 140 - (RND * 70), 31
			NEXT A

			SELECT CASE Player(P).ShipType
            CASE 1: ParticlizeObject Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, 2, Player(P).Angle, 280, CoolShipV(), CoolShipT()
            CASE 2: ParticlizeObject Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, 2, Player(P).Angle, 280, CrapShipV(), CrapShipT()
            CASE 3: ParticlizeObject Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, 2, Player(P).Angle, 280, FighterShipV(), FighterShipT()
            CASE 4: ParticlizeObject Player(P).x, Player(P).y, Player(P).xMove, Player(P).yMove, 2, Player(P).Angle, 280, GoldShipV(), GoldShipT()
			END SELECT

			IF SOUNDON THEN
				Freq = 4000 + (INT(RND * 1000) - 500)
				PlaySample 5 + (P - 1), 12, CLNG(Freq), 64, 8
			END IF

         IF MatchOver = 0 THEN Player(Player(P).HitBy).Score = Player(Player(P).HitBy).Score + 1
			Player(P).Dead = 280
			PlayerDies = TRUE
		END IF

		' Respawn
		IF Player(P).Dead THEN
         IF MatchOver = 0 THEN Player(P).Dead = Player(P).Dead - 1
			IF Player(P).Dead = 0 THEN

				Player(P).x = (RND * (MapSize * 2)) - MapSize
				Player(P).y = (RND * (MapSize * 2)) - MapSize
				Player(P).xMove = 0
				Player(P).yMove = 0
				Player(P).Angle = 0
				Player(P).HitsTaken = 0
            Player(P).SpecialState = 0
				Player(P).SpecialsUsed = 0
				Player(P).NextSpecialCount = 0

			END IF
		END IF

		IF Player(P).x < -MapSize THEN Player(P).x = -MapSize: Player(P).xMove = -(Player(P).xMove / 4)
		IF Player(P).y < -MapSize THEN Player(P).y = -MapSize: Player(P).yMove = -(Player(P).yMove / 4)
		IF Player(P).x > MapSize THEN Player(P).x = MapSize: Player(P).xMove = -(Player(P).xMove / 4)
		IF Player(P).y > MapSize THEN Player(P).y = MapSize: Player(P).yMove = -(Player(P).yMove / 4)

		' Calculate how far apart the ships are in the screen
		IF ScaleBx1 < Player(P).x THEN ScaleBx1 = Player(P).x
		IF ScaleBx2 > Player(P).x THEN ScaleBx2 = Player(P).x
		IF ScaleBy1 < Player(P).y THEN ScaleBy1 = Player(P).y
		IF ScaleBy2 > Player(P).y THEN ScaleBy2 = Player(P).y

	NEXT P


   IF MatchOver = 0 THEN

      CamCx = (ScaleBx1 + ScaleBx2) / 2
      CamCy = (ScaleBy1 + ScaleBy2) / 2
      IF ScaleBx1 > ScaleBx2 THEN SWAP ScaleBx1, ScaleBx2
      IF ScaleBy1 > ScaleBy2 THEN SWAP ScaleBy1, ScaleBy2

      NewScaleX = ABS(ScaleBx2 - ScaleBx1)
      NewScaleY = ABS(ScaleBy2 - ScaleBy1)

      NewScale = 0
      IF NewScaleX > NewScale THEN NewScale = NewScaleX
      IF NewScaleY > NewScale THEN NewScale = NewScaleY

      IF NewScale < 0 THEN NewScale = 0

      Camera.Scale = Camera.Scale + (((100 * (160 / (160 + NewScale))) - Camera.Scale) / 16)
      Camera.x = Camera.x + ((CamCx - Camera.x) / 16)
      Camera.y = Camera.y + ((CamCy - Camera.y) / 16)

   ELSE

      Camera.Scale = Camera.Scale + ((50 - Camera.Scale) / 64)
      Camera.x = Camera.x + ((Player(MatchOver).x - Camera.x) / 16)
      Camera.y = Camera.y + ((Player(MatchOver).y - Camera.y) / 16)

   END IF



	' Draw stars
	CamScale = (100 - (100 - Camera.Scale)) / 100
	FOR P = 1 TO 256

		Sx = CENTERX + ((Star(P).x - Camera.x) * CamScale)
		Sy = CENTERY + ((Star(P).y - Camera.y) * CamScale)

		DQBpset 1, Sx, Sy, Star(P).col
		IF Count THEN
			IF Star(P).col = 16 THEN Star(P).ColDir = 1
			IF Star(P).col = 31 THEN Star(P).ColDir = -1
			Star(P).col = Star(P).col + Star(P).ColDir
		END IF

	NEXT P
	CountVal = CountVal + 1
	IF CountVal = 8 THEN Count = TRUE: CountVal = 0 ELSE Count = FALSE


	' Do particle effects
	DoParticles
	DoTriParticles

	' Do bullets and missiles
	DoBullets
	DoMissiles


	' Draw player ships
	FOR P = 1 TO NumPlayers

		' Lock-on system
		SELECT CASE Player(P).ShipType
			CASE 1, 3
            IF Player(P).SpecialState AND Player(P).Dead = 0 THEN

					Sx = CENTERX + ((Player(P).x - Camera.x) * CamScale)
					Sy = CENTERY + ((Player(P).y - Camera.y) * CamScale)

					LineLength = 1024 * CamScale
					DottedLine Sx, Sy, Sx + (LineLength * SIN(Player(P).Angle * ROTPI)), Sy - (LineLength * COS(Player(P).Angle * ROTPI)), dVal, 15

					Sx = 1024 * SIN(Player(P).Angle * ROTPI)
					Sy = -1024 * COS(Player(P).Angle * ROTPI)

					LockTo = ScanLine(P, CINT(Player(P).x), CINT(Player(P).y), CINT(Player(P).x + Sx), CINT(Player(P).y + Sy))
					IF LockTo THEN
						IF Player(LockTo).Dead = 0 THEN
							IF Player(P).LockOnTo <> LockTo THEN
								IF SOUNDON THEN PlaySample 5 + (P - 1), 15, 11025, 64, 8
							END IF
							Player(P).LockOnTo = LockTo
						END IF
					END IF
					IF Player(P).LockOnTo THEN
						IF Player(Player(P).LockOnTo).Dead THEN Player(P).LockOnTo = 0
					END IF

				END IF
		END SELECT

		IF Player(P).Dead = 0 THEN
			SELECT CASE Player(P).ShipType
				CASE 1: RenderObject Player(P).x, Player(P).y, Player(P).Angle, 100, CoolShipV(), CoolShipT()
				CASE 2: RenderObject Player(P).x, Player(P).y, Player(P).Angle, 100, CrapShipV(), CrapShipT()
				CASE 3: RenderObject Player(P).x, Player(P).y, Player(P).Angle, 100, FighterShipV(), FighterShipT()
				CASE 4: RenderObject Player(P).x, Player(P).y, Player(P).Angle, 100, GoldShipV(), GoldShipT()
			END SELECT

			IF Player(P).LockOnTo THEN
				RenderBox Player(Player(P).LockOnTo).x - 64, Player(Player(P).LockOnTo).y - 64, Player(Player(P).LockOnTo).x + 64, Player(Player(P).LockOnTo).y + 64, 14
			END IF

		END IF

	NEXT P

	RenderBox -MapSize, -MapSize, MapSize, MapSize, 9


   ' Draw life bars and stats
	DrawLifeBars
   IF MatchOver THEN
      DQBprint 1, "Player " + LTRIM$(STR$(MatchOver)) + " wins!", CENTERED, 129, 15
      MatchOverCount = MatchOverCount + 1
      IF MatchOverCount >= 700 AND QuitGame = FALSE THEN QuitGame = TRUE: FadeCount = 1
   END IF
	DQBprint 1, "FPS:" + LTRIM$(STR$(FPS)), 1, 1, 15


   IF DQBkey(KEYESC) AND QuitGame = FALSE THEN QuitGame = TRUE: FadeCount = 1

   IF FadeCount THEN
      IF QuitGame = FALSE THEN
         CalcSmoothFadeIn (63 - FadeCount), 63, 63, 63, VARSEG(DefaultPal), VARPTR(DefaultPal), VARSEG(VideoPal), VARPTR(VideoPal)
         IF FadeCount = 1 THEN VideoPal = DefaultPal
      ELSE
         CalcSmoothFadeIn (63 - FadeCount), 0, 0, 0, VARSEG(DefaultPal), VARPTR(DefaultPal), VARSEG(VideoPal), VARPTR(VideoPal)
      END IF      
   END IF


	DQBwait 1
   IF FadeCount THEN
      DQBsetPal VideoPal
      IF QuitGame = FALSE THEN
         FadeCount = FadeCount - 1
      ELSE
         FadeCount = FadeCount + 1
      END IF
   END IF

	IF PlayerDies THEN
		FOR P = 0 TO 255
			DQBsetCol P, 63, 63, 63
		NEXT P
		FadeCount = 63
	END IF
	DQBcopyLayer 1, VIDEO
	DQBclearLayer 1

	A = (A + 4) MOD 360
	dVal = (dVal + 1) MOD 6

	IF CLNG(TIMER) > OldTIme& THEN
		OldTIme& = CLNG(TIMER)
		FPS = Loops
		Loops = 0
	END IF
	Loops = Loops + 1

   IF FadeCount = 63 AND QuitGame THEN EXIT DO

LOOP 

DQBclearLayer VIDEO

END SUB


'===========================================================================\
SUB PlayGDM (GDMfile$, Offs AS LONG)

STATIC FirstCallDone

IF SOUNDON THEN

	IF FirstCallDone THEN
		StopMusic
		StopOutput
		UnloadModule
	END IF

	Crap = EmsExist
	OPEN GDMfile$ FOR BINARY AS #1
	LoadGDM FILEATTR(1, 2), Offs - 1, ErrFlag, VARSEG(ModHead), VARPTR(ModHead)
	CLOSE #1

   IF ErrFlag THEN
      SELECT CASE ErrFlag
         CASE 1: PRINT "Module is corrupt"
         CASE 2: PRINT "Could not autodetect module type"
         CASE 3: PRINT "Bad format ID"
         CASE 4: PRINT "Out of memory"
         CASE 5: PRINT "Cannot unpack samples"
         CASE 6: PRINT "AdLib samples not supported"
         CASE IS >= 7: PRINT "Unknown Load Error:" + STR$(ErrorFlag)
      END SELECT
      END
   END IF

END IF

IF FirstCallDone THEN DQBcloseNoText
IF DQBinit(1, 0, 0) THEN PRINT DQBerror$: SndClose: END
IF FirstCallDone = FALSE THEN DQBfpu

IF SOUNDON THEN
	FOR S = 1 TO 32
		IF ASC(MID$(ModHead.PanMap, S, 1)) <> &HFF THEN
			NumChannels = NumChannels + 1
		END IF
	NEXT S
	OverRate& = StartOutput(NumChannels + 4, 0)
	StartMusic
END IF

IF FirstCallDone = FALSE THEN DQBinitVGA

DQBinstallKeyboard
DQBsetPal DefaultPal
DQBsetFont MicroFont

FirstCallDone = TRUE

END SUB


'===========================================================================\
SUB SndClose

IF SOUNDON THEN
	StopMusic
	StopOutput
	UnloadModule
	FreeMSE
END IF

END SUB


'===========================================================================\
SUB SndInit

DIM CardOffs AS LONG

IF SOUNDON = FALSE THEN EXIT SUB

Freemem& = FRE(-1) - 80000
A& = SETMEM(-Freemem&)

SELECT CASE ConfigData.SoundCardType
   CASE 1: CardOffs = oSB1X.MSE 
   CASE 2: CardOffs = oSB2X.MSE
   CASE 3: CardOffs = oSBPRO.MSE
   CASE 4: CardOffs = oSB16.MSE
   CASE 5: CardOffs = oGUS.MSE
   CASE 6: CardOffs = oPAS.MSE
END SELECT

SELECT CASE ConfigData.SoundQuality
   CASE 0: Ov = 8
   CASE 1: Ov = 16
   CASE 2: Ov = 22
   CASE 3: Ov = 45
END SELECT

Crap = LoadMSE("SPACEWRZ.DAT", CardOffs - 1, Ov, 4096, ConfigData.SoundCardAddr, ConfigData.SoundCardIRQ, ConfigData.SoundCardDMA)
IF Crap THEN

	SELECT CASE Crap
		CASE 1: PRINT "Failed to autodetect sound card address."
		CASE 2: PRINT "Failed to autodetect sound card IRQ."
		CASE 3: PRINT "Failed to autodetect sound card DMA."
		CASE 4: PRINT "Specified DMA channel is not supported."
		CASE 6: PRINT "The sound card is not responding"
		CASE 7: PRINT "Memory control blocks are destroyed"
		CASE 8: PRINT "Insufficient memory for the mixing buffers"
		CASE 9: PRINT "Insufficient memory for the MSE file"
		CASE 10: PRINT MSE$ + " might be missing or corrupt"
		CASE 11: PRINT "Failed to load " + MSE$
		CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS sound cards)"
		CASE ELSE: PRINT "Unknown error:" + STR$(Crap)
	END SELECT
	END

END IF

END SUB


'===========================================================================\
SUB DoBullets

FOR B = 1 TO 100
	IF Bullet(B).Active THEN

		Bullet(B).x = Bullet(B).x + Bullet(B).xMove
		Bullet(B).y = Bullet(B).y + Bullet(B).yMove

		RenderObject Bullet(B).x, Bullet(B).y, Bullet(B).Angle, 100, BulletV(), BulletT()
      IF Bullet(B).Active < 32 THEN         
         RenderObjectGamma Bullet(B).x, Bullet(B).y, Bullet(B).Angle, 100, -((Bullet(B).Active \ 2) - 16), BulletV(), BulletT()
      ELSE
         RenderObject Bullet(B).x, Bullet(B).y, Bullet(B).Angle, 100, BulletV(), BulletT()         
      END IF
		Bullet(B).Active = Bullet(B).Active - 1

		' Collision detection
		FOR P = 1 TO NumPlayers
			IF Player(P).Dead = 0 AND Bullet(B).Active THEN
				IF InBox(CINT(Bullet(B).x), CINT(Bullet(B).y), Player(P).x - 60, Player(P).y - 60, Player(P).x + 60, Player(P).y + 60) AND Bullet(B).Owner <> P THEN
					Bullet(B).Active = 0
					FOR A = 1 TO 20
                  PutParticle Bullet(B).x, Bullet(B).y, 0, 0, (RND * 3), (RND * 360), 140 - (RND * 70), 31
					NEXT A
					Player(P).HitsTaken = Player(P).HitsTaken + 1
					Player(P).HitBy = Bullet(B).Owner
					IF SOUNDON THEN
						Freq = 11025 + (INT(RND * 1000) - 500)
						PlaySample 5 + (P - 1), 16, CLNG(Freq), 64, 8
					END IF
				END IF
			END IF
		NEXT P

	END IF
NEXT B

END SUB


'===========================================================================\
SUB DoMissiles

FOR B = 1 TO UBOUND(Missile)

	IF Missile(B).Active THEN

		Missile(B).x = Missile(B).x + Missile(B).xMove
		Missile(B).y = Missile(B).y + Missile(B).yMove

		SELECT CASE Missile(B).MType
			CASE 0 ' Homing

				IF Missile(B).Active < 70 THEN
					Missile(B).xMove = Missile(B).xMove * .94
					Missile(B).yMove = Missile(B).yMove * .94
				END IF

				IF Missile(B).Active >= 70 THEN
					IF Player(Missile(B).Target).Dead = 0 THEN Missile(B).Angle = FindAngle(Missile(B).x, Missile(B).y, Player(Missile(B).Target).x, Player(Missile(B).Target).y)
					Missile(B).xMove = Missile(B).xMove + .4 * SIN(Missile(B).Angle * ROTPI)
					Missile(B).yMove = Missile(B).yMove - .4 * COS(Missile(B).Angle * ROTPI)
					PutParticle Missile(B).x - (24 * SIN(Missile(B).Angle * ROTPI)), Missile(B).y + (24 * COS(Missile(B).Angle * ROTPI)), Missile(B).xMove, Missile(B).yMove, (RND * 5), (Missile(B).Angle + 180) + ((RND * 41) - 20), 70, 111
				END IF

				IF Missile(B).Active < 560 THEN
					Missile(B).Active = Missile(B).Active + 1
				ELSE
					ParticlizeObject Missile(B).x, Missile(B).y, Missile(B).xMove, Missile(B).yMove, 4, Missile(B).Angle, 140 - (RND * 70), MissileV(), MissileT()
					FOR Pa = 1 TO 40
                  PutParticle Missile(B).x - (24 * SIN(Missile(B).Angle * ROTPI)), Missile(B).y + (24 * COS(Missile(B).Angle * ROTPI)), Missile(B).xMove, Missile(B).yMove, (RND * 5), (RND * 360), 70, 31
					NEXT Pa
					Missile(B).Active = 0
				END IF

				IF Missile(B).Active = 69 AND SOUNDON THEN
               ChanNum = 5 + (Missile(B).Owner - 1)
					PlaySample ChanNum, 13, 11025, 64, 8
				END IF

				RenderObject Missile(B).x, Missile(B).y, Missile(B).Angle, 100, MissileV(), MissileT()

			CASE 1 ' Power

				IF Missile(B).Active = 1 THEN
					IF SoundOn THEN
                  ChanNum = 5 + (Missile(B).Owner - 1)
						PlaySample ChanNum, 13, 11025, 64, 8
					END IF
            END IF

            IF Missile(B).Active < 280 THEN
               Missile(B).Active = Missile(B).Active + 1
            ELSE
               ParticlizeObject Missile(B).x, Missile(B).y, Missile(B).xMove, Missile(B).yMove, 4, Missile(B).Angle, 140 - (RND * 70), PMissileV(), PMissileT()
               FOR Pa = 1 TO 40
                  PutParticle Missile(B).x - (24 * SIN(Missile(B).Angle * ROTPI)), Missile(B).y + (24 * COS(Missile(B).Angle * ROTPI)), Missile(B).xMove, Missile(B).yMove, (RND * 5), (RND * 360), 70, 31
               NEXT Pa
               Missile(B).Active = 0
            END IF

				Missile(B).xMove = Missile(B).xMove + .4 * SIN(Missile(B).Angle * ROTPI)
				Missile(B).yMove = Missile(B).yMove - .4 * COS(Missile(B).Angle * ROTPI)
				PutParticle Missile(B).x - (24 * SIN(Missile(B).Angle * ROTPI)), Missile(B).y + (24 * COS(Missile(B).Angle * ROTPI)), Missile(B).xMove, Missile(B).yMove, (RND * 5), (Missile(B).Angle + 180) + ((RND * 41) - 20), 70, 111

				RenderObject Missile(B).x, Missile(B).y, Missile(B).Angle, 100, PMissileV(), PMissileT()

		END SELECT

		' Collision detection
		FOR P = 1 TO NumPlayers
         IF Missile(B).Owner <> P AND Player(P).Dead = 0 THEN
				IF InBox(CINT(Missile(B).x), CINT(Missile(B).y), CINT(Player(P).x - 60), CINT(Player(P).y - 60), CINT(Player(P).x + 60), CINT(Player(P).y + 60)) THEN
					IF SOUNDON THEN
						ChanNum = 5 + (P - 1)
						PlaySample ChanNum, 12, 11025, 64, 8
					END IF

					SELECT CASE Missile(B).MType
						CASE 0: ParticlizeObject Missile(B).x, Missile(B).y, 0, 0, 4, Missile(B).Angle, 140 - (RND * 70), MissileV(), MissileT()
						CASE 1: ParticlizeObject Missile(B).x, Missile(B).y, 0, 0, 4, Missile(B).Angle, 140 - (RND * 70), PMissileV(), PMissileT()
					END SELECT

					FOR Pa = 1 TO 40
                  PutParticle Missile(B).x - (24 * SIN(Missile(B).Angle * ROTPI)), Missile(B).y + (24 * COS(Missile(B).Angle * ROTPI)), 0, 0, (RND * 5), (RND * 360), 70, 31
					NEXT Pa

					SELECT CASE Missile(B).MType
						CASE 0: Player(P).HitsTaken = Player(P).HitsTaken + 5
						CASE 1: Player(P).HitsTaken = Player(P).HitsTaken + 10
					END SELECT
					Player(P).HitBy = Missile(B).Owner

					Missile(B).Active = 0
				END IF
			END IF
		NEXT P

	END IF

NEXT B

END SUB
