/*
 * This file is part of the Zmiy project
 * Copyright (C) 2013 Mateusz Viste
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>  /* rand() */
#include "levels.h"


void PutItem(struct gamestruct *game, int itemnum) {
  int x, y;
  for (;;) {
    x = rand() % game->playfieldwidth;
    y = rand() % game->playfieldheight;
    y += game->playfieldvoffset;
    if (((game->playfield[x][y] & BLOCK_TYPE) == BLOCK_EMPTY) && ((game->playfield[x][y] & BLOCK_VALUE) == 0)) break;
  }
  game->playfield[x][y] = (BLOCK_REFRESH_FLAG | BLOCK_EMPTY) + itemnum;
}


void LoadLevel(struct gamestruct *game, int lev) {
  int x, y, z, t;
  game->snakeposx = 4;
  game->snakeposy = 4;
  game->snakelen = 6;
  game->level = lev;
  game->playfieldwidth = 80;
  game->playfieldheight = 49;
  game->playfieldvoffset = 1;

  /* Normalize the level to be in the range 1..9 */
  lev %= 10;
  if (lev == 0) lev = 1;

  /* clear out the entire field */
  for (y = game->playfieldvoffset; y < game->playfieldheight + game->playfieldvoffset; y++) {
    for (x = 0 ; x < game->playfieldwidth; x++) {
      game->playfield[x][y] = BLOCK_EMPTY;
    }
  }

  /* draw borders around the playfield */
  for (x = 0; x < 80; x++) {
    game->playfield[x][1] = BLOCK_WALL;
    game->playfield[x][49] = BLOCK_WALL;
  }
  for (y = 0; y < 50; y++) {
    game->playfield[0][y] = BLOCK_WALL;
    game->playfield[79][y] = BLOCK_WALL;
  }


  switch (lev) {
    case 1: /* LEVEL 1 */
      break;
    case 2: /* LEVEL 2 */
      for (x = 20; x < 60; x++) game->playfield[x][23] = BLOCK_WALL;
      break;
    case 3: /* LEVEL 3 */
      for (y = 0; y < 50; y += 3) game->playfield[39][y] = BLOCK_WALL;
      break;
    case 4: /* LEVEL 4 */
      for (x = 61; x < 69; x++) {
        game->playfield[x][1] = BLOCK_EMPTY;
        game->playfield[x][49] = BLOCK_EMPTY;
      }
      game->playfield[60][2] = BLOCK_WALL;
      game->playfield[69][2] = BLOCK_WALL;
      game->playfield[60][48] = BLOCK_WALL;
      game->playfield[69][48] = BLOCK_WALL;
      for (x = 0; x < 55; x++) {
        game->playfield[x][16] = BLOCK_WALL;
      }
      for (x = 25; x < 80; x++) {
        game->playfield[x][33] = BLOCK_WALL;
      }
      break;
    case 5: /* LEVEL 5 */
      for (x = 25; x < 55; x++) {
        game->playfield[x][10] = BLOCK_WALL;
        game->playfield[x][40] = BLOCK_WALL;
      }
      for (y = 12; y < 39; y++) {
        game->playfield[23][y] = BLOCK_WALL;
        game->playfield[56][y] = BLOCK_WALL;
      }
      break;
    case 6: /* LEVEL 6 */
      x = 20;
      y = 7;
      z = 40; /* how big our snail starts */
      t = 0; /* the type of line to draw */
      for (; z > 3; z -= 3) {
        if (t == 0) {
            int t1 = x + z;
            for (; x < t1; x++) {
              game->playfield[x][y] = BLOCK_WALL;
            }
          } else if (t == 1) {
            int t1 = y + z;
            for (; y < t1; y++) {
              game->playfield[x][y] = BLOCK_WALL;
            }
          } else if (t == 2) {
            int t1 = x - z;
            for (; x > t1; x--) {
              game->playfield[x][y] = BLOCK_WALL;
            }
          } else if (t == 3) {
            int t1 = y - z;
            for (; y > t1; y--) {
              game->playfield[x][y] = BLOCK_WALL;
            }
        }
        if (t < 3) t += 1; else t = 0;
      }
      break;
    case 7: /* LEVEL 7 */
      for (x = 14; x < 79; x += 13) {
        for (y = 1 + (x % 2); y < 49; y += 2) {
          game->playfield[x][y] = BLOCK_WALL;
        }
      }
      break;
    case 8: /* LEVEL 8 */
      for (x = 1; x < 79; x++) {
        game->playfield[x][24] = BLOCK_WALL;
      }
      for (y = 1; y < 49; y++) {
        game->playfield[40][y] = BLOCK_WALL;
      }
      for (y = 21; y < 24; y++) {
        game->playfield[0][y] = BLOCK_EMPTY;
        game->playfield[79][y] = BLOCK_EMPTY;
      }
      game->playfield[1][20] = BLOCK_WALL;
      game->playfield[78][20] = BLOCK_WALL;
      for (x = 41; x < 44; x++) {
        game->playfield[x][1] = BLOCK_EMPTY;
        game->playfield[x][49] = BLOCK_EMPTY;
      }
      game->playfield[44][2] = BLOCK_WALL;
      game->playfield[44][48] = BLOCK_WALL;
      for (y = 25; y < 28; y++) {
        game->playfield[40][y] = BLOCK_EMPTY;
        game->playfield[40][y] = BLOCK_EMPTY;
      }
      game->playfield[39][28] = BLOCK_WALL;
      game->playfield[41][28] = BLOCK_WALL;
      break;
    case 9: /* LEVEL 9 */
      for (z = 55; z > 6; z -= 15) {
        for (x = 40 - (z / 2); x < 40 + (z / 2); x++) {
          game->playfield[x][25 - (z / 3)] = BLOCK_WALL;
          game->playfield[x][25 + (z / 3)] = BLOCK_WALL;
        }
        for (y = 25 - (z / 3); y <= 25 + (z / 3); y++) {
          game->playfield[40 - (z / 2)][y] = BLOCK_WALL;
          game->playfield[40 + (z / 2)][y] = BLOCK_WALL;
        }
      }
      for (y = 2; y < 45; y++) {
        game->playfield[15 + y][y] = BLOCK_EMPTY;
        if (y > 25) {
            game->playfield[14 + y][y] = BLOCK_EMPTY;
          } else {
            game->playfield[16 + y][y] = BLOCK_EMPTY;
        }
      }
      break;
  }

  /* mark all fields as 'to be refreshed' */
  for (y = game->playfieldvoffset; y < game->playfieldheight + game->playfieldvoffset; y++) {
    for (x = 0 ; x < game->playfieldwidth; x++) {
      game->playfield[x][y] |= BLOCK_REFRESH_FLAG;
    }
  }

  /* put the first item onscreen */
  PutItem(game, 1);

  game->playfield[game->snakeposx][game->snakeposy] = (BLOCK_SNAKE1 + 1) | BLOCK_REFRESH_FLAG;
  game->snakedirection = SNAKEDIR_RIGHT;
}
