Program Herding;
{Elephant Herding
Herd Elephants into the cage. Two player game on one PC.

Programmed by Sebastiaan Jansen using TP7
http://thandor.net}
Uses crt, dos;

Const
 Gametime = 0.80;

Type
 PlayerType = Record
 x, y : ShortInt;
 end;

 ElephantType = Record
 x, y : ShortInt;
 InCage : Boolean;
 end;

var
 Quit : Boolean;
 Player : Array [0..1] of PlayerType;
 Elephant : Array [0..19] of ElephantType;
 Start, Endtime : real;
 i : integer;
 MaxElephants : ShortInt;

Function timer:real;
var
 Hour, Minute, Second, Sec100 : word;
begin
 gettime(hour,minute,second,sec100);
 timer:=(hour*3600.0+minute*60.0+second+sec100/100);
end;

Procedure HideCursor; Assembler;
  Asm
    mov   ax, 0100h
    mov   cx, 2607h
    int   10h
  end;  {HideCursor}

Procedure ShowCursor; Assembler;
  Asm
    mov   ax, 0100h
    mov   cx, 0506h
    int   10h
  end;  {ShowCursor}

{From Timo Salmi FAQ}
function ReadASCII (column, row : byte) : char;
 var regs : registers;
  videocolumns : byte;
  videobase : word;
  offset : word;
 begin
  { Get the video base address }
  FillChar (regs, SizeOf(regs), 0);
  regs.ah := $0F;  Intr ($10, regs);
  if regs.al = 7 then videobase := $B000 else videobase := $B800;
  { Get the screen width }
  FillChar (regs, SizeOf(regs), 0);
  regs.ah := $0F;
  Intr ($10, regs);
  videocolumns := regs.ah;
  { Get the character }
  offset := (((row-1)*videocolumns)+(column-1))*2;
  ReadASCII := chr(mem[videobase:offset]);
 end;

Function CheckMovement(x,y : ShortInt) : Boolean; {if player/elephant bumps into a certain character it should be blocked}
begin
 CheckMovement:=TRUE;
 if (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or (ReadASCII(x,y) = '') or
    (ReadASCII(x,y) = '') then CheckMovement:=FALSE;
end;

Function ElephantLeft(Number : ShortInt) : Boolean; {Move elephant to the left}
begin
 ElephantLeft:=FALSE;
 if (CheckMovement(Elephant[Number].x-1, Elephant[Number].y) = TRUE) and (Elephant[Number].x > 12) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].x:=Elephant[Number].x-1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantLeft:=TRUE;
  end;
end;

Function ElephantRight(Number : ShortInt) : Boolean;
begin
 ElephantRight:=FALSE;
 if (CheckMovement(Elephant[Number].x+1, Elephant[Number].y) = TRUE) and (Elephant[Number].x < 68) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].x:=Elephant[Number].x+1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantRight:=TRUE;
  end;
end;

Function ElephantUp(Number : ShortInt) : Boolean;
begin
 ElephantUp:=FALSE;
 if (CheckMovement(Elephant[Number].x, Elephant[Number].y-1) = TRUE) and (Elephant[Number].y > 4) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].y:=Elephant[Number].y-1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantUp:=TRUE;
  end;
end;

Function ElephantDown(Number : ShortInt) : Boolean;
begin
 ElephantDown:=FALSE;
 if (CheckMovement(Elephant[Number].x, Elephant[Number].y+1) = TRUE) and (Elephant[Number].y < 18) then
  begin
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write(' ');
   Elephant[Number].y:=Elephant[Number].y+1;
   GotoXY(Elephant[Number].x, Elephant[Number].y);
   Write('');
   ElephantDown:=TRUE;
  end;
end;

Procedure ElephantMovement; {Calculates Elephant movement}
var
 i : ShortInt;
 Distance0, Distance1, ClosestPlayer : ShortInt;
 ElephantMoved : Boolean;
begin
 TextColor(7);
 for i:=0 to MaxElephants do
  begin
  ElephantMoved:=FALSE; {Keep track wether Elephant moved or not}
   {Determine which player is closest to Elephant for x-axis}
   if (Player[0].x > Elephant[i].x) then
      Distance0:=Player[0].x - Elephant[i].x else
      Distance0:=Elephant[i].x - Player[0].x;
  if (Player[1].x > Elephant[i].x) then
      Distance1:=Player[1].x - Elephant[i].x else
      Distance1:=Elephant[i].x - Player[1].x;
  if Distance1 > Distance0 then ClosestPlayer:=0 else ClosestPlayer:=1;

   if (Elephant[i].x < Player[ClosestPlayer].x) then
    begin
     if (ElephantLeft(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if (Elephant[i].x > Player[ClosestPlayer].x) then
    begin
     if (ElephantRight(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   {Determine which player is closest to Elephant for y-axis}
   if (Player[0].y > Elephant[i].y) then
      Distance0:=Player[0].y - Elephant[i].y else
      Distance0:=Elephant[i].y - Player[0].y;
   if (Player[1].y > Elephant[i].y) then
      Distance1:=Player[1].y - Elephant[i].y else
      Distance1:=Elephant[i].y - Player[1].y;
   if Distance1 > Distance0 then ClosestPlayer:=0 else ClosestPlayer:=1;

   if (Elephant[i].y < Player[ClosestPlayer].y) then
    begin
     if (ElephantUp(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if (Elephant[i].y > Player[ClosestPlayer].y) then
    begin
     if (ElephantDown(i) = TRUE) then ElephantMoved:=TRUE;
    end;

   if ElephantMoved=FALSE then {Elephant didn't move; try random panic move to get un-stuck}
    begin
     Distance0:=Random(4);
     Case Distance0 of
      0: ElephantLeft(i);
      1: ElephantRight(i);
      2: ElephantUp(i);
      3: ElephantDown(i);
     end;
    end;

  end;
end;

Procedure MoveUp(Number : ShortInt); {Move player up}
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x, Player[Number].y-1) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].y:=Player[Number].y-1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
  end;
end;

Procedure MoveLeft(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x-1, Player[Number].y) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].x:=Player[Number].x-1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
  end;
end;

Procedure MoveRight(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x+1, Player[Number].y) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].x:=Player[Number].x+1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
  end;
end;

Procedure MoveDown(Number : ShortInt);
begin
 if Number=0 then TextColor(14) else TextColor(15);
 if (CheckMovement(Player[Number].x, Player[Number].y+1) = TRUE) then
  begin
   GotoXY(Player[Number].x, Player[Number].y);
   Write(' ');
   Player[Number].y:=Player[Number].y+1;
   GotoXY(Player[Number].x, Player[Number].y);
   if Number = 0 then Write('') else Write('');
  end;
end;

Procedure ProcessKeys(Key : char); {Read the keys and do the appropriate actions}
begin
 case Key of
  'H': MoveUp(0);
  'K': MoveLeft(0);
  'M': MoveRight(0);
  'P': MoveDown(0);
  'w': MoveUp(1);
  'a': MoveLeft(1);
  'd': MoveRight(1);
  's': MoveDown(1);
  'W': MoveUp(1);
  'A': MoveLeft(1);
  'D': MoveRight(1);
  'S': MoveDown(1);
  'Q': Quit:=TRUE;
  'q': Quit:=TRUE;
  #27: Quit:=TRUE;
  end;
end;

Procedure GenerateElephants; {Generate the Elephants}
var
 Number : ShortInt;
begin
  for i:=0 to MaxElephants do
 begin
  Number:=Random(3);
  Elephant[i].x:=i+36+Number;
  Elephant[i].y:=13+Number;
  Elephant[i].InCage:=FALSE;
  TextColor(7);
  GotoXY(Elephant[i].x, Elephant[i].y);
  Write('');
 end;
end;

Procedure DefinePlayers; {Place the players onto the screen}
begin
 {Clear players}
 GotoXY(Player[0].x, Player[0].y);
 Write(' ');
 GotoXY(Player[1].x, Player[1].y);
 Write(' ');

 {Define Players}
 Player[0].x:=13;
 Player[0].y:=4;
 Player[1].x:=67;
 Player[1].y:=18;
 TextColor(14);
 GotoXY(Player[0].x, Player[0].y);
 Write('');
 TextColor(15);
 GotoXY(Player[1].x, Player[1].y);
 Write('');
end;

Procedure NextLevel; {Play a sound, empty the cage and go to the next level}
begin
 {Play a sound!}
 Sound(500);
 Delay(100);
 Sound(700);
 Delay(150);
 Sound(600);
 Delay(200);
 NoSound;
 {Clear the cage}
 GotoXY(38,9);
 Write('     ');
 GotoXY(38,10);
 Write('     ');
 GotoXY(38,11);
 Write('     ');
 MaxElephants:=MaxElephants+1;
 GenerateElephants;
 DefinePlayers;
end;

Procedure CheckCage; {Check if the elephants are within the cage and move on to next level if they are}
var
 i : ShortInt;
 AllInCage : Boolean;
begin
 AllInCage:=TRUE;
 for i:=0 to MaxElephants do
  begin
   Elephant[i].InCage:=FALSE;
   if ((Elephant[i].x > 37) and (Elephant[i].x < 43)) and ((Elephant[i].y > 9) and (Elephant[i].y < 12)) then
    begin
     Elephant[i].InCage:=TRUE;
    end else AllInCage:=FALSE;
  end;

 if AllInCage=TRUE then NextLevel;
end;

begin
{Init}
Randomize;
HideCursor; {Hide the cursor}
Quit:=FALSE;
ClrScr;
DefinePlayers;
MaxElephants:=0; {First level will only have one elephant, this value will increase when advancing through levels}
GenerateElephants;

{Draw map border}
TextColor(8);
for i:=10 to 70 do
 begin
  GotoXY(i,2);
  Write('');
  GotoXY(i,20);
  Write('');
 end;

for i:=3 to 19 do
 begin
  GotoXY(10,i);
  Write('');
  GotoXY(70,i);
  Write('');
 end;
 
{Draw Cage}
TextColor(6);
GotoXY(37,9);
Write('');
GotoXY(37,10);
Write('');
GotoXY(37,11);
Write('');
GotoXY(37,12);
Write('');
GotoXY(38,12);
Write('');
GotoXY(39,12);
Write('');
GotoXY(40,12);
Write('');
GotoXY(41,12);
Write('');
GotoXY(42,12);
Write('');
GotoXY(43,12);
Write('');
GotoXY(43,10);
Write('');
GotoXY(43,11);
Write('');
GotoXY(43,9);
Write('');

repeat {The repeat clausule which contains the running game}
 if KeyPressed then ProcessKeys(Readkey);

 if timer >= endtime then
  begin
   start:=timer;
   start:=timer;
   endtime:=start+gametime;
   ElephantMovement;
   CheckCage;
   if MaxElephants=19 then Quit:=TRUE; {Exit}
  end;

until Quit=TRUE;
ClrScr;
TextColor(7);
WriteLn('Thanks for playing Elephant Herding!');
ShowCursor;
end.